/*----------------------------------------------------------
   Appends a build level to IMPORTS.EXE and INITORDER.EXE

           Author:       Peter Moylan
           Last revised: 2 September 2014

   Usage:
           bldlvl ver

           where ver is the version string

------------------------------------------------------------*/

parse arg ver
projHost = "PJM3"
timestamp = LEFT(DATE() TIME(),25)LEFT(projHost,10)
signature0 = "@#Peter Moylan:"ver"#@##1## "timestamp"::EN:AU:::@@"
outfile = "level.txt"

'@DEL 'outfile' 2> nul'
CALL LINEOUT outfile, signature0||"Lists the modules of a Modula-2 program"
CALL STREAM outfile,'C','CLOSE'
'@copy imports.exe /B + level.txt imports.exe /B > nul'
'@DEL 'outfile' 2> nul'

CALL LINEOUT outfile, signature0||"Lists the initialisation order of the modules of a Modula-2 program"
CALL STREAM outfile,'C','CLOSE'
'@copy initorder.exe /B + level.txt initorder.exe /B > nul'
'@DEL 'outfile' 2> nul'

exit

