/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         active_list_Click
*/
active_list_Click:
    call VRSet "Halt", "Enabled", 1
return

/*:VRX         DeleteThread
*/
DeleteThread:
    tid = arg( 1 )
    index = VRMethod( "active_list", "FindString", tid )
    if index \= 0 then do
        call VRMethod "active_list", "Delete", index
    end
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Halt_Click
*/
Halt_Click:
    id = VRGet( "active_list", "SelectedString" )
    if id = "" then return

    ok = 0

    if( VRMethod( "Application", "GetThreadID" ) \= id )then do
        ok = VRMethod( "Application", "HaltThread", id )
        call DeleteThread id
    end

    if ok = 0 then do
        call VRMessage "Halt",,
             "Thread" id "cannot be halted.",,
             "Halt thread"
    end

return
/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    call UpdateThreadList
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ShowMessage
*/
ShowMessage:
    text = VRInfo( "message" )
    call VRMethod "message_list", "Addstring", text
    call UpdateThreadList
return

/*:VRX         Spawn_Click
*/
Spawn_Click:
    id = VRMethod( "Application", "GetThreadID" )
    call VRMethod "Application", "StartThread", "window2", id
    if result = 0 then do
        call VRMessage VRWindow(),,
             "Could not spawn thread",,
             "Spawn Error"
    end
    call UpdateThreadList
return

/*:VRX         UpdateThreadList
*/
UpdateThreadList:
    call VRMethod "Application", "ListThreads", "threads."
    call VRMethod "active_list", "Clear"
    call VRMethod "active_list", "AddStringList", "threads."
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

