/*
 * tclPort.h --
 *
 *	This header file handles porting issues that occur because
 *	of differences between systems.  It reads in platform specific
 *	portability files.
 *
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 * Copyright (c) 1996-1998 Illya Vaes
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) tclPort.h 1.15 96/02/07 17:24:21
 */

#ifndef _TCLPORT
#define _TCLPORT

#if defined(__WIN32__) || defined(_WIN32)
#   include "../win/tclWinPort.h"
#else
#   if defined(MAC_TCL)
#	include "tclMacPort.h"
#   else
#       if (defined(__OS2__) || defined(__EMX__))
#           include "../os2/tclOS2Port.h"
#       else
#           include "../unix/tclUnixPort.h"
#       endif
#   endif
#endif

#endif /* _TCLPORT */
