/* 
 * tkOS2Dll.c --
 *
 *	This file contains a stub dll entry point.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc.
 * Copyright (c) 1996-2000 Illya Vaes
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "tkPort.h"
#include "tkOS2Int.h"

int _CRT_init(void);
void _CRT_term(void);

/* Save the Tk DLL handle for TkPerl */
unsigned long dllHandle = (unsigned long) NULLHANDLE;


/*
 *----------------------------------------------------------------------
 *
 * _DLL_InitTerm --
 *
 *	DLL entry point.
 *
 * Results:
 *	TRUE on sucess, FALSE on failure.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

unsigned long _DLL_InitTerm(unsigned long modHandle, unsigned long flag)
{
    /*
     * If we are attaching to the DLL from a new process, tell Tk about
     * the handle to use. If we are detaching then clean up any
     * data structures related to this DLL.
     */

    switch (flag) {
    case 0: {    /* INIT */
        PPIB pibPtr;
        PTIB tibPtr;

        /*
         * Warp ourselves to PM; only of interest for CLI that really want
         * to use PM services etc. and using the Tk DLL.
         */
        rc = DosGetInfoBlocks(&tibPtr, &pibPtr);
        pibPtr->pib_ultype = 3;

        if (TkOS2InitPM() == (HAB)NULLHANDLE) {
#ifdef VERBOSE
            FILE *errFile = fopen("tk80dll.err", "w");
            if (errFile != NULL) {
                fprintf(errFile, "TkOS2InitPM returns NULLHANDLE\n");
            }
#endif
            return FALSE;
        }
        /* Save handle */
        dllHandle = modHandle;
        TkOS2XInit(dllHandle);
        return TRUE;
    }

    case 1:     /* TERM */
        TkOS2XCleanup(dllHandle);
        TkOS2ExitPM(dllHandle);
        /* Invalidate handle */
        dllHandle = (unsigned long)NULLHANDLE;
        return TRUE;
    }

    return FALSE;
}
