#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/examples/unions/RCS/server.py,v $
# Version:      @(#)$RCSfile: server.py,v $ $Revision: 1.8 $
#
#############################################################################
""" Example server using IDL unions. """


# Standard/built-in modules.
import sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Stubs and skeletons generated by 'fnidl'.
import Unions, Unions_skel


class Server(Unions_skel.test_skel):
    """ Implementation of the 'test' interface. """

    # 'in' parameters.
    def in_a(self, a):
	print a
	return

    def in_b(self, b):
	print b
	return

    def in_c(self, c):
	print c
	return

    def in_d(self, d):
	print d
	return

    def in_e(self, e):
	print e
	return

    def in_f(self, f):
	print f
	return

    # 'inout' parameters.
    def inout_a(self, a):
	print (a.d, a.v)
	if a.d == 1:
	    a.v = a.v + 1

	else:
	    a.v = "Hello to you too!"

	return a

    def inout_b(self, b):
	print (b.d, b.v)
	if b.d == 1:
	    b.v = b.v + 1

	else:
	    b.v = "Hello to you too!"

	return b

    def inout_c(self, c):
	print (c.d, c.v)
	if c.d == 1:
	    c.v = c.v + 1

	else:
	    c.v = "Hello to you too!"

	return c

    def inout_d(self, d):
	print 'inout_d:', d, d.d, d.v
	print (d.d, d.v)
	if d.d == Unions.red:
	    d.v = d.v + 1

	elif d.d == Unions.green:
	    d.v = d.v + 1.0

	elif d.d == Unions.blue:
	    d.v = d.v + " ... and there's more"

	print 'inout_d:', d, d.d, d.v
	return d

    def inout_e(self, e):
	print (e.d, e.v)
	if e.d == Unions.red:
	    e.v = e.v + 1

	else:
	    e.v = "Whatever I put here should disappear!"

	return e

    def inout_f(self, f):
	print (f.d, f.v)
	if f.d == Unions.red:
	    f.v = f.v + 1

	else:
	    f.v = "But this should get back as the default case!"

	return f

    # 'out' parameters.
    def out_a(self):
	return Unions.A(0, 'How are you?')

    def out_b(self):
	return Unions.B(0, 'This value should be None in the client!')

    def out_c(self):
	return Unions.C(0, 'This one should get through as the default!')

    def out_d(self):
	return Unions.D(Unions.blue, 'How are you?')

    def out_e(self):
	return Unions.E(Unions.blue, 'This value should be None in the client')

    def out_f(self):
	return Unions.F(Unions.blue, 'This one should get thru as the default')

    # Return values.
    def return_a(self):
	return Unions.A(0, 'Is anybody out there?')

    def return_b(self):
	return Unions.B(0, 'This value should be None in the client!')

    def return_c(self):
	return Unions.C(0, 'This one should get through as the default!')

    def return_d(self):
	return Unions.D(Unions.blue, 'Is anybody out there?')

    def return_e(self):
	return Unions.E(Unions.blue, 'This value should be None in the client')

    def return_f(self):
	return Unions.F(Unions.blue, 'This one should get thru as the default')
    

def main(argv):
    """ Do it! """
    
    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(sys.argv, BOA.BOA_ID)

    print 'Creating object reference...'

    # Create an object reference ('fred' is the object key).
    obj = boa.create('fred', Server._FNORB_ID)

    print 'Creating implementation...'

    # Create an instance of the implementation class.
    impl = Server()

    print 'Activating the implementation...'

    # Activate the implementation (ie. connect the generated object reference
    # to the implementation).  Note that the implementation will not receive
    # any operation requests until we start the event loop (see below).
    boa.obj_is_ready(obj, impl)

    # Write the stringified object reference to a file (this is just a 'cheap
    # and cheerful' way of making the object reference available to the
    # client!).
    open('server.ref', 'w').write(orb.object_to_string(obj))

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    print 'Server finished!'

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
