/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal'
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
#append SHARED\OBJECT.VRS
*/
return
/*:VRX         CN_ObjList_ContextMenu
*/
CN_ObjList_ContextMenu: procedure expose Globals.
    call VRMethod "M_Selected", "Popup"
return

/*:VRX         CN_ObjList_Delete
*/
/*
    call CN_ObjList_Delete

    - Delete objects corresponding to "source" records.
    - The delete dialog allows the use to prune the delete list contained
    in "records."
*/
CN_ObjList_Delete: procedure expose Globals.
    call GetSourceRecords "CN_ObjList"
    if records.0 > 0 then do
        call VRLoadSecondary "SW_Delete", "W"
        do i = 1 to records.0
            objectNumber = VRMethod( "CN_ObjList", "GetFieldData", records.i, "Object" )
            call ObjectCloseAll "CN_ObjList", records.i
            keys.0 = 1
            keys.1 = objectNumber
            call ObjectRefresh "ObjList", "Delete" objectNumber
            call ObjListDeleteObject objectNumber
        end
        keys.0 = 0
    end
return



/*:VRX         CN_ObjList_DoubleClick
*/
CN_ObjList_DoubleClick: procedure expose Globals.
    record = VRInfo( "Record" )
    default = VRGet( "MI_Selected_Open", "DefaultItem" )
    parse VAR default "MI_Selected_Open_" view
    call ObjectOpen "CN_ObjList", record, "SW_" || view
return

/*:VRX         CN_ObjList_DragDiscard
*/
CN_ObjList_DragDiscard:  procedure expose Globals.
    call CN_ObjList_Delete
return

/*:VRX         CN_ObjList_DragDrop
*/
CN_ObjList_DragDrop:  procedure expose Globals.
    object = VRInfo( "SourceObject" )
    objName = VRGet( object, Name )
    if( objName = "VS_Templates" ) then do
        index = VRInfo( "SourceIndex" )
        call VRMethod "VS_Templates", "GetAttributes", "Values", "values."
        icon = values.index
        objectNumber = ObjListNewObject( icon, "New Object", "Description of new object" )

        left = VRInfo( "Left" )
        bottom = VRInfo( "Bottom" )
        keys.0 = 1
        keys.1 = objectNumber
        call ObjectRefresh "ObjList", "New" objectNumber left bottom
    end
return

/*:VRX         CN_ObjList_EndEdit
*/
CN_ObjList_EndEdit: procedure expose Globals.
    cancelled = VRInfo( "Cancelled" )
    if cancelled then signal CN_ObjList_EndEdit_Done

    /* Update object.  Only the caption and description fields
       can be changed by direct editting.
    */
    record = VRInfo( "Record" )
    if record = "" then signal CN_ObjList_EndEdit_Done

    objectNumber = VRMethod( "CN_ObjList", "GetFieldData", record, "Object" )
    index = ObjListFind( objectNumber )

    field = VRInfo( "Field" )
    if field = "" then do
        name = VRMethod( "CN_ObjList", "GetRecordAttr", record, "Caption" )
    end
    else do
        name = VRMethod( "CN_ObjList", "GetFieldData", record, "Caption" )
    end
    Globals.!ObjList.index.!Name = name
    Globals.!ObjList.index.!Description = VRMethod( "CN_ObjList", "GetFieldData", record, "Description" )

    keys.0 = 1
    keys.1 = objectNumber
    call ObjectRefresh "ObjList", "Change" objectNumber
CN_ObjList_EndEdit_Done:
return

/*:VRX         CN_ObjList_Fini
*/
CN_ObjList_Fini: procedure expose Globals.
    call ObjectListClosed "CN_ObjList"
return


/*:VRX         CN_ObjList_Init
*/
/*  call CN_ObjList_Init

    - Create the fields, register the object list with the
    object manager code, and fill with the initial object list.

    - NOTE: The object number field must be "String" rather
    than "ULong" or the search for key values will fail because
    REXX represents numbers as strings.
*/
CN_ObjList_Init: procedure expose Globals.

/*  Create fields in the container for detail information
*/
    call VRMethod "CN_ObjList", "AddField", "String", "Object", "Object"
    call VRMethod "CN_ObjList", "AddField", "Icon", "Icon", "Icon"
    call VRMethod "CN_ObjList", "AddField", "String", "Caption", "Caption"
    call VRMethod "CN_ObjList", "AddField", "String", "Description", "Description"

/*  The object number field is the key field so it cannot
    be modified.
*/
    call VRMethod "CN_ObjList", "SetFieldAttr", "Object", "ReadOnly", 1

/*  Register the list
    - The key field will be used to determine which views
    are views of the same object.
*/
    keyFields.0 = 1
    keyFields.1 = "Object"
    call ObjectListOpened "ObjList", "CN_ObjList"

/*  Fill the container with the current object list.
*/
    ok = VRMethod( "CN_ObjList", "RemoveRecord", "All" )
    do i = 1 to Globals.!ObjList.0
        numb = Globals.!ObjList.i.!Number
        icon = Globals.!ObjList.i.!Icon
        name = Globals.!ObjList.i.!Name
        desc = Globals.!ObjList.i.!Description
        record = VRMethod( "CN_ObjList", "AddRecord", , "", name, icon )
        ok = VRMethod( "CN_ObjList", "SetFieldData", record,,
            "Object", Format(numb, 2),,
            "Icon", icon,,
            "Caption", name,,
            "Description", desc )
    end
    call VRMethod "CN_ObjList", "Arrange"

return


/*:VRX         CN_ObjList_Refresh
*/
/*
    CN_ObjList_Refresh

    - Action determined by VRInfo( "Type" ):

    "Change" objectNumber               Detail change.

    "Delete" objectNumber               Object deleted.

    "New" objectNumber [left bottom]    New object [drop position].
*/
CN_ObjList_Refresh: procedure expose Globals.

    parse value VRInfo( "Type" ) with type objectNumber left bottom

    ok = VRSet( "CN_ObjList", "Painting", 0 )

    i = ObjListFind( objectNumber )
    icon = Globals.!ObjList.i.!Icon
    name = Globals.!ObjList.i.!Name
    desc = Globals.!ObjList.i.!Description

    select
        when type = "Change" then do
            keys.0 = 1
            keys.1 = objectNumber
            record = ObjectListFindRecord( "CN_ObjList" )
            if record = "" then signal CN_ObjList_RefreshDone

            call VRMethod "CN_ObjList", "SetRecordAttr", record,,
                "Icon", icon,,
                "Caption", name
            call VRMethod "CN_ObjList", "SetFieldData", record,,
                "Object", Format(objectNumber, 2),,
                "Icon", icon,,
                "Caption", name,,
                "Description", desc
        end
        when type = "Delete" then do
            keys.0 = 1
            keys.1 = objectNumber
            record = ObjectListFindRecord( "CN_ObjList" )
            if record = "" then signal CN_ObjList_RefreshDone

            call VRMethod "CN_ObjList", "RemoveRecord", record
        end
        when type = "New" then do
            record = VRMethod( "CN_ObjList", "AddRecord", , "",,
                name, icon, left, bottom )
            call VRMethod "CN_ObjList", "SetFieldData", record,,
                "Object", Format(objectNumber, 2),,
                "Icon", icon,,
                "Caption", name,,
                "Description", desc
        end
    end
CN_ObjList_RefreshDone:
    ok = VRSet( "CN_ObjList", "Painting", 1 )
return

/*:VRX         DDCB_Set_General_Icon_Change
*/
DDCB_Set_General_Icon_Change: procedure expose Globals.
    icon = VRGet( "DDCB_Set_General_Icon", "Value" )
    record = VRGet( VRInfo("Window"), "UserData" )
    call VRMethod "CN_Set_General_Icon", "SetRecordAttr", record, "Icon", icon
return

/*:VRX         Fini
*/
Fini: procedure expose Globals.

    window = VRWindow()

    call VRSet window, "Visible", 0

    call CN_ObjList_Fini

    call ObjListFini

return 0


/*:VRX         GetObjectNumberFromPage
*/
/*
    objectNumber = GetObjectNumberFromPage( page )

    page    - The page (window) of a notebook on a window
            opened as an individual view of an object

    objectNumber - The number of object viewed by the window
*/
GetObjectNumberFromPage: procedure expose Globals.
    parse arg page
    notebook = VRGet( page, "Parent" )
    window = VRGet( notebook, "Parent" )
    call ObjectGetKeys window
return keys.1


/*:VRX         GetSourceRecords
*/
/*
    call GetSourceRecords container
    - Get the records to operate on (source for pop-up or selected for pull-down).
    - Resets the source attribute of the container itself and its records.
    - Returns the list in "records."
*/
GetSourceRecords: procedure expose Globals. records.
    parse arg container
    call VRMethod container, "GetRecordList", "SourceOrSelected", "records." 
    call VRSet container, "Painting", 0, "Source", 0
    call VRMethod container, "SetRecordAttr", "All", "Source", 0
    call VRSet container, "Painting", 1
return


/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Globals.

    window = VRWindow()

    /* Initialize global variables */

    Globals. = ""

    /* No help for this app.  Just point at a standard OS/2 help file. */
    call VRSet window, "HelpFile", VRIniDir() || "\help\hmhelp.hlp"

    /* Initialize the object list */

    call ObjListInit

    /* Display the list */

    call CN_ObjList_Init

    /*  Make the window visible after everything is done */
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

return


/*:VRX         M_Selected_Click
*/
/*
    M_Selected_Click
 
    - Disable items in the "Selected" menu when nothing is enabled.
    - VRInfo( "Source" ) will be either "" or the object under a
    previous context event
    - Uses "SourceOrSelected" as the "Selected" menu is used both as a
    pull down and a pop-up.
*/
M_Selected_Click: procedure expose Globals.
    ok = VRMethod( "CN_ObjList", "GetRecordList", "SourceOrSelected", "reclist." )
    selected = reclist.0 > 0
    ok = VRSet( "MI_Selected_Open", "Enabled", selected )  
    ok = VRSet( "MI_Selected_Clone", "Enabled", selected )  
    ok = VRSet( "MI_Selected_Delete", "Enabled", selected )
return

/*:VRX         MI_Arrange_Click
*/
MI_Arrange_Click:  procedure expose Globals.
    ok = VRMethod( "CN_ObjList", "Arrange" )
return

/*:VRX         MI_Help_General_Click
*/
MI_Help_General_Click: procedure expose Globals.
    call VRMethod VRInfo( "Object" ), "InvokeHelp"
return

/*:VRX         MI_Help_Index_Click
*/
MI_Help_Index_Click: procedure expose Globals.
    call VRMethod VRInfo( "Object" ), "InvokeHelp"
return

/*:VRX         MI_Help_Product_Click
*/
MI_Help_Product_Click: procedure expose Globals.
    call ProdInfo VRWindow()
return

/*:VRX         MI_Help_Using_Click
*/
MI_Help_Using_Click: procedure expose Globals.
    call VRMethod VRInfo( "Object" ), "InvokeHelp"
return

/*:VRX         MI_Selected_Clone_Click
*/
MI_Selected_Clone_Click:  procedure expose Globals.
    call GetSourceRecords "CN_ObjList"
    do i = 1 to records.0
        call VRMethod "CN_ObjList", "GetFieldData", records.i, "fieldData."
        icon = fieldData.2
        name = fieldData.3
        desc = fieldData.4
        objectNumber = ObjListNewObject( icon, name, desc )

        left = VRMethod( "CN_ObjList", "GetRecordAttr", records.i, "Left" )
        bottom = VRMethod( "CN_ObjList", "GetRecordAttr", records.i, "Bottom" )
        keys.0 = 1
        keys.1 = objectNumber
        call ObjectRefresh "ObjList", "New" objectNumber left+100 bottom-100
    end
return

/*:VRX         MI_Selected_Delete_Click
*/
MI_Selected_Delete_Click: procedure expose Globals.
    call CN_ObjList_Delete
return

/*:VRX         MI_Selected_Open_A_Click
*/
MI_Selected_Open_A_Click:  procedure expose Globals.
    call GetSourceRecords "CN_ObjList"
    do i = 1 to records.0
        call ObjectOpen "CN_ObjList", records.i, "SW_A"
    end
return

/*:VRX         MI_Selected_Open_B_Click
*/
MI_Selected_Open_B_Click:  procedure expose Globals.
    call GetSourceRecords "CN_ObjList"
    do i = 1 to records.0
        call ObjectOpen "CN_ObjList", records.i, "SW_B"
    end
return

/*:VRX         MI_Selected_Open_Settings_Click
*/
MI_Selected_Open_Settings_Click:  procedure expose Globals.
    call GetSourceRecords "CN_ObjList"
    do i = 1 to records.0
        call ObjectOpen "CN_ObjList", records.i, "SW_Settings"
    end
return

/*:VRX         MI_Sort_By_X
*/
MI_Sort_By_X:  procedure expose Globals.
    parse arg menuItem, fieldName

    call VRSet "MI_Sort", "DefaultItem", menuItem

    ok = VRSet( "CN_ObjList", "DetailSort", fieldName )
    ok = VRMethod( "CN_ObjList", "SortRecords" )
return

/*:VRX         MI_Sort_Caption_Click
*/
MI_Sort_Caption_Click:  procedure expose Globals.
    call MI_Sort_By_X "MI_Sort_Caption", "Caption" 
return

/*:VRX         MI_Sort_Description_Click
*/
MI_Sort_Description_Click:  procedure expose Globals.

    call MI_Sort_By_X "MI_Sort_Description", "Description" 

return

/*:VRX         MI_Sort_Object_Click
*/
MI_Sort_Object_Click: procedure expose Globals.
    call MI_Sort_By_X "MI_Sort_Object", "Object" 
return

/*:VRX         MI_View_Details_Click
*/
MI_View_Details_Click: procedure expose Globals.
    call VRSet "CN_ObjList", "View", "Detail"
    call VRSet "MI_Arrange", "Enabled", 0
    call VRSet "MI_Sort", "Enabled", 1
    call VRSet "MI_View_Icons", "Enabled", 1
    call VRSet "MI_View_Details", "Enabled", 0
return

/*:VRX         MI_View_Icons_Click
*/
MI_View_Icons_Click:  procedure expose Globals.
    call VRSet "CN_ObjList", "View", "Icon"
    call VRSet "MI_Sort", "Enabled", 0
    call VRSet "MI_Arrange", "Enabled", 1
    call VRSet "MI_View_Icons", "Enabled", 0
    call VRSet "MI_View_Details", "Enabled", 1
return

/*:VRX         MI_Windows_Templates_Click
*/
MI_Windows_Templates_Click:  procedure expose Globals.
    if( VRIsValidObject( Globals.!palette ) ) then do
        ok = VRSet( Globals.!palette, "WindowState", "Normal" )
        ok = VRMethod( Globals.!palette, "Activate" )
    end
    else do
        Globals.!palette = VRLoadSecondary( "SW_Templates" )
    end
return

/*:VRX         MLE_Set_General_Name_Change
*/
MLE_Set_General_Name_Change:  procedure expose Globals.
    name = VRGet( "MLE_Set_General_Name", "Value" )
    record = VRGet( VRInfo("Window"), "UserData" )
    call VRMethod "CN_Set_General_Icon", "SetRecordAttr", record, "Caption", name
return


/*:VRX         ObjListDeleteObject
*/
/*
    call ObjListDeleteObject objectNumber
*/
ObjListDeleteObject: procedure expose Globals.
    parse arg objectNumber
    
    start = ObjListFind( objectNumber )

    count = Globals.!ObjList.0
    Globals.!ObjList.0 = count - 1

    do i = start to count - 1
        j = i + 1
        Globals.!ObjList.i.!Number = Globals.!ObjList.j.!Number
        Globals.!ObjList.i.!Icon = Globals.!ObjList.j.!Icon
        Globals.!ObjList.i.!Name = Globals.!ObjList.j.!Name
        Globals.!ObjList.i.!Description = Globals.!ObjList.j.!Description
    end

    drop Globals.!ObjList.count.!Icon
    drop Globals.!ObjList.count.!Name
    drop Globals.!ObjList.count.!Description

return

/*:VRX         ObjListFind
*/
/*
    index = ObjListFind( objectNumber )
*/
ObjListFind: procedure expose Globals.

    parse arg objectNumber

    count = Globals.!ObjList.0
    do index = 1 to count
        if Globals.!ObjList.index.!Number = objectNumber then leave
    end

return index

/*:VRX         ObjListFini
*/
ObjListFini: procedure expose Globals.

return

/*:VRX         ObjListInit
*/
ObjListInit: procedure expose Globals.
    Globals.!ObjList.0 = 0
    Globals.!ObjListNext = 1
    do i = 1 to 6
        call ObjListNewObject "Information", "Object" i, "This is the description for object" i 
    end
return

/*:VRX         ObjListNewObject
*/
/*
    objectNumber = ObjListNewObject icon, name, description
*/
ObjListNewObject: procedure expose Globals.
    parse arg icon, name, description 

    count = Globals.!ObjList.0
    count = count + 1

    number = Globals.!ObjListNext
    Globals.!ObjListNext = number + 1     

    Globals.!ObjList.0 = count
    Globals.!ObjList.count.!Number = number
    Globals.!ObjList.count.!Icon = icon
    Globals.!ObjList.count.!Name = name
    Globals.!ObjList.count.!Description = description

return number

/*:VRX         PB_Delete_Cancel_Click
*/
PB_Delete_Cancel_Click: procedure expose Globals. records.
    records.0 = 0
    call SW_Delete_Fini
return

/*:VRX         PB_Delete_Click
*/
PB_Delete_Click: procedure expose Globals. records.
    call VRMethod "LB_DeleteList", "GetSelectedList", "items."
    do i = 1 to items.0
        records.i = VRMethod( "LB_DeleteList", "GetItemData", items.i )  
    end
    records.0 = items.0
    call SW_Delete_Fini
return

/*:VRX         PB_Set_Description_Apply_Click
*/
PB_Set_Description_Apply_Click:  procedure expose Globals.
    call SW_Set_Description_Apply
return

/*:VRX         PB_Set_Description_Reset_Click
*/
PB_Set_Description_Reset_Click:  procedure expose Globals.
    call SW_Set_Description_Reset
return

/*:VRX         PB_Set_General_Apply_Click
*/
PB_Set_General_Apply_Click: procedure expose Globals.
    call SW_Set_General_Apply
return

/*:VRX         PB_Set_General_Find_Click
*/
PB_Set_General_Find_Click: procedure expose Globals.
    iconName = VRFileDialog( VRInfo("Window"), "Icon", "O", "*.ICO" )
    if iconName \= "" then do
        ok = VRSet( "DDCB_Set_General_Icon", "Value", iconName )
    end
return
/*:VRX         PB_Set_General_Reset_Click
*/
PB_Set_General_Reset_Click: procedure expose Globals.
    call SW_Set_General_Reset
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return


/*:VRX         SW_A_Close
*/
SW_A_Close:procedure expose Globals.
    call SW_A_Fini
return

/*:VRX         SW_A_Create
*/
SW_A_Create:procedure expose Globals.
    call SW_A_Init
return

/*:VRX         SW_A_Fini
*/
SW_A_Fini:procedure expose Globals.
    window = VRInfo( "Window" )
    call ObjectClosed window
    call VRDestroy window
return
/*:VRX         SW_A_Init
*/
SW_A_Init:procedure expose Globals.

    window = VRInfo( "Object" )

    call SW_A_Refresh

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_A_Refresh
*/
SW_A_Refresh: procedure expose Globals.
    window = VRInfo( "Window" )
    call ObjectGetKeys window
    index = ObjListFind( keys.1 )
    name = Globals.!ObjList.index.!Name
    call VRSet window, "Caption", name "- View A"
    call VRSet "DT_A", "Caption", name
return

/*:VRX         SW_B_Close
*/
SW_B_Close:procedure expose Globals.
    call SW_B_Fini
return

/*:VRX         SW_B_Create
*/
SW_B_Create:procedure expose Globals.
    call SW_B_Init
return

/*:VRX         SW_B_Fini
*/
SW_B_Fini:procedure expose Globals.
    window = VRInfo( "Window" )
    call ObjectClosed window
    call VRDestroy window
return
/*:VRX         SW_B_Init
*/
SW_B_Init:procedure expose Globals.
    window = VRInfo( "Object" )

    call SW_B_Refresh

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_B_Refresh
*/
SW_B_Refresh: procedure expose Globals.
    window = VRInfo( "Window" )
    call ObjectGetKeys window
    index = ObjListFind( keys.1 )
    name = Globals.!ObjList.index.!Name
    call VRSet window, "Caption", name "- View B"
    call VRSet "DT_B", "Caption", name
return

/*:VRX         SW_Delete_Close
*/
SW_Delete_Close: procedure expose Globals.
    call SW_Delete_Fini
return

/*:VRX         SW_Delete_Create
*/
SW_Delete_Create: procedure expose Globals. records.
    call SW_Delete_Init
return

/*:VRX         SW_Delete_Fini
*/
SW_Delete_Fini: procedure expose Globals. 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Delete_Init
*/
SW_Delete_Init: procedure expose Globals. records.
    do i = 1 to records.0
        caption = VRMethod( "CN_ObjList", "GetRecordAttr", records.i, "Caption" )
        position = VRMethod( "LB_DeleteList", "AddString", caption )
        call VRMethod "LB_DeleteList", "SetItemData", position, records.i
        items.i = i
    end
    items.0 = records.0
    ok = VRMethod( "LB_DeleteList", "SetSelectedList", "items." )

    window = VRInfo( "Object" )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

return

/*:VRX         SW_Set_Description_Apply
*/
SW_Set_Description_Apply: procedure expose Globals.
    objectNumber = GetObjectNumberFromPage( VRInfo("Window") )
    index = ObjListFind( objectNumber )
    Globals.!ObjList.index.!Description = VRGet( "MLE_Set_Description", "Value" )
    keys.0 = 1
    keys.1 = objectNumber 
    call ObjectRefresh "ObjList", "Change" objectNumber
return

/*:VRX         SW_Set_Description_Close
*/
SW_Set_Description_Close:procedure expose Globals.
    call SW_Set_Description_Fini
return

/*:VRX         SW_Set_Description_Create
*/
SW_Set_Description_Create:procedure expose Globals.
    call SW_Set_Description_Init
return

/*:VRX         SW_Set_Description_Fini
*/
SW_Set_Description_Fini:procedure expose Globals.
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Set_Description_Init
*/
SW_Set_Description_Init:procedure expose Globals.

    call SW_Set_Description_Reset

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_Set_Description_Refresh
*/
SW_Set_Description_Refresh: procedure expose Globals.
    objectNumber = GetObjectNumberFromPage( VRInfo("Window") )
    index = ObjListFind( objectNumber )
    call VRSet "MLE_Set_Description", "Value", Globals.!ObjList.index.!Description
return

/*:VRX         SW_Set_Description_Reset
*/
SW_Set_Description_Reset: procedure expose Globals.
    call SW_Set_Description_Refresh
return

/*:VRX         SW_Set_General_Apply
*/
SW_Set_General_Apply: procedure expose Globals.
    objectNumber = GetObjectNumberFromPage( VRInfo("Window") )
    index = ObjListFind( objectNumber )
    Globals.!ObjList.index.!Name = VRGet( "MLE_Set_General_Name", "Value" )
    Globals.!ObjList.index.!Icon = VRGet( "DDCB_Set_General_Icon", "Value" )
    keys.0 = 1
    keys.1 = objectNumber
    call ObjectRefresh "ObjList", "Change" objectNumber
return

/*:VRX         SW_Set_General_Close
*/
SW_Set_General_Close: procedure expose Globals.
    call SW_Set_General_Fini
return

/*:VRX         SW_Set_General_Create
*/
SW_Set_General_Create: procedure expose Globals.
    call SW_Set_General_Init
return

/*:VRX         SW_Set_General_Fini
*/
SW_Set_General_Fini: procedure expose Globals.
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_Set_General_Init
*/
SW_Set_General_Init: procedure expose Globals.

    window = VRInfo( "Object" )

    /* Create a record to display the current caption/icon setting
       and stash the record handle in the page window's user data
    */
    record = VRMethod( "CN_Set_General_Icon", "AddRecord" )
    call VRSet window, "UserData", record

    call SW_Set_General_Reset

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_Set_General_Refresh
*/
SW_Set_General_Refresh: procedure expose Globals.
    window = VRInfo( "Window" )
    objectNumber = GetObjectNumberFromPage( window )
    index = ObjListFind( objectNumber )
    call VRSet "MLE_Set_General_Name", "Value", Globals.!ObjList.index.!Name
    call VRSet "DDCB_Set_General_Icon", "Value", Globals.!ObjList.index.!Icon
    record = VRGet( window, "UserData" )
    call VRMethod "CN_Set_General_Icon", "SetRecordAttr", record,,
        "Caption", Globals.!ObjList.index.!Name,,
        "Icon", Globals.!ObjList.index.!Icon
return

/*:VRX         SW_Set_General_Reset
*/
SW_Set_General_Reset: procedure expose Globals.
    call SW_Set_General_Refresh
return

/*:VRX         SW_Settings_Close
*/
SW_Settings_Close:procedure expose Globals.
    call SW_Settings_Fini
return

/*:VRX         SW_Settings_Create
*/
SW_Settings_Create:procedure expose Globals.
    call SW_Settings_Init
return

/*:VRX         SW_Settings_Fini
*/
SW_Settings_Fini:procedure expose Globals.
    window = VRInfo( "Window" )
    call ObjectClosed window
    call VRDestroy window
return
/*:VRX         SW_Settings_Init
*/
SW_Settings_Init:procedure expose Globals.
    window = VRInfo( "Object" )

    call SW_Settings_Refresh

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         SW_Settings_Refresh
*/
SW_Settings_Refresh: procedure expose Globals.
    window = VRInfo( "Window" )

    call ObjectGetKeys window
    index = ObjListFind( keys.1 )
    name = Globals.!ObjList.index.!Name
    call VRSet window, "Caption", name "- Settings"

    pageCount = VRGet( "NB_Settings", "PageCount" )
    do i = 1 to pageCount
        pageWindow = VRMethod( "NB_Settings", "GetPageWindow", i )
        if pageWindow \= "" then do
            call ObjectRefresh pageWindow
        end
    end
return

/*:VRX         SW_Templates_Close
*/
SW_Templates_Close:procedure expose Globals.
    call SW_Templates_Fini
return

/*:VRX         SW_Templates_Create
*/
SW_Templates_Create:procedure expose Globals.
    call SW_Templates_Init
return

/*:VRX         SW_Templates_Fini
*/
SW_Templates_Fini:procedure expose Globals.
    window = VRInfo( "Window" )
    Globals.!Templates.!Top = VRGet( window, "Top" )
    Globals.!Templates.!Left = VRGet( window, "Left" )
    call VRDestroy window
return
/*:VRX         SW_Templates_Init
*/
SW_Templates_Init:procedure expose Globals.
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        if( DataType( Globals.!Templates.!Top ) = "NUM" ) then do
            ok = VRSet( window, "Top", Globals.!Templates.!Top )
            ok = VRSet( window, "Left", Globals.!Templates.!Left )
        end
        else do
            call VRMethod window, "CenterWindow"
        end
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
return

/*:VRX         W_ObjList_Close
*/
W_ObjList_Close:
    call Quit
return



