/* Desktop smart cleaner  (c)PYzone 2001-2003 */
/* Minimizes all _visible_ windows on Desktop */
/* except whose task titles are matching to predefined filters */
/* Provides interactive tools to create such filters */

NUMERIC DIGITS 10
call RxFuncAdd 'PYRxInit', 'PYRxUtil', 'PYRxInit'
call PYRxInit
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

parse source . . eP
parse arg restart .

call PYRxGo 't','%',,'org_pos' /* store original size */
my_hwnd = PYRxGo('t','!')  /* activate own window */
my_ttl = 'Minimize All'

call set_icon

/* SWP_ flags to use with WinSetWindowPos() */
SWP.SIZE = 1 ; SWP.MOVE = 2 ; SWP.ZORDER=4 
SWP.SHOW = 8 ; SWP.HIDE = 16
SWP.ACTIVATE = 128 ; SWP.DEACTIVATE = 256
SWP.MAXIMIZE = 2048 ; SWP.RESTORE = 4096

call PYRxKey 200
 /* let's "hide" own window - set it size to 1x1 pixel ;) */
call PYRxGo 't','!',,'0 0 1 1 4 '||(SWP.SIZE+SWP.MOVE+SWP.ZORDER)

call get_zorder  /* make current z-list */
call PYRxGo 't','!',desk_hwnd /* activate Desktop */

call SysGetEA eP,'MIN_EXCLUDE','excl_list'
exclude = '' ; to_restore = ''
cur_excl = '   Done with filters :'||'0'x
if restart \= '$#@#$' & pos('010001'x,excl_list) = 1 then
  do  /* have non-empty preconfigured filters (excl_list) & started not only for WPS object */
    do while excl_list \= ''
      parse var excl_list '010001'x title '00'x excl_list
      cur_excl = cur_excl||'0'x||left(title,30)
      call PYRxGo 't','?',title,'tl'/*search for currently running tasks with matching titles*/
      do i=1 to tl.0 /*let's make list with handles of windows, which don't need be minimized */
        if wordpos(tl.i,exclude) = 0 then
          exclude = exclude' 'tl.i
       end
     end
    do until min = 0 /*minimize all windows except filtered-excluded, fullscreen, non-selectable or hidden */
      min = 0 ; call PYRxGo 't','?..??.?','*','tl' /* get some parameters of all task windows */
      do i=1 to tl.0
        parse var tl.i hwnd type vis show /* hWnd - window handle , type - PM,FS,VIO etc. */
                                          /* vis - task visibility in Tasklist */
                                          /* show - window is hidden or it's possible to see it */
        if pos(hwnd,exclude)\=0 | pos(type,'1 4')\=0 | vis\=4 | show=0 | hwnd = my_hwnd then
          iterate
        call PYRxGo 't','!',hwnd      /* trying to activate some window */
        call PYRxKey 100
        if PYRxGo('t','@',hwnd) then
          min = move_win(hwnd, 1)     /* activated Ok - try to minimize it */
       end
     end
     /* prompt for "All Done" or "New Configure" */
    if PYRxMsg(,30,,my_ttl,cur_excl,my_hwnd,,'Ok','Configure') \= 12 then
      signal exit_0    /* "OK" (all done) was selected, bye */
    call restore_view /* will restore windows layout */
   end

call PYRxGo 't','*','*','tl'; min_str=''; min.0=0  /* "tl." now contains all parameters of all currently running tasks */
if PYRxMsg(,,,my_ttl,"Exclude List creation :"||'0000'x,
                    ||"Point out all tasks one by one ,"||'d'x,
                    ||"excluding that must not be minimized.",,
           my_hwnd,,'Ok','Cancel') \= 11 then  /* user doesn't want to configure */
  signal exit_0
do while SysPutEA(eP,'$TEST$','') \= 0  /* check if it's possible to write the EAs */
  call PYRxMsg ,,,,"Error !"||'0000'x||"Can't create Exclude List",'!'
  signal exit_0  /* EAs not writable - configuration doesn't have a sense */
 end
signal on HALT name do_exit    /* let's provide windows layout restoration */
signal on SYNTAX name do_exit  /* -- */
do i=1 to tl.0
  parse var tl.i hwnd pid . type vis . show . '220122'x title '"'
  if pid = 0 then
    do  /* here we caught the window of Tasklist itself */
      tl_hwnd = hwnd ; tl_ttl = title
     end
   else
    if wordpos(type,'1 4') \= 0 & vis = 4 & hwnd \= my_hwnd then
      call to_min_list  /* preliminary hide in tasklist all fullscreen tasks */
 end
call PYRxGo 't','.Select Task for Minimize',tl_hwnd /* rename system Tasklist (temporary) */
call PYRxGo 't','<Select This for Finish Minimize>' /* set own task/window title */
to_restore = ''  /* need-to-restore list initially is empty */
do forever
  drop tl_ses act_hwnd tmp_hwnd ; act_count = 0
  call PYRxGo 't','.'min.0' tasks minimized'  /* correct own window's title */
  call show_tasklist  /* another way to press <Ctrl><Esc> ;) */
  do i=1 to 50 until PYRxGo('t','%',tl_hwnd) & PYRxGo('t','@',tl_hwnd)
    call PYRxKey 100  /* wait for Tasklist visual appearance */
   end
  if i > 50 then
    iterate           /* we want Tasklist ! */
 /* now we need to catch the moment when Tasklist will disappear and new active window will be selected */
  do until tl_ses \= fg_ses | \PYRxGo('t','%',tl_hwnd) /* foreground session changed or Tasklist disappeared */
    call PYRxKey 100*(tl_ses\='TL_SES')   /* small delay, =~0 at first time , ~100 msec at next pass*/
    fg_ses = PYRxGo('i','.......................?')  /* QSV_FOREGROUND_FS_SESSION */
    if tl_ses = 'TL_SES' then
      tl_ses = fg_ses                     /* "catch" initially foreground session */
   end
 /* some windows are "bad" - e.g. Desktop or Warpcenter, or which are not in Tasklist - will try to skip it */
  bad_list = off_touch    /* Desktop and Warpcenter was caught before - in "get_zorder"*/
  call PYRxGo 't',,0,'tl' /* fix all current children od Desktop */
  do i=1 to tl.0
    hwnd = word(tl.i,2)
    if hwnd \= word(tl.i,3) then
      bad_list = bad_list' 'hwnd  /* window isn't belongs to any task - will avoid it */
   end
 /* will try to "reliably" fix new active window */
  do i=1 to 50 until act_count = 5
    call PYRxKey 100     /* small delay */
    act_hwnd = PYRxGo('t','@',,'cur_pos')  /* who's active now ? */
    do while act_hwnd \= tmp_hwnd | act_hwnd = tl_hwnd
      tmp_hwnd = act_hwnd
      act_count = 0
      iterate i
     end
    act_count = act_count + 1
   end
  if pos(act_hwnd,bad_list) \= 0 | \datatype(act_hwnd,'w') then
    act_count = 0  /* some of unwanted windows or error at all */
  if act_count \= 0 then
    if \PYRxGo('t','%',act_hwnd) then
       act_count = restore_task() /* active, but invisible - try to "restore" */
  if act_count = 0 then
    iterate  /* may be next pass will be more successful */
  if act_count < 0 then
    leave    /* worst case - desktops are "passive" */
  if act_hwnd = my_hwnd then
 /* own task was selected - may be all windows are minimized ? */
    if PYRxMsg(,,,my_ttl,"Finish ?",my_hwnd,,'Yes','No') = 11 then
      leave
     else
      iterate
 /* some strange things sometimes happen */
  fg_ses = PYRxGo('i','.......................?')
  call PYRxGo 't','*','*','tl'
  do i=1 to tl.0 until tl_ses = fg_ses & act_hwnd = hwnd
    parse var tl.i hwnd . tl_ses . '"' title '220122'x
   end
  if i > tl.0 then
    iterate  /* can't agree with such selectionn */
 /* let's show to user what we think he has selected ;) */
  call PYRxMsg ,,,,title||'0000'x,hwnd,,'Minimize','Skip','Quit'
  if result = 11 then
    do
      /* yes, he wants it - do minimize */
      call move_win hwnd, 1
      /* here we give to user a "last" chance to confirm his choice */
      call PYRxMsg ,,,,title||'0000'x||'     Minimize Ok ?',hwnd,,,
                   'Next','Restore','Quit'
     end
  select
    when result = 11 then
      call to_min_list      /* minimization confirmed */
    when result = 12 then
      call move_win hwnd, 0 /* some doubts - restore current window & repeat */
    otherwise
      signal do_exit        /* all right - quit - restore windows layout & exit */
   end
 end /*do forever*/
/* here all possible windows are interactively minimized */
/* need to create filter patterns for titles of windows that never need to be minimized */
Exclude = ''; exn = 0; call PYRxGo 't','?...?....??','*','tl' /* get currently running tasks' parameters */
if min.0 < tl.0 - 1 then 
  do  /* "to minimize" list is smaller than total - there're some task(s) to deal with */
    do i=1 to tl.0
      parse var tl.i hwnd vis '"' title '220122'x
      do while wordpos(hwnd,off_touch) \= 0
        Exclude = Exclude||'010001'x||title||'0'x  /* all "bad" windows will not be minimized by default */
        iterate i
       end
      if wordpos(hwnd,min_str)=0 & hwnd\=my_hwnd & vis=4 then
        do  /* normal, selectable task , not me - Ok, will deal with it */
          exn = exn + 1 ; ex_h.exn = hwnd ; ex_t.exn = title /* "ex_h." - set of handles, "ex_t." - set of titles */
          do j=i+1 to tl.0
            if pos(' 4 "'||title||'220122'x, tl.j) \= 0 then
              drop tl.j /* "forget" each selectable task with this title */
           end
         end
     end
    i = 1
    do while i <= exn
     /* for each task will prompt to choose what to do */
      if ch_ttl = 'CH_TTL' | ch_ttl = 11 then
        do
          call PYRxGo 't',my_ttl'.  Current exclusions : 'exn /* new window title */
          if anchor = 'ANCHOR' then
            call get_anchor 1            /* at first - maximize own window */
          parse value PYRxShow(0,0,0) with . . ymx xmx .
          if exn > ymx - 4 then
            do
              '@mode co'xmx' '||(exn+4)  /* can change window size to provide all titles visibility */
             end
          parse value PYRxShow(0,0,100000,' ','6'x) with . . ymx xmx . /* cls */
          do j=1 to exn
            call PYRxShow j-1,0,0,right(j,3)||' : '||ex_t.j /* show all titles */
           end
         end
      if ch_ttl = 'CH_TTL' then  /* 2nd phase beginning prompt - only once */
        ch_ttl = PYRxMsg(,,,my_ttl,"Some tasks have changing ",
                    ||"their titles dynamically."||'0000'x,
                    ||"For reliable recognition of such title"||'d'x,
                    ||'You need to specify a few "sticky" symbols.',,
           my_hwnd,,'Edit exclusions','Leave as is')
      if ch_ttl = 11 then  /* 'Edit' selected */
        if edit_title() = 13 then
          iterate   /* was decided to let this task be minimized */
      Exclude = Exclude||'010001'x||ex_t.i||'0'x ; i = i + 1  /* add new filter pattern */
     end  /*do while i <= exn*/
   end /*if min.0 < tl.0 - 1 then*/
if SysPutEA(eP,'MIN_EXCLUDE',Exclude) = 0 then  /* trying to store filters into EAs */
  do  /* EAs stored Ok - will prompt to (re)create WPS object */
    if PYRxMsg(,,,my_ttl,'Ready to use .',my_hwnd,,'Ok','+ WPS object') = 12 then
      call SysCreateObject "WPProgram",my_ttl,,
			   "<WP_DESKTOP>","EXENAME="eP";MINIMIZED=YES;CCVIEW=NO","REPLACE"
   end
 else
  call PYRxMsg ,,,my_ttl,'Error storing Exclude List !','!'

do_exit:
  do i=1 to min.0  /* let's restore original tasks layout in Tasklist */
    parse var min.i hwnd . . . vis jmp .  /* check for task selection possibility */
    call PYRxGo 't','....'||substr('-# +',vis,1)||substr('-+',jmp,1),hwnd /* set as it was */
   end
  if tl_hwnd \= 'TL_HWND' then   /* have changed Tasklist title ? */
    call PYRxGo 't','.'tl_ttl,tl_hwnd  /* restore original Tasklist title */
  call restore_view  /* let's restore original windows layout */
exit_0:
  if org_pos \= 'ORG_POS' then
    do  /* restore own window to its original state */
      parse var org_pos x y sx sy z_bh mmx s_hd .
      call PYRxGo 't','!',,x' 'y' 'sx' 'sy' 4 '||(SWP.SIZE+SWP.MOVE+SWP.ZORDER)
      call PYRxKey 100
      select
        when s_hd = 2 then
          nop   /* originally was hidden */
        when mmx = 1 then
          call PYRxGo 't','.'  /* was minimized */
        otherwise
          call PYRxGo 't','!'
       end
     end
 exit  /* all is done */

restore_task: procedure expose SWP. z_record. cur_pos act_hwnd
 /* for some reasons sometimes system can't show window of currently active task */
 /* here is attempt to restore such window */
  parse value PYRxGo('t','.?.?.....?', act_hwnd) with pid type title /* get curr. parameters */
  if wordpos(type,'1 4') \= 0 then
    return 0    /* fullcsreen - can't do anything */
  ttl = strip(left(title,40))
  if ttl \= title then
    ttl = ttl'..'
  call PYRxMsg ,,,,ttl||'0000'x||"System can't show task window"||'0000'x,
             ||'1. Task switching slow down'||'d'x,
             ||'2. You have "passive" virtual desktops'||'d'x,
             ||'3. This task is "Lost"',act_hwnd,,'Skip','Get','Change mode'
  if result < 12 then
    return 0   /* user says that it was occasional system slowing */
  if result = 13 then
    return -1  /* "passive" virtual desktop case */
  call PYRxGo 't','.',act_hwnd,'0 0'  /* assign minimization position */
  call PYRxKey 100
  call PYRxGo 't','.',act_hwnd        /* minimize it to that pos. */
  call PYRxKey 100
 /* get original window dimensions */
  parse var z_record.act_hwnd x y cx cy z_behind max_min hide_show dx dy
 /* assign restoration settings as originally was */
  call PYRxGo 't','#',act_hwnd,'0 0 '||(100*(cx=0)+cx)||' '||(100*(cy=0)+cy)
  call PYRxKey 100
 /* trying to activate window */
  call PYRxGo 't','!',act_hwnd
  do j=1 to 50 until PYRxGo('t','%',act_hwnd,'cur_pos') /* wait ~5 sec. max. until become visual */
    call PYRxKey 100
   end
  do while j <= 50  /* if window was successfuly restored - store new presentation parameters & return TRUE */
    parse var cur_pos x y cx cy .
    z_record.act_hwnd = x' 'y' 'cx' 'cy' 'z_behind' 'max_min' 'hide_show' 'dx' 'dy
    return 1  /* restored Ok */
   end
 /* if You don't want this disturbing window - try to kill it */
  call PYRxMsg ,,,,ttl||'0000'x||"Can't restore task window",act_hwnd,,'Skip','Kill task'
  if result = 12 then
    if wordpos(type,'0 3') = 0 then
      call PYRxGo 'p','-',pid   /* text windowed VIO will kill with DosClose() */
     else
      call PYRxGo 't','-',act_hwnd /* PM and "default" - through WM_QUIT message */
  return 0

to_min_list :
 /* adds hWnd of minimized window to "min_str" list */
 /* counts current number of minimized tasks */
 /* puts original parameters of minimized window to special array "min." */
 /* removes minimized task from Tasklist and from Jump sequence */
  call PYRxGo 't','....--',hwnd ; min_str = min_str' 'hwnd
  min.0 = min.0 + 1; 
  interpret 'min.'||min.0||' = tl.i'
  say ' '||min.0||' : 'title
  return

move_win: procedure expose z_record. SWP. to_restore z_layout
  parse arg hwnd, move_mode /* move_mode : 1 to remove window from sight in view of it initial state */
                            /*             0 to return wnd to desktop in view of it z-place */
  parse var z_record.hwnd . . . . . z_max_min z_hide_show . /* look for init state */
  do while move_mode | z_max_min = 1 | z_hide_show = 2
    select  /* order to remove | initially was min. | or was hidden */
      when z_max_min = 1 then
        call PYRxGo 't','.',hwnd /* initially was minimized - let it be */
      when z_hide_show = 2 then 
        call PYRxGo 't','#',hwnd /* was hidden - let it be */
      otherwise
        call PYRxGo 't','#',hwnd /* hide it & include to need-to-restore list */
        if wordpos(hwnd,to_restore) = 0 then
          to_restore = hwnd' 'to_restore
     end
    return 1  /* have removed some window */
   end
  call z_move hwnd /* it seems, need to restore some window */
  call wordpos hwnd,to_restore
  if result \= 0 then /* well, let's remove it from need-to-restore list */
    to_restore = delword(to_restore,result,1)
  return 1

z_move: procedure expose SWP. z_record. z_layout
 /* tries to set window to same z-place as it had when program is being started */
 /* restores it original dimensions */
  parse arg hwnd
  parse var z_record.hwnd x y cx cy z_behind max_min hide_show . /* get all window init parameters */
  if max_min = 1 | hide_show = 2 then /*initially this window was minimized or hidden - won't show it*/
    return
  z = wordpos(hwnd,z_layout)
  if z_behind \= 3 then   /* #define HWND_TOP 3 */
 /* if window was not the topmost - will look for currently existing window that initially was upper */
    do j=(z-1) to 1 by -1 while \datatype(PYRxGo('t','%',z_behind,'cur_pos'),'w')
      z_behind = word(z_layout,j)
     end
 /* let's set window to same z_place where it was at program start and assign same dimensions */
  call PYRxGo 't','!',hwnd, x' 'y' 'cx' 'cy' 'z_behind' '||(SWP.SIZE+SWP.SHOW+SWP.ZORDER)
  do while \datatype(result,'w')
    call PYRxGo 't','.',hwnd /* strange error - minimize it just for a case */
    return
   end
  do j=1 to 50 until cur_show = 1 /* will wait (~5 sec) for window's visual appearance */
    call PYRxKey 100
    call PYRxGo 't','%',hwnd,'cur_pos'
    parse var cur_pos . . . . . . cur_show .
   end
  return

get_anchor: procedure expose SWP. anchor org_pos
 /* activates own window to force virtual desktop to restore "known" coordinates */
 /* if called with parameter - additionally maximizes own window */
  if anchor \= 'ANCHOR' then
    return
  my_hwnd= PYRxGo('t','!')  /* activate myself */
  do while \PYRxGo('t','@',my_hwnd) | \PYRxGo('t','%',my_hwnd) /* wait until active & visible */
    call PYRxKey 100
   end
  if arg(1,'o') then
    return
  call PYRxGo 't','.' 
  call PYRxKey 100
  parse var org_pos x y sx sy z_bh mmx s_hd .
  call PYRxGo 't','!',,'0 0 'sx' 'sy' 0 '||(SWP.SIZE+SWP.MOVE)
  call PYRxKey 100
  call PYRxGo 't','!',,'0 0 0 0 0 '||(SWP.SHOW+SWP.MAXIMIZE+SWP.ACTIVATE)
  call PYRxKey 100
  call PYRxGo 't','%',,'anchor'
  return
  
get_zorder: procedure expose SWP. z_record. desk_hwnd off_touch my_hwnd z_order z_layout
 /* scans and creates variables for two z-sequences : */
 /* "z_layout" with all Desktop child windows */
 /* "z_order" with filtered from "z_layout" main windows of currently running tasks */
 /* also, presentation parameters of that windows are storing into "z_record." set */
  off_touch = '' ; z_order = '' ; z_layout = ''
  call PYRxGo 't',,0,'tl' /* obtain Desktop children's parameters in 'tl.' */
  do i = 1 to tl.0
    parse var tl.i . hwnd task_hwnd . 1 zRecord
    z_layout = z_layout' 'hwnd
    do while i = tl.0 & pos('"wpFolder window"',zRecord) \= 0
      desk_hwnd = hwnd               /* DeskTop */
      off_touch = off_touch' 'hwnd
      leave i
     end
    if hwnd \= task_hwnd then
      iterate
    do while pos(' "#3"',zRecord) \= 0
      off_touch = off_touch' 'hwnd   /* WarpCenter */
      iterate i
     end
    parse value PYRxGo('t','?..??',hwnd) with tl_hwnd type vis
    if tl_hwnd \= hwnd | tl_hwnd = my_hwnd | pos(type,'1 4') \= 0 | vis \= 4 then
      iterate
    call PYRxGo 't','%',hwnd,'z_record.'hwnd
    z_order = z_order' 'hwnd
   end
  return

restore_view : procedure expose z_record. SWP. to_restore anchor z_order wait z_layout
 /* restores whole windows layout */
  call get_anchor  /* return to original coordinates (can be changed if have virtual desktops) */
  my_hwnd = PYRxGo('t')
  do i = 1 to words(to_restore) /* will restore each window from need-to-restore list */
    call wait_msg /* some kind of "smart" notification message */
    hwnd = word(to_restore,i)
    parse var z_record.hwnd x y cx cy . . . dx dy z_title /* look for original parameters */
    kx.1 = 0 ; ky.1 = 0 ; kx.2 = -32000 ; ky.2 = -32000 ; kx.3 = 32000 ; ky.3 = 32000
    call PYRxGo 't','%',hwnd,'cur_pos'                    /* get current state */
    do z=1 to 3 /* this way to move windows is shown in PYRxUtil manual example "Jumpin' windows" */
      parse var cur_pos cur_x cur_y .
      if cur_x = x & cur_y = y then     /* current & original positions now are equal */
        leave
      call PYRxGo 't','!',hwnd, x' 'y' 'kx.z' 'ky.z' 0 '||SWP.MOVE  /* try to set window to new position */
      do j=1 to 50 until new_x \= cur_x | new_y \= cur_y /* wait ~5 sec. max until window will appear on new pos */
        call PYRxKey 100
        call PYRxGo 't','%',hwnd,'cur_pos'  /* check current position */
        parse var cur_pos new_x new_y .
       end
     end
    call z_move hwnd  /* now window has original position coordinates - let's move it to orig. z-place */
   end
  do z=1 to words(z_order) until datatype(PYRxGo('t','%',word(z_order,z)),'w')
    nop   /* look for topmost originally shown window */
   end
  call PYRxGo 't','!',word(z_order,z) /* activate it & set the topmost */
  if datatype(wait,'w') then
    call close_msgbox  /* remove notification message if it still exists */
  drop wait
  return

close_msgbox:
  do until \datatype(result,'w')
    call PYRxKey 100
    call PYRxMsg wait,'-'
   end
  drop wait
  return

wait_msg: procedure expose wait my_hwnd anchor wait
  new = wait = 'WAIT'
  if datatype(wait,'w') then
    if PYRxMsg(wait,'?') \= '' then
      call close_msgbox
  do while wait = 'WAIT'
    if \new then
      do
        drop anchor
        call get_anchor
       end
    wait = PYRxMsg('*',,1,,'Wait.'||'0'x,
                            ||'Your windows layout'||'0'x,
                            ||'Now will be restored', my_hwnd)
   end
  return

show_tasklist: procedure expose SWP. tl_hwnd
 /* system Tasklist is an ordinary window that can be shown and activized on Desktop */
 /* here it will be additionally centered on screen */
  call PYRxGo 't','%',tl_hwnd,'origin'  /* obtain current parameters */
  parse var origin x y cx cy . . . dx dy  /* position, dimensions, screen size */
  if cx > dx then
    cx = dx
  if cy > dy then
    cy = dy
  call PYRxGo 't','!',tl_hwnd,(dx - cx)%2||' '||(dy - cy)%2||' 'cx' 'cy' 0 ',  /* activate centered */
                            ||(SWP.SIZE+SWP.MOVE+SWP.SHOW+SWP.ACTIVATE)
  return

edit_title :
 /* prompts for choices, which are : */
 /* 'Dynamic' if task can change its title and need to specially make filter pattern */
 /* 'Static' - title always is the same - it will be a filter pattern exactly */
 /* 'Let minimize' - task window was skipped for some reason during 1st configuration phase */
 /* returns : */
 /* 1 - pattern created and placed in ex_t.i */
 /* 12 - let's use current title ex_t.i as pattern text */
 /* 13 - current title won't be used as minimization filter */
  call PYRxShow i-1,0,xmx,,'f'x  /* highlight current title */
  call PYRxGo 't','!'            /* activate own window */
  title = ex_t.i
  call PYRxMsg ,,,,title||'0000'x||'   Task title :',ex_h.i,,'Dynamic','Static','Let minimize'
  if result = 13 then
    do  /* this task can be minimized */
      do j=i+1 to exn
        interpret 'ex_t.'||(j-1)||' = ex_t.j; ex_h.'||(j-1)||' = ex_h.j' /* remove it from exclusions list */
       end
      exn = exn - 1
     end
  if result \= 11 then  /* let's minimize OR task title is exactly the pattern */
    return result
 /* draw at window's bottom some kind of editor */
  call PYRxShow ymx-2,0,0,left(right(i,3)||' : '||title,xmx),'16'x  /* current title text */
  call PYRxShow '+1',,0,left(' (<Left> <Right>)+<Ctrl>     <Enter>',xmx),'71'x  /* keys reference */
  lf_pos = 1 ; rt_pos = length(title)
 /* pattern is part of original title where non-permanent symbols at the beginning and at the end */
 /* are replaced with single (two) '*' symbols */
  do forever
    pattern = substr(title,lf_pos,rt_pos-lf_pos+1); tmp_mem = pattern; del_str = ''
    if lf_pos \= 1 then
      pattern = '*'pattern
    if rt_pos \= length(title) then
      pattern = pattern'*'
    do y_cur=1 to exn  /* here will highlight all titles that are matching to current pattern */
      if y_cur = i then
        iterate        /* current title is already highlighted (most brightly) */
      attr = '6'x      /* "non-matching" colour */
      call pos tmp_mem, ex_t.y_cur
      if result \= 0 then
        if (right(pattern,1) = '*' & (result = 1 | left(pattern,1) = '*')) |, 
           length(ex_t.y_cur) = length(tmp_mem) + result - 1 then
          do
            del_str = del_str' 'y_cur  /* "matches" list */
            attr = '7'x  /* "matching" colour */
           end
      call PYRxShow y_cur-1,0,xmx,,attr  /* recolour existing title text */
     end
    call PYRxShow ymx-3,0,xmx,' ','1f'x  /* colour fill editing line for current pattern */
    call PYRxShow ,5 + lf_pos - (lf_pos>1),0,pattern /* place here current pattern text */
    parse value PYRxKey() with . scan .
    select
      when scan = '4B' then /*Left*/
        if lf_pos < rt_pos - 1 then
          lf_pos = lf_pos + 1
      when scan = '4D' then /*Right*/
        if rt_pos > lf_pos + 1 then
          rt_pos = rt_pos - 1
      when scan = 73  then /*Ctrl-Left*/
        if lf_pos > 1 then
          lf_pos = lf_pos - 1
      when scan = 74  then /*Ctrl-Right*/
        if rt_pos < length(title) then
          rt_pos = rt_pos + 1
      when scan \= '1C' then
        nop
      otherwise   /*Enter*/  /* end of editing */
        ex_t.i = pattern ; tmp_mem = exn ; exn = 0
        do j=1 to tmp_mem
          if wordpos(j,del_str) = 0 then
            do  /* rebuild titles list - excluding matches */
              exn = exn + 1 ; ex_t.exn = ex_t.j ; ex_h.exn = ex_h.j
              if i = j then
                i = exn
             end
         end
        return 1
     end /*select*/
   end /*do forever*/

set_icon : procedure expose eP restart
 /* is used once at start */
 /* decodes base64 icon code and attaches it to program file's EAs */
 /* restarts program when it is "fresh" or is started with any parameter */

  call SysGetEA eP,'.ICON','ic'  /* try to obtain icon from EA */
  if \datatype(result,'w') | result \= 0 then
    ic = ''                      /* GetEA error */
  if length(ic) \= 11316 then
    do
       /* extract base64-coded icon from last comment of script body */
      parse value charin(eP,,50000) with '2f2a7e'x i64 '2a2f'x
      call stream eP,'c','close'

       /* base64 decoding of icon */
      i64 = translate(i64,'0000'x,'0d0a'x)
      d_code = xrange('0'x,'3f'x) ; s_code = xrange('A','Z')||xrange('a','z')||'0123456789+/'
      ji = 1 ; ic = ''
      call pos '0'x,i64
      do while result \= 0
        tmp_s = ''
        if result > ji then
          tmp_s = x2b(c2x(translate(substr(i64,ji,result-ji),d_code,s_code)))
        ji = result+1
        do while tmp_s \= ''
          parse var tmp_s +2 ic.0 +6 +2 ic.1 +6 +2 ic.2 +6 +2 ic.3 +6 +2 ic.4 +6 +2 ic.5 +6 ,
                      +2 ic.6 +6 +2 ic.7 +6 +2 ic.8 +6 +2 ic.9 +6 +2 ic.10 +6 +2 ic.11 +6 tmp_s
          result = ic.0||ic.1||ic.2||ic.3||ic.4||ic.5||ic.6||ic.7||ic.8||ic.9||ic.10||ic.11
          if result \= '' then
            ic = ic||x2c(b2x(left(result,length(result)%8*8)))
         end
        call pos '0'x,i64,ji
       end
     end
  if length(ic) = 11312 then
    do /* Just decoded, Ok - store it in EAs */
      ic = 'F9FF'x||translate('12',d2c(length(ic),2),'21')||ic
      call SysPutEA eP,'.ICON',ic
      restart = '$'
     end
  if restart \= '' & restart \= '$#@#$' then
    '@start /c /min /pgm "'eP'" $#@#$'  /* restart program with "create WPS object" flag */
   else
    return
  exit

/* base64-coded icon is below */
/* can be decoded in "set_icon" */
/*~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*/