/**
 * REXX Communication Control Function Library  Ver.1.1
 *                  copyright 1998, Naga(Kazuo Adachi)
 *                          mailto:nagaw@ibm.net
 *                          mailto:GDB00421@nifty.ne.jp
 *
 * $Id$
 *
 * $Log$
 */

CALL RxFuncAdd 'RxCommLoadFuncs','RxComm','RxCommLoadFuncs'
CALL RxCommLoadFuncs

/*--------------------------------------------------------*/
/**
 * Drop Modem Signal(Line)
 */
lineDTR = 'OFF'
lineRTS = ''
waitDCD = 5

rc = RxCommSignal( lineDTR, lineRTS )

/**
 * Wait for drop DCD or 'NO CARRIER'
 */
chkDCD = TIME('R')
DO UNTIL POS( 'OK'        , rc ) = 1 |,
         POS( 'NO CARRIER', rc ) = 1
    rc = RxCommRead()
    CALL CHAROUT , rc

    IF POS( 'DCD', RxCommSignal() ) = 0 THEN LEAVE

    IF TIME('E') - chkDCD > waitDCD THEN
    DO
        /**
         * Manualy Hangup Line
         */
        ok = RxCommWrite( '+++' )
        DO UNTIL POS( 'OK', rc ) = 1
            rc = RxCommRead()
            CALL CHAROUT , rc
        END
        ok = RxCommWrite( 'ATH' || '0D'x )

        chkDCD = TIME('R')
    END
END

RETURN
