/* Rexx: RxReplaceModule using rxunlock.dll example */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysloadFuncs'
call SysLoadFuncs
call SysCls

call RxFuncAdd 'RxUnlockLoadFuncs', 'RXUNLOCK', 'RxUnlockLoadFuncs'
call RxUnlockLoadFuncs

/* enable debug output */
call RxUnlockDebug( 1 )

Parse ARG file1 file2

Say '--- repace non-existing target -----------------------------------------'
Say 'RxReplaceModule(rxunlock.dll,nonexist.fil)....'
rc=RxReplaceModule('rxunlock.dll','nonexist.fil')
Say 'rc='rc
'@del nonexist.fil'
'@pause'

Say '--- repace with same filename ------------------------------------------'
Say 'RxReplaceModule(rxunlock.dll,rxunlock.dll)....'
rc=RxReplaceModule('rxunlock.dll','rxunlock.dll')
Say 'rc='rc
'@pause'

Say '--- repace with non non-existing source --------------------------------'
Say 'RxReplaceModule(nonexist.fil,rxunlock.dll)....'
rc=RxReplaceModule('nonexist.fil','rxunlock.dll')
Say 'rc='rc
'@pause'

Say '--- repace executable in use  ------------------------------------------'
'@copy' SysBootDrive()'\os2\e.exe .\test.exe'
'@start .\test.exe'
call SysSleep 4
Say 'RxReplaceModule('SysBootDrive()'\os2\attrib.exe,test.exe)....'
rc=RxReplaceModule(SysBootDrive()'\os2\attrib.exe','test.exe')
Say 'rc='rc
'@del test.exe'
'@pause'


if file2 <> '' then
  do
    Say 'RxReplaceModule(' file1',' file2 ')....'
    rc=RxReplaceModule( file1, file2 )
    Say 'rc='rc
  end
 