#include "example.h"

void Initialize ( int iArgC, char *pcArgP[], BALLS *pBalls )
/* Perform everything that's neccessary to run the balls. */
{
   int iC1;
   BALL *pBall;

   memset (pBalls, 0, sizeof (BALLS));

   InitScreen ();

   randomize ();

   for (iC1 = 0;
        iC1 < MAXBALLS;
        iC1++)
   {
      pBall = &pBalls->Ball[iC1];
      NEWCOLOR (pBall->iColor);
      pBall->iXPos = random (iScreenW) + 1;
      pBall->iYPos = random (iScreenH) + 1;
      pBall->iHSpeed = (iC1%2) ? NEWSPEED (MAXHSPEED) : -NEWSPEED (MAXHSPEED);
      pBall->iVSpeed = (iC1%2) ? NEWSPEED (MAXVSPEED) : -NEWSPEED (MAXVSPEED);
   }

   if (iArgC > 1)
   {
      pBalls->iNr = atoi (pcArgP[1]);
      pBalls->iNr = pBalls->iNr > 0 ? pBalls->iNr : 10;
      pBalls->iNr = pBalls->iNr <= MAXBALLS ? pBalls->iNr : MAXBALLS;
   }
   else
   {
      pBalls->iNr = 10;
   }
}

void InitScreen ( void )
/* Prepare screen to show the running balls. */
{
   #ifdef GUI
   #ifdef OS2
   SIZEL Size = { 0, 0 };
   ARCPARAMS ap = { 4, 4, 0, 0 };
   hAB = WinInitialize (0);
   hMQ = WinCreateMsgQueue (hAB, 0);
   WinRegisterClass (hAB, "SillyExample", ClientWndProc, CS_SIZEREDRAW, 0);
   hWndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE | WS_ANIMATE,
                                   &ulFrameFlags,
                                   "SillyExample", "Bounching balls",
                                   0, 0, 100, &hWndClient);
   hDC = WinOpenWindowDC (hWndClient);
   hPS = GpiCreatePS (hAB, hDC, &Size, PU_PELS | GPIF_DEFAULT |
                                       GPIT_MICRO | GPIA_ASSOC);
   GpiSetDrawingMode (hPS, DM_DRAW);
   WinStartTimer (hAB, hWndClient, TID_MOVE, DELAY);
   GpiSetArcParams (hPS, &ap);
   DosSetPriority (0, 1, 31, 0); /* Change to a low priority (IDLE class) */
   #else
   int iErrorCode;
   int iGraphDriver;
   int iGraphMode;

   iGraphDriver = DETECT;        /* Request auto-detection */
   initgraph (&iGraphDriver, &iGraphMode, "");
   iErrorCode = graphresult ();  /* Read result of initialization */
   if (iErrorCode != grOk)       /* Error occured during init */
   {
      cprintf ("Graphics System Error: %s\n\r", grapherrormsg (iErrorCode));
      exit (1);
   }
   #endif
   #else
   _setcursortype (_NOCURSOR);
   #endif
   ClrScr ();
   GetScrSize (&iScreenW, &iScreenH);
}
