.. ----------------------------------------
.2 Usage
.. ----------------------------------------
.an USAGE

[=TOPICS]

.su V30 u

.. ----------------------------------------
.3 Call [=BASETITLE] directly
.. ----------------------------------------
.an USAGE_DIRECTLY

Invoking the command below, [=TITLE] will compile the source
files to IPF source and call the [.INSTALL_IPF IPF Compiler] to
create an INF or HLP file.

If the INF file can be created successfully, the INF file
viewer is started to display it, unless the switch parameter
*/NOVIEW* is specified.

All switch parameters may be abbreviated and are case-insensitive.
You just have to type the uppercase letter.

See some examples [.USAGE_EXAMPLE here].

.fo off
  HTEXT 
    [.FN_PARM_CMDPATH drive]   [.FN_PARM_CMDPATH path] 

  [.FN_PARM_INPUTFILE source__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

 
    [.FN_PARM_IPFFILE ipf__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

 
 
    [.FN_PARM_INFORHLPFILE inf__or__hlp__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

 
 Ĵ
 Ĵ
    [.FN_PARM_RCHFILE rch__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

   Ŀ
                               
 Ĵ
       [.FN_PARM_HELP /?] Ĵ
       [.FN_PARM_VERBOSE /Verbose] Ĵ
       [.FN_PARM_NOVIEW /Noview] Ĵ
       [.FN_PARM_RCH /Rch] Ĵ
          [.FN_PARM_RCHSTEM /Rch:prefix]    
       [.FN_PARM_GENHLP /Hlp] 
                [.FN_PARM_SUBPAGES /Subpages] 
.fo on

.. ----------------------------------------
.3 [=BASETITLE] call examples
.. ----------------------------------------
.an USAGE_EXAMPLE

The following command creates the file *sample.inf* from *sample.txt* in the
current directory (an intermediate IPF file named *sample.ipf* is also created there).
The INF file viewer is launched with the resulting INF file right after compilation:
.fo off
  htext sample.txt
.fo on

The following command does the same, but does not launch the INF file viewer
.fo off
  htext sample.txt /NOVIEW
.fo on

The following command does the same, but displays some information about
the compilation process.
.fo off
  htext sample.txt /VERBOSE
.fo on

The following command creates the file *target.inf* from *sample.txt* in the
subdirectory *release\inf*. The intermediate IPF file *source.ipf* is created
in the *compile* subdirectory.
.fo off
  htext sample.txt compile\source.ipf release\inf\target.inf
.fo on

The following command creates the file *sample.hlp* from *sample.txt* in the
current directory (an intermediate IPF file named *sample.ipf* is also created there):
.fo off
  htext sample.txt /HLP
.fo on

The following command creates the file *sample.hlp* from *sample.txt* in the
current directory and also generates a resource header file named *sample.rch*,
so that an application can use the numeric resource ids of the help file.
Within the header file, the anchornames being used as symbol names are prefixed
with the string *IDPNL__*
.fo off
  htext sample.txt /HLP /RCH:IDPNL__
.fo on

.. ----------------------------------------
.3 Call [=BASETITLE] as batch processor
.. ----------------------------------------
.an USAGE_EXTPROC

You can use [=TITLE] as an external batch processor
for CMD files, that contains [=TITLE] compatible source file.
For that, (re)name a source text file to have an extension of .cmd
and place the following line at the very top of the file:
.fo off
  EXTPROC htext
.fo on

Append any [.USAGE_DIRECTLY parameters for HTEXT.CMD] to this line.

In order to let [=TITLE] compile the command file, simply
execute the new command file.

.. ----------------------------------------
.3 [=BASETITLE] environment variables
.. ----------------------------------------
.an USAGE_ENVVARS

The following environment variables are used by [=TITLE]:

.plist bold tsize=15 break=fit
- INCLUDE
= path to search for include and bitmap files, if not found in current or
  specified directory
- HTINCLUDE
= path to search for include and bitmap files if not found in current or
  specified directory and the directories of the INCLUDE statement
- HTWRITEFULLPATHS
= set this to 1 in order to use full pathnames for the bitmap files, to
  behave like the versions before 1.08. As alternate value to enable that,
  also TRUE and ON were accepted. Every other value switches to the
  default behavior: create relative bitmap filenames. (Because IPFC handles
  relative pathnames well, this feature can be used here as well to make
  the created IPF file better exchangable. That applies especially to those
  cases, where the IPF file is distributed without its HTEXT file.)

The following environment variables can be changed to replace the
[.LINK_BITMAPS default bitmaps] being inserted before external links:

.plist bold tsize=15 break=fit
- WEBBMP
= bitmap filename for all web links, like http, ftp etc. (default:
  ns.bmp)
- EMAILBMP
= bitmap filename for email links (default: nsmail.bmp)
- INFBMP
= bitmap filename for INF and HLP file links (default: book.bmp)

All filenames may be specified fully-qualified as well.

.. ----------------------------------------
.3 EPM support
.. ----------------------------------------

[=TITLE] supports special features of the developer's edition of the
*Enhanced Editor* of OS/2 V6.03b (EPM).

.at hi
The EPM macro version coming with OS/2 Warp 4 doesnot provide that!
.at

You either have to replace the EPM yourself after installing an OS/2 system
or simply install [ [=URL_NEPMD] NEPMD].

*Error message layout*
.ul
- The error messages of the [=TITLE] match error messages of common OS/2
  compilers.
- The error messages of the *IPF compiler* are transformed to match error
  messages of common OS/2 compilers.

This way, you can use the error scan feature and simply step through all
errors being reported by both [=TITLE] and the *IPF compiler*.

.. ----------------------------------------
.3 HtCmp - compare [=BASETITLE] sources
.. ----------------------------------------
.an USAGE_HTCMP

Invoking the command below, *htcmp* will compare specified
[=TITLE] source files with files of the same name in a
target directory and and create a directory structure in
an output directory, where for each section not being
equal between a source and target file, difference files
are created.

[=NOTE]
.ul compact
- When comparing, Includes are not processed, instead each
  include file needs to be compared as well separately.
- In order to get reasonable results, it is highly recommended
  to specify anchor names for all sections. If a section does
  not contain an anchor name, a name is generated in form of
  ##0, ##1 and so forth.
- If two files to be compared do not contain anchor names, they
  still can be compared, if the order of the sections has not
  changed and no sections have been added other than at the end
  of the new file.

.fo off
  HTCMP 
    [.FN_PARM_CMDPATH drive]   [.FN_PARM_CMDPATH path] 


  [.FN_PARM_SOURCEMASK source__mask]  [.FN_PARM_TARGETPATH target__path] 
                                 [.FN_PARM_OUTPUTDIR output__path] 

   Ŀ
                             
 Ĵ
       [.FN_PARM_HELP /?] 
.fo on

.. ----------------------------------------
.3 HtLaunch - using the default web browser
.. ----------------------------------------
.an USAGE_HTLAUNCH

[=TITLE] can create [.ESC_LINKS external links to internet resources]
for you, which will start a web browser automatically.

Unfortunately, an INF file has to contain the name of the web browser
(or any other program started from it) hard-coded. As a result,
an INF file cannot support the *default web browser* mechanism provided
by *OS/2 Warp 3* and *OS/2 Warp 4* by default. Instead, [=TITLE] uses
*NETSCAPE.EXE* as the browser to be used for external internet resources.

In order to still have an opportunity to support the default browser
mechanism of *OS/2 Warp*, [=TITLE] comes with the *HtLaunch* utility.

When called with an URL as parameter, *HtLaunch* will query the default
browser from OS/2 an use it to access the desired internet resource.
In order to let an INF file use *HtLaunch*, this utility is also used
to modify any INF file created by [=TITLE] to use htlaunch.exe
instead of NETSCAPE.EXE, so that such a modified INF file will from
then on indirectly use the default web browser for external internet
resources.

As only drawback, the external links will not work any longer, if you
copy a patched INF file to a system, where htlaunch.exe is not available.

In order to use *HtLaunch*, do the following:
.ol
- use [=TITLE] to create an INF file with [.ESC_LINKS external internet links]
- ship your application package with both htlaunch.exe and your INF file and
  an installation routine
- when the installation routine of your package installs the INF file on a new
  system
  - copy htlaunch.exe to a directory from within the *PATH* statement
.
  (?:\OS2 recommended, where ?: is the boot drive)
  - copy the INF file to the desired location
  - modify the INF file with the following command
.fo off
    htlaunch $PATCH <pathname__of__inf__file>
.fo on

[=NOTE]
.ul compact
- The external links to internet resources within the modified INF file will
  not longer work on systems, where *htlaunch.exe* is not available.
- The *HtLaunch* utility can only patch INF files created by [=TITLE]
  to use *htlaunch.exe*.

.. ----------------------------------------
.3 Ipf2Htext - compile an IPF file to an [=BASETITLE] file
.. ----------------------------------------
.an USAGE_IPF2HTEXT

The *Ipf2Htext* utility can be used to convert existing IPF files into
HTEXT files. In addition to easier editing of the converted files, it
provides a few IPF code fixes (like superfluous empty lines) as well.
Test your IPF files and see how the [=TITLE] code will look like!

Invoking the command below, *Ipf2Htext* will compile an IPF source
file to an HTEXT target file. When the HTEXT target file is omitted,
the output file is created in the directory of the IPF source file,
but with extension *.htext*.

All switch parameters may be abbreviated and are case-insensitive.
You just have to type the uppercase letter.

.fo off
  IPF2HTEXT 
    [.FN_PARM_CMDPATH drive]   [.FN_PARM_CMDPATH path] 

  [.FN_PARM_IPF2HTEXT_IPFFILE ipf__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

 
    [.FN_PARM_IPF2HTEXT_HTEXTFILE htext__file] 
    [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path] 

   Ŀ
                                                   
 Ĵ
       /Aps:  [.FN_PARM_IPF2HTEXT_APSFILE aps__file] Ĵ
                [.FN_PARM_FILEDRIVE drive]   [.FN_PARM_FILEPATH path]             
       [.FN_PARM_HELP /?] 
.fo on

For many existing IPF files, the resulting HTEXT file can be used for
editing the source of a help file directly.

More complex help files will require a bit finishing. In many cases
that applies to auto-links and groups only, while groups are not supported
by [=TITLE]. To achieve comparable results, you have to use [.CMD_SUBLINK]
commands. Note that you can also use [.CMD_SUBLINK] without creating any
text, e.g. for the auto-link feature.

See the [.LIMITATIONS] section for all unsupported IPF tags/attributes.

[=NOTE]
.ul compact
- IPF comment lines are converted to HTEXT comment lines.
- IPF *.nameit* commands are converted to HTEXT environment variables.
- In order not to overwrite an existing **.htext file, specify the second
  parameter as well.
- For comparing the HTEXT output with that for a back-and-forth-compiled one,
  execute:
.fo off
   htext file.htext    (creates file.ipf and file.inf)
   ipf2htext file.ipf filenew.htext  (creates filenew.htext)
   htext filenew.htext               (creates filenew.ipf and filenew.inf)
.fo on
  Then you can compare file.inf with filenew.inf.

.. #######################
.include footnote.inc
.. #######################

