/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if !defined( SSEXCEPTION)
#  define SSEXCEPTION

#  include<stdio.h>
#  include<string.h>
#  include<sssto.hpp>
#  include<ssexcept.h>
#  include<ssglobal.h>

#  define SSExceptionParmArray  8
#  define SSExceptionTextLength 127
#  define SSExceptionDefault    SSTrue
#  define SSTHROW( class)       throw class

   class SSException;
   class SSExceptionInfo;
   class SSExceptionParm;
   class SSExceptionPresent;

   class SSExceptionParm
      {
      public:

         enum SSExceptionParmType
            {
            constVoid,
            constChar,
            unsigned32
            };

         SSConstr            SSExceptionParm( void);
         SSConstr            SSExceptionParm( const char*);
         SSConstr            SSExceptionParm( const void*);
         SSConstr            SSExceptionParm( SSUnsigned32);
         SSConstr            SSExceptionParm( const SSExceptionParm&);

         SSExceptionParm&    operator=( const char*);
         SSExceptionParm&    operator=( const void*);
         SSExceptionParm&    operator=( SSUnsigned32);
         SSExceptionParm&    operator=( const SSExceptionParm&);

         SSExceptionParmType type( void) const;
         SSBooleanValue      isConstChar( void) const;
         SSBooleanValue      isConstVoid( void) const;
         SSBooleanValue      isUnsigned32( void) const;

         const char*         asConstChar( void) const;
         const void*         asConstVoid( void) const;
         SSUnsigned32        asUnsigned32( void) const;

                             operator const char*( void);
                             operator const void*( void);
                             operator SSUnsigned32( void);

         SSDestr             SSExceptionParm( void);

      protected:
         SSExceptionParmType oType;
         union
            {
            const void*      opParm;
            SSUnsigned32     oulParm;
            char*            opchParm;
            };
      };

   class SSExceptionInfo
      {
      public:
         SSConstr       SSExceptionInfo( void);

         SSBooleanValue hasException( void) const;
         SSBooleanValue setException( SSBooleanValue = SSTrue);
 
      protected:
         SSBooleanValue oException;
      };

   class SSException
      {
      friend class SSExceptionInfo;

      public:
         void*             operator new( size_t);
         void              operator delete( void*);

         SSConstr          SSException( const SSException&);
         SSConstr          SSException( const char*, unsigned long = 0);

         const char*       text( void) const;
         SSExceptionParm*  parm( SSUnsigned32);
         SSUnsigned32      errorId( void) const;
         void              setText( const char*);

         SSDestr           SSException( void);

      protected:
         SSUnsigned32      oulId;
         SSExceptionParm   oaParm[ SSExceptionParmArray];
         char              oachText[ SSExceptionTextLength + 1];
      };

   class SSExceptionOutOfStorage : public SSException
      {
      public:
         SSConstr          SSExceptionOutOfStorage( void);
      };

   class SSExceptionPresent 
      {
      public:
         SSConstr     SSExceptionPresent( void);

         void         throwException( SSUnsigned32, const char*);
         void         throwException( SSUnsigned32, const char*,
                         SSUnsigned32);
         void         throwException( SSUnsigned32, const char*,
                         const char*);
         void         throwException( SSUnsigned32, const char*, 
                         const char*, SSUnsigned32);
         void         throwException( SSUnsigned32, const char*,
                         SSUnsigned32, SSUnsigned32, const char*);

         SSException* getException( void);
         SSException* hasException( void) const;
         SSException* setException( SSException*);

      protected:
         SSException* opException;
      };

   SSExceptionInfo& getSSExceptionInfo( void);
   void             setSSExceptionNewHandler( void);
 
#  include<ssexcept.inl>

#endif
