/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if !defined( SSREF)
#  define SSREF
#  include<ssglobal.h>

#  define SSRefMsgCount "SSRef0001e: Reference count less than zero"

   class SSRefCount
      {
      public:
         SSConstr             SSRefCount( void);

         virtual void         refInc( void);
         virtual void         refFree( void) = 0;
         virtual void         refDec( SSBooleanValue = SSTrue);

      protected:
         SSSigned32           olCount;
      };

   template< class T> class SSRef
      {
      public:
         SSInline SSConstr             SSRef( T*);
         SSInline SSConstr             SSRef( T&);
         SSInline SSConstr             SSRef( void);
         SSInline SSConstr             SSRef( SSRef< T>&);

         SSInline SSRef< T>&           operator=( T*);
         SSInline SSRef< T>&           operator=( T&);
         SSInline T&                   operator*( void);
         SSInline T*                   operator->( void);
         SSInline                      operator T*( void);
         SSInline SSRef< T>&           operator=( SSRef< T>&);

         SSInline SSDestr              SSRef( void);

      protected:
         T*                            opType;
      };

#  include<ssref.inl>

#endif
