/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
   SSInline SSRefCount::SSRefCount( void) : olCount( 1)
      {
      }

   template< class T> SSRef< T>::SSRef( void) : opType( 0)
      {
      }

   template< class T> SSRef< T>::SSRef( T* qpT) : opType( qpT)
      {
      if ( opType) opType->refInc();
      }

   template< class T> SSRef< T>::SSRef( T& qT) : opType( &qT)
      {
      opType->refInc();
      }

   template< class T> SSRef< T>::SSRef( SSRef< T>& qRef) : 
      opType( qRef.opType)
      {
      if ( opType) opType->refInc();
      }

   template< class T> SSRef< T>& SSRef< T>::operator=( SSRef< T>& qRef)
      {
      if ( qRef) qRef->refInc();
      if ( opType) opType->refDec();
      opType = qRef.opType;
      return *this;
      }

   template< class T> SSRef< T>& SSRef< T>::operator=( T* qpT)
      {
      if ( qpT) qpT->refInc();
      if ( opType) opType->refDec();
      opType = qpT;
      return *this;
      }

   template< class T> SSRef< T>& SSRef< T>::operator=( T& qT)
      {
      qT.refInc();
      if ( opType) opType->refDec();
      opType = &qT;
      return *this;
      }

   template< class T> SSRef< T>::operator T*( void)
      {
      return opType;
      }

   template< class T> T& SSRef< T>::operator*( void)
      {
      return *opType;
      }

   template< class T> T* SSRef< T>::operator->( void)
      {
      return opType;
      }

   template< class T> SSRef< T>::~SSRef( void)
      {
      if ( opType) opType->refDec();
      }
