/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.examples.controlexample.ButtonTab;
import org.eclipse.swt.examples.controlexample.ComboTab;
import org.eclipse.swt.examples.controlexample.DialogTab;
import org.eclipse.swt.examples.controlexample.LabelTab;
import org.eclipse.swt.examples.controlexample.ListTab;
import org.eclipse.swt.examples.controlexample.ShellTab;
import org.eclipse.swt.examples.controlexample.SliderTab;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.examples.controlexample.TextTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ControlExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_control");
    private ShellTab shellTab;
    private TabFolder tabFolder;
    static final int ciClosedFolder = 0;
    static final int ciOpenFolder = 1;
    static final int ciTarget = 2;
    static final String[] imageLocations = new String[]{"closedFolder.gif", "openFolder.gif", "target.gif"};
    Image[] images;
    static /* synthetic */ Class class$0;

    public ControlExample(Composite parent) {
        this.initResources();
        this.tabFolder = new TabFolder(parent, 0);
        Tab[] tabArray = new Tab[8];
        tabArray[0] = new ButtonTab(this);
        tabArray[1] = new ComboTab(this);
        tabArray[2] = new DialogTab(this);
        tabArray[3] = new LabelTab(this);
        tabArray[4] = new ListTab(this);
        this.shellTab = new ShellTab(this);
        tabArray[5] = this.shellTab;
        tabArray[6] = new SliderTab(this);
        tabArray[7] = new TextTab(this);
        Tab[] tabs = tabArray;
        int i = 0;
        while (i < tabs.length) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(tabs[i].getTabText());
            item.setControl((Control)tabs[i].createTabFolderPage(this.tabFolder));
            ++i;
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void dispose() {
        if (this.shellTab != null) {
            this.shellTab.closeAllShells();
        }
        this.shellTab = null;
        this.tabFolder = null;
        this.freeResources();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        ControlExample instance = new ControlExample((Composite)shell);
        shell.setText(ControlExample.getResourceString("window.title"));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        instance.dispose();
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(ControlExample.getResourceString(key), args);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    private void initResources() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        ImageData source = new ImageData(clazz2.getResourceAsStream(imageLocations[i]));
                        ImageData mask = source.getTransparencyMask();
                        this.images[i] = new Image(null, source, mask);
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        String error = resourceBundle != null ? ControlExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    private void freeResources() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                Image image = this.images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            this.images = null;
        }
    }
}

