/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.fileviewer;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.examples.fileviewer.FileViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

class IconCache {
    public final int shellIcon = 0;
    public final int iconClosedDrive = 1;
    public final int iconClosedFolder = 2;
    public final int iconFile = 3;
    public final int iconOpenDrive = 4;
    public final int iconOpenFolder = 5;
    public final int cmdCopy = 6;
    public final int cmdCut = 7;
    public final int cmdDelete = 8;
    public final int cmdParent = 9;
    public final int cmdPaste = 10;
    public final int cmdPrint = 11;
    public final int cmdRefresh = 12;
    public final int cmdRename = 13;
    public final int cmdSearch = 14;
    public final String[] stockImageLocations = new String[]{"generic_example.gif", "icon_ClosedDrive.gif", "icon_ClosedFolder.gif", "icon_File.gif", "icon_OpenDrive.gif", "icon_OpenFolder.gif", "cmd_Copy.gif", "cmd_Cut.gif", "cmd_Delete.gif", "cmd_Parent.gif", "cmd_Paste.gif", "cmd_Print.gif", "cmd_Refresh.gif", "cmd_Rename.gif", "cmd_Search.gif"};
    public Image[] stockImages;
    public final int cursorDefault = 0;
    public final int cursorWait = 1;
    public Cursor[] stockCursors;
    private Hashtable iconCache;
    static /* synthetic */ Class class$0;

    public void initResources(Display display) {
        if (this.stockImages == null) {
            this.stockImages = new Image[this.stockImageLocations.length];
            int i = 0;
            while (i < this.stockImageLocations.length) {
                Image image = this.createStockImage(display, this.stockImageLocations[i]);
                if (image == null) {
                    this.freeResources();
                    throw new IllegalStateException(FileViewer.getResourceString("error.CouldNotLoadResources"));
                }
                this.stockImages[i] = image;
                ++i;
            }
        }
        if (this.stockCursors == null) {
            Cursor[] cursorArray = new Cursor[2];
            cursorArray[1] = new Cursor((Device)display, 1);
            this.stockCursors = cursorArray;
        }
        this.iconCache = new Hashtable();
    }

    public void freeResources() {
        Image image;
        if (this.stockImages != null) {
            int i = 0;
            while (i < this.stockImages.length) {
                image = this.stockImages[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            this.stockImages = null;
        }
        if (this.iconCache != null) {
            Enumeration it = this.iconCache.elements();
            while (it.hasMoreElements()) {
                image = (Image)it.nextElement();
                image.dispose();
            }
        }
    }

    private Image createStockImage(Display display, String path) {
        try {
            ImageData imageData;
            InputStream stream;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.examples.fileviewer.IconCache");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((stream = clazz.getResourceAsStream(path)) != null && (imageData = new ImageData(stream)) != null) {
                ImageData mask = imageData.getTransparencyMask();
                return new Image((Device)display, imageData, mask);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Image getIconFromProgram(Program program) {
        Image image = (Image)this.iconCache.get(program);
        if (image == null) {
            ImageData imageData = program.getImageData();
            if (imageData != null) {
                image = new Image(null, imageData, imageData.getTransparencyMask());
                this.iconCache.put(program, image);
            } else {
                image = this.stockImages[3];
            }
        }
        return image;
    }
}

