/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.pm.FATTRS;

public final class Font {
    private FATTRS handle;
    private long handleStamp;
    private Device device;

    Font() {
    }

    public Font(Device device, FontData fd) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, fd);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Font(Device device, String name, int height, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (name == null) {
            SWT.error(4);
        }
        this.init(device, new FontData(name, height, style));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new FontData[]{FontData.pm_new(this.handle)};
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    void init(Device device, FontData fd) {
        if (fd == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = new FATTRS();
        this.handle.fm_szFamilyname = fd.name;
        this.handle.height = fd.height;
        this.handle.fm_usWeightClass = (short)((fd.style & 1) != 0 ? 7 : 5);
        this.handle.fm_fsSelection = (fd.style & 2) != 0 ? (short)1 : 0;
        System.arraycopy(fd.szFacename.getBytes(), 0, this.handle.szFacename, 0, Math.min(31, fd.szFacename.length()));
        this.handle.fsSelection = fd.fsSelection;
        this.handleStamp = device.matchFont(this.handle, true);
    }

    public FATTRS internal_get_handle() {
        this.handleStamp = this.device.matchFont(this.handle, false);
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.hashCode() + "}";
    }

    public static Font pm_new(Device device, FATTRS fa) {
        if (device == null) {
            device = Device.getDevice();
        }
        Font font = new Font();
        font.device = device;
        font.handle = fa;
        font.handleStamp = device.fontCacheStamp;
        return font;
    }
}

