/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell parent) {
        this(parent, 0);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int blue;
        int green;
        int red;
        int color = 0;
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        Display display = this.parent.getDisplay();
        PSZ pszTitle = new PSZ("Choose Color");
        if (this.rgb != null) {
            red = this.rgb.red << 16 & 0xFF0000;
            green = this.rgb.green << 8 & 0xFF00;
            blue = this.rgb.blue & 0xFF;
            color = red | green | blue;
        }
        this.rgb = null;
        color = OS.WinEditColorDlg(1, hwndOwner, color, pszTitle);
        System.out.println("color = " + Integer.toHexString(color));
        if (color != -255) {
            red = color >> 16 & 0xFF;
            green = color >> 8 & 0xFF;
            blue = color & 0xFF;
            this.rgb = new RGB(red, green, blue);
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

