/**+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
* Generator   : PPWIZARD version 17.308
*             : FREE tool for Windows, OS/2, DOS and UNIX by Dennis Bareis (dbareis@gmail.com)
*             : http://dennisbareis.com/ppwizard.htm
* Time        : Saturday, 4 Nov 2017 11:03:36am
* Input File  : D:\DBAREIS\Projects\MultiOs\PPWIZARD\ppwizard.x
* Output File : D:\DBAREIS\Projects\MultiOs\PPWIZARD\out\ppwizard.rex
*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*/

if arg(1)="!CheckSyntax!" then exit(21924)

PgmVersion="17.308"
SupportedReginaVersions='2.0, 2.2, 3.0, 3.0.1 or 3.0BETA2, 3.2(MT), 3.3(MT)'
RecommendedReginaVersions='3.3(MT)'
CheckAddressCmdCnt=0
TrapHandler=''
RedirMethod=''
call ConsoleWriteAllowed 'Y'
call InitScreenHandling2Off
call InitCommandLineOptions arg(1)
call InitConsoleOutputVarsPass1
PpwDoing='Initializing'
Dummy=time('Reset')
b2rNewSingleQuote="' || " || '"' || "'" || '" || ' || "'"
b2rAllHexCodes=''
b2rAllAsciiCodes=''
do b2rCharCode=0 to 31
b2rAllHexCodes=b2rAllHexCodes||d2c(b2rCharCode)
end
do b2rCharCode=32 to 126
b2rAllAsciiCodes=b2rAllAsciiCodes||d2c(b2rCharCode)
end
do b2rCharCode=127 to 255
b2rAllHexCodes=b2rAllHexCodes||d2c(b2rCharCode)
end
signal EndBIN2REXPXh

_QuoteAscii:
b2rAscii2Quote=arg(1)
if pos("'",b2rAscii2Quote)=0 then
return("'" || b2rAscii2Quote || "'")
else
do
if pos('"',b2rAscii2Quote)=0 then
return('"' || b2rAscii2Quote || '"')
else
do
return("'" || ReplaceString(b2rAscii2Quote, "'", b2rNewSingleQuote) || "'")
end
end

_FormatHex:
b2rHexString=arg(1)
b2rLengthHex=length(b2rHexString)
b2rFormattedHex="'"
if b2rLengthHex>7 then
do
b2rLeft1=left(b2rHexString,1)
b2rLeft1Pos=verify(b2rHexString,b2rLeft1)
if b2rLeft1Pos=0 then
return( "copies('" || c2x(b2rLeft1) || "'x, " || b2rLengthHex || ")" )
else
do
if b2rLeft1Pos>7 then
do
b2rFormattedHex="copies('" || c2x(b2rLeft1) || "'x, " || b2rLeft1Pos-1 || ") || '"
b2rHexString=substr(b2rHexString,b2rLeft1Pos)
b2rLengthHex=b2rLengthHex-(b2rLeft1Pos-1)
end
end
end
do b2rCharPosn=1 to b2rLengthHex
if(b2rCharPosn//8)=1 then
do
if b2rCharPosn<>1 then
b2rFormattedHex=b2rFormattedHex|| ' '
end
b2rFormattedHex=b2rFormattedHex||c2x(substr(b2rHexString,b2rCharPosn,1))
end
b2rFormattedHex=b2rFormattedHex|| "'x"
return(b2rFormattedHex)

_QuoteAsciiBreakIfRequired:
qabAscii=arg(1)
qabLength=length(qabAscii)
qabReturn=''
do while qabLength>256
qabLeft=left(qabAscii,256)
qabAscii=substr(qabAscii,256+1)
qabLength=qabLength-256
if qabReturn='' then
qabReturn=_QuoteAscii(qabLeft)
else
qabReturn=qabReturn|| " || " ||_QuoteAscii(qabLeft)
end
if qabLength=0 then
return(qabReturn)
else
do
if qabReturn='' then
return(_QuoteAscii(qabAscii))
else
return(qabReturn|| " || " ||_QuoteAscii(qabAscii))
end

_FormatHexBreakIfRequired:
fhbHex=arg(1)
fhbLength=length(fhbHex)
fhbReturn=''
do while fhbLength>80
fhbLeft=left(fhbHex,80)
fhbHex=substr(fhbHex,80+1)
fhbLength=fhbLength-80
if fhbReturn='' then
fhbReturn=_FormatHex(fhbLeft)
else
fhbReturn=fhbReturn|| " || " ||_FormatHex(fhbLeft)
end
if fhbLength=0 then
return(fhbReturn)
else
do
if fhbReturn='' then
return(_FormatHex(fhbHex))
else
return(fhbReturn|| " || " ||_FormatHex(fhbHex))
end

BIN2REXP:
call BIN2REXP_START
b2rValue=arg(1)
b2rValueLength=length(b2rValue)
if b2rValueLength=0 then
call BIN2REXP_ONEBIT '""'
else
do
do while b2rValue\==''
b2rEndAsciiPos=verify(b2rValue,b2rAllAsciiCodes)
if b2rEndAsciiPos=0 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(b2rValue)
b2rValue=''
end
else
do
if b2rEndAsciiPos<>1 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(left(b2rValue,b2rEndAsciiPos-1))
b2rValue=substr(b2rValue,b2rEndAsciiPos)
end
else
do
b2rEndBinaryPos=verify(b2rValue,b2rAllHexCodes)
if b2rEndBinaryPos=0 then
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(b2rValue)
b2rValue=''
end
else
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(left(b2rValue,b2rEndBinaryPos-1))
b2rValue=substr(b2rValue,b2rEndBinaryPos)
end
end
end
end
end
call BIN2REXP_END
return

EndBIN2REXPXh:
signal EndDUMPVARXh

DumpVarsInExpression:
dv_RexxExp=arg(1)
dv_Stem=translate(arg(2))
dv_VarHeading=arg(3)
dv_LineRoutine=arg(4)
if dv_Stem<> '' then
do
dv_AutoDump='N'
dv_StemDot=dv_Stem|| '.'
if symbol(dv_StemDot|| '0') = 'VAR' then
dv_VarCount=value(dv_StemDot|| '0')
else
do
call _DumpVarsLineOutput 'DumpVar: Could not find "' || dv_StemDot || '0' || '"'
return(0)
end
end
else
do
dv_AutoDump='Y'
dv_Stem='DV_VARLIST'
dv_StemDot=dv_Stem|| '.'
dv_VarCount=0
end
if dv_VarCount=0 then
dv_MaxVarLng=0
do while dv_RexxExp<> ''
parse value strip(dv_RexxExp, 'L')with dv_1stChar+1 dv_RexxExp
select
when datatype(dv_1stChar, 'S')then
do
dv_OneVar=dv_1stChar
do while dv_RexxExp<> ''
parse var dv_RexxExp dv_1stChar+1 dv_RexxExp
if datatype(dv_1stChar, 'S')then
dv_OneVar=dv_OneVar||dv_1stChar
else
do
dv_RexxExp=dv_1stChar||dv_RexxExp
leave
end
end
call _RememberDumpedVar dv_OneVar
if pos('.',dv_OneVar)<>0 then
do
do while dv_OneVar<> ''
parse var dv_OneVar dv_ThisBit '.' dv_OneVar
call _RememberDumpedVar dv_ThisBit
end
end
end
when dv_1stChar='"' | dv_1stChar = "'" then
do
dv_EndQuotePos=pos(dv_1stChar,dv_RexxExp)
if dv_EndQuotePos=0 then
dv_RexxExp=''
else
dv_RexxExp=substr(dv_RexxExp,dv_EndQuotePos+1)
end
otherwise
nop
end
end
call value dv_StemDot|| '0',dv_VarCount
if dv_AutoDump='Y' then
call DumpVarsInExpressionNow dv_Stem,dv_VarHeading,dv_LineRoutine
return(dv_VarCount)

DumpVarsInExpressionNow:
dv_StemDot=arg(1)|| '.'
dv_VarHeading=arg(2)
dv_LineRoutine=arg(3)
if symbol(dv_StemDot|| '0') = 'VAR' then
dv_VarCount=value(dv_StemDot|| '0')
else
do
call _DumpVarsLineOutput 'DumpVar: could not find "' || dv_StemDot || '0' || '"'
return(0)
end
if dv_VarCount<>0&dv_VarHeading<> '' then
do
call _DumpVarsLineOutput ''
call _DumpVarsLineOutput dv_VarHeading
call _DumpVarsLineOutput copies('~',length(dv_VarHeading))
end
dv_ShowVarLng=dv_MaxVarLng
if dv_MaxVarLng>30 then
dv_ShowVarLng=30
do dv_Index=1 to dv_VarCount
dv_OneVar=value(dv_StemDot||dv_Index)
if length(dv_OneVar)>=dv_ShowVarLng then
ShowVar=dv_OneVar
else
ShowVar=right(dv_OneVar,dv_ShowVarLng)
dv_OneVarValue=value(translate(dv_OneVar))
if datatype(dv_OneVarValue, 'N')=0 then
do
call BIN2REXP dv_OneVarValue
dv_OneVarValue=dv_Value
end
call _DumpVarsLineOutput ShowVar|| ' = ' ||dv_OneVarValue
end
return

_RememberDumpedVar:
dv_ThisVar=arg(1)
if symbol(dv_ThisVar)='VAR' then
do
dv_AlreadyHave='N'
dv_ThisVarUpper=translate(dv_ThisVar)
do dv_Index=1 to dv_VarCount
if dv_ThisVarUpper=translate(value(dv_StemDot||dv_Index))then
do
dv_AlreadyHave='Y'
leave
end
end
if dv_AlreadyHave='N' then
do
dv_VarCount=dv_VarCount+1
call value dv_StemDot||dv_VarCount,dv_ThisVar
if length(dv_ThisVar)>dv_MaxVarLng then
dv_MaxVarLng=length(dv_ThisVar)
end
end
return

_DumpVarsLineOutput:
if dv_LineRoutine='' then
call say arg(1)
else
interpret 'call ' || dv_LineRoutine || ' arg(1)'
return

BIN2REXP_START:
dv_Value=''
return

BIN2REXP_ONEBIT:
if dv_Value<> '' then
dv_Value=dv_Value|| ' || '
dv_Value=dv_Value||arg(1)
return

BIN2REXP_END:
return

EndDUMPVARXh:
HaveCapturedTrapDetails='N'
MacroBeingExpanded=''
LastLineAfterMacroRep=''
LastFileLine=''
LastLine=''
InterpretThisRexx=''
ErrorHookCount=0
ExitCuc.0=0
call RexxHookInit
signal on NOVALUE name SimpleRexxTrapUninitializedVariable
signal on SYNTAX name SimpleRexxTrapSyntaxError
TrapHandler='SIMPLE'
MyBaseHomeDir="http://dennisbareis.com/"
PgmHomePage=MyBaseHomeDir|| "ppwizard.htm"
PgmAuthorHomePage=MyBaseHomeDir|| "index.htm"
PgmAuthor="Dennis Bareis"
PgmAuthorEmail="dbareis@gmail.com"
ExpressionKilledUs=''
OptChar=''
SyntaxOkRc=21924
SyntaxOkText='!CheckSyntax!'
CopyrightDisplayed='N'
CurrentOutFile=''
CurrentOutLine=0
OutSyntaxMsg=''
OutSyntaxCmd=''
OutSyntaxRc=''
OutSyntaxCode=''
OutSyntaxErrLineMask=''
IncludeLevel=0
Warnings=0
LineSourceBeingProcessed='?'
OnExitSleepForOk=0
OnExitSleepForError=2
SleepSwitch='N'
if translate(strip(arg(1)))='DEBUG' then
call DisplayCopyright
/*
*REXSYSTM.XH Version 11.072 By Dennis Bareis
*http://dennisbareis.id.au/index.htm(dbareis@gmail.com)
*/
trace off
RexSystmRexxPgmName='?'
if '1' == 'F1'x then
RexIsAscii='N'
else
RexIsAscii='Y'
parse version RexVersionInfo
if pos('REGINA',translate(RexVersionInfo))<>0 then
do
RexWhich='REGINA'
parse value translate(RexVersionInfo)with . 'REGINA_' RexVerRegina ' '
RexVerRegina=translate(RexVerRegina, '.', '_')
end
else
do
RexVerRegina=''
if pos('REXX370',translate(RexVersionInfo))<>0 then
do
RexWhich='REXX370'
end
else
do
RexWhich='STANDARD_OS/2'
end
end
parse source RexSystemOpSys .
RexSystemOpSys=translate(RexSystemOpSys)
RexSystemOpSysREAL=RexSystemOpSys
if RexWhich='REGINA' then
do
if RexSystemOpSys="WIN32" then
parse value uname()with RexSystemOpSysREAL .
if RexSystemOpSys="UNIX" then
parse value uname()with RexSystemOpSysREAL .
RexSystemOpSysReal=translate(RexSystemOpSysReal)
end
if RexSystemOpSys="BEOS" then
RexSystemOpSys="UNIX"
if RexSystemOpSys="TSO" then
do
call syscalls 'ON'
RexSystemOpSys="UNIX"
end
RexSystmRexxPgmName=RexGetFullSourceName()
if RexIsAscii='N' then
do
RexEOL='15'x
end
else
do
if RexSystemOpSys="UNIX" then
RexEOL='0A'x
else
RexEOL='0D0A'x
end
if arg(2)<> '' then
call RexSystemFailure 'ARG(2) contains unexpected data of ' || arg(2) || '.'
if translate(strip(arg(1)))='DEBUG' then
do
call RexDumpSystemInfo
exit(0)
end
if RexWhich='STANDARD_OS/2' then
do
call RxFuncAdd 'SysSleep',        'RexxUtil', 'SysSleep'
call RxFuncAdd 'SysFileDelete',   'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysSearchPath',   'RexxUtil', 'SysSearchPath'
call RxFuncAdd 'SysFileTree',     'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call SetLocal
RexEnvVarPool='OS2ENVIRONMENT'
RexStdoutStream='STDOUT'
RexStderrStream='STDERR'
RexTmpFileCntr=random(90000)
end
else
do
OPTIONS 'NOEXT_COMMANDS_AS_FUNCS'
numeric digits 11
RexEnvVarPool='SYSTEM'
RexStdoutStream='<stdout>'
RexStderrStream='<stderr>'
end
if RexSystemOpSys<> "UNIX" then
do
RexDirChar='\'
RexOptionChar='/'
end
else
do
RexDirChar='/'
RexOptionChar='-'
end
signal REXSYSTM_1

RexDumpSystemInfo:
say 'Program Name  : ' ||RexSystmRexxPgmName
say 'Op System     : ' ||RexSystemOpSys
say 'Rexx Ver      : ' ||RexVersionInfo
say 'Which System  : ' ||RexWhich
if RexWhich='REGINA' then
say 'regina uname(): ' ||uname()
return

RexNeedReginaWorkAround:
if RexWhich='STANDARD_OS/2' then
return('N')
else
return('Y')

RexGetFullSourceName:
parse source . . TmpRexxSrc
if RexWhich='REGINA' then
TmpRexxSrc=_FileQueryExists(strip(TmpRexxSrc))
if RexSystemOpSysREAL="TSO" then
do
TmpRexxSrc=word(TmpRexxSrc,1)
TmpRexxSrc=_FileQueryExists(TmpRexxSrc)
end
if TmpRexxSrc='' then
call RexSystemFailure 'Could not determine the name of the rexx program!'
return(TmpRexxSrc)

RexGetNameOfTmpDir:call TRACE "OFF"
TmpDir=strip(GetEnv('REXSYSTM_TMP'))
if TmpDir='' then
TmpDir=strip(GetEnv('TMP'))
if TmpDir='' then
TmpDir=strip(GetEnv('TEMP'))
if TmpDir='' then
do
if RexSystemOpSys="UNIX" then
TmpDir='/tmp'
end
if right(TmpDir,1)==RexDirChar then
TmpDir=left(TmpDir,length(TmpDir)-1)
if RexWhich='REXX370' then
do
if TmpDir="SYSTEM" then
TmpDir="TMP"
end
return(TmpDir)

RedirectStdOutAndErr2:
if RedirMethod<> '' then
do
select
when RedirMethod="@bash" then
return(' > "' || arg(1) || '" 2>&1')
when RedirMethod="@csh" then
return(' >& "' || arg(1) || '"')
otherwise
do
r12Meth=RedirMethod
r12Pos=pos('{?}',r12Meth)
do while r12Pos<>0
r12Meth=left(r12Meth,r12Pos-1)||arg(1)||substr(r12Meth,r12Pos+3)
r12Pos=pos('{?}',r12Meth)
end
end
end
return(' ' ||r12Meth)
end
if RexSystemOpSys="DOS" | RexSystemOpSysREAL = "WIN95" | RexSystemOpSysREAL = "WIN98" | RexSystemOpSysREAL = "WINME" then
do
return(' >' ||arg(1))
end
else
do
return(' > "' || arg(1) || '" 2>&1')
end

NameOfNulDevice:
if RexSystemOpSys="UNIX" then
return('/dev/null')
else
return('nul')

AllCmdOutput2Nul:
return(RedirectStdOutAndErr2(NameOfNulDevice()))

AddressCmd:call TRACE "OFF"
SysCmd2Exec=arg(1)
if RexWhich='STANDARD_OS/2' then
SysCmd2Exec='@' ||SysCmd2Exec
call DebugAddressCmdBefore SysCmd2Exec
SysCmd2Exec
SysCmdRc=Rc
FileIndex=2
SysCmdFile=arg(FileIndex)
do while SysCmdFile<> ''
call DebugAddressCmdOutput SysCmdFile, 'H1'
call DebugAddressCmdOutput copies('~', length(SysCmdFile)), 'H2'
if _FileQueryExists(SysCmdFile)='' then
call DebugAddressCmdOutput '*File does not exist*',     '!'
else
do
SysCmdLine=0
call _FileClose SysCmdFile
do while lines(SysCmdFile)<>0
SysCmdLine=SysCmdLine+1
call DebugAddressCmdOutput linein(SysCmdFile),SysCmdLine
end
call _FileClose SysCmdFile
end
FileIndex=FileIndex+1
SysCmdFile=arg(FileIndex)
end
call DebugAddressCmdAfter SysCmdRc
Rc=SysCmdRc
return(SysCmdRc)

_filespec:call TRACE "OFF"
fsCmd=translate(arg(1))
select
when fsCmd='D' | fsCmd = 'DRIVE' then
do
if RexSystemOpSys="UNIX" then
return('')
fsPos=pos(':',arg(2))
if fsPos=0 then
return('')
else
return(left(arg(2),fsPos))
end
when fsCmd='P' | fsCmd = 'PATH' then
do
fsStartWith=substr(arg(2),length(_filespec('D',arg(2)))+1)
fsPos=lastpos(RexDirChar,fsStartWith)
if fsPos=0 then
return('')
else
return(left(fsStartWith,fsPos))
end
when fsCmd='N' | fsCmd = 'NAME' then
do
return(substr(arg(2),length(_filespec('L',arg(2)))+1))
end
when fsCmd='L' | fsCmd = 'LOCATION' then
do
return(_filespec('D', arg(2)) || _filespec('P',arg(2)))
end
when fsCmd='S' | fsCmd = 'SLASHLESS' then
do
fsPos=_filespec('L',arg(2))
if right(fsPos,1)=RexDirChar then
fsPos=left(fsPos,length(fsPos)-1)
return(fsPos)
end
when fsCmd='E' | fsCmd = 'EXTN' then
do
fsExtnName=_filespec('N',arg(2))
fsDotPos=lastpos('.',fsExtnName)
if fsDotPos=0 then
return('')
else
return(substr(fsExtnName,fsDotPos+1))
end
when fsCmd='W' | fsCmd = 'WITHOUTEXTN' then
do
fsDotPos=lastpos('.',arg(2))
if fsDotPos=0 then
return(arg(2))
else
return(left(arg(2),fsDotPos-1))
end
when fsCmd='B' | fsCmd = 'BASENAME' then
do
return(_filespec('W', _filespec('N',arg(2))))
end
otherwise
call RexSystemFailure 'Unknown _filespec() command of "' || arg(1) || '"'
end
return

_SysSleep:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
do
call SysSleep arg(1)
return
end
call sleep arg(1)
return

_SysFileTree:call TRACE "OFF"
a!Mask=arg(1)
a!Stem=arg(2)
if pos('D',arg(3))<>0 then
a!Type='D'
else
a!Type='F'
if RexWhich='STANDARD_OS/2' then
do
a!P3=a!Type|| 'O'
if pos('S',arg(3))<>0 then
a!P3=a!P3|| 'S'
return(SysFileTree(a!Mask,a!Stem,a!P3))
end
a!TmpFile=RexGetTmpFileName()
if RexSystemOpSys<> "UNIX" then
do
a!Cmd='dir /B '
if pos('S',arg(3))<>0 then
a!Cmd=a!Cmd|| "/S "
if a!Type='F' then
a!Cmd=a!Cmd|| "/A-D "
else
a!Cmd=a!Cmd|| "/AD "
if RexSystemOpSys="DOS" then
a!CmdMask=a!Mask
else
a!CmdMask='"' || a!Mask || '"'
a!Cmd=a!Cmd||a!CmdMask||RedirectStdOutAndErr2(a!TmpFile)
end
else
do
a!Cmd='find ' || _filespec('L', a!Mask) || ' '
if RexSystemOpSysREAL<> "FREEBSD" & RexSystemOpSysREAL <> "OPENBSD" & RexSystemOpSysREAL <> "Darwin" & RexSystemOpSysREAL <> "TSO" then
a!Cmd=a!Cmd|| '-noleaf '
if pos('S',arg(3))=0 then
do
if RexSystemOpSysREAL="OPENBSD" | (RexSystemOpSysREAL <> "FREEBSD" & RexSystemOpSysREAL <> "Darwin" & RexSystemOpSysREAL <> "TSO")then
a!Cmd=a!Cmd|| '-maxdepth 1 '
else
a!Cmd=a!Cmd|| '-prune '
end
if a!Type='F' then
a!Cmd=a!Cmd|| "-type f "
else
a!Cmd=a!Cmd|| "-type d "
stfSName=_filespec('N',a!Mask)
if stfSName<> '' then
a!Cmd=a!Cmd|| '-name "' || stfSName || '"'
a!Cmd=a!Cmd||RedirectStdOutAndErr2(a!TmpFile)
end
Rc=AddressCmd(a!Cmd,a!TmpFile)
LastSlash=lastpos(RexDirChar,a!Mask)
call _FileClose a!TmpFile
a!FileCnt=0
do while lines(a!TmpFile)<>0
a!AFile=linein(a!TmpFile)
if a!AFile='' | a!AFile = '.' | a!AFile = '..' then
iterate
if RexSystemOpSys="UNIX" & a!Type = 'D' then
do
if a!AFile=_filespec('L',a!Mask)then
iterate
end
if LastSlash<>0 then
do
if pos(RexDirChar,a!AFile)==0 then
a!AFile=left(a!Mask,LastSlash)||a!AFile
end
if a!Type='F' then
do
a!AFile=_FileQueryExists(a!AFile)
if a!AFile='' then
iterate
end
else
do
if RexWhich='REGINA' then
do
if DirQueryExists(a!AFile)='' then
iterate
end
else
do
if pos(' ',a!AFile)<>0 then
iterate
end
end
a!FileCnt=a!FileCnt+1
call _valueS a!Stem|| '.' ||a!FileCnt,strip(a!AFile)
end
call _FileClose a!TmpFile
DeleteRc=_SysFileDelete(a!TmpFile)
call _valueS a!Stem|| '.0',a!FileCnt
return(0)

_SysFileDelete:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(SysFileDelete(arg(1)))
b!F=arg(1)
if RexSystemOpSys<> "DOS" then
b!F='"' || b!F || '"'
if RexSystemOpSys="DOS" | RexSystemOpSysREAL = "WIN95" | RexSystemOpSysREAL = "WIN98" | RexSystemOpSysREAL = "WINME" then
return(AddressCmd('if exist ' || b!F || ' del ' ||b!F||AllCmdOutput2Nul()))
else
do
if RexSystemOpSys="UNIX" then
return(AddressCmd('rm -f ' ||b!F||AllCmdOutput2Nul()))
else
return(AddressCmd('del ' ||b!F||AllCmdOutput2Nul()))
end

RexGetTmpFileName:call TRACE "OFF"
if arg(1)<> '' then
TmpFileM=arg(1)
else
do
if RexSystemOpSys<> "UNIX" then
TmpFileM='RSTM????.TMP'
else
do
TmpFileM=GetEnv('USER')
if TmpFileM='' then
TmpFileM=GetEnv('user')
if TmpFileM='' then
TmpFileM='?????.rstm'
else
TmpFileM=TmpFileM|| '_?????.rstm'
end
end
TmpFileM=RexGetNameOfTmpDir()||RexDirChar||TmpFileM
if RexWhich='STANDARD_OS/2' then
do
TmpFileF=SysTempFileName(TmpFileM)
if TmpFileF='' then
do
RexTmpFileCntr=RexTmpFileCntr+1
TmpFileF='C_' || right(RexTmpFileCntr, 6, '0') || '.TMP'
end
return(TmpFileF)
end
TmpRandom=right(time('S'),3)||random(99999)
TmpRandomAdd=0
do until _FileQueryExists(TmpFileA)=''
TmpRandomS=reverse(d2x(TmpRandom+TmpRandomAdd))
TmpRandomAdd=TmpRandomAdd+1
TmpFileA=TmpFileM
TmpWhich=1
QmPos=pos('?',TmpFileA)
do while QmPos<>0
TmpReplace=substr(TmpRandomS,TmpWhich,1)
TmpWhich=TmpWhich+1
if TmpReplace='' then
TmpWhich=1
else
do
TmpFileA=overlay(TmpReplace,TmpFileA,QmPos)
QmPos=pos('?',TmpFileA)
end
end
end
return(TmpFileA)

GetEnv:call TRACE "OFF"
if RexWhich<> 'REXX370' then
rsGetEnv=value(arg(1),,RexEnvVarPool)
else
do
rsGetEnv=''
end
if rsGetEnv=='' & arg(2) = 'Y' then
call RexSystemFailure 'Could not find the environment variable "' || arg(1) || '"'
call DebugGetEnv arg(1),rsGetEnv
return(rsGetEnv)

SetEnv:call TRACE "OFF"
if RexWhich<> 'REXX370' then
return(value(arg(1),arg(2),RexEnvVarPool))
else
do
return('')
end

_valueS:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(value(arg(1),arg(2)))
return(value(translate(arg(1)),arg(2)))

_valueG:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(value(arg(1)))
return(value(arg(1)))
/*
 * DB$STUBS - Keep indent (not so easy for comments)
 *            for this bit until finished!
 */

DirGetCurrent:
   return( directory() )

DirQueryExists:
   if  arg(1) = '' then
       return('')
   select
       when RexWhich = 'REGINA' | RexWhich = 'STANDARD_OS/2' then
       do
           c!CDir = directory()
           c!NewDir = directory(arg(1))
           call directory c!CDir
           return(c!NewDir)
       end
       when RexWhich = 'REXX370' then
       do
           /* DB$390 - return passed name (BAD! - ppwizard might fail in parts)
            */
           return(arg(1))
       end
       otherwise
       do
           return(arg(1))
       end
   end

_FileQueryExists:
   if  arg(1) = '' then
       return('')
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'c', 'query exists') )
   else
   do
       /* DB$390 - return passed name (BAD! - ppwizard might fail in parts)
       */
       return(arg(1))
   end

_FileQueryDateTime:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'c', 'query datetime') )
   else
   do
       /* DB$390 - Return valid but fixed value
       */
       return('01-01-01 12:00:00')
   end

FileQuerySize:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'c', 'query size') )
   else
   do
       /* DB$390 - Return valid but fixed value
       */
       return('219')
   end

FileOpenReadOnly:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'c', 'open read') )
   else
   do
       /* DB$390 - For now do nothing (so file opens read/write - so what)
       */
       return('')
   end

FileLineIn:
   parse arg d!F, d!Ln
   if  d!Ln = '' then
       return( LineIn(d!F) )
   else
   do
       if  RexWhich = 'REGINA' | d!LN = 1 then
           return( LineIn(d!F, d!Ln) )
       else
       do
           d!Cont = linein(d!F, 1);
           do d!l = 2 to d!LN
              d!Cont = linein(d!F);
           end
           return(d!Cont)
       end
   end

_FileClose:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'c', 'close') )
   else
   do
       /* DB$390 - Worth a try
       */
       call lineout arg(1)
       return('')
   end

FileState:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'State') )
   else
   do
       /* DB$390 - Stream Description
       */
       return('')
   end

FileDescription:
   if  RexWhich <> 'REXX370' then
       return( stream(arg(1), 'Description') )
   else
   do
       /* DB$390 - Stream Description
       */
       return('')
   end
/*
   REXSYSTM.XH - a few stream there (need to move stubs there)
   DirMake
   FileCharin    ?
   FileCharout   ?
   FileLineOut   ?
*/

REXSYSTM_1:
PpWizardPgmName=RexSystmRexxPgmName
PpWizardOpSysREAL=RexSystemOpSysREAL
PpWizardOpSys=RexSystemOpSys
WizName=translate(_filespec('name',PpWizardPgmName))
call InitScreenHandling
TryQuoteListSd="'" || '"'
TryQuoteListDs='"' || "'"
TryQuoteListAny=TryQuoteListDs|| '^~!@#$%&*-+=?/\|`:;._'
NullChar='00'x
TabChar='09'x
CrLf=RexEOL
if RexIsAscii='N' then
do
MarksNewLine='15'x
end
else
do
MarksNewLine='0A'x
TryQuoteListAny=TryQuoteListAny||xrange('DB'x, 'FE'x) || xrange('80'x, 'DA'x)
end
call CheckForNotBeingAbleToExecAnything
call InitConsoleOutputVarsPass2
if RexSystemOpSys<> "UNIX" then
call SetDebugChars '96,96,25',  'Y'
else
call SetDebugChars '34,-1,165', 'Y'
numeric digits 14
trace off
if RexSystemOpSys="UNIX" then
NewLineChars=MarksNewLine
else
NewLineChars=CrLf
MarksNewLineInHashDefine='<{nl}>'
MarksNewLineInHashDefine2=MarksNewLineInHashDefine||MarksNewLineInHashDefine
Ignore=0
LowerCase="abcdefghijklmnopqrstuvwxyz"
UpperCase="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
DecimalDigits="0123456789"
CharsLUN=LowerCase||UpperCase||DecimalDigits
DebugOnStuffOutputted='N'
WantedWarningRc=1
NotEqualInC='!' || '='
EofChar=d2c(26)
RexxCmtStart='/' || '*'
RexxCmtEnd='*' || '/'
TagSvNewLine='<' || '?NewLine>' ||MarksNewLine
signal Screen_2

InitScreenHandling2Off:
e!G_CtextAvail=''
e!BeepsAllow='N'
e!ColorAllow='N'
e!How2ChangeColors='A'
return

e!CfgColor:
parse arg e!Var1,e!DefC,e!DefA
if e!How2ChangeColors='C' then
e!D=e!DefC
else
e!D=e!DefA
e!Val1=CfgEnv('PPWIZARD_COLOR_' ||e!Var1,e!D)
e!Val1=ReplaceCurlyHexCodes(e!Val1)
call value 'e!COL_' ||e!Var1,e!Val1
return

InitScreenHandling:
if RexSystemOpSys="WIN32" then
do
e!Comspec=GetEnv("COMSPEC", "Y")
if pos('.COM',translate(e!Comspec))<>0 then
do
e!How2ChangeColors='A'
call DBG 'This windows version does not support use of CTEXT.EXE'
call DBG 'It can use ANSI.SYS if this is installed in "config.sys".'
end
else
do
e!G_CtextAvail=FileQueryExists(_filespec('L', PpWizardPgmName) || 'ctext.exe')
if e!G_CtextAvail='' then
do
e!How2ChangeColors=''
e!Cmt='not'
end
else
do
e!How2ChangeColors='C'
e!Cmt='found'
end
call DBG 'This windows version supports use of CTEXT.EXE (CTEXT.EXE ' || e!Cmt || ' in the PPWIZARD directory)'
end
end
call e!CfgColor "RESET",      "{white}",    "{x1B}[0m"
call e!CfgColor "DEFAULT",    "{brown}",    "{x1B}[0;33m"
call e!CfgColor "Error",      "{bred}",     "{x1B}[0;1;31m"
call e!CfgColor "Warning",    "{yellow}",   "{x1B}[0;1;33m"
call e!CfgColor "Info",       "{bwhite}",   "{x1B}[0;1m"
call e!CfgColor "HighLight",  "{bmagenta}", "{x1B}[0;1;35m"
call e!CfgColor "Title",      "{green}",    "{x1B}[0;32m"
call e!CfgColor "PromptText", "{bwhite}",   "{x1B}[0;1m"
call e!CfgColor "RexxTrace",  "{bmagenta}", "{x1B}[0;1;35m"
call e!CfgColor "RexxOther",  "{cyan}",     "{x1B}[0;36m"
call e!CfgColor "Summary",    "{white}",    "{x1B}[0m"
e!HowToBeep=d2c(7)
e!BeepsAllow='Y'
e!ColorAllow='N'
if RexSystemOpSys="OS/2" then
e!ColorAllow='Y'
else
do
if e!How2ChangeColors='C' then
e!ColorAllow='Y'
end
return

GetColorCode:
e!Cc='e!COL_' ||arg(1)
if symbol(e!Cc)<> 'VAR' then
do
if left(arg(1),1)='?' then
call e!CfgColor arg(1), '{white}', '{x1B}[0m'
else
CryAndDie('Invalid color category of "' || arg(1) || '" specified!')
end
return(e!CC)

Beeps:call TRACE "OFF"
if e!BeepsAllow='Y' then
do
e!C=arg(1)
if e!C='' then
e!C=1
do e!i=1 to e!C
call charout,e!HowToBeep
end
end
return("")

ColorCfg:call TRACE "OFF"
parse arg e!Var2,e!Val2
call DBG 'ColorCfg(' || e!Var2 || ') = ' ||e!Val2
e!Val2=ReplaceCurlyHexCodes(e!Val2)
e!S=GetColorCode(e!Var2)
e!P=value(e!S)
call value e!S,e!Val2
return(e!P)

ColorSet:call TRACE "OFF"
if e!ColorAllow='Y' then
do
e!C=arg(1)
if e!C='' then
e!C='DEFAULT'
e!S=GetColorCode(e!C)
if e!How2ChangeColors='C' then
do
e!Cmd='"' || e!G_CtextAvail || '" ' || value(e!S) || ' ' ||AllCmdOutput2Nul()
e!Comspec|| ' /c ' ||e!Cmd
end
else
do
if e!How2ChangeColors='A' then
call charout,value(e!S)
end
end
return

GetCtextFileName:
return(e!G_CtextAvail)

ColorAllow:call TRACE "OFF"
e!Rc=e!ColorAllow
e!ColorAllow=translate(arg(1))
if e!How2ChangeColors='' then
do
if e!ColorAllow='Y' then
do
e!ColorAllow='N'
call DBG 'User tried to turn on color changing but it is not possible to change colors...'
end
end
return(e!Rc)

BeepsAllow:call TRACE "OFF"
e!Rc=e!BeepsAllow
e!BeepsAllow=translate(arg(1))
return(e!Rc)

Screen_2:
signal Progress_3

RepCommonProgCodes:
parse arg f!T,f!F
f!CDU=UFile(DirGetCurrent())||RexDirChar
f!CDUL=length(f!CDU)
if pos('{.}',f!T)<>0 then
f!T=ReplaceString(f!T, '{.}',FileNameRelative(f!F))
f!T=ReplaceString(f!T, '{S}',  _filespec('N',f!F))
f!T=ReplaceString(f!T, '{L}',f!F)
f!T=ReplaceString(f!T, '{PM}',ProcessingMode)
return(f!T)

Making:call TRACE "OFF"
parse arg g!FN,MsgMode
if g!FN='' then
g!FN=CurrentOutFile
g!FFN=FileQueryExists(g!FN)
if g!FFN<> '' then
g!FN=g!FFN
call DBG 'Making(' || g!FN || ')'
call DBGIND 1
g!I=copies("  ", IncludeLevel+1) || ' '
g!T=OptionMsgMaking
g!Rexx=CfgMacro('HOOK_MSG_MAKING', '')
g!Rexx=PerformReplacementsInCmdsParameters(g!Rexx)
if g!Rexx<> '' then
do
MsgFile=g!FN
MsgInd=g!I
MsgText=g!T
call ExecRexxCmd g!Rexx
call DBGIND-1
return
end
call DBG 'Spec: ' ||g!T
if g!T='' then
do
call DBGIND-1
return
end
if pos('{R?}',g!T)<>0 then
do
if MsgMode<> 'R' then
g!T=ReplaceString(g!T, '{R?}', '')
else
do
call DBGIND-1
return
end
end
g!T=RepCommonProgCodes(g!T,g!FN)
call Line1 g!I||g!T
call DBGIND-1
return

Reading:call TRACE "OFF"
if arg(1)='' then
h!Ex=0
else
h!Ex=1
call ReadingI arg(1),,h!Ex
return

ReadingI:
parse arg i!FFN,i!Frag,i!Ex
call DBG 'Reading(' || i!FFN || ')'
call DBGIND 1
if i!FFN='' then
i!FFN=IncludeFileName
if i!Frag='N' then
do
MsgFragSp=''
MsgFragS=''
MsgFragE=''
end
else
do
MsgFragSp=IncludeFragmentSpec
MsgFragS=IncludeFragmentS
MsgFragE=IncludeFragmentE
end
i!I=ReadingIndent(i!Ex)
i!T=OptionMsgReading
i!Rexx=CfgMacro('HOOK_MSG_READING', '')
i!Rexx=PerformReplacementsInCmdsParameters(i!Rexx)
if i!Rexx<> '' then
do
MsgFile=i!FFN
MsgInd=i!I
MsgText=i!T
call ExecRexxCmd i!Rexx
call DBGIND-1
return
end
call DBG 'Spec: ' ||i!T
if i!T='' then
do
call DBGIND-1
return
end
i!P=pos('{F?}',i!T)
if i!P<>0 then
do
if MsgFragSp='' then
i!T=left(i!T,i!P-1)
else
i!T=ReplaceString(i!T, '{F?}', '')
end
i!T=RepCommonProgCodes(i!T,i!FFN)
i!T=ReplaceString(i!T, '{F}',MsgFragSp)
i!T=ReplaceString(i!T, '{FS}',MsgFragS)
i!T=ReplaceString(i!T, '{FE}',MsgFragE)
call Line1 i!I||i!T
call DBGIND-1
return

ReadingIndent:
j!Ex=arg(1)
if j!Ex='' then j!Ex=0
return(copies("  ", IncludeLevel+j!Ex) || ' ')

UFile:
if RexSystemOpSys="UNIX" then
return(arg(1))
else
return(translate(arg(1)))

Progress_3:
LastSystemCmd="none"
LastSystemCmdFull="none"
LastSystemRc=999
signal System_4

ProcessSystem:
Rest=PerformReplacementsInCmdsParameters(arg(1))
Log2File=GetQuotedText(Rest, "Rest")
LastSystemCmd=GetQuotedRest(Rest)
select
when RexSystemOpSys="OS/2" then
CmdProc='CMD.EXE /c '
otherwise
CmdProc=''
end
LastSystemCmdFull=CmdProc||LastSystemCmd
DeleteFileAfter='N'
select
when translate(Log2File)='ASIS' then
Log2File=''
when Log2File='-' then
Log2File=NameOfNulDevice()
when Log2File='?' then
do
Log2File=RexGetTmpFileName('ps??????.PPW')
DeleteFileAfter='Y'
end
otherwise
nop
end
if Log2File<> '' then
LastSystemCmdFull=LastSystemCmdFull||RedirectStdOutAndErr2(Log2File)
LastSystemRc=AddressCmd(LastSystemCmdFull,Log2File)
if DeleteFileAfter='Y' then
call _SysFileDelete(Log2File)
return(0)

System_4:
signal stack_5

StackInitForBuild:
STK_CNT=0
return

_StkErrLine:
if StackErrorText='' then
StackErrorText=arg(1)
else
StackErrorText=StackErrorText||MarksNewLine||arg(1)
return

StackValidation:
call DBG "Validating the " || STK_CNT || " stack(s)"
call DBGIND+1
StackErrorText=''
k!Invalid=0
do k!S=1 to STK_CNT
k!ID=STK.k!S
k!Desc=value(k!ID|| '_DESC')
call DBG 'Validating: ' ||k!Desc
k!Lvl=value(k!ID|| '.0')
call DBGIND+1
if k!Lvl=0 then
call DBG 'OK'
else
do
k!Invalid=k!Invalid+1
call DBG 'There are ' || k!Lvl || ' items still on the stack!'
k!T='STACK "' || k!Desc || '" has ' || k!Lvl || ' errors'
call _StkErrLine ''
call _StkErrLine k!T
call _StkErrLine copies('~',length(k!T))
do k!Inv=1 to k!Lvl
call _StkErrLine 'Push # : ' ||k!Inv
call _StkErrLine 'Where  : ' || value(k!ID || '_LOCN.' ||k!Inv)
call _StkErrLine 'Doing  : ' || value(k!ID || '_DOING.' ||k!Inv)
call _StkErrLine ''
end
end
call DBGIND-1
end
if k!Invalid<>0 then
CryAndDie(StackErrorText||MarksNewLine|| 'There are ' || k!Invalid || ' stacks with incorrect nesting (details above).')
call DBGIND-1
return

StackPush:call TRACE "OFF"
parse arg l!Desc,l!What,l!Doing
l!ID='STK_' ||c2x(l!Desc)
if symbol(l!ID|| '.0') = 'VAR' then
l!L=value(l!ID|| '.0')+1
else
do
l!L=1
STK_CNT=STK_CNT+1
STK.STK_CNT=l!ID
call value l!ID|| '_DESC',l!Desc
end
call value l!ID|| '.0',l!L
call value l!ID|| '.' ||l!L,l!What
call value l!ID|| '_LOCN.' ||l!L,GetInputFileNameAndLine()
if l!Doing='' then
l!Doing=GetFileLineBeingProcessed()
call value l!ID|| '_DOING.' ||l!L,l!Doing
return

StackPop:call TRACE "OFF"
m!ID='STK_' ||c2x(arg(1))
if symbol(m!ID|| '.0') <> 'VAR' then
CryAndDie('Can''t pop the non-existant stack "' || arg(1) || '"')
m!L=value(m!ID|| '.0')
if m!L<=0 then
CryAndDie('Nothing on the stack "' || arg(1) || '"')
call value m!ID|| '.0',m!L-1
return(value(m!ID|| '.' ||m!L))

ProcessPush:
n!R=PerformReplacementsInCmdsParameters(arg(1))
n!Typ=translate(GetQuotedText(n!R, "n!R"))
if n!R="" then
do
call StackPush n!Typ, ''
end
else
do
do until n!R=''
n!I=GetQuotedText(n!R, "n!R")
select
when n!Typ='MACRO' then
do
call StackPush '#Push MACRO',MacroGet(n!I)
end
when n!Typ='REXXVAR' then
do
call StackPush '#Push REXXVAR',_valueG(n!I)
end
otherwise
CryAndDie('Unsupported #PUSH type of ' ||n!Typ)
end
end
end
return(0)

ProcessPop:
o!R=PerformReplacementsInCmdsParameters(arg(1))
o!Typ=translate(GetQuotedText(o!R, "o!R"))
if o!R="" then
do
call StackPop o!Typ
end
else
do
o!C=0
do until o!R=''
o!C=o!C+1
o!S.o!C=GetQuotedText(o!R, "o!R")
end
do o!I=o!C to 1 by-1
select
when o!Typ='MACRO' then
do
call MacroSet o!S.o!I,StackPop('#Push MACRO'), 'Y'
end
when o!Typ='REXXVAR' then
do
call _valueS o!S.o!I,StackPop('#Push REXXVAR')
end
otherwise
CryAndDie('Unsupported #POP type of ' ||o!Typ)
end
end
end
return(0)

stack_5:
call InitTransformationCode
signal Transfrm_6

InitTransformationCode:
TransformCodeLvl=0
return

ProcessTransform:
p!Do=arg(1)
if p!Do<> '' then
do
p!Do=PerformReplacementsInCmdsParameters(p!Do)
p!Do=GetQuotedText(p!Do)
end
if p!Do<> '' then
do
TransformCodeLvl=TransformCodeLvl+1
if OptionDebugOn='Y' then
call DBG 'Start of transformation block #' || TransformCodeLvl || ' - "' || p!Do || '"'
p!C=MacroGet(p!Do)
p!C=PerformReplacementsInCmdsParameters(p!C)
call StackPush "#transform Nesting",,"PPWIZARD's #transform command"
TransformCode.TransformCodeLvl=p!C
end
else
do
if OptionDebugOn='Y' then
call DBG "End of transformation block #" ||TransformCodeLvl
call StackPop "#transform Nesting"
TransformCodeLvl=TransformCodeLvl-1
end
return(0)

Transfrm_6:
signal NextId_7

InitNextId:
NextIdUnique=0
NextIdReplOn='N'
NextIdMarker='@' || '@'
NextIdMask='*_'
NextIdNewCounter=NextIdUnique
NextIdChars1st=LowerCase
NextIdCharsRst=LowerCase|| '!?_' ||DecimalDigits
NextIdNew=_GetNextIdPrefix()
NextIdUsed='N'
NextIdLocked=''
NextIdLockedAt=''
return

ProcessNextId:
q!P=arg(1)
if q!P='' then
call _NextIdInc
else
do
q!P=PerformReplacementsInCmdsParameters(q!P)
q!Cmd=GetQuotedText(q!P, 'q!P')
q!CmdU=translate(q!Cmd)
select
when q!CmdU='OFF' then
NextIdReplOn='N'
when q!CmdU='ON' then
NextIdReplOn='Y'
when q!CmdU='CHARS' then
do
call _DieIfLocked q!Cmd
NextIdChars1st=GetQuotedText(q!P, 'q!P')
NextIdCharsRst=GetQuotedRest(q!P)
NextIdNew=_GetNextIdPrefix()
end
when q!CmdU='LOCK' then
do
call _DieIfLocked q!Cmd
if q!P='' then
q!P='"?"'
NextIdLocked=GetQuotedRest(q!P)
NextIdLockedAt=CurrentSourceLocation()
if NextIdLocked='' then
CryAndDie('You must specify a KEY to lock Next ID incrementing.')
end
when q!CmdU='UNLOCK' then
do
if NextIdLocked='' then
CryAndDie('Not locked!')
if q!P='' then
q!P='"?"'
q!Key=GetQuotedRest(q!P)
if q!Key<>NextIdLocked then
CryAndDie('Incorrect key used, required "' || NextIdLocked || '"', 'Locking was done at ' ||NextIdLockedAt)
NextIdLocked=''
end
when q!CmdU='REPLACE' then
do
call _DieIfLocked q!Cmd
NextIdMarker=GetQuotedRest(q!P)
if NextIdMarker='' then
NextIdMarker='@' || '@'
end
when q!CmdU='MASK' then
do
call _DieIfLocked q!Cmd
NextIdMask=GetQuotedRest(q!P)
if NextIdMask='' then
NextIdMask='*_'
NextIdNew=_GetNextIdPrefix()
end
when q!CmdU='PUSH' then
do
q!Info=NextIdReplOn|| '00'x || NextIdMarker || '00'x || NextIdMask || '00'x || NextIdNew || '00'x || NextIdNewCounter || '00'x || NextIdUsed || '00'x || NextIdLocked || '00'x || NextIdLockedAt || '00'x || NextIdChars1st || '00'x||NextIdCharsRst
call StackPush "#NextId PUSH",q!Info
NextIdLocked=''
NextIdUsed='Y'
call _NextIdInc
NextIdReplOn='N'
end
when q!CmdU='POP' then
do
q!Info=StackPop("#NextId PUSH")
parse var q!Info NextIdReplOn '00'x NextIdMarker '00'x NextIdMask '00'x NextIdNew '00'x NextIdNewCounter '00'x NextIdUsed '00'x NextIdLocked '00'x NextIdLockedAt '00'x NextIdChars1st '00'x NextIdCharsRst
end
otherwise
CryAndDie('Unknown #NextID command of "' || q!Cmd || '"')
end
end
if OptionDebugOn='Y' then
do
if NextIdReplOn='N' then
q!T='off'
else
q!T='on'
q!I=NextIdLocked
if q!I='' then
q!I='unlocked'
else
q!I='locked (KEY = "' || NextIdLocked || '", locked at ' || NextIdLockedAt || ')'
call DBG '#NextID processing is turned ' ||q!T
call DBG '#NextID incrementing is ' ||q!I
call DBG 'If ON, any "' || NextIdMarker || '" strings will be replaced with "' || NextIdNew || '"'
end
return(0)

_NextIdInc:
call _DieIfLocked 'increment'
NextIdReplOn='Y'
if NextIdUsed='Y' then
do
NextIdUnique=NextIdUnique+1
NextIdNewCounter=NextIdUnique
NextIdNew=_GetNextIdPrefix()
end
return

_DieIfLocked:
if NextIdLocked<> '' then
CryAndDie('Operation (' || arg(1) || ') not allowed as #NextId ID is locked, KEY = "' || NextIdLocked || '"', 'Locking was done at ' ||NextIdLockedAt)
return

_GetNextIdPrefix:
r!Dec=NextIdNewCounter
r!LenLeading=length(NextIdChars1st)
r!LenTrailing=length(NextIdCharsRst)
r!1=''
r!P=''
do until r!Dec=0
if r!1=='' then
do
r!1=substr(NextIdChars1st,(r!Dec//r!LenLeading)+1,1)
r!Dec=r!Dec%r!LenLeading
end
else
do
r!P=substr(NextIdCharsRst,(r!Dec//r!LenTrailing)+1,1)||r!P
r!Dec=r!Dec%r!LenTrailing
end
end
r!P=ReplaceString(NextIdMask, '*',r!1||r!P)
NextIdUsed='N'
return(r!P)

NextId_7:
call InitINTERCEPTCode
signal Intercpt_8

InitINTERCEPTCode:
InterceptCode=''
InterceptStartLoc=''
InterceptOffMarker=''
return

ProcessIntercept:
RexxCode=arg(1)
if RexxCode<> '' then
do
RexxCode=PerformReplacementsInCmdsParameters(RexxCode)
RexxCode=GetQuotedText(RexxCode)
end
if RexxCode<> '' then
do
if OptionDebugOn='Y' then
call DBG 'Start of INTERCPT block "' || RexxCode || '"'
if InterceptCode<> '' then
CryAndDie("Already in tranformation block started at " ||InterceptStartLoc)
InterceptStartLoc=CurrentSourceLocation()
InterceptOffMarker=arg(2)
InterceptCode=MacroGet(RexxCode)
InterceptCode=PerformReplacementsInCmdsParameters(InterceptCode)
end
else
do
if OptionDebugOn='Y' then
call DBG "End of INTERCPT block"
if InterceptCode='' then
CryAndDie('We were not in a INTERCPT block!')
InterceptCode=''
end
return(0)

Intercpt_8:
OutputHoldLvl=0
call InitOutputHold
signal OutpHold_9

InitOutputHold:
HoldingOutput='N'
HeldOutput=''
OutpHoldStartLoc=''
return

OutputHoldPushAndClear:
OutputHoldLvl=OutputHoldLvl+1
OutHold_.OutputHoldLvl.!HoldingOutput=HoldingOutput
OutHold_.OutputHoldLvl.!HeldOutput=HeldOutput
OutHold_.OutputHoldLvl.!OutpHoldStartLoc=OutpHoldStartLoc
call InitOutputHold
return

OutputHoldPop:
HoldingOutput=OutHold_.OutputHoldLvl.!HoldingOutput
HeldOutput=OutHold_.OutputHoldLvl.!HeldOutput
OutpHoldStartLoc=OutHold_.OutputHoldLvl.!OutpHoldStartLoc
OutputHoldLvl=OutputHoldLvl-1
return

DieIfHoldingOutput:
if HoldingOutput='Y' then
CryAndDie('Missing #OutputHold (end)', 'Block started at ' ||OutpHoldStartLoc)
return

ProcessHashOutputHold:
OrexxRexx=arg(1)
if OrexxRexx='' then
do
if OptionDebugOn='Y' then
call DBG 'Start of hold output block'
if HoldingOutput='Y' then
CryAndDie("Already in hold output block started at " ||OutpHoldStartLoc)
call FlushQueuedOutput
HoldingOutput='Y'
OutpHoldStartLoc=CurrentSourceLocation()
end
else
do
if OptionDebugOn='Y' then
call DBG "End of hold output block - Held " || length(HeldOutput) || ' byte(s)'
if HoldingOutput='N' then
CryAndDie('We were not in a hold output block!')
call FlushQueuedOutput
OrexxRexx=PerformReplacementsInCmdsParameters(OrexxRexx)
OrexxRexx=GetQuotedText(OrexxRexx)
if translate(OrexxRexx)='DROP' then
HeldOutput=''
else
do
OutputModCode=MacroGet(OrexxRexx)
OutputModCode=PerformReplacementsInCmdsParameters(OutputModCode)
call ExecRexxCmd OutputModCode
end
if HeldOutput\=='' then
do
if OptionDebugOn='Y' then
call DBG 'Writing ' || length(HeldOutput) || ' byte(s) to output'
call FileCharOut CurrentOutFile,HeldOutput
end
call InitOutputHold
end
return(0)

OutpHold_9:
signal RexxHook_10

RexxHookSetBuildingParms:
parse arg HookBuildParmInput,HookBuildParmOutput,HookBuildParmTemplate
return

RexxHookInit:
RexxHookBefore=''
RexxHookAfter=''
RexxHookWarning=''
RexxHookError=''
RexxHookGetFileList=''
call RexxHookSetBuildingParms
return

RexxHookSet:
parse arg ThisCmd,s!Spec
parse var s!Spec s!W';'s!Rx
s!W=translate(s!W)
do until s!W=''
parse var s!W s!W1','s!W
rhDone='N'
if s!W1='' | abbrev("BEFORE",s!W1)then
do
rhDone='Y'
RexxHookBefore=s!Rx
end
if s!W1='' | abbrev("AFTER",s!W1)then
do
rhDone='Y'
RexxHookAfter=s!Rx
end
if s!W1='' | abbrev("WARNING",s!W1)then
do
rhDone='Y'
RexxHookWarning=s!Rx
end
if s!W1='' | abbrev("ERROR",s!W1)then
do
rhDone='Y'
RexxHookError=s!Rx
end
if s!W1='' | abbrev("GETFILELIST",s!W1)then
do
rhDone='Y'
RexxHookGetFileList=s!Rx
end
if rhDone='N' then
CryAndDie('The hook type of "' || s!W1 || '" is unknown')
end
return

CallHook:
parse arg CallHook,CallHookOkParmsOk,Parm1,Parm2,Parm3,Parm4
BuildDetailParms=', HookBuildParmInput, HookBuildParmOutput, HookBuildParmTemplate'
HookSpecificParms=', Parm1, Parm2, Parm3, Parm4'
select
when CallHook="WARNING" then
HookRexxCmd=RexxHookWarning
when CallHook="BEFORE" then
HookRexxCmd=RexxHookBefore
when CallHook="AFTER" then
HookRexxCmd=RexxHookAfter
when CallHook="ERROR" then
do
ErrorHookCount=ErrorHookCount+1
if ErrorHookCount>1 then
return
HookRexxCmd=RexxHookError
end
when CallHook="GETFILELIST" then
do
HookRexxCmd=RexxHookGetFileList
BuildDetailParms=''
end
end
SrcLineLoc=CurrentSourceLocation('')
if OptionDebugOn='Y' then
do
call DBG 'Calling hook: ' || CallHook || ' - ' ||HookRexxCmd
call DBGIND 1
end
HookCmd='HookRc =  "' || HookRexxCmd || '"("00.050", SrcLineLoc, "' || CallHook || '"' || BuildDetailParms || HookSpecificParms || ')'
HookRc='?'
signal ON SYNTAX NAME SyntaxErrorInHook
Interpret HookCmd
if OptionDebugOn='Y' then
call DBG 'Rc = ' ||HookRc
if abbrev(HookRc, 'OK:')=0 then
do
call DumpVarsInExpression HookCmd,, 'HOOK VARIABLES', 'Line1'
CryAndDie('Hook Command Failed: ' || HookCmd, "Hook's Return Code : " ||HookRc)
end
OkParms=substr(HookRc,4)
if OkParms<> '' & CallHookOkParmsOk <> 'Y' then
CryAndDie('OK parameters not allowed on "' || CallHook || '" hooks.')
if OptionDebugOn='Y' then
call DBGIND-1
return(OkParms)

SyntaxErrorInHook:
CryAndDie('Hook Cmd Failed: ' ||HookCmd)

RexxHook_10:
WarningSpecs=''
signal Warning_11

OutputWarningToScreen:
t!Code=strip( 'WARNING ' ||strip(arg(1)))
t!Txt=arg(2)
if IncludeLevel=0 then
LineText=''
else
LineText='(@' || AddCommasToDecimalNumber(IncludeLineNumber) || ')'
t!CodeTxt=t!Code|| ': ' ||t!Txt
t!Msg=LineText||t!CodeTxt
t!LookIn=translate(t!Msg)
t!Lst=WarningSpecs
do while t!Lst<> ''
parse var t!Lst t!Spec (PathDelimiterChar) t!Lst
t!Spec1=left(t!Spec,1)
t!SpecR=substr(t!Spec,2)
if t!Spec1<> '-' & t!Spec1 <> '+' & t!Spec1 <> '!' then
do
t!Spec1='-'
t!SpecR=t!Spec
t!Spec=t!Spec1||t!SpecR
end
if t!SpecR='' then
iterate
if t!SpecR='*' |pos(translate(t!SpecR),t!LookIn)<>0 then
do
if OptionDebugOn='Y' then
call DBG 'Warning matched the spec => ' ||t!Spec
select
when t!Spec1='!' then
do
if OptionDebugOn='Y' then
call DBG 'Normal Warning => ' ||t!Msg
leave
end
when t!Spec1='+' then
do
CryAndDie(t!CodeTxt,, 'This warning was promoted to a fatal error by "' || t!Spec || '"')
end
when t!Spec1='-' then
do
if OptionDebugOn='Y' then
call DBG 'Ignoring Warning => ' ||t!Msg
return
end
end
end
end
if RexxHookWarning<> '' then
do
t!Rc=translate(CallHook("WARNING", 'Y',t!Txt))
if t!Rc='IGNORE+' then
Warnings=Warnings+1
if t!Rc='IGNORE' | t!Rc = 'IGNORE+' then
do
if OptionDebugOn='Y' then
call DBG "HOOK said to drop warning: " ||t!Txt
return
end
if t!Rc<> '' then
CryAndDie('Unknown warning hook return code of: ' ||t!Rc)
end
call ColorSet 'WARNING'
call Line1 ReadingIndent()|| '  ' ||t!Msg
call ColorSet
Warnings=Warnings+1
return

WarnAboutDepreciatedFeature:
call OutputWarningToScreen 'DEP0', 'Replace OBSOLETE Feature ASAP -> ' ||arg(1)
return

ProcessHashWarning:
u!R=PerformReplacementsInCmdsParameters(arg(1))
u!Code=GetQuotedText(u!R, "u!R")
u!Txt=GetQuotedRest(u!R)
call OutputWarningToScreen u!Code,u!Txt
return(0)

WARNINGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'WARNINGS', 'Ignoring any warnings containing "' || WarningSpecs || '"'
return

WARNINGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'WARNINGS', 'Setting default ignore warnings to "' || Tags || '"'
Default4_WarningSpecs=Tags
return(0)
end
if Tags=='' then
Tags=Default4_WarningSpecs
if translate(Tags)=='NULL' then
Tags=''
WarningSpecs=Tags
call WARNINGS_DEBUG
return

WARNINGS_GET:
call WARNINGS_DEBUG
return(WarningSpecs)

Warning_11:
signal Tabs_12

TABS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'TABS', 'TABS is set to "' || OptionTabsString || '" (' || TabsMode || ')'
return

TABS_SET:
OptionTabsString=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'TABS', 'Setting default TABS to "' || OptionTabsString || '"'
DefaultTabsString=OptionTabsString
return(0)
end
if OptionTabsString=='' then
OptionTabsString=DefaultTabsString
WidthOfTab=0
OptionTabs=left(OptionTabsString,1)
select
when datatype(OptionTabsString, 'W')then
do
OptionTabs='E'
WidthOfTab=OptionTabsString
TabsMode='expanding tabs, fixed tab stop every ' || WidthOfTab || ' characters'
end
when OptionTabsString='WARNINGS' then
TabsMode='display warnings'
when OptionTabsString='IGNORE' then
TabsMode='ignore tabs, leave in place'
when OptionTabsString='TOSPACES' then
TabsMode='converting each tab to one space'
otherwise
CryAndDie('Invalid TABS option of "' || OptionTabsString || '"')
end
call TABS_DEBUG
return

TABS_GET:
call TABS_DEBUG
return(OptionTabsString)

Tabs_12:
SrTypePre=d2c(254)||d2c(174)
SrTypeSuf=d2c(175)
call SrInit
signal SR_TYPE_13

SrInit:
SrCaseIns=SrTypePre|| 'CI' ||SrTypeSuf
SrCaseIns_P=length(SrCaseIns)+1
SrFixed=SrTypePre|| 'FiX' ||SrTypeSuf
SrFixed_P=length(SrFixed)+1
return

CompareReplaceFixed:call TRACE "OFF"

CompareReplaceFixed2:
sr_FromOrig=arg(1)
sr_SSpec=arg(2)
sr_CaseInSens='N'
sr_From=sr_FromOrig
sr_From_L=length(sr_From)
if arg(3, 'E')=1 then
sr_NoMatch=sr_From
else
sr_NoMatch=0
sr_LSRemoved=0
sr_TSRemoved=0
do while sr_SSpec<> ''
parse var sr_SSpec sr_CmdChar +1 sr_SSpec
select
when sr_CmdChar='@' then
do
parse var sr_SSpec sr_Operator ',' sr_Posn '=' +1 sr_Delim +1 sr_CompWith (sr_Delim) sr_SSpec
sr_Length=length(sr_CompWith)
if datatype(sr_Posn, 'W')=0 then
CryAndDie("CompareReplaceFixed()", "The position must be a whole number, '" || sr_Posn || "' is invalid")
if sr_Posn<0 then
do
sr_Posn=sr_From_L+sr_Posn+1
if sr_Posn<1 then
return(sr_NoMatch)
end
if sr_CaseInSens='N' then
sr_bit=substr(sr_From,sr_Posn,sr_Length)
else
sr_bit=translate(substr(sr_From,sr_Posn,sr_Length))
select
when sr_Operator='=' then
srCompRc=sr_bit=sr_CompWith
when sr_Operator='<>' then
srCompRc=sr_bit<>sr_CompWith
when sr_Operator='==' then
srCompRc=sr_bit==sr_CompWith
when sr_Operator='\==' then
srCompRc=sr_bit\==sr_CompWith
when sr_Operator='<' then
srCompRc=sr_bit<sr_CompWith
when sr_Operator='>' then
srCompRc=sr_bit>sr_CompWith
when sr_Operator='<=' then
srCompRc=sr_bit<=sr_CompWith
when sr_Operator='>=' then
srCompRc=sr_bit>=sr_CompWith
otherwise
CryAndDie("CompareReplaceFixed()", "Unsupported operator of '" || sr_Operator || "' used", '', 'ONLY "=, <>, ==, \==, <, >, <=, >=" are supported!')
end
if srCompRc=0 then
return(sr_NoMatch)
end
when sr_CmdChar='!' then
do
parse var sr_SSpec sr_CmdChar2 +1 sr_SSpec
select
when sr_CmdChar2='B' | sr_CmdChar2 = 'L' | sr_CmdChar2 = 'T' then
do
if sr_CmdChar2='B' | sr_CmdChar2 = 'L' then
do
sr_OrigLength=sr_From_L
sr_From=strip(sr_From, 'L')
sr_From_L=length(sr_From)
if sr_OrigLength<>sr_From_L then
sr_LSRemoved=sr_OrigLength-sr_From_L
sr_FromOrig=strip(sr_FromOrig, 'L')
end
if sr_CmdChar2='B' | sr_CmdChar2 = 'T' then
do
sr_OrigLength=sr_From_L
sr_From=strip(sr_From, 'T')
sr_From_L=length(sr_From)
if sr_OrigLength<>sr_From_L then
sr_TSRemoved=sr_OrigLength-sr_From_L
sr_FromOrig=strip(sr_FromOrig, 'T')
end
end
when sr_CmdChar2='I' then
do
sr_From=space(sr_From)
sr_From_L=length(sr_From)
end
when sr_CmdChar2='S' then
sr_CaseInSens='N'
when sr_CmdChar2='i' then
sr_CaseInSens='Y'
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid "!" command of "' || sr_CmdChar2 || '"')
end
end
when sr_CmdChar='?' then
do
parse var sr_SSpec sr_Operator +1 sr_Delim +1 sr_LookFor (sr_Delim) sr_SSpec
if sr_CaseInSens='N' then
sr_Pos=pos(sr_LookFor,sr_From)
else
sr_Pos=pos(sr_LookFor,translate(sr_From))
if sr_Operator='=' then
do
if sr_Pos=0 then
return(sr_NoMatch)
end
else
do
if sr_Pos<>0 then
return(sr_NoMatch)
end
end
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid compare command of "' || sr_CmdChar || '"')
end
end
if arg(3, 'O')=1 then
return(1)
sr_RSpec=arg(3)
ReplaceCount=ReplaceCount+1
sr_output=''
do forever
parse var sr_RSpec sr_Before '@' sr_RSpec
sr_Output = sr_Output || sr_Before
if sr_RSpec=='' then
return(sr_Output)
parse var sr_RSpec sr_CmdChar +1 sr_RSpec
select
when sr_CmdChar='$' then
do
parse var sr_RSpec sr_Posn ',' sr_Length ';' sr_RSpec
if sr_Posn<0 then
do
sr_Posn=sr_From_L+sr_Posn+1
if sr_Posn<1 then
return(sr_From)
end
if sr_Length='*' then
sr_Output=sr_Output||substr(sr_FromOrig,sr_Posn)
else
sr_Output=sr_Output||substr(sr_FromOrig,sr_Posn,sr_Length)
end
when sr_CmdChar='=' then
do
parse var sr_RSpec sr_Delim +1 sr_Exec (sr_Delim) sr_RSpec
CompareString=sr_From
call ExecRexxCmd('sr_Output = sr_Output || ' ||sr_Exec)
end
when sr_CmdChar='@' then
sr_Output=sr_Output|| '@'
when sr_CmdChar='<' then
sr_Output=sr_Output||copies(' ',sr_LSRemoved)
when sr_CmdChar='>' then
sr_Output=sr_Output||copies(' ',sr_TSRemoved)
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid replace command of "' || sr_CmdChar || '"')
end
end

SR_TYPE_13:
SpellDelChars=d2c(9)|| ',.=:;<>&-%()!/~' || '?#${}[]"'
SpellDictFileCount=0
SpellDelChangeCount=0
SpellingPrompts='N'
SpellShowEachError='N'
SpellingAddFile=''
SpellWordCount=0
SpellMistakeCount=0
SpellingAddCount=0
BadlySpellWordCount=0
CheckSpelling='N';
signal SPELLING_14

PrepareSpellingForThisBuild:
if OptionCompleteAddToToDepFile='Y' then
do
do DictIndex=1 to SpellDictFileCount
call AddInputFileToDependancyList SpellDictFile.DictIndex,,SpellDictTime.DictIndex
end
end
Drop ?BADWORDEB.
return

LoadSpellingDictionary:
DictFileS=arg(1)
call DBG_SPELLING 'User wants the dictionary "' || DictFileS || '"'
DictFile=FindFile(DictFileS, 'dictionary')
call DBG_SPELLING 'Loading "' || DictFile || '"'
SpellDictFileCount=SpellDictFileCount+1
SpellDictFile.SpellDictFileCount=DictFile
SpellDictTime.SpellDictFileCount=GetFileDateTimeButDontWarnOnError(DictFile)
call FileClose DictFile, 'N'
do while lines(DictFile)<>0
ThisWord=translate(strip(linein(DictFile)))
if ThisWord='' then
iterate
if left(ThisWord,1)=';' then
iterate
if left(ThisWord,1)<> '$' then
do
SpellWordCount=SpellWordCount+1
call _valueS '?SPELLDICT.?' || c2x(ThisWord), ''
end
else
do
parse var ThisWord DictCmd Rest
select
when DictCmd='$MISTAKE' then
do
parse var Rest SpeltWrong SpeltCorrectly .
SpellMistakeCount=SpellMistakeCount+1
call _valueS '?SPELLERR.?' ||c2x(SpeltWrong),SpeltCorrectly
end
when DictCmd='$DELIMITERS' then
do
call DBG_SPELLING 'Dictionary is changing spelling delimiters'
SpellDelChangeCount=SpellDelChangeCount+1
if SpellDelChangeCount>1 then
call OutputWarningToScreen 'SPL9', 'Spell check delimiters already modified!'
call ExecRexxCmd "SpellDelChars = " ||strip(Rest)
end
otherwise
do
SpellWordCount=SpellWordCount+1
call _valueS '?SPELLDICT.?' || c2x(ThisWord), ''
end
end
end
end
call FileClose DictFile
call DBG_SPELLING 'Now have ' || AddCommasToDecimalNumber(SpellWordCount) || ' word(s) in dictionary and ' || AddCommasToDecimalNumber(SpellMistakeCount) || ' common mistakes noted!'
CheckSpelling='Y';
return

SpellCheckOneLine:
SpellLine=space(arg(1))
if 1=1 then
do
RightBit=SpellLine
SpellLine=''
StartPos=pos('<',RightBit)
do while StartPos<>0
EndPos=pos('>',RightBit,StartPos+1)
if EndPos=0 then
EndPos=StartPos
SpellLine=SpellLine||left(RightBit,StartPos-1)|| ' '
RightBit=substr(RightBit,EndPos+1)
StartPos=pos('<',RightBit)
end
SpellLine=SpellLine||RightBit
if SpellLine='' then
return
end
SpellLine=translate(translate(SpellLine), '', SpellDelChars, ' ')
do WordIndex=1 to words(SpellLine)
ThisWord=Word(SpellLine,WordIndex)
if left(ThisWord,1)="'" then
ThisWord=substr(ThisWord,2)
if right(ThisWord,1)="'" then
ThisWord=left(ThisWord,length(ThisWord)-1)
if length(ThisWord)>100 then
do
if OptionDebugOn='Y' then
call DBG_SPELLING 'Word too big to safely handle "' || ThisWord || '"'
iterate
end
ThisWordC2X=c2x(ThisWord)
if SpellMistakeCount<>0 then
do
MistakeId='?SPELLERR.?' ||ThisWordC2X
if symbol(MistakeId)='VAR' then
do
if SpellShowEachError='Y' then
ShowThisError='Y'
else
do
DuplicatedId='?BADWORDEB.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
ShowThisError='N'
else
do
ShowThisError='Y'
call _valueS DuplicatedId, ''
end
end
if ShowThisError='Y' then
do
CorrectWord=_valueG(MistakeId)
if CorrectWord='' then
call OutputWarningToScreen 'SPL0', 'Common Mistake: ' ||ThisWord
else
call OutputWarningToScreen 'SPL0', 'Common Mistake: ' || ThisWord || ' (use "' || CorrectWord || '" instead)'
end
iterate
end
end
if SpellWordCount=0&SpellingPrompts='N' then
iterate
ValidId='?SPELLDICT.?' ||ThisWordC2X
if symbol(ValidId)<> 'VAR' then
do
if datatype(ThisWord)<> 'NUM' then
do
WordWarningId=''
WordWarningMsg=''
if SpellingPrompts<> 'N' then
do
DuplicatedId='?BADWORDPI.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
do
BadIndex=_valueG(DuplicatedId)
if BadIndex<> '' then
do
WordWarningId='SPL1'
WordWarningMsg='Added "' || ThisWord || '" to "' || SpellingAddFile || '"'
SpellingAddOccurs.BadIndex=SpellingAddOccurs.BadIndex+1
end
end
else
do
DuplicatedIdValue=''
if SpellingAddFile<> '' & SpellingPrompts <> 'N' then
do
if SpellingPrompts='OK' then
UserResp='Y'
else
do
do until UserResp='Y' | UserResp = 'N' | UserResp = 'Q' | UserResp = 'A'
call ColorSet 'PromptText'
call charout,ThisWord|| ' <- OK (Yes/yes All/No/Quit asking)?'
call ColorSet
UserResp=translate(left(linein(),1))
end
end
if UserResp='A' then
do
SpellingPrompts='OK'
UserResp='Y'
end
if UserResp='Y' then
do
SpellingAddCount=SpellingAddCount+1
DuplicatedIdValue=SpellingAddCount
SpellingAddWord.SpellingAddCount=ThisWord
SpellingAddOccurs.SpellingAddCount=1
if SpellingPrompts='OK' then
do
WordWarningId='SPL1'
WordWarningMsg='Added "' || ThisWord || '" to "' || SpellingAddFile || '"'
end
end
else
do
if UserResp='Q' then
SpellingPrompts='N'
end
end
BadlySpellWordCount=BadlySpellWordCount+1
call _valueS DuplicatedId,DuplicatedIdValue
end
end
if SpellShowEachError='Y' then
ShowThisError='Y'
else
do
DuplicatedId='?BADWORDEB.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
ShowThisError='N'
else
do
ShowThisError='Y'
call _valueS DuplicatedId, ''
end
end
if ShowThisError='Y' then
do
if WordWarningId='' then
do
WordWarningId='SPL1'
WordWarningMsg='Spelling? : ' ||ThisWord
end
call OutputWarningToScreen WordWarningId,WordWarningMsg
end
end
end
end
return

OutputAnySpellingAdditions:
if SpellingAddCount=0 then
return
call DBG_SPELLING 'Adding spelling words to file "' || SpellingAddFile || '"'
call DBGIND 1
if MacroExists("PPWIZARD_DONT_SORT_ADD_WORDS") = 'N' then
do
call DBG_SPELLING 'Sorting ' || SpellingAddCount || ' "bad" word(s) by number of occurences!'
SpellingAddWord.0=SpellingAddCount
SpellingAddOccurs.0=SpellingAddCount
SrtM=1
SrtCount=SpellingAddOccurs.0
do while(9*SrtM+4)<SrtCount
SrtM=SrtM*3+1
end
do while SrtM>0
SrtK=SrtCount-SrtM
do SrtJ=1 to SrtK
SrtIndex1=SrtJ
do while SrtIndex1>0
SrtIndex2=SrtIndex1+SrtM
SrtGreater=SpellingAddOccurs.SrtIndex1>SpellingAddOccurs.SrtIndex2
if SrtGreater then
do
SrtTemp=SpellingAddOccurs.SrtIndex1;SpellingAddOccurs.SrtIndex1=SpellingAddOccurs.SrtIndex2;SpellingAddOccurs.SrtIndex2=SrtTemp;SrtTemp=SpellingAddWord.SrtIndex1;SpellingAddWord.SrtIndex1=SpellingAddWord.SrtIndex2;SpellingAddWord.SrtIndex2=SrtTemp
end
else
leave
SrtIndex1=SrtIndex1-SrtM
end
end
SrtM=SrtM%3
end
call ArrayReverse "SpellingAddWord"
call ArrayReverse "SpellingAddOccurs"
end
call FileClose SpellingAddFile, 'N'
if FileQueryExists(SpellingAddFile)<> "" then
do
call DBG_SPELLING 'Deleting existing "' || SpellingAddFile || '"'
call MustDeleteFile SpellingAddFile
end
call DBG_SPELLING 'Writing words to file'
call DBGIND 1
do WordIndex=1 to SpellingAddCount
call lineout SpellingAddFile,SpellingAddWord.WordIndex
if OptionDebugOn='Y' then
call DBG_SPELLING 'The word "' || SpellingAddWord.WordIndex || '" occured ' || SpellingAddOccurs.WordIndex || ' time(s).'
end
call DBGIND-1
call FileClose SpellingAddFile
call OutputInformationToScreen AddCommasToDecimalNumber(SpellingAddCount)|| ' word(s) added to "' || SpellingAddFile || '"'
call DBGIND-1
return

SPELLING_14:
OptionDebugOn='N'
OptionMaxCol=500
OptionDebugTime='*'
call DBGINDInit
signal Debug_15

DebugInc:call TRACE "OFF"
call DBGIND 1
return

DebugDec:call TRACE "OFF"
call DBGIND-1
return

DebugOn:call TRACE "OFF"
call _DebugOnOff 'Y'
return

DebugOff:call TRACE "OFF"
call _DebugOnOff 'N'
return

_DebugOnOff:
if DebugSwitchUsed='Y' then
call DBG 'Command ignored as "/debug" used'
else
do
OptionDebugOn=arg(1)
call DebugStateChanged
end
return

DebugIndent:call TRACE "OFF"

DBGIND:
DebugIndent=DebugIndent+(arg(1)*2)
if DebugIndent<0 then
DebugIndent=0
return

Debug:call TRACE "OFF"

DBG:
if OptionDebugOn='N' then
return

DBG2:
if arg(1)='' then
call _DBG1 ''
else
call _DBG1 _DebugPrefix()|| '         >' ||translate(arg(1),DebugNewline,MarksNewLine)
return

_DebugPrefix:
if OptionDebugTime='' then
v!T=''
else
do
if OptionDebugTime="*" then
v!T=trunc(time('E'),3)
else
v!T=time(OptionDebugTime)
v!T='[' || v!T || ']'
end
return(v!T||copies("  ",IncludeLevel+DebugIndent))

YorN2OnorOff:
if arg(1)='Y' then
return('ON')
else
return('OFF')

DebugShowCurrentLineWithLineNumber:
if OptionDebugOn='Y' then
do
FmtLineNum=IncludeLineNumber
if length(FmtLineNum)<4 then
FmtLineNum=right(FmtLineNum,4, '0')
if arg(2)<> '' then
FmtLineNum=left(arg(2),length(FmtLineNum))
if IncludeMemHandle='' then
FmtLineNum='{' || DebugCurrentFileNumber || '}' ||FmtLineNum
else
FmtLineNum='[' || DebugCurrentFileNumber || ']' ||FmtLineNum
select
when AsIsModeOn='Y' & AutoTagOn = 'Y' then
DebugSym='> '
when AsIsModeOn='Y' then
DebugSym='} '
when AutoTagOn='Y' then
DebugSym=') '
otherwise
DebugSym=': '
end
if arg(1)=='' then
call _DBG1 _DebugPrefix()||FmtLineNum||DebugSym
else
call _DBG1 _DebugPrefix()||FmtLineNum||DebugSym||DebugRightArrow||translate(arg(1),DebugNewline,MarksNewLine)||DebugLeftArrow
end
return

DebugShowLineDropped:
if OptionDebugOn='Y' then
do
call _DBG1 _DebugPrefix()||left(arg(1),length(FmtLineNum), ' ') || '-'
end
return

DebugGetEnv:
if OptionDebugOn='Y' then
call DBG 'GetEnv(): "' || arg(1) || '" = ' ||DebugRightArrow||arg(2)||DebugLeftArrow
return

DebugWarning:
if OptionDebugOn='N' then
return
DbgWarning='!!! ' || arg(1) || ' !!!'
DbgLine=copies('!',length(DbgWarning))
call DBG2 ''
call DBG2 left('!!!![ DEBUG WARNING ]', length(DbgWarning), '!')
call DBG2 DbgWarning
call DBG2 left('', length(DbgWarning), '!')
call DBG2 ''
return

DebugOutputVariableInfo:
if OptionDebugOn='Y' then
call DBG2 '? ' ||translate(arg(1),DebugNewline,MarksNewLine)
return

DBGINDInit:
DebugIndent=0
return

DebugGetOpSysText:
if PpWizardOpSys=PpWizardOpSysREAL then
return(PpWizardOpSys)
else
return(PpWizardOpSys|| ' ("' || PpWizardOpSysREAL || '")')

DebugStateChanged:
if OptionDebugOn='Y' then
do
call DisplayCopyright
if DebugOnStuffOutputted='N' then
do
call _DBG1 ''
call _DBG1 ''
call _DBG1 'BRIEF INTRO TO DEBUG OUTPUT'
call _DBG1 '~~~~~~~~~~~~~~~~~~~~~~~~~~~'
call _DBG1 'Indenting of debug text represents logic "nesting", the format'
call _DBG1 'of a line read from file is explained below:'
call _DBG1 ''
call _DBG1 '[0.050]  {1}0006: #define Fred Value'
call _DBG1 '-------  ~~~----  ------------------'
call _DBG1 '   ^      ^  ^            ^'
call _DBG1 '   |      |  |            + The line(s)'
call _DBG1 '   |      |  |'
call _DBG1 '   |      |  +-- <<#{   = Line came from memory buffer only used for "<<ML" lines'
call _DBG1 '   |      |  +-- <<ML   = Line came from #{ defined within a macro'
call _DBG1 '   |      |  +-- <<<<   = Line came from memory buffer (macro, line continuation etc - Imbedded newlines IGNORED)'
call _DBG1 '   |      |  +-- >>>>   = Writing buffered line to output'
call _DBG1 '   |      |  +-- <<FL   = Line came from #{ defined in a file'
call _DBG1 '   |      |  +-- Number = Number of line just read from file'
call _DBG1 '   |      |'
call _DBG1 '   |      +-- The number is a unique number to represent a file inclusion'
call _DBG1 '   |          {file#} means file is being read from disk'
call _DBG1 '   |          [file#] means file is being read from cached memory'
call _DBG1 '   |          Indenting represents #include level'
call _DBG1 '   |'
call _DBG1 '   +- Time in your preferred format (defaults to elapsed - See /DebugTime)'
call _DBG1 ''
call _DBG1 'Note that the #OPTION "DebugLevel" command can be used to reduce the'
call _DBG1 'information generated!'
call _DBG1 ''
call _DBG1 'Never use the rexx say command to display output! Use the PPWIZARD'
call _DBG1 '"say()" function instead to ensure that the output is included in any'
call _DBG1 'PPWIZARD output.'
call _DBG1 'There are MANY rexx debugging options, including tracing, interactive debugging'
call _DBG1 'and break points. The #DefineRexx command will so cause rexx code variables to be dumped.'
call _DBG1 ''
call _DBG1 ''
call _DBG1 ''
SourceTime=_FileQueryDateTime(PpWizardPgmName)
call DBG 'Debug Header'
call DBG '~~~~~~~~~~~~'
call DBGIND 1
call DBG 'Started@: "' || PpwCompTime        || '"'
call DBG 'Program : "' || PpWizardPgmName    || '" (' || SourceTime || ')'
call DBG 'OptionE : "' || OptionsEnvironment || '"'
call DBG 'OptionC : "' || OptionsCmdLine     || '"'
call DBG 'Src Type: "' || ProcessingMode     || '"'
call DBG 'OpSystem: "' ||DebugGetOpSysText()
call DBG 'Rexx Ver: "' || RexVersionInfo     || '"'
call DBG 'Mode    : "' || RexWhich           || '"'
if RexWhich='REGINA' then
call DBG 'uname() : "' || uname()        || '"'
if OptionFilterIn<> '' then
call DBG 'Filter I: ' || FunctionFilterIn || '(' || InputInterfaceVer || ')'
if OptionFilterOut<> '' then
call DBG 'Filter O: "' || OptionFilterOut   || '" (interface version ' || OutputInterfaceVer || ')'
call _DBG1 ''
call _DBG1 ''
DebugOnStuffOutputted='Y'
call DBGIND-1
end
end
call SetEnv "PPWIZARD_DEBUG",OptionDebugOn
return

ProcessHashDebug:
if DebugSwitchUsed='Y' then
call DBG 'Command ignored as "/debug" used'
else
do
ReturnRc=SetOnorOffVariable(arg(1), 'OptionDebugOn')
call DebugStateChanged
end
return(0)

DebugShowAsMuchEnvironmentDetailAsPossible:
if OptionDebugOn='N' then
return
call DBG 'Dumping Environmental Info'
TmpSetFile=RexGetTmpFileName('DB??????.PPW')
RedirBit=RedirectStdOutAndErr2(TmpSetFile)
call _EnvAddCmd 'set'
if RexSystemOpSys<> "UNIX" then
do
select
when RexSystemOpSys="OS/2"  then VerCmd = 'VER /R'
otherwise VerCmd='VER'
end
call _EnvAddCmd VerCmd
end
if RexSystemOpSys<> "UNIX" then
call _SysFileDelete TmpSetFile
return

_EnvAddCmd:
call AddressCmd arg(1)||RedirBit,TmpSetFile
if RexSystemOpSys="UNIX" then
call _SysFileDelete TmpSetFile
return

_DBG1:
w!Line=arg(1)
if OptionMaxCol=0 then
call Line1 w!Line
else
do
if length(w!Line)<=OptionMaxCol then
call Line1 w!Line
else
call Line1 left(w!Line,OptionMaxCol)|| ' <-[' || OptionMaxCol || ']'
end
return

_SetDebugChar:
x!Var=arg(1)
x!CurValVar=arg(2)
parse value strip(value(x!Var)) with x!Val ',' x!Rest
call value x!Var,x!Rest
if x!Val=-1 then
x!NewVal=''
else
do
x!Val=strip(x!Val)
if x!Val='' then
x!NewVal=value(x!CurValVar)
else
do
if datatype(x!Val, 'W')then
x!NewVal=d2c(x!Val)
else
x!NewVal=x!Val
end
end
return(x!NewVal)

SetDebugChars:
y!Chars=arg(1)
y!MakDef=arg(2)
if y!Chars='' then
do
DebugLeftArrow=_DebugLeftArrow
DebugRightArrow=_DebugRightArrow
DebugNewline=_DebugNewline
end
else
do
DebugRightArrow=_SetDebugChar('y!Chars', 'DebugRightArrow')
DebugLeftArrow=_SetDebugChar('y!Chars', 'DebugLeftArrow' )
DebugNewline=_SetDebugChar('y!Chars', 'DebugNewline' )
end
if y!MakDef='Y' then
do
_DebugLeftArrow=DebugLeftArrow
_DebugRightArrow=DebugRightArrow
_DebugNewline=DebugNewline
end
call DBG 'New debug characters are "LEFT=' || DebugRightArrow || ', RIGHT=' || DebugLeftArrow || ', NL=' || DebugNewline || '"'
return

Debug_15:
DebugLevelCnt=0
SeeLevelAll=_SaveDebugLevel("ALL",           "FFFFFF")
SeeNone=_SaveDebugLevel("NONE",          "000000")
DummyUser1=_SaveDebugLevel("USER1",         "000001")
DummyUser2=_SaveDebugLevel("USER2",         "000002")
SeeLevelConditional=_SaveDebugLevel("CONDITIONAL",   "000004")
SeeFoundVar=_SaveDebugLevel("FOUNDVAR",      "000008")
SeeFoundVarParms=_SaveDebugLevel("FOUNDVARPARMS", "000010")
SeeFoundStdVar=_SaveDebugLevel("FOUNDSTDVAR",   "000020")
SeeAfterReplace=_SaveDebugLevel("AFTERREPLACE",  "000040")
SeeOptions=_SaveDebugLevel("OPTIONS",       "000080")
SeeOpSys=_SaveDebugLevel("OPSYS",         "000100")
SeeDefining=_SaveDebugLevel("DEFINING",      "000200")
SeeDefaultOrMacroValue=_SaveDebugLevel("MACROVALORDEF", "000400")
SeeAsIs=_SaveDebugLevel("ASIS",          "000800")
SeeAutoTag=_SaveDebugLevel("AUTOTAG",       "001000")
SeeRexxVar=_SaveDebugLevel("REXXVAR",       "002000")
SeeRexxTrace=_SaveDebugLevel("REXXTRACE",     "004000")
SeeInterpret=_SaveDebugLevel("INTERPRET",     "008000")
SeeEvaluate=_SaveDebugLevel("EVALUATE",      "010000")
SeeImport=_SaveDebugLevel("IMPORT",        "020000")
SeeSpelling=_SaveDebugLevel("SPELLING",      "040000")
SeeQuoting=_SaveDebugLevel("QUOTING",       "080000")
SeeImport=bitand(SeeImport,SeeDefaultOrMacroValue)
UserBitsOn=bitor(DummyUser1,DummyUser2)
DebugLevel=bitxor(SeeLevelAll,UserBitsOn)
DebugLevel=bitxor(DebugLevel,SeeQuoting)
SeeLevelDEFAULT=_SaveDebugLevel("DEFAULT",c2x(DebugLevel))
signal DebugOpt_16

IsDebugOn:call TRACE "OFF"
ido1=arg(1)
if ido1='' then
return(OptionDebugOn)
else
do
if OptionDebugOn='N' then
return(0)
else
do
idoUBits=bitand(DebugLevel,UserBitsOn)
idoUBits=bitand(idoUBits,x2c(right(ido1,6, '0')))
return(c2d(idoUBits))
end
end

DebugAddressCmdBefore:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DBGIND 1
call DBG 'Executing: ' ||arg(1)
call DBGIND-1
end
end
else
do
if OptionAddressCmdTrace<> '' then
do
call say ''
call ColorSet 'RexxTrace'
call say '>>> Executing: ' ||arg(1)
call ColorSet 'Default'
end
end
return

DebugAddressCmdOutput:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DBGIND 2
DbgLineNumber=arg(2)
if datatype(DbgLineNumber, 'W')=0 then
call DBG '> ' ||arg(1)
else
do
if DbgLineNumber<999 then
DbgLineNumber=right(DbgLineNumber,3, '0')
call DBG '> ' || DbgLineNumber || ': ' ||arg(1)
end
call DBGIND-2
end
end
return

DebugAddressCmdAfter:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DBGIND 2
call DBG '  Rc = ' ||arg(1)
call DBGIND-2
end
end
else
do
if OptionAddressCmdTrace<> '' then
do
call ColorSet 'RexxTrace'
call say '<<< Rc = ' ||arg(1)
call ColorSet 'Default'
call say ''
end
end
if OptionAddressCmdTrace<> '' then
do
if pos('P',OptionAddressCmdTrace)<>0 then
do
call ColorSet 'PromptText'
address system 'pause'
call ColorSet 'Default'
end
end
return

DebugOutputAfterReplacement:
if OptionDebugOn='N' then
return
if bitand(DebugLevel,SeeAfterReplace)==SeeAfterReplace then
call DBG2 arg(2)||DebugRightArrow||translate(arg(1),DebugNewline,MarksNewLine)||DebugLeftArrow
return

DBG_DEFINING:
if bitand(DebugLevel,SeeDefining)==SeeDefining then
call DBG arg(1)
return

DBG_ASIS:
if bitand(DebugLevel,SeeAsIs)==SeeAsIs then
call DBG arg(1)
return

DBG_REXXVAR:
if bitand(DebugLevel,SeeRexxVar)==SeeRexxVar then
call DBG arg(1)
return

DBG_INTERPRET:
if bitand(DebugLevel,SeeInterpret)==SeeInterpret then
call DBG arg(1)
return

DBG_EVALUATE:
if bitand(DebugLevel,SeeEvaluate)==SeeEvaluate then
call DBG arg(1)
return

DBG_SPELLING:
if bitand(DebugLevel,SeeSpelling)==SeeSpelling then
call DBG arg(1)
return

DBG_QUOTING:
if bitand(DebugLevel,SeeQuoting)==SeeQuoting then
call DBG arg(1)
return

DBG_IMPORT:
if bitand(DebugLevel,SeeImport)==SeeImport then
call DBG arg(1)
return

DBG_AUTOTAG:
if bitand(DebugLevel,SeeAutoTag)==SeeAutoTag then
call DBG arg(1)
return

DBG_MACROVALORDEF:
if bitand(DebugLevel,SeeDefaultOrMacroValue)==SeeDefaultOrMacroValue then
call DBG arg(1)
return

DBG_OPTIONS:
if bitand(DebugLevel,SeeOptions)==SeeOptions then
call DBG arg(1)
return

DBG_CONDITIONAL:
if bitand(DebugLevel,SeeLevelConditional)==SeeLevelConditional then
call DBG arg(1)
return

DebugOutputVariableInfo_FOUNDSTDVAR:
if bitand(DebugLevel,SeeFoundStdVar)==SeeFoundStdVar then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDVAR:
if bitand(DebugLevel,SeeFoundVar)==SeeFoundVar then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDVARPARMS:
if bitand(DebugLevel,SeeFoundVarParms)==SeeFoundVarParms then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDSTDVAR:
if bitand(DebugLevel,SeeFoundVar)==SeeFoundVar then
call DebugOutputVariableInfo arg(1)
return

_SaveDebugLevel:
DebugLevelCnt=DebugLevelCnt+1
DebugLevelNme.DebugLevelCnt=translate(arg(1))
DebugLevelVal.DebugLevelCnt=arg(2)
return(x2c(arg(2)))

GetDebugLevel:
WantedName=translate(arg(1))
do DbgIndex=1 to DebugLevelCnt
if WantedName=DebugLevelNme.DbgIndex then
return(DebugLevelVal.DbgIndex)
end
return('')

_WorkOutDebugLevelText:
DbgLvlTxt="ALL"
do DbgIndex=1 to DebugLevelCnt
if bitand(DebugLevel,x2c(DebugLevelVal.DbgIndex))=SeeNone then
DbgLvlTxt=DbgLvlTxt|| ',-' ||DebugLevelNme.DbgIndex
end
return(DbgLvlTxt)

DEBUGLEVEL_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'DEBUGLEVEL', 'Debug level (when on) is ' || '0x' || c2x(DebugLevel) || ': ' ||_WorkOutDebugLevelText()
return

DEBUGLEVEL_GET:
call DEBUGLEVEL_DEBUG
return(_WorkOutDebugLevelText())

DEBUGLEVEL_SET:
DebugCmdsIn=arg(1)
DebugCmds=DebugCmdsIn
do while DebugCmds<> ''
parse var DebugCmds OneDebugOpt','DebugCmds
OneDebugOpt=strip(OneDebugOpt)
OptionAction=left(OneDebugOpt,1)
if OptionAction='+' then
OneDebugOpt=substr(OneDebugOpt,2)
else
do
if OptionAction='-' then
OneDebugOpt=substr(OneDebugOpt,2)
else
OptionAction='='
end
OptionBinary=x2c(GetDebugLevel(OneDebugOpt))
if OptionBinary='' then
CryAndDie('Invalid debug option of "' || OneDebugOpt || '"')
if OptionAction='=' then
DebugLevel=OptionBinary
else
do
if OptionAction='+' then
DebugLevel=bitor(DebugLevel,OptionBinary)
else
DebugLevel=bitand(DebugLevel,bitxor(x2c('FFFFFF'),OptionBinary))
end
end
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'DEBUGLEVEL', 'Setting default value of debug level to "' || _WorkOutDebugLevelText() || '"'
Default4_DebugLevel=DebugLevel
return(0)
end
if DebugCmdsIn='' then
DebugLevel=Default4_DebugLevel
call DEBUGLEVEL_DEBUG
return

DebugOpt_16:
signal CGI_17

InitConsoleOutputVarsPass1:
OptionCgiModeOn='N'
CgiOutputFile=''
CgiFatalError='N'
CgiConsoleCnt=0
ConsoleFile=''
OutputToConsoleLog='N'
OutputToErrorLog='N'
ConsoleErrorFile='PPWIZARD.ERR'
TruncateDefaultErrorFile='Y'
return

InitConsoleOutputVarsPass2:
call UserIsSpecifyingConsoleFileName GetEnv("PPWIZARD_CONSOLEFILE")
call UserIsSpecifyingErrorFileName GetEnv("PPWIZARD_ERRORFILE")
if ConsoleErrorFile='' then
ConsoleErrorFile='PPWIZARD.ERR'
return

ConsoleWriteAllowed:
_ConsoleWriteAllowed=translate(arg(1))
return

UserIsSpecifyingErrorFileName:
ConsoleErrorFile=arg(1)
if ConsoleErrorFile<> '' then
do
if left(ConsoleErrorFile,1)='+' then
do
ConsoleErrorFile=substr(ConsoleErrorFile,2)
TruncateDefaultErrorFile='N'
end
else
do
TruncateDefaultErrorFile='Y'
end
end
return

UserIsSpecifyingConsoleFileName:
z!ConFile=arg(1)
if z!ConFile="*" then
do
if OutputToConsoleLog<> 'N' then
return
z!ConFile='PpwDebug.txt'
call Say '/Debug spotted - Sending console output to "' || z!ConFile || '".'
end
z!CopyFrom=''
if OutputToConsoleLog='Y' then
do
if left(z!ConFile,1)='+' then
z!New=substr(z!ConFile,2)
else
z!New=z!ConFile
if translate(ConsoleFile)<>translate(z!New)then
z!CopyFrom=ConsoleFile
else
z!ConFile='+' ||z!New
end
if ConsoleFile<> '' then
do
call _FileClose ConsoleFile
ConsoleFile=''
end
if z!ConFile<> '' then
do
if left(z!ConFile,1)='+' then
do
z!ConFile=substr(z!ConFile,2)
end
else
do
call MustDeleteFile z!ConFile
end
end
if z!ConFile='' then
OutputToConsoleLog='N'
else
do
call MakeDirectoryTree _filespec('Location',z!ConFile)
OutputToConsoleLog='y'
ConsoleFile=z!ConFile
if z!CopyFrom<> '' then
do
do while lines(z!CopyFrom)<>0
call _Lne2CFle linein(z!CopyFrom)
end
call lineout z!CopyFrom, ''
call lineout z!CopyFrom, 'See "' || ConsoleFile || '" for more console output...'
call _FileClose z!CopyFrom
call _Lne2CFle ''
call _Lne2CFle ''
call _Lne2CFle copies('*+',38)
call _Lne2CFle strip(PadString('above copied from "' || z!CopyFrom || '"', 78, 'C'), 'T')
call _Lne2CFle strip(PadString(TheTime,78, 'C'), 'T')
call _Lne2CFle copies('*+',38)
call _Lne2CFle ''
OutputToConsoleLog='Y'
end
end
return

AllFollowingOutputGoesToErrorFile:
call ConsoleWriteAllowed 'Y'
if ConsoleErrorFile='' then
return
if TruncateDefaultErrorFile='Y' then
do
TruncateDefaultErrorFile='N'
call MustDeleteFile ConsoleErrorFile
end
call MakeDirectoryTree _filespec('Location',ConsoleErrorFile)
TheTime=NiceDateTime()
if symbol('InputFileFull') <> 'VAR' then
TheFile=''
else
TheFile=InputFileFull
OutputToErrorLog='Y'
call Say2ErrorFile ''
call Say2ErrorFile ''
call Say2ErrorFile copies('*+',38)
call Say2ErrorFile strip(PadString(TheFile,78, 'C'), 'T')
call Say2ErrorFile strip(PadString(TheTime,78, 'C'), 'T')
call Say2ErrorFile copies('*+',38)
call Say2ErrorFile ''
return

Say2ErrorFile:
if OutputToErrorLog='Y' then
do
ab!L=arg(1)
do until ab!L==''
parse var ab!L ab!Nxt (MarksNewLine) ab!L
call lineout ConsoleErrorFile,ab!Nxt
end
end
return

Char1ToErrorFile:
if OutputToErrorLog='Y' then
call charout ConsoleErrorFile,arg(1)
return

AddConsoleHdr:
OutputToConsoleLog='N' 
TheTime=NiceDateTime()
OutputToConsoleLog='Y' 
call _Lne2CFle ''
call _Lne2CFle ''
call _Lne2CFle copies('*+',38)
call _Lne2CFle strip(PadString(TheTime,78, 'C'), 'T')
call _Lne2CFle copies('*+',38)
call _Lne2CFle ''
return

_Lne2CFle:
if OutputToConsoleLog<> 'N' then
do
bb!L=arg(1)
do until bb!L==''
parse var bb!L bb!Nxt (MarksNewLine) bb!L
call lineout ConsoleFile,bb!Nxt
end
end
return

_Chr2CFle:
if OutputToConsoleLog<> 'N' then
call charout ConsoleFile,arg(1)
return

Say:call TRACE "OFF"

Line1:
parse arg cb!Short,cb!Long
if cb!Long='' then
cb!Long=cb!Short
CgiConsoleCnt=CgiConsoleCnt+1
if CgiConsoleCnt>999999 then
CgiConsoleCnt=-1
if OptionCgiModeOn='N' then
do
if _ConsoleWriteAllowed='Y' then
say cb!Short
call Say2Logs cb!Long
end
else
do
if CgiOutputFile<> '' then
call lineout CgiOutputFile,cb!Short
if CgiFatalError='Y' then
say _MustSeeAsIsInHtmlViewer(cb!Short)
end
return

Say2Logs:
cb!2Logs=arg(1)
if OutputToErrorLog='Y' then
call Say2ErrorFile cb!2Logs
if OutputToConsoleLog<> 'N' then
do
if OutputToConsoleLog='y' then
call AddConsoleHdr
call _Lne2CFle cb!2Logs
end
return

Chars:call TRACE "OFF"

Char1:
TheChar1=arg(1)
CgiConsoleCnt=CgiConsoleCnt+1
if CgiConsoleCnt>999999 then
CgiConsoleCnt=-1;
if OptionCgiModeOn='N' then
do
call charout,TheChar1
if OutputToErrorLog='Y' then
call Char1ToErrorFile TheChar1
if OutputToConsoleLog<> 'N' then
do
if OutputToConsoleLog='y' then
call AddConsoleHdr
call _Chr2CFle TheChar1
end
end
else
do
if CgiOutputFile<> '' then
call charout CgiOutputFile,TheChar1
if CgiFatalError='Y' then
call charout,_MustSeeAsIsInHtmlViewer(TheChar1)
end
return

DieIfCgiModeOn:
if OptionCgiModeOn='Y' then
call CryAndDie "This feature is not allowed in CGI mode"
return

TurnCgiModeOn:
OptionCgiModeOn='Y'
CgiOutputFile=ThisCmdOptions
if pos('?',CgiOutputFile)<>0 then
do
PartSecond=time('Long')
parse var PartSecond .'.'PartSecond
RandomBit=right(time('Seconds'), 5, '0')
RandomBit=RandomBit||left(strip(PartSecond),3)
RandomBit=RandomBit|| '.' || right( date('Days'), 3, '0')
CgiOutputFile=ReplaceString(CgiOutputFile, '?',RandomBit)
end
if CgiOutputFile<> '' then
do
if FileQueryExists(CgiOutputFile)<> '' then
do
call _FileClose CgiOutputFile
DeleteRc=_SysFileDelete(CgiOutputFile)
if DeleteRc<>0 then
call DBG 'Could not delete "' || CgiOutputFile || '" (Rc = ' || DeleteRc || ')'
end
end
call ColorAllow 'N'
call BeepsAllow 'N'
return

CloseCgiFileIfOpen:
if OutputToConsoleLog<> 'N' then
do
call _FileClose ConsoleFile
OutputToConsoleLog='N'
end
if OutputToErrorLog='Y' then
do
call _FileClose ConsoleErrorFile
OutputToErrorLog='N'
end
if CgiOutputFile<> '' then
call _FileClose CgiOutputFile
return

CgiStartFatalError:
if OptionCgiModeOn='N' then
return
CgiDoVar='CGI_FATAL_MY_MESSAGE_ONLY'
if MacroExists(CgiDoVar)='Y' then
do
CgiErrorCodes=CfgMacro(CgiDoVar, '')
if CgiErrorCodes='' then
call DBG 'We do not want any error indication in user output'
else
call DBG 'Displaying user message only (no error details)'
say CgiErrorCodes
return
end
call DBG 'Will show user error output as "' || CgiDoVar || '" was not defined'
CgiErrDefault='<p><hr><font size=+1 color=red><center><h1>FATAL ERROR</h1></center><p><pre>'
CgiErrorCodes=CfgMacro("CGI_FATAL_HEADER",CgiErrDefault)
say CgiErrorCodes
CgiErrDefault='</pre><hr></font>'
CgiErrorCodes=CfgMacro("CGI_FATAL_TRAILER",CgiErrDefault)
CgiFatalError='Y'
return

CgiEndFatalError:
if OptionCgiModeOn='N' then
return
if CgiFatalError='N' then
return
say CgiErrorCodes
CgiFatalError='N'
return

_MustSeeAsIsInHtmlViewer:
BrowserOk=ReplaceString(arg(1), "<",          "&lt;")
BrowserOk=ReplaceString(BrowserOk, ">",          "&gt;")
return(BrowserOk)

ConsoleCount:
return(CgiConsoleCnt)

CGI_17:
ReplaceCount=0
CiSelfRef="{*}"
call HasChangeStr
signal EndREPLSTR

HasChangeStr:
signal on SYNTAX name NoChangeStr
UseChangeStr='N'
IgnoreIt='?'
IgnoreIt=CountStr("look", "in")
if IgnoreIt<> "0" then
signal NoChangeStr
IgnoreIt=ChangeStr("from", "in", "to")
if IgnoreIt<> "in" then
signal NoChangeStr
UseChangeStr='Y'

NoChangeStr:
return

ReplaceString:call TRACE "OFF"
if UseChangeStr='N' then
signal _ReplaceString_
parse arg rs?TheString,rs?ChangeFrom
rs?Count=CountStr(rs?ChangeFrom,rs?TheString)
if rs?Count=0 then
return(rs?TheString)
ReplaceCount=ReplaceCount+rs?Count
return(ChangeStr(rs?ChangeFrom,rs?TheString,arg(3)))

_ReplaceString_:
parse arg rs?TheString,rs?ChangeFrom
rs?FoundPosn=pos(rs?ChangeFrom,rs?TheString)
if rs?FoundPosn=0 then
return(rs?TheString)
rs?ChangeTo=arg(3)
rs?ChangeFromLength=length(rs?ChangeFrom)
rs?LeftPart=''
do until rs?FoundPosn=0
rs?LeftPart=rs?LeftPart||left(rs?TheString,rs?FoundPosn-1)||rs?ChangeTo
rs?TheString=substr(rs?TheString,rs?FoundPosn+rs?ChangeFromLength)
ReplaceCount=ReplaceCount+1
rs?FoundPosn=pos(rs?ChangeFrom,rs?TheString)
end
return(rs?LeftPart||rs?TheString)

ReplaceStringCi:call TRACE "OFF"
rsi?TheString=arg(1)
rsi?TheStringU=translate(rsi?TheString)
rsi?ChangeFrom=translate(arg(2))
rsi?FoundPosn=pos(rsi?ChangeFrom,rsi?TheStringU)
if rsi?FoundPosn=0 then
return(rsi?TheString)
rsi?ChangeTo=arg(3)
if pos(CiSelfRef,rsi?ChangeTo)=0 then
rsi?Ref='N'
else
rsi?Ref='Y'
rsi?ChangeFromLength=length(rsi?ChangeFrom)
rsi?LeftPart=''
do until rsi?FoundPosn=0
if rsi?Ref='N' then
rsi?SubWith=rsi?ChangeTo
else
do
rsi?SaveCount=ReplaceCount
rsi?SubWith=ReplaceString(rsi?ChangeTo,CiSelfRef,substr(rsi?TheString,rsi?FoundPosn,rsi?ChangeFromLength))
ReplaceCount=rsi?SaveCount
end
rsi?LeftPart=rsi?LeftPart||left(rsi?TheString,rsi?FoundPosn-1)||rsi?SubWith
rsi?TheString=substr(rsi?TheString,rsi?FoundPosn+rsi?ChangeFromLength)
rsi?TheStringU=substr(rsi?TheStringU,rsi?FoundPosn+rsi?ChangeFromLength)
ReplaceCount=ReplaceCount+1
rsi?FoundPosn=pos(rsi?ChangeFrom,rsi?TheStringU)
end
return(rsi?LeftPart||rsi?TheString)

EndREPLSTR:
ReplaceCount=0
signal EndBULK_C2S

BulkChar2String:call TRACE "OFF"
parse arg brRightBit,brArray
brModifyThese=value(brArray)
brPos=verify(brRightBit,brModifyThese, 'M')
if brPos=0 then
return(brRightBit)
brLeftBit=''
brArray=brArray|| '.'
do until brPos=0
brLeftBit=brLeftBit||left(brRightBit,brPos-1)||value(brArray||pos(substr(brRightBit,brPos,1),brModifyThese))
brRightBit=substr(brRightBit,brPos+1)
ReplaceCount=ReplaceCount+1
brPos=verify(brRightBit,brModifyThese, 'M')
end
return(brLeftBit||brRightBit)

BulkChangePrepare:call TRACE "OFF"
parse arg brArray,brChar,brString
if brChar=='' then
call value brArray, ''
else
do
brValue=value(brArray)||BrChar
call value brArray,brValue
call value brArray|| '.' ||length(brValue),brString
end
return

EndBULK_C2S:
_CCnt=0
call _32 '00000000'x
call _32 '77073096'x
call _32 'EE0E612C'x
call _32 '990951BA'x
call _32 '076DC419'x
call _32 '706AF48F'x
call _32 'E963A535'x
call _32 '9E6495A3'x
call _32 '0EDB8832'x
call _32 '79DCB8A4'x
call _32 'E0D5E91E'x
call _32 '97D2D988'x
call _32 '09B64C2B'x
call _32 '7EB17CBD'x
call _32 'E7B82D07'x
call _32 '90BF1D91'x
call _32 '1DB71064'x
call _32 '6AB020F2'x
call _32 'F3B97148'x
call _32 '84BE41DE'x
call _32 '1ADAD47D'x
call _32 '6DDDE4EB'x
call _32 'F4D4B551'x
call _32 '83D385C7'x
call _32 '136C9856'x
call _32 '646BA8C0'x
call _32 'FD62F97A'x
call _32 '8A65C9EC'x
call _32 '14015C4F'x
call _32 '63066CD9'x
call _32 'FA0F3D63'x
call _32 '8D080DF5'x
call _32 '3B6E20C8'x
call _32 '4C69105E'x
call _32 'D56041E4'x
call _32 'A2677172'x
call _32 '3C03E4D1'x
call _32 '4B04D447'x
call _32 'D20D85FD'x
call _32 'A50AB56B'x
call _32 '35B5A8FA'x
call _32 '42B2986C'x
call _32 'DBBBC9D6'x
call _32 'ACBCF940'x
call _32 '32D86CE3'x
call _32 '45DF5C75'x
call _32 'DCD60DCF'x
call _32 'ABD13D59'x
call _32 '26D930AC'x
call _32 '51DE003A'x
call _32 'C8D75180'x
call _32 'BFD06116'x
call _32 '21B4F4B5'x
call _32 '56B3C423'x
call _32 'CFBA9599'x
call _32 'B8BDA50F'x
call _32 '2802B89E'x
call _32 '5F058808'x
call _32 'C60CD9B2'x
call _32 'B10BE924'x
call _32 '2F6F7C87'x
call _32 '58684C11'x
call _32 'C1611DAB'x
call _32 'B6662D3D'x
call _32 '76DC4190'x
call _32 '01DB7106'x
call _32 '98D220BC'x
call _32 'EFD5102A'x
call _32 '71B18589'x
call _32 '06B6B51F'x
call _32 '9FBFE4A5'x
call _32 'E8B8D433'x
call _32 '7807C9A2'x
call _32 '0F00F934'x
call _32 '9609A88E'x
call _32 'E10E9818'x
call _32 '7F6A0DBB'x
call _32 '086D3D2D'x
call _32 '91646C97'x
call _32 'E6635C01'x
call _32 '6B6B51F4'x
call _32 '1C6C6162'x
call _32 '856530D8'x
call _32 'F262004E'x
call _32 '6C0695ED'x
call _32 '1B01A57B'x
call _32 '8208F4C1'x
call _32 'F50FC457'x
call _32 '65B0D9C6'x
call _32 '12B7E950'x
call _32 '8BBEB8EA'x
call _32 'FCB9887C'x
call _32 '62DD1DDF'x
call _32 '15DA2D49'x
call _32 '8CD37CF3'x
call _32 'FBD44C65'x
call _32 '4DB26158'x
call _32 '3AB551CE'x
call _32 'A3BC0074'x
call _32 'D4BB30E2'x
call _32 '4ADFA541'x
call _32 '3DD895D7'x
call _32 'A4D1C46D'x
call _32 'D3D6F4FB'x
call _32 '4369E96A'x
call _32 '346ED9FC'x
call _32 'AD678846'x
call _32 'DA60B8D0'x
call _32 '44042D73'x
call _32 '33031DE5'x
call _32 'AA0A4C5F'x
call _32 'DD0D7CC9'x
call _32 '5005713C'x
call _32 '270241AA'x
call _32 'BE0B1010'x
call _32 'C90C2086'x
call _32 '5768B525'x
call _32 '206F85B3'x
call _32 'B966D409'x
call _32 'CE61E49F'x
call _32 '5EDEF90E'x
call _32 '29D9C998'x
call _32 'B0D09822'x
call _32 'C7D7A8B4'x
call _32 '59B33D17'x
call _32 '2EB40D81'x
call _32 'B7BD5C3B'x
call _32 'C0BA6CAD'x
call _32 'EDB88320'x
call _32 '9ABFB3B6'x
call _32 '03B6E20C'x
call _32 '74B1D29A'x
call _32 'EAD54739'x
call _32 '9DD277AF'x
call _32 '04DB2615'x
call _32 '73DC1683'x
call _32 'E3630B12'x
call _32 '94643B84'x
call _32 '0D6D6A3E'x
call _32 '7A6A5AA8'x
call _32 'E40ECF0B'x
call _32 '9309FF9D'x
call _32 '0A00AE27'x
call _32 '7D079EB1'x
call _32 'F00F9344'x
call _32 '8708A3D2'x
call _32 '1E01F268'x
call _32 '6906C2FE'x
call _32 'F762575D'x
call _32 '806567CB'x
call _32 '196C3671'x
call _32 '6E6B06E7'x
call _32 'FED41B76'x
call _32 '89D32BE0'x
call _32 '10DA7A5A'x
call _32 '67DD4ACC'x
call _32 'F9B9DF6F'x
call _32 '8EBEEFF9'x
call _32 '17B7BE43'x
call _32 '60B08ED5'x
call _32 'D6D6A3E8'x
call _32 'A1D1937E'x
call _32 '38D8C2C4'x
call _32 '4FDFF252'x
call _32 'D1BB67F1'x
call _32 'A6BC5767'x
call _32 '3FB506DD'x
call _32 '48B2364B'x
call _32 'D80D2BDA'x
call _32 'AF0A1B4C'x
call _32 '36034AF6'x
call _32 '41047A60'x
call _32 'DF60EFC3'x
call _32 'A867DF55'x
call _32 '316E8EEF'x
call _32 '4669BE79'x
call _32 'CB61B38C'x
call _32 'BC66831A'x
call _32 '256FD2A0'x
call _32 '5268E236'x
call _32 'CC0C7795'x
call _32 'BB0B4703'x
call _32 '220216B9'x
call _32 '5505262F'x
call _32 'C5BA3BBE'x
call _32 'B2BD0B28'x
call _32 '2BB45A92'x
call _32 '5CB36A04'x
call _32 'C2D7FFA7'x
call _32 'B5D0CF31'x
call _32 '2CD99E8B'x
call _32 '5BDEAE1D'x
call _32 '9B64C2B0'x
call _32 'EC63F226'x
call _32 '756AA39C'x
call _32 '026D930A'x
call _32 '9C0906A9'x
call _32 'EB0E363F'x
call _32 '72076785'x
call _32 '05005713'x
call _32 '95BF4A82'x
call _32 'E2B87A14'x
call _32 '7BB12BAE'x
call _32 '0CB61B38'x
call _32 '92D28E9B'x
call _32 'E5D5BE0D'x
call _32 '7CDCEFB7'x
call _32 '0BDBDF21'x
call _32 '86D3D2D4'x
call _32 'F1D4E242'x
call _32 '68DDB3F8'x
call _32 '1FDA836E'x
call _32 '81BE16CD'x
call _32 'F6B9265B'x
call _32 '6FB077E1'x
call _32 '18B74777'x
call _32 '88085AE6'x
call _32 'FF0F6A70'x
call _32 '66063BCA'x
call _32 '11010B5C'x
call _32 '8F659EFF'x
call _32 'F862AE69'x
call _32 '616BFFD3'x
call _32 '166CCF45'x
call _32 'A00AE278'x
call _32 'D70DD2EE'x
call _32 '4E048354'x
call _32 '3903B3C2'x
call _32 'A7672661'x
call _32 'D06016F7'x
call _32 '4969474D'x
call _32 '3E6E77DB'x
call _32 'AED16A4A'x
call _32 'D9D65ADC'x
call _32 '40DF0B66'x
call _32 '37D83BF0'x
call _32 'A9BCAE53'x
call _32 'DEBB9EC5'x
call _32 '47B2CF7F'x
call _32 '30B5FFE9'x
call _32 'BDBDF21C'x
call _32 'CABAC28A'x
call _32 '53B39330'x
call _32 '24B4A3A6'x
call _32 'BAD03605'x
call _32 'CDD70693'x
call _32 '54DE5729'x
call _32 '23D967BF'x
call _32 'B3667A2E'x
call _32 'C4614AB8'x
call _32 '5D681B02'x
call _32 '2A6F2B94'x
call _32 'B40BBE37'x
call _32 'C30C8EA1'x
call _32 '5A05DF1B'x
call _32 '2D02EF8D'x
signal CRC32REX_18

_32:
db!c=d2c(_CCnt)
_C.db!c=arg(1)
_CCnt=_CCnt+1
return

Crc32PrePostConditioning:call TRACE "OFF"
if arg(1)='' then
return('FFFFFFFF'x)
else
return(bitxor(arg(1), 'FFFFFFFF'x))

UpdateCrc32:call TRACE "OFF"
parse arg eb!Crc,eb!Buffer
do while eb!Buffer\==''
parse var eb!Buffer eb!PerfBuffer 2001 eb!Buffer
do eb!ThisByte=1 to length(eb!PerfBuffer)
parse var eb!Crc eb!L3 4 eb!R1
eb!ArrayEl=bitxor(eb!R1,substr(eb!PerfBuffer,eb!ThisByte,1))
eb!Crc=Bitxor('00'x||eb!L3,_C.eb!ArrayEl)
end
end
return(eb!Crc)

Crc32InDisplayableForm:call TRACE "OFF"
return(c2x(arg(1)))

CRC32REX_18:
signal EndBASEDATEXh

BaseDate:procedure;call TRACE "OFF"
TheDate=translate(arg(1), ' ', '/-')
if TheDate='' then
TheDate=date('Sorted')
parse var TheDate Year MM DD
if length(Year)>=8 then
do
DD=substr(Year,7,2)
MM=substr(Year,5,2)
Year=left(Year,4)
end
DaysInMonth='31  28  31  30  31  30  31  31  30  31  30  31'
if datatype(Year, 'WholeNumber')<>1 then
return(-10)
if datatype(MM, 'WholeNumber')<>1 then
return(-20)
if datatype(DD, 'WholeNumber')<>1 then
return(-30)
if MM<0|MM>12 then
return(-21)
DaysThisMonth=word(DaysInMonth,MM)
if MM=2 then
DaysThisMonth=DaysThisMonth+1
if DD<0|DD>DaysThisMonth then
return(-31)
if length(strip(Year))=2 then
do
if Year>=80 then
Year='19' ||Year
else
Year='20' ||Year
end
y=Year;m=MM;d=DD
z=y+(m-14)%12
f=word('306 337 0 31 61 92 122 153 184 214 245 275',m)
b=d+f+365*z+z%4-z%100+z%400-307
return(b)

_Bd2Date:procedure;call TRACE "OFF"
parse arg rd,Format,Delimiter
z=rd+307
h=100*z-25
a=h%3652425
b=a-a%4
year=(100*b+h)%36525
c=b+z-365*year-year%4
month=(5*c+456)%153
day=c-word('0 31 61 92 122 153 184 214 245 275 306 337',month-2)
if month>12 then
do
year=year+1
month=month-12
end
yyyy=right(year,4, '0')
mm=right(month,2, '0')
dd=right(day,2, '0')
return(yyyy||Delimiter||mm||Delimiter||dd)

EndBASEDATEXh:
call InitializeDATA
signal Data_19

InitializeDATA:
fb!VarNme=''
fb!RowCnt=0
fb!ColCnt=0
fb!StartLoc=''
return

AddDataLine:
fb!P1=arg(1)
if fb!P1='' then
return
fb!RowCnt=fb!RowCnt+1
if OptionDebugOn='Y' then
call DBG fb!VarNme|| ' (#data) row #' ||fb!RowCnt
fb!ColNumb=0
do while fb!P1<> ''
fb!ColNumb=fb!ColNumb+1
fb!Col=GetQuotedText(fb!P1, "fb!P1")
call value fb!VarNme|| '.' || fb!RowCnt || '.' ||fb!ColNumb,fb!Col
end
if fb!ColCnt=0&fb!RowCnt=1 then
fb!ColCnt=fb!ColNumb
if fb!ColNumb<>fb!ColCnt then
CryAndDie('Incorrect number of #data columns, expected ' || fb!ColCnt || ', found ' ||fb!ColNumb)
return

ProcessDATA:
fb!P1=arg(1)
if fb!P1<> '' then
do
call StackPush "#Data Nesting",,"PPWIZARD's #Data command"
if fb!VarNme<> '' then
CryAndDie("The #Data command can't be nested")
fb!StartLoc=CurrentSourceLocation()
fb!P1=PerformReplacementsInCmdsParameters(fb!P1)
fb!VarNme=GetQuotedText(fb!P1, "fb!P1")
if fb!P1='' then
fb!ColCnt=''
else
fb!ColCnt=GetQuotedText(fb!P1)
if fb!ColCnt='' then
fb!ColCnt=0
call DataChkDef fb!VarNme,fb!ColCnt
interpret 'drop ' || fb!VarNme || '.'
end
else
do
call DBG 'End of ' || fb!RowCnt || ' row #data block started: ' ||fb!StartLoc
call value fb!VarNme|| '.!DataCols',fb!ColCnt
call value fb!VarNme|| '.!StartLocn',fb!StartLoc
call value fb!VarNme|| '.0',fb!RowCnt
call StackPop "#Data Nesting"
call InitializeDATA
end
return(0)

DataChkDef:
parse arg fb!V,fb!N
call DieIfNotRexxSymbol fb!V
if datatype(fb!N, 'W')=0 then
CryAndDie('The #data column count of "' || fb!N || '" is not an integer')
return

DataInfo:call TRACE "OFF"
parse value arg(1)with fb!DataVar '.' fb!DataRow '.' fb!DataCol
if fb!DataVar='' then
CryAndDie("Want which #data information (no name supplied)?")
if fb!DataRow='' & fb!DataCol = '' then
do
fb!Sl=fb!DataVar|| '.!StartLocn'
if symbol(fb!Sl)<> 'VAR' then
fb!DataRc=''
else
fb!DataRc=value(fb!Sl)
end
else
do
if symbol(fb!DataVar|| '.!DataCols') <> 'VAR' then
CryAndDie('A #data item of "' || fb!DataVar || '" does not exist!')
if fb!DataRow="?" then
fb!DataRc=value(fb!DataVar|| '.0')
else
do
if fb!DataCol="?" then
fb!DataRc=value(fb!DataVar|| '.!DataCols')
else
do
fb!DataName=fb!DataVar|| '.' || fb!DataRow || '.' ||fb!DataCol
if symbol(fb!DataName)<> 'VAR' then
do
call DumpVarsIfCompoundVariable fb!DataName
CryAndDie('#data for "' || fb!DataName || '" does not exist!')
end
fb!DataRc=value(fb!DataName)
end
end
end
return(fb!DataRc)

Data_19:
signal PREFIX_20

HASHPREFIX_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'HASHPREFIX', 'Hash prefix is now "' || HashPrefix || '" (' || HashPrefix || 'define etc)'
return

HASHPREFIX_GET:
call HASHPREFIX_DEBUG
return(HashPrefix)

HASHPREFIX_SET:
HashPrefix=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'HASHPREFIX', 'Setting default value of hash Prefix to "' || HashPrefix || '"'
Default4_HashPrefix=HashPrefix
return(0)
end
if HashPrefix=='' then
HashPrefix=Default4_HashPrefix
AfterPrefix=translate(HashPrefix, '',LowerCase)
if AfterPrefix<>HashPrefix then
CryAndDie('A hash prefix should not include lower case characters!')
HashPrefixLng=length(HashPrefix)
call HASHPREFIX_DEBUG
CmdHashAsIs=HashPrefix|| 'ASIS'
CmdHashAutoTag=HashPrefix|| 'AUTOTAG'
CmdHashAutoTagClear=HashPrefix|| 'AUTOTAGCLEAR'
CmdHashAutoTagState=HashPrefix|| 'AUTOTAGSTATE'
CmdHashLoopBreak=HashPrefix|| 'BREAK'
CmdHashLoopContinue=HashPrefix|| 'CONTINUE'
CmdHashData=HashPrefix|| 'DATA'
CmdHashDebug=HashPrefix|| 'DEBUG'
CmdHashDefine=HashPrefix|| 'DEFINE'
CmdHashDefinePlus=HashPrefix|| 'DEFINE+'
CmdHashDefineIfReq=HashPrefix|| 'DEFINE?'
CmdHashDefineRexx=HashPrefix|| 'DEFINEREXX'
CmdHashDefineRexxPlus=HashPrefix|| 'DEFINEREXX+'
CmdHashDependsOn=HashPrefix|| 'DEPENDSON'
CmdHashElseifL=HashPrefix|| 'ELSEIF'
CmdHashEndifL=HashPrefix|| 'ENDIF'
CmdHashEof=HashPrefix|| 'EOF'
CmdHashErrorL=HashPrefix|| 'ERROR'
CmdHashEvaluateL=HashPrefix|| 'EVALUATE'
CmdHashEvaluatePlusL=HashPrefix|| 'EVALUATE+'
CmdHashIf=HashPrefix|| 'IF'
CmdHashIfdef=HashPrefix|| 'IFDEF'
CmdHashIfndef=HashPrefix|| 'IFNDEF'
CmdHashImport=HashPrefix|| 'IMPORT'
CmdHashInclude=HashPrefix|| 'INCLUDE'
CmdHashInfo=HashPrefix|| 'INFO'
CmdHashIntercept=HashPrefix|| 'INTERCEPT'
CmdHashMacroSpace=HashPrefix|| 'MACROSPACE'
CmdHashNextId=HashPrefix|| 'NEXTID'
CmdHashOnExit=HashPrefix|| 'ONEXIT'
CmdHashOption=HashPrefix|| 'OPTION'
CmdHashOutput=HashPrefix|| 'OUTPUT'
CmdHashOutputHold=HashPrefix|| 'OUTPUTHOLD'
CmdHashPush=HashPrefix|| 'PUSH'
CmdHashPop=HashPrefix|| 'POP'
CmdHashRequire=HashPrefix|| 'REQUIRE'
CmdHashSystem=HashPrefix|| 'SYSTEM'
CmdHashTransform=HashPrefix|| 'TRANSFORM'
CmdHashRexxVar=HashPrefix|| 'REXXVAR'
CmdHashUndefL=HashPrefix|| 'UNDEF'
CmdHashWarningL=HashPrefix|| 'WARNING'
CmdHashLoopS=HashPrefix|| '{'
CmdHashLoopE=HashPrefix|| '}'
CmdHash1Line=HashPrefix|| '('
CmdHash1LineEnd=HashPrefix|| ')'
CmdHashOneLine=HashPrefix|| 'ONELINE'
CmdHashEvaluateS=HashPrefix|| 'E'
CmdHashEvaluatePlusS=HashPrefix|| 'E+'
CmdHashUndefS=HashPrefix|| 'U'
CmdHashElseifS=HashPrefix|| 'ELSE'
CmdHashEndifS=HashPrefix|| 'END'
CmdHashErrorS=HashPrefix|| '!'
CmdHashWarningS=HashPrefix|| 'W'
return

PREFIX_20:
signal LineCmt_21

LINECOMMENT_DEBUG:
if OptionDebugOn='Y' then
do
if LineComment<>NullChar then
call OptionDebugShow 'LINECOMMENT', 'Lines starting with "' || LineComment || '" are comments ("' || InLineComment || '" for inline comments)'
else
call OptionDebugShow 'LINECOMMENT', 'Comment removal has been turned off'
end
return

LINECOMMENT_GET:
call LINECOMMENT_DEBUG
return(LineCommentSet2)

LINECOMMENT_SET:
LineComment=arg(1)
LineCommentSet2=LineComment
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'LINECOMMENT', 'Setting default value of line comment to "' || LineComment || '"'
Default4_LineComment=LineComment
return(0)
end
if LineComment=='' then
LineComment=Default4_LineComment
if translate(LineComment)='NULL' then
LineComment=NullChar
else
do
if length(LineComment)<>1 then
CryAndDie('A comment char should be one character long')
end
InLineComment=LineComment||LineComment
call LINECOMMENT_DEBUG
return

LineCmt_21:
signal WhiteSpc_22

_WsFmt:
dbgExtra=''
do CharIndex=1 to length(ExtraWhiteSpace)
if CharIndex<>1 then
dbgExtra=dbgExtra|| ', '
dbgExtra=dbgExtra||c2x(substr(ExtraWhiteSpace,CharIndex,1))
end
return(dbgExtra)

WHITESPACE_DEBUG:
if OptionDebugOn='Y' then
do
if ExtraWhiteSpace=='' then
call OptionDebugShow 'WHITESPACE', 'No extra whitespace characters defined'
else
call OptionDebugShow 'WHITESPACE', 'Extra whitespace characters are hexadecimal ' ||_WsFmt()
end
return

WHITESPACE_GET:
call WHITESPACE_DEBUG
return(ExtraWhiteSpace)

WHITESPACE_SET:
ExtraWhiteSpace=arg(1)
if ProcessedCmdLine='N' then
do
Default4_ExtraWhiteSpace=ExtraWhiteSpace
if ExtraWhiteSpace=='' then
call OptionDebugShow 'WHITESPACE', 'Setting default to no extra whitespace'
else
call OptionDebugShow 'WHITESPACE', 'Setting default to extra whitespace characters are hexadecimal ' ||_WsFmt()
return(0)
end
if ExtraWhiteSpace=='NULL' then
ExtraWhiteSpace=Default4_ExtraWhiteSpace
call WHITESPACE_DEBUG
return

WhiteSpc_22:
signal LineCont_23

LINECONTINUATION_DEBUG:
if OptionDebugOn='Y' then
do
if LineContChar=NullChar then
call OptionDebugShow 'LINECONTINUATION', 'Line continuation handling has been turned off'
else
do
call OptionDebugShow 'LINECONTINUATION', 'The line continuation marker is now "' || LineContChar || '"'
if symbol('CodexNewLine') = 'VAR' then
DbgText='"' || CodexNewLine || '"'
else
DbgText="'X' code for newline"
call DBGIND 1
call DBG '"' || LineContAddNewLine   || '" = Join with    ' ||DbgText
call DBG '"' || LineContWithoutSpace || '" = Join without space'
call DBG '"' || LineContWithSpace    || '" = Join with    space'
call DBG '"' || LineContDefault      || '" = Join with    space'
call DBGIND-1
end
end
return

LINECONTINUATION_GET:
call LINECONTINUATION_DEBUG
return(LineContCharList)

LINECONTINUATION_SET:
LineContParm=arg(1)
LineContParmSet2=LineContParm
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'LINECONTINUATION', 'Setting default value of line continuation chars to "' || LineContParm || '"'
Default4_LineContParm=LineContParm
LineContCharList=LineContParm
return(0)
end
if LineContParm=='' then
LineContParm=Default4_LineContParm
if translate(LineContParm)='NULL' then
LineContParm=NullChar
else
do
if length(LineContParm)<>1&length(LineContParm)<>5 then
CryAndDie('Invalid line continuation spec of "' || LineContParm || '"')
end
LineContCharList=overlay(LineContParm,LineContCharList)
LineContChar=substr(LineContCharList,1,1)
LineContAddNewLine=substr(LineContCharList,2,1)||LineContChar
LineContAddNewLineObs=d2c(25)||LineContChar
LineContWithoutSpace=substr(LineContCharList,3,1)||LineContChar
LineContWithSpace=substr(LineContCharList,4,1)||LineContChar
LineContDefault=substr(LineContCharList,5,1)||LineContChar
call LINECONTINUATION_DEBUG
return

LineCont_23:
AsIsCount=0
AsIsUsing=''
signal AsIs_24

AsIsPrepare:call TRACE "OFF"
AsIsParms=space(arg(1))
AsIsUsing=AsIsParms
AsIsCount=0
AsIsIndex=0
AsIsCollecting=''
call DBG_ASIS 'AsIsPrepare(): Cleared memory. Processing "' || AsIsUsing || '"'
call DBGIND 1
aiOptCnt=0
do while AsIsParms<> ''
call _SetUpAsIsTagging translate(GetQuotedText(AsIsParms, "AsIsParms"))
end
if AsIsCount<>0 then
do
if aiOptCnt=0 then
aiMsg='none'
else
do
if aiOptCnt=AsIsCount then
aiMsg='all'
else
aiMsg=aiOptCnt
end
call DBG_ASIS 'Have ' || AsIsCount || ' "as is" tags (' || aiMsg || ' optimised)'
end
call DBGIND-1
return(AsIsCount)

ExpandAsIsTags:
if AsIsModeOn='N' then
return(arg(1))

AsIs:call TRACE "OFF"
if AsIsCount=0 then
return(arg(1))
EaiString=arg(1)
AsIsCnt=ReplaceCount
do Tag=1 to AsIsIndex
if AsIsBef.Tag=='' then
EaiString=BulkChar2String(EaiString,AsIsAft.Tag)
else
do
if left(AsIsBef.Tag,2)<>SrTypePre then
EaiString=ReplaceString(EaiString,AsIsBef.Tag,AsIsAft.Tag)
else
do
select
when abbrev(AsIsBef.Tag,SrCaseIns)then
EaiString=ReplaceStringCI(EaiString,substr(AsIsBef.Tag,SrCaseIns_P),AsIsAft.Tag)
when abbrev(AsIsBef.Tag,SrFixed)then
EaiString=CompareReplaceFixed2(EaiString,substr(AsIsBef.Tag,SrFixed_P),AsIsAft.Tag)
otherwise
EaiString=ReplaceString(EaiString,AsIsBef.Tag,AsIsAft.Tag)
end
end
end
end
if OptionDebugOn='Y' then
do
if AsIsCnt<>ReplaceCount then
call DebugOutputAfterReplacement EaiString, 'ASIS'
end
return(EaiString)

ProcessAsIs:
HashCmdParms=PerformReplacementsInCmdsParameters(arg(1))
AsIsCmd=translate(GetQuotedText(HashCmdParms, "AsIsParms"))
if AsIsCmd='SETUP' then
do
AsIsPrepCache='?'
call SetupNamedAsIsStorage GetQuotedText(AsIsParms)
return(0)
end
call SetOnorOffVariable AsIsCmd, 'AsIsModeOn'
if AsIsModeOn='N' then
do
AsIsCount=0
if AsIsParms<> '' then
CryAndDie('Did not expect more than the "OFF" parameter')
call OptionsPop
end
else
do
call OptionsPush
call OptionOnOrOff_SET "KEEPINDENT",      "KeepIndent",      "ON"
call OptionOnOrOff_SET "LEAVEBLANKLINES", "LeaveBlankLines", "ON"
call LINECOMMENT_SET "NULL"
call LINECONTINUATION_SET "NULL"
call AsIsPrepare AsIsParms
end
if OptionDebugOn='Y' then
do
if AsIsCount=0 then
call DBG_ASIS 'AsIs mode is ' || YorN2OnorOff(AsIsModeOn) || '.  No tags prepared.'
else
call DBG_ASIS 'AsIs mode is ' || YorN2OnorOff(AsIsModeOn) || '.  Have ' || AsIsCount || ' tags from "' || AsIsUsing || '"'
end
return(0)

SetupNamedAsIsStorage:
AsIsNameU=translate(arg(1))
AsIsName='AI_' ||c2x(AsIsNameU)
AsIsAltCnt=arg(2)
AsIsCounter=0
if AsIsAltCnt='' then
do
TagFrom=AutoTagFirst
TagTo=AutoTagLast
end
else
do
TagFrom=1
TagTo=AsIsAltCnt
end
do Tag=TagFrom to TagTo
AsIsCounter=AsIsCounter+1
if AsIsAltCnt='' then
do
AsIsBef.AsIsCounter.AsIsName=AutoTagOnB.Tag
AsIsAft.AsIsCounter.AsIsName=AutoTagOnA.Tag
end
else
do
AsIsBef.AsIsCounter.AsIsName=ImportB.Tag
AsIsAft.AsIsCounter.AsIsName=ImportA.Tag
end
end
call _valueS AsIsName,AsIsCounter
if AsIsAltCnt='' then
call ClearAutoTags 'N'
call DBG_ASIS 'Captured ' || AsIsCounter || ' tags as "' || AsIsNameU || '"'
return

_SetUpAsIsTagging:
AsIsNameU=translate(arg(1))
AsIsName='AI_' ||c2x(AsIsNameU)
call DBG_ASIS 'Getting tags from storage named "' || AsIsNameU || '"'
call DBGIND 1
if symbol(AsIsName)<> 'VAR' then
CryAndDie('#AsIs "SETUP" has not been run for "' || AsIsNameU || '"')
AsIsCopyCount=_valueG(AsIsName)
do Index=1 to AsIsCopyCount
ThisBefore=AsIsBef.Index.AsIsName
ThisAfter=AsIsAft.Index.AsIsName
AsIsCount=AsIsCount+1
call DBG_ASIS 'AsIs #' || AsIsCount || ': From=' || DebugRightArrow || ThisBefore || DebugLeftArrow || ',  To=' ||DebugRightArrow||ThisAfter||DebugLeftArrow
if length(ThisBefore)<>1 then
do
AsIsCollecting=''
AsIsIndex=AsIsIndex+1
AsIsBef.AsIsIndex=ThisBefore
AsIsAft.AsIsIndex=ThisAfter
end
else
do
if AsIsCollecting=='' then
do
AsIsCollecting='OptAsIs' ||AsIsIndex
call _valueS AsIsCollecting, ''
AsIsIndex=AsIsIndex+1
AsIsBef.AsIsIndex=''
AsIsAft.AsIsIndex=AsIsCollecting
end
aiOptCnt=aiOptCnt+1
aiOptList=_valueG(AsIsCollecting)||ThisBefore
aiIndex=length(aiOptList)
call _valueS AsIsCollecting,aiOptList
call _valueS AsIsCollecting|| '.' ||aiIndex,ThisAfter
end
end
call DBG_ASIS 'Copied ' || AsIsCopyCount || ' tags'
call DBGIND-1
return

AsIs_24:
AtChangeType=''
AtChangeTypeDesc="CASESENSITIVE"
signal AutoTag_25

ShowAutoTagStateWhenDebugOn:
if OptionDebugOn='Y' then
do
if AutoTagName='' then
DbgText1=''
else
DbgText1=' (named "' || AutoTagName || '")'
call DBG_AUTOTAG 'AutoTagging is ' || YorN2OnorOff(AutoTagOn) || '.  Have ' || ((AutoTagLast - AutoTagFirst) + 1) || ' tags available in state #' ||AutoTagStateCnt||DbgText1
if arg(1)='Y' then
do
call DBGIND 1
do Tag=AutoTagFirst to AutoTagLast
call DBG_AUTOTAG 'AutoTag #' || Tag || ': From=' || DebugRightArrow || AutoTagOnB.Tag || DebugLeftArrow || ',  To=' ||DebugRightArrow||AutoTagOnA.Tag||DebugLeftArrow
end
call DBGIND-1
end
end
return

CompletelyInitializeAutoTagState:
AutoTagOn='N'
call ClearAutoTags 'Y'
return

ClearAutoTags:
if arg(1)='N' then
do
if AutoTagStateCnt=0 then
AutoTagLast=0
else
AutoTagLast=AutoTagState.AutoTagStateCnt.Last
end
else
do
AutoTagLast=0
AutoTagStateCnt=0
AutoTagFirst=1
AutoTagName=''
end
if OptionDebugOn='Y' then
do
if AutoTagStateCnt=0 then
call DBG_AUTOTAG 'Cleared ALL autotags (no state information saved - State #0).'
else
call ShowAutoTagStateWhenDebugOn
end
return

AutoTagAdd:call TRACE "OFF"
parse arg gb!B,gb!A,gb!T,gb!S
if gb!T=='' then
gb!T=Default4_ATCHANGETYPEDESC
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'AutoTagAdd(): Assigning ' || DebugRightArrow || gb!B || DebugLeftArrow || ' = ' || DebugRightArrow || gb!A || DebugLeftArrow || ' (TYPE=' || gb!T || ')'
call _AddAutoTag GetCtCode(gb!T)||gb!B,gb!A,gb!S
return

AutoTag:call TRACE "OFF"
EatString=arg(1)
if AutoTagFirst>AutoTagLast then
return(EatString)
AtCnt=ReplaceCount
do Tag=AutoTagFirst to AutoTagLast
if left(AutoTagOnB.Tag,2)<>SrTypePre then
EatString=ReplaceString(EatString,AutoTagOnB.Tag,AutoTagOnA.Tag)
else
do
select
when abbrev(AutoTagOnB.Tag,SrCaseIns)then
EatString=ReplaceStringCI(EatString,substr(AutoTagOnB.Tag,SrCaseIns_P),AutoTagOnA.Tag)
when abbrev(AutoTagOnB.Tag,SrFixed)then
EatString=CompareReplaceFixed2(EatString,substr(AutoTagOnB.Tag,SrFixed_P),AutoTagOnA.Tag)
otherwise
EatString=ReplaceString(EatString,AutoTagOnB.Tag,AutoTagOnA.Tag)
end
end
end
if OptionDebugOn='Y' then
do
if AtCnt<>ReplaceCount then
call DebugOutputAfterReplacement EatString, 'ATAG'
end
return(EatString)

ProcessAutoTagClear:
if arg(1)='' then
AtClearAll='N'
else
do
AtParm=GetQuotedText(arg(1))
if translate(AtParm)<> 'ALL' then
CryAndDie('Invalid parameter of "' || AtParm || '" specified!')
AtClearAll='Y'
end
call ClearAutoTags AtClearAll
return(0)

_GetStateIndexForNameOrDie:
gsiName=arg(1)
do NameIndex=1 to AutoTagStateCnt
if gsiName=AutoTagState.NameIndex.Name then
return(NameIndex)
end
CryAndDie('There is no state known as "' || gsiName(1) || '"')

MatchesAutoTagStateIncDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#AutoTagState +" at ' || AutoTagState.MatchIndex.AtLine || ')')

ProcessAutoTagState:
Rest=strip(arg(1))
Ats1stParm=left(Rest,1)
if Ats1stParm='+' | Ats1stParm = '-' then
Rest=substr(Rest,2)
else
Ats1stParm=GetQuotedText(arg(1), "Rest")
select
when Ats1stParm='+' then
do
AutoTagStateCnt=AutoTagStateCnt+1
AutoTagState.AutoTagStateCnt.First=AutoTagFirst
AutoTagState.AutoTagStateCnt.Last=AutoTagLast
AutoTagState.AutoTagStateCnt.Name=AutoTagName
AutoTagState.AutoTagStateCnt.AtOnOff=AutoTagOn
AutoTagState.AutoTagStateCnt.AtLine=CurrentSourceLocation()
BeforeFirst=AutoTagFirst
BeforeLast=AutoTagLast
AutoTagFirst=AutoTagLast+1
AutoTagName=''
do while Rest<> ''
StateAlias=translate(GetQuotedText(Rest, "Rest"))
if StateAlias="REMEMBER" then
do
CopyFrom=BeforeFirst
Copyto=BeforeLast
end
else
do
NameIndex=_GetStateIndexForNameOrDie(StateAlias)
CopyFrom=AutoTagState.NameIndex.First
Copyto=AutoTagState.NameIndex.Last
end
do AddTagIndex=CopyFrom to CopyTo
call _AddAutoTag AutoTagOnB.AddTagIndex,AutoTagOnA.AddTagIndex
end
end
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'Remembering current #AutoTag state, now in state #' ||AutoTagStateCnt
end
when Ats1stParm='-' then
do
if AutoTagStateCnt<=0 then
CryAndDie('No #autotag states memorised!')
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'This restore matches the setup at ' ||AutoTagState.AutoTagStateCnt.AtLine
BeforeFirst=AutoTagFirst
BeforeLast=AutoTagLast
AutoTagFirst=AutoTagState.AutoTagStateCnt.First
AutoTagLast=AutoTagState.AutoTagStateCnt.Last
AutoTagOn=AutoTagState.AutoTagStateCnt.AtOnOff
AutoTagName=AutoTagState.AutoTagStateCnt.Name
AutoTagStateCnt=AutoTagStateCnt-1
if Rest='' then
Remember='N'
else
do
Rest=translate(GetQuotedText(Rest, "Rest"))
if Rest="REMEMBER" then
Remember='Y'
else
CryAndDie('Invalid parameter of "' || Rest || '" specified (expected "REMEMBER")')
end
if Rest='' then
DbgWord='dropping'
else
do
Rest=translate(GetQuotedText(Rest))
if Rest<> "REMEMBER" then
CryAndDie('Invalid parameter of "' || Rest || '" specified (expected "REMEMBER")')
DbgWord='remembering'
AutoTagLast=AutoTagFirst-1
do AddTagIndex=BeforeFirst to BeforeLast
call _AddAutoTag AutoTagOnB.AddTagIndex,AutoTagOnA.AddTagIndex
end
end
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'Restoring #AutoTag state #' || AutoTagStateCnt || ', we are ' || DbgWord || ' any new tags you may have defined'
end
otherwise
AutoTagName=translate(Ats1stParm)
if Rest<> '' then
call DieIfExtraUnexpectedParms Rest
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'This state is now named "' || AutoTagName || '"'
end
call ShowAutoTagStateWhenDebugOn AutoTagOn
return(0)

_AddAutoTag:
TheTagB=arg(1)
TheTagA=arg(2)
ThePosn=arg(3)
if ThePosn='' then
ThePosn='999999'
ThePosn=(ThePosn+AutoTagFirst)-1
if ThePosn>AutoTagLast then
do
AutoTagLast=AutoTagLast+1
SlotIndex=AutoTagLast
end
else
do
ToIndex=AutoTagLast+2
do MoveIndex=ThePosn to AutoTagLast
ToIndex=ToIndex-1
FromIndex=ToIndex-1
AutoTagOnB.ToIndex=AutoTagOnB.FromIndex
AutoTagOnA.ToIndex=AutoTagOnA.FromIndex
end
SlotIndex=ThePosn
AutoTagLast=AutoTagLast+1
end
AutoTagOnB.SlotIndex=TheTagB
AutoTagOnA.SlotIndex=TheTagA
return

_DeleteAutoTag:
TheTagB=arg(1)
do Tag=AutoTagFirst to AutoTagLast
if TheTagB=AutoTagOnB.Tag then
do
AutoTagLast=AutoTagLast-1
do ToIndex=Tag to AutoTagLast
FromIndex=ToIndex+1
AutoTagOnB.ToIndex=AutoTagOnB.FromIndex
AutoTagOnA.ToIndex=AutoTagOnA.FromIndex
end
return('Y')
end
end
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'No need to delete the tag (it does not exist)'
return('N')

ProcessAutoTag:
AtBefore=GetQuotedText(arg(1), "Rest")
if AtBefore=='' then
CryAndDie("You did not supply text to be replaced (can't replace empty string)!")
AtDumpList='N'
OnOrOff=IsStringOnOrOffCmd(AtBefore)
if OnOrOff<> '' & Rest = '' then
do
AutoTagOn=OnOrOff
if AutoTagOn='Y' then
AtDumpList='Y'
end
else
do
AtBefore_NoCT=AtBefore
AtBefore=AtChangeType||AtBefore
if Rest='' then
call _DeleteAutoTag AtBefore
else
do
AtAfter=ReplaceString(GetQuotedText(Rest, "Rest"),AutoTagSelf,AtBefore_NoCT)
if ReplacementsAllowed='Y' then
do
do while pos(StartsMacroReplacement,AtAfter)<>0
BeforeCount=ReplaceCount
AtAfterR=_ReplaceAllHashDefinedVariables(AtAfter)
if pos(MarksNewLine,AtAfterR)<>0 then
leave
AtAfter=AtAfterR
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
call DebugOutputAfterReplacement AtAfter, 'VP2O'
end
end
if pos(StartsStdSymbolReplacement,AtAfter)<>0 then
do
if pos(MarksNewLine,AtAfter)=0 then
do
BeforeCount=ReplaceCount
AtAfterR=ReplaceStandardDefinitions(AtAfter)
if BeforeCount<>ReplaceCount then
do
if pos(MarksNewLine,AtAfterR)=0 then
do
AtAfter=AtAfterR
if OptionDebugOn='Y' then
call DebugOutputAfterReplacement AtAfter, 'SP2O'
end
end
end
end
end
AtSlot=''
if Rest<> '' then
do
SlotSpec=word(rest,1)
Rest=subword(rest,2)
if left(SlotSpec,1)<> '#' then
CryAndDie('Invalid slot specification of "' || SlotSpec || '" supplied, must begin with a "#"!')
AtSlot=substr(SlotSpec,2)
end
if OptionDebugOn='Y' then
call DBG_AUTOTAG 'Assigning ' || DebugRightArrow || AtBefore_NoCT || DebugLeftArrow || ' = ' || DebugRightArrow || AtAfter || DebugLeftArrow || ' (TYPE=' || AtChangeTypeDesc || ')'
call _AddAutoTag AtBefore,AtAfter,AtSlot
end
end
call ShowAutoTagStateWhenDebugOn AtDumpList
if Rest<> '' then
CryAndDie('Too many parameters!')
return(0)

ATCHANGETYPE_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'ATCHANGETYPE', 'AutoTag change type is "' || AtChangeTypeDesc || '"'
return

ATCHANGETYPE_GET:
call ATCHANGETYPE_DEBUG
return(AtChangeTypeDesc)

ATCHANGETYPE_SET:
AtChangeTypeDesc=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'ATCHANGETYPE', 'Setting default change type to "' || AtChangeTypeDesc || '"'
Default4_ATCHANGETYPEDESC=AtChangeTypeDesc
return(0)
end
if AtChangeTypeDesc=='' then
AtChangeTypeDesc=Default4_ATCHANGETYPEDESC
AtChangeType=GetCtCode(AtChangeTypeDesc)
call ATCHANGETYPE_DEBUG
return

GetCtCode:
hb!D=arg(1)
hb!U=translate(hb!D)
hb!ReginaBugWorkAround='N'
select
when hb!U="CASESENSITIVE" then
do
hb!ReginaBugWorkAround='Y'
hb!C=''
end
when hb!U="CASEINSENSITIVE" then
do
hb!ReginaBugWorkAround='Y'
hb!C=SrCaseIns
end
when hb!U="FIXED" then
do
hb!ReginaBugWorkAround='Y'
hb!C=SrFixed
end
otherwise
do
if hb!ReginaBugWorkAround='N' then
CryAndDie('Unknown AutoTag Change Type of "' || hb!D || '"')
end
end
return(hb!C)

AutoTag_25:
DefRexxSpecialSepTag='<' || '?xRexxEos>'
call InitializeDefineRexx
ValidPpwTrace='OFF ON AUTO'
signal Def_Rexx_26

MakeSafeInSQuotes:
ib!Str=arg(1)
ib!Str=ReplaceString(ib!Str, "'", "''")
ib!L1M=left(StartsMacroReplacement,1)
ib!Str=ReplaceString(ib!Str,ib!L1M, "' || '" || ib!L1M || "' || '")
ib!L1P=left(StartsMacroParm,1)
ib!Str=ReplaceString(ib!Str,ib!L1P, "' || '" || ib!L1P || "' || '")
return(ib!Str)

InitializeDefineRexx:
DefRexxVar=''
DefRexxAddType=''
DefRexxCode=''
DefRexxStartLoc=''
DefRexxPack='Y'
DefRexxTraceNext='N'
DefRexxLineCnt=0
if symbol('OptionPpwTrace') = 'VAR' then
DefRexxTrace=OptionPpwTrace
else
DefRexxTrace='OFF'
DefRexxNumTrace=0
DefRexxTraceAllowed='Y'
return

ProcessDefineRexx:
if arg(1)='' then
do
if DefRexxVar='' then
CryAndDie("Not currently defining rexx code!", 'To execute you need to specify a parameter of ""')
if DefRexxNumTrace<>0 then
do
if DefRexxVar<> '?JustExec?';then
EndCmt='@Finished@ (Executing rexx from macro "' || DefRexxVar || '")'
else
EndCmt="@Finished@"
call DefRexxAddLine "call RexxTrace '" || EndCmt || "','?'"
DefRexxNumTrace=DefRexxNumTrace+1
call DBG_DEFINING DefRexxNumTrace|| ' $trace statements inserted'
end
if DefineMacroReplace='Y' then
DefRexxCode=PerformReplacementsInCmdsParameters(DefRexxCode)
if DefRexxVar<> '?JustExec?';then
do
call AddHashDefine DefRexxVar,DefRexxCode,DefRexxAddType
end
else
do
if OptionDebugOn='Y' then
call DBG_DEFINING 'Rexx code will be immediately executed but not saved'
call ExecRexxCmd DefRexxCode, 'Y'
end
call InitializeDefineRexx
end
else
do
if DefRexxVar<> '' then
CryAndDie("Already in rexx code block started at " ||DefRexxStartLoc)
call InitializeDefineRexx
DefRexxStartLoc=CurrentSourceLocation()
DefRexxAddType=arg(2)
DefRexxVar=GetQuotedText(PerformReplacementsInCmdsParameters(arg(1)), "Rest")
if DefRexxVar='' then
do
DefRexxVar='?JustExec?';
DefRexxPack='N'
end
if Rest<> '' then
do
Rest=translate(Rest)
do until Rest=''
DefSpec=GetQuotedText(Rest, "Rest")
select
when DefSpec='NOPACK' then
DefRexxPack='N'
when DefSpec='TRACE:AUTO' then
DefRexxTrace='AUTO'
when DefSpec='TRACE:ON' | DefSpec = '$TRACE' then
DefRexxTrace='ON'
when DefSpec='TRACE:OFF' then
DefRexxTrace='OFF'
otherwise
CryAndDie('Invalid option of "' || DefSpec || '" used')
end
end
end
if OptionPpwTraceAllowed='N' then
do
if DefRexxTrace<> 'OFF' then
do
call DBG_DEFINING 'Tracing turned off with /PPWTRACE, otherwise would trace using "' || DefRexxTrace || '"!'
DefRexxTrace='OFF'
end
end
if OptionDebugOn='Y' then
do
if DefRexxPack='Y' then
call DBG_DEFINING "AllowPack option is currently " ||YorN2OnorOff(AllowPack)
if DefRexxTrace='OFF' then
call DBG_DEFINING '$Trace and $Breakpoint commands will be ignored!'
else
do
if DefRexxTrace='AUTO' then
call DBG_DEFINING '$Trace statements for each line are being automatically inserted!'
else
call DBG_DEFINING '$Trace statements for each line are NOT being automatically inserted!'
end
end
if DefRexxTrace<> 'OFF' then
do
if DefRexxVar<> '?JustExec?';then
StrCmt='@Starting@ (Executing rexx from macro "' || DefRexxVar || '")'
else
StrCmt="@Starting@ (direct: " || CurrentSourceLocation() || ")"
call DefRexxAddLine "call RexxTrace '" || StrCmt || "','?'"
DefRexxNumTrace=DefRexxNumTrace+1
end
end
return(0)

AddDefineRexxLine:
NewRexxLine=strip(arg(1))
DefRexxLineCnt=DefRexxLineCnt+1
if right(NewRexxLine,2)=RexxCmtEnd then
do
StartCmtPos=lastpos(RexxCmtStart,NewRexxLine)
if StartCmtPos<>0 then
do
if StartCmtPos=0 then
NewRexxLine=''
else
NewRexxLine=strip(left(NewRexxLine,StartCmtPos-1), 'T')
end
end
do while right(NewRexxLine,1)=';'
NewRexxLine=strip(left(NewRexxLine,length(NewRexxLine)-1), 'T')
end
if NewRexxLine='' then
return
UnpackedLine=space(NewRexxLine)
if DefRexxPack='Y' then
do
if AllowPack='Y' then
NewRexxLine=CompressRexxLine(NewRexxLine)
end
DropLine='N'
jb!W1=translate(word(NewRexxLine,1))
select
when jb!W1="$BREAKPOINT" then
do
UserTraceCmt=subword(NewRexxLine,2)
if DefRexxTrace='OFF' then
jb!I='Ignoring - '
else
do
jb!I=''
UserTraceCmt=MakeSafeInSQuotes(UserTraceCmt)
NewRexxLine="call UserBreakPoint '$BreakPoint: " || UserTraceCmt || "','?'"
call DefRexxAddLine NewRexxLine
DefRexxNumTrace=DefRexxNumTrace+1
end
call DBG_DEFINING jb!I|| '$BreakPoint: ' ||UserTraceCmt
DropLine='Y'
end
when jb!W1="$TRACE" then
do
DropLine='Y'
if DefRexxTrace='OFF' then
call DBG_DEFINING 'Ignoring - $Trace command'
else
do
Rest=translate(subword(NewRexxLine,2))
select
when Rest="ON" then
DefRexxTraceAllowed='Y'
when Rest="OFF" then
DefRexxTraceAllowed='N'
otherwise
do
UserTraceCmt=subword(NewRexxLine,2)
if UserTraceCmt='' then
DefRexxTraceNext="Y"
else
do
call DBG_DEFINING '$tracing comment: ' ||UserTraceCmt
DefRexxTraceNext="N"
UserTraceCmt=MakeSafeInSQuotes(UserTraceCmt)
NewRexxLine="call RexxTrace '" || UserTraceCmt || "','?'"
call DefRexxAddLine NewRexxLine
DefRexxNumTrace=DefRexxNumTrace+1
end
end
end
end
end
otherwise
end
if DropLine='Y' then
DropLine='N'
else
do
if DefRexxTraceNext="Y" then
TraceThis='Y'
else
do
if DefRexxTrace<> 'AUTO' then
TraceThis='N'
else
do
if pos('/' || translate(NewRexxLine) || '/', "/THEN/DO/ELSE/")=0 then
TraceThis='Y'
else
TraceThis='N'
end
end
if TraceThis='Y' then
do
DefRexxTraceNext="N"
if DefRexxTraceAllowed='Y' then
do
call DBG_DEFINING '$tracing: ' ||UnpackedLine
TraceThis=MakeSafeInSQuotes(UnpackedLine)
NewRexxLine="call RexxTrace '@" || DefRexxLineCnt || " -> " || TraceThis || "',,'Y'" ||DefRexxSpecialSepTag||NewRexxLine
DefRexxNumTrace=DefRexxNumTrace+1
end
end
call DefRexxAddLine NewRexxLine
end
return

DefRexxAddLine:
if DefRexxCode='' then
DefRexxCode=arg(1)
else
DefRexxCode=DefRexxCode||DefRexxSpecialSepTag||arg(1)
return

PPWTRACE_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'PPWTRACE', 'PPWTRACE is set to "' || OptionPpwTrace || '"'
return

PPWTRACE_SET:
OptionPpwTrace=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'PPWTRACE', 'Setting default PPWTRACE to "' || OptionPpwTrace || '"'
DefaultPpwTrace=OptionPpwTrace
return(0)
end
if OptionPpwTrace=='' then
OptionPpwTrace=DefaultPpwTrace
if pos(OptionPpwTrace,ValidPpwTrace)=0 then
CryAndDie('Invalid PPWTRACE value of "' || OptionPpwTrace || '", should be one of "' || ValidPpwTrace || '"!')
call PPWTRACE_DEBUG
return

PPWTRACE_GET:
call PPWTRACE_DEBUG
return(OptionPpwTrace)

Def_Rexx_26:
OptionCount=0
LongestPpwOptionLng=0
call _OptionsAdd "ALLOWPACK"
call _OptionsAdd "ALLOWSPELL"
call _OptionsAdd "CSREPLACEMENT"
call _OptionsAdd "DEFINEMACROREPLACE"
call _OptionsAdd "KEEPINDENT"
call _OptionsAdd "LEAVEBLANKLINES"
call _OptionsAdd "REPLACE"
call _OptionsAdd "ATCHANGETYPE"
call _OptionsAdd "DEBUGLEVEL"
call _OptionsAdd "EXTRAINDENT"
call _OptionsAdd "EXPANDX"
call _OptionsAdd "HASHPREFIX"
call _OptionsAdd "LINECOMMENT"
call _OptionsAdd "LINECONTINUATION"
call _OptionsAdd "MACROPARMTAGS"
call _OptionsAdd "PARMVAL"
call _OptionsAdd "PPWTRACE"
call _OptionsAdd "REPLACEMENTTAGS"
call _OptionsAdd "TABS"
call _OptionsAdd "WARNINGS"
call _OptionsAdd "WHITESPACE"
signal OPTION_27

_OptionsAdd:
OptionCount=OptionCount+1
OptionList.OptionCount=arg(1)
ThisLng=length(arg(1))
if ThisLng>LongestPpwOptionLng then
LongestPpwOptionLng=ThisLng
return

SetUpPpwizardOptionDefaults:
if RexIsAscii='N' then
DefWhite=''
else
do
if RexSystemOpSys<> "UNIX" then
DefWhite=d2c(26)||d2c(27)
else
DefWhite=d2c(13)||d2c(26)||d2c(27)
end
ProcessedCmdLine='N'
call DBG_OPTIONS 'Setting PPWIZARD defaults (may be overriden with ' || OptChar || 'option switch)'
call DBGIND 1
call OptionOnOrOff_SET "ALLOWPACK",          "AllowPack",           "ON"
call OptionOnOrOff_SET "ALLOWSPELL",         "AllowSpell",          "ON"
call ATCHANGETYPE_SET "CASESENSITIVE"
call OptionOnOrOff_SET "CSREPLACEMENT",      "CsReplacement",       "OFF"
call DEBUGLEVEL_SET 'DEFAULT'
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",  "OFF"
call EXPANDX_SET 'LATE'
call EXTRAINDENT_SET 'NULL'
call HASHPREFIX_SET '#'
call OptionOnOrOff_SET "KEEPINDENT",         "KeepIndent",          "OFF"
call OptionOnOrOff_SET "LEAVEBLANKLINES",    "LeaveBlankLines",     "OFF"
call LINECOMMENT_SET ';'
call LINECONTINUATION_SET '\%-+ '
call MACROPARMTAGS_SET '{}$'
call OptionOnOrOff_SET "REPLACE",            "ReplacementsAllowed", "ON"
call PARMVAL_SET "SOME"
if OptionDebugOn='Y' then
kb!D='ON'
else
kb!D='OFF'
call PPWTRACE_SET kb!D
call REPLACEMENTTAGS_SET '<>$?[]'
call TABS_SET 'Warnings'
call WARNINGS_SET ''
call WHITESPACE_SET DefWhite
call DBGIND-1
return

SetUpOptionsForThisBuild:
ProcessedCmdLine='Y'
call DBG_OPTIONS 'Initializing #options for this build of ' ||CurrentOutFile
call DBGIND 1
call OptionOnOrOff_SET "ALLOWPACK",          "AllowPack",           ""
call OptionOnOrOff_SET "ALLOWSPELL",         "AllowSpell",          ""
call ATCHANGETYPE_SET ''
call OptionOnOrOff_SET "CSREPLACEMENT",      "CsReplacement",       ""
call DEBUGLEVEL_SET ''
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",  ""
call EXPANDX_SET ''
call EXTRAINDENT_SET ''
call HASHPREFIX_SET ''
call OptionOnOrOff_SET "KEEPINDENT",         "KeepIndent",          ""
call OptionOnOrOff_SET "LEAVEBLANKLINES",    "LeaveBlankLines",     ""
call LINECOMMENT_SET ''
call LINECONTINUATION_SET ''
call MACROPARMTAGS_SET ''
call OptionOnOrOff_SET "REPLACE",            "ReplacementsAllowed", ""
call PARMVAL_SET ''
call PPWTRACE_SET ''
call REPLACEMENTTAGS_SET ''
call TABS_SET ''
call WARNINGS_SET ''
call WHITESPACE_SET 'NULL'
call DBGIND-1
return

MatchesOptionStackPushDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#option PUSH" at ' || OptPush.MatchIndex || ')')

OptionsPush:
OptionStackCnt=OptionStackCnt+1
OptPush.OptionStackCnt=CurrentSourceLocation()
PushName='OptPush' ||OptionStackCnt
if OptionDebugOn='Y' then
call DBG_OPTIONS 'Saving current options on stack as #' ||OptionStackCnt
call DBGIND 1
do OptionIndex=1 to OptionCount
call _valueS PushName|| '.' ||OptionIndex,OptionGetValue(OptionList.OptionIndex)
end
call DBGIND-1
return

OptionsPop:
if OptionStackCnt<=0 then
CryAndDie('There are no options on the stack to pop!')
if OptionDebugOn='Y' then
call DBG_OPTIONS 'Restoring current options from #' || OptionStackCnt || ' (pushed at ' || OptPush.OptionStackCnt || ')'
call DBGIND 1
PushName='OptPush' ||OptionStackCnt
do OptionIndex=1 to OptionCount
call OptionSetValue OptionList.OptionIndex,_valueG(PushName|| '.' ||OptionIndex)
end
call DBGIND-1
OptionStackCnt=OptionStackCnt-1
return

ProcessOption:
Options=arg(1)
if ProcessedCmdLine='Y' then
Options=PerformReplacementsInCmdsParameters(Options)
if Options='' then
CryAndDie('No options specified!')
OptCnt=0
do while Options<> ''
parse var Options Word1' 'RestOptions
Word1=translate(word1)
OptCnt=OptCnt+1
select
when Word1="PUSH" | Word1 = "+" then
do
Options=RestOptions
call OptionsPush
end
when Word1="POP" | Word1 = "-" then
do
Options=RestOptions
call OptionsPop
end
otherwise
do
if pos('=',Options)=0 then
CryAndDie('#option #' || OptCnt || ' is either invalid or should be followed by a value, found: ' ||Options)
parse var Options ThisOption'='Options
ThisOption=translate(strip(ThisOption))
ThisValue=GetQuotedText(Options, "Options")
call OptionSetValue ThisOption,ThisValue
end
end
end
return(0)

OptionDebugShow:
if OptionDebugOn='Y' then
do
kb!M=left(arg(1),LongestPpwOptionLng)|| ': ' ||arg(2)
if arg(1)='DEBUGLEVEL' then
call DBG kb!M
else
call DBG_OPTIONS kb!M
end
return

OptionOnOrOff_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow arg(1), 'Currently set to ' ||YorN2OnorOff(_valueG(arg(2)))
return

OptionOnOrOff_SET:
parse arg OptionName,OnOffVar2Set,OnOffValue
if ProcessedCmdLine='N' then
do
call OptionDebugShow OptionName, 'Setting default to "' || OnOffValue || '"'
call _valueS "Default4_" ||OnOffVar2Set,OnOffValue
return(0)
end
if OnOffValue=='' then
OnOffValue=_valueG("Default4_" ||OnOffVar2Set)
OnOrOff=IsStringOnOrOffCmd(OnOffValue)
if OnOrOff='' then
CryAndDie('Tried to set "' || OnOffVar2Set || '" to an invalid value of "' || OnOffValue || '"')
call _valueS OnOffVar2Set,OnOrOff
call OptionOnOrOff_DEBUG OptionName,OnOffVar2Set
return(0)

OptionOnOrOff_GET:
parse arg OptionName,OnOffVar2Get
VarState=YorN2OnorOff(_valueG(OnOffVar2Get))
call OptionOnOrOff_DEBUG OptionName,OnOffVar2Get
return(VarState)

OptionSetValue:
parse arg sOption,sValue
select
when sOption="ALLOWPACK" then
call OptionOnOrOff_SET "ALLOWPACK", "AllowPack",sValue
when sOption="ALLOWSPELL" then
call OptionOnOrOff_SET "ALLOWSPELL", "AllowSpell",sValue
when sOption="ATCHANGETYPE" then
call ATCHANGETYPE_SET sValue,sOption
when sOption="CSREPLACEMENT" then
call OptionOnOrOff_SET "CSREPLACEMENT", "CsReplacement",sValue
when sOption="DEBUGLEVEL" then
call DEBUGLEVEL_SET sValue,sOption
when sOption="DEFINEMACROREPLACE" then
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",sValue
when sOption="EXPANDX" then
call EXPANDX_SET sValue,sOption
when sOption="EXTRAINDENT" then
call EXTRAINDENT_SET sValue,sOption
when sOption="HASHPREFIX" then
call HASHPREFIX_SET sValue,sOption
when sOption="KEEPINDENT" then
call OptionOnOrOff_SET "KEEPINDENT", "KeepIndent",sValue
when sOption="LEAVEBLANKLINES" then
call OptionOnOrOff_SET "LEAVEBLANKLINES", "LeaveBlankLines",sValue
when sOption="LINECOMMENT" then
call LINECOMMENT_SET sValue,sOption
when sOption="LINECONTINUATION" then
call LINECONTINUATION_SET sValue,sOption
when sOption="MACROPARMTAGS" then
call MACROPARMTAGS_SET sValue,sOption
when sOption="PARMVAL" then
call PARMVAL_SET sValue,sOption
when sOption="PPWTRACE" then
call PPWTRACE_SET sValue,sOption
when sOption="REPLACE" then
call OptionOnOrOff_SET "REPLACE", "ReplacementsAllowed",sValue
when sOption="REPLACEMENTTAGS" then
call REPLACEMENTTAGS_SET sValue,sOption
when sOption="TABS" then
call TABS_SET sValue,sOption
when sOption="WARNINGS" then
call WARNINGS_SET sValue,sOption
when sOption="WHITESPACE" then
call WHITESPACE_SET sValue,sOption
otherwise
CryAndDie("Can't set '" || sOption || "' as this option is unknown")
end
return

OptionGetValue:
parse arg gOption
select
when gOption="ALLOWPACK" then
return(OptionOnOrOff_GET("ALLOWPACK", "AllowPack"))
when gOption="ALLOWSPELL" then
return(OptionOnOrOff_GET("ALLOWSPELL", "AllowSpell"))
when gOption="ATCHANGETYPE" then
return(ATCHANGETYPE_GET(gOption))
when gOption="CSREPLACEMENT" then
return(OptionOnOrOff_GET("CSREPLACEMENT", "CsReplacement"))
when gOption="DEBUGLEVEL" then
return(DEBUGLEVEL_GET(gOption))
when gOption="DEFINEMACROREPLACE" then
return(OptionOnOrOff_GET("DEFINEMACROREPLACE", "DefineMacroReplace"))
when gOption="EXPANDX" then
return(EXPANDX_GET(gOption))
when gOption="EXTRAINDENT" then
return(EXTRAINDENT_GET(gOption))
when gOption="HASHPREFIX" then
return(HASHPREFIX_GET(gOption))
when gOption="KEEPINDENT" then
return(OptionOnOrOff_GET("KEEPINDENT", "KeepIndent"))
when gOption="LEAVEBLANKLINES" then
return(OptionOnOrOff_GET("LEAVEBLANKLINES", "LeaveBlankLines"))
when gOption="LINECOMMENT" then
return(LINECOMMENT_GET(gOption))
when gOption="LINECONTINUATION" then
return(LINECONTINUATION_GET(gOption))
when gOption="MACROPARMTAGS" then
return(MACROPARMTAGS_GET(gOption))
when gOption="PARMVAL" then
return(PARMVAL_GET(gOption))
when gOption="PPWTRACE" then
return(PPWTRACE_GET(gOption))
when gOption="REPLACE" then
return(OptionOnOrOff_GET("REPLACE", "ReplacementsAllowed"))
when gOption="REPLACEMENTTAGS" then
return(REPLACEMENTTAGS_GET(gOption))
when gOption="TABS" then
return(TABS_GET(gOption))
when gOption="WARNINGS" then
return(WARNINGS_GET(gOption))
when gOption="WHITESPACE" then
return(WHITESPACE_GET(gOption))
otherwise
CryAndDie("Can't get '" || gOption || "' as this option is unknown")
end
return

OPTION_27:
NameOfOs2ReginaRexxInterpreter=""
signal Rexx_28

_GetNameOfMacroSpaceExe:
if Symbol('MacroSpaceExe') <> 'VAR' then
do
MacroSpaceExeBase='MacroSpc.EXE'
MacroSpaceExe=_filespec('drive', PpWizardPgmName) || _filespec('Path',PpWizardPgmName)||MacroSpaceExeBase
if FileQueryExists(MacroSpaceExe)='' then
do
MacroSpaceExe=FindFileInPath(MacroSpaceExeBase, '*PATH')
if MacroSpaceExe="" then
MacroSpaceExe=FindFileInPath(MacroSpaceExeBase, '*DPATH')
end
call DBG 'Macro Space Pgm: ' ||MacroSpaceExe
end
return(MacroSpaceExe)

_GetNameOfOs2ReginaExe:
if Symbol('Os2ReginaExe') <> 'VAR' then
do
Os2ReginaExeBase='ROS2REXX.EXE'
Os2ReginaExe=_filespec('drive', PpWizardPgmName) || _filespec('Path',PpWizardPgmName)||Os2ReginaExeBase
if FileQueryExists(Os2ReginaExe)='' then
do
Os2ReginaExe=FindFileInPath(Os2ReginaExeBase, '*PATH')
end
end
return(Os2ReginaExe)

DoMacroSpaceOperation:
parse arg MsCommand,MsFile,MsFunction,MsQuiet
CallersLine=SIGL
call DBG 'Trying to macrospace "' || MsCommand || '" "' || MsFile || '" alias (' || MsFunction || ')'
TmpFile=RexGetTmpFileName('ms??????.PPW')
CheckPgm=_GetNameOfMacroSpaceExe()
if CheckPgm='' then
do
if MsQuiet="QUIET" then
return
else
CryAndDie("Can't perform macro space command as " || MacroSpaceExeBase || ' is unavailable.')
end
FailMsg='MACRO SPACE COMMAND FAILED'
call AddressCmd CheckPgm|| ' ' || MsCommand || ' ' || MsFile || ' ' || MsFunction || ' >' || TmpFile || ' 2>&1'
if MsQuiet="QUIET" then
return
else
signal CheckMacroSpaceRc

CheckRexxModuleForSyntaxErrors:
call DBG 'CheckRexxModuleForSyntaxErrors()'
if RexWhich='REGINA' then
do
call CallStubInGeneratedCodeToCheckSyntax
return
end
CallersLine=SIGL
TmpFile=RexGetTmpFileName('rc??????.PPW')
CheckPgm=_GetNameOfMacroSpaceExe()
if CheckPgm='' then
do
call DBG "Can't use normal validation method on the rexx syntax - " || MacroSpaceExeBase || ' file not found!'
call CallStubInGeneratedCodeToCheckSyntax
return
end
FailMsg='INVALID SYNTAX'
call AddressCmd CheckPgm|| ' CheckSyntax ' || Output.1.File || ' >' || NameOfNulDevice() || ' 2>' ||TmpFile

CheckMacroSpaceRc:
CheckRc=Rc
if CheckRc=0 then
do
DosDelRc=_SysFileDelete(TmpFile)
call UseOs2ReginaToDoubleCheckSyntax
return
end
call Line1 ''
call ColorSet 'ERROR'
call Line1 FailMsg
call Line1 copies('~',length(FailMsg))
do while lines(TmpFile)<>0
call Line1 linein(TmpFile)
end
call ColorSet
call _FileClose TmpFile
DosDelRc=_SysFileDelete(TmpFile)
AbnormalExit(CallersLine, "Syntax Error in generated rexx code")

CallStubInGeneratedCodeToCheckSyntax:
CheckingFile=Output.1.File
call DBGIND 1
call DBG 'Calling stub in generated code'
signal ON SYNTAX NAME SyntaxErrorInGeneratedCode
CheckRc='*?*'
interpret 'CheckRc =  "' || CheckingFile || '"("' || SyntaxOkText || '")'
if CheckRc<>SyntaxOkRc then
CryAndDie('Probably Syntax Error, got unexpected RC of "' || CheckRc || '"')
call DBGIND-1
return

SyntaxErrorInGeneratedCode:
CryAndDie('Faulty syntax in generated "' || CheckingFile || '"!')

UseOs2ReginaToDoubleCheckSyntax:
if RexWhich='REGINA' then
return
if NameOfOs2ReginaRexxInterpreter='-' then
return
call DBG 'OS/2 rexx already passed code, can we double check using OS/2 regina?'
UseExe=NameOfOs2ReginaRexxInterpreter
if UseExe='' then
UseExe=_GetNameOfOs2ReginaExe()
if UseExe='' then
return
CheckingFile=Output.1.File
call DBGIND 1
call DBG 'Checking using "' || UseExe || '"'
call AddressCmd UseExe|| ' ' || CheckingFile || ' ' ||SyntaxOkText
if Rc<>SyntaxOkRc&Rc<>255 then
CryAndDie('Probably syntax error in "' || Output.1.File || '"', 'Got unexpected RC of "' || Rc || '" from ' ||UseExe)
call DBGIND-1
return

Rexx_28:
InfLoopSeconds4Parms=0
InfLoopSeconds4Macros=0
InfiniteIncludeLoopWhen=0
RexxSkipCounter=0
ArePositionalChars='"' || "'="
MarksPhpXml='<' || '?'
signal Define_29

_RXQuote:
parse arg mb!Right,mb!Quote,mb!OpQuote
mb!Break=mb!Quote|| '||,' ||DefRexxSpecialSepTag||mb!Quote
mb!DQuote=mb!Quote||mb!Quote
mb!Left=''
do while length(mb!Right)>100
if mb!Left=='' then
mb!Left=ReplaceString(left(mb!Right,100),mb!Quote,mb!DQuote)
else
mb!Left=mb!Left||mb!Break||ReplaceString(left(mb!Right,100),mb!Quote,mb!DQuote)
mb!Right=substr(mb!Right,100+1)
end
return(mb!Left||ReplaceString(mb!Right,mb!Quote,mb!DQuote))

_RxVar:
parse arg nb!Cmd,nb!Value
parse var nb!Cmd "$$RXVAR:" nb!Var
if nb!Var='' then
CryAndDie('You must supply a variable name on a "$$RxVar" transformation')
return('@s@RxVar:' || nb!Var || ':' || nb!Value || ':@e@RxVar')

ExpandAnyRxVarHacks:
parse arg ob!Str
ob!P=pos('@s@RxVar:',ob!Str)
if ob!P=0 then
return(ob!Str)
ob!L=''
do until ob!P=0
parse var ob!Str ob!B '@s@RxVar:' ob!Var ':' ob!Value ':@e@RxVar' ob!Str
ob!C=''
ob!Add2=''
do until ob!Value==''
parse var ob!Value ob!Bit+100 ob!Value
ob!Bit=ReplaceString(ob!Bit, '"', '""')
ob!C=ob!C||ob!Var|| '=' || ob!Add2 || '"' || ob!Bit || '"' ||DefRexxSpecialSepTag
ob!Add2=ob!Var|| '||'
end
ob!L=ob!L||ob!B||ob!C
ob!P=pos('@s@RxVar:',ob!Str)
end
return(ob!L||ob!Str)

InitCondNlCount:
CondNlCount=0
return

_MacroBitNotFoundText:
if CsReplacement='N' then
return('')
else
return('Macro names & parameters are case sensitive (check case)')

InitializeHashDefinesForThisCompile:
call DBG_DEFINING 'Initializing all #defines, got ' || OptionDefineCount || ' /define definitions to load up.'
drop MACRO?.
call AddHashDefine '_PPWIZARD_', ''
if OptionDefineCount<>0 then
do
do Index=1 to OptionDefineCount
call AddHashDefine OptionDefine.Index.Var,OptionDefine.Index.Cont
end
end
call _GetUserOptionsViaDefineSwitch
return

_GetUserOptionsViaDefineSwitch:
call DBG_MACROVALORDEF 'Getting some lesser options (not worth specific commands)'
call DBGIND 1
if RexSystemOpSys="UNIX" then
PathDelimiterChar=':'
else
PathDelimiterChar=';'
PathDelimiterChar=CfgMacro("PATH_DELIMITER_CHAR",PathDelimiterChar)
if length(PathDelimiterChar)<>1 then
CryAndDie("Invalid path delimiter (expected 1 only character)")
RexxLocalVar=CfgMacro("REXX_MAKE_LOCAL_VAR", '@' || '@')
InfiniteIncludeLoopWhen=CfgMacro("INFINITE_INCLUDE_LOOP_WHEN",20)
InfLoopSecondsDef=CfgMacro("INFINITE_MACRO_LOOP_SECONDS",2)
InfLoopSeconds4Macros=CfgMacro("INFINITE_MACRO_LOOP_SECONDS_MACROS",InfLoopSecondsDef)
call _InfiniteLoopShowIfOff InfLoopSeconds4Macros, "macro"
InfLoopSeconds4Parms=CfgMacro("INFINITE_MACRO_LOOP_SECONDS_PARMS",InfLoopSecondsDef)
call _InfiniteLoopShowIfOff InfLoopSeconds4Parms, "macro parameter"
call DBGIND-1
return

PARMVAL_DEBUG:
if OptionDebugOn='Y' then
do
if OptionParmVal="S" then
pb!D="SOME"
else
pb!D=YorN2OnorOff(OptionParmVal)
call OptionDebugShow 'PARMVAL', 'Currently set to "' || pb!D || '"'
end
return

PARMVAL_SET:
qb!Value=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'PARMVAL', 'Setting default to "' || qb!Value || '"'
DefaultParmVal=qb!Value
return(0)
end
if qb!Value=='' then
qb!Value=DefaultParmVal
if qb!Value="SOME" then
OptionParmVal="S"
else
do
OptionParmVal=IsStringOnOrOffCmd(qb!Value)
if OptionParmVal='' then
CryAndDie('Invalid PARMVAL option of "' || qb!Value || '"')
end
call PARMVAL_DEBUG
return

PARMVAL_GET:
call PARMVAL_DEBUG
if OptionParmVal="S" then
rb!Value="SOME"
else
rb!Value=YorN2OnorOff(OptionParmVal)
return(rb!Value)

REPLACEMENTTAGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'REPLACEMENTTAGS', 'Replace tags now look like "' || StartsMacroReplacement || 'MacroVar' || EndsMacroReplacement || '" and "' || StartsStdSymbolReplacement || 'StandardMacroVar' || EndsMacroReplacement || '", Indirection like "' || MacroIndLeft || 'symbol' || MacroIndRight || '"'
return

REPLACEMENTTAGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'REPLACEMENTTAGS', 'Setting default value of replacement tags to "' || Tags || '"'
Default4_ReplacementTags=Tags
return(0)
end
if Tags=='' then
Tags=Default4_ReplacementTags
rb!L=length(Tags)
if rb!L<>4&rb!L<>6 then
CryAndDie('Tried to set invalid replace tags of "' || Tags || '"')
StartsMacroReplacement=substr(Tags,1,1)||substr(Tags,3,1)
StdSymbolReplacementChar=substr(Tags,4,1)
StartsStdSymbolReplacement=substr(Tags,1,1)||StdSymbolReplacementChar
EndsMacroReplacement=substr(Tags,2,1)
if rb!L=6 then
do
MacroIndLeft=substr(Tags,5,1)
MacroIndRight=substr(Tags,6,1)
end
EndsVar=' ' ||EndsMacroReplacement
StartsStdSymbolReplacement_x=StartsStdSymbolReplacement|| 'x'
CodexNewLine=StartsStdSymbolReplacement|| "NewLine" ||EndsMacroReplacement
if RexIsAscii='N' then
do
CodexHexNewLine=StartsStdSymbolReplacement_x|| "15" ||EndsMacroReplacement
CodexHexSpace=StartsStdSymbolReplacement_x|| "40" ||EndsMacroReplacement
CodexHexHash=StartsStdSymbolReplacement_x|| "7B" ||EndsMacroReplacement
CodexHexDollar=StartsStdSymbolReplacement_x|| "5B" ||EndsMacroReplacement
CodexHexQuestionMark=StartsStdSymbolReplacement_x|| "1A" ||EndsMacroReplacement
CodexHexLessThan=StartsStdSymbolReplacement_x|| "4C" ||EndsMacroReplacement
CodexSemiColon=StartsStdSymbolReplacement_x|| "5E" ||EndsMacroReplacement
end
else
do
CodexHexNewLine=StartsStdSymbolReplacement_x|| "0A" ||EndsMacroReplacement
CodexHexSpace=StartsStdSymbolReplacement_x|| "20" ||EndsMacroReplacement
CodexHexHash=StartsStdSymbolReplacement_x|| "23" ||EndsMacroReplacement
CodexHexDollar=StartsStdSymbolReplacement_x|| "24" ||EndsMacroReplacement
CodexHexQuestionMark=StartsStdSymbolReplacement_x|| "3F" ||EndsMacroReplacement
CodexHexLessThan=StartsStdSymbolReplacement_x|| "3C" ||EndsMacroReplacement
CodexSemiColon=StartsStdSymbolReplacement_x|| "3B" ||EndsMacroReplacement
end
CodexNothing=StartsStdSymbolReplacement_x|| "Nothing" ||EndsMacroReplacement
call REPLACEMENTTAGS_DEBUG
return

REPLACEMENTTAGS_GET:
call REPLACEMENTTAGS_DEBUG
return(substr(StartsMacroReplacement,1,1)||EndsMacroReplacement||substr(StartsMacroReplacement,2,1)||substr(StartsStdSymbolReplacement,2,1)||MacroIndLeft||MacroIndRight)

MACROPARMTAGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'MACROPARMTAGS', 'Macro parameters now look like "' || StartsMacroParm || 'MacroParameter' || EndsMacroParm || '"'
return

MACROPARMTAGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'MACROPARMTAGS', 'Setting default value of macro parameter tags to "' || Tags || '"'
Default4_MacroParameterTags=Tags
return(0)
end
if Tags=='' then
Tags=Default4_MacroParameterTags
if length(Tags)<>3 then
CryAndDie('Tried to set invalid macro parameter tags of "' || Tags || '"')
StartsMacroParm=substr(Tags,1,1)||substr(Tags,3,1)
EndsMacroParm=substr(Tags,2,1)
HidesMacroParm=substr(Tags,1,1)|| '_' ||substr(Tags,3,1)
AutoTagSelf=StartsMacroParm|| 'AT' ||EndsMacroParm
call MACROPARMTAGS_DEBUG
return

MACROPARMTAGS_GET:
call MACROPARMTAGS_DEBUG
return(substr(StartsMacroParm,1,1)||EndsMacroParm||substr(StartsMacroParm,2,1))

ProcessDefine:
Rest=arg(1)
if DefineMacroReplace='Y' then
Rest=PerformReplacementsInCmdsParameters(Rest)
if pos(MarksNewLineInHashDefine,Rest)<>0 then
do
Rest=ReplaceString(arg(1),MarksNewLineInHashDefine2,MarksNewLine)
Rest=ReplaceString(Rest,MarksNewLineInHashDefine,MarksNewLine)
end
parse var Rest HashDefineV HashDefineC
return(AddHashDefine(HashDefineV,strip(HashDefineC),arg(2)))

ProcessEvaluate:
Rest=PerformReplacementsInCmdsParameters(arg(1))
HashDefineAnswerName=GetQuotedText(Rest, "Rest",, "Getting macro name")
if Rest='' then
CryAndDie('Evaluate what command?')
CmdToEvaluate=GetQuotedRest(Rest)
HashDefineRc=0
if HashDefineAnswerName='' then
call ExecRexxCmd CmdToEvaluate
else
do
CmdToEvaluate='EvaluateAnswer = ' ||CmdToEvaluate
call ExecRexxCmd CmdToEvaluate
HashDefineRc=AddHashDefine(HashDefineAnswerName,EvaluateAnswer,arg(2))
end
return(HashDefineRc)

MacroExists:
if symbol('EndsVar') <> 'VAR' then
return('N')
if translate(arg(2))<> 'I' then
do
if verify(arg(1),EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || arg(1) || '" is invalid (Any of "' || EndsVar || '" are invalid)')
end
lb!MacName=arg(1)
lb!MacNameO=lb!MacName
lb!RbPos=pos(MacroIndRight,lb!MacName)
if lb!RbPos<>0 then
do
if OptionDebugOn='Y' then
do
call DBG_DEFINING '[indirection]: ' ||DebugRightArrow||lb!MacName||DebugLeftArrow
call DBGIND 1
end
do while lb!RbPos<>0
lb!LbPos=lastpos(MacroIndLeft,lb!MacName,lb!RbPos)
if lb!LbPos=0 then
CryAndDie('Could not find a matching "' || MacroIndLeft || '" character for "' || MacroIndRight || '"', 'The invalid macro is:', '  ' ||lb!MacName)
lb!L=left(lb!MacName,lb!LbPos-1)
lb!M=substr(lb!MacName,lb!LbPos+1,lb!RbPos-lb!LbPos-1)
lb!R=substr(lb!MacName,lb!RbPos+1)
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Looking for: ' ||lb!M
call DBGIND 1
end
lb!RepType=''
if symbol(lb!M)='VAR' then
do
lb!RepType='REXX'
lb!RepWith=value(lb!M)
end
else
do
if CsReplacement='N' then
lb!SavedAs='MACRO?.M?'||c2x(translate(lb!M))
else
lb!SavedAs='MACRO?.M?'||c2x(lb!M)
if symbol(lb!SavedAs)='VAR' then
do
lb!RepType='PPWIZARD'
lb!RepWith=value(lb!SavedAs)
end
end
if OptionDebugOn='Y' then
do
if lb!RepType='' then
call DBG_DEFINING 'No such REXX or PPWIZARD symbol!'
else
call DBG_DEFINING lb!RepType|| ' symbol contained: ' ||lb!RepWith
call DBGIND-1
end
if lb!RepType='' then
do
if lb!MacName=lb!MacNameO then
lb!Show=lb!MacName
else
lb!Show=lb!MacName|| ' <= "' ||lb!MacNameO
CryAndDie("Could not find a REXX variable or PPWIZARD macro matching:", '  ' || lb!M, 'In the macro reference:', '  ' ||lb!Show)
end
lb!MacName=lb!L||lb!RepWith||lb!R
if OptionDebugOn='Y' then
call DBG_DEFINING 'New macro reference is "' ||DebugRightArrow||lb!MacName||DebugLeftArrow
lb!RbPos=pos(MacroIndRight,lb!MacName)
end
if OptionDebugOn='Y' then
call DBGIND-1
end
if pos(MacroIndLeft,lb!MacName)<>0 then
CryAndDie('Could not find a matching "' || MacroIndRight || '" character for "' || MacroIndLeft || '"', 'The invalid macro is:', '  ' ||lb!MacName)
sb!Dummy=lb!MacName
if CsReplacement='N' then
sb!As='MACRO?.M?'||c2x(translate(lb!MacName))
else
sb!As='MACRO?.M?'||c2x(lb!MacName)
if symbol(sb!As)='VAR' then
return('Y')
else
return('N')

HandleUndefCommand:
return(undef_(PerformReplacementsInCmdsParameters(arg(1))))

MacroUndef:call TRACE "OFF"

Undef_:
tb!Ud=arg(1)
if verify(tb!Ud,EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || tb!Ud || '" is invalid (Any of "' || EndsVar || '" are invalid)')
lb!MacName=tb!Ud
lb!MacNameO=lb!MacName
lb!RbPos=pos(MacroIndRight,lb!MacName)
if lb!RbPos<>0 then
do
if OptionDebugOn='Y' then
do
call DBG_DEFINING '[indirection]: ' ||DebugRightArrow||lb!MacName||DebugLeftArrow
call DBGIND 1
end
do while lb!RbPos<>0
lb!LbPos=lastpos(MacroIndLeft,lb!MacName,lb!RbPos)
if lb!LbPos=0 then
CryAndDie('Could not find a matching "' || MacroIndLeft || '" character for "' || MacroIndRight || '"', 'The invalid macro is:', '  ' ||lb!MacName)
lb!L=left(lb!MacName,lb!LbPos-1)
lb!M=substr(lb!MacName,lb!LbPos+1,lb!RbPos-lb!LbPos-1)
lb!R=substr(lb!MacName,lb!RbPos+1)
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Looking for: ' ||lb!M
call DBGIND 1
end
lb!RepType=''
if symbol(lb!M)='VAR' then
do
lb!RepType='REXX'
lb!RepWith=value(lb!M)
end
else
do
if CsReplacement='N' then
lb!SavedAs='MACRO?.M?'||c2x(translate(lb!M))
else
lb!SavedAs='MACRO?.M?'||c2x(lb!M)
if symbol(lb!SavedAs)='VAR' then
do
lb!RepType='PPWIZARD'
lb!RepWith=value(lb!SavedAs)
end
end
if OptionDebugOn='Y' then
do
if lb!RepType='' then
call DBG_DEFINING 'No such REXX or PPWIZARD symbol!'
else
call DBG_DEFINING lb!RepType|| ' symbol contained: ' ||lb!RepWith
call DBGIND-1
end
if lb!RepType='' then
do
if lb!MacName=lb!MacNameO then
lb!Show=lb!MacName
else
lb!Show=lb!MacName|| ' <= "' ||lb!MacNameO
CryAndDie("Could not find a REXX variable or PPWIZARD macro matching:", '  ' || lb!M, 'In the macro reference:', '  ' ||lb!Show)
end
lb!MacName=lb!L||lb!RepWith||lb!R
if OptionDebugOn='Y' then
call DBG_DEFINING 'New macro reference is "' ||DebugRightArrow||lb!MacName||DebugLeftArrow
lb!RbPos=pos(MacroIndRight,lb!MacName)
end
if OptionDebugOn='Y' then
call DBGIND-1
end
if pos(MacroIndLeft,lb!MacName)<>0 then
CryAndDie('Could not find a matching "' || MacroIndRight || '" character for "' || MacroIndLeft || '"', 'The invalid macro is:', '  ' ||lb!MacName)
tb!Dummy=lb!MacName
if CsReplacement='N' then
SavedAs='MACRO?.M?'||c2x(translate(lb!MacName))
else
SavedAs='MACRO?.M?'||c2x(lb!MacName)
if symbol(SavedAs)='VAR' then
drop(SavedAs)
return(0)

MacroSet:call TRACE "OFF"

AddHashDefine:
parse arg HashDefineU,HashDefineC,DefineMode
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Defining "' || HashDefineU || '" <- ' ||DebugRightArrow||HashDefineC||DebugLeftArrow
call DBGIND 1
end
if verify(HashDefineU,EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || HashDefineU || '" is invalid (Any of "' || EndsVar || '" are invalid)')
lb!MacName=HashDefineU
lb!MacNameO=lb!MacName
lb!RbPos=pos(MacroIndRight,lb!MacName)
if lb!RbPos<>0 then
do
if OptionDebugOn='Y' then
do
call DBG_DEFINING '[indirection]: ' ||DebugRightArrow||lb!MacName||DebugLeftArrow
call DBGIND 1
end
do while lb!RbPos<>0
lb!LbPos=lastpos(MacroIndLeft,lb!MacName,lb!RbPos)
if lb!LbPos=0 then
CryAndDie('Could not find a matching "' || MacroIndLeft || '" character for "' || MacroIndRight || '"', 'The invalid macro is:', '  ' ||lb!MacName)
lb!L=left(lb!MacName,lb!LbPos-1)
lb!M=substr(lb!MacName,lb!LbPos+1,lb!RbPos-lb!LbPos-1)
lb!R=substr(lb!MacName,lb!RbPos+1)
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Looking for: ' ||lb!M
call DBGIND 1
end
lb!RepType=''
if symbol(lb!M)='VAR' then
do
lb!RepType='REXX'
lb!RepWith=value(lb!M)
end
else
do
if CsReplacement='N' then
lb!SavedAs='MACRO?.M?'||c2x(translate(lb!M))
else
lb!SavedAs='MACRO?.M?'||c2x(lb!M)
if symbol(lb!SavedAs)='VAR' then
do
lb!RepType='PPWIZARD'
lb!RepWith=value(lb!SavedAs)
end
end
if OptionDebugOn='Y' then
do
if lb!RepType='' then
call DBG_DEFINING 'No such REXX or PPWIZARD symbol!'
else
call DBG_DEFINING lb!RepType|| ' symbol contained: ' ||lb!RepWith
call DBGIND-1
end
if lb!RepType='' then
do
if lb!MacName=lb!MacNameO then
lb!Show=lb!MacName
else
lb!Show=lb!MacName|| ' <= "' ||lb!MacNameO
CryAndDie("Could not find a REXX variable or PPWIZARD macro matching:", '  ' || lb!M, 'In the macro reference:', '  ' ||lb!Show)
end
lb!MacName=lb!L||lb!RepWith||lb!R
if OptionDebugOn='Y' then
call DBG_DEFINING 'New macro reference is "' ||DebugRightArrow||lb!MacName||DebugLeftArrow
lb!RbPos=pos(MacroIndRight,lb!MacName)
end
if OptionDebugOn='Y' then
call DBGIND-1
end
if pos(MacroIndLeft,lb!MacName)<>0 then
CryAndDie('Could not find a matching "' || MacroIndRight || '" character for "' || MacroIndLeft || '"', 'The invalid macro is:', '  ' ||lb!MacName)
tb!Dummy=lb!MacName
if CsReplacement='N' then
SavedAs='MACRO?.M?'||c2x(translate(lb!MacName))
else
SavedAs='MACRO?.M?'||c2x(lb!MacName)
if symbol(SavedAs)='VAR' then
do
select
when DefineMode='Y' then
do
if OptionDebugOn='Y' then
call DBG_DEFINING 'User said OK to redefine so no warning'
end
when DefineMode='' then
do
call OutputWarningToScreen 'R000', 'Redefine of "' || HashDefineU || '".'
end
when DefineMode='?' then
do
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Macro already defined, conditional definition aborted!'
call DBGIND-1
end
return(0)
end
otherwise
CryAndDie('Unknown define mode of "' || DefineMode || '"')
end
end
call _valueS SavedAs,HashDefineC
if OptionDebugOn='Y' then
call DBGIND-1
return(0)

PerformReplacementsInCmdsParameters:
ub!Prms=arg(1)
if ReplacementsAllowed<> 'Y' then
return(ub!Prms)
ub!Prms=ReplaceHashAndStandardDefines(arg(1), "PRM")
if ExpandXCmd='Y' then
do
if pos(StartsStdSymbolReplacement_x,ub!Prms)<>0 then
ub!Prms=ReplaceTheXCodesWeKnowExist(ub!Prms)
end
if pos(MarksNewLine,ub!Prms)<>0 then
do
ub!1='Parameters for a PPWIZARD command must never expand to multiple'
ub!2='lines (contain PPWIZARD #commands)!'
ub!4='EXPANDED PARAMETERS'
ub!5='~~~~~~~~~~~~~~~~~~~'
ub!6=ub!Prms
CryAndDie(ub!1,ub!2,,ub!4,ub!5,ub!6)
end
return(ub!Prms)

ReplaceMacros:call TRACE "OFF"
signal _ReplaceMacros

ReplaceHashAndStandardDefines:
if ReplacementsAllowed='N' then
return(arg(1))

_ReplaceMacros:
if InfLoopSeconds4Macros<>0 then
do
call time 'R'
ub!MrCount=0
ub!MrDieCount=0
end
parse arg HashDefineString,HashDefPrefix,HashDefRecord
ReplLoop=0
do while pos(StartsMacroReplacement,HashDefineString)<>0
BeforeCount=ReplaceCount
HashDefineString=_ReplaceAllHashDefinedVariables(HashDefineString)
if HashDefRecord='Y' then
LastLineAfterMacroRep=HashDefineString
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
do
if HashDefPrefix='' then
call DebugOutputAfterReplacement HashDefineString, 'VCMD'
else
call DebugOutputAfterReplacement HashDefineString, 'V' ||HashDefPrefix
end
end
if pos(MarksNewLine,HashDefineString)<>0 then
leave
if InfLoopSeconds4Macros<>0 then
do
if ub!MrDieCount<>0 then
do
ub!MrDieCount=ub!MrDieCount-1
if ub!MrDieCount<>0 then
call DBG '--- ' || ub!MrDieCount || ' more loops until we die...'
else
do
_InfiniteLoopDie( 'It appears that we might be in an infinite loop replacing macros as we have\n'             || 'been trying to replace macros for at least ' || InfLoopSeconds4Parms || ' second(s).\n\n'  || 'This can occur if a macro''s contents refers to itself (either directly\n'                 || 'or indirectly).\n' )
end
end
else
do
ub!MrCount=ub!MrCount+1
if(ub!MrCount//1000)=0 then
do
if time('E')>=InfLoopSeconds4Macros then
do
ub!MrDieCount=20
call _InfiniteLoopDetectedTurnDebugOn "macro"
end
end
end
end
end
if pos(StartsStdSymbolReplacement,HashDefineString)<>0 then
do
BeforeCount=ReplaceCount
HashDefineString=ReplaceStandardDefinitions(HashDefineString)
if HashDefRecord='Y' then
LastLineAfterMacroRep=HashDefineString
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
do
if HashDefPrefix='' then
call DebugOutputAfterReplacement HashDefineString, 'SCMD'
else
call DebugOutputAfterReplacement HashDefineString, 'S' ||HashDefPrefix
end
end
end
return(HashDefineString)

_UnknownStandardSymbol:
call CryAndDie 'The standard symbol "' || StartsStdSymbolReplacement || SymbolName || EndsMacroReplacement || '" is unknown!'

ReplaceStandardDefinitions:
RightBit=arg(1)
if pos(MarksNewLine,RightBit)<>0 then
return(RightBit)
LeftBit=''
StartPos=pos(StartsStdSymbolReplacement,RightBit)
do while StartPos<>0
if StartsStdSymbolReplacement==MarksPhpXml then
do
Left4=substr(RightBit,StartPos+2,3)
if Left4='xml' then
do
LeftBit=LeftBit|| '<' ||CodexHexQuestionMark
RightBit=substr(RightBit,3)
StartPos=pos(StartsStdSymbolReplacement,RightBit)
iterate
end
if Left4='php' then
do
StartPos=pos(StartsStdSymbolReplacement,RightBit,StartPos+2)
iterate
end
if left(Left4,1)=' ' then
do
StartPos=pos(StartsStdSymbolReplacement,RightBit,StartPos+2)
iterate
end
end
EndPos=pos(EndsMacroReplacement,RightBit,StartPos+1)
if EndPos=0 then
CryAndDie('Could not find the "' || EndsMacroReplacement || '" end of variable started at: ' ||substr(RightBit,StartPos))
LeftBit=LeftBit||left(RightBit,StartPos-1)
SymbolNameC=substr(RightBit,StartPos+2,(EndPos-StartPos)-2)
RightBit=substr(RightBit,EndPos+1)
if left(SymbolNameC,1)='x' then
do
ReplaceCount=ReplaceCount-1
SymbolValue=StartsStdSymbolReplacement||SymbolNameC||EndsMacroReplacement
end
else
do
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDSTDVAR 'Found : ' ||StartsStdSymbolReplacement||SymbolNameC||EndsMacroReplacement
SymbolName=SymbolNameC
Left1=left(SymbolName,1)
if Left1='=' then
DdCodes=''
else
do
SpcPos=pos(' ',SymbolName)
if SpcPos=0 then
DdCodes=''
else
do
DdCodes=translate(substr(SymbolName,SpcPos+1))
SymbolName=left(SymbolName,SpcPos-1)
end
end
vb!Pos=pos(':',SymbolName)
if vb!Pos=0 then
do
SymbolParms=''
SymbolParmsFnd='N'
end
else
do
SymbolParmsFnd='Y'
SymbolParms=substr(SymbolName,vb!Pos+1,length(SymbolName)-vb!Pos)
SymbolName=left(SymbolName,vb!Pos-1)
end
SymbolName=translate(SymbolName)
Left1=left(SymbolName,1)
select
when Left1='?' then
do
SymbolName=substr(SymbolName,2)
if left(SymbolName,1)<> '*' then
do
call DieIfNotRexxSymbol SymbolName
if symbol(SymbolName)<> 'VAR' then
do
call DumpVarsIfCompoundVariable SymbolName
call CryAndDie 'The rexx variable "' || SymbolName || '" is unknown!'
end
SymbolValue=_valueG(SymbolName)
end
else
do
SymbolName=substr(SymbolName,2)
if right(SymbolName,1)<> '?' then
vb!Die='Y'
else
do
vb!Die='N'
SymbolName=left(SymbolName,length(SymbolName)-1)
end
SymbolValue=GetEnv(SymbolName,vb!Die)
end
end
when Left1='I' then
do
select
when SymbolName="INPUTFILE" then
SymbolValue=FormatSsFile(InputFileFull)
when SymbolName="INPUTCOMPONENT" then
SymbolValue=FormatSsFile(IncludeFileName)
when SymbolName="INPUTCOMPONENTLINE" then
SymbolValue=FormatSsNumber(IncludeLineNumber)
when SymbolName="INPUTFILETIME" then
do
vb!Ts=GetFileTimeStamp(InputFileFull, "D")
SymbolValue=FormatSsTime(vb!Ts, "INPUTFILETIME")
end
when SymbolName="INPUTCOMPONENTTIME" then
do
vb!Ts=GetFileTimeStamp(IncludeFileName, "D")
SymbolValue=FormatSsTime(vb!Ts, "INPUTCOMPONENTTIME")
end
when SymbolName="INCLUDELEVEL" then
SymbolValue=IncludeLevel
otherwise
call _UnknownStandardSymbol
end
end
when Left1='S' then
do
select
when SymbolName="SPACE" then
SymbolValue=CodexHexSpace
when SymbolName="SEMICOLON" then
SymbolValue=CodexSemiColon
when SymbolName="SYNTAXCHECK" then
do
SymbolValue=OutSyntaxCode
if SymbolValue='' then
CryAndDie("We do not know how to insert syntax checking code (or already inserted)!")
OutSyntaxCode=''
end
when SymbolName="SYNTAXCHECKOFF" then
do
OutSyntaxCode=''
OutSyntaxRc=''
OutSyntaxCmd=''
SymbolValue=''
end
otherwise
call _UnknownStandardSymbol
end
end
when Left1='O' then
do
select
when SymbolName="OUTPUTLINE" then
SymbolValue=FormatSsNumber(CurrentOutLine+1)
when SymbolName="OUTPUTLEVEL" then
SymbolValue=OutputLevel
when SymbolName="OPSYS" then
SymbolValue=PpWizardOpSys
when SymbolName="OPSYSSPECIFIC" then
SymbolValue=PpWizardOpSysREAL
when SymbolName="OUTPUTFILE" then
do
call _FileClose CurrentOutFile
SymbolValue=FileQueryExists(CurrentOutFile)
if SymbolValue='' then
CryAndDie('Could not obtain file name information for the "' || StartsStdSymbolReplacement || 'OutputFile>" variable!')
SymbolValue=FormatSsFile(SymbolValue)
end
otherwise
call _UnknownStandardSymbol
end
end
when Left1='P' then
do
select
when SymbolName='PROCESSINGMODE' then
SymbolValue=ProcessingMode
when SymbolName='PROTECTFROMPPWSTART' then
SymbolValue=MarksNewLine||HashPrefix||ProtectFromPpwS||MarksNewLine
when SymbolName='PROTECTFROMPPWEND' then
SymbolValue=MarksNewLine||ProtectFromPpwE||MarksNewLine
when SymbolName='PPWIZARDAUTHORHOMEPAGE' then
SymbolValue=PgmAuthorHomePage
when SymbolName='PPWIZARDAUTHOR' then
SymbolValue=PgmAuthor
when SymbolName='PPWIZARDAUTHOREMAIL' then
do
SymbolValue=PgmAuthorEmail
if SymbolParmsFnd='N' then
vb!SpamT=CfgMacro("PPWIZARD_PPWIZARDAUTHOREMAIL_SPAM_PROTECTION", '@TEXT')
else
do
vb!SpamT=SymbolParms
SymbolParms=''
end
if vb!SpamT<> '' then
SymbolValue=NoSpam(SymbolValue,vb!SpamT)
end
when SymbolName='PPWIZARDPGM' then
SymbolValue=FormatSsFile(PpWizardPgmName)
when SymbolName='PPWIZARDHOMEPAGE' then
SymbolValue=PgmHomePage
when SymbolName='PPWIZARDGENERATORMETATAGS' then
SymbolValue=PgmDefaultHtmlMetaTags
when SymbolName='PPWIZARDAUTHORBASEWEBDIR' then
SymbolValue=MyBaseHomeDir
otherwise
call _UnknownStandardSymbol
end
end
when Left1='D' then
do
select
when SymbolName='DEBUGON' then
SymbolValue=OptionDebugOn
when SymbolName='DOLLAR' then
SymbolValue=CodexHexDollar
when SymbolName='DIRSLASH' then
SymbolValue=RexDirChar
when SymbolName='DATA' then
do
SymbolValue=DataInfo(SymbolParms)
SymbolParms=''
end
otherwise
call _UnknownStandardSymbol
end
end
when SymbolName='NEWLINEINMACRO' then
SymbolValue=MarksNewLineInHashDefine
when SymbolName='NEWLINE' then
SymbolValue=CodexHexNewLine||LeftIndent
when SymbolName='NEWLINE?' then
do
CondNlCount=CondNlCount+1
SymbolValue="{?WaNtNl?}"
end
when SymbolName='/' then
SymbolValue=OptionXSlash
when SymbolName='_' then
SymbolValue=CodexNothing
when SymbolName='FLUSH' then
do
call FlushQueuedOutput
SymbolValue=""
end
when SymbolName='COMPILETIME' then
SymbolValue=FormatSsTime(PpwCompTs, "COMPILETIME")
when SymbolName='CMDLINETOTAL' then
SymbolValue=CmdLineTotal
when SymbolName='VERSION' then
SymbolValue=PgmVersion
when SymbolName='HASH' then
SymbolValue=CodexHexHash
when SymbolName='HASHPREFIX' then
SymbolValue=HashPrefix
when SymbolName='RESTARTLINE' then
SymbolValue=MarksNewLine
when SymbolName='TOTALOUTPUTLINES' then
SymbolValue=FormatSsNumber(GeneratedLines+1)
when SymbolName='CTEXT.EXE' then
SymbolValue=FormatSsFile(GetCtextFileName())
when SymbolName='NEWESTFILEDATETIME' then
do
SymbolValue=TsNewestSourcefile
if SymbolParms<> '' then
SymbolValue=FormatSsTime(SymbolValue)
end
when SymbolName='LESSTHAN' then
SymbolValue=CodexHexLessThan
when SymbolName='QUESTIONMARK' then
SymbolValue=CodexHexQuestionMark
when SymbolName='BASEDIR' then
SymbolValue=FormatSsFile(BaseDir4CurrentInputFile)
when SymbolName='UNIQUE' then
do
PPwizardUnique=PPwizardUnique+1
SymbolValue=FormatSsNumber(PPwizardUnique)
end
when SymbolName='TEMPLATEDATAFILE' then
SymbolValue=FormatSsFile(TemplateDataFile)
when SymbolName='TMPDIR' then
do
vb!D=RexGetNameOfTmpDir()
if right(vb!D,1)=RexDirChar then
vb!D=left(vb!D,length(vb!D)-1)
SymbolValue=vb!D
end
when SymbolName='CGISTART' then
SymbolValue='Content-type: text/html' ||CodexHexNewLine||CodexHexNewLine
when SymbolName='REXXSKIP' then
do
RexxSkipCounter=RexxSkipCounter+1
RexxLbl=_filespec("WITHOUTEXTN", _filespec("NAME", IncludeFileName)) || '_' ||RexxSkipCounter
SymbolValue=MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" = "' || RexxLbl || '"' ||MarksNewLine
SymbolValue=SymbolValue|| 'signal ' || RexxLbl || ';' ||MarksNewLine
SymbolValue=SymbolValue||MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" PUSH' ||MarksNewLine
end
when SymbolName='REXXSKIPTO' then
do
SymbolValue=MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" POP' ||MarksNewLine
SymbolValue=SymbolValue||RexxSkipLbl|| ':' ||MarksNewLine
end
when SymbolName='..' then
do
call DBGIND 1
vb!IF=InputFileFull
vb!Bd=BaseDir4CurrentInputFile
call DBG 'Base dir "' || vb!Bd || '"'
call ValidateBaseDirUse vb!BD,vb!IF
vb!SrcDir=_filespec('Location',vb!IF)
vb!RelDir=substr(vb!SrcDir,length(vb!Bd)+1)
call DBG 'Rel dir  "' || vb!RelDir || '"'
vb!DD=''
do while vb!RelDir<> ""
vb!DD=vb!DD|| '..\'
parse var vb!RelDir . (RexDirChar) vb!RelDir
end
SymbolValue=vb!DD
call DBGIND-1
end
when Left1='=' then
do
if OptionDebugOn='Y' then
call DBGIND 1
call ExecRexxCmd 'SymbolValue = ' ||substr(SymbolNameC,2)
if OptionDebugOn='Y' then
call DBGIND-1
SymbolParms=''
end
otherwise
call _UnknownStandardSymbol
end
if DdCodes<> '' then
do
do until DdCodes=''
parse var DdCodes DdCode DdCodes
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDSTDVAR '$$Bef : ' ||SymbolValue
call DebugOutputVariableInfo_FOUNDSTDVAR '$$Cmd : ' ||DdCode
end
select

when DdCode='$$DSQ' then
SymbolValue=QuoteIt(SymbolValue,TryQuoteListDs, 'Y')

when DdCode='$$SDQ' then
SymbolValue=QuoteIt(SymbolValue,TryQuoteListSd, 'Y')

when DdCode='$$AQ' then
SymbolValue=QuoteIt(SymbolValue, 'ANY', 'Y')

when DdCode='$$UPPER' then
SymbolValue=ToUpperCase(SymbolValue)

when DdCode='$$LOWER' then
SymbolValue=ToLowerCase(SymbolValue)

when DdCode='$$ADDCOMMA' then
SymbolValue=AddCommasToDecimalNumber(SymbolValue)

when DdCode='$$HTMLQ' then
SymbolValue=ReplaceString(SymbolValue, '"', '&quot;')

when DdCode='$$BSX2' then
SymbolValue=ReplaceString(SymbolValue, "\" , "\\")

when DdCode='$$SQX2' then
SymbolValue=ReplaceString(SymbolValue, "'" , "''")

when DdCode='$$DQX2' then
SymbolValue=ReplaceString(SymbolValue, '"' , '""')

when left(DdCode,8)="$$RXVAR:" then
SymbolValue=_RxVar(DdCode,SymbolValue)

when DdCode="$$RX'" then
SymbolValue=_RXQuote(SymbolValue, "'")

when DdCode='$$RX"' then
SymbolValue=_RXQuote(SymbolValue, '"')

when DdCode='$$C2X' then
SymbolValue=c2x(SymbolValue)

when DdCode='$$NOSPAM' then
SymbolValue=NoSpam(SymbolValue, "@TEXT")

when left(DdCode,6)="$$DEL:" then
do
lb!Del=substr(DdCode,7)
if lb!Del=='' then
CryAndDie("$$Del must have parameters!")
if lb!Del=='?\' then
lb!Del=RexDirChar
if lb!Del<>right(SymbolValue,length(lb!Del))then
SymbolValue=SymbolValue||lb!Del
end

when DdCode='$$SPCPLUS' then
do
if SymbolValue\=='' then
SymbolValue=' ' ||SymbolValue
end

when DdCode='$$ISBLANK' then
do
if SymbolValue='' then
SymbolValue='Y'
else
SymbolValue='N'
end

when DdCode='$$RXEXEC' then
do
RxExec=''
call ExecRexxCmd SymbolValue, 'N'
SymbolValue=RxExec
end

when abbrev(DdCode, '$$FILEPART:')then
do
lb!Fps=substr(DdCode,12)
if lb!Fps='' then
CryAndDie("$$FilePart must have parameters!")
do while lb!Fps<> ''
parse var lb!Fps lb!Fp ',' lb!Fps
SymbolValue=FilePart(lb!Fp,SymbolValue)
end
end

otherwise
do
parse var DdCode DdCode ':' TheParameters
UserRexx=CfgMacro("REXX_" || DdCode, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || DdCode || '" is unknown!')
TheMacro=""
TheName=SymbolName
TheValue=SymbolValue
call ExecRexxCmd UserRexx, 'N'
if OptionDebugOn='Y' then
do
if SymbolValue=TheValue then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DBGIND-1
end
end
if TheParameters<> '' then
CryAndDie('The $$ replacement command of "' || DdCode || '" is did not process its parameters:', '   ' ||TheParameters)
SymbolValue=TheValue
end
end
end
end
if SymbolParms<> '' then
CryAndDie('Unexpected parameters on standard macro:',SymbolNameC)
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDSTDVAR 'Value : ' ||DebugRightArrow||SymbolValue||DebugLeftArrow
end
LeftBit=LeftBit||SymbolValue
ReplaceCount=ReplaceCount+1
if pos(MarksNewLine,SymbolValue)<>0 then
leave
StartPos=pos(StartsStdSymbolReplacement,RightBit)
end
return(LeftBit||RightBit)

FormatSsFile:
wb!F=arg(1)
do while SymbolParms<> ''
parse var SymbolParms wb!Cmd ',' SymbolParms
wb!F=_filespec(wb!Cmd,wb!F)
end
return(wb!F)

FormatSsNumber:
if SymbolParms='' then
return(arg(1))
else
do
xb!R=FormatNumber(arg(1),SymbolParms)
SymbolParms=''
return(xb!R)
end

FormatSsTime:
parse arg yb!Ts,yb!CfgSuffix
yb!Fmt=SymbolParms
if yb!Fmt<> '' then
SymbolParms=''
else
do
yb!Fmt=CfgMacro("PPWIZARD_FORMAT_DATETIME", '%c')
yb!Fmt=CfgMacro("PPWIZARD_FORMAT_" ||yb!CfgSuffix,yb!Fmt)
end
yb!Time=FormatTime(yb!Fmt,yb!Ts, "PPWIZARD")
return(yb!Time)

GetDefineContents:
if verify(arg(1),EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || arg(1) || '" is invalid (Any of "' || EndsVar || '" are invalid)')
lb!MacName=arg(1)
lb!MacNameO=lb!MacName
lb!RbPos=pos(MacroIndRight,lb!MacName)
if lb!RbPos<>0 then
do
if OptionDebugOn='Y' then
do
call DBG_DEFINING '[indirection]: ' ||DebugRightArrow||lb!MacName||DebugLeftArrow
call DBGIND 1
end
do while lb!RbPos<>0
lb!LbPos=lastpos(MacroIndLeft,lb!MacName,lb!RbPos)
if lb!LbPos=0 then
CryAndDie('Could not find a matching "' || MacroIndLeft || '" character for "' || MacroIndRight || '"', 'The invalid macro is:', '  ' ||lb!MacName)
lb!L=left(lb!MacName,lb!LbPos-1)
lb!M=substr(lb!MacName,lb!LbPos+1,lb!RbPos-lb!LbPos-1)
lb!R=substr(lb!MacName,lb!RbPos+1)
if OptionDebugOn='Y' then
do
call DBG_DEFINING 'Looking for: ' ||lb!M
call DBGIND 1
end
lb!RepType=''
if symbol(lb!M)='VAR' then
do
lb!RepType='REXX'
lb!RepWith=value(lb!M)
end
else
do
if CsReplacement='N' then
lb!SavedAs='MACRO?.M?'||c2x(translate(lb!M))
else
lb!SavedAs='MACRO?.M?'||c2x(lb!M)
if symbol(lb!SavedAs)='VAR' then
do
lb!RepType='PPWIZARD'
lb!RepWith=value(lb!SavedAs)
end
end
if OptionDebugOn='Y' then
do
if lb!RepType='' then
call DBG_DEFINING 'No such REXX or PPWIZARD symbol!'
else
call DBG_DEFINING lb!RepType|| ' symbol contained: ' ||lb!RepWith
call DBGIND-1
end
if lb!RepType='' then
do
if lb!MacName=lb!MacNameO then
lb!Show=lb!MacName
else
lb!Show=lb!MacName|| ' <= "' ||lb!MacNameO
CryAndDie("Could not find a REXX variable or PPWIZARD macro matching:", '  ' || lb!M, 'In the macro reference:', '  ' ||lb!Show)
end
lb!MacName=lb!L||lb!RepWith||lb!R
if OptionDebugOn='Y' then
call DBG_DEFINING 'New macro reference is "' ||DebugRightArrow||lb!MacName||DebugLeftArrow
lb!RbPos=pos(MacroIndRight,lb!MacName)
end
if OptionDebugOn='Y' then
call DBGIND-1
end
if pos(MacroIndLeft,lb!MacName)<>0 then
CryAndDie('Could not find a matching "' || MacroIndRight || '" character for "' || MacroIndLeft || '"', 'The invalid macro is:', '  ' ||lb!MacName)
zb!MN=lb!MacName
if CsReplacement='N' then
zb!SA='MACRO?.M?'||c2x(translate(lb!MacName))
else
zb!SA='MACRO?.M?'||c2x(lb!MacName)
if symbol(zb!SA)='VAR' then
return(_valueG(zb!SA))
if arg(1)=zb!MN then
zb!New=''
else
zb!New=' ("' || zb!MN || '")'
zb!ErrMsg='Macro named "' || arg(1) || '"' || zb!New || ' does not exist!'
zb!CaseErr=_MacroBitNotFoundText()
if zb!CaseErr<> '' then
zb!ErrMsg=zb!ErrMsg|| '0A'x||zb!CaseErr
call Dbg 'Macro "' || arg(1) || '" was not found'
zb!Rexx=CfgMacro('HOOK_UNKNOWN_MACRO', '')
if zb!Rexx='' then
CryAndDie(zb!ErrMsg)
else
do
HookDefineName=arg(1)
HookDefineContinue='N'
HookDefineValue=zb!ErrMsg
call ExecRexxCmd zb!Rexx
if HookDefineContinue='Y' then
return(HookDefineValue)
else
CryAndDie(HookDefineValue)
end

_SpecialPrm:
call DebugOutputVariableInfo_FOUNDVARPARMS "This is a special variable, it's value is: " ||arg(1)
return

_DieInvPrm:
CryAndDie('The "' || StartsMacroParm || ThisParmName || EndsMacroParm || '" parameter was not supplied (and there is no default value)',_MacroBitNotFoundText())
return

ReplaceDefinitionsParameters:
if InfLoopSeconds4Parms<>0 then
do
call time 'R'
ac!PrCount=0
ac!PrDieCount=0
end
do ParmIndex=1 to ParmCount
ParmUsed.ParmIndex='N'
end
ac!DieIfNotUsed='N'
ac!ValPointless='N'
DefaultCnt=0
ParmLeftBit=''
ParmRightBit=VariableCont
ParmPos=pos(StartsMacroParm,ParmRightBit)
do while ParmPos<>0
if InfLoopSeconds4Parms<>0 then
do
if ac!PrDieCount<>0 then
do
ac!PrDieCount=ac!PrDieCount-1
if ac!PrDieCount<>0 then
call DBG '--- ' || ac!PrDieCount || ' more loops until we die...'
else
do
_InfiniteLoopDie( 'It appears that we might be in an infinite loop replacing parameters as we\n' || 'have been trying to replace parameters for a single macro reference for at\n'   || 'least ' || InfLoopSeconds4Parms || ' second(s).\n\n'                            || 'This can occur if the replacement text for one parameter causes more\n'         || 'parameter replacement.\n' )
end
end
else
do
ac!PrCount=ac!PrCount+1
if(ac!PrCount//1000)=0 then
do
if time('E')>=InfLoopSeconds4Parms then
do
ac!PrDieCount=20
call _InfiniteLoopDetectedTurnDebugOn "macro parameter"
end
end
end
end
ParmLeftBit=ParmLeftBit||left(ParmRightBit,ParmPos-1)
ParmRightBit=substr(ParmRightBit,ParmPos+2)
EqualPos=pos('=',ParmRightBit)
MaybeEndPos=pos(EndsMacroParm,ParmRightBit)
if MaybeEndPos=0 then
CryAndDie('Incorrect use of macro parameter, no matching "' || EndsMacroParm || '" for "' || StartsMacroParm || '"')
if EqualPos<>0&EqualPos<MaybeEndPos then
do
ThisParmNameOC=strip(left(ParmRightBit,EqualPos-1))
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameOC)
else
ThisParmName=ThisParmNameOC
ParmRightBit=substr(ParmRightBit,EqualPos+1)
ParmDefault=GetQuotedText(ParmRightBit, "ParmRightBit", EndsMacroParm, "Getting default for macro parm " ||ThisParmName)
HaveDefault='Y'
CurlyPos=pos(EndsMacroParm,ParmRightBit)
if CurlyPos=0 then
CryAndDie("Expected to find '" || EndsMacroParm || "' " || 'after the parameter default of "' || ParmDefault || '"!')
ParmCmds=left(ParmRightBit,CurlyPos-1)
ParmRightBit=substr(ParmRightBit,CurlyPos+1)
FoundIndex=0
do DefaultIndex=1 to DefaultCnt
if ThisParmName=PrmDefaultName.DefaultIndex then
do
FoundIndex=DefaultIndex
leave
end
end
if FoundIndex=0 then
do
DefaultCnt=DefaultCnt+1
FoundIndex=DefaultCnt
end
PrmDefaultName.FoundIndex=ThisParmName
PrmDefaultValue.FoundIndex=ParmDefault
end
else
do
HaveDefault='N'
ThisParmNameOC=strip(left(ParmRightBit,MaybeEndPos-1))
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameOC)
else
ThisParmName=ThisParmNameOC
SpcPos=pos(' ',ThisParmName)
if SpcPos=0 then
ParmCmds=''
else
do
ParmCmds=substr(ThisParmName,SpcPos+1)
ThisParmName=left(ThisParmName,SpcPos-1)
ThisParmNameOC=left(ThisParmNameOC,SpcPos-1)
end
ParmRightBit=substr(ParmRightBit,MaybeEndPos+1)
end
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'Parm : ' ||ThisParmName
FndVarIndex=0
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
if ThisParmName=ParmName.ParmIndex then
do
ParmUsed.ParmIndex='Y'
FndVarIndex=ParmIndex
end
end
end
if FndVarIndex<>0 then
do
ac!IsPassed='Y'
ReplaceParmWith=ParmValue.FndVarIndex
end
else
do
ac!IsPassed='N'
if HaveDefault='Y' then
ReplaceParmWith=ParmDefault
else
do
if OptionDebugOn='Y' then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'Parameter not supplied. No default given. Default value stored?'
end
do DefaultIndex=1 to DefaultCnt
if ThisParmName=PrmDefaultName.DefaultIndex then
do
ReplaceParmWith=PrmDefaultValue.DefaultIndex
HaveDefault='Y'
leave
end
end
if OptionDebugOn='Y' then
do
if HaveDefault='N' then
Ans='Oops - not user defined!'
else
Ans='Lucky!'
call DebugOutputVariableInfo_FOUNDVARPARMS Ans
call DBGIND-1
end
if HaveDefault='N' then
do
ac!ReginaBugWorkAround='N'
select
when ThisParmName='?' then
do
ac!ValPointless='Y'
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'is all unused parms'
ReplaceParmWith=''
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
if ParmUsed.ParmIndex='N' then
do
LSPC=' '
if ParmValueT.ParmIndex='NV' then
ReplaceParmWith=ReplaceParmWith||LSPC||ParmNameC.ParmIndex
else
do
if ParmCmds='' then
do
QChar=QuoteIt(ParmValue.ParmIndex,TryQuoteListAny)
ReplaceParmWith=ReplaceParmWith||LSPC||ParmNameC.ParmIndex|| '=' ||QChar||ParmValue.ParmIndex||QChar
end
else
do
ReplaceParmWith=ReplaceParmWith||LSPC||StartsMacroParm||ParmNameC.ParmIndex|| ' ' ||ParmCmds||EndsMacroParm
end
end
end
end
end
ParmCmds=''
end
when ThisParmName='??' then
do
ac!ValPointless='Y'
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'all parms as rexx array'
RepWith=''
ArrayCnt=0
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
ArrayCnt=ArrayCnt+1
ac!Perf='MP.' || ArrayCnt || ".MPNAME  = " ||QuoteAsRexxLit(ParmNameC.ParmIndex)||DefRexxSpecialSepTag
ac!Perf=ac!Perf|| '@s@RxVar:' || 'MP.' || ArrayCnt || '.MPVALUE' || ':' || ParmValue.ParmIndex || ':@e@RxVar' ||DefRexxSpecialSepTag
ac!Perf=ac!Perf|| 'MP.' || ArrayCnt || ".MPUSED  = '" || ParmUsed.ParmIndex                   || "'" ||DefRexxSpecialSepTag
ac!Perf=ac!Perf|| 'MP.' || ArrayCnt || ".MPTYPE  = '" || ParmValueT.ParmIndex                 || "'" ||DefRexxSpecialSepTag
RepWith=RepWith||ac!Perf
end
end
ReplaceParmWith=RepWith|| 'MP.0 = ' ||ArrayCnt||DefRexxSpecialSepTag
ParmCmds=''
end
when translate(ThisParmName)='?MACNAME' then
do
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'name of macro being expanded'
ReplaceParmWith=VariableName
end
when translate(ThisParmName)='?PARMS' then
do
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'Is Query: How many parameters passed?'
ReplaceParmWith=ParmCount
end
when translate(ThisParmName)='?RESETUSED' then
do
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'All parms now marked unused'
do ParmIndex=1 to ParmCount
ParmUsed.ParmIndex='N'
end
ac!ValPointless='Y'
ReplaceParmWith=''
ParmCmds=''
end
when ThisParmName='!KEYWORDS' then
do
if OptionDebugOn='Y' then
call _SpecialPrm 'Empty - It is a parameter validation command (die if keywords used)'
if HaveKeywordParms<> '' then
CryAndDie('The "' || VariableName || '" macro does not support keywords!','We found the following keywords: ',HaveKeywordParms,,"Did you accidently use spaces around these parameter's equal signs?")
ac!ReginaBugWorkAround='Y'
ReplaceParmWith=''
ParmCmds=''
end
when ThisParmName='!' then
do
ac!DieIfNotUsed="Y"
ac!ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call _SpecialPrm 'Empty - It is a parameter validation command'
ReplaceParmWith=''
ParmCmds=''
end
when left(ThisParmName,2)='!:' then
do
ac!ReginaBugWorkAround='Y'
ReplaceParmWith=''
ParmCmds=''
if OptionParmVal<> "N" then
do
if CsReplacement='N' then
ac!ValLst=translate(substr(ThisParmName,3))
else
ac!ValLst=substr(ThisParmName,3)
if OptionDebugOn='Y' then
call _SpecialPrm 'Empty - Parameter validation, valid parms are : ' ||ac!ValLst
ac!ValLstCma=',' || ac!ValLst || ','
ac!Inv=''
do ac!i=1 to ParmCount
if ParmName.ac!i<> '' then
do
if pos(',' || ParmName.ac!i || ',',ac!ValLstCma)=0 then
do
if ac!Inv<> '' then
ac!Inv=ac!Inv||MarksNewLine
ac!Inv=ac!Inv|| '  * ' ||ParmName.ac!i
end
end
end
if ac!Inv<> '' then
CryAndDie('The following macro parameters were unexpected:', ac!Inv,,'Valid parameters are:',ac!ValLst)
end
end
otherwise
do
if ac!ReginaBugWorkAround='N' then
call _DieInvPrm
end
end
end
end
end
if ParmCmds<> '' then
do
ParmCmds=translate(strip(ParmCmds))
do until ParmCmds=''
parse var ParmCmds ParmCmd ParmCmds
if OptionDebugOn='Y' then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS '$$Bef: ' ||ReplaceParmWith
call DebugOutputVariableInfo_FOUNDVARPARMS '$$Cmd: ' ||ParmCmd
call DBGIND-1
end
select
when ParmCmd='$$PASSAQ' then
do
QChar=QuoteIt(ReplaceParmWith, 'ANY')
ReplaceParmWith=ThisParmNameOC|| '=' ||QChar||ReplaceParmWith||QChar
end
when ParmCmd='$$PASSDSQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListDs)
ReplaceParmWith=ThisParmNameOC|| '=' ||QChar||ReplaceParmWith||QChar
end
when ParmCmd='$$IGNORE' then
ReplaceParmWith=''
when ParmCmd='$$ISPASSED' then
ReplaceParmWith=ac!IsPassed

when ParmCmd='$$DSQ' then
ReplaceParmWith=QuoteIt(ReplaceParmWith,TryQuoteListDs, 'Y')

when ParmCmd='$$SDQ' then
ReplaceParmWith=QuoteIt(ReplaceParmWith,TryQuoteListSd, 'Y')

when ParmCmd='$$AQ' then
ReplaceParmWith=QuoteIt(ReplaceParmWith, 'ANY', 'Y')

when ParmCmd='$$UPPER' then
ReplaceParmWith=ToUpperCase(ReplaceParmWith)

when ParmCmd='$$LOWER' then
ReplaceParmWith=ToLowerCase(ReplaceParmWith)

when ParmCmd='$$ADDCOMMA' then
ReplaceParmWith=AddCommasToDecimalNumber(ReplaceParmWith)

when ParmCmd='$$HTMLQ' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, '"', '&quot;')

when ParmCmd='$$BSX2' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, "\" , "\\")

when ParmCmd='$$SQX2' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, "'" , "''")

when ParmCmd='$$DQX2' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, '"' , '""')

when left(ParmCmd,8)="$$RXVAR:" then
ReplaceParmWith=_RxVar(ParmCmd,ReplaceParmWith)

when ParmCmd="$$RX'" then
ReplaceParmWith=_RXQuote(ReplaceParmWith, "'")

when ParmCmd='$$RX"' then
ReplaceParmWith=_RXQuote(ReplaceParmWith, '"')

when ParmCmd='$$C2X' then
ReplaceParmWith=c2x(ReplaceParmWith)

when ParmCmd='$$NOSPAM' then
ReplaceParmWith=NoSpam(ReplaceParmWith, "@TEXT")

when left(ParmCmd,6)="$$DEL:" then
do
lb!Del=substr(ParmCmd,7)
if lb!Del=='' then
CryAndDie("$$Del must have parameters!")
if lb!Del=='?\' then
lb!Del=RexDirChar
if lb!Del<>right(ReplaceParmWith,length(lb!Del))then
ReplaceParmWith=ReplaceParmWith||lb!Del
end

when ParmCmd='$$SPCPLUS' then
do
if ReplaceParmWith\=='' then
ReplaceParmWith=' ' ||ReplaceParmWith
end

when ParmCmd='$$ISBLANK' then
do
if ReplaceParmWith='' then
ReplaceParmWith='Y'
else
ReplaceParmWith='N'
end

when ParmCmd='$$RXEXEC' then
do
RxExec=''
call ExecRexxCmd ReplaceParmWith, 'N'
ReplaceParmWith=RxExec
end

when abbrev(ParmCmd, '$$FILEPART:')then
do
lb!Fps=substr(ParmCmd,12)
if lb!Fps='' then
CryAndDie("$$FilePart must have parameters!")
do while lb!Fps<> ''
parse var lb!Fps lb!Fp ',' lb!Fps
ReplaceParmWith=FilePart(lb!Fp,ReplaceParmWith)
end
end

otherwise
do
parse var ParmCmd ParmCmd ':' TheParameters
UserRexx=CfgMacro("REXX_" || ParmCmd, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || ParmCmd || '" is unknown!')
TheMacro=VariableName
TheName=ThisParmName
TheValue=ReplaceParmWith
call ExecRexxCmd UserRexx, 'N'
if OptionDebugOn='Y' then
do
if ReplaceParmWith=TheValue then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DBGIND-1
end
end
if TheParameters<> '' then
CryAndDie('The $$ replacement command of "' || ParmCmd || '" is did not process its parameters:', '   ' ||TheParameters)
ReplaceParmWith=TheValue
end
end
end
end
if OptionDebugOn='Y' then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'Use : ' ||ReplaceParmWith
call DBGIND-1
end
ParmRightBit=ReplaceParmWith||ParmRightBit
ParmPos=pos(StartsMacroParm,ParmRightBit)
end
ParmLeftBit=ParmLeftBit||ParmRightBit
if ac!ValPointless='N' then
do
if OptionParmVal<> "S" then
do
ac!DieIfNotUsed=OptionParmVal
end
if ac!DieIfNotUsed='Y' | OptionDebugOn = 'Y' then
do
ac!UnUsed=''
do ParmIndex=1 to ParmCount
if ParmUsed.ParmIndex='N' then
do
call DebugOutputVariableInfo_FOUNDVARPARMS 'The "' || ParmName.ParmIndex  || '" parameter was not referred to by the "' || VariableName || '" macro (either invalid or referenced only in unused default value of another parameter).'
if ac!UnUsed='' then
ac!UnUsed=ParmName.ParmIndex
else
ac!UnUsed=ac!UnUsed|| ', ' ||ParmName.ParmIndex
end
end
if ac!DieIfNotUsed='Y' then
do
if ac!UnUsed<> '' then
do
ac!UnUsed='    ' ||ac!UnUsed
if DefaultCnt=0 then
ac!Def='No macro parameters used default values'
else
do
ac!Def=''
do DefaultIndex=1 to DefaultCnt
if ac!Def='' then
ac!Def=PrmDefaultName.DefaultIndex
else
ac!Def=ac!Def|| ', ' ||PrmDefaultName.DefaultIndex
end
end
ac!Def='    ' ||ac!Def
CryAndDie('The "' || VariableName || '" macro was supplied parameters it', 'does not require! These are:', ac!UnUsed, '', 'These macro parameters used default values:',ac!Def)
end
end
end
end
if pos('{',ParmLeftBit)<>0 then
do
if pos(StartsMacroParm,ParmLeftBit)<>0 then
CryAndDie('Not all "' || VariableName || '" parameters replaced!')
ParmLeftBit=ReplaceString(ParmLeftBit,HidesMacroParm,StartsMacroParm)
end
return(ParmLeftBit)

_ReplaceAllHashDefinedVariables:
RightBit=arg(1)
LeftBit=''
ChangesMade='N'
VarPos=pos(StartsMacroReplacement,RightBit)
do while VarPos<>0
LeftBit=LeftBit||left(RightBit,VarPos-1)
RightBit=substr(RightBit,VarPos+2)
DelPos=verify(RightBit,EndsVar, 'M')
if DelPos=0 then
CryAndDie("Can't find the end of the macro reference at " ||DebugRightArrow||StartsMacroReplacement||RightBit||DebugLeftArrow)
VariableName=left(RightBit,DelPos-1)
MacroBeingExpanded=VariableName
RightBit=strip(substr(RightBit,DelPos), 'L')
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDVAR 'Found : ' || StartsMacroReplacement || VariableName || ' ...' ||EndsMacroReplacement
call DBGIND 1
end
DefnAsIs='N'
VariableCont=GetDefineContents(VariableName)
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDVAR 'Value : ' ||DebugRightArrow||VariableCont||DebugLeftArrow
call DBGIND 1
end
ParmCount=0
HaveKeywordParms=''
DDCmdCount=0
PositionalParmCount=0
EndParmDelimiters=EndsMacroReplacement|| '= '
Left1=left(RightBit,1)
do while Left1<>EndsMacroReplacement
if pos(Left1,ArePositionalChars)<>0 then
do
PositionalParmCount=PositionalParmCount+1
ThisParmNameC='#' ||PositionalParmCount
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameC)
else
ThisParmName=ThisParmNameC
ThisParmValType='V'
if Left1='=' then
ThisParmVal=GetQuotedText(substr(RightBit,2), "RightBit", EndsMacroReplacement, 'Getting macro parameter''s value for ' ||ThisParmNameC)
else
ThisParmVal=GetQuotedText(RightBit, "RightBit", EndsMacroReplacement, 'Getting positional macro parameter''s value for ' ||ThisParmNameC)
end
else
do
DelPos=verify(RightBit,EndParmDelimiters, 'M')
if DelPos=0 then
CryAndDie('Macro reference incorrectly formatted, missing "' || EndsMacroReplacement || '"?')
ThisParmNameC=strip(left(RightBit,DelPos-1))
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameC)
else
ThisParmName=ThisParmNameC
DelChar=substr(RightBit,DelPos,1)
if DelChar='=' then
do
ThisParmVal=GetQuotedText(substr(RightBit,DelPos+1), "RightBit", EndsMacroReplacement, 'Getting macro parameter''s value for ' ||ThisParmNameC)
ThisParmValType='V'
end
else
do
RightBit=strip(substr(RightBit,DelPos), 'L')
if left(ThisParmName,2)<> '$$' then
do
ThisParmVal=ThisParmName
ThisParmValType='NV'
HaveKeywordParms=HaveKeywordParms||MarksNewLine|| '   * ' ||ThisParmName
end
else
do
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS '$$Cmd: ' ||ThisParmName
select
when ThisParmName='$$ASIS' then
DefnAsIs='Y'
otherwise
do
DDCmdCount=DDCmdCount+1
DDCmd.DDCmdCount=ThisParmName
end
end
Left1=left(RightBit,1)
iterate
end
end
end
do ChkIndex=1 to ParmCount
if ThisParmName=ParmName.ChkIndex then
CryAndDie('The macro parameter "' || ThisParmName || '" was specified more than once!')
end
ParmCount=ParmCount+1
ParmName.ParmCount=ThisParmName
ParmNameC.ParmCount=ThisParmNameC
ParmValue.ParmCount=ThisParmVal
ParmValueT.ParmCount=ThisParmValType
Left1=left(RightBit,1)
end
if DefnAsIs='Y' then
do
if ParmCount<>0 then
CryAndDie('You wanted "' || VariableName || '" substituted ASIS but then specified parameters!')
end
else
do
if ParmCount<>0 then
VariableCont=ReplaceDefinitionsParameters()
else
do
if pos(StartsMacroParm,VariableCont)<>0 then
VariableCont=ReplaceDefinitionsParameters()
else
VariableCont=ReplaceString(VariableCont,HidesMacroParm,StartsMacroParm)
end
end
if DDCmdCount<>0 then
do
do ddIndex=1 to DDCmdCount
ThisDdCmd=DDCmd.ddIndex
select

when ThisDdCmd='$$DSQ' then
VariableCont=QuoteIt(VariableCont,TryQuoteListDs, 'Y')

when ThisDdCmd='$$SDQ' then
VariableCont=QuoteIt(VariableCont,TryQuoteListSd, 'Y')

when ThisDdCmd='$$AQ' then
VariableCont=QuoteIt(VariableCont, 'ANY', 'Y')

when ThisDdCmd='$$UPPER' then
VariableCont=ToUpperCase(VariableCont)

when ThisDdCmd='$$LOWER' then
VariableCont=ToLowerCase(VariableCont)

when ThisDdCmd='$$ADDCOMMA' then
VariableCont=AddCommasToDecimalNumber(VariableCont)

when ThisDdCmd='$$HTMLQ' then
VariableCont=ReplaceString(VariableCont, '"', '&quot;')

when ThisDdCmd='$$BSX2' then
VariableCont=ReplaceString(VariableCont, "\" , "\\")

when ThisDdCmd='$$SQX2' then
VariableCont=ReplaceString(VariableCont, "'" , "''")

when ThisDdCmd='$$DQX2' then
VariableCont=ReplaceString(VariableCont, '"' , '""')

when left(ThisDdCmd,8)="$$RXVAR:" then
VariableCont=_RxVar(ThisDdCmd,VariableCont)

when ThisDdCmd="$$RX'" then
VariableCont=_RXQuote(VariableCont, "'")

when ThisDdCmd='$$RX"' then
VariableCont=_RXQuote(VariableCont, '"')

when ThisDdCmd='$$C2X' then
VariableCont=c2x(VariableCont)

when ThisDdCmd='$$NOSPAM' then
VariableCont=NoSpam(VariableCont, "@TEXT")

when left(ThisDdCmd,6)="$$DEL:" then
do
lb!Del=substr(ThisDdCmd,7)
if lb!Del=='' then
CryAndDie("$$Del must have parameters!")
if lb!Del=='?\' then
lb!Del=RexDirChar
if lb!Del<>right(VariableCont,length(lb!Del))then
VariableCont=VariableCont||lb!Del
end

when ThisDdCmd='$$SPCPLUS' then
do
if VariableCont\=='' then
VariableCont=' ' ||VariableCont
end

when ThisDdCmd='$$ISBLANK' then
do
if VariableCont='' then
VariableCont='Y'
else
VariableCont='N'
end

when ThisDdCmd='$$RXEXEC' then
do
RxExec=''
call ExecRexxCmd VariableCont, 'N'
VariableCont=RxExec
end

when abbrev(ThisDdCmd, '$$FILEPART:')then
do
lb!Fps=substr(ThisDdCmd,12)
if lb!Fps='' then
CryAndDie("$$FilePart must have parameters!")
do while lb!Fps<> ''
parse var lb!Fps lb!Fp ',' lb!Fps
VariableCont=FilePart(lb!Fp,VariableCont)
end
end

otherwise
do
parse var ThisDdCmd ThisDdCmd ':' TheParameters
UserRexx=CfgMacro("REXX_" || ThisDdCmd, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || ThisDdCmd || '" is unknown!')
TheMacro=""
TheName=VariableName
TheValue=VariableCont
call ExecRexxCmd UserRexx, 'N'
if OptionDebugOn='Y' then
do
if VariableCont=TheValue then
do
call DBGIND 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DBGIND-1
end
end
if TheParameters<> '' then
CryAndDie('The $$ replacement command of "' || ThisDdCmd || '" is did not process its parameters:', '   ' ||TheParameters)
VariableCont=TheValue
end
end
end
end
if OptionDebugOn='Y' then
call DBGIND-2
RightBit=substr(RightBit,2)
LeftBit=LeftBit||VariableCont
ReplaceCount=ReplaceCount+1
if pos(MarksNewLine,LeftBit)<>0 then
leave
VarPos=pos(StartsMacroReplacement,RightBit)
end
MacroBeingExpanded=''
TheString=LeftBit||RightBit
return(TheString)

CfgMacro:
bc!M=arg(1)
if MacroExists(bc!M)='N' then
do
bc!V=arg(2)
bc!Wrd='not'
end
else
do
bc!V=GetDefineContents(bc!M)
bc!Wrd='was'
end
if OptionDebugOn='Y' then
call DBG_MACROVALORDEF 'Option(Macro) "' || bc!M || '" ' || bc!Wrd || ' found. Using ' ||DebugRightArrow||bc!V||DebugLeftArrow
return(bc!V)

CfgEnv:
cc!V=arg(1)
cc!Rc=GetEnv(cc!V)
if cc!Rc\=='' then
cc!C='was'
else
do
cc!Rc=arg(2)
cc!C='not'
end
if OptionDebugOn='Y' then
call DBG 'Option(Env) "' || cc!V || '" ' || cc!C || ' found. Using ' ||DebugRightArrow||cc!Rc||DebugLeftArrow
return(cc!Rc)

_InfiniteLoopDetectedTurnDebugOn:
OptionDebugOn='Y'
call DebugStateChanged
call DBG '###'
call DBG '### Debug automatically turned on'
call DBG '### A ' || arg(1) || ' infinite loop was detected!'
call DBG '###'
call DBG ''
return

_InfiniteLoopDie:
call DBG ''
call DBG '###'
call DBG '### Dying now (hopefully info above helps)!'
call DBG '###'
call DBG ''
cc!T=arg(1)|| '\n\nDebug mode was turned on for you above to aid in the problem resolution.'
cc!T=ReplaceString(cc!T, "\n",MarksNewLine)
CryAndDie(cc!T)

_InfiniteLoopShowIfOff:
if arg(1)=0 then
do
call DBGIND 1
call DBG 'Infinite loop detection for ' || arg(2) || ' substitution turned off!'
call DBGIND-1
end
return

Define_29:
RexxTokens='|=+-/%*<>\,;:()&'
signal LineOut_30

GenerateOneLine:
if CondNlCount=0 then
call GenerateOneLineAsIs arg(1)
else
do
if OptionDebugOn='Y' then
call DBG 'Looking for Conditional newline codes'
BefCodeCount=ReplaceCount
Line2Gen=ReplaceString(arg(1), "{?WaNtNl?}",MarksNewLine)
if BefCodeCount<>ReplaceCount then
do
if OptionDebugOn='Y' then
call DBG 'Found ' ReplaceCount - BefCodeCount || ' conditional newline codes'
CondNlCount=CondNlCount-(ReplaceCount-BefCodeCount)
do until BefCodeCount=ReplaceCount
BefCodeCount=ReplaceCount
Line2Gen=ReplaceString(Line2Gen,MarksNewLine||MarksNewLine,MarksNewLine)
end
if Line2Gen\=='' then
do
if left(Line2Gen,1)=MarksNewLine then
Line2Gen=substr(Line2Gen,2)
if Line2Gen\=='' then
do
if right(Line2Gen,1)=MarksNewLine then
Line2Gen=left(Line2Gen,length(Line2Gen)-1)
end
end
end
do until Line2Gen==''
parse var Line2Gen This1 (MarksNewLine) Line2Gen
call GenerateOneLineAsIs This1
end
end
return

GenerateOneLineAsIs:
Line2Gen2=arg(1)
if CheckSpelling='Y';then
do
if AllowSpell='Y' & Line2Gen2 <> '' then
call SpellCheckOneLine Line2Gen2
end
if OptionFilterOut='' then
do
if HoldingOutput='N' then
call FileCharOut CurrentOutFile,Line2Gen2||NewLineChars
else
HeldOutput=HeldOutput||Line2Gen2||NewLineChars
GeneratedLines=GeneratedLines+1
CurrentOutLine=CurrentOutLine+1
end
else
do
FilterRc=HtmlFilterOut("O",Line2Gen2,CurrentOutFile,CurrentOutLine,GeneratedLines,NewLineChars)
if Left(FilterRc,3)<> "OK:" then
CryAndDie(FilterRc)
else
do
NumWritten=substr(FilterRc,4)
GeneratedLines=GeneratedLines+NumWritten
CurrentOutLine=CurrentOutLine+NumWritten
end
end
return

OutputRexxLine:
RexxLine=arg(1)
if right(RexxLine,1)=';' then
RexxLine=left(RexxLine,length(RexxLine)-1)
if OptionPack='Y' & KeepIndent = 'N' then
do
if AllowPack='Y' then
RexxLine=CompressRexxLine(RexxLine)
else
do
if OptionDebugOn='Y' then
call DBG 'Not allowed to pack this line'
end
end
ElPos=pos(':',RexxLine)
if ElPos<>0 then
do
PossLabel=strip(left(RexxLine,ElPos-1))
if datatype(PossLabel, 'S')=1 then
call GenerateOneLine ''
end
if pos(NotEqualInC,RexxLine)<>0 then
call OutputInformationToScreen '"' || NotEqualInC || '" found.  Did you mean to use "<>" or "\="?'
call GenerateOneLine RexxLine
return

CompressRexxLine:
RexxLine=arg(1)
Spos=lastpos("'",RexxLine)
Dpos=lastpos('"',RexxLine)
EndPos=max(Spos,Dpos)
if EndPos=0 then
return(_CompressRexx(RexxLine))
else
do
Spos=pos("'",RexxLine)
Dpos=pos('"',RexxLine)
StartPos=min(Spos,Dpos)
if StartPos=0 then
StartPos=max(Spos,Dpos)
LeftBit=left(RexxLine,StartPos-1)
RightBit=substr(RexxLine,EndPos+1)
if right(LeftBit,1, "*") == ' ' then
LeftSpace=' '
else
LeftSpace=''
if left(RightBit,1, "*") == ' ' then
RightSpace=' '
else
RightSpace=''
LeftBit=_CompressRexx(LeftBit)
RightBit=_CompressRexx(RightBit)
if LeftSpace==' ' then
do
if right(LeftBit,1)='=' then
LeftSpace=''
end
LeftBit=_CompressRexx(LeftBit)
RightBit=_CompressRexx(RightBit)
return(LeftBit||LeftSpace||substr(RexxLine,StartPos,(EndPos-StartPos)+1)||RightSpace||RightBit)
end

_CompressRexx:
ToCompress=space(arg(1))
Compressed=''
TokenPos=verify(ToCompress,RexxTokens, 'M')
do while TokenPos<>0
Compressed=Compressed||strip(left(ToCompress,TokenPos-1), 'T')||substr(ToCompress,TokenPos,1)
ToCompress=strip(substr(ToCompress,TokenPos+1), 'L')
TokenPos=verify(ToCompress,RexxTokens, 'M')
end
return(Compressed||ToCompress)

LineOut_30:
call InitializeOneLine
signal OneLine_31

InitializeOneLine:
OneLineLevel=0
OneLineBuffer=''
OneLineGCount=0
return

InitializeOneLine4ThisLevel:
OneLineSeperator.OneLineLevel=''
OneLineStopper.OneLineLevel=''
OneLineNonPpwCnt.OneLineLevel=0
OneLineCount.OneLineLevel=0
return

AddToOneLine:
_OneLineBit=arg(1)
_Word1=word(_OneLineBit,1)
if translate(_Word1)=CmdHash1Line then
do
if OneLineBuffer\=='' then
do
OneLineBuffer=OneLineBuffer||OneLineSeperator.OneLineLevel
end
call ProcessOneLine subword(_OneLineBit,2),CmdHash1LineEnd
return('')
end
if strip(_OneLineBit)<>OneLineStopper.OneLineLevel then
do
OneLineCount.OneLineLevel=OneLineCount.OneLineLevel+1
OneLineGCount=OneLineGCount+1
if OneLineGCount=1 then
do
if translate(left(_Word1,length(CmdHashDefine)))=CmdHashDefine then
do
PpwCmdDivider2=MarksNewLineInHashDefine
OneLineBuffer=OneLineBuffer||_OneLineBit|| ' '
end
else
do
PpwCmdDivider2=MarksNewLine
OneLineNonPpwCnt.OneLineLevel=OneLineNonPpwCnt.OneLineLevel+1
OneLineBuffer=OneLineBuffer||_OneLineBit
end
end
else
do
if left(_Word1,HashPrefixLng)<>HashPrefix then
do
if OneLineNonPpwCnt.OneLineLevel=0 then
OneLineBuffer=OneLineBuffer||_OneLineBit
else
OneLineBuffer=OneLineBuffer||OneLineSeperator.OneLineLevel||_OneLineBit
OneLineNonPpwCnt.OneLineLevel=OneLineNonPpwCnt.OneLineLevel+1
end
else
do
parse var _OneLineBit _ppwCmd _ppwCmdParm
_OneLineBit=_ppwCmd|| ' ' ||strip(_ppwCmdParm)
OneLineBuffer=OneLineBuffer||PpwCmdDivider2||_OneLineBit||PpwCmdDivider2
end
end
return('')
end
if OptionDebugOn='Y' then
call DBG 'End of #( block - ' || OneLineCount.OneLineLevel || ' line(s)'
OneLineLevel=OneLineLevel-1
call StackPop "#( Nesting"
if OneLineLevel<>0 then
return('')
else
do
_OneLineBit=OneLineBuffer
call InitializeOneLine
return(_OneLineBit)
end

ProcessOneLine:
OneLineLevel=OneLineLevel+1
call StackPush "#( Nesting",,"PPWIZARD's #( command"
call InitializeOneLine4ThisLevel
Rest=PerformReplacementsInCmdsParameters(arg(1))
if Rest='' then
do
OneLineSeperator.OneLineLevel=CfgMacro("PPWIZARD_DEFAULT_#(_SEPARATOR", ' ')
end
else
do
OneLineSeperator.OneLineLevel=GetQuotedText(Rest, "Rest")
end
if Rest<> '' then
OneLineStopper.OneLineLevel=GetQuotedText(Rest)
else
do
OneLineStopper.OneLineLevel=arg(2)
if OneLineStopper.OneLineLevel='' then
OneLineStopper.OneLineLevel=HashPrefix|| 'OneLineEnd'
end
if OptionDebugOn='Y' then
do
call DBG 'Line separator      = ' ||DebugRightArrow||OneLineSeperator.OneLineLevel||DebugLeftArrow
call DBG 'End of block marker = ' || DebugRightArrow || OneLineStopper.OneLineLevel   || DebugLeftArrow || ' (case sensitive!)'
end
return(0)

OneLine_31:
UserHashCmds=''
signal CMDNFND_32

LookForUnknownCmdHandler:
UserHashCmds=CfgMacro("UNKNOWN_HASH_COMMANDS", '')
return

ProcessUnknownHashCommand:
parse arg HashCmd,HashParms
CmdGenerates=''
call ExecRexxCmd UserHashCmds
if CmdGenerates\=='' then
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=CmdGenerates
else
IncludeLoopMemBufferNextLine=CmdGenerates||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=CmdGenerates
else
IncludeMemBufferNextLine=CmdGenerates||MarksNewLine||IncludeMemBufferNextLine
end
end
end
return(0)

CMDNFND_32:
OptChar='-'
CmdLineQL='"' || "'~`!#$%^=(["
CmdLineQR='"' || "'~`!#$%^=)]"
signal CmdLine_33

InitCommandLineOptions:
Bc02_148='N'
OptCharW='/'
OptCharU='-'
OptionsCmdLine=strip(arg(1))
OptionDebugOn='N'
OptionMaxCol=500
OptionPpwTraceAllowed='N'
OptionAddressCmdTrace=''
DependsOnCheckOnly='N'
DaylightSavings='Y'
DepDelPrev='N'
OptionBaseDirectory=''
InputMasksAllowed='Y'
OptionPrjExtn='DEF_*'
CgiOutputFile=''
OptionCgiModeOn='N'
ProcessingMode=''
OptionCloneUsed='N'
call BuildTitle "HTML",       '?'
call BuildTitle "POWERSHELL", '?'
call BuildTitle "OTHER",      '?'
call BuildTitle "REXX",       '?'
call BuildTitle "COPY",       '?'
OptionMsgReading="* Reading: {.}{F?}({F})"
OptionMsgMaking="- Making: {.}{R?}"
PpwOnOK=''
PpwOnERROR=''
if RexSystemOpSys="UNIX" then
OptionFileSR='NONE'
else
OptionFileSR='UNC'
OptionValidation=''
OptionValidationRc=''
OptionDependsOn=''
OptionWantInfoMsgs='Y'
OptionHashIncludeCnt=0
OptionIncludePathCnt=0
OptionTemplate=''
OptionQuietDependsOn='N'
OptionSummary='Y'
OptionPack='N'
OptionTranslateFileNames='N'
OptionFilterIn=''
OptionFilterOut=''
OptionDefineCount=0
OptionKeepRexxCmts='N'
OptionCompleteAddToToDepFile='Y'
OptionRepeatsOfInputFileOK='N'
OptionAtEndCommand=''
OptionAtEndCommandOkTest=''
HaveGeneratorTags='N'
OptionHtmlGeneratorTags=''
OptionNoDepFileOnWarnings='Y'
OptionHideCmdS=''
OptionHideCmdE=''
OptionHideCmdS_L=0
OptionHideCmdE_L=0
OptionForceRebuild='N'
OptionOutput=''
OptionOutputDefDir=''
OptionNoFiles=''
OptionCopyModeFuzz=0
Option0FilesPerMaskOk='N'
Option0FilesTotalOk='N'
Option0FilesTotalAfterExcludeOk='N'
OptionXSlash=''
OptionDeleteOnError='Y'
OptionTeeDelay=0
return

InitCommandLineOptions2:
call DBG 'Set up default extension Handlers'
call DBGIND 1
call DBG 'Set EXTN -> Processing mode and default output mask mappings'
call DBGIND 1
call ExtnInfoSet "*,it:PM=^LU:HTML^,OM=^LU:{$OutputDir}*.htm^,DM=^LU:^"
call ExtnInfoSet "v:PM=^LU:OTHER^,OM=^LU:{$OutputDir}*.vbs^,DM=^LU:^"
call ExtnInfoSet "j:PM=^LU:OTHER^,OM=^LU:{$OutputDir}*.js^,DM=^LU:^"
if RexSystemOpSys="OS/2" then
dc!XE="cmd"
else
dc!XE="rex"
call ExtnInfoSet "x:PM=^LU:REXX^,OM=^LU:{$OutputDir}*." || dc!XE || '^,DM=^LU:^'
call ExtnInfoSet "p:PM=^LU:POWERSHELL^,OM=^LU:{$OutputDir}*.ps1^,DM=^LU:^"
call DBGIND-1
call DBG 'Set OUTPUT EXTN/PROCESSING MODES -> header mappings'
call DBGIND 1
dc!Line=copies('*+',30)
call StoreOutHeader "|VBS|'"         || dc!Line || "|' |'"   || dc!Line || "|"
call StoreOutHeader "|JS|//"         || dc!Line || "|// |//" || dc!Line || "|"
call StoreOutHeader "|C|//"          || dc!Line || "|// |//" || dc!Line || "|"
call StoreOutHeader "|*REXX|/*"      || dc!Line || "|* |"    || dc!Line || "*/|"
call StoreOutHeader "|*POWERSHELL|#" || dc!Line || "|# |#"   || dc!Line || "|"
call DBGIND-1
call DBG 'Set OUTPUT EXTN/PROCESSING MODES -> Syntax handlers'
call DBGIND 1
dc!R=PPWIZARD_REGINA_SYNTAX_CMD('N')
if dc!R='' then
call StoreSyntaxCheckCode4Header '|*REXX|*|'
else
call StoreSyntaxCheckCode4Header '|*REXX|' || dc!R || ' !CheckSyntax!|21924|' || PPWIZARD_REGINA_SYNTAX_LINE_MASK() || '|if arg(1)="!CheckSyntax!" then exit(21924)|'
call StoreSyntaxCheckCode4Header '|VBS|cscript.exe "{?}" //NOLOGO !CheckSyntax!|21924|({?}, {?C}) |?:if Wscript.Arguments.Count = 1 then if Wscript.Arguments(0) = "!CheckSyntax!" then wscript.quit(21924)|'
call StoreSyntaxCheckCode4Header '|JS|cscript.exe "{?}" //NOLOGO !CheckSyntax!|21924|({?}, {?C}) |?:if (WScript.Arguments.length == 1) {if (WScript.Arguments(0) == "!CheckSyntax!") WScript.quit(21924)}|'
call StoreSyntaxCheckCode4Header '|*POWERSHELL|PowerShell.exe -ExecutionPolicy Bypass -NoLogo -NonInteractive -File "{?}" "!CheckSyntax!"|21924|.ps1:{?} char:{?C}|?:if ($($args.Count) -eq 1) { if  ($($args[0]) -eq "!CheckSyntax!") {EXIT 21924} }|'
call DBGIND-1
call DBGIND-1
return

PPWIZARD_REGINA_SYNTAX_CMD:
ec!TH=arg(1)
call DBG 'PPWIZARD_REGINA_SYNTAX_CMD(' || ec!TH || ')'
call DBGIND 1
ec!R=GetEnv("PPWIZARD_REGINA_SYNTAX_CMD")
if ec!R='' & ec!TH = 'Y' then
do
if RexWhich='REGINA' then
ec!R='regina'
else
do
if RexSystemOpSys="OS/2" then
do
ec!R=GetEnv("COMSPEC", "Y") || ' /C'
end
end
end
if ec!R<> '' then
do
ec!N='{?}'
if pos(ec!N,ec!R)=0 then
ec!R=ec!R|| ' "' || ec!N || '"'
end
call DBG 'Returning: ' ||ec!R
call DBGIND-1
return(ec!R)

PPWIZARD_REGINA_SYNTAX_LINE_MASK:
call DBG 'PPWIZARD_REGINA_SYNTAX_LINE_MASK()'
call DBGIND 1
fc!M=GetEnv("PPWIZARD_REGINA_SYNTAX_LINE_MASK")
if fc!M='' then
fc!M='line {?}: '
call DBG 'Returning: ' ||fc!M
call DBGIND-1
return(fc!M)

QuickCheckForDebugSwitch:
OptionsEnvironment=GetEnv('PPWIZARD_OPTIONS')
fc!LI=translate(OptionsEnvironment|| ' ' || OptionsCmdLine) || ' '
fc!P=pos(OptCharW|| 'DEBUG ',fc!LI)
if fc!P=0 then
fc!P=pos(OptCharU|| 'DEBUG ',fc!LI)
if fc!P<>0 then
do
call UserIsSpecifyingConsoleFileName "*"
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
OptionPpwTraceAllowed='Y'
call DebugStateChanged
end
return

ProcessCommandLine:
call SetUpPpwizardOptionDefaults
call InitializeCharCodes
PpwDoing='Starting to processing parameters (from command line + Environment)'
call DBG PpwDoing
InputMaskCount=0
DebugSwitchUsed='N'
OptionWantCopyright='Y'
CmdLineTotal=''
PpwClDep=''
call ProcessCommandLineBit "environment",OptionsEnvironment
PpwDefaultProject=FindProjectFile('ppwizard')
if PpwDefaultProject<> '' then
call ProcessCommandLineBit PpwDefaultProject,OptChar|| 'LIST:' || ReplaceString(PpwDefaultProject, ' ', '{x20}')
call ProcessCommandLineBit "command line",OptionsCmdLine
call DBG 'Finished Processing : ' ||CmdLineTotal
PpwDoing=''
return

AddToSwitchList:
gc!ForDep=arg(1)
gc!ThisParm=ReplaceString(ThisParm, ' ', '{x20}')
if CmdLineTotal='' then
CmdLineTotal=gc!ThisParm
else
CmdLineTotal=CmdLineTotal|| ' ' ||gc!ThisParm
if gc!ForDep='Y' then
do
if PpwClDep='' then
PpwClDep=gc!ThisParm
else
PpwClDep=PpwClDep|| ' ' ||gc!ThisParm
end
return

ProcessCommandLineBit:
parse arg hc!What,hc!CmdLine
hc!CmdLine=ReplaceEnv(hc!CmdLine)
call DBGIND 1
call DBG 'Processing switches - ' ||hc!What
call DBGIND 1
do while hc!CmdLine<> ''
hc!CmdLine=strip(hc!CmdLine)
hc!QPos=pos(left(hc!CmdLine,1),CmdLineQL)
if hc!QPos<>0 then
do
hc!SQ=substr(CmdLineQL,hc!QPos,1)
hc!EQ=substr(CmdLineQR,hc!QPos,1)
call DBG 'Item quoted. Left Quote = ' || hc!SQ || ', Looking for end quote of ' ||hc!EQ
hc!Start=hc!CmdLine
hc!CmdLine=substr(hc!CmdLine,2)
hc!QPos=pos(hc!EQ,hc!CmdLine)
if hc!QPos=0 then
UserSyntaxError('Could not find the ending quote of ' || hc!EQ || ' at ==> ' ||hc!Start)
ThisParm=left(hc!CmdLine,hc!QPos-1)
hc!CmdLine=substr(hc!CmdLine,hc!QPos+1)
if hc!CmdLine<> '' then
do
if left(hc!CmdLine,1)\==' ' then
UserSyntaxError('Invalid quoted parameter (space must follow quoted item) at ==> ' ||hc!Start)
end
end
else
do
parse var hc!CmdLine ThisParm hc!CmdLine
end
ParmType=left(ThisParm,1)
select
when ParmType=OptCharU|((ParmType=OptCharW)&(RexSystemOpSys<> "UNIX"))then
do
ThisParmT='Switch'
OptChar=ParmType
end
when ParmType='@' then
ThisParmT='Project'
when ParmType=';' then
ThisParmT='Commented out'
otherwise
do
ThisParmT='FileMask'
ParmType=''
end
end
call DBG ThisParmT|| ' <- "' || ThisParm || '"'
if ParmType=';' then
iterate
call DBGIND 1
ThisParm=ReplaceCurlyHexCodes(ThisParm)
PpwDoing='Processing command line: ' ||ThisParm
if ParmType='@' then
do
PrjFile=substr(ThisParm,2)
PrjFileF=FindProjectFile(PrjFile)
if PrjFileF='' then
CryAndDie('The specified project "' || PrjFile || '" does not exist')
ThisParm=OptChar|| 'LIST:' || ReplaceString(PrjFileF, ' ', '{x20}')
hc!CmdLine=ThisParm|| ' ' ||hc!CmdLine
call DBGIND-1
iterate
end
if ParmType='' then
do
if InputMasksAllowed='N' then
CryAndDie('Sorry but no more input masks can be accepted', 'Input mask "' || ThisParm || '" specified in:', '    ' ||hc!What)
call AddToSwitchList 'N'
hc!FM=MakeAbsolute(ThisParm)
hc!FF='?' ||RexDirChar
if left(hc!FM,2)=hc!FF then
do
hc!Find=substr(hc!FM,3)
hc!FM=FindFile(hc!Find, '!')
end
hc!Marker='{ENDBASE}'
if pos(hc!Marker,hc!FM)<>0 then
do
parse var hc!FM hc!BD (hc!Marker) hc!FM
hc!FM=hc!BD||hc!FM
call DBG 'Without base dir marker = "' || hc!FM || '"'
if left(hc!BD,1)='+' then
hc!BD=substr(hc!BD,2)
end
else
do
if OptionBaseDirectory<> '' then
do
hc!BD=OptionBaseDirectory
end
else
do
if left(hc!FM,1)='+' then
hc!BD=substr(hc!FM,2)
else
hc!BD=hc!FM
hc!BD=_filespec('Location',hc!BD)
end
end
call ValidateBaseDirUse hc!BD,hc!FM, 'Y'
hc!PM=ProcessingMode
hc!OM=OptionOutput
hc!DM=OptionDependsOn
InputMaskCount=InputMaskCount+1
InputMaskBDir.InputMaskCount=hc!BD
InputMaskPMode.InputMaskCount=hc!PM
InputMaskOutMask.InputMaskCount=hc!OM
InputMaskDepMask.InputMaskCount=hc!DM
InputMaskCpyFuzz.InputMaskCount=OptionCopyModeFuzz
InputMask0FilesOk.InputMaskCount=Option0FilesPerMaskOk
hc!U="<Unknown at this time>"
if hc!PM='' then
hc!PM=hc!U
if hc!OM='' then
hc!OM=hc!U
if hc!DM='' then
hc!DM=hc!U
call DBG 'Base Directory  = "' || hc!BD || '"'
call DBG 'Processing Mode = "' || hc!PM || '"'
call DBG 'Output Mask     = "' || hc!OM || '"'
call DBG 'Depends On Mask = "' || hc!DM || '"'
call DBG '0 Files OK      = ' ||Option0FilesPerMaskOk
call DBG 'Copy Fuzz (sec) = ' ||OptionCopyModeFuzz
InputMask.InputMaskCount=hc!FM
call DBGIND-1
iterate
end
ParmPos=verify(ThisParm, ':=', 'M')
if ParmPos=0 then
do
ThisCmd=ThisParm
ThisCmdOptions=''
end
else
do
ThisCmd=left(ThisParm,ParmPos-1)
ThisCmdOptions=substr(ThisParm,ParmPos+1)
end
ThisCmd=translate(substr(ThisCmd,2))
RecordSwitch='Y'
IsDepSwitch='Y'
select
when ThisCmd='PACK' then
OptionPack=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='DELETEPREV' then
DepDelPrev=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='CRLF' then
do
if SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y') = 'Y' then
NewLineChars=CrLf
else
NewLineChars=MarksNewLine
end
when ThisCmd='CLONE' then
do
if InputMaskCount<>0 then
UserSyntaxError('Clone must be specified before any file masks!')
OptionCloneUsed='Y'
hc!CmdLine='/COPY:' || ThisCmdOptions || ' /CopyRight:N ' ||hc!CmdLine
OptionSummary='N'
end
when ThisCmd='COPY' then
do
if ThisCmdOptions<> '' then
do
OptionCopyModeFuzz=ThisCmdOptions
if datatype(OptionCopyModeFuzz, 'W')=0 then
UserSyntaxError('Invalid /Copy:Fuzz value of "' || OptionCopyModeFuzz || '" supplied!')
end
call PModeSwitch ThisCmd
end
when ThisCmd='OTHER' then
call PModeSwitch ThisCmd,ThisCmdOptions
when ThisCmd='HTML' then
call PModeSwitch ThisCmd,ThisCmdOptions
when ThisCmd='REXX' then
call PModeSwitch ThisCmd,ThisCmdOptions
when ThisCmd='POWERSHELL' then
call PModeSwitch ThisCmd,ThisCmdOptions
when ThisCmd='NOFILES' then
OptionNoFiles=ThisCmdOptions
when ThisCmd='TEEDELAY' then
OptionTeeDelay=ThisCmdOptions
when ThisCmd='OUTPUT' then
do
hc!V=ThisCmdOptions
if right(hc!V,1)=RexDirChar then
do
OptionOutputDefDir=hc!V
call DBG "Setting default output directory"
end
else
do
call DBG "Setting processing mode"
OptionOutput=hc!V
end
end
when ThisCmd='DEPENDSON' then
do
OptionDependsOn=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
if left(OptionDependsOn,1)='-' then
do
OptionQuietDependsOn='y'
OptionDependsOn=substr(OptionDependsOn,2)
end
else
do
if left(OptionDependsOn,1)='!' then
do
OptionQuietDependsOn='Y'
OptionDependsOn=substr(OptionDependsOn,2)
end
else
do
OptionQuietDependsOn='N'
end
end
end
when ThisCmd='DEPENDSONCOMPLETE' then
OptionCompleteAddToToDepFile=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='DEPENDSONIGNORE1H' then
DaylightSavings=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='DEPENDSONCHECKONLY' then
do
DependsOnCheckOnly=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
if DependsOnCheckOnly='Y' then
OptionQuietDependsOn='N'
end
when ThisCmd='0OK' then
do
if ThisCmdOptions='' then
ThisCmdOptions='YES,YES,YES'
parse var ThisCmdOptions hc!P1 ',' hc!P2 ',' hc!P3
if hc!P1<> '' then
Option0FilesPerMaskOk=SwitchWantsYesOrNo(ThisCmd,hc!P1, 'Y')
if hc!P2<> '' then
Option0FilesTotalOk=SwitchWantsYesOrNo(ThisCmd,hc!P2, 'Y')
if hc!P3<> '' then
Option0FilesTotalAfterExcludeOk=SwitchWantsYesOrNo(ThisCmd,hc!P3, 'Y')
end
when ThisCmd='TEMPLATE' then
OptionTemplate=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
when ThisCmd='COLOR' | ThisCmd = 'COLOUR' then
call ColorAllow SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='COLORCFG' then
do
hc!O=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
parse var hc!O hc!Var '=' hc!Val
if hc!Val='' then
CryAndDie('Incorrectly formatted color configuration of "' || hc!O || '"')
call ColorCfg hc!Var,hc!Val
end
when ThisCmd='BEEP' then
call BeepsAllow SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='REPEATSOFINPUTFILEOK' then
OptionRepeatsOfInputFileOK=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='BC' then
do
hc!P=translate(SwitchMustHaveOptions(ThisCmd,ThisCmdOptions))
parse var hc!P hc!F '=' hc!V
hc!FV='BC' || ReplaceString(hc!F, '.', '_')
if hc!V<> 'N' & hc!V <> 'Y' then
CryAndDie('Expected "Y" or "N" for ' || hc!FV || ' flag')
if symbol(hc!FV)<> 'VAR' then
CryAndDie('Invalid backwards compat flag of ' ||hc!FV)
call value hc!FV,hc!V
end
when ThisCmd='WARNINGSRC' then
do
if ThisCmdOptions='' then
WantedWarningRc=1
else
do
WantedWarningRc=GetQuotedText(ThisCmdOptions)
if datatype(WantedWarningRc, 'W')=0 then
CryAndDie('Invalid warning return code of "' || WantedWarningRc || '" supplied!')
end
end
when ThisCmd='OUTHEADER' then
call StoreOutHeader GetQuotedText(ThisCmdOptions)
when ThisCmd='SYNTAX' then
call StoreSyntaxCheckCode4Header GetQuotedText(ThisCmdOptions)
when ThisCmd='EXTNINFO' then
call ExtnInfoSet ThisCmdOptions
when ThisCmd='FILENAMES' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
OptionTranslateFileNames=translate(strip(ThisCmdOptions))
if OptionTranslateFileNames<> "LOWER" & OptionTranslateFileNames <> "UPPER" then
UserSyntaxError('Expected "UPPER" or "LOWER" on the "' || TheCmd || '" command, not "' || ThisCmdOptions || '"!')
end
when ThisCmd='DEFINE' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
parse var ThisCmdOptions DefineVar'='DefineContents
OptionDefineCount=OptionDefineCount+1
OptionDefine.OptionDefineCount.Var=DefineVar
OptionDefine.OptionDefineCount.Cont=strip(DefineContents)
end
when ThisCmd='OPTION' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
call ProcessOption ThisCmdOptions
end
when ThisCmd='REQUIRE' then
do
hc!P=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
call ProcessRequireCommon translate(hc!P, ' ', ',')
end
when ThisCmd='FILTERINPUT' then
do
call NotAvailableUnderNtYet ThisCmd
OptionFilterIn=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
call DoMacroSpaceOperation "ADD", OptionFilterIn, "HtmlFilterIn"
end
when ThisCmd='FILTEROUTPUT' then
do
call NotAvailableUnderNtYet ThisCmd
OptionFilterOut=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
call DoMacroSpaceOperation "ADD", OptionFilterOut, "HtmlFilterOut"
end
when ThisCmd='SPELLSHOWALL' then
SpellShowEachError=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='SPELLCHECK' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
call LoadSpellingDictionary ThisCmdOptions
end
when ThisCmd='SPELLADDWORD' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
SpellingAddFile=ThisCmdOptions
if left(SpellingAddFile,1)<> '-' then
SpellingPrompts='Y'
else
do
SpellingPrompts='OK'
SpellingAddFile=substr(SpellingAddFile,2)
end
end
when ThisCmd='**/' then
OptionKeepRexxCmts=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='INFO' then
OptionWantInfoMsgs=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='#INCLUDE' | ThisCmd = 'INCLUDE' then
do
if ThisCmdOptions='' then
OptionHashIncludeCnt=0
else
do
OptionHashIncludeCnt=OptionHashIncludeCnt+1
OptionHashInclude.OptionHashIncludeCnt=ThisCmdOptions
end
call DBG OptionHashIncludeCnt|| ' /#Include items stored'
end
when ThisCmd='BASEDIR' then
do
OptionBaseDirectory=MakeAbsolute(ThisCmdOptions)
call DBG "BASEDIR: " ||OptionBaseDirectory
end
when ThisCmd='INCLUDEPATH' then
do
call IncludePath ThisCmdOptions
end
when ThisCmd='CGI' then
call TurnCgiModeOn ThisCmdOptions
when ThisCmd='HTMLGENERATOR' then
do
HaveGeneratorTags='Y'
OptionHtmlGeneratorTags=ThisCmdOptions
end
when ThisCmd='EXCLUDE' then
do
IsDepSwitch='N'
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
ExcludeList.0=0
TmpMask=ThisCmdOptions
call DBG 'Looking for files matching "' || TmpMask || '"'
if left(TmpMask,1)<> '+' then
FollowDirs='N'
else
do
FollowDirs='Y'
TmpMask=substr(TmpMask,2)
end
call Files4Mask TmpMask, 'ExcludeList',FollowDirs
call DBGIND 1
call DBG 'Found ' || ExcludeList.0 || ' files(s) to exclude'
call DBGIND 1
do InputIndex=1 to ExcludeList.0
TheFile=ExcludeList.InputIndex
call DBG TheFile
call _valueS "_EXCLUDE_._EXF_" || c2x(UFile(TheFile)), 'you used "' || OptChar || ThisCmd || ':' || ThisCmdOptions || '"'
end
call DBGIND-2
end
when ThisCmd='INC2CACHE' then
IncludeIntoMemory=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='PPWTRACE' then
OptionPpwTraceAllowed=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='ADDRESSCMDTRACE' then
OptionAddressCmdTrace=translate(ThisCmdOptions)
when ThisCmd='DEBUGTIME' then
OptionDebugTime=ThisCmdOptions
when ThisCmd='DEBUGCHARS' then
call SetDebugChars ThisCmdOptions
when ThisCmd='HOOK' then
call RexxHookSet ThisCmd,ThisCmdOptions
when ThisCmd='REGSYNTAX' then
do
if RexWhich='REGINA' then
call DBG "/RegSyntax has no effect under Regina!"
NameOfOs2ReginaRexxInterpreter=ThisCmdOptions
end
when ThisCmd='REDIRMETHOD' then
RedirMethod=ThisCmdOptions
when ThisCmd='DEBUG' then
do
call BeepsAllow 'N'
call ColorAllow 'N'
call SwitchMustNotHaveOptions ThisCmd,ThisCmdOptions
DebugSwitchUsed='Y'
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
OptionPpwTraceAllowed='Y'
call DebugStateChanged
end
when ThisCmd='COPYRIGHT' then
OptionWantCopyright=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='XSLASH' then
do
YesOrNo=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
if YesOrNo='N' then
OptionXSlash=''
else
OptionXSlash=' /'
end
when ThisCmd='GETENV' then
do
FromEnv=GetEnv(ThisCmdOptions)
if FromEnv='' then
CryAndDie('The environment variable "' || ThisCmdOptions || '" does not exist.')
call DBG 'Contained: ' ||FromEnv
hc!CmdLine=FromEnv|| ' ' ||hc!CmdLine
end
when ThisCmd='INPUT' then
hc!CmdLine='"' || SwitchMustHaveOptions(ThisCmd, ThisCmdOptions) || '" ' ||hc!CmdLine
when ThisCmd='LIST' then
do
RecordSwitch='N'
ListFile=FileQueryExists(ThisCmdOptions)
if ListFile='' then
CryAndDie('The list file "' || ThisCmdOptions || '" does not exist')
call DBG 'Processing: "' || ListFile || '"'
call DBGIND 1
call FileClose ListFile, 'N'
LCmt=';' || ';'
LineNum=0
SpecList=''
do while lines(ListFile)<>0
OneSpec=linein(ListFile)
OneSpec=ReplaceEnv(OneSpec)
if ExtraWhiteSpace=='' then
OneSpec=strip(OneSpec)
else
OneSpec=strip(translate(OneSpec, '', ExtraWhiteSpace, ' '))
CmtPos=lastpos(LCmt,OneSpec)
LineNum=LineNum+1
if CmtPos<>0 then
OneSpec=strip(left(OneSpec,CmtPos-1), 'T')
if OneSpec='' | left(OneSpec, 1) = ';' then
iterate
OneSpec=ReplaceString(OneSpec, ' ', '{' || 'x20}')
call DBG 'Line #' || LineNum || ': ' ||OneSpec
SpecList=SpecList|| ' ' ||OneSpec
end
call DBGIND-1
hc!CmdLine=strip(SpecList)|| ' ' ||hc!CmdLine
call FileClose ListFile
end
when ThisCmd='DEPENDSONWARNINGS' then
OptionNoDepFileOnWarnings=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='@EXTN' then
OptionPrjExtn=ThisCmdOptions
when ThisCmd='CONSOLEFILE' then
call UserIsSpecifyingConsoleFileName ThisCmdOptions
when ThisCmd='ERRORFILE' then
call UserIsSpecifyingErrorFileName ThisCmdOptions
when ThisCmd='DEBUGCOLS' then
do
TheValue=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
OptValid='N'
if datatype(TheValue, 'W')=1 then
do
if TheValue>=0 then
OptValid='Y'
end
if OptValid='N' then
UserSyntaxError('Invalid /DebugCols value of "' || TheValue || '" supplied!')
OptionMaxCol=TheValue
end
when ThisCmd='DROPFILES' then
do
call DBG 'Dropping all stored input file masks'
InputMaskCount=0
call SwitchMustNotHaveOptions ThisCmd,ThisCmdOptions
end
when ThisCmd='ONOK' then
PpwOnOK=ThisCmdOptions
when ThisCmd='ONERROR' then
do
PpwOnERROR=ThisCmdOptions
if SleepSwitch='N' then
OnExitSleepForError=0
end
when ThisCmd='HIDECMD' then
do
if translate(ThisCmdOptions)='HTML[]' then
ThisCmdOptions='<!--[{?}]-->'
parse var ThisCmdOptions OptionHideCmdS '{?}' OptionHideCmdE
OptionHideCmdS_L=length(OptionHideCmdS)
OptionHideCmdE_L=length(OptionHideCmdE)
if OptionHideCmdS_L=0|OptionHideCmdE_L=0 then
CryAndDie('Your hide template must include "{?}" to indicate where the', 'command would be and must not start or end the template')
end
when ThisCmd='EXEC' then
do
call SplitOffRcTest
call RunExecOrValidateCmd ThisCmd,ExecRcTest,ExecCmd
end
when ThisCmd='VALIDATE' then
do
call SplitOffRcTest
OptionValidationRc=ExecRcTest
OptionValidation=ExecCmd
end
when ThisCmd='SLEEP' then
do
SleepSwitch='Y'
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
parse var ThisCmdOptions OnExitSleepForOK ',' OnExitSleepForError
if OnExitSleepForError='' then
OnExitSleepForError=2
end
when ThisCmd='DELETEONERROR' then
OptionDeleteOnError=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='BUILDTITLE' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
parse var ThisCmdOptions '/' hc!M '/' hc!T
call BuildTitle hc!M,hc!T
end
when ThisCmd='READING' then
OptionMsgReading=ThisCmdOptions
when ThisCmd='MAKING' then
OptionMsgMaking=ThisCmdOptions
when ThisCmd='FORCEREBUILD' then
do
OptionForceRebuild=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
IsDepSwitch='N'
end
when ThisCmd='FILESR' then
OptionFileSR=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
when ThisCmd='1' then
do
call DBG 'Rest of command line is one parameter, quoting => ' ||hc!CmdLine
hc!CmdLine='"' || hc!CmdLine || '"'
end
when ThisCmd='CONSOLE' then
call ConsoleWriteAllowed SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='?' then
UserSyntaxError('?')
otherwise
UserSyntaxError('Unknown switch of "' || OptChar || ThisCmd || '" specified')
end
call DBGIND-1
if RecordSwitch='Y' then
call AddToSwitchList IsDepSwitch
end
call DBGIND-3
return

UserSyntaxError:
call AllFollowingOutputGoesToErrorFile
call CgiStartFatalError
call DisplayCopyright
if arg(1)='?' then
Title='SYNTAX'
else
do
call ColorSet 'ERROR'
call Line1 "SYNTAX ERROR"
call Line1 "~~~~~~~~~~~~"
call Line1 '    ' ||arg(1)
Title='CORRECT SYNTAX'
end
call CgiEndFatalError
call Line1 ''
call Line1 Title
call Line1 copies('~',length(Title))
call Line1 '    ' || WizName || ' [-Switch1] [[+]InputMask1] [/Switch2] [@Project] ...'
call Line1 ''
call Line1 'SOME COMMON SWITCHES'
call Line1 '~~~~~~~~~~~~~~~~~~~~'
call Line1 '-Copy  -Html  -Other  -Rexx  (processing modes)'
call Line1 '-Output:?out\*.html  -DependsOn:-?out\*.*.dep  /DependsOnComplete:y|n'
call Line1 '/DeletePrev:y|n  '  || '/DeleteOnError:y|n  /ConsoleFile:file  /ErrorFile:file'
call Line1 '/Define:Macro=Value  '  || '/#Include:file  /Template:file  /Exclude:*.TMP'
call Line1 '/HideCmd:HowSpec (hide PPWIZARD stuff from GUI editors etc)'
call Line1 '/CrLf:y|n  /Color:y|n  /List:file (command line)'
call Line1 '/Debug  /DebugCols:MaxCols'
call Line1 ''
call Line1 'Note that switches can start with "-" or "/", in the above I used "-" to mark'
call Line1 'switches which affect the following input masks and so are more position'
call Line1 'sensitive than most other switches (which generally work more globally).'
call Line1 ''
call Line1 "For more details (and more switches) please see PPWIZARD's documentation at:"
call Line1 '    http://dennisbareis.com/ppwizard.htm'
call AddColorDelayWorkaroundForTee
call ColorSet
call Beeps 2
if arg(1)<> '?' then
AbnormalExit(MyLineNumber(), "Invalid Command Line - " ||arg(1))
else
do
parse version ThisRexxVer
call Line1 ''
call Line1 'ENVIRONMENTAL INFORMATION'
call Line1 '~~~~~~~~~~~~~~~~~~~~~~~~~'
call Line1 'Rexx Version  : ' ||ThisRexxVer
call Line1 'Operating Syst: ' ||DebugGetOpSysText()
call Line1 'PPWIZARD      : ' ||PgmVersion
call Line1 '              : "' || PpWizardPgmName || '"'
AbnormalExit(MyLineNumber(), "User just wanted version number information")
end

SwitchMustHaveOptions:
parse arg TheCmd,TheOptions
if TheOptions='' then
UserSyntaxError('You must supply parameters on the "' || OptChar || TheCmd || '" switch!')
return(TheOptions)

SwitchMustNotHaveOptions:
parse arg TheCmd,TheOptions,Value2Set
if TheOptions<> '' then
UserSyntaxError('No parameters are expected for the "' || OptChar || TheCmd || '" switch!')
return(Value2Set)

SwitchOptionsValidateAgainstList:
TheCmd=arg(1)
TheOption=translate(arg(2))
ValidList=',' || translate(arg(3)) || ','
if pos(',' || TheOption || ',',ValidList)<>0 then
return(TheOption)
UserSyntaxError('An invalid parameter of "' || TheOption || '" was specified on the "' || OptChar || TheCmd || '" switch!')

SwitchWantsYesOrNo:
TheCmd=arg(1)
TheOption=translate(arg(2))
Default=arg(3)
if TheOption='' then
return(Default)
else
return(left(SwitchOptionsValidateAgainstList(TheCmd,TheOption, "Y,N,YES,NO"),1))

NotAvailableUnderNtYet:
TheCmd=arg(1)
if RexWhich='REGINA' then
UserSyntaxError('"' || OptChar || TheCmd || '" can not be performed under Windows (or regina).... Yet...')
return

FindProjectFile:
ic!PrjFile=arg(1)
if pos('.',ic!PrjFile)=0 then
ic!PrjFile=ic!PrjFile|| '.ppw'
if OptionDebugOn='Y' then
do
call DBGIND 1
call DBG 'Looking for the project file "' || ic!PrjFile || '"'
call DBGIND 1
end
ic!Full=FindFile(ic!PrjFile)
if OptionDebugOn='Y' then
do
call DBGIND 1
if ic!Full='' then
call DBG 'Project file not found.'
else
call DBG 'Found project file "' || ic!Full || '"'
call DBGIND-3
end
return(ic!Full)

SplitOffRcTest:
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
if left(ThisCmdOptions,1)='{' then
parse var ThisCmdOptions '{' ExecRcTest '}' ExecCmd
else
do
ExecCmd=ThisCmdOptions
ExecRcTest=''
end
return

RunExecOrValidateCmd:
parse arg jc!Switch,jc!CmdRc,jc!Cmd
if OptionDebugOn='Y' then
call DBG 'Performing ' || OptChar || jc!Switch || ' command'
jc!Exec=ReplaceString(jc!Cmd, "{?}",CurrentOutFile)
if left(jc!Exec,1)<> '!' then
jc!Redirect='Y'
else
do
jc!Redirect='N'
jc!Exec=substr(jc!Exec,2)
end
if jc!Redirect='N' then
do
call AddressCmd jc!Exec
CmdRc=Rc
end
else
do
TmpFile=RexGetTmpFileName('Ec??????.PPW')
call AddressCmd jc!Exec||RedirectStdOutAndErr2(TmpFile),TmpFile
CmdRc=Rc
call _SysFileDelete TmpFile
end
if jc!CmdRc<> '' then
do
call DBGIND 1
jc!ExecOk=0
jc!ExecThis='jc!ExecOk = ' || '(' || jc!CmdRc || ')'
if ProcessedCmdLine='Y' then
call ExecRexxCmd jc!ExecThis
else
do
call DBG 'Interpreting: ' ||jc!ExecThis
interpret jc!ExecThis
end
call DBGIND-1
if\jc!ExecOk then
CryAndDie('User command failed (CmdRc was ' || CmdRc || '):', '     ' || jc!Exec, 'Test was:', '     ' ||jc!CmdRc)
end
return

MakeAbsolute:
kc!Path=arg(1)
if left(kc!Path,1)<> '+' then
kc!Plus=''
else
do
kc!Path=substr(kc!Path,2)
kc!Plus='+'
end
kc!File=kc!Path
if left(kc!File,1)='.' |pos(RexDirChar,kc!File)=0 then
do
DotSlash='.' ||RexDirChar
DotDotSlash='.' ||DotSlash
maDir=GetCurrentDirectory()
if OptionDebugOn='Y' then
do
call DBG 'Converting relative "' || kc!File || '"'
call DBGIND 1
end
if pos(RexDirChar,kc!File)<>0 then
do
do forever
select
when left(kc!File,2)==DotSlash then
do
kc!File=substr(kc!File,3)
end
when left(kc!File,3)==DotDotSlash then
do
LastChar=right(maDir,1)
SlashPos=lastpos(RexDirChar,maDir)
if SlashPos=0|LastChar=RexDirChar|LastChar=':' then
CryAndDie('The spec "' || kc!Path || '" can not be converted to absolute', 'from the current directory "' || GetCurrentDirectory() || '"')
maDir=left(maDir,SlashPos-1)
kc!File=substr(kc!File,4)
end
otherwise
leave
end
end
end
if right(maDir,1)=RexDirChar then
kc!File=maDir||kc!File
else
kc!File=maDir||RexDirChar||kc!File
if OptionDebugOn='Y' then
do
call DBG 'To Absolute "' || kc!File || '"'
call DBGIND-1
end
end
return(kc!Plus||kc!File)

ValidateBaseDirUse:
parse arg lc!BD,lc!FM,lc!MayHavePlus
call DBG 'Validating base directory "' || lc!BD || '" against "' || lc!FM || '"'
if lc!MayHavePlus='Y' then
do
if left(lc!FM,1)='+' then
lc!FM=substr(lc!FM,2)
end
if right(lc!BD,1)<>RexDirChar then
CryAndDie('The base directory "' || lc!Bd || '" does not end with a "' || RexDirChar || '"!')
if RexSystemOpSys="UNIX" then
do
lc!BdU=lc!BD
lc!FmU=lc!FM
end
else
do
lc!BdU=translate(lc!BD)
lc!FmU=translate(lc!FM)
end
if lc!BdU\==left(lc!FmU,length(lc!BdU))then
CryAndDie('The file mask       "' || lc!FmU ||  '"', 'does not begin with "' || lc!BdU || '"')
return

ValidatePMode:
mc!PM=translate(arg(1))
if pos('|' || mc!PM || '|', '|HTML|REXX|POWERSHELL|OTHER|COPY|')=0 then
CryAndDie('Invalid processing mode of "' || mc!PM || '"')
return(mc!PM)

PModeSwitch:
parse arg nc!PM,nc!Prm
call SwitchMustNotHaveOptions nc!PM,nc!Prm
ProcessingMode=ValidatePMode(translate(nc!PM))
if OptionCloneUsed='Y' then
do
if ProcessingMode<> 'COPY' then
UserSyntaxError('Invalid mode of ' ||ProcessingMode)
end
return

BuildTitle:
parse arg oc!M,oc!T
if oc!T='?' then
do
if translate(oc!M)='COPY' then
oc!T='Copying: "{IS}" -> "{OL}"'
else
oc!T='Making ({PM}) - {OL}'
end
call value 'PPWBLDTITLE_' ||oc!M,oc!T
call DBG '/Making Text for ' || oc!M || ' mode is: ' ||oc!T
return

CmdLine_33:
DependsOnFmtVer="FORMAT 00.157"
call ClearCollectedDependancyInfo
call ClearDependancyTimeStampCache
signal DEPENDON_34

NeedToRemake:
DepFile4=arg(1)
if OptionDependsOn='' then
do
call DBG 'No dependancy checking enabled - Need to make'
DepFileName=''
return("Y")
end
DepFileName=GenerateFileName(DepFile4,OptionDependsOn)
if _NeedToRemakeCheckDependencies()='N' then
do
call _FlushDependancyCheckingProgress 'N'
if OptionQuietDependsOn='N' then
call Line1 ''
return('N')
end
call _FlushDependancyCheckingProgress 'Y'
if DependsOnCheckOnly='N' then
do
if DepDelPrev='Y' then
do
call DBG 'Delete all output dependancy files (made last build)'
call DBGIND 1
call FileOpenReadOnly DepFileName
do while lines(DepFileName)<>0
pc!Line=linein(DepFileName)
if pc!Line='' then
iterate
parse var pc!Line pc!Type pc!Line
if pc!Type='output' then
do
pc!LastTime=GetQuotedText(pc!Line, "pc!Line")
call MustDeleteFile pc!LastTime
end
end
call FileClose DepFileName
call DBGIND-1
end
call MustDeleteFile DepFileName
end
return('Y')

ClearCollectedDependancyInfo:
DepTmp.0=0
DepIn.0=0
DepOut.0=0
return

ClearDependancyTimeStampCache:
TimeStampCount=0
return

GetFileDateTimeButDontWarnOnError:
tsFile=arg(1)
if FileQueryExists(tsFile)=='' then
Ts=-1
else
Ts=GetFileTimeStamp(tsFile)
return(Ts)

_FlushDependancyCheckingProgress:
if pc!ProgressCnt=0 then
return
if arg(1)='N' then
do
do pc!I=1 to pc!ProgressCnt
call DBG pc!Progress.pc!I
end
end
else
do
TitleText='We do need to remake "' || _filespec('name', CurrentOutFile) || '"'
call ColorSet 'TITLE'
call Line1 ''
call Line1 TitleText
call Line1 copies('~',length(TitleText))
call ColorSet
if pc!ProgressCnt<15 then
do
do pc!I=1 to pc!ProgressCnt
call Line1 '  >> ' ||pc!Progress.pc!I
end
end
else
do
do pc!I=1 to 7
call Line1 '  >> ' ||pc!Progress.pc!I
end
call Line1 '  ...'
do pc!I=pc!ProgressCnt-7 to pc!ProgressCnt
call Line1 '  >> ' ||pc!Progress.pc!I
end
end
call Line1 ''
end
return

_ShowDependancyCheckingProgress:
if OptionQuietDependsOn='Y' then
call DBG arg(1)
else
do
if OptionQuietDependsOn='N' then
call Line1 '  ?> ' ||arg(1)
else
do
pc!ProgressCnt=pc!ProgressCnt+1
pc!Progress.pc!ProgressCnt=arg(1)
end
end
return

_NeedToRemakeCheckDependencies:
pc!ProgressCnt=0
TitleText='Checking Dependencies - "' || _filespec('name', CurrentOutFile) || '"'
if OptionQuietDependsOn<> 'N' then
call DBG TitleText
else
do
call ColorSet 'TITLE'
call Line1 TitleText
call Line1 copies('~',length(TitleText))
call ColorSet
end
if OptionForceRebuild='Y' then
do
call _ShowDependancyCheckingProgress 'The /ForceRebuild switch forces us to rebuild'
return('Y')
end
call _ShowDependancyCheckingProgress 'Checking: "' || DepFileName || '"'
if FileQueryExists(DepFileName)='' then
do
call _ShowDependancyCheckingProgress '  The dependency file does not exist.'
return('Y')
end
call FileClose DepFileName, 'N'
OpenRc=FileOpenReadOnly(DepFileName)
DependLine=linein(DepFileName)
if DependLine<>DependsOnFmtVer then
do
call _ShowDependancyCheckingProgress '  Dependency formatting is not at current level'
call FileClose DepFileName
return('Y')
end
ReMake='N'
DepLineNum=1
do while lines(DepFileName)<>0
DependLine=linein(DepFileName)
DepLineNum=DepLineNum+1
if DependLine='' then
iterate
if left(DependLine,1)=';' then
iterate
call DBG 'Line #' || DepLineNum || ': ' ||DependLine
call DBGIND 1
parse var DependLine DepType DependLine
WhatStamped=GetQuotedText(DependLine, "DependLine")
LineStamp=GetQuotedRest(DependLine)
call _ShowDependancyCheckingProgress 'Checking: "' || WhatStamped || '"'
if DependsOnCheckOnly='Y' & translate(WhatStamped) = "*CMDLINE" then
do
call _ShowDependancyCheckingProgress "Not validating the command line in check only mode...."
end
else
do
DependantTime=GetDependsStamp("WhatStamped")
if DependantTime=-1&DependantTime<>LineStamp then
do
call _ShowDependancyCheckingProgress "Can't locate the dependant file (" || DepType || ")!"
ReMake='Y'
call DBGIND-1
leave
end
if DependantTime<>LineStamp then
do
call _ShowDependancyCheckingProgress "  The " || DepType || " dependancy stamp differs from last make."
WhatStamped=""
call _ShowDependancyCheckingProgress "      PREVIOUS: " ||strip(left(LineStamp,60))
call _ShowDependancyCheckingProgress "           NOW: " ||strip(left(DependantTime,60))
ReMake='Y'
if DaylightSavings='Y' then
do
if length(DependantTime)=14&length(LineStamp)=14&datatype(DependantTime, 'W') = 1 & datatype(LineStamp, 'W')=1 then
do
pc!MinSec1=right(DependantTime,4)
pc!MinSec2=right(LineStamp,4)
if pc!MinSec1==pc!MinSec2 then
do
pc!Bd1=BaseDate(DependantTime)
pc!Bd2=BaseDate(LineStamp)
pc!Min=min(pc!Bd1,pc!Bd2)
pc!T1=(pc!Bd1-pc!Min)*24+substr(DependantTime,9,2)
pc!T2=(pc!Bd2-pc!Min)*24+substr(LineStamp,9,2)
if abs(pc!T1-pc!T2)==1 then
do
call _ShowDependancyCheckingProgress "             * Ignoring difference (out by EXACTLY one hour)."
ReMake='N'
end
end
end
end
if ReMake='Y' then
do
call DBGIND-1
leave
end
end
end
call DBGIND-1
end
call FileClose DepFileName
if ReMake='N' then
call _ShowDependancyCheckingProgress 'No need to remake...'
else
call _ShowDependancyCheckingProgress 'We do need to remake...'
return(ReMake)

IsTempFile:
qc!File=UFILE(arg(1))
do qc!I=1 to DepTmp.0
if qc!File=DepTmp.qc!I then
return(qc!I)
end
return(0)

AddTempFileToDependancyList:call TRACE "OFF"
parse arg rc!Tf
rc!Tf=UFile(rc!Tf)
call DBG 'AddTempFileToDependancyList(' || rc!Tf || ')'
if IsTempFile(rc!Tf)<>0 then
return('N')
DepTmp.0=DepTmp.0+1
rc!I=DepTmp.0
DepTmp.rc!I=rc!Tf
DepTmpUsed.rc!I=""
return('Y')

AddInputFileToDependancyList:call TRACE "OFF"
parse arg sc!IFile,sc!OkIfMissing,sc!TS
sc!IFileU=UFile(sc!IFile)
if sc!TS='' then
sc!TS=GetDependsStamp("sc!IFile")
call DBG 'AddInputFileToDependancyList(' || sc!IFile || '): ' ||sc!Ts
if sc!Ts=-1&left(sc!IFile,1)<> '*' then
do
if sc!OkIfMissing<> 'Y' then
CryAndDie('AddInputFileToDependancyList() was passed a non existant file of "' || sc!IFile || '" (and you did not indicate this was OK)...')
end
do sc!I=1 to DepIn.0
if sc!IFileU=UFILE(DepIn.sc!I)then
return('N')
end
DepIn.0=DepIn.0+1
sc!I=DepIn.0
DepIn.sc!I=sc!IFile
DepInTs.sc!I=sc!TS
return('Y')

AddOutputFileToDependancyList:call TRACE "OFF"
tc!OFile=arg(1)
tc!OFile=UFile(tc!OFile)
call DBG 'AddOutputFileToDependancyList(' || tc!OFile || ')'
do tc!I=1 to DepOut.0
if tc!OFile=DepOut.tc!I then
return('N')
end
DepOut.0=DepOut.0+1
tc!I=DepOut.0
DepOut.tc!I=tc!OFile
return('Y')

DeletingOnError:
if symbol('DepOut.0') <> 'VAR' then
return
if OptionDeleteOnError='N' then
return
call DBG 'Deleting any files we created for this build'
call DBGIND 1
do uc!I=1 to DepOut.0
uc!File=DepOut.uc!I
call _FileClose uc!File
if FileQueryExists(uc!File)<> "" then
do
DeleteRc=_SysFileDelete(uc!File)
if FileQueryExists(uc!File)<> "" then
call DBG 'Could not delete "' || uc!File || '"'
end
end
call DBGIND-1
return

_OutputDepWhatToFile:
DepWhat=arg(1)
DepWhatQ=QuoteIt(DepWhat)
DepWhat=DepWhatQ||DepWhat||DepWhatQ
return(DepWhat)

CreateDependancyFileFromLists:
if DepFileName='' then
return
call DBG 'Making the dependancy file (' || DepFileName || ')'
call DBGIND 1
vc!TI=0
do vc!FI=1 to DepIn.0
vc!F=DepIn.vc!FI
vc!Fs=DepInTs.vc!FI
vc!TmpIndex=IsTempFile(vc!F)
if vc!TmpIndex<>0 then
do
vc!List=DepTmpUsed.vc!TmpIndex
if vc!List<> "" then vc!List = vc!List || ' '
vc!List=vc!List|| ' INPUT(' || vc!F || ')'
DepTmpUsed.vc!TmpIndex=vc!List
end
else
do
vc!Ti=vc!Ti+1
DepIn.vc!TI=vc!F
DepInTs.vc!TI=vc!Fs
end
end
DepIn.0=vc!TI
vc!TI=0
do vc!FI=1 to DepOut.0
vc!F=DepOut.vc!FI
vc!TmpIndex=IsTempFile(vc!F)
if vc!TmpIndex<>0 then
do
vc!List=DepTmpUsed.vc!TmpIndex
if vc!List<> "" then vc!List = vc!List || ' '
vc!List=vc!List|| ' OUTPUT(' || vc!F || ')'
DepTmpUsed.vc!TmpIndex=vc!List
end
else
do
vc!Ti=vc!Ti+1
DepOut.vc!TI=vc!F
end
end
DepOut.0=vc!TI
DepDrop=''
DepHook=CfgMacro("HOOK_DEPENDSON", '')
if DepHook<> '' then
do
call ExecRexxCmd DepHook
end
if DepDrop<> '' then
call DBG "User hook said don't create dependancy file : " ||DepDrop
else
do
call MakeDirectoryTree _filespec('drive', DepFileName) || _filespec('path',DepFileName)
call ClearDependancyTimeStampCache
call FileLineOut DepFileName,DependsOnFmtVer
call FileLineOut DepFileName, ''
DepWhatPad=0
call FileLineOut DepFileName, ';#########################[ OUTPUT ]#########################'
do vc!I=1 to DepOut.0
if DepOut.vc!I<> '' then
do
call DBG 'Add OUTPUT dependancy : ' ||DepOut.vc!I
OutputFileTs=GetFileDateTimeButDontWarnOnError(DepOut.vc!I)
call FileLineOut DepFileName, 'output   ' || _OutputDepWhatToFile(DepOut.vc!I) || '   ~' || OutputFileTs || '~'
end
end
if DepOut.0=0 then call FileLineOut DepFileName, ';NONE'
call FileLineOut DepFileName, ''
call FileLineOut DepFileName, ''
call FileLineOut DepFileName, ';#########################[ INPUT ]#########################'
do vc!I=1 to DepIn.0
if DepIn.vc!I<> '' then
do
call DBG 'Add INPUT  dependancy : ' ||DepIn.vc!I
call FileLineOut DepFileName, 'input    ' || _OutputDepWhatToFile(DepIn.vc!I) || '   ~' || DepInTs.vc!I || '~'
end
end
if DepIn.0=0 then call FileLineOut DepFileName, ';NONE'
call FileLineOut DepFileName, ''
call FileLineOut DepFileName, ''
call FileLineOut DepFileName, ';#########################[ TEMP FILES ]#########################'
do vc!I=1 to DepTmp.0
vc!List=DepTmpUsed.vc!I
if vc!List="" then vc!List = "NOTHING"
vc!TmpLine=";TEMP=(" || DepTmp.vc!I || ') REMOVED: ' ||vc!List
call FileLineOut DepFileName,vc!TmpLine
end
if DepTmp.0=0 then call FileLineOut DepFileName, ';NONE'
call FileClose DepFileName
end
call DBGIND-1
return

ProcessDependsOn:
Rest=PerformReplacementsInCmdsParameters(arg(1))
DepType=translate(GetQuotedText(Rest, "DependsOnList"))
if DependsOnList='' then
CryAndDie('No files supplied on "#DependsOn ' || DepType || '" command!')
do while DependsOnList<> ''
ThisOne=GetQuotedText(DependsOnList, "DependsOnList")
select
when DepType='OUTPUT' then
Added=AddOutputFileToDependancyList(ThisOne)
when DepType='INPUT' then
Added=AddInputFileToDependancyList(ThisOne)
when DepType='TEMP' then
Added=AddTempFileToDependancyList(ThisOne)
otherwise
CryAndDie('Unknown dependancy type of "' || DepType || '"!')
end
if Added='Y' then
call DBG DepType|| ' dependancy : ' ||ThisOne
end
return(0)

GetDependancyInfo:call TRACE "OFF"
parse arg wc!Type,wc!Which
wc!Type=translate(wc!Type)
if wc!Which='' then
do
select
when wc!Type='INPUT' then
return(DepIn.0)
when wc!Type='OUTPUT' then
return(DepOut.0)
otherwise
_GetDependancyInfoErr(wc!Type)
end
end
else
do
select
when wc!Type='INPUT' then
return(DepIn.wc!Which)
when wc!Type='INPUTSTAMP' then
return(DepInTS.wc!Which)
when wc!Type='OUTPUT' then
return(DepOut.wc!Which)
otherwise
_GetDependancyInfoErr(wc!Type)
end
end

_GetDependancyInfoErr:
CryAndDie('Invalid dependancy query type of "' || arg(1) || '"')

GetDependsStamp:
xc!4WhatVar=arg(1)
xc!4What=value(xc!4WhatVar)
if left(xc!4What,1)<> '*' then
do
xc!Ret=GetFileDateTimeButDontWarnOnError(xc!4What)
end
else
do
Stamp4U=translate(xc!4What)
select
when abbrev(Stamp4U, "*TODAY")then
do
xc!Ret=date('S')
end
when Stamp4U="*CMDLINE" then
do
xc!Ret=PpwClDep
end
when Stamp4U="*PPWPGM" then
do
xc!Ret=PgmVersion||' '||FileQuerySize(PpWizardPgmName)||' '||GetFileDateTimeButDontWarnOnError(PpWizardPgmName)
end
when abbrev(Stamp4U, "*REXX=")then
do
xc!RexxExp=substr(xc!4What,7)
if pos('DEPVALUE',translate(xc!RexxExp))=0 then
xc!RexxExp='DepValue = ' ||xc!RexxExp
DepValue=time('L')
call ExecRexxCmd xc!RexxExp
xc!Ret=DepValue
end
when abbrev(Stamp4U, "*EXPIRES=")then
do
xc!ExpWhen=translate(substr(xc!4What,10))
parse var xc!ExpWhen xc!ExpCmd ';' xc!ExpTs
if xc!ExpWhen='NOW' then
xc!ExpWhen=0
xc!CurrTs=TimeSTamp()
if xc!ExpTs='' then
do
xc!ExpTs=TimeSTamp(xc!ExpWhen)
xc!4What=xc!4What|| ';' ||xc!ExpTs
call value xc!4WhatVar,xc!4What
end
if xc!CurrTs<=xc!ExpTs then
xc!Ret='Tick Tock...'
else
xc!Ret='Expired!'
end
when abbrev(Stamp4U, "*EXEC=")then
do
TheCmd=substr(xc!4What,7)
TmpFile=RexGetTmpFileName("DEPON???.???")
call AddressCmd TheCmd||RedirectStdOutAndErr2(TmpFile),TmpFile
ExecRc=Rc
call DBG 'Depend value is result of (Rc=' || ExecRc || '): ' ||TheCmd
call FileClose TmpFile, 'N'
TheCmdVal=charin(TmpFile,,999999)
call FileClose TmpFile
call _SysFileDelete TmpFile
TheCmdVal=translate(TheCmdVal,, '0D0A1A'x, ' ')
TheCmdVal='RC=' || ExecRc || '->' ||TheCmdVal
xc!Ret=TheCmdVal
end
when abbrev(Stamp4U, "*FILES=")then
do
TheMask=substr(xc!4What,8)
if left(TheMask,1)<> '+' then
xc!Sub='N'
else
do
xc!Sub='Y'
TheMask=substr(TheMask,2)
end
call Files4Mask TheMask, 'DepDirList',xc!Sub
xc!Ret=DepDirList.0|| ' files'
do DepIndex=1 to DepDirList.0
xc!F=DepDirList.DepIndex
call AddTempFileToDependancyList xc!F
xc!Ret=xc!Ret|| '; ' || xc!F || '=' || GetFileDateTimeButDontWarnOnError(xc!F) || ',' ||FileQuerySize(xc!F)
end
end
otherwise
CryAndDie('An incorrectly formatted "special" input dependancy was specified', 'You used "' || xc!4What || '"')
end
end
xc!Mx=20000
xc!L=length(xc!Ret)
if xc!L>xc!Mx then
do
call DBG 'Original STAMP: ' ||xc!Ret
call DBG 'Stamp is ' || xc!L || ' bytes long, as this is greater than ' || xc!Mx || ' we will convert to a CRC!'
xc!C=Crc32PrePostConditioning()
xc!C=UpdateCrc32(xc!C,xc!Ret)
xc!C=Crc32PrePostConditioning(xc!C)
xc!Ret='CRC32 ' || Crc32InDisplayableForm(xc!C) || ', length ' ||AddCommasToDecimalNumber(xc!L)
end
call DBG 'Stamp: ' ||xc!Ret
return(xc!Ret)

DEPENDON_34:
DoingImport=''
signal IMPORT_35

ProcessImport:
if DoingImport<> '' then
CryAndDie("Can't nest #import (started at " || DoingImport || ')')
else
DoingImport=CurrentSourceLocation()
ImportParms=PerformReplacementsInCmdsParameters(arg(1))
if AsIsModeOn='Y' then
CryAndDie("Please turn off #AsIs mode before importing.")
call _InitImportAsIsMemories
ImportFileName=GetQuotedText(ImportParms, "ImportParms")
if ImportParms='' then
CryAndDie('#import is missing import type (parm #2)!')
ImportFileType=translate(GetQuotedText(ImportParms, "ImportParms"))
if substr(ImportFileType,4)<> '-' then
DropLine=0
else
do
ImportFileType=left(ImportFileType,3)
DropLine=1
end
FirstChar=left(ImportFileType,1)
DelimiterSpec=FirstChar||FirstChar||FirstChar
CustomDelimiter='NO'
if(ImportFileType==DelimiterSpec)|(ImportFileType==DelimiterSpec|| '-')then
do
CustomDelimiter=FirstChar
TmpFilePart=''
end
else
do
TmpFilePart=ImportFileType
if pos('*' || ImportFileType || '*', '*TAB*CMA*FIX*SQL*WRAP*T2H*ML*')=0 then
CryAndDie('Invalid #import type of "' || ImportFileType || '" specified!')
end
if ImportFileType<> 'SQL' then
do
if ImportFileName='' then
CryAndDie('#import has no parameters!')
call FileClose ImportFileName, 'N'
FullImportName=FindFile(ImportFileName, "import")
if FullImportName='' then
CryAndDie('The #import file "' || ImportFileName || '" does not exist!')
call ReadingI FullImportName, 'N'
call AddInputFileToDependancyList FullImportName
end
ToInclude=RexGetTmpFileName('I_' || left(TmpFilePart, 4, '_') || '??.???')
call MustDeleteFile ToInclude
if ImportParms='' then
MacroName=''
else
MacroName=GetQuotedText(ImportParms, "ImportParms")
if MacroName='' then
do
select
when ImportFileType='WRAP' then
MacroName='WRAP'
when ImportFileType='T2H' then
MacroName='T2H'
when ImportFileType='ML' then
MacroName='ML'
otherwise
MacroName='IMPORT'
end
end
call DBG_IMPORT '#import options start with "' || MacroName || '_"'
call AsIsPrepare ''
call DBG_IMPORT 'Generating "' || ToInclude || '" for later inclusion (#include).'
ReplaceNewLineChar=''
ReplaceTabChar=''
DisplayingFields=''
ReplaceNewLineChar=''
ReplaceTabChar=''
Imp2Data=''
Imp2DataCnt=0
DoPass2=translate(GetImportValue('DO_PASS_2', 'Y'))
select
when ImportFileType='WRAP' then
ImpLinCnt=HandleLineWrapping()
when ImportFileType='T2H' then
ImpLinCnt=HandleTextToHtmlImport()
otherwise
do
select
when CustomDelimiter<> 'NO' then
xc!Dfc=CustomDelimiter
when ImportFileType='TAB' then
xc!Dfc=TabChar
when ImportFileType='CMA' then
xc!Dfc=','
otherwise
xc!Dfc=''
end
call ImportTablePreparationPass1
if ImportParms='' then
do
if xc!Dfc\=='' then
do
ImportInlineCmtChars=d2c(0)|| 'NeverMatch'
ImportParms=ExtractFieldInfoFromSimpleCharDelimitedFile(xc!Dfc)
end
end
if ImportFileType='FIX' then
DefStripType='T'
else
DefStripType=''
call ImportTablePreparationPass2
select
when xc!Dfc\=='' then
ImpLinCnt=HandleSimpleCharDelimitedFile(xc!Dfc)
when ImportFileType='FIX' then
ImpLinCnt=HandleFixedFieldFile()
when ImportFileType='SQL' then
ImpLinCnt=HandleSQLDataBase()
when ImportFileType='ML' then
ImpLinCnt=HandleMultiLineImport()
otherwise
CryAndDie('Unknown import type of "' || ImportFileType || '"')
end
call ImportTableTermination
end
end
if ImportFileType<> 'SQL' then
call FileClose FullImportName
if OptionDebugOn='Y' then
do
call DBG_IMPORT 'Imported ' || AddCommasToDecimalNumber(ImpLinCnt) || ' line(s) in "' || ImportFileType || '" mode.'
if Imp2Data<> '' then
call DBG_IMPORT 'Imported into #data "' || Imp2Data || '"'
end
if Imp2Data='' then
do
call FileClose ToInclude
end
call AsIsPrepare ''
if Imp2Data='' then
do
if DoPass2='N' then
call DBG_IMPORT 'You have disabled PASS2 processing'
else
do
call DBG_IMPORT 'Now #include the generated temporary file ("' || ToInclude || '").'
call RecursiveIncludeSave
call ProcessInputFile ToInclude, 'N', 'N'
call RecursiveIncludeRestore
call ReadingI
end
if GetImportValue('KEEP_TMP_FILE',  OptionDebugOn) = 'N' then
DeleteRc=_SysFileDelete(ToInclude)
end
DoingImport=''
return(0)

_ImportValueSpacer:
if OptionDebugOn='Y' then
do
call DBG_MACROVALORDEF ''
if arg(1)<> '' then
call DBG_MACROVALORDEF arg(1)
end
return

ImportValueExists:
yc!Cm=MacroName|| '_' ||arg(1)
yc!Yn=MacroExists(yc!Cm)
if OptionDebugOn='Y' then
call DBG_MACROVALORDEF 'Option(Macro) "' || yc!Cm || '" Exists? : ' ||yc!Yn
return(yc!Yn)

GetImportValue:
zc!V=CfgMacro(MacroName|| '_' ||arg(1),arg(2))
if ImportFileType<> "WRAP" & ImportFileType <> "T2H" then
zc!V=ReplaceString(zc!V,StartsMacroParm|| 'Columns' ||EndsMacroParm,DisplayingFields)
return(zc!V)

GetImportValue_Tabs:
ReplaceTabChar=GetImportValue('TAB_CHAR', '')
return

GetImportValue_RecordFilter:
return(PerformReplacementsInCmdsParameters(GetImportValue('RECORD_FILTER', '')))

GetImportValue_LineFilter:
LineFilter=PerformReplacementsInCmdsParameters(GetImportValue('LINE_FILTER', ''))
return

GetImportValue_Comments:
call _ImportValueSpacer 'Get comment options'
call DBGIND 1
ImportLineCmtChars=GetImportValue( 'LINECMT_CHARS',arg(1))
ImportInlineCmtChars=GetImportValue('INLINECMT_CHARS',arg(2))
call DBGIND-1
return

IsCmtLine:
if ImportLineCmtChars='' then
return(0)
else
return(abbrev(arg(1),ImportLineCmtChars))

ImportOneLine:
FileLine=linein(FullImportName)
if ExtraWhiteSpace\=='' then
FileLine=translate(FileLine, '', ExtraWhiteSpace, ' ')
if LineFilter<> '' then
do
call DBG_IMPORT 'Calling specified line filter'
call DBGIND 1
call ExecRexxCmd LineFilter
call DBGIND-1
end
if ImportInlineCmtChars<> '' then
do
ad!Pos=pos(ImportInlineCmtChars,FileLine)
if ad!Pos<>0 then
FileLine=strip(left(FileLine,ad!Pos-1), 'Trailing')
end
if arg(1)='Y' then
FileLine=AsIs(FileLine)
if ReplaceNewLineChar\=='' then
FileLine=ReplaceString(FileLine,MarksNewLine,ReplaceNewLineChar)
if ReplaceTabChar\=='' then
FileLine=ReplaceString(FileLine,TabChar,ReplaceTabChar)
return(FileLine)

GenerateTagsIfNonEmpty:
if Imp2Data='' then
do
OptionalTags=GetImportValue(arg(1),arg(2))
if OptionalTags\=='' then
call PpwLineout ToInclude,OptionalTags
end
return

GenerateProtectStartTags:
call GenerateTagsIfNonEmpty 'PROTECT_START', StartsStdSymbolReplacement || 'ProtectFromPpwStart' ||EndsMacroReplacement
return

GenerateProtectEndTags:
call GenerateTagsIfNonEmpty 'PROTECT_END',   StartsStdSymbolReplacement || 'ProtectFromPpwEnd' ||EndsMacroReplacement
return

GenerateBeforeTags:
call GenerateTagsIfNonEmpty 'BEFORE',arg(1)
return

GenerateAfterTags:
call GenerateTagsIfNonEmpty 'AFTER',arg(1)
return

HandleImportAsIsOptions:
call _ImportValueSpacer 'Prepare "AS IS" tagging'
call DBGIND 1
ImportAsIsMemory=GetImportValue('ASIS_TAGGING',arg(1))
call DBGIND 1
call AsIsPrepare ImportAsIsMemory
call DBGIND-2
return

_InitImportAsIsMemories:
if symbol('ImpMemInit') = 'VAR' then
return
ImpMemInit='Y'
call DBG_IMPORT 'Initializing named #AsIs tags for HTML Importing'
call DBGIND 1
call _ClearTempMemory
call _AddToTempMemory '&', '&amp;'
call _AddToTempMemory '<', '&lt;'
call _AddToTempMemory '>', '&gt;'
call SetupNamedAsIsStorage 'IMPORT_HTML_BASIC',TmpAtCount
call _ClearTempMemory
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '-'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '|'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '-'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '|'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call SetupNamedAsIsStorage 'IMPORT_HTML_BOXGRAPHIC_TO_BOXTEXT',TmpAtCount
call DBGIND-1
return

_ClearTempMemory:
TmpAtCount=0
return

_AddToTempMemory:
TmpAtCount=TmpAtCount+1
ImportB.TmpAtCount=arg(1)
ImportA.TmpAtCount=arg(2)
return

WriteLineToTmpImportFile:call TRACE "OFF"
call PpwLineout ToInclude,arg(1)
return

IMPORT_35:
signal IMPORTT_36

ImportTablePreparationPass1:
call _ImportValueSpacer 'Assorted options'
call DBGIND 1
DropBlankLines=translate(GetImportValue('DROP_BLANK_LINES',  'Y'))
DropLine=GetImportValue('DROP_LINE_COUNT',DropLine)
ReplaceNewLineChar=GetImportValue('NEWLINE_CHAR', '<br>')
call GetImportValue_Tabs
call GetImportValue_LineFilter
RecordFilter=GetImportValue_RecordFilter()
Imp2Data=GetImportValue('#DATA', '')
if Imp2Data<> '' then
call DataChkDef Imp2Data,1
call DBGIND-1
return

ImportTablePreparationPass2:
call DBG_IMPORT 'IMPORT PARMS: ' ||ImportParms
call DBGIND+1
if ImportParms='' then
CryAndDie('#import is missing field names (parm #4 onwards)!')
NumberOfFields=0
DisplayingFields=0
do while ImportParms<> ''
NumberOfFields=NumberOfFields+1
HeadingInfo=GetQuotedText(ImportParms, "ImportParms")
ColumnNumber=DisplayingFields+1
ExtraInfo=''
if left(HeadingInfo,1)<> '{' then
call DBG_IMPORT ' COL  #' || ColumnNumber ': ' ||HeadingInfo
else
do
ad!OrigColN=ColumnNumber
EndPosn=pos('}',HeadingInfo)
if EndPosn=2 then
HeadingInfo=substr(HeadingInfo,3)
else
do
if EndPosn=0 then
CryAndDie('Leading field codes on heading "' || HeadingInfo || '" invalid (expected "}")')
ExtraInfo=substr(HeadingInfo,2,EndPosn-2)
HeadingInfo=substr(HeadingInfo,EndPosn+1)
if ImportFileType<> 'SQL' then
do
parse var ExtraInfo MaybeColumnNumber','ExtraInfo
if MaybeColumnNumber<> '' & MaybeColumnNumber <> '*' then
ColumnNumber=MaybeColumnNumber
end
end
call DBG_IMPORT '{COL} #' || ColumnNumber || '<=' || ad!OrigColN || ': ' ||HeadingInfo
if datatype(ColumnNumber, 'W')=0 then
CryAndDie('The override {column} number of "' || ColumnNumber || '" is not an integer')
end
FieldHeading.NumberOfFields=HeadingInfo
FieldExtra.NumberOfFields=ExtraInfo
if HeadingInfo='' then
call DBG_IMPORT "User doesn't want this column..."
else
do
FieldColumn.NumberOfFields=ColumnNumber
DisplayingFields=DisplayingFields+1
end
end
call DBGIND-1
call _ImportValueSpacer 'What happens to blank fields?'
call DBGIND 1
if ProcessingMode='HTML' then
ad!B='&nbsp;'
else
ad!B=''
ReplaceBlankFields=GetImportValue('BLANK_FIELD',ad!B)
do Index=1 to DisplayingFields
RepBlankCol.Index=GetImportValue('BLANK_COLUMN_' ||Index,ReplaceBlankFields)
end
call DBGIND-1
call _ImportValueSpacer 'Want to strip spaces from column data?'
call DBGIND 1
DefStripType=GetImportValue('STRIP_SPACES',DefStripType)
do Index=1 to DisplayingFields
StripType.Index=translate(GetImportValue('STRIP_SPACES_' ||Index,DefStripType))
end
call DBGIND-1
if Imp2Data='' then
do
call _ImportValueSpacer 'What do we do with column titles?'
call DBGIND 1
if ImportValueExists('HEADER') = 'Y' then
ForHeader=GetImportValue('HEADER', '!BUG!')
else
do
DefaultColFormatting=GetImportValue('HEADING_COLUMNS',     "align='center'")
DefaultBeforeData=GetImportValue('HEADING_BEFORE_DATA', '')
DefaultAfterData=GetImportValue('HEADING_AFTER_DATA',  '')
ForHeader='<tr>'
do Index=1 to DisplayingFields
ThisColFormatting=GetImportValue('HEADING_COLUMN_' ||Index,DefaultColFormatting)
ThisBeforeData=GetImportValue('HEADING_BEFORE_DATA_' ||Index,DefaultBeforeData)
ThisAfterData=GetImportValue('HEADING_AFTER_DATA_' ||Index,DefaultAfterData)
ForHeader=ForHeader|| '<th ' || ThisColFormatting || '>' || ThisBeforeData || StartsMacroParm || 'Column' || Index || EndsMacroParm || ThisAfterData || '</th>'
end
ForHeader=ForHeader|| '</tr>'
end
call DBGIND-1
call _ImportValueSpacer 'Working out what table data row looks like'
call DBGIND 1
if ImportValueExists('RECORD') = 'Y' then
ForEachRecord=GetImportValue('RECORD', '!BUG!')
else
do
DefaultColFormatting=GetImportValue('RECORD_COLUMNS',     "align='center'")
DefaultBeforeData=GetImportValue('RECORD_BEFORE_DATA', '')
DefaultAfterData=GetImportValue('RECORD_AFTER_DATA',  '')
ForEachRecord='<tr>'
do Index=1 to DisplayingFields
ThisColFormatting=GetImportValue('RECORD_COLUMN_' ||Index,DefaultColFormatting)
ThisBeforeData=GetImportValue('RECORD_BEFORE_DATA_' ||Index,DefaultBeforeData)
ThisAfterData=GetImportValue('RECORD_AFTER_DATA_' ||Index,DefaultAfterData)
ForEachRecord=ForEachRecord|| '<td ' || ThisColFormatting || '>' || ThisBeforeData || StartsMacroParm || 'Column' || Index || EndsMacroParm  || ThisAfterData || '</td>'
end
ForEachRecord=ForEachRecord|| '</tr>'
end
call DBGIND-1
call _ImportValueSpacer 'Start output'
call DBGIND 1
call GenerateProtectStartTags
ad!TblAttr=GetImportValue('TABLE_ATTRIBS', "border='4' cellspacing='0' cellpadding='2'")
if ad!TblAttr<> '' then
ad!TblAttr=' ' ||strip(ad!TblAttr)
ad!BeforeTags='<table' || ad!TblAttr || '>'
ad!CapText=GetImportValue('TABLE_CAPTION_TEXT', '')
if ad!CapText<> '' then
do
ad!CapAttr=GetImportValue('TABLE_CAPTION_ATTRIBS', "")
ad!Cap='<caption'
if ad!CapAttr<> '' then
ad!Cap=ad!Cap|| ' ' ||ad!CapAttr
ad!Cap=ad!Cap|| '>' || ad!CapText || '</caption>'
ad!BeforeTags=ad!BeforeTags||ad!Cap
end
call GenerateBeforeTags ad!BeforeTags
call DBG_IMPORT 'Outputting heading fields'
call DBGIND 1
call _NewRecord 'H'
do FieldIndex=1 to NumberOfFields
call _AddField2Record FieldHeading.FieldIndex
end
call GenerateRecordFromFields
call DBGIND-2
end
call GetImportValue_Comments ';', ';' || ';'
if ProcessingMode='HTML' then
call HandleImportAsIsOptions "IMPORT_HTML_BASIC"
return

ImportTableTermination:
if Imp2Data='' then
do
call GenerateAfterTags '</table>'
call GenerateProtectEndTags
end
return

HandleFixedFieldFile:
if OptionDebugOn='Y' then
call DBG_IMPORT 'Importing fixed field file'
do FieldIndex=1 to NumberOfFields
parse var FieldExtra.FieldIndex StartCol'-'EndCol
if EndCol='' | EndCol = '*' then
FieldLength=''
else
FieldLength=(EndCol-StartCol)+1
FieldStartCol.FieldIndex=StartCol
FieldLength.FieldIndex=FieldLength
end
ImportFileLine=0
call DBG_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
CurrentRecord=ImportOneLine('Y')
ImportFileLine=ImportFileLine+1
if CurrentRecord='' then
iterate
if ImportFileLine<=DropLine then
iterate
if IsCmtLine(ImportFileLine)then
iterate
call _NewRecord
do FieldIndex=1 to NumberOfFields
if FieldLength.FieldIndex='' then
ThisField=substr(CurrentRecord,FieldStartCol.FieldIndex)
else
ThisField=substr(CurrentRecord,FieldStartCol.FieldIndex,FieldLength.FieldIndex)
call _AddField2Record ThisField
end
if GenerateRecordFromFields()then
leave
end
return(ImportFileLine)

ExtractFieldInfoFromSimpleCharDelimitedFile:
call DBG_IMPORT 'Field information not supplied, reading the defined column heading record!'
call DBGIND 1
HdrOnLine=DropLine
if HdrOnLine=0 then
HdrOnLine=1
HdrOnLine=GetImportValue('COLUMN_HEADINGS_ON_LINE_NUMBER',HdrOnLine)
if HdrOnLine<1 then
HdrOnLine=1
call DBG_IMPORT 'Field headings are on line #' ||HdrOnLine
if lines(FullImportName)=0 then
CryAndDie("Can't extract field information from an empty file!")
do cd!x=1 to HdrOnLine
cd!Line=ImportOneLine('Y')
end
bd!L=cd!Line
bd!Del=arg(1)
bd!MinF=0
bd!MaxF=0
bd!FC=0
bd!Q='"'
bd!Q2='""'
do while bd!L<> ''
bd!Fc=bd!Fc+1
if left(bd!L,1)<>bd!Q then
do
bd!DelPos=pos(bd!Del,bd!L)
if bd!DelPos<>0 then
do
bd!F=left(bd!L,bd!DelPos-1)
bd!L=substr(bd!L,bd!DelPos+1)
end
else
do
bd!F=bd!L
bd!L=''
end
end
else
do
bd!LookFrom=2
do forever
bd!QPos=pos(bd!Q,bd!L,bd!LookFrom)
if bd!QPos=0 then
do
if lines(FullImportName)=0 then
do
CryAndDie('Import of line ' || ImportFileLine || ' failed','A record spans more than one line however there are no more lines!',, 'RECORD', '~~~~~~', cd!Line, 'DETECTED AT', '~~~~~~~~~~~',bd!L)
end
bd!Ln=ImportOneLine('Y')
ImportFileLine=ImportFileLine+1
cd!Line=cd!Line||bd!Ln
bd!L=bd!L||ReplaceNewLineChar||bd!Ln
iterate
end
if substr(bd!L,bd!QPos+1,1)=bd!Q then
bd!LookFrom=bd!QPos+2
else
leave
end
bd!F=ReplaceString(substr(bd!L,2,bd!QPos-2),bd!Q2,bd!Q)
bd!L=substr(bd!L,bd!QPos+1)
if bd!L<> '' then
do
if left(bd!L,1)<>bd!Del then
do
CryAndDie('Import of line ' || ImportFileLine || ' failed','Expected delimiter after field #' || bd!Fc,, 'RECORD', '~~~~~~', cd!Line, 'DETECTED AT', '~~~~~~~~~~~',bd!L)
end
bd!L=substr(bd!L,2)
end
end
cd!Fld.bd!Fc=bd!F
if bd!MaxF<>0 then
do
if bd!Fc>=bd!MaxF then
leave
end
end
if bd!Fc<bd!MinF then
do
do while bd!Fc<bd!MinF
bd!Fc=bd!Fc+1
cd!Fld.bd!Fc=''
end
end
cd!Fld.0=bd!Fc
call DBG_IMPORT 'Found ' || cd!Fld.0 || ' fields:'
call DBGIND 1
cd!Ret=''
do cd!i=1 to cd!Fld.0
cd!F=cd!Fld.cd!i
if left(cd!F,1)='{' then
cd!F='{}' ||cd!F
call DBG_IMPORT 'Column #' || cd!i || ' = ' ||cd!F
cd!Ret=cd!Ret||QuoteIt(cd!F, "ANY", "Y") || ' '
end
call FileClose FullImportName
call DBGIND-2
return(cd!Ret)

HandleSimpleCharDelimitedFile:
FieldDelimiter=arg(1)
if OptionDebugOn='Y' then
do
DelimiterText=c2d(FieldDelimiter)
if DelimiterText> '32' then
DelimiterText=DelimiterText|| ' ("' || FieldDelimiter || '")'
call DBG_IMPORT 'Importing simple delimited file - delimiter = ASCII ' ||DelimiterText
end
call DBG_IMPORT 'Reading "' || FullImportName || '"...'
ImportFileLine=0
do while lines(FullImportName)<>0
CurrentRecord=ImportOneLine('Y')
ImportFileLine=ImportFileLine+1
if CurrentRecord='' then
do
if DropBlankLines='Y' then
iterate
end
if ImportFileLine<=DropLine then
iterate
if IsCmtLine(CurrentRecord)then
iterate
call _NewRecord
bd!L=CurrentRecord
bd!Del=FieldDelimiter
bd!MinF=NumberOfFields
bd!MaxF=NumberOfFields
bd!FC=0
bd!Q='"'
bd!Q2='""'
do while bd!L<> ''
bd!Fc=bd!Fc+1
if left(bd!L,1)<>bd!Q then
do
bd!DelPos=pos(bd!Del,bd!L)
if bd!DelPos<>0 then
do
bd!F=left(bd!L,bd!DelPos-1)
bd!L=substr(bd!L,bd!DelPos+1)
end
else
do
bd!F=bd!L
bd!L=''
end
end
else
do
bd!LookFrom=2
do forever
bd!QPos=pos(bd!Q,bd!L,bd!LookFrom)
if bd!QPos=0 then
do
if lines(FullImportName)=0 then
do
CryAndDie('Import of line ' || ImportFileLine || ' failed','A record spans more than one line however there are no more lines!',, 'RECORD', '~~~~~~', CurrentRecord, 'DETECTED AT', '~~~~~~~~~~~',bd!L)
end
bd!Ln=ImportOneLine('Y')
ImportFileLine=ImportFileLine+1
CurrentRecord=CurrentRecord||bd!Ln
bd!L=bd!L||ReplaceNewLineChar||bd!Ln
iterate
end
if substr(bd!L,bd!QPos+1,1)=bd!Q then
bd!LookFrom=bd!QPos+2
else
leave
end
bd!F=ReplaceString(substr(bd!L,2,bd!QPos-2),bd!Q2,bd!Q)
bd!L=substr(bd!L,bd!QPos+1)
if bd!L<> '' then
do
if left(bd!L,1)<>bd!Del then
do
CryAndDie('Import of line ' || ImportFileLine || ' failed','Expected delimiter after field #' || bd!Fc,, 'RECORD', '~~~~~~', CurrentRecord, 'DETECTED AT', '~~~~~~~~~~~',bd!L)
end
bd!L=substr(bd!L,2)
end
end
dd!Fld.bd!Fc=bd!F
if bd!MaxF<>0 then
do
if bd!Fc>=bd!MaxF then
leave
end
end
if bd!Fc<bd!MinF then
do
do while bd!Fc<bd!MinF
bd!Fc=bd!Fc+1
dd!Fld.bd!Fc=''
end
end
dd!Fld.0=bd!Fc
do dd!i=1 to dd!Fld.0
call _AddField2Record dd!Fld.dd!i
end
if GenerateRecordFromFields()then
leave
end
return(ImportFileLine)

_NewRecord:
RecordType=arg(1)
if Imp2Data='' then
do
if RecordType='H' then
ThisRecordsCodes=ForHeader
else
ThisRecordsCodes=ForEachRecord
end
FieldCounter=0
ColumnCounter=0
DroppedCounter=0
NonBlankFieldCounter=0
return

_AddField2Record:
FieldCounter=FieldCounter+1
if FieldHeading.FieldCounter='' then
do
DroppedCounter=DroppedCounter+1
Dropped.DroppedCounter=arg(1)
end
else
do
NewValue=arg(1)
ColumnCounter=ColumnCounter+1
StripWhat=StripType.ColumnCounter
if StripWhat<> '' then
NewValue=strip(NewValue,StripWhat)
if NewValue='' then
NewValue=RepBlankCol.ColumnCounter
else
NonBlankFieldCounter=NonBlankFieldCounter+1
SaveAsIndex=FieldColumn.FieldCounter
Column.SaveAsIndex=NewValue
end
return

GenerateRecordFromFields:
call DBGIND 1
if DropBlankLines='Y' then
do
if NonBlankFieldCounter=0 then
do
call DBG_IMPORT 'Dropping record as all fields were blank'
call DBGIND-1
return(0)
end
end
if RecordFilter<> '' then
do
if RecordType<> 'H' then
do
Column.0=ColumnCounter
Dropped.0=DroppedCounter
call DBG_IMPORT 'Calling specified filter'
call DBGIND 1
Remove=''
call ExecRexxCmd RecordFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DBG_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DBGIND-2
return(1)
end
else
do
call DBG_IMPORT 'Record dropped ==> ' ||Remove
call DBGIND-2
return(0)
end
end
call DBGIND-1
end
end
if Imp2Data='' then
do
do ThisOne=1 to ColumnCounter
ThisRecordsCodes=ReplaceString(ThisRecordsCodes,StartsMacroParm|| 'Column' ||ThisOne||EndsMacroParm,Column.ThisOne)
end
if ThisRecordsCodes<> '' then
do
call DBG_IMPORT 'Generating: ' ||DebugRightArrow||ThisRecordsCodes||DebugLeftArrow
call PpwLineout ToInclude,ThisRecordsCodes
end
end
else
do
Imp2DataCnt=Imp2DataCnt+1
if Imp2DataCnt=1 then
do
interpret 'drop ' || Imp2Data || '.'
call value Imp2Data|| '.!DataCols',ColumnCounter
call value Imp2Data|| '.!StartLocn',DoingImport
end
do ThisOne=1 to ColumnCounter
call value Imp2Data|| '.' || Imp2DataCnt || '.' ||ThisOne,Column.ThisOne
end
call value Imp2Data|| '.0',Imp2DataCnt
end
call DBGIND-1
return(0)

PpwLineout:
parse arg gFile,gLine
do until gLine==''
parse var gLine This1 (MarksNewLine) gLine
if 0<>charout(gFile,This1||NewLineChars)then
do
IoReason=FileDescription(gFile)
CryAndDie('Write to "' || gFile || '" failed (' || IoReason || ')!')
end
end
return

IMPORTT_36:
signal REXXSQL_37

LoadRexxSql:
signal on SYNTAX name RexxSqlMissing
ed!Rc=RXFuncAdd('SQLLoadFuncs', 'rexxsql', 'SQLLoadFuncs')
call DBG_IMPORT "RXFuncAdd(rexxsql.dll), RC = " ||ed!Rc
call SQLLoadFuncs
call DBG_IMPORT "rexxsql.dll functions loaded"
return

RexxSqlMissing:
fd!Em="Can't locate/load rexxsql.dll (Mark Hessling's SQL support)!"
fd!Reason='UNKNOWN'
signal on SYNTAX name RexxSqlEmFailed
if RexWhich='REGINA' then
do
fd!Tmp=RxFuncErrMsg()
fd!Reason=fd!Tmp
end

RexxSqlEmFailed:
CryAndDie(fd!Em, 'REASON:',fd!Reason)

fd!Line:
fd!Count=fd!Count+1
fd!L.fd!Count=arg(1)
return

ErrorSql:
do fd!I=1 to 10
fd!L.fd!I=''
end
fd!Count=0
do fd!I=1 to arg()
call fd!Line arg(fd!I)
end
if fd!Count>6 then
fd!Count=6
signal on NOVALUE name SqlVarMissing1
if fd!L.1='' then
do
fd!Count=1
if symbol('SQLCA.FUNCTION') = 'VAR' then
fd!L.1='REXXSQL ' || SQLCA.FUNCTION || '() call failed.'
else
fd!L.1='REXXSQL failed in an unknown SQL Function (this is a RexxSql bug)'
end
call fd!Line ''
if sqlca.intcode=-1 Then
do
call fd!Line 'SQLCODE:' sqlca.sqlcode
call fd!Line 'SQLERRM:' sqlca.sqlerrm
call fd!Line 'SQLTEXT:' sqlca.sqltext
end
else
do
call fd!Line 'INTCODE:' sqlca.intcode
call fd!Line 'INTERRM:' sqlca.interrm
end

SqlVarMissing2:
CryAndDie(fd!L.1,fd!L.2,fd!L.3,fd!L.4,fd!L.5,fd!L.6,fd!L.7,fd!L.8,fd!L.9,fd!L.10)

SqlVarMissing1:
call fd!Line 'The REXXSQL variable "' || condition('D') || '" is unknown.'
call fd!Line "ErrorSQL() was trying to display REXXSQL information..."
signal SqlVarMissing2

HandleSqlDataBase:
if OptionDebugOn='Y' then
do
call DBG_IMPORT "Importing SQL via Mark Hessling's REXXSQL interface"
call DBGIND 1
end
call LoadRexxSql
gd!Imported=0
call DBG_IMPORT "REXXSQL VERSION: " || SqlVariable("VERSION")
do FieldIndex=1 to NumberOfFields
gd!FNAME=FieldExtra.FieldIndex
if gd!FNAME='' then
gd!FNAME=FieldHeading.FieldIndex
FieldName.FieldIndex=gd!FNAME
end
if OptionDebugOn='Y' then
do
call SqlVariable "DEBUG", GetImportValue('SQL_DEBUG', '3')
end
gd!Id="SQL"
gd!UserId=GetImportValue('SQL_USERID',   "")
gd!Password=GetImportValue('SQL_USERPW',   "")
gd!DataSourceId=GetImportValue('SQL_DATABASE', "")
if gd!DataSourceId='' then
CryAndDie('An SQL database was not specified')
gd!Server=GetImportValue('SQL_SERVER',   "")
call DBG_IMPORT "Connecting to the database: SQLConnect()"
if SQLConnect(gd!Id,gd!UserId,gd!Password,gd!DataSourceId,gd!Server)<0 then
ErrorSql('Connection failed to "' || gd!DataSourceId || '", have you set up ODBC datasource (control panel)?')
call DBG_IMPORT "DATABASE INFO: " || SqlGetInfo(gd!Id, 'DBMSNAME')
gd!Cmds=GetImportValue('SQL_COMMANDS', "")
if gd!Cmds<> '' then
do
call DBGIND 1
do gd!I=1 to words(gd!Cmds)
gd!Mac=word(gd!Cmds,gd!I)
gd!Cmd=GetDefineContents(gd!Mac)
if left(gd!Cmd,1)<> '-' then
gd!Doe='Y'
else
do
gd!Doe='N'
gd!Cmd=substr(gd!Cmd,2)
end
call DBG_IMPORT "Executing: " ||gd!Cmd
gd!Rc=SQLCommand(gd!Mac,gd!Cmd)
call DBGIND 1
if gd!Rc>=0 then
call DBG_IMPORT "OK, RC=" ||gd!Rc
else
do
if gd!Doe='Y' then
ErrorSql('User command from "' || gd!Mac || '" failed!')
if sqlca.intcode=-1 Then
do
gd!1='SQLCODE:' sqlca.sqlcode
gd!2='SQLERRM:' sqlca.sqlerrm
gd!3='SQLTEXT:' sqlca.sqltext
end
else
do
gd!1='INTCODE:' sqlca.intcode
gd!2='INTERRM:' sqlca.interrm
gd!3=''
end
call DBG_IMPORT "Command failed"
call DBG_IMPORT gd!1
call DBG_IMPORT gd!2
call DBG_IMPORT gd!3
end
call DBGIND-1
end
call DBGIND-1
end
gd!Query=GetImportValue('SQL_QUERY', "")
if gd!Query='' then
CryAndDie('An SQL query was not specified')
call DBG_IMPORT "Preparing the query: SqlPrepare()"
if SqlPrepare('SQLQUERY',gd!Query)<0 then
ErrorSql('The SQL prepare step failed, could be an DSN config issue (or CSV missing etc)')
if OptionDebugOn='Y' then
do
call DBG_IMPORT "Returned Column information"
call DBGIND 1
gd!Attribs=SqlGetInfo(gd!Id, 'DESCRIBECOLUMNS')
if sqlca.intcode<0 then
gd!Attribs='NAME TYPE SIZE SCALE NULLABLE PRECISION'
gd!Pad2=0
do gd!I=1 to words(gd!Attribs)
gd!This=word(gd!Attribs,gd!I)
if length(gd!This)>gd!Pad2 then
gd!Pad2=length(gd!This)
end
gd!NumCols=SqlDescribe('SQLQUERY', 'gd!Det')
if gd!NumCols<0 then
ErrorSql()
do gd!ColIndex=1 to gd!NumCols
call DBG_IMPORT "Query Field " ||gd!ColIndex
call DBGIND 1
do gd!I=1 to words(gd!Attribs)
gd!Attrib=word(gd!Attribs,gd!I)
gd!Value=value('gd!Det.COLUMN.' || gd!Attrib || '.gd!ColIndex')
if left(gd!Value,1)='' | right(gd!Value, 1) = '' then
gd!Value='""'
call DBG_IMPORT right(gd!Attrib,gd!Pad2)|| ' = ' ||gd!Value
end
call DBGIND-1
end
call DBGIND-1
end
if SqlOpen('SQLQUERY')<0 then
ErrorSql()
gd!Rc=SqlFetch('SQLQUERY')
do while gd!Rc>0
call _NewRecord
do FieldIndex=1 to NumberOfFields
gd!ColVar='SQLQUERY.' ||FieldName.FieldIndex
if gd!Imported=0 then
do
if symbol(gd!ColVar)<> 'VAR' then
CryAndDie('The query did not return a field called "' || FieldName.FieldIndex || '"')
end
gd!ColVal=value(gd!ColVar)
gd!ColVal=AsIs(gd!ColVal)
call _AddField2Record gd!ColVal
end
gd!Imported=gd!Imported+1
if GenerateRecordFromFields()then
leave
gd!Rc=SqlFetch('SQLQUERY')
end
if gd!Rc<0 then
ErrorSql()
if SqlClose('SQLQUERY')<0 then
ErrorSql()
if SqlDispose('SQLQUERY')<0 then
ErrorSql()
call DBG_IMPORT "Disconnecting from the database"
if SQLDisconnect(gd!Id)<0 then
ErrorSql()
if OptionDebugOn='Y' then
call DBGIND-1
return(gd!Imported)

REXXSQL_37:
signal IMPORTTX_38

HandleTextToHtmlImport:
if ProcessingMode<> 'HTML' then
CryAndDie("Text to html file importing is only allowed when generating HTML")
if ImportParms<> '' then
CryAndDie('There are too many parameters on the T2H #import!')
UrlNameVar=StartsMacroParm|| 'Url' ||EndsMacroParm
UrlTypeVar=StartsMacroParm|| 'UrlType' ||EndsMacroParm
HeadingVar=StartsMacroParm|| 'Heading' ||EndsMacroParm
call GenerateProtectStartTags
call GenerateBeforeTags '<pre><font size=-1>'
T2hFilter=GetImportValue_RecordFilter()
call GetImportValue_LineFilter
call GetImportValue_Tabs
BlankLinesTo=GetImportValue('BLANK_LINES_TO', '')
HttpLink=GetImportValue('HTTP_LINK',   '<a href="' || UrlTypeVar || UrlNameVar || '" target=_top>' || UrlTypeVar || UrlNameVar || '</a>')
FtpLink=GetImportValue('FTP_LINK',    '<a href="' || UrlTypeVar || UrlNameVar || '">' || UrlTypeVar || UrlNameVar || '</a>')
MailLink=GetImportValue('MAILTO_LINK', '<A HREF="mailto:' || UrlNameVar || '">' || UrlNameVar || '</A>')
DefaultAllStd=UpperCase||LowerCase||DecimalDigits
AlwaysOkInUrl=GetImportValue('ALWAYS_OK_IN_URL_CHARS',DefaultAllStd)
if AlwaysOkInUrl\=='' then
DefaultAllStd=''
ExtraValidHttpChar=GetImportValue('EXTRA_VALID_HTTP_CHARS',         DefaultAllStd || './?%+:~_')
ExtraValidFtpChar=GetImportValue('EXTRA_VALID_FTP_CHARS',ExtraValidHttpChar)
ExtraValidEmailName=GetImportValue('EXTRA_VALID_EMAIL_NAME_CHARS',   DefaultAllStd || '_.')
ExtraValidEmailSvr=GetImportValue('EXTRA_VALID_EMAIL_SVR_CHARS',    DefaultAllStd || '_.')
ValidEmailDelimiters=GetImportValue('EXTRA_VALID_EMAIL_DELIMITERS',   " '" || '",;')
ValidInHttpUrl=AlwaysOkInUrl||ExtraValidHttpChar
ValidInFtpUrl=AlwaysOkInUrl||ExtraValidFtpChar
ValidInEmailL=AlwaysOkInUrl||ExtraValidEmailName
ValidInEmailR=AlwaysOkInUrl||ExtraValidEmailSvr
call GetImportValue_Comments '', ''
if ProcessingMode='HTML' then
call HandleImportAsIsOptions "IMPORT_HTML_BASIC IMPORT_HTML_BOXGRAPHIC_TO_BOXTEXT"
T2hLineNumber=0
call DBG_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
T2hFileLine=ImportOneLine('Y')
T2hLineNumber=T2hLineNumber+1
if IsCmtLine(T2hFileLine)then
iterate
if T2hFileLine='' then
do
if BlankLinesTo\=='' then
T2hNewLine=BlankLinesTo
else
T2hNewLine=''
end
else
do
T2hNewLine=T2hFileLine
if MailLink\=='' then
T2hNewLine=_MakeTextImportEmailChanges(T2hNewLine,ValidInEmailL,ValidInEmailR,ValidEmailDelimiters,MailLink)
if HttpLink\=='' then
T2hNewLine=_MakeTextImportLinkChanges(T2hNewLine, 'http:',ValidInHttpUrl,HttpLink)
if FtpLink\=='' then
T2hNewLine=_MakeTextImportLinkChanges(T2hNewLine, 'ftp:',ValidInFtpUrl,FtpLink)
end
if T2hFilter<> '' then
do
call DBG_IMPORT 'Calling specified filter'
call DBGIND 1
Remove=''
call ExecRexxCmd T2hFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DBG_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DBGIND-1
leave
end
else
do
call DBG_IMPORT 'Record dropped ==> ' ||Remove
call DBGIND-1
iterate
end
end
call DBGIND-1
end
call PpwLineout ToInclude,T2hNewLine
end
call GenerateAfterTags '</font></pre>'
call GenerateProtectEndTags
return(T2hLineNumber)

_MakeTextImportLinkChanges:
parse arg RightBit,UrlType,tlOkInUrl,tlTransformSpec
LeftBit=''
UrlPos=pos(UrlType,RightBit)
lUrlType=length(UrlType)
do while UrlPos<>0
LeftBit=LeftBit||left(RightBit,UrlPos-1)
RightBit=substr(RightBit,UrlPos+lUrlType)
NotUrlCharPos=verify(RightBit,tlOkInUrl)
if NotUrlCharPos=0 then
do
TheUrl=RightBit
RightBit=''
end
else
do
TheUrl=left(RightBit,NotUrlCharPos-1)
RightBit=substr(RightBit,NotUrlCharPos)
end
UrlBit=ReplaceString(tlTransformSpec,UrlTypeVar,UrlType)
UrlBit=ReplaceString(UrlBit,UrlNameVar,TheUrl)
LeftBit=LeftBit||UrlBit
UrlPos=pos(UrlType,RightBit)
end
return(LeftBit||RightBit)

_MakeTextImportEmailChanges:
parse arg RightBit,tlOkInEmailName,tlOkInEmailSvr,tlDelimiters,tlTransformSpec
LeftBit=''
SnailPos=pos('@',RightBit)
do while SnailPos<>0
lRightBit=length(RightBit)
if SnailPos=1|SnailPos=lRightBit then
do
LeftBit=LeftBit||left(RightBit,SnailPos)
RightBit=substr(RightBit,SnailPos+1)
end
else
do
LeftPos=SnailPos-1
do until LeftPos=0
OneChar=substr(RightBit,LeftPos,1)
if pos(OneChar,tlDelimiters)<>0 then
do
LeftPos=LeftPos+1
leave
end
LeftPos=LeftPos-1
end
if LeftPos=0 then
LeftPos=LeftPos+1
EmailLeftBit=substr(RightBit,LeftPos,SnailPos-LeftPos)
RightPos=SnailPos+1
do until RightPos>lRightBit
OneChar=substr(RightBit,RightPos,1)
if pos(OneChar,tlDelimiters)<>0 then
do
RightPos=RightPos-1
leave
end
RightPos=RightPos+1
end
if RightPos>lRightBit then
RightPos=lRightBit
if substr(RightBit,RightPos,1)='.' then
RightPos=RightPos-1
EmailRightBit=substr(RightBit,SnailPos+1,RightPos-SnailPos)
if verify(EmailLeftBit,tlOkInEmailName)<>0|verify(EmailRightBit,tlOkInEmailSvr)<>0|pos('.',EmailRightBit)=0 then
do
LeftBit=LeftBit||left(RightBit,SnailPos)
RightBit=substr(RightBit,SnailPos+1)
end
else
do
EmailBit=ReplaceString(tlTransformSpec,UrlTypeVar, 'mailto:')
EmailBit=ReplaceString(EmailBit,UrlNameVar,EmailLeftBit|| '@' ||EmailRightBit)
LeftBit=LeftBit||left(RightBit,LeftPos-1)||EmailBit
RightBit=substr(RightBit,RightPos+1)
end
end
SnailPos=pos('@',RightBit)
end
return(LeftBit||RightBit)

IMPORTTX_38:
signal IMPORTWR_39

HandleLineWrapping:
if ImportParms<> '' then
CryAndDie('There are too many parameters on the WRAP #import!')
DropBlankLines=translate(GetImportValue('DROP_BLANK_LINES',  'Y'))
call GetImportValue_Tabs
WrapFilter=GetImportValue_RecordFilter()
call GetImportValue_LineFilter
call GetImportValue_Comments ';', ';' || ';'
if ProcessingMode='HTML' then
call HandleImportAsIsOptions ""
WrapLineNumber=0
NewDoubleQuote='" || d2c(34) || "'
call DBG_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
WrapLine=ImportOneLine('Y')
WrapLineNumber=WrapLineNumber+1
if WrapLine='' then
do
if DropBlankLines='Y' then
iterate
end
if IsCmtLine(WrapLine)then
iterate
if WrapFilter='' then
do
RebuildCmd='"' || ReplaceString(WrapLine, '"', NewDoubleQuote) || '"'
SafeQuote=QuoteIt(RebuildCmd,TryQuoteListAny)
call PpwLineout ToInclude,StartsMacroReplacement||MacroName|| ' Line=' ||SafeQuote||RebuildCmd||SafeQuote||EndsMacroReplacement
end
else
do
call DBG_IMPORT 'Calling filter for line #' ||WrapLineNumber
call DBGIND 1
Remove=''
call ExecRexxCmd WrapFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DBG_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DBGIND-1
leave
end
else
do
call DBG_IMPORT 'Line dropped ==> ' ||Remove
call DBGIND-1
iterate
end
end
call DBGIND-1
call PpwLineout ToInclude,WrapLine
end
end
return(WrapLineNumber)

IMPORTWR_39:
MultiLineImportInProgress='N'
signal I_ML_40

HandleMultiLineImport:
if OptionDebugOn='Y' then
call DBG_IMPORT 'Importing multi line record file'
mlDelimiter=GetImportValue('DELIMITER',         '=')
mlLineSep=GetImportValue('SEPARATOR',         ' ')
mlStripL=translate(GetImportValue('STRIP_LEADING', 'Y'))
mlLineCmtChar=GetImportValue('LINE_COMMENT_CHAR',LineComment)
if mlLineCmtChar='' then
mlLineCmtChar=' '
call GetImportValue_LineFilter
MultiLineFilter=PerformReplacementsInCmdsParameters(GetImportValue('MULTILINE_FILTER', ''))
drop mlFIndex?.
do FieldIndex=1 to NumberOfFields
parse value translate(FieldExtra.FieldIndex)with FieldName ',' FieldOptions
if FieldName='' then
CryAndDie('No {field name} supplied for field #' ||FieldIndex)
call _valueS 'mlFIndex?.mli?' ||c2x(FieldName),FieldOptions
MlFieldName.FieldIndex=FieldName
end
MultiLineImportInProgress='Y'
LastMlStoredAs=''
ImportFileLine=0
LastCommentLine=''
call DBG_IMPORT 'Reading "' || FullImportName || '"...'
call _MlNewRecord
do while lines(FullImportName)<>0
MultiLine=strip(ImportOneLine('N'))
ImportFileLine=ImportFileLine+1
if MultiLine='' then
do
if MlFieldCnt<>0 then
do
hd!Eof=_MlGenerateRecord()
call _MlNewRecord
if hd!Eof then
leave
end
end
else
do
if left(MultiLine,1)=LineComment then
iterate
if MultiLineFilter<> '' then
do
call DBG_IMPORT 'Calling specified multi line filter'
call DBGIND 1
Remove=''
call ExecRexxCmd MultiLineFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DBG_IMPORT 'Line #' || ImportFileLine || ' to EOF dropped ==> ' ||Remove
call DBGIND-1
leave
end
else
do
call DBG_IMPORT 'Line #' || ImportFileLine || ' dropped ==> ' ||Remove
call DBGIND-1
iterate
end
end
call DBGIND-1
end
parse var MultiLine MultiVar (mlDelimiter) MultiValue
if mlStripL='Y' then
MultiValue=strip(MultiValue, 'L')
else
do
if left(MultiValue,1)=' ' then
MultiValue=substr(MultiValue,2)
end
if MultiVar<> '' then
call _MlRememberFieldsValue strip(MultiVar, 'T'),MultiValue
else
do
if LastMlStoredAs='' then
CryAndDie('Line #' || ImportFileLine || ': No field to continue!')
if AsIsThisField='N' then
mlNew=_valueG(LastMlStoredAs)||mlLineSep||MultiValue
else
mlNew=_valueG(LastMlStoredAs)||mlLineSep||AsIs(MultiValue)
call _valueS LastMlStoredAs,mlNew
end
end
end
call FileClose FullImportName
if MlFieldCnt<>0 then
call _MlGenerateRecord
MultiLineImportInProgress='N'
return(ImportFileLine)

_MlNewRecord:
call _NewRecord
MlFieldCnt=0
drop mlFValues?.
return

_MlRememberFieldsValue:
parse arg FieldN,FieldV
UFieldN=translate(FieldN)
StoredAs='mlFIndex?.mli?' ||c2x(UFieldN)
if symbol(StoredAs)<> 'VAR' then
CryAndDie('Line #' || ImportFileLine || ' - Unknown field name of "' || FieldN || '"')
FieldOptions=_valueG(StoredAs)
StoredAs='mlFValues?.mlv?' ||c2x(UFieldN)
LastMlStoredAs=StoredAs
if symbol(StoredAs)='VAR' then
CryAndDie('Line #' || ImportFileLine || ' - Field name of "' || FieldN || '" specified more than once')
if FieldV='' then
do
if pos('NONBLANK',FieldOptions)<>0 then
CryAndDie('Line #' || ImportFileLine || ' - Field "' || FieldN || '" contains a blank value')
end
if pos('NOASIS',FieldOptions)=0 then
do
call _valueS StoredAs,AsIs(FieldV)
AsIsThisField='Y'
end
else
do
call _valueS StoredAs,FieldV
AsIsThisField='N'
end
MlFieldCnt=MlFieldCnt+1
return

_MlGenerateRecord:
do FieldIndex=1 to NumberOfFields
FieldName=MlFieldName.FieldIndex
StoredAs='mlFValues?.mlv?' ||c2x(FieldName)
if symbol(StoredAs)='VAR' then
call _AddField2Record _valueG(StoredAs)
else
do
FieldOptions=_valueG('mlFIndex?.mli?' ||c2x(FieldName))
if pos('REQUIRED',FieldOptions)<>0 then
CryAndDie('Line #' || ImportFileLine || ' - Required field "' || FieldName || '" was not specified')
call _AddField2Record ''
end
end
id!Eof=GenerateRecordFromFields()
LastMlStoredAs=''
return(id!Eof)

GetMlField:call TRACE "OFF"
if MultiLineImportInProgress<> 'Y' then
CryAndDie('GetMlField(): Multi line import is not in progress!')
FieldName=translate(arg(1))
StoredAs='mlFValues?.mlv?' ||c2x(FieldName)
if symbol(StoredAs)='VAR' then
return(_valueG(StoredAs))
CryAndDie('Line #' || ImportFileLine || ' - GetMlField(): Field "' || FieldName || '" is unknown!')

I_ML_40:
call LoopInitOnce
signal LOOP_41

LoopInitOnce:
RxLoopCntr=0
LoopID=0
call LoopInitForEachLoop
return

LoopInitForEachLoop:
InLoop='N'
LoopCnt=0
LoopLine=1
LoopContinueIndex=0
LoopFirstLineNumber=-1
LoopAtEndLineNumber=-1
LoopIfNesting=-1
LoopLineSrc=-1
return

LoopPush:
call StackPush "#{ LOOP"
RxLoopCntr=RxLoopCntr+1
SavedAs=RxLoopCntr
SFI_InLoop.SavedAs=InLoop
SFI_LoopCnt.SavedAs=LoopCnt
SFI_LoopLine.SavedAs=LoopLine
SFI_LoopLineSrc.SavedAs=LoopLineSrc
SFI_LoopFirstLineNumber.SavedAs=LoopFirstLineNumber
SFI_LoopAtEndLineNumber.SavedAs=LoopAtEndLineNumber
SFI_LoopIfNesting.SavedAs=LoopIfNesting
SFI_LoopContIndex.SavedAs=LoopContinueIndex
do SaveIndex=1 to LoopCnt
SavedPpwLoop.SaveIndex.SavedAs=PpwLoop.SaveIndex
end
call LoopInitForEachLoop
return

LoopPop:
call StackPop "#{ LOOP"
SavedAs=RxLoopCntr
RxLoopCntr=RxLoopCntr-1
InLoop=SFI_InLoop.SavedAs
LoopCnt=SFI_LoopCnt.SavedAs
LoopLine=SFI_LoopLine.SavedAs
LoopLineSrc=SFI_LoopLineSrc.SavedAs
LoopFirstLineNumber=SFI_LoopFirstLineNumber.SavedAs
LoopAtEndLineNumber=SFI_LoopAtEndLineNumber.SavedAs
LoopIfNesting=SFI_LoopIfNesting.SavedAs
LoopContinueIndex=SFI_LoopContIndex.SavedAs
do SaveIndex=1 to LoopCnt
PpwLoop.SaveIndex=SavedPpwLoop.SaveIndex.SavedAs
end
return

LoopPushHack:
call LoopPush
return

LoopPopHack:
call LoopPop
return

ProcessLoopStart:
if InLoop='Y-DisableForNow' then
do
LineSrc='L'
CryAndDie('A nested loop must for now be "hidden" within a macro')
end
else
do
if IncludeMemBufferNextLine=='' then
LineSrc='F'
else
LineSrc='M'
end
call LoopPush
InLoop='Y'
LoopID=LoopID+1
LoopCnt=0
LoopLine=1
jd!A=arg(1)
if jd!A="" then
jd!LoopType=''
else
do
jd!A=PerformReplacementsInCmdsParameters(jd!A)
parse var jd!A jd!LoopType jd!A
jd!LoopType=translate(jd!LoopType)
select
when jd!LoopType='FOR' then
do
parse value translate(jd!A)with jd!Var "=" jd!Strt " TO " jd!End
jd!Var=strip(jd!Var)
jd!Strt=strip(jd!Strt)
if jd!End="" then
CryAndDie("Incorrect FOR spec ==> " ||jd!A)
if datatype(jd!Strt, 'Number')=0 then
jd!Strt=GetRexxVarValueOrDie(jd!Strt)
call _valueS jd!Var,jd!Strt
end
when jd!LoopType='SET' then
do
if translate(word(jd!A,1))<> 'COUNTER' then
jd!Var='SetLoopVar' ||LoopID
else
do
jd!Var=word(jd!A,2)
jd!A=subword(jd!A,3)
end
jd!SetCnt=0
jd!InitSet=''
jd!LoopSetCnt=0
jd!IndexList=''
jd!NewArray='SETITEMS' ||LoopID
do while jd!A<> ''
jd!SetName=GetQuotedText(jd!A, "jd!A")
if pos('=',jd!SetName)<>0 then
do
parse var jd!SetName jd!SetName '=' jd!Rest
parse var jd!Rest '{' jd!Del '}' jd!2Split
if jd!Del=='' then
do
jd!Del=' '
jd!2Split=jd!Rest
end
call ArraySplit jd!SetName,jd!2Split,jd!Del
end
jd!SetVAR="SET_" ||jd!SetName
jd!SetStem=jd!SetName|| '.'
jd!SetCnt=jd!SetCnt+1
jd!IndexVar='jd!' ||jd!SetCnt
jd!InitSet=jd!InitSet|| 'do ' || jd!IndexVar || ' = 1 to ' || jd!SetStem || '0; '
if jd!SetCnt<>1 then
jd!IndexList=jd!IndexList|| ' || '
jd!IndexList=jd!IndexList|| '"' || jd!SetVar || '=' || jd!SetStem || '" || ' || jd!IndexVar || ' || ";"'
end
jd!InitSet=jd!InitSet|| 'jd!LoopSetCnt=jd!LoopSetCnt+1; '
jd!InitSet=jd!InitSet||jd!NewArray|| '.jd!LoopSetCnt=strip(' || jd!IndexList || '); '
do jd!I=1 to jd!SetCnt
jd!InitSet=jd!InitSet|| 'end; '
end
call ExecRexxCmd jd!InitSet
call _valueS jd!NewArray|| '.0',jd!LoopSetCnt
jd!End=jd!LoopSetCnt
call _valueS jd!Var,1
end
otherwise
CryAndDie('Invalid loop specification (command "' || jd!LoopType || '" unknown)')
end
end
if jd!LoopType='FOR' | jd!LoopType = 'SET' then
do
call DBG 'Adding FOR/SET loop lines'
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=CmdHashIf|| ' [' || jd!Var || ' > ' || jd!End || ']'
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=CmdHashLoopBreak
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=CmdHashEndifL
if jd!LoopType='SET' then
do
call DBG 'Adding SET loop lines for ' || jd!LoopSetCnt || ' loops'
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=CmdHashEvaluateL|| ' ^^ ^<' || '??' || jd!NewArray || '.' || jd!Var || '>^'
end
end
LoopFirstLineNumber=IncludeLineNumber
LoopIfNesting=IfNesting
LoopLineSrc=LineSrc
LngCmdS=length(CmdHashLoopS)
LngCmdE=length(CmdHashLoopE)
EndCnt=1
EndCntPrev=0
do forever
if EndCnt<>EndCntPrev then
do
call DBG 'Looking for ' || EndCnt || ' end of loops...'
EndCntPrev=EndCnt
end
if LoopLineSrc='F' then
do
if IncludeFileLines()=0 then
leave
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=IncludeFileLineIn()
InputLines=InputLines+1
end
else
do
if IncludeMemBufferNextLine=='' then
leave
LoopCnt=LoopCnt+1
parse var IncludeMemBufferNextLine PpwLoop.LoopCnt (MarksNewLine) IncludeMemBufferNextLine
end
SrchThis=strip(translate(PpwLoop.LoopCnt,,TabChar), 'L')
if CmdHashLoopS=left(SrchThis,LngCmdS)then
do
call DBG 'Found the start of a nested loop...'
EndCnt=EndCnt+1
CryAndDie('A nested loop must for now be "hidden" within a macro')
end
if CmdHashLoopE=left(SrchThis,LngCmdE)then
do
call DBG 'Found the end of a loop...'
EndCnt=EndCnt-1
if EndCnt=0 then
do
LoopCnt=LoopCnt-1
if LoopCnt=0 then
CryAndDie("No commands found in body of loop!")
leave
end
end
end
LoopAtEndLineNumber=IncludeLineNumber
if EndCnt<>0 then
do
if LoopLineSrc='F' then
eLoop='EOF'
else
eLoop='end of macro'
CryAndDie('Could not find "' || CmdHashLoopE || '" before ' || eLoop, 'Searched ' || LoopCnt || ' line(s)')
end
if jd!LoopType='FOR' | jd!LoopType = 'SET' then
do
call DBG 'Adding FOR/SET loop lines'
LoopCnt=LoopCnt+1
PpwLoop.LoopCnt=CmdHashRexxVar|| ' ^' || jd!Var || '^ + 1'
LoopContinueIndex=LoopCnt
end
else
do
LoopContinueIndex=1
end
call DBG 'Loop is ' || LoopCnt || ' line(s) long and ends on line ' ||AddCommasToDecimalNumber(IncludeLineNumber)
return(0)

GetLoopLineIntoFileLine:
FileLine=PpwLoop.LoopLine
if LoopLineSrc='F' then
IncludeLineNumber=LoopFirstLineNumber+LoopLine
LoopLine=LoopLine+1
if LoopLine>LoopCnt then
LoopLine=1
return(FileLine)

ProcessLoopBreak:
call DBG 'Exiting loop'
InLoop='N'
IfNesting=LoopIfNesting
IncludeLineNumber=LoopAtEndLineNumber
call LoopPop
return(0)

ProcessLoopContinue:
LoopLine=LoopContinueIndex
call DBG 'Back to "start" of loop - Loop Line #' ||LoopContinueIndex
IfNesting=LoopIfNesting
return(0)

LOOP_41:
_RestrictKeyMinimum=CharsLUN
_giCounter=0
signal GetId_42

GetIdPrepare:call TRACE "OFF"
giHandle=arg(1)
giUniqueId=translate(arg(2))
interpret 'drop GI?'  || giHandle || '.'
call _valueS 'GI?'  || giHandle || '.GI?UID',giUniqueId
call _valueS 'GI?'  || giHandle || '.GI?PFVAR',arg(3)
return

SetId:call TRACE "OFF"
giHandle=arg(1)
giName=arg(2)
giId=arg(3)
giSaveAsPrefix='GI?'  || giHandle || '.GI?'
if giName\=='' then
do
if _valueG(giSaveAsPrefix|| 'UID') = 'Y' then
CryAndDie("You have asked for UNIQUE ID's to be generated. Don't use SetId()!!!")
giKeySavedAs=giSaveAsPrefix|| 'KEY_' ||c2x(giName)
if symbol(giKeySavedAs)='VAR' then
CryAndDie('SetId(): The KEY of "' || giName || '" has already been used')
call _valueS giKeySavedAs,giId
end
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giId)
if symbol(IdSavedAs)='VAR' then
CryAndDie('SetId(): The ID of "' || giId || '" has already been used')
call _valueS IdSavedAs, ''
return('')

GetId:call TRACE "OFF"
giHandle=arg(1)
giType=translate(arg(2))
giName=arg(3)
giSaveAsPrefix='GI?'  || giHandle || '.GI?'
giUniqueId=_valueG(giSaveAsPrefix|| 'UID')
giPfVar=_valueG(giSaveAsPrefix|| 'PfVar')
if giUniqueId<> 'Y' then
do
giKeySavedAs=giSaveAsPrefix|| 'KEY_' ||c2x(giName)
if symbol(giKeySavedAs)='VAR' then
return(_valueG(giKeySavedAs))
end
GiMaxLength=''
select
when giType="MAXCHARS" then
do
CanBeDuplicated='Y'
GiMaxLength=arg(5)
if GiMaxLength='' then
GiMaxLength=8
giId=_Id_2_(giName,arg(4))
if length(giId)>GiMaxLength then
giId=left(giId,GiMaxLength)
end
when giType="C2X" then
do
CanBeDuplicated='N'
giId=_Id_c2x(giName,arg(4))
end
when giType="2_" then
do
CanBeDuplicated='Y'
giId=_Id_2_(giName,arg(4))
end
otherwise
CryAndDie('GetId(): Invalid type of "' || giType || '" specified')
end
if CanBeDuplicated='Y' then
do
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giId)
if symbol(IdSavedAs)='VAR' then
do
GiIndex=1
do forever
if GiMaxLength='' then
giTryId=giId||GiIndex
else
do
giChopLength=GiMaxLength-length(GiIndex)
if length(giId)>giChopLength then
giTryId=left(giId,giChopLength)||GiIndex
else
giTryId=giId||GiIndex
end
GiIndex=GiIndex+1
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giTryId)
if symbol(IdSavedAs)<> 'VAR' then
do
giId=giTryId
leave
end
end
end
call _valueS IdSavedAs, ''
end
if giUniqueId<> 'Y' then
call _valueS giKeySavedAs,giId
return(giId)

_Id_2_:
parse arg KeyR,RestrictTo
RestrictTo=_RestrictKeyMinimum||RestrictTo
if giPfVar<> "" then
do
giPrefix=_valueG(giPfVar)
KeyR=giPrefix||KeyR
call _valueS giPfVar, ""
end
KeyL=''
InvPos=verify(KeyR,RestrictTo)
do while InvPos<>0
KeyL=KeyL||left(KeyR,InvPos-1)|| '_'
KeyR=substr(KeyR,InvPos+1)
InvPos=verify(KeyR,RestrictTo)
end
KeyL=strip(KeyL||KeyR,, '_')
do until BeforeCount=ReplaceCount
BeforeCount=ReplaceCount
KeyL=ReplaceString(KeyL, "__", "_")
end
if KeyL='' then
return('_')
else
return(KeyL)

_Id_c2x:
parse arg KeyR,RestrictTo
RestrictTo=_RestrictKeyMinimum||RestrictTo
KeyL=''
InvPos=verify(KeyR,RestrictTo)
do while InvPos<>0
KeyL=KeyL||left(KeyR,InvPos-1)|| 'x' ||c2x(substr(KeyR,InvPos,1))
KeyR=substr(KeyR,InvPos+1)
InvPos=verify(KeyR,RestrictTo)
end
return(KeyL||KeyR)

GetId_42:
call GetIdPrepare "IMAGEHW"
Add2Stem=''
_ValCharsHttp=UpperCase||LowerCase||DecimalDigits|| "./?=&%+:~_-,#@[]()$!;"
_ValCharsFtp=_ValCharsHttp
_DelOnExitCnt=0
signal Evaluate_43

_ScaleSide:
parse arg SideBefore,SideScale
PercentPos=pos('%',SideScale)
if PercentPos=0 then
return(SideScale)
else
return((SideBefore*left(SideScale,PercentPos-1))%100)

_GetSizeTags:
if OptionDebugOn='Y' then
do
call DBGIND 1
call DBG_EVALUATE 'Real size = ' || ImageWidth || 'x' ||ImageHeight
call DBGIND-1
end
ImgScaleW=ImageScaleW
ImgScaleH=ImageScaleH
if ImgScaleW='?' | ImgScaleH = '?' then
do
if ImgScaleW='?' then
do
NewHeight=_ScaleSide(ImageHeight,ImgScaleH)
NewWidth=(ImageWidth*NewHeight)%ImageHeight
end
else
do
NewWidth=_ScaleSide(ImageWidth,ImgScaleW)
NewHeight=(ImageHeight*NewWidth)%ImageWidth
end
end
else
do
NewWidth=_ScaleSide(ImageWidth,ImgScaleW)
NewHeight=_ScaleSide(ImageHeight,ImgScaleH)
end
select
when ImageInfoFmt='WH' then
ImageReturn='width="' || NewWidth || '" height="' || NewHeight || '"'
when ImageInfoFmt='W,H' then
ImageReturn=NewWidth|| ',' ||NewHeight
when ImageInfoFmt='H#' then
ImageReturn=NewHeight
when ImageInfoFmt='W#' then
ImageReturn=NewWidth
otherwise
CryAndDie('Invalid image format of "' || ImageInfoFmt || '" specified!')
end
if ImageCacheKey<> '' then
call value ImageCacheKey,ImageReturn
return(ImageReturn)

CheckFileInfo:
parse arg iFile,iType,iId,iExpected
if iId==iExpected then
return
call FileClose iFile
Line1='"' || iFile || '" does not appear to be a "' || iType || '" file.'
Line2='It is ' || FileQuerySize(iFile) || ' bytes long. '
if iId=='' then
Line2=Line2|| 'This appears to be too short.'
else
Line2=Line2|| 'The ID is "x' || c2x(iId) || '" (expected "x' || c2x(iExpected) || '")'
CryAndDie(Line1,Line2)

_GetGifSize:
GifFormatId=left(charin(ImageFile,1,6),3)
call CheckFileInfo ImageFile, 'GIF', GifFormatId, 'GIF'
WidthLow=charin(ImageFile,,1)
WidthHigh=charin(ImageFile,,1)
ImageWidth=c2d(WidthHigh||WidthLow)
HeightLow=charin(ImageFile,,1)
HeightHigh=charin(ImageFile,,1)
ImageHeight=c2d(HeightHigh||HeightLow)
call FileClose ImageFile
return(_GetSizeTags())

_GetPngSize:
PngFormatId=charin(ImageFile,1,8)
call CheckFileInfo ImageFile, 'PNG', PngFormatId, '89'x || 'PNG' || '0D 0A 1A 0A'x
PngFormatId=charin(ImageFile,,4)
PngFormatId=charin(ImageFile,,4)
call CheckFileInfo ImageFile, 'PNG', PngFormatId, 'IHDR'
ImageWidth=c2d(charin(ImageFile,,4))
ImageHeight=c2d(charin(ImageFile,,4))
call FileClose ImageFile
return(_GetSizeTags())

_R4:
return(substr(arg(1),4,1)||substr(arg(1),3,1)||substr(arg(1),2,1)||substr(arg(1),1,1))

_GetBmpSize:
BmpFormatId=charin(ImageFile,1,2)
call CheckFileInfo ImageFile, 'BITMAP', BmpFormatId, 'BM'
BmpIgnore=charin(ImageFile,,16)
ImageWidth=c2d(_R4(charin(ImageFile,,4)))
ImageHeight=c2d(_R4(charin(ImageFile,,4)))
call FileClose ImageFile
return(_GetSizeTags())

_GetJpgSize:
FileType=c2x(Charin(ImageFile,1,2))
call CheckFileInfo ImageFile, 'JPEG', FileType, "FFD8"
NxtSeg=3
ImageHeight="IMAGEHEIGHT"
Type=''
do while(Type<> "D9") & (NxtSeg <> -1) & (Imageheight = "IMAGEHEIGHT")
NxtSeg=_ReadJpgSegment(NxtSeg)
end
call FileClose ImageFile
return(_GetSizeTags())

_ReadJpgSegment:
SegPos=arg(1)
Marker=c2x(charIn(ImageFile,SegPos))
if Marker<> "FF" then
return(-1)
Type=c2x(charIn(ImageFile))
Res=SegPos+2
select
when Type="01" | Type >= "D0" & Type <= "D9" then
SegmentLength=0
otherwise
SegmentLength=c2d(CharIn(ImageFile,,2))
End
Res=Res+SegmentLength
if Type="C0" | Type = "C2" then
do
Imagebps=c2d(CharIn(ImageFile))
ImageHeight=c2d(CharIn(ImageFile,,2))
ImageWidth=c2d(CharIn(ImageFile,,2))
end
return(Res)

GetImageHeightWidth:call TRACE "OFF"
parse arg ImageFile,ImageScaleW,ImageScaleH,ImageInfoFmt,ImageNoCache
if ImageScaleW='' then
ImageScaleW='100%'
if ImageScaleH='' then
ImageScaleH='?'
if ImageInfoFmt="" then
ImageInfoFmt='WH'
ImageInfoFmt=translate(ImageInfoFmt)
if OptionDebugOn='Y' then
call DBG_EVALUATE 'GetImageHeightWidth("' || ImageFile || '", "' || ImageScaleW || '", "' || ImageScaleH || '", "' || ImageInfoFmt || '")'
if ImageNoCache='Y' then
ImageCacheKey=''
else
do
ImageCacheKey='I_' || ImageFile || '_w' || c2x(ImageScaleW) || '_h' || c2x(ImageScaleH) || '_f' ||c2x(ImageInfoFmt)
ImageCacheKey=GetId("IMAGEHW", 'MAXCHARS',ImageCacheKey,,200)
if symbol(ImageCacheKey)='VAR' then
do
if OptionDebugOn='N' then
return(value(ImageCacheKey))
else
do
SizeString=value(ImageCacheKey)
call DBG_EVALUATE 'Returning "' || SizeString || '" (from cache)'
return(SizeString)
end
end
end
DotPos=lastpos('.',ImageFile)
if DotPos=0 then
CryAndDie('Unknown graphic file type on "' || ImageFile || '".')
ImageExtn=translate(substr(ImageFile,DotPos+1))
if FileQueryExists(ImageFile)='' then
do
CryAndDie('Graphic file "' || ImageFile || '" does not exist.')
return('')
end
call DBGIND 1
select
when ImageExtn='GIF' then
SizeString=_GetGifSize()
when ImageExtn='PNG' then
SizeString=_GetPngSize()
when ImageExtn='BMP' then
SizeString=_GetBmpSize()
when ImageExtn='JPG' | ImageExtn = 'JPEG' then
SizeString=_GetJpgSize()
otherwise
CryAndDie('Currently only support "GIF", "JPEG", "PNG" & "BMP" files.')
end
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Returning "' || SizeString || '"'
call DBGIND-1
return(SizeString)

ToUpperCase:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ToUpperCase()'
call GetUserLcCfg
return(translate(arg(1),CfgUpper,CfgLower))

ToLowerCase:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ToLowerCase()'
call GetUserLcCfg
return(translate(arg(1),CfgLower,CfgUpper))

EnsureFileHasCorrectCase:call TRACE "OFF"
cFileI=arg(1)
if OptionTranslateFileNames='N' then
return(cFileI)
if OptionTranslateFileNames='UPPER' then
cFileO=translate(cFileI)
else
cFileO=translate(cFileI,LowerCase,UpperCase)
if OptionDebugOn='Y' then
do
if cFileI<>cFileO then
do
call DBG_EVALUATE 'A files case was adjusted'
call DBGIND 1
call DBG_EVALUATE 'FROM: "' || cFileI || '"'
call DBG_EVALUATE '  TO: "' || cFileO || '"'
call DBGIND-1
end
end
return(cFileO)

GetAmPmTime:call TRACE "OFF"
return(GetAmPmTimeFromHhMmSs(time('N'),arg(1),arg(2)))

GetAmPmTimeFromHhMmSs:call TRACE "OFF"
parse arg kd!PT,kd!AddSS,kd!AmPm
if kd!AmPm='' then
kd!AmPm='am;pm'
parse var kd!AmPm kd!AmTxt ';' kd!PmTxt
if pos(':',kd!PT)=0 then
parse var kd!PT kd!HH 3 kd!MM 5 kd!SS
else
parse var kd!PT kd!HH ':' kd!MM ':' kd!SS
if kd!HH>=12 then
kd!AmPm=kd!PmTxt
else
kd!AmPm=kd!AmTxt
if kd!HH>12 then
kd!HH=kd!HH-12
kd!HH=kd!HH+0
kd!MM=right(kd!MM,2, '0')
if kd!AddSS='' then
do
if kd!SS='' then
kd!AddSS='N'
else
kd!AddSS='Y'
end
if kd!AddSS='N' then
kd!SS=''
else
kd!SS=':' || right(kd!SS, 2, '0')
kd!T=kd!HH|| ':' ||kd!MM||kd!SS||kd!AmPm
return(kd!T)

AddCommasToDecimalNumber:procedure;call TRACE "OFF"
ld!Str=strip(arg(1))
if pos(',',ld!Str)<>0 then
return(ld!Str)
ld!P=pos('.',ld!Str)
if ld!P=0 then
ld!After=''
else
do
if ld!P=1 then
return("0" ||ld!Str)
ld!After=substr(ld!Str,ld!P+1)
ld!Str=left(ld!Str,ld!P-1)
end
ld!Str=reverse(ld!Str)
ld!With=""
do while length(ld!Str)>3
ld!With=ld!With||left(ld!Str,3)|| ','
ld!Str=substr(ld!Str,4)
end
ld!With=ld!With||ld!Str
ld!With=reverse(ld!With)
if ld!After<> '' then
ld!With=ld!With|| '.' ||ld!After
return(ld!With)

PadString:procedure;call TRACE "OFF"
parse arg TheString,TheMaxSize,PadType
StringSize=length(TheString)
if StringSize>=TheMaxSize then
return(TheString)
SpacesRequired=TheMaxSize-StringSize
if PadType='R' then
return(copies(' ',SpacesRequired)||TheString)
else
do
if PadType<> 'C' then
return(TheString||copies(' ',SpacesRequired))
else
do
SpacesOnLeft=SpacesRequired%2
return(copies(' ', SpacesOnLeft) || TheString || copies(' ',SpacesRequired-SpacesOnLeft))
end
end

BreakAt:call TRACE "OFF"
parse arg md!Max,md!Str,md!Chars,md!With
if md!Chars=='' then
md!Chars=CfgMacro("PPWIZARD_BREAKAT_AFTER", './:#')
if md!With='' then
md!With=CfgMacro("PPWIZARD_BREAKAT_USE",   '<br>')
baPos=pos('-',md!Max)
if baPos=0 then
baMinSize=md!Max%3
else
parse var md!Max baMinSize'-'md!Max
md!Rc=''
do while length(md!Str)>md!Max
md!Left=left(md!Str,md!Max)
md!Str=substr(md!Str,md!Max+1)
md!BestPos=0
md!CharList=md!Chars
do while md!CharList\==''
md!ThisChar=left(md!CharList,1)
md!CharList=substr(md!CharList,2)
md!Pos=lastpos(md!ThisChar,md!Left)
if md!Pos>md!BestPos then
do
md!BestPos=md!Pos
end
end
if md!Rc<> '' then
md!Rc=md!Rc||md!With
if md!BestPos=0 then
md!Rc=md!Rc||md!Left
else
do
md!Rc=md!Rc||left(md!Left,md!BestPos)
md!Str=substr(md!Left,md!BestPos+1)||md!Str
end
end
if md!Rc<> '' then
return(md!Rc||md!With||md!Str)
else
return(md!Rc||md!Str)

Wbr:call TRACE "OFF"
parse arg nd!Str,nd!Chars,nd!Use,nd!Min,nd!Max
if nd!Use='' then
nd!Use=CfgMacro("PPWIZARD_WBR_USE", '<wbr>')
if nd!Chars=='' then
nd!Chars=CfgMacro("PPWIZARD_WBR_AFTER", '/\?&_')
if nd!Min='' then
nd!Min=CfgMacro("PPWIZARD_WBR_MIN",0)
if nd!Max='' then
nd!Max=CfgMacro("PPWIZARD_WBR_MAX",999999)
nd!Rc=''
nd!Start=1
do while nd!Str\==''
nd!Pos=verify(nd!Str,nd!Chars, 'M',nd!Start)
if nd!Pos=0 then
do
if length(nd!Str)<=nd!Max then
leave
else
nd!Pos=nd!Max
end
if nd!Pos<nd!Min then
do
nd!Start=nd!Pos+1
iterate
end
if nd!Pos>nd!Max then
nd!Pos=nd!Max
nd!Rc=nd!Rc||left(nd!Str,nd!Pos)||nd!Use
nd!Str=substr(nd!Str,nd!Pos+1)
nd!Start=1
end
nd!Rc=nd!Rc||nd!Str
return(nd!Rc)

MacroGet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'MacroGet()'
GotValue=GetDefineContents(arg(1))
if OptionDebugOn='Y' then
call DBG_EVALUATE 'MacroGet("' || arg(1) || '") = ' ||DebugRightArrow||GotValue||DebugLeftArrow
return(GotValue)

Defined:call TRACE "OFF"
if OptionDebugOn='N' then
return(MacroExists(arg(1),arg(2)))
else
do
call DBG_EVALUATE 'Defined("' || arg(1) || '")?'
call DBGIND 1
od!Yn=MacroExists(arg(1),arg(2))
call DBG_EVALUATE 'Returning: ' ||od!Yn
call DBGIND-1
return(od!Yn)
end

DataSave:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'DataSave()'
parse arg StoreApp,StoreKey,StoreData
call _valueS "DSAP_" || c2x(StoreApp) || '.DSKY_' ||c2x(StoreKey),StoreData
return

DataGet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'DataGet()'
parse arg StoreApp,StoreKey,StoreDefault
DataVarName="DSAP_" || c2x(StoreApp) || '.DSKY_' ||c2x(StoreKey)
if symbol(DataVarName)<> 'VAR' then
return(StoreDefault)
else
return(_valueG(DataVarName))

UrlEncode:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'UrlEncode()'
UrlIn=arg(1)
ueCmd=translate(arg(2))
SpaceToPlus='N'
select
when ueCmd='TO%' then
do
UrlBadChars=arg(3)
if UrlBadChars=='' then
UrlBadChars='+<>%"/?# '
end
when ueCmd='TO%EXCEPT' then
do
UrlOkChars=arg(3)
if UrlOkChars=='' then
UrlOkChars=CharsLUN|| '-._'
UrlBadChars=space(translate(xrange('00'x, 'FF'x), '',UrlOkChars),0)
if pos(' ',UrlOkChars)=0 then
UrlBadChars=UrlBadChars|| ' '
end
when ueCmd='ENCODEALL' then
UrlBadChars=xrange('00'x, 'FF'x)
otherwise
CryAndDie('Invalid UrlEncode() command of "' || ueCmd || '"')
end
UrlOut=''
UrlCount=length(UrlIn)
do CharPosn=1 to UrlCount
ThisChar=substr(UrlIn,CharPosn,1)
if pos(ThisChar,UrlBadChars)=0 then
UrlOut=UrlOut||ThisChar
else
do
if ThisChar==' ' & SpaceToPlus = 'Y' then
UrlOut=UrlOut|| '+'
else
UrlOut=UrlOut|| '%' || right(c2x(ThisChar), 2, '0')
end
end
return(UrlOut)

UrlDecode:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'UrlDecode()'
parse arg UrlIn,udCmd
UrlPlusIsSpace='Y'
if udCmd<> '' then
do
if translate(udCmd)='LEAVE+' then
UrlPlusIsSpace='N'
else
CryAndDie('Invalid UrlDecode() command of "' || udCmd || '"')
end
UrlOut=''
CharPosn=1
UrlCount=length(UrlIn)
do while CharPosn<=UrlCount
ThisChar=substr(UrlIn,CharPosn,1)
CharPosn=CharPosn+1
if UrlPlusIsSpace<> 'N' & ThisChar = '+' then
ThisChar=' '
else
do
if ThisChar='%' then
do
ThisChar=substr(UrlIn,CharPosn,2)
CharPosn=CharPosn+2
if CharPosn>(UrlCount+1)then
CryAndDie('Invalid URL encoding of "%' || strip(ThisChar) || '" at end of URL')
ThisChar=x2c(ThisChar)
end
end
UrlOut=UrlOut||ThisChar
end
return(UrlOut)

Warning:call TRACE "OFF"
call OutputWarningToScreen arg(1),arg(2)
return(0)

Error:call TRACE "OFF"
call CryAndDie 'Rexx code called Error()', '------------------------',arg(1),arg(2),arg(3),arg(4),arg(5),arg(6),arg(7),arg(8),arg(9),arg(10)
return(0)

Info:call TRACE "OFF"
call OutputInformationToScreen arg(1)
return(0)

DieIfIoErrorOccurred:call TRACE "OFF"
pd!F=arg(1)
if OptionDebugOn='Y' then
call DBG_EVALUATE 'DieIfIoErrorOccurred("' || pd!F || '")'
FileState=FileState(pd!F)
if FileState='READY' then
return
IoReason=FileDescription(pd!F)
if IoReason\=='NOTREADY:EOF' then
do
if RexWhich='REGINA' & IoReason = '' then
do
if OptionDebugOn='Y' then
do
call DBG 'DieIfIoErrorOccurred(): Bug first reported to Mark Hessling 3/10/99 for 0.08h beta'
call DBGIND 1
call DBG 'I/O failure on "' || pd!F || '" (' || IoReason || ').'
call DBGIND-1
end
return
end
call _FileClose pd!F
call CryAndDie 'I/O failure on "' || pd!F || '" (' || IoReason || ').'
end
return

_ValidateIcLevel:
qd!L=arg(1)
if qd!L='' then
qd!L=IncludeLevel
if datatype(qd!L, 'WholeNumber')<>1 then
return(0)
if qd!L<1|qd!L>IncludeLevel then
return(0)
return(qd!L)

InputComponentLevel:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'InputComponentLevel()'
rd!L=_ValidateIcLevel(arg(1))
if rd!L=0 then
return('')
else
return(IncludeFileName.rd!L)

InputComponentLineLevel:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'InputComponentLineLevel()'
sd!L=_ValidateIcLevel(arg(1))
if sd!L=0 then
return('')
else
return(GetLineNumber4Level(sd!L))

GetLineNumber4Level:
td!L=arg(1)
if td!L=IncludeLevel then
return(IncludeLineNumber)
else
return(_IncludeLineNumber.td!L)

FileSlashReduction:call TRACE "OFF"
parse arg ud!F,ud!M
if ud!M='' then
ud!M=OptionFileSR
call DBG 'FileSlashReduction(' || ud!F || ') in "' || ud!M || '" mode'
call DBGIND 1
ud!M=translate(ud!M)
if ud!M<> 'NONE' then
do
if ud!M='UNC' then
do
parse var ud!F ud!P+1 ud!F
end
else
do
if ud!M<> 'ALL' then
CryAndDie('Invalid file slash reduction mode of "' || ud!M || '"')
else
do
ud!P=''
end
end
do until ud!PC=ReplaceCount
ud!PC=ReplaceCount
ud!F=ReplaceString(ud!F,RexDirChar||RexDirChar,RexDirChar)
end
ud!F=ud!P||ud!F
end
call DBG 'Returning "' || ud!F || '"'
call DBGIND-1
return(ud!F)

GenerateFileName:call TRACE "OFF"
parse arg vd!SrcFile,vd!EdtMsk
if OptionDebugOn='Y' then
do
call DBG 'GenerateFileName(' || vd!SrcFile || ') using "' || vd!EdtMsk || '"'
call DBGIND 1
call DBG 'Current directory is "' || GetCurrentDirectory() || '"'
end
ShortName=_filespec('name',vd!SrcFile)
ShortNameNE=_filespec('withoutextn',ShortName)
InputPath=_filespec('location',vd!SrcFile)
vd!Full=ReplaceString(vd!EdtMsk, "?",InputPath)
vd!Full=ReplaceString(vd!Full, "*.*",ShortName)
vd!Full=ReplaceString(vd!Full, "*",ShortNameNE)
vd!Full=ReplaceString(vd!Full, "{$PATH}",InputPath)
vd!Full=ReplaceString(vd!Full, "{$BASE}",ShortNameNE)
vd!Full=ReplaceString(vd!Full, "{$SHORT}",ShortName)
vd!Full=ReplaceString(vd!Full, "{$FULL}",vd!SrcFile)
vd!Full=ReplaceString(vd!Full, "{$OutputDir}",OptionOutputDefDir)
if pos('{$path}',vd!Full)<>0 then
do
call DBGIND 1
vd!Bd=BaseDir4CurrentInputFile
call DBG '{$path} found, base directory is "' || vd!Bd || '"'
call ValidateBaseDirUse vd!BD,vd!SrcFile
vd!SrcDir=_filespec('Location',vd!SrcFile)
vd!RelDir=substr(vd!SrcDir,length(vd!Bd)+1)
call DBG '{$path} = "' || vd!RelDir || '"'
vd!Full=ReplaceString(vd!Full, "{$path}",vd!RelDir)
call DBGIND-1
end
vd!Full=FileSlashReduction(vd!Full)
vd!Full=EnsureFileHasCorrectCase(vd!Full)
if OptionDebugOn='Y' then
call DBG 'Generated Name = "' || vd!Full || '"'
if OptionDebugOn='Y' then
call DBGIND 1
call MakeDirectoryTree _filespec('drive', vd!Full) || _filespec('path',vd!Full)
if OptionDebugOn='Y' then
call DBGIND-2
return(vd!Full)

ProcessNext:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ProcessNext()'
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=arg(1)
else
IncludeLoopMemBufferNextLine=arg(1)||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=arg(1)
else
IncludeMemBufferNextLine=arg(1)||MarksNewLine||IncludeMemBufferNextLine
end
end
return

Tabs2Spaces:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Tabs2Spaces()'

ExpandTabs:
parse arg t2sRightBit,t2sTabWidth
if pos('09'x,t2sRightBit)=0 then
return(t2sRightBit)
t2sLeftBit=''
t2sLeftBitL=0
t2sTabPos=pos('09'x,t2sRightBit)
if t2sTabWidth='' then
t2sTabWidth=8
do while t2sTabPos<>0
t2sLeftBit=t2sLeftBit||left(t2sRightBit,t2sTabPos-1)
t2sLeftBitL=t2sLeftBitL+(t2sTabPos-1)
Spaces4Tab=t2sTabWidth-((t2sLeftBitL)//t2sTabWidth)
t2sLeftBit=t2sLeftBit||copies(' ',Spaces4Tab)
t2sLeftBitL=t2sLeftBitL+Spaces4Tab
t2sRightBit=substr(t2sRightBit,t2sTabPos+1)
t2sTabPos=pos('09'x,t2sRightBit)
end
return(t2sLeftBit||t2sRightBit)

RexxVarDefined:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'RexxVarDefined()'
vsValue=symbol(arg(1))
if vsValue='BAD' then
do
vsLength=length(arg(1))
if symbol(copies('A', vsLength)) <> 'BAD' then
Reason=''
else
Reason='A symbol length of "' || vsLength || ' bytes seems to be too long for your rexx interpreter!'
CryAndDie('RexxVarDefined()', 'Invalid symbol of "' || arg(1) || '" passed.',Reason)
end
if vsValue='VAR' then
return(1)
else
return(0)

ReplaceCurlyHexCodes:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ReplaceCurlyHexCodes()'
Before=arg(1)
RightBit=Before
LeftBit=''
StartPos=pos('{x',RightBit)
do while StartPos<>0
Codes2=substr(RightBit,StartPos+2,2)
if datatype(Codes2, 'X') <> 1 | substr(RightBit, StartPos+4, 1) <> '}' then
do
LeftBit=LeftBit||left(RightBit,StartPos+1)
RightBit=substr(RightBit,StartPos+2)
end
else
do
LeftBit=LeftBit||left(RightBit,StartPos-1)||x2c(Codes2)
RightBit=substr(RightBit,StartPos+5)
end
StartPos=pos('{x',RightBit)
end
LeftBit=LeftBit||RightBit
if OptionDebugOn='Y' then
do
if Before<>LeftBit then
call DebugOutputAfterReplacement LeftBit, '{xXX}'
end
return(LeftBit)

RandomString:call TRACE "OFF"
parse arg RsString,RsPickFrom
if RsPickFrom='' then
RsPickFrom=DecimalDigits||UpperCase
RsMax=length(RsPickFrom)
QPos=pos('?',RsString)
do while QPos<>0
RsString=left(RsString,QPos-1)||substr(RsPickFrom,random(1,RsMax),1)||substr(RsString,QPos+1)
QPos=pos('?',RsString)
end
return(RsString)

_FindFileInPathList:
parse arg wd!Look4,wd!PathList
call DBGIND 1
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Searching for "' || wd!Look4 || '" in "' || wd!PathList || '"'
if RexSystemOpSys="UNIX" then
wd!SepChar=':'
else
wd!SepChar=';'
wd!Found=''
do while wd!PathList<> ''
parse var wd!PathList wd!Path (wd!SepChar) wd!PathList
if right(wd!Path,1)<>RexDirChar then
wd!Path=wd!Path||RexDirChar
wd!Found=_FileQueryExists(wd!Path||wd!Look4)
if wd!Found<> '' then
leave
end
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Found "' || wd!Found || '"'
call DBGIND-1
return(wd!Found)

FindFileInPath:call TRACE "OFF"
parse arg xd!Look4,xd!LookIn
if RexSystemOpSys="UNIX" then
xd!SepChar=':'
else
xd!SepChar=';'
if OptionDebugOn='Y' then
call DBG_EVALUATE 'FindFileInPath(): Looking for "' || xd!Look4 || '" in "' || xd!LookIn || '"'
call DBGIND 1
xd!Searched=''
do while xd!LookIn<> ''
parse var xd!LookIn xd!ThisBit (xd!SepChar) xd!LookIn
if xd!ThisBit='' then
iterate
xd!Left1=left(xd!ThisBit,1)
select
when xd!Left1='*' then
do
xd!LookIn=GetEnv(substr(xd!ThisBit,2))||xd!SepChar||xd!LookIn
end
when xd!Left1='+' then
do
xd!Comb=substr(xd!ThisBit,2)
xd!Mask=xd!Comb
if right(xd!Mask,1)<>RexDirChar then
xd!Mask=xd!Mask||RexDirChar
xd!Mask=xd!Mask|| '*.*'
xd!List.0=0
call Dirs4Mask xd!Mask, 'xd!List', 'Y'
do xd!Index=1 to xd!List.0
xd!Comb=xd!Comb||xd!SepChar||xd!List.xd!Index
end
xd!LookIn=xd!Comb||xd!SepChar||xd!LookIn
end
otherwise
do
if xd!Searched='' then
xd!Searched=xd!ThisBit
else
xd!Searched=xd!Searched||xd!SepChar||xd!ThisBit
end
end
end
xd!Found=_FindFileInPathList(xd!Look4,xd!Searched)
if xd!Found<> '' then
xd!Found=FileQueryExists(xd!Found)
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Result: "' || xd!Found || '"'
call DBGIND-1
return(xd!Found)

IncludePath:call TRACE "OFF"
yd!P=arg(1)
if yd!P='' then
OptionIncludePathCnt=0
else
do
OptionIncludePathCnt=OptionIncludePathCnt+1
OptionIncludePath.OptionIncludePathCnt=yd!P
end
return

FindFile:call TRACE "OFF"
parse arg zd!Look4,zd!Die
zd!Found=''
if OptionDebugOn='Y' then
call DBG_EVALUATE 'FindFile(): Looking for "' || zd!Look4 || '"'
call DBGIND 1
if zd!Found='' then
do
call DBG_EVALUATE 'Looking in current directory'
zd!Found=FileQueryExists(zd!Look4)
end
if zd!Found='' then
do
if symbol("InputFileFull") = 'VAR' then
do
call DBG_EVALUATE 'Looking in same directory the input file "' || InputFileFull || '"'
zd!Found=_filespec('Location',InputFileFull)||zd!Look4
if FileQueryExists(zd!Found)='' then
zd!Found=''
end
end
if zd!Found='' then
do
do zd!Index=1 to OptionIncludePathCnt until zd!Found<> ''
zd!Found=FindFileInPath(zd!Look4,OptionIncludePath.zd!Index)
end
end
if zd!Found='' then
zd!Found=FindFileInPath(zd!Look4, '*PPWIZARD_INCLUDE')
if zd!Found='' then
zd!Found=FindFileInPath(zd!Look4, '*INCLUDE')
if zd!Found='' then
do
call DBG_EVALUATE 'Looking in same directory as PPWIZARD'
parse source . . zd!Found
zd!Found=_filespec('Location',zd!Found)||zd!Look4
if FileQueryExists(zd!Found)='' then
zd!Found=''
end
if zd!Found<> '' then
zd!Found=FileQueryExists(zd!Found)
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Result: "' || zd!Found || '"'
if zd!Found='' then
do
if zd!Die<> '' then
do
if zd!Die='!' then
zd!T=''
else
zd!T=zd!Die|| ' '
CryAndDie('The ' || zd!T || 'file "' || zd!Look4 || '" could not be found!')
end
end
call DBGIND-1
return(zd!Found)

_SysSearchPath:call TRACE "OFF"
return(FindFileInPath(arg(2), '*' ||arg(1)))

SSTRIP:call TRACE "OFF"
parse arg ae!S,ae!M,ae!C
if ae!M=='' then
ae!M='B'
if ae!C=='' then
ae!C='00'x
ae!S=translate(ae!S, '', ae!C, ' ')
return(strip(ae!S,ae!M))

Add2:call TRACE "OFF"
parse arg be!V,be!S
if be!S<> '' then
Add2Stem=be!S|| '.'
if Add2Stem='' then
CryAndDie("Add to which array?")
be!CV=Add2Stem|| '0'
if symbol(be!CV)<> 'VAR' then
be!C=0
else
be!C=value(be!CV)
be!C=be!C+1
call value Add2Stem||be!C,be!V
call value be!CV,be!C
return(be!C)

OptionGet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'OptionGet()'
call DBGIND 1
ce!Ans=OptionGetValue(arg(1))
call DBGIND-1
return(ce!Ans)

OptionSet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'OptionSet()'
call DBGIND 1
call OptionSetValue arg(1),arg(2)
call DBGIND-1
return

MakeWebLinks:call TRACE "OFF"
parse arg de!R,de!ProtU,de!T,de!CS
if de!ProtU='' then
do
de!AllProt=MakeWebLinks(de!R, 'http',de!T,de!CS)
de!AllProt=MakeWebLinks(de!AllProt, 'https',de!T,de!CS)
de!AllProt=MakeWebLinks(de!AllProt, 'ftp',de!T,de!CS)
return(de!AllProt)
end
de!Prot=de!ProtU|| '://'
de!Pos=pos(de!Prot,de!R)
if de!Pos=0 then
return(de!R)
if de!ProtU='ftp' then
de!Valid=_ValCharsFtp
else
de!Valid=_ValCharsHttp
de!CS1=left(de!CS,1)
if de!CS<> "" then
do
select
when de!CS1='+' then de!Valid=de!Valid||SUBSTR(de!CS,2)
otherwise de!Valid=de!CS
end
end
de!ProtL=length(de!Prot)
if de!T='' then
de!T='<a href="{URL}">{URL}</a>'
de!L=''
do until de!Pos=0
de!L=de!L||left(de!R,de!Pos-1)
de!R=substr(de!R,de!Pos)
de!Pos=verify(de!R,de!Valid, 'N')
if de!Pos=0 then
do
de!Url=de!R
de!R=''
end
else
do
de!Url=left(de!R,de!Pos-1)
de!R=substr(de!R,de!Pos)
end
de!Insert=ReplaceString(de!T, "{URL}",de!Url)
de!Insert=ReplaceString(de!Insert, "{URL-}",substr(de!Url,de!ProtL+1))
de!L=de!L||de!Insert
de!Pos=pos(de!Prot,de!R)
end
return(de!L||de!R)

TimeStamp:call TRACE "OFF"
parse arg ee!CmdList,ee!Ts
ee!AddSec=0
do while ee!CmdList<> ''
parse var ee!CmdList ee!Cmd ee!CmdList
ee!Unit=translate(right(ee!Cmd,1))
ee!Units=left(ee!Cmd,length(ee!Cmd)-1)
select
when ee!Unit='W' then
ee!CmdSec=ee!Units*604800
when ee!Unit='D' then
ee!CmdSec=ee!Units*86400
when ee!Unit='H' then
ee!CmdSec=ee!Units*3600
when ee!Unit='M' then
ee!CmdSec=ee!Units*60
when ee!Unit='S' then
ee!CmdSec=ee!Units
otherwise
ee!CmdSec=ee!Cmd
end
ee!AddSec=ee!AddSec+ee!CmdSec
end
if ee!Ts='' then
do
ee!Bd=basedate()
ee!Sec=time('S')
end
else
do
ee!Bd=basedate(left(ee!Ts,8))
parse value substr(ee!Ts,9)with ee!HH+2 ee!MM+2 ee!SS
ee!Sec=(ee!HH*3600)+(ee!MM*60)+ee!SS
end
ee!TotSec=ee!Sec+ee!AddSec
ee!PlusDay=ee!TotSec%86400
ee!Sec=ee!TotSec//86400
ee!Date=Bd2Date(ee!Bd+ee!PlusDay)
ee!HH=right(ee!Sec%3600,2, '0')
ee!Sec=ee!Sec//3600
ee!MM=right(ee!Sec%60,2, '0')
ee!Sec=ee!Sec//60
ee!SS=right(ee!Sec,2, '0')
return(ee!Date||ee!HH||ee!MM||ee!SS)

ArraySplit:call TRACE "OFF"
parse arg fe!Stem,fe!Value,fe!Del,fe!Spaces,fe!KeepBlank
fe!Stem=fe!Stem|| '.'
if fe!Del=='' then
fe!Del=' '
if fe!Spaces='' then
fe!Spaces='B'
if right(fe!Value,1)==fe!Del then
fe!Value=fe!Value||fe!Del
fe!Cnt=0
do while fe!Value\==''
parse var fe!Value fe!Before (fe!Del) fe!Value
if fe!Spaces<> 'K' then
do
if fe!Spaces='BM' then
fe!Before=space(fe!Before)
else
fe!Before=strip(fe!Before,fe!Spaces)
end
if fe!Before='' then
do
if fe!KeepBlank<> 'Y' then
iterate
end
fe!Cnt=fe!Cnt+1
call _valueS fe!Stem||fe!Cnt,fe!Before
end
call _valueS fe!Stem|| '0',fe!Cnt
return(fe!Cnt)

ArrayRemoveDup:
parse arg ge!Stem,ge!MaxInRow
if ge!MaxInRow='' then
ge!MaxRpt=0
else
ge!MaxRpt=ge!MaxInRow-1
ge!Stem=ge!Stem|| '.'
ge!End=value(ge!Stem|| '0')
ge!DstI=0
ge!Last=''
ge!RepeatCnt=0
do ge!SrcI=1 to ge!End
ge!Value=value(ge!Stem||ge!SrcI)
if ge!Value\==ge!Last then
ge!RepeatCnt=0
else
do
if ge!SrcI<>1 then
do
ge!RepeatCnt=ge!RepeatCnt+1
if ge!RepeatCnt>ge!MaxRpt then
iterate
end
end
ge!Last=ge!Value
ge!DstI=ge!DstI+1
call value ge!Stem||ge!DstI,ge!Value
end
call value ge!Stem|| '0',ge!DstI
return(ge!DstI)

ArrayTranslate:
parse arg he!Stem,he!Spaces,he!Case
he!Stem=he!Stem|| '.'
if he!Spaces='' then
he!Spaces='B'
he!End=value(he!Stem|| '0')
do he!SrcI=1 to he!End
he!Value=value(he!Stem||he!SrcI)
if he!Spaces<> 'K' then
do
if he!Spaces='BM' then
he!Value=space(he!Value)
else
he!Value=strip(he!Value,he!Spaces)
end
if he!Case<> '' then
do
if he!Case='L' then
he!Value=ToLowerCase(he!Value)
else
he!Value=ToUpperCase(he!Value)
end
call value he!Stem||he!SrcI,he!Value
end
return(he!End)

ReverseArray:

ArrayReverse:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ReverseArray()'
riArray=translate(arg(1))|| '.'
riCount=_valueG(riArray||0)
riHalfWay=riCount%2
do riFrom=1 to riHalfWay
riTo=(riCount-riFrom)+1
riTemp=_valueG(riArray||riFrom)
call _valueS riArray||riFrom,_valueG(riArray||riTo)
call _valueS riArray||riTo,riTemp
end
return(riCount)

MakeDirectoryTree:call TRACE "OFF"
parse arg ie!Tree,ie!Die
if ie!Die='' then
ie!Die='N'
if right(ie!Tree,1)=RexDirChar then
ie!Tree=left(ie!Tree,length(ie!Tree)-1)
if ie!Tree='' then
return(0)
if OptionDebugOn='Y' then
do
call DBG 'MakeDirectoryTree("' || ie!Tree || '")'
call DBGIND 1
end
if DirQueryExists(ie!Tree)<> '' then
do
if OptionDebugOn='Y' then
do
call DBG 'Directory already exists (no need to make)'
call DBGIND-1
end
return(0)
end
if RexSystemOpSys="DOS" then
ie!Dq=''
else
ie!Dq='"'
if RexSystemOpSys="UNIX" then
MakeDirCmd='mkdir '
else
MakeDirCmd='md '
SearchFromPosn=1
do until SlashPosn=0
SlashPosn=pos(RexDirChar,ie!Tree,SearchFromPosn)
if SlashPosn<>1 then
do
if SlashPosn=0 then
MakeDir=ie!Tree
else
MakeDir=left(ie!Tree,SlashPosn-1)
DirBit=filespec('name',MakeDir)
if right(MakeDir,1)<> ':' & DirBit <> '.' & DirBit <> '..' then
do
if OptionDebugOn='N' then
call AddressCmd MakeDirCmd||ie!Dq||MakeDir||ie!Dq||AllCmdOutput2Nul()
else
do
TmpMkDirFile=RexGetTmpFileName('mdt?????.PPW')
call AddressCmd MakeDirCmd||ie!Dq||MakeDir||ie!Dq||RedirectStdOutAndErr2(TmpMkDirFile),TmpMkDirFile
if Rc=0 then
call DBG 'Made Directory "' || MakeDir || '"'
call _SysFileDelete TmpMkDirFile
end
end
end
SearchFromPosn=SlashPosn+1
end
if DirQueryExists(ie!Tree)<> '' then
ie!Rc=0
else
do
ie!Rc=3
ie!T='We failed to create the "' || ie!Tree || '" directory!'
if OptionDebugOn='Y' then
call DBG ie!T
if ie!Die<> 'N' then
CryAndDie(ie!T)
end
if OptionDebugOn='Y' then
call DBGIND-1
return(ie!Rc)

HhMmSs2Seconds:
parse value arg(1)with ie!HH+2 ie!MM+2 ie!SS
return((ie!HH*3600)+(ie!MM*60)+ie!SS)

AreFilesEqual:
parse arg je!F1,je!F2,je!Fuzz
if je!Fuzz='' then
je!Fuzz=0
call DBG 'AreFilesEqual?: "' || je!F1 || '" <-> "' || je!F2 || '" (Fuzziness of ' || je!Fuzz || ' seconds)'
call DBGIND 1
if FileQueryExists(je!F1)='' then
je!Rc='The file "' || je!F1 || '" does not exist.'
else
do
if FileQueryExists(je!F2)='' then
je!Rc='The file "' || je!F2 || '" does not exist.'
else
do
je!1s=stream(je!F1, 'c', 'query size')
je!2s=stream(je!F2, 'c', 'query size')
je!1t=GetFileTimeStamp(je!F1, 'Q')
je!2t=GetFileTimeStamp(je!F2, 'Q')
call DBG 'SRC: ' || je!1s || ' - ' ||je!1t
call DBG 'DST: ' || je!2s || ' - ' ||je!2t
if je!1s<>je!2s then
je!Rc='File sizes differ'
else
do
parse var je!1t je!1dd+8 je!1dt
parse var je!2t je!2dd+8 je!2dt
if je!1dd<>je!2dd then
je!Rc='Files created on different days'
else
do
je!Diff=abs(HhMmSs2Seconds(je!2dt)-HhMmSs2Seconds(je!1dt))
call DBG '     Files differ by ' || je!Diff || ' seconds'
if je!Diff>je!Fuzz then
je!Rc='Files differ by more than ' || je!Fuzz || ' seconds.'
else
je!Rc=''
end
end
end
end
call DBG 'Rc = "' || je!Rc || '"'
call DBGIND-1
return(je!Rc)

IsDestFileOlder:
parse arg ke!Src,ke!Dst,ke!Fuzz
if ke!Fuzz='' then
ke!Fuzz=0
call DBG 'IsDestFileOlder?: "' || ke!Src || '" <-> "' || ke!Dst || '" (Fuzziness of ' || ke!Fuzz || ' seconds)'
call DBGIND 1
if FileQueryExists(ke!Src)='' then
ke!Rc='The file "' || ke!Src || '" does not exist.'
else
do
if FileQueryExists(ke!Dst)='' then
ke!Rc='The file "' || ke!Dst || '" does not exist.'
else
do
ke!1t=GetFileTimeStamp(ke!Src, 'Q')
ke!2t=GetFileTimeStamp(ke!Dst, 'Q')
if ke!1t=-1|ke!2t=-1 then
ke!Do="Unexpected problem getiing time stamp info..."
else
do
parse var ke!1t ke!1dd+8 ke!1dt
parse var ke!2t ke!2dd+8 ke!2dt
if ke!1dd<>ke!2dd then
do
if ke!1t<=ke!2t then
ke!Rc=''
else
ke!Rc='Source file newer and created on different day'
end
else
do
ke!Diff=HhMmSs2Seconds(ke!2dt)-HhMmSs2Seconds(ke!1dt)
call DBG '     Files differ by ' || ke!Diff || ' seconds'
if abs(ke!Diff)<=ke!Fuzz then
ke!Rc=''
else
do
if ke!Diff>0 then
ke!Rc=''
else
ke!Rc='Source file is newer by more than ' || ke!Fuzz || ' seconds.'
end
end
end
end
end
call DBG 'Rc = "' || ke!Rc || '"'
call DBGIND-1
return(ke!Rc)

FileCopy:call TRACE "OFF"
parse arg le!Src,le!Dst,le!When,le!ContOnError
call DBG 'Copy "' || le!Src || '" to "' || le!Dst || '"?'
if FileQueryExists(le!Src)='' then
do
if le!ContOnError<> 'Y' then
CryAndDie('The FileCopy() source file "' || le!Src || '" does not exist...')
return(2)
end
call DBGIND 1
le!When=translate(le!When)
le!Do=''
select
when le!When='' then
le!Do='We always copy'
when left(le!When,5)='EQUAL' then
do
parse var le!When . ':' le!Fuzz
le!Do=AreFilesEqual(le!Src,le!Dst,le!Fuzz)
end
when left(le!When,5)='NEWER' then
do
parse var le!When . ':' le!Fuzz
le!Do=IsDestFileOlder(le!Src,le!Dst,le!Fuzz)
end
otherwise
CryAndDie('Unknown FileCopy() mode of "' || le!When || '"')
end
if le!Do<> '' then
call DBG 'Source will be copied: ' ||le!Do
else
do
call DBG 'The source does not need copying'
call DBGIND-1
return(0)
end
call AddInputFileToDependancyList le!Src
call AddOutputFileToDependancyList le!Dst
le!QSD='"' || le!Src || '" "' || le!Dst || '"'
select
when RexSystemOpSys="UNIX" then
le!CpyS='cp --force --preserve=timestamps --verbose'
when RexSystemOpSys="WIN32" then
do
if RexSystemOpSysREAL="WINNT" then
le!CpyS='copy /B'
else
le!CpyS='copy /Y /B'
end
when RexSystemOpSys="OS/2" then
le!CpyS='copy'
otherwise
le!CpyS='copy'
end
CopyCmd=le!CpyS|| ' ' ||le!QSD
TmpMkDirFile=RexGetTmpFileName('fc??????.PPW')
le!CpyRc=AddressCmd(CopyCmd||RedirectStdOutAndErr2(TmpMkDirFile),TmpMkDirFile)
if le!CpyRc=0 then
call DBG 'File successfully copied'
else
do
call DBG 'Copy failed'
if le!ContOnError<> 'Y' then
do
do le!i=1 to 5
le!L.le!i=linein(TmpMkDirFile)
end
call FileDelete TmpMkDirFile, 'N'
CryAndDie('File copy failed (Rc=' || le!CpyRc || ')!', 'From: "' || le!Src || '"', 'To  : "' || le!Dst || '"', "",le!L.1,le!L.2,le!L.3,le!L.4,le!L.5)
end
end
call FileDelete TmpMkDirFile, 'N'
call DBGIND-1
return(le!CpyRc)

QuoteAsRexxLit:call TRACE "OFF"
return( "'" || ReplaceString(arg(1), "'", "''") || "'" )

FormatNumber:call TRACE "OFF"
parse arg me!Numb,me!Fmt
if me!Fmt='' then
me!Fmt='%,%N'
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'FormatInt(' || me!Numb || ') - ' ||me!Fmt
call DBGIND 1
end
parse var me!Numb me!Int '.' me!Rem
me!Comma='N'
me!R=''
me!Pos=pos('%',me!Fmt)
me!LN=me!Numb
do while me!Pos<>0
me!R=me!R||left(me!Fmt,me!Pos-1)
me!C=substr(me!Fmt,me!Pos+1,1)
me!Fmt=substr(me!Fmt,me!Pos+2)
me!Div=0
me!N=''
me!Ac='N'
select
when me!C='?' then
do
parse var me!Fmt me!1 ',' me!2 ';' me!Fmt
if me!LN=1 then
me!N=me!1
else
me!N=me!2
end
when me!C='N' then
do
me!N=me!Numb
me!LN=me!N
me!Ac='Y'
end
when me!C='I' then
do
me!N=me!Int
me!LN=me!N
me!Ac='Y'
end
when me!C='1' then
me!N=left(me!Rem,1, '0')
when me!C='2' then
me!N=left(me!Rem,2, '0')
when me!C='3' then
me!N=left(me!Rem,3, '0')
when me!C='4' then
me!N=left(me!Rem,4, '0')
when me!C='R' then
me!N=me!Rem
when me!C='K' then
me!Div=1024
when me!C='k' then
me!Div=1000
when me!C='M' then
me!Div=1024*1024
when me!C='m' then
me!Div=1000*1000
when me!C=',' then
me!Comma='Y'
when me!C='_' then
me!N=' '
when me!C='%' then
me!N='%'
otherwise
me!N='%' ||me!C
end
if me!Div<>0 then
do
me!N=me!Numb%me!Div
parse value me!Numb/me!Div with . '.' me!Rem
me!Div=0
me!Ac='Y'
me!LN=me!N
end
if me!Ac='Y' then
do
if me!Comma='Y' then
me!N=AddCommasToDecimalNumber(me!N)
end
me!R=me!R||me!N
me!Pos=pos('%',me!Fmt)
end
me!R=me!R||me!Fmt
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'Returning: ' ||me!R
call DBGIND-1
end
return(me!R)

FormatTime:call TRACE "OFF"
parse arg ne!Fmt,ne!Ts,ne!Pre
if ne!Ts='' then
ne!Ts=TimeStamp()
if ne!Pre='' then
ne!Pre='FORMATTIME'
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'FormatTime(' || ne!Ts || ')'
call DBGIND 1
end
if ne!Fmt=='' then
ne!Fmt=CfgMacro(ne!Pre|| '_DEFAULT_TIME_FORMAT', '%c')
parse var ne!Ts ne!YYYY+4 ne!MM+2 ne!DD+2 ne!HH+2 ne!Min+2 ne!SS
ne!R=''
ne!Pos=pos('%',ne!Fmt)
do while ne!Pos<>0
ne!R=ne!R||left(ne!Fmt,ne!Pos-1)
ne!C=substr(ne!Fmt,ne!Pos+1,1)
ne!Fmt=substr(ne!Fmt,ne!Pos+2)
if ne!HH>12 then
ne!II=ne!HH-12
else
ne!II=ne!HH+0
if ne!II=0 then
ne!II=12
select
when ne!C='d' then
ne!N=ne!DD
when ne!C='e' then
ne!N=right(ne!DD+0,2, ' ')
when ne!C='#' then
ne!N=ne!DD+0
when ne!C='m' then
ne!N=ne!MM
when ne!C='y' then
ne!N=right(ne!YYYY,2)
when ne!C='Y' then
ne!N=ne!YYYY
when ne!C='H' then
ne!N=ne!HH
when ne!C='!' then
ne!N=ne!HH+0
when ne!C='I' then
ne!N=right(ne!II,2, '0')
when ne!C='@' then
ne!N=ne!II
when ne!C='M' then
ne!N=ne!Min
when ne!C='S' then
ne!N=ne!SS
when ne!C='j' then
ne!N=right(BaseDate(ne!Ts)-basedate(ne!YYYY|| '0101')+1, 3, '0')
when ne!C='$' then
ne!N=BaseDate(ne!Ts)-basedate(ne!YYYY|| '0101')+1
when ne!C='Z' then
ne!N=''
when ne!C='%' then
ne!N='%'
when ne!C='_' then
ne!N=' '
when ne!C='a' then
do
ne!N=CfgMacro(ne!Pre|| '_DAY_NAMES_SHORT',    'Mon Tue Wed Thu Fri Sat Sun')
ne!N=word(ne!N,(BaseDate(ne!Ts)//7)+1)
end
when ne!C='A' then
do
ne!N=CfgMacro(ne!Pre|| '_DAY_NAMES_LONG',    'Monday Tuesday Wednesday Thursday Friday Saturday Sunday')
ne!N=word(ne!N,(BaseDate(ne!Ts)//7)+1)
end
when ne!C='b' then
do
ne!N=CfgMacro(ne!Pre|| '_MONTH_NAMES_SHORT', 'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec')
ne!N=word(ne!N,ne!MM)
end
when ne!C='B' then
do
ne!N=CfgMacro(ne!Pre|| '_MONTH_NAMES_LONG',  'January February March April May June July August September October November December')
ne!N=word(ne!N,ne!MM)
end
when ne!C='p' then
do
if ne!HH>=12 then
ne!N=CfgMacro(ne!Pre|| '_PM_TEXT', 'pm')
else
ne!N=CfgMacro(ne!Pre|| '_AM_TEXT', 'am')
end
when ne!C='x' then
do
ne!N=CfgMacro(ne!Pre|| '_DATE_FORMAT', '%a %b %# %Y')
ne!Fmt=ne!N||ne!Fmt
ne!N=''
end
when ne!C='X' then
do
ne!N=CfgMacro(ne!Pre|| '_TIME_FORMAT', '%@:%M:%S%p')
ne!Fmt=ne!N||ne!Fmt
ne!N=''
end
when ne!C='c' then
do
ne!N=CfgMacro(ne!Pre|| '_DATE_TIME_FORMAT', '%x at %X')
ne!Fmt=ne!N||ne!Fmt
ne!N=''
end
when ne!C='D' then
do
ne!Fmt='%m/%d/%y' ||ne!Fmt
ne!N=''
end
when ne!C='v' then
do
ne!Fmt='%e-%b-%Y' ||ne!Fmt
ne!N=''
end
when ne!C='R' then
do
ne!Fmt='%H:%M' ||ne!Fmt
ne!N=''
end
when ne!C='r' then
do
ne!Fmt='%I:%M:%S%p' ||ne!Fmt
ne!N=''
end
when ne!C='T' then
do
ne!Fmt='%H:%M:%S' ||ne!Fmt
ne!N=''
end
otherwise
ne!N='%' ||ne!C
end
ne!R=ne!R||ne!N
ne!Pos=pos('%',ne!Fmt)
end
ne!R=ne!R||ne!Fmt
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'Returning: ' ||ne!R
call DBGIND-1
end
return(ne!R)

GetCurrentDirectory:call TRACE "OFF"
oe!Dir=DirGetCurrent()
if OptionDebugOn='Y' then
call DBG 'Current Directory = "' || oe!Dir || '"'
return(oe!Dir)

HtmlGeneratorTags:call TRACE "OFF"
parse arg pe!T,pe!G
if pe!G='Y' then
do
pe!R=OptionHtmlGeneratorTags
OptionHtmlGeneratorTags=pe!T
end
else
do
pe!R=HtmlGeneratorTags
HtmlGeneratorTags=pe!T
end
return(pe!R)

SortArray:

ArraySort:call TRACE "OFF"
if OptionDebugOn='Y' then
call DBG_EVALUATE 'ArraySort()'
parse arg qe!Array,qe!KeyFrom,qe!KeyTo,qe!Strict
qe!Array=translate(qe!Array)|| '.'
qe!Count=_valueG(qe!Array||0)
do qe!I=1 to qe!Count
qe!DATA.qe!I=_valueG(qe!Array||qe!I)
end
qe!DATA.0=qe!Count
if qe!KeyFrom=='' then
do
qe!SepKey='N'
call DBG_EVALUATE 'No separate key array'
end
else
do
qe!SepKey='Y'
qe!KEY.0=qe!DATA.0
if qe!KeyFrom=='@' then
do
if symbol('CfgLower') = 'VAR' then
do
call GetUserLcCfg
qe!KeyFrom=CfgLower
qe!KeyTo=CfgUpper
end
else
do
qe!KeyFrom=LowerCase
qe!KeyTo=UpperCase
end
end
if datatype(qe!KeyFrom, 'W')==1 then
do
call DBG_EVALUATE 'Separate key array built from columns ' || qe!KeyFrom || ' - ' ||qe!KeyTo
if qe!KeyTo='' then
qe!Length=0
else
qe!Length=qe!KeyTo-qe!KeyFrom
do qe!I=1 to qe!KEY.0
if qe!Length=0 then
do
qe!KEY.qe!I=substr(qe!DATA.qe!I,qe!KeyFrom)
end
else
do
qe!KEY.qe!I=substr(qe!DATA.qe!I,qe!KeyFrom,qe!Length)
end
end
end
else
do
if qe!KeyTo=='' then
do
qe!From=qe!KeyFrom|| '.'
call DBG_EVALUATE 'Separate key array built and passed by caller - ' ||qe!From
qe!D=qe!KEY.0
qe!K=_valueG(qe!From|| "0")
if qe!D<>qe!K then
CryAndDie("User supplied sort key array does not have correct number of elements!", "The data array has " || qe!D || " elements while the key array has " ||qe!K)
do qe!I=1 to qe!KEY.0
qe!KEY.qe!I=_valueG(qe!From||qe!I)
end
end
else
do
call DBG_EVALUATE 'Separate key array built by translation'
do qe!I=1 to qe!KEY.0
qe!KEY.qe!I=translate(qe!DATA.qe!I,qe!KeyTo,qe!KeyFrom)
end
end
end
end
qe!M=1
do while(9*qe!M+4)<qe!Count
qe!M=qe!M*3+1
end
do while qe!M>0
qe!K=qe!Count-qe!M
do qe!J=1 to qe!K
qe!Index1=qe!J
do while qe!Index1>0
qe!Index2=qe!Index1+qe!M
if qe!SepKey='N' then
do
qe!Val1=qe!DATA.qe!Index1
qe!Val2=qe!DATA.qe!Index2
end
else
do
qe!Val1=qe!Key.qe!Index1
qe!Val2=qe!Key.qe!Index2
end
if qe!Strict='Y' then
qe!Greater=qe!Val1>>qe!Val2
else
qe!Greater=qe!Val1>qe!Val2
if qe!Greater then
do
qe!Temp=qe!DATA.qe!Index1
qe!DATA.qe!Index1=qe!DATA.qe!Index2
qe!DATA.qe!Index2=qe!Temp
if qe!SepKey='Y' then
do
qe!Temp=qe!Key.qe!Index1
qe!Key.qe!Index1=qe!Key.qe!Index2
qe!Key.qe!Index2=qe!Temp
end
end
else
leave
qe!Index1=qe!Index1-qe!M
end
end
qe!M=qe!M%3
end
qe!Count=_valueG(qe!Array||0)
do qe!I=1 to qe!Count
call _valueS qe!Array||qe!I,qe!DATA.qe!I
end
Drop qe!DATA.
Drop qe!KEY.
return(qe!Count)

FileNameRelative:call TRACE "OFF"
parse arg re!F,re!Rel,re!If
if re!If='' then
re!If=2
if re!Rel='' then
re!Rel=DirGetCurrent()
re!S=RexDirChar
re!S2=re!S||re!S
if right(re!Rel,1)<>re!S then
re!Rel=re!Rel||re!S
if left(re!F,2)=re!S2|left(re!Rel,2)=re!S2 then
return(re!F)
re!P=compare(ufile(re!Rel),ufile(re!F))
if re!P=0|right(re!F,1)=re!S then
CryAndDie('The file "' || re!F || '" appears to be a directory!')
else
do
if re!P=1 then
return(re!F)
re!P=min(lastpos(re!S,re!Rel,re!P),lastpos(re!S,re!F,re!P))+1
re!Fc=substr(re!F,re!P)
re!Fr=substr(re!Rel,re!P)
re!Cnt=0
re!P=pos(re!S,re!Fr)
do while re!P<>0
re!Cnt=re!Cnt+1
re!P=pos(re!S,re!Fr,re!P+1)
end
re!Rel=copies('..' ||re!S,re!Cnt)||re!Fc
select
when datatype(re!If, 'W')then
do
if re!Cnt<=re!If then
re!F=re!Rel
end
when translate(re!If)='S' then
do
if length(re!Rel)<=length(re!F)then
re!F=re!Rel
end
otherwise
re!F=re!Rel
end
end
return(re!F)

Files4Mask:call TRACE "OFF"
parse arg se!Msk,se!Stm,se!Fol,se!Srt
if se!Fol='' then
se!Fol='N'
if se!Srt='' then
se!Srt='Y'
call DBG 'Files4Mask("' || se!Msk || '"): Follow Directories = "' || se!Fol || '"'
call DBGIND 1
call _valueS se!Stm|| '.0',0
if RexxHookGetFileList='' then
do
if se!Fol='N' then
se!Fol=''
else
se!Fol='S'
call DBG 'Using "_SysFileTree()" as "GetFileList" hook not used'
call _SysFileTree se!Msk,se!Stm, 'F' ||se!Fol
end
else
do
call DBG 'Not using "_SysFileTree()" as user specified use of "' || RexxHookGetFileList || '"'
glfTmpFile=RexGetTmpFileName('fm??????.PPW')
call MustDeleteFile glfTmpFile
glfLocn=_filespec('Location',se!Msk)
glfName=_filespec('Name',se!Msk)
call CallHook "GETFILELIST",,glfLocn,glfName,se!Fol,glfTmpFile
if FileQueryExists(glfTmpFile)='' then
CryAndDie('"' || RexxHookGetFileList || '" did not create the file list!')
glfLine=0
glfCount=0
do while lines(glfTmpFile)<>0
CurrentLine=linein(glfTmpFile)
glfLine=glfLine+1
if CurrentLine<> '' then
do
FullFile=FileQueryExists(CurrentLine)
if FullFile='' then
CryAndDie('"' || RexxHookGetFileList || '" specified an invalid file of "' || CurrentLine || '" on line #' ||glfLine)
glfCount=glfCount+1
call _valueS se!Stm|| '.' ||glfCount,CurrentLine
end
end
call FileClose glfTmpFile
call _valueS se!Stm|| '.0',glfCount
if OptionDebugOn='N' then
call MustDeleteFile glfTmpFile
end
if se!Srt<> 'N' then
call ArraySort se!Stm, '@'
call DBGIND-1
return

Dirs4Mask:call TRACE "OFF"
parse arg te!Msk,te!Stm,te!Fol,te!Srt
if te!Fol='' then
te!Fol='N'
if te!Srt='' then
te!Srt='Y'
call DBG 'Dirs4Mask("' || te!Msk || '"): Follow Directories = "' || te!Fol || '"'
call DBGIND 1
call _valueS te!Stm|| '.0',0
if te!Fol='N' then
te!Fol=''
else
te!Fol='S'
call _SysFileTree te!Msk,te!Stm, 'D' ||te!Fol
if te!Srt<> 'N' then
call ArraySort te!Stm, '@'
call DBGIND-1
return

_FileWriteFailed:
CryAndDie('Write to "' || arg(1) || '" failed (' || FileDescription(arg(1)) || ')!')

FileLineOut:call TRACE "OFF"
parse arg ue!File,ue!Line
if 0=lineout(ue!File,ue!Line)then
return
_FileWriteFailed(ue!File)

FileCharOut:call TRACE "OFF"
if 0=charout(arg(1),arg(2))then
return
_FileWriteFailed(arg(1))

QuoteIt:call TRACE "OFF"
parse arg ve!Q4,ve!TryQ,ve!What
if ve!What='' then
ve!What='N'
if ve!TryQ='' then
ve!TryQ='"' || "'"
else
do
if translate(ve!TryQ)='ANY' then
ve!TryQ=TryQuoteListAny
end
ve!I=verify(ve!TryQ,ve!Q4)
if ve!I=0 then
CryAndDie('QuoteIt(): Could not find suitable quote for ' ||DebugRightArrow||ve!Q4||DebugLeftArrow)
else
do
ve!Q=substr(ve!TryQ,ve!I,1)
if ve!What='N' then
return(ve!Q)
else
return(ve!Q||ve!Q4||ve!Q)
end

Quoted:call TRACE "OFF"
parse arg we!Q4,we!TryQ
if we!TryQ='' then
we!TryQ='ANY'
return(QuoteIt(we!Q4,we!TryQ, 'Y'))

FileGetTmpName:call TRACE "OFF"
return(RexGetTmpFileName(arg(1)))

FileClose:call TRACE "OFF"
parse arg we!F,we!C
if we!C='' then
we!C='Y'
if we!C<> 'N' then
call DieIfIoErrorOccurred we!F
call _FileClose we!F
return

MustDeleteFile:call TRACE "OFF"
call FileDelete arg(1)
return

FileDelete:call TRACE "OFF"
parse arg we!F,we!D
if we!D='' then
we!D='Y'
else
we!D=translate(we!D)
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'FileDelete(' || we!F || ') : How = ' ||we!D
call DBGIND 1
end
if we!D='Q' then
do
_DelOnExitCnt=_DelOnExitCnt+1
_DelOnExit._DelOnExitCnt=we!F
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'File being queued for deletion on exit - #' ||_DelOnExitCnt
call DBGIND-1
end
return(0)
end
call _FileClose we!F
if FileQueryExists(we!F)='' then
do
we!Rc=0
if OptionDebugOn='Y' then
call DBG_EVALUATE 'File does not exist'
end
else
do
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Deleting the file'
call _FileClose we!F
if OptionDebugOn='Y' then
call DBGIND 1
we!Rc=_SysFileDelete(we!F)
if OptionDebugOn='Y' then
call DBGIND-1
if FileQueryExists(we!F)="" then
we!Rc=0
else
do
call CheckForNotBeingAbleToExecAnything
if we!D<> 'N' then
CryAndDie('Could not delete "' || we!F || '", it must be in use (DosRc=' || we!Rc || ')...')
if we!Rc=0 then
we!Rc=987
end
end
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'Rc = ' ||we!Rc
call DBGIND-1
end
return(we!Rc)

FileDeleteQueued:
call DBG_EVALUATE 'Deleting any files previously queued up'
call DBGIND 1
do we!i=1 to _DelOnExitCnt
call DBG_EVALUATE 'Deleting #' ||we!i
call DBGIND 1
call FileDelete _DelOnExit.we!i, 'N'
call DBGIND-1
end
call DBGIND-1
return(0)

QueryExists:

FileQueryExists:call TRACE "OFF"
parse arg xe!F,xe!ME
if xe!ME='' then
xe!ME='N'
if xe!F='' then
CryAndDie('The filename "" is invalid!')
else
do
xe!Rc=_FileQueryExists(xe!F)
if xe!Rc='' & xe!ME <> 'N' then
CryAndDie('The filename "' || xe!F || '" does not exist!')
return(xe!Rc)
end

Bd2Date:call TRACE "OFF"
parse arg ye!Bd,ye!Fmt,ye!Cfg,ye!T
ye!S=_Bd2Date(ye!Bd)
if ye!Fmt<> "" then
do
if ye!T="" then
ye!T='000000'
ye!S=FormatTime(ye!Fmt,ye!S||ye!T,ye!Cfg)
end
return(ye!S)

FileQueryDateTime:call TRACE "OFF"
parse arg ye!F,ye!Fmt,ye!Cfg,ye!D
if ye!D='' then
ye!D='Y'
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'FileQueryDateTime(' || ye!F || ') : Fmt = ' ||ye!Fmt
call DBGIND 1
end
ye!Ts=GetFileTimeStamp(ye!F, 'Q')
if ye!Ts=-1 then
do
if ye!D='N' then
ye!Ft=''
else
CryAndDie('Failed getting file time for "' || ye!F || '"')
end
else
do
ye!Ft=FormatTime(ye!Fmt,ye!Ts,ye!Cfg)
end
call DBGIND-1
return(ye!Ft)

GetFileTimeStamp:call TRACE "OFF"
parse arg ze!FN,ze!OnErr,ze!Fmt
ze!OnErr=translate(ze!OnErr)
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'GetFileTimeStamp("' || ze!FN || '")'
call DBGIND 1
end
ze!ST=FileInMemoryTimeStamp(ze!FN)
if ze!ST='' then
do
ze!FT=_FileQueryDateTime(ze!FN)
if OptionDebugOn='Y' then
call DBG_EVALUATE 'Is time stamped : "' || ze!FT || '"'
if ze!FT='' then
do
ze!M='The file "' || ze!FN || '" does not exist.'
select
when ze!OnErr='Q' then
call DBG ze!M
when ze!OnErr='D' then
CryAndDie(ze!M)
otherwise
call OutputWarningToScreen 'TS00',ze!M
end
if OptionDebugOn='Y' then
call DBGIND-1
return(-1)
end
ze!FT=space(ze!FT)
parse var ze!FT Month'-'Day'-'Year' 'Hour':'Minute':'Second
if Year<80 then
Year=100+Year
Year=1900+Year
ze!ST=Year||Month||Day||Hour||Minute||Second
end
if ze!Fmt<> '' then
do
call DBG_EVALUATE 'Time Stamp      : "' || ze!ST || '"'
ze!ST=FormatTime(ze!Fmt,ze!ST)
end
if OptionDebugOn='Y' then
do
call DBG_EVALUATE 'Returning       : "' || ze!ST || '"'
call DBGIND-1
end
return(ze!ST)

FilePart:call TRACE "OFF"
return(_filespec(arg(1),arg(2)))

ScheduleCleanupCode:call TRACE "OFF"
af!Mac=arg(1)
af!MV=MacroGet(af!Mac)
af!MV=ReplaceMacros(af!MV)
af!MV=ReplaceEos(af!MV)
af!Cnt=ExitCuc.0
af!Cnt=af!Cnt+1
ExitCuc.af!Cnt=af!MV
ExitCuc.0=af!Cnt
return

NoSpam:call TRACE "OFF"
parse arg bf!E,bf!T
if bf!T='' then
bf!T='@TEXT'
bf!T=translate(bf!T)
select
when bf!T='@TEXT' then
do
bf!Ht=CfgMacro("PPWIZARD_NOSPAM_TEXT", 'SpamBeGone')
bf!E=ReplaceString(bf!E, "@", '@' || bf!Ht || '.')
end
otherwise
CryAndDie('Unknown NoSpam() option of "' || bf!T || '"')
end
return(bf!E)

Seconds2Text:call TRACE "OFF"
cf!S=arg(1)
cf!W=cf!S%604800
cf!S=cf!S//604800
cf!D=cf!S%86400
cf!S=cf!S//86400
cf!H=cf!S%3600
cf!S=cf!S//3600
cf!M=cf!S%60
cf!S=cf!S-(cf!M*60)
cf!T=''
cf!T=cf!T||cf!Text(cf!W, "week")
cf!T=cf!T||cf!Text(cf!D, "day")
cf!T=cf!T||cf!Text(cf!H, "hour")
cf!T=cf!T||cf!Text(cf!M, "minute")
cf!T=cf!T||cf!Text(cf!S, "second")
if cf!T='' then
cf!T='0 seconds'
return(strip(cf!T))

cf!Text:
parse arg cf!N,cf!U
if cf!N=0 then
cf!Rc=''
else
do
cf!Rc=' ' || cf!N || ' ' ||cf!U
if cf!N>1 then
cf!Rc=cf!Rc|| 's'
end
return(cf!Rc)

Evaluate_43:
TraceBpListsLoaded=''
TraceAutoAliasCnt=0
TraceAutoAliasMax=0
TraceLineInBuffer=""
signal ExecCmd_44

ExecRexxCmd:
parse arg InterpretThisAsPassed,df!Exp
if df!Exp='Y' then
InterpretThisRexx=PerformReplacementsInCmdsParameters(InterpretThisAsPassed)
else
InterpretThisRexx=InterpretThisAsPassed
if RexWhich='REGINA' then
df!UseEos=MarksNewLine
else
df!UseEos=';'
InterpretThisRexx=ExpandAnyRxVarHacks(InterpretThisRexx)
InterpretThisRexx=ReplaceEos(InterpretThisRexx)
InterpretThis=InterpretThisRexx
if OptionDebugOn='Y' then
call DBG_INTERPRET 'ExecRexxCmd(' || AddCommasToDecimalNumber(length(InterpretThisRexx)) || ' bytes): ' ||DebugRightArrow||InterpretThisRexx||DebugLeftArrow
call DBGIND 1
if OptionPpwTrace='OFF' then
TraceBreakPoint=''
else
call SetUpBp strip(CfgMacro('REXX_BP', ''))
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeRexxTrace)==SeeRexxTrace then
do
if RexWhich='REGINA' then
df!Def='OFF'
else
df!Def='INTERMEDIATES'
TraceLevel4Rexx=translate(CfgMacro('REXXTRACE',df!Def))
if TraceLevel4Rexx<> 'OFF' then
InterpretThis='TRACE ' || TraceLevel4Rexx || ';' || InterpretThisRexx || ';call TRACE "OFF";'
call Line1 ''
call Line1 '---------- START REXX CODE (RexxTrace=' || TraceLevel4Rexx || ') ----------'
end
end
signal ON SYNTAX NAME _SyntaxErrorDuringInterpret
signal ON NOVALUE NAME _UnknownVariableDuringInterpret
InitializedBp='N'
TraceLineInBuffer=""
PrevTracedLine=''
interpret InterpretThis
TraceBreakPoint=''
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeRexxTrace)==SeeRexxTrace then
do
call Line1 '---------- END   REXX CODE (RexxTrace=' || TraceLevel4Rexx || ') ----------'
call Line1 ''
end
end
call DBGIND-1
return

_UnknownVariableDuringInterpret:
TrappingLine=SIGL
call TRACE "OFF"
call CommonTrapHandler TrappingLine, 'N', 'Unknown Variable', condition('D'),space(InterpretThisRexx),TraceBreakPoint

_SyntaxErrorDuringInterpret:
TrappingLine=SIGL
call TRACE "OFF"
call CommonTrapHandler TrappingLine, 'S', 'Reason',errortext(Rc),space(InterpretThisRexx),TraceBreakPoint

ReplaceEos:
return(ReplaceString(arg(1),DefRexxSpecialSepTag,df!UseEos))

SetUpBp:
TraceBreakPoint=arg(1)
if TraceBreakPoint<> '' then
do
if left(TraceBreakPoint,1)='=' then
do
df!Mac=strip(substr(TraceBreakPoint,2))
if MacroExists(df!Mac)='N' then
do
df!T='The breakpoint macro "' || df!Mac || '" does not exist!'
if arg(2)<> 'U' then
CryAndDie(df!T, 'The "REXX_BP" macro contains an invalid value')
else
do
call ColorSet 'ERROR'
call Line1 df!T
call Beeps
TraceBreakPoint="?"
end
end
else
do
TraceBreakPoint=GetDefineContents(df!Mac)
TraceBreakPoint='=' ||ReplaceEos(PerformReplacementsInCmdsParameters(TraceBreakPoint))
end
end
else
do
if TraceBreakPoint<> '?' & left(TraceBreakPoint, 1) = '?' then
do
TraceBreakPoint='=if (' || strip(substr(TraceBreakPoint, 2)) || ') then; do; rtStop="Y"; end;'
end
end
end
return

AddToBpSearch:
RtSearchText=RtSearchText|| '{SOL}' || space(arg(1)) || '{EOL}'
return

TraceLineIn:
if TraceLineInBuffer="" then
do
df!RL=linein()
df!Tmp=_ConsoleWriteAllowed
_ConsoleWriteAllowed='N'
call line1 df!RL
_ConsoleWriteAllowed=df!Tmp
end
else
do
parse var TraceLineInBuffer df!RL '{NL}' TraceLineInBuffer
call line1 df!RL
end
return(strip(df!RL))

UserBreakPoint:call TRACE "OFF"
RtUserBreakPoint='Y'
signal _UserBreakPoint

RexxTrace:call TRACE "OFF"
RtUserBreakPoint='N'

_UserBreakPoint:
signal on NOVALUE name RexxTrapUninitializedVariable
signal on SYNTAX name RexxTrapSyntaxError
parse arg rtText,rtDumpList,rtDbgCmd,rtDbgTrapped
rtSay='$TRACE: ' ||rtText
call ColorSet 'RexxTrace'
call Line1 rtSay
call ColorSet 'RexxOther'
RtSearchText=''
call AddToBpSearch rtText
if rtDbgTrapped<> 'Y' then
do
rtThis=''
if rtDbgCmd='Y' then
do
rtThis=PrevTracedLine|| ' ' ||rtText
PrevTracedLine=rtText
end
else
rtThis=rtDumpList
if rtThis<> '' then
do
if rtThis<> '?' then
call DumpVarsInExpression rtThis, '', '', 'TraceVarSay'
else
do
call Line1 'ALL KNOWN VARIABLES'
call Line1 '~~~~~~~~~~~~~~~~~~~'
call DumpVarsInExpression InterpretThisRexx, '', '', 'TraceVarSay'
end
end
end
call Line1 ''
if RtUserBreakPoint='Y' | rtDbgTrapped = 'Y' then
rtStop='Y'
else
do
if TraceBreakPoint='' then
rtStop='N'
else
do
select
when TraceBreakPoint='?' then
rtStop='Y'
when left(TraceBreakPoint,1)='=' then
do
rtStop='N'
df!B=BeepsAllow('N')
call ExecuteUsersTraceCmd substr(TraceBreakPoint,2)
call BeepsAllow df!B
end
otherwise
do
if pos(TraceBreakPoint,RtSearchText)<>0 then
rtStop='Y'
else
rtStop='N'
end
end
end
end
if rtStop='N' then
return
call LoadBpLists
TraceLineInBuffer=strip(CfgMacro('REXX_BP_AUTO_CMD', ''))
do forever
call ColorSet 'PromptText'
call Char1 'BreakPoint (' || BpAliasCnt || ' aliases) => '
call ColorSet 'RexxOther'
rtCmd=TraceLineIn()
if rtCmd='' then
do
call ColorSet
return
end
rtCmdU=translate(rtCmd)
select
when left(rtCmd,1)='/' then
do
EqPos=pos('=',rtCmd)
if EqPos<>0 then
do
call AddBpAlias rtCmd, "user"
STo=SaveBpAliasFile()
if STo='' then
STxt='Done (not permanently saved)!'
else
STxt='Done, saved to "' || STo || '".'
call ColorSet 'HIGHLIGHT'
call Line1 STxt
call ColorSet 'RexxOther'
end
else
do
rtAlias=strip(substr(rtCmd,2))
if left(rtAlias,1)='#' | datatype(rtAlias, 'W')then
do
if left(rtAlias,1)='#' then
rtAliasI=strip(substr(rtAlias,2))
else
rtAliasI=rtAlias
if rtAliasI>TraceAutoAliasCnt then
do
call ColorSet 'ERROR'
call Line1 '#Alias "#' || rtAliasI || '" does not exist!'
call ColorSet 'RexxOther'
call Beeps
iterate
end
rtAliasI=(TraceAutoAliasCnt-rtAliasI)+1
rtCmd=Aalias.rtAliasI
end
else
do
df!Mac="REXX_BP_ALIAS:" ||rtAlias
if MacroExists(df!Mac)='Y' then
rtCmd=GetDefineContents(df!Mac)
else
do
rtCmd=FindBpAlias(rtAlias)
if rtCmd='' then
do
call ColorSet 'ERROR'
call Line1 'Alias "' || rtAlias || '" not found!'
call ColorSet 'RexxOther'
call Beeps
iterate
end
end
end
TraceLineInBuffer=rtCmd
iterate
end
end
when left(rtCmd,1)='?' then
do
df!Rest=substr(rtCmdU,2)
rtCmdU=word(df!Rest,1)
call ColorSet 'RexxOther'
select
when rtCmdU='' then
do
call Line1 rtText
end
when abbrev('VARIABLES',rtCmdU)then
do
if words(df!Rest)=1 then
do
call Line1 'ALL KNOWN VARIABLES'
call Line1 '~~~~~~~~~~~~~~~~~~~'
call DumpVarsInExpression InterpretThisRexx, '', '', 'TraceVarSay'
end
else
do
df!Exists=''
df!Unknown=''
do df!I=2 to words(df!Rest)
df!V=word(df!Rest,df!I)
if symbol(df!V)='VAR' then
df!Exists=df!Exists|| ' ' ||df!V
else
df!Unknown=df!Unknown|| ' ' ||df!V
end
if df!Unknown<> '' then
do
call ColorSet 'ERROR'
call Line1 'Unknown Variables: ' ||strip(df!Unknown)
call ColorSet 'RexxOther'
end
if df!Exists<> '' then
call DumpVarsInExpression df!Exists, '', '', 'TraceVarSay'
end
end
when abbrev('LOCATION',rtCmdU)then
call Line1 'AT: ' ||CurrentSourceLocation()
when abbrev('ALIASES',rtCmdU)then
do
call Line1 'ALL ALIASES'
call Line1 '~~~~~~~~~~~'
do Index=1 to BpAliasCnt
call Line1 left(BpAlias.Index.BpAName,BpLongestAlias)|| ' = ' ||BpAlias.Index.BpAValue
end
end
when abbrev('#ALIASES',rtCmdU)then
do
if TraceAutoAliasCnt=0 then
do
call ColorSet 'ERROR'
call Line1 'No commands have been remembered yet!'
call Beeps
end
else
do
MaxLng=length(TraceAutoAliasCnt)
call Line1 'ALL # ALIASES'
call Line1 '~~~~~~~~~~~~~'
do Index=1 to TraceAutoAliasCnt
IndexR=(TraceAutoAliasCnt-Index)+1
call Line1 '/#' || left(IndexR, MaxLng)  || ' = ' ||Aalias.Index
end
end
end
when abbrev('MACRO',rtCmdU)then
do
df!Mac=word(rtCmd,2)
if MacroExists(df!Mac)='N' then
do
call ColorSet 'ERROR'
call Line1 'The macro "' || df!Mac || '" does not exist'
call Beeps
end
else
do
df!T='MACRO: ' ||df!Mac
call ColorSet 'HIGHLIGHT'
call line1 df!T
call line1 copies('~',length(df!T))
call ColorSet 'INFO'
call Char1 '"'
call ColorSet 'RexxOther'
call Char1 GetDefineContents(df!Mac)
call ColorSet 'INFO'
call Line1 '"'
end
end
otherwise
do
call ColorSet 'ERROR'
call Line1 'Unknown ? command of "' || rtCmd || '"!'
call Beeps
end
end
call ColorSet 'RexxOther'
end
when rtCmdU='BP' then
do
call ColorSet 'PromptText'
call Char1 "New Breakpoint (blank = none) => "
call ColorSet 'RexxOther'
call SetUpBp TraceLineIn(), 'U'
end
otherwise
do
if ExecuteUsersTraceCmd(rtCmd)=0 then
do
if AddAutoAlias(rtCmd)<>0 then
call SaveBpAliasFile
end
end
end
end
Die("NeverGetsHere:Trace")

TraceVarSay:
call ColorSet 'RexxOther'
call Line1 "      | " ||arg(1)
call ColorSet 'RexxOther'
call AddToBpSearch arg(1)
return

ExecuteUsersTraceCmd:
signal ON SYNTAX NAME _SyntaxErrorDuringExecuteUsersTraceCmd
signal ON NOVALUE NAME _UnknownVariableDuringExecuteUsersTraceCmd
interpret arg(1)
return(0)

_SyntaxErrorDuringExecuteUsersTraceCmd:
ErrNo=Rc
call ColorSet 'ERROR'
call Line1 'SYNTAX ERROR: ' ||errortext(ErrNo)
call ColorSet 'RexxOther'
call Line1 ''
call Beeps
return(1)

_UnknownVariableDuringExecuteUsersTraceCmd:
call ColorSet 'ERROR'
call Line1 'The rexx variable "' || condition('D') || '" is unknown!'
call ColorSet 'RexxOther'
call Line1 ''
call Beeps
return(1)

LoadBpLists:
TraceBpList=CfgMacro('REXX_BP_ALIAS_FILES', '')
if TraceBpList<>TraceBpListsLoaded then
TraceBpListsLoaded=''
if TraceAutoAliasMax=0 then
do
TraceAutoAliasMax=CfgMacro('REXX_BP_MAX_AUTO_CMD',22)
if datatype(TraceAutoAliasMax, 'W')=0 then
TraceAutoAliasMax=22
if TraceAutoAliasMax<10 then
TraceAutoAliasMax=22
end
if TraceBpListsLoaded<> '' then
return
BpSaveTo=''
BpList=TraceBpList
BpAliasCnt=0
BpFileNumb=0
BpLongestAlias=0
do while BpList<> ''
parse var BpList BpList1';'BpList
BpFileNumb=BpFileNumb+1
if BpFileNumb=1 then
BpSaveTo=BpList1
if BpList1='' then
iterate
BpList1=FindFile(BpList1)
if BpList1='' then
iterate
call FileClose BpList1, 'N'
BpListLine=0
do while lines(BpList1)<>0
CurrentLine=strip(linein(BpList1))
BpListLine=BpListLine+1
if CurrentLine='' | left(CurrentLine, 1) = ';' then
iterate
AliasSource='line #' || BpListLine || ' of ' ||BpList1
call AddBpAlias CurrentLine,AliasSource,BpFileNumb
end
call FileClose BpList1
end
TraceBpListsLoaded=TraceBpList
return

AddBpAlias:
parse arg AliasCmd,AliasSrc,FromFile
parse var AliasCmd '/'BpAliasName'='BpAliasValue
if BpAliasValue='' then
do
call DBG 'Alias Command from ' || AliasSrc || ' incorrectly formatted!'
return
end
BpAliasName=translate(BpAliasName)
if left(BpAliasName,1)=='#' then
do
call AddAutoAlias BpAliasValue
return
end
if length(BpAliasName)>BpLongestAlias then
BpLongestAlias=length(BpAliasName)
FoundIndex=0
do Index=1 to BpAliasCnt
if BpAliasName=BpAlias.Index.BpAName then
do
FoundIndex=Index
leave
end
end
if FoundIndex<>0 then
do
if FromFile<> '' then
return
end
else
do
BpAliasCnt=BpAliasCnt+1
FoundIndex=BpAliasCnt
end
BpAlias.FoundIndex.BpAName=BpAliasName
BpAlias.FoundIndex.BpAValue=BpAliasValue
BpAlias.FoundIndex.BpFNumb=FromFile
return

FindBpAlias:
BpAliasName=translate(strip(arg(1)))
do Index=1 to BpAliasCnt
if BpAliasName=BpAlias.Index.BpAName then
return(BpAlias.Index.BpAValue)
end
return('')

SaveBpAliasFile:
if BpSaveTo='' then
return('')
call MustDeleteFile BpSaveTo
call lineout BpSaveTo, ';***'
call lineout BpSaveTo, ';*** Automatically saved at: ' ||NiceDateTime()
call lineout BpSaveTo, ';***'
call lineout BpSaveTo, ''
FoundF='N'
do Index=1 to BpAliasCnt
if BpAlias.Index.BpFNumb=1 then
do
if FoundF='N' then
call lineout BpSaveTo, ';--- Loaded From File ---'
FoundF='Y'
call lineout BpSaveTo, '/' || BpAlias.Index.BpAName || '=' ||BpAlias.Index.BpAValue
end
end
call FileClose BpSaveTo
FoundU='N'
do Index=1 to BpAliasCnt
if BpAlias.Index.BpFNumb=''then
do
if FoundU='N' then
do
if FoundF='Y' then
call lineout BpSaveTo, ''
call lineout BpSaveTo, ';--- User Modified This Session ---'
end
FoundU='Y'
call lineout BpSaveTo, '/' || BpAlias.Index.BpAName || '=' ||BpAlias.Index.BpAValue
end
end
call FileClose BpSaveTo
if TraceAutoAliasCnt<>0 then
do
call lineout BpSaveTo, ''
call lineout BpSaveTo, ';--- Last Few Commands Used ---'
do Index=1 to TraceAutoAliasCnt
IndexN=(TraceAutoAliasCnt-Index)+1
call lineout BpSaveTo, '/#' || IndexN  || '=' ||Aalias.Index
end
end
call FileClose BpSaveTo
return(BpSaveTo)

FindAutoAlias:
FindWhat=arg(1)
do FndIndex=1 to TraceAutoAliasCnt
if FindWhat=Aalias.FndIndex then
return(FndIndex)
end
return(0)

DeleteAutoAlias:
DelIndex=arg(1)
do DelIndexT=DelIndex to TraceAutoAliasCnt-1
DelIndexF=DelIndexT+1
Aalias.DelIndexT=Aalias.DelIndexF
end
TraceAutoAliasCnt=TraceAutoAliasCnt-1
return

AddAutoAlias:
SaveWhat=strip(arg(1))
if SaveWhat='' then
return(0)
FoundAt=FindAutoAlias(SaveWhat)
if FoundAt<>0 then
call DeleteAutoAlias FoundAt
if TraceAutoAliasCnt>=TraceAutoAliasMax then
call DeleteAutoAlias 1
TraceAutoAliasCnt=TraceAutoAliasCnt+1
Aalias.TraceAutoAliasCnt=SaveWhat
return(TraceAutoAliasCnt)

ExecCmd_44:
ExpandXEarly='N'
ExpandXLate='N'
ExpandXCmd='N'
signal EndExpandX

EXPANDX_DEBUG:
if OptionDebugOn='Y' then
do
if ExpandX='NONE' then
call OptionDebugShow 'EXPANDX', 'X codes are never expanded'
else
call OptionDebugShow 'EXPANDX', 'X codes are expanded "' || ExpandX || '"'
end
return

EXPANDX_GET:
call EXPANDX_DEBUG
return(ExpandX)

EXPANDX_SET:
ExpandX=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'EXPANDX', 'Setting default value of "X" var expansion to "' || EXPANDX || '"'
Default4_EXPANDX=ExpandX
return(0)
end
if ExpandX=='' then
ExpandX=Default4_EXPANDX
ExpandXEarly='N'
ExpandXLate='N'
ExpandXCmd='N'
if ExpandX<> 'NONE' then
do
TmpList=translate(ExpandX)
do while TmpList<> ''
parse var TmpList ThisItem','TmpList
select
when ThisItem='COMMAND' then
ExpandXCmd='Y'
when ThisItem='EARLY' then
ExpandXEarly='Y'
when ThisItem='LATE' then
ExpandXLate='Y'
otherwise
CryAndDie('Unknown EXPANDX option of "' || ThisItem || '"')
end
end
end
call EXPANDX_DEBUG
return

SetXCode:call TRACE "OFF"
parse arg ef!N,ef!V
ef!XN='XVAR?.X?' ||c2x(translate(ef!N))
call _valueS ef!XN,ef!V
return

InitializeCharCodes:
call DBG_DEFINING 'Initializing <' || '?x00-FF> codes + <' || '?xRexxEos> + some others'
do CharCode=0 to 255
call _valueS 'XVAR?.X?' ||c2x(translate(d2x(CharCode,2))),d2c(CharCode)
end
call _valueS 'XVAR?.X?'  || c2x(translate("RexxEos")),MarksNewLine
call _valueS 'XVAR?.X?'  || c2x(translate("Nothing")), ""
Val='<' || '?xml version="1.0" encoding="UTF-8"?>' ||MarksNewLine
Val=Val|| '<' || '!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd">' ||MarksNewLine
Val=Val|| '<html xmlns="http://www.w3.org/1999/xhtm" xml:lang="en" lang="en">' ||MarksNewLine
call _valueS 'XVAR?.X?'  || c2x(translate("HTML10")),Val
return

ExpandXCodes:call TRACE "OFF"

RepXCodes:
if pos(StartsStdSymbolReplacement_x,arg(1))=0 then
return(arg(1))

ReplaceTheXCodesWeKnowExist:
LeftBit=''
RightBit=arg(1)
StartPos=pos(StartsStdSymbolReplacement_x,RightBit)
do while StartPos<>0
ReplaceCount=ReplaceCount+1
EndPos=pos(EndsMacroReplacement,RightBit,StartPos+1)
XVarName='XVAR?.X?' ||c2x(translate(substr(RightBit,StartPos+3,(EndPos-StartPos)-3)))
if symbol(XVarName)='VAR' then
LeftBit=LeftBit||left(RightBit,StartPos-1)||_valueG(XVarName)
else
do
CryAndDie(StartsStdSymbolReplacement_x||substr(RightBit,StartPos+3,(EndPos-StartPos)-3)||EndsMacroReplacement|| ' is not defined (use "#RexxVar =x=" command)!')
end
RightBit=substr(RightBit,EndPos+1)
StartPos=pos(StartsStdSymbolReplacement_x,RightBit)
end
if OptionDebugOn='Y' then
call DebugOutputAfterReplacement LeftBit||RightBit, '?xXX'
return(LeftBit||RightBit)

EndExpandX:
call InitOnExitProcessing
signal OnExit_45

InitOnExitProcessing:
OnExitCnt=0
LinesFromOnExit='N'
do ff!I=1 to 100
OnExitLst.ff!I=''
end
return

SetUpOnExitProcessingIfEndOfMainFile:
if IncludeLevel=1 then
do
if OnExitCnt<>0 then
do
call DBG ''
call DBG '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
call DBG '!!! "#OnExit" processing follows !!!'
call DBG '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
call DBG ''
call DBGIND 1
ff!All=''
do ff!I=1 to 100
ff!Txt=OnExitLst.ff!I
if ff!Txt\=='' then
do
call DBG 'FROM: ' ||OnExitLoc.ff!I
call DBGIND 1
call DBG 'SLOT #' || ff!I || ': ' ||ff!Txt
call DBGIND-1
if ff!All='' then
ff!All=ff!Txt
else
ff!All=ff!All||MarksNewLine||ff!Txt
end
end
call DBGIND-1
IncludeMemBufferNextLine=ff!All
LinesFromOnExit='Y'
OnExitCnt=0
return('Y')
end
end
return('N')

ProcessOnExit:
gf!R=strip(arg(1))
gf!W1=word(gf!R,1)
if translate(gf!W1)='EXEC' then
do
gf!R=subword(gf!R,2)
gf!R=PerformReplacementsInCmdsParameters(gf!R)
if left(gf!R,1)='{' then
parse var gf!R '{' gf!RcTest '}' gf!R
else
do
gf!R=gf!R
gf!RcTest=''
end
if OptionValidation<> '' then
CryAndDie("Already have a command specified for execution!")
OptionValidation=gf!R
OptionValidationRc=gf!RcTest
return(0)
end
if left(gf!R,1)<> '#' then
gf!Slot=50
else
do
gf!Slot=substr(word(gf!R,1),2)
gf!R=subword(gf!R,2)
end
if datatype(gf!Slot, 'W')=0 then
do
if symbol(gf!Slot)='VAR' then
gf!Slot=value(gf!Slot)
else
do
if defined(gf!Slot)='Y' then
gf!Slot=MacroGet(gf!Slot)
else
CryAndDie('Slot "' || gf!Slot || '" was not an integer so we looked for a rexx variable', ' then macro of that name, neither was found!')
end
end
if gf!R='' then
CryAndDie('No #OnExit text specified!')
if datatype(gf!Slot, 'W')=0|gf!Slot<1|gf!Slot>100 then
CryAndDie('Invalid slot number of "' || gf!Slot || '"', 'It should be an integer from 1 to 100.')
call DBG '#OnExit (slot #' || gf!Slot || ') we will process => ' ||DebugRightArrow||gf!R||DebugLeftArrow
OnExitCnt=OnExitCnt+1
if OnExitLst.gf!Slot='' then
do
OnExitLst.gf!Slot=gf!R
OnExitLoc.gf!Slot=CurrentSourceLocation()
end
else
do
if gf!Slot<>50 then
CryAndDie('You are attempting to reuse #OnExit slot ' || gf!Slot, 'The slot was already used at ' || OnExitLoc.gf!Slot, 'Only slot 50 can be reused.')
OnExitLst.gf!Slot=OnExitLst.gf!Slot||MarksNewLine||gf!R
end
return(0)

OnExit_45:
IncludeIntoMemory=''
signal Include_46

RecursiveIncludeSave:
call LoopPushHack
_DebugCurrentFileNumber.IncludeLevel=DebugCurrentFileNumber
_IncludeMemHandle.IncludeLevel=IncludeMemHandle
_IncludeEofLine.IncludeLevel=IncludeEofLine
_IncludeFragmentSpec.IncludeLevel=IncludeFragmentSpec
_IncludeLineNumber.IncludeLevel=IncludeLineNumber
_IncludeMemBufferNextLine.IncludeLevel=IncludeMemBufferNextLine
_IncludeLoopMemBufferNextLine.IncludeLevel=IncludeLoopMemBufferNextLine
_EofForced.IncludeLevel=EofForced
EofForced=''
return

RecursiveIncludeRestore:
DebugCurrentFileNumber=_DebugCurrentFileNumber.IncludeLevel
IncludeMemHandle=_IncludeMemHandle.IncludeLevel
IncludeEofLine=_IncludeEofLine.IncludeLevel
IncludeFragmentSpec=_IncludeFragmentSpec.IncludeLevel
IncludeLineNumber=_IncludeLineNumber.IncludeLevel
IncludeMemBufferNextLine=_IncludeMemBufferNextLine.IncludeLevel
IncludeLoopMemBufferNextLine=_IncludeLoopMemBufferNextLine.IncludeLevel
EofForced=_EofForced.IncludeLevel
IncludeFileName=IncludeFileName.IncludeLevel
call HandleIncludeFragment
call LoopPopHack
return

FileInMemoryTimeStamp:
fimFullFileName=arg(1)
if RexSystemOpSys="UNIX" then
ifHandle='_IF_' || c2x(fimFullFileName) || '.'
else
ifHandle='_IF_' || c2x(translate(fimFullFileName)) || '.'
if symbol(ifHandle|| '!TS') <> 'VAR' then
return('')
else
do
Ts=_valueG(ifHandle|| '!TS')
if OptionDebugOn='Y' then
call DBG 'Cached Timestamp: "' || Ts || '"'
return(Ts)
end

IncludeFileOpen:
ifFullFileName=arg(1)
ifLoad2Mem=arg(2)
if RexSystemOpSys="UNIX" then
ifHandle='_IF_' || c2x(ifFullFileName) || '.'
else
ifHandle='_IF_' || c2x(translate(ifFullFileName)) || '.'
if symbol(ifHandle|| '0') = 'VAR' then
do
if OptionDebugOn='Y' then
call DBG '"' || ifFullFileName || '" will be read from memory cache'
return(_valueG(ifHandle|| '0') || ';' ||ifHandle)
end
call FileClose ifFullFileName, 'N'
OpenRc=FileOpenReadOnly(ifFullFileName)
if ifLoad2Mem='' then
ifLoad2Mem=IncludeIntoMemory
if ifLoad2Mem='N' then
do
if OptionDebugOn='Y' then
call DBG 'Will read "' || ifFullFileName || '" directly from file'
return('')
end
if OptionDebugOn='Y' then
call DBG 'Will read "' || ifFullFileName || '" into memory cache'
Ts=GetFileTimeStamp(ifFullFileName)
call _valueS ifHandle|| '!TS',Ts
ifLineNum=0
do while lines(ifFullFileName)<>0
ifLineNum=ifLineNum+1
ifLineTxt=linein(ifFullFileName)
call _valueS ifHandle||ifLineNum,ifLineTxt
end
call _valueS ifHandle|| '0',ifLineNum
call FileClose ifFullFileName
if OptionDebugOn='Y' then
do
call DBGIND 1
call DBG 'Read ' || AddCommasToDecimalNumber(ifLineNum) || ' lines'
call DBGIND-1
end
return(ifLineNum|| ';' ||ifHandle)

IncludeFileClose:
if IncludeMemHandle='' then
do
call FileClose IncludeFileName
end
return

IncludeFileLines:
if IncludeMemHandle='' then
return(lines(IncludeFileName))
else
return(IncludeLineNumber<IncludeEofLine)

IncludeFileLineIn:
IncludeLineNumber=IncludeLineNumber+1
if IncludeMemHandle='' then
ifLineTxt=linein(IncludeFileName)
else
ifLineTxt=_valueG(IncludeMemHandle||IncludeLineNumber)
if ExtraWhiteSpace=='' then
return(ifLineTxt)
else
return(translate(ifLineTxt, '', ExtraWhiteSpace, ' '))

Include_46:
SummaryUserAllBldCount=0
SummaryUserOverallCount=0
SummaryUserThisBldCount=0
signal Summary_47

Summary:call TRACE "OFF"
parse arg SummaryLeft,SummaryRight,SummaryMode
SummaryLeft=strip(SummaryLeft)
SummaryMode1=translate(left(SummaryMode,1))
select
when SummaryMode1='D' then
do
call DBG "Don't" || ' want "' || SummaryLeft || '" in any summaries'
call _valueS '!SUMMDROP.!' ||c2x(SummaryLeft),CurrentSourceLocation()
end
when SummaryMode1='O' then
do
SummaryUserOverallCount=SummaryUserOverallCount+1
SummaryUserOverallL.SummaryUserOverallCount=SummaryLeft
SummaryUserOverallR.SummaryUserOverallCount=SummaryRight
end
when SummaryMode1='A' then
do
SummaryUserAllBldCount=SummaryUserAllBldCount+1
SummaryUserAllBldL.SummaryUserAllBldCount=SummaryLeft
SummaryUserAllBldR.SummaryUserAllBldCount=SummaryRight
end
otherwise
do
SummaryUserThisBldCount=SummaryUserThisBldCount+1
SummaryUserThisBldL.SummaryUserThisBldCount=SummaryLeft
SummaryUserThisBldR.SummaryUserThisBldCount=SummaryRight
end
end
return

GenerateUserSummaryThisBuild:
do SummLine=1 to SummaryUserThisBldCount
call AddSummaryLine SummaryUserThisBldL.SummLine,SummaryUserThisBldR.SummLine
end
SummaryUserThisBldCount=0
return

GenerateUserSummaryAllBuilds:
do SummLine=1 to SummaryUserAllBldCount
call AddSummaryLine SummaryUserAllBldL.SummLine,SummaryUserAllBldR.SummLine
end
return

GenerateUserSummaryOverall:
do SummLine=1 to SummaryUserOverallCount
call AddSummaryLine SummaryUserOverallL.SummLine,SummaryUserOverallR.SummLine
end
return

AboutToGenerateSummary:
MaxSummaryLeft=0
SummaryLines=0
call Line1 ''
if arg(1)<> 'N' then
do
TitleText='Summary'
call ColorSet 'TITLE'
call Line1 TitleText
call Line1 copies('~',length(TitleText))
call ColorSet
end
return

AddSummaryLine:
parse arg SummaryLeft,SummaryRight
SummaryLeft=strip(SummaryLeft)
DropSym='!SUMMDROP.!' ||c2x(SummaryLeft)
if symbol(DropSym)='VAR' then
do
call DBG 'Summary line for "' || SummaryLeft || '" unwanted (dropped at ' || _valueG(DropSym) || ')'
return
end
if length(SummaryLeft)>MaxSummaryLeft then
MaxSummaryLeft=length(SummaryLeft)
SummaryLines=SummaryLines+1
SummaryL.SummaryLines=SummaryLeft
SummaryR.SummaryLines=SummaryRight
return

GenerateSummaryLines:
call ColorSet 'SUMMARY'
do SummLine=1 to SummaryLines
call Line1 "   " || left(SummaryL.SummLine, MaxSummaryLeft) || ': ' ||SummaryR.SummLine
end
call ColorSet
return

Summary_47:
PpwCompTime=NiceDateTime()
PpwCompTs=TimeStamp()
InputInterfaceVer="98.131"
OutputInterfaceVer="98.132"
call SetEnv "PPWIZARD_VER_II",InputInterfaceVer
call SetEnv "PPWIZARD_VER_OI",OutputInterfaceVer
ProtectPrefix='{PROTECT_' || time('Seconds') || '}'
ProtectFromPpwS="option PUSH LeaveBlankLines=YES KeepIndent=YES linecomment='NULL' LineContinuation='NULL' HashPrefix='" || ProtectPrefix || "'"
ProtectFromPpwE=ProtectPrefix|| 'option POP'
call QuickCheckForDebugSwitch
signal on NOVALUE name RexxTrapUninitializedVariable
signal on SYNTAX name RexxTrapSyntaxError
signal on HALT name RexxCtrlC
TrapHandler='FULL'
call InitCommandLineOptions2
call ProcessCommandLine
if InputMaskCount=0 then
do
if OptionNoFiles="" then
UserSyntaxError("No input masks specified and no default configured (/NOFILES)")
else
do
call ProcessCommandLineBit "/NOFILES",OptionNoFiles
if InputMaskCount=0 then
UserSyntaxError("No input masks specified and /NOFILES did not include a file mask!")
end
end
call CheckRexxInterpreter 'Y'
call DebugShowAsMuchEnvironmentDetailAsPossible
PpwUserDescription='PPWIZARD version ' || PgmVersion || ' on ' || PpWizardOpSysREAL ||  ', FREE tool for Windows, OS/2, DOS and UNIX by ' || PgmAuthor || ' (' || PgmHomePage || ')'
PgmDefaultHtmlMetaTags='<meta name="GENERATOR" content="' || PpwUserDescription || '"' || OptionXSlash || '>'
if HaveGeneratorTags='N' then
OptionHtmlGeneratorTags=PgmDefaultHtmlMetaTags
if OptionCloneUsed='Y' then
do
if InputMaskCount<2 then
UserSyntaxError('No clone destination supplied!')
CloneOutputMask=InputMask.InputMaskCount||RexDirChar|| '{' || '$path}' || RexDirChar || '*.*'
call ProcessCommandLineBit "CLONE", OptChar || 'Output:' || ReplaceString(CloneOutputMask, ' ', '{x20}')
InputMaskCount=InputMaskCount-1
end
InputMasksAllowed='N'
InpFileCount=0
InpFileCountActuallyMade=0
AllSameExtn=''
do SpecIndex=1 to InputMaskCount
InputList.0=0
TmpMask=InputMask.SpecIndex
call DBG 'Looking for files matching "' || TmpMask || '"'
if left(TmpMask,1)<> '+' then
FollowDirs='N'
else
do
FollowDirs='Y'
TmpMask=substr(TmpMask,2)
end
call Files4Mask TmpMask, 'InputList',FollowDirs
call DBGIND 1
call DBG 'Found ' || InputList.0 || ' files(s)'
call DBGIND 1
if InputList.0=0 then
do
call CheckForNotBeingAbleToExecAnything
WeWantToDie='Y'
if LookLikeASingleFile(TmpMask)='Y' then
do
if OptionDebugOn='N' then
do
call BeepsAllow 'N'
call ColorAllow 'N'
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
call DebugStateChanged
call DBG 'Debug forced on as we seem to have a file find problem!'
call DBGIND 1
call DBG 'We could not find "' || TmpMask || '", yet it seems to exist! We will solder on!'
call DBG 'Please send redirected output to "' || PgmAuthor || '" (' || PgmAuthorEmail || ')'
call DBG 'You could easily use a "GetFileList" ' || OptChar || 'Hook to workaround this.'
call DBGIND 1
call Files4Mask TmpMask, 'InputList',FollowDirs
call DBGIND-2
call DBG 'Turning off debug again'
OptionDebugOn='N'
call DebugStateChanged
end
InputList.0=1
InputList.1=TmpMask
WeWantToDie='N'
end
if WeWantToDie='Y' then
do
if InputMask0FilesOk.SpecIndex='Y' then
call DBG 'You indicated that 0 files were OK...'
else
do
Left1=left(InputMask.SpecIndex,1)
if Left1<> '-' & Left1 <> '/' then
Extra=''
else
Extra=' (all switches under ' || PpWizardOpSysREAL || ' must start with "' || OptChar || '")'
UserSyntaxError('No input files matched "' || InputMask.SpecIndex || '"' ||Extra)
end
end
end
call DBGIND-1
do InputIndex=1 to InputList.0
TheFile=InputList.InputIndex
call DBG TheFile
InpFileCount=InpFileCount+1
InpFile.InpFileCount=TheFile
InpFileMaskIndex.InpFileCount=SpecIndex
DotPos=lastpos('.',TheFile)
if DotPos<>0 then
do
FileExtn=translate(substr(TheFile,DotPos+1))
if InpFileCount=1 then
AllSameExtn=FileExtn
if AllSameExtn<>FileExtn then
AllSameExtn=''
end
end
call DBGIND-1
end
if InpFileCount=0 then
do
if Option0FilesTotalOk='N' then
UserSyntaxError('No files matched any of the input file masks (' || InputMaskCount || ') supplied!')
end
if AllSameExtn<> '' then
do
call DBG 'All input files end in the same extension (".' || AllSameExtn || '")'
call DBGIND 1
if OptionPrjExtn='' then
call DBG 'User has turned off Extensions based project files'
else
do
ExtnFile=ReplaceString(OptionPrjExtn, '*',AllSameExtn)
ExtnFile=FindProjectFile(ExtnFile)
if ExtnFile<> '' then
call ProcessCommandLineBit ExtnFile,OptChar|| 'LIST:' || ReplaceString(ExtnFile, ' ', '{x20}')
end
call DBGIND-1
end
if NewLineChars==CrLf then
LinesEndWith="CR followed by LF"
else
LinesEndWith="LF only"
call DBG 'Output lines are terminated with ' ||LinesEndWith
call DBG 'HTML Generator Tags are ' ||DebugRightArrow||OptionHtmlGeneratorTags||DebugLeftArrow
if OptionWantCopyright='Y' then
do
if OptionQuietDependsOn='N' then
call DisplayCopyright
end
call DebugStateChanged
if IncludeIntoMemory='' then
do
if InpFileCount=1 then
IncludeIntoMemory='N'
else
IncludeIntoMemory='Y'
end
call DBG 'Will read files into memory cache: ' ||IncludeIntoMemory
LastProcessingMode=ProcessingMode
LastOptionOutput=OptionOutput
LastOptionDependsOn=OptionDependsOn
call DBG "Starting processing of " || InpFileCount || ' file(s)'
PpwExitRc=0
ActuallyProcessed=0
FailedProcessingWarning=0
do InputIndex=1 to InpFileCount
ThisFile=InpFile.InputIndex
call DBG "Starting processing of file " || InputIndex || '/' || InpFileCount || ': "' || ThisFile || '"'
if symbol("_EXCLUDE_._EXF_" || c2x(UFile(ThisFile))) = 'VAR' then
do
if OptionRepeatsOfInputFileOK='Y' then
call DBG ThisFile|| ' not excluded because /RepeatsOfInputFileOK was used'
else
do
call DBG ThisFile|| ' excluded - ' || _valueG("_EXCLUDE_._EXF_" ||c2x(UFile((ThisFile))))
iterate
end
end
ActuallyProcessed=ActuallyProcessed+1
call _valueS "_EXCLUDE_._EXF_" || c2x(UFile((ThisFile))), "Already processed"
SpecIndex=InpFileMaskIndex.InputIndex
BaseDir4CurrentInputFile=InputMaskBDir.SpecIndex
hf!Pm=InputMaskPMode.SpecIndex
hf!Om=InputMaskOutMask.SpecIndex
hf!Dm=InputMaskDepMask.SpecIndex
CopyModeFuzz=InputMaskCpyFuzz.SpecIndex
if hf!Om='' then
do
if OptionCloneUsed='Y' then
hf!Om=CloneOutputMask
end
call DBG 'In 02.148 backwards compatability mode? : ' ||Bc02_148
if Bc02_148='Y' then
do
if hf!Pm='' then
hf!Pm=LastProcessingMode
if hf!Om='' then
hf!Om=LastOptionOutput
if hf!Dm='' then
hf!Dm=LastOptionDependsOn
end
else
do
if hf!Om='' then
do
hf!Om=GetEiOrLu(ThisFile, 'OM',LastOptionOutput)
if hf!Om='' then
CryAndDie('No default output mask configured for "' || ThisFile || '"', "See /ExtnInfo")
end
if hf!Pm='' then
do
hf!Pm=GetEiOrLu(ThisFile, 'PM',LastProcessingMode)
if hf!Pm='' then
CryAndDie('No default processing mode configured "' || ThisFile || '"', "See /ExtnInfo")
end
if hf!Dm='' then
hf!Dm=GetEiOrLu(ThisFile, 'DM',LastOptionDependsOn)
end
ProcessingMode=hf!Pm
OptionOutput=hf!Om
OptionDependsOn=hf!Dm
if OptionTemplate='' | ProcessingMode  = 'COPY' then
GenerateRc=GenerateOutput(ThisFile, '')
else
GenerateRc=GenerateOutput(OptionTemplate,ThisFile)
if GenerateRc>PpwExitRc then
PpwExitRc=GenerateRc
if OptionDebugOn='Y' then
call DBG 'The Exit Rc is currently "' || PpwExitRc || '"'
end
if ActuallyProcessed=0 then
do
if InpFileCount<>0 then
do
if Option0FilesTotalAfterExcludeOk='N' then
UserSyntaxError('All input files (' || InpFileCount || ') were excluded by you!')
end
end
call OutputAnySpellingAdditions
if OptionQuietDependsOn='Y' &InpFileCountActuallyMade=0 then
OptionSummary='N'
if OptionSummary='Y' then
do
if ActuallyProcessed<>1 then
do
call AboutToGenerateSummary
call GenerateUserSummaryOverall
call AddSummaryLine 'Operating Syst' ,PpWizardOpSys
call AddSummaryLine 'Rexx Version' ,RexVersionInfo
if InpFileCount=InpFileCountActuallyMade then
call AddSummaryLine '# files' ,InpFileCount
else
call AddSummaryLine '# files made' ,InpFileCountActuallyMade || ' out of ' ||InpFileCount
call AddSummaryLine 'Exit Code' ,PpwExitRc
if FailedProcessingWarning<>0 then
call AddSummaryLine '# Warnings' ,FailedProcessingWarning
call AddSummaryLine 'Elapsed Time'     ,_ElapsedTime(time('Elapsed'))
call GenerateSummaryLines
end
end
ThatsAllFolks(PpwExitRc)

GetSourceFileDateTimeDieOnError:
DateTimeRc=GetFileDateTimeButDontWarnOnError(arg(1))
if DateTimeRc=-1 then
CryAndDie('Could not get date/time stamp of "' || arg(1) || '".')
return(DateTimeRc)

InitLuCaseCfg:
CfgLower=''
CfgUpper=''
return

GetUserLcCfg:
if CfgLower=='' then
do
CfgLower=CfgMacro("PPWIZARD_LOWERCASE",LowerCase)
CfgUpper=CfgMacro("PPWIZARD_UPPERCASE",UpperCase)
end
return

GenerateOutput:
InputFile=arg(1)
TemplateDataFile=arg(2)
if TemplateDataFile<> '' then
if!TemplateProcessing='Y'
else
if!TemplateProcessing='N'
call ClearCollectedDependancyInfo
if if!TemplateProcessing='N' then
do
call DBG 'Main file is not a template, no point loading into memory'
InFile=InputFile
ForceBaseFile2Mem='N'
end
else
do
call DBG 'Main file is a template'
InFile=TemplateDataFile
ForceBaseFile2Mem=''
end
CurrentOutFile=GenerateFileName(InFile,OptionOutput)
call ClearDependancyTimeStampCache
InputFileFull=FileQueryExists(InputFile)
if NeedToRemake(InFile)='N' then
return(0)
if DependsOnCheckOnly='Y' then
do
call _ShowDependancyCheckProgress "We'd normally BUILD now but /DependsOnCheckOnly used..."
return(0)
end
if OptionDependsOn='' then
do
if ProcessingMode='COPY' then
do
if!Rc=AreFilesEqual(InputFileFull,CurrentOutFile,CopyModeFuzz)
if if!Rc='' then
return(0)
end
end
InpFileCountActuallyMade=InpFileCountActuallyMade+1
if OptionWantCopyright='Y' then
do
if OptionQuietDependsOn='Y' then
call DisplayCopyright
end
if!T=value('PPWBLDTITLE_' ||ProcessingMode)
if if!T<> '' then
do
if!T=ReplaceString(if!T, '{IS}', _filespec('N',InputFileFull))
if!T=ReplaceString(if!T, '{OS}', _filespec('N',CurrentOutFile))
if!T=ReplaceString(if!T, '{ID}', _filespec('L',InputFileFull))
if!T=ReplaceString(if!T, '{OD}', _filespec('L',CurrentOutFile))
if!T=ReplaceString(if!T, '{IL}',InputFileFull)
if!T=ReplaceString(if!T, '{OL}',CurrentOutFile)
if!T=ReplaceString(if!T, '{PM}',ProcessingMode)
call ColorSet 'TITLE'
call Line1 if!T
if ProcessingMode<> 'COPY' then
call Line1 copies('~',length(if!T))
end
call ColorSet
if if!TemplateProcessing='N' then
TmpTemplate=''
else
TmpTemplate=TemplateDataFile
call RexxHookSetBuildingParms InFile,CurrentOutFile,TmpTemplate
if RexxHookBefore<> '' then
call CallHook "BEFORE"
call SetUpOptionsForThisBuild
Dummy=time('Reset')
call DBGINDInit
call InitLuCaseCfg
call StackInitForBuild
call CompletelyInitializeAutoTagState
call InitINTERCEPTCode
call InitTransformationCode
call InitOutputHold
call InitializeCharCodes
call InitializeDefineRexx
call InitializeOneLine
call InitCondNlCount
call InitOnExitProcessing
call InitNextId
DebugIncludeNumber=0
Warnings=0
LineSourceBeingProcessed='?'
GeneratedLines=0
InputLines=0
PartialLine=''
IncludeLevel=0
EofForced=''
LineQueued=''
PPwizardUnique=0
StackCnt=0
OptionStackCnt=0
HtmlGeneratorTags=OptionHtmlGeneratorTags
AsIsModeOn='N'
if OptionCompleteAddToToDepFile='Y' then
do
call AddInputFileToDependancyList "*PpwPgm"
call AddInputFileToDependancyList "*CmdLine"
end
call PrepareSpellingForThisBuild
TsNewestSourcefile=GetSourceFileDateTimeDieOnError(PpWizardPgmName)
call InitializeHashDefinesForThisCompile
IfNesting=0
IfState.WantLines.0='Y'
IfState.IfTrue.0='Y'
IfState.InTrue.0='Y'
WantLineCache='Y'
GenerateRc=0
call CheckRexxInterpreter
if ProcessingMode='COPY' then
do
if!Rc=FileCopy(InputFileFull,CurrentOutFile)
call CreateDependancyFileFromLists
return(0)
end
OutputLevel=0
Ok2OutputHeader='Y'
call HaveNewOutputFile CurrentOutFile,,'N',ProcessingMode
do if!HI=1 to OptionHashIncludeCnt
if!List=OptionHashInclude.if!HI
do while if!List<> ''
parse var if!List if!This (PathDelimiterChar) if!List
if if!This<> '' then
do
call DBG '/#Include "' ||if!This
GenerateRc=GenerateRc+ProcessInputFile(if!This)
end
end
end
GenerateRc=GenerateRc+ProcessInputFile(InputFile,,ForceBaseFile2Mem)
if GenerateRc=0 then
do
call ValidateNesting "PPWIZARD"
if GeneratedLines=0 then
call OutputWarningToScreen 'GEN0', 'No output lines generated'
if OptionDebugOn='Y' then
call DBG 'No fatal errors detected so far'
end
call _FileClose CurrentOutFile
if RexxHookAfter<> '' then
call CallHook "AFTER"
if GenerateRc=0 then
do
if OptionDebugOn='Y' then
call DBG 'Looks OK so far, look for even more errors'
if PartialLine<> '' then
CryAndDie('A line continued to EOF')
call DoSyntaxCheckingOnFileIfEnabled CurrentOutFile
if OptionValidation<> '' then
do
ToExec=ReplaceHashAndStandardDefines(OptionValidation)
call RunExecOrValidateCmd 'VALIDATE',OptionValidationRc,ToExec
end
if Warnings<>0 then
do
FailedProcessingWarning=FailedProcessingWarning+1
GenerateRc=WantedWarningRc
end
if OptionNoDepFileOnWarnings='Y' &Warnings<>0 then
call DBG 'Dependancy file not created as warnings exist'
else
call CreateDependancyFileFromLists
if OptionSummary='Y' then
do
if InpFileCount=1 then
call AboutToGenerateSummary
else
call AboutToGenerateSummary 'N'
call GenerateUserSummaryThisBuild
call GenerateUserSummaryAllBuilds
if InpFileCount=1 then
call GenerateUserSummaryOverall
if Warnings<>0 then
call AddSummaryLine 'Warnings'        ,'YES (' || AddCommasToDecimalNumber(Warnings) || ')'
if InpFileCount=1 then
do
call AddSummaryLine 'Operating Syst' ,PpWizardOpSys
call AddSummaryLine 'Rexx Version' ,RexVersionInfo
end
call AddSummaryLine 'Return Code' ,GenerateRc
call AddSummaryLine 'Elapsed Time'        ,_ElapsedTime(time('Elapsed'))
call GenerateSummaryLines
end
end
call Line1 ''
call RexxHookSetBuildingParms
return(GenerateRc)

_ElapsedTime:
return(Seconds2Text(trunc(arg(1),2)))

MyLineNumber:
return(SIGL)

HandleIncludeFragment:
jf!U=translate(IncludeFragmentSpec)
select
when left(jf!U,3)='SE:' then
do
parse var IncludeFragmentSpec +3 jf!Del +1 jf!S (jf!Del) jf!E (jf!Del) jf!Crap
if jf!Crap<> '' then
do
IncludeLevel=IncludeLevel-1
if IncludeLevel<>0 then
call RecursiveIncludeRestore
CryAndDie('The "SE:" fragment spec:', '    ' || IncludeFragmentSpec, 'is not correctly formatted. ("' || jf!Crap || '" was unexpected)')
end
end
otherwise
do
jf!S=IncludeFragmentSpec
jf!E=jf!S
end
end
IncludeFragmentS=jf!S
IncludeFragmentE=jf!E
return

ProcessInputFile:
parse arg RequestedFile,kf!AddToDepFile,kf!ForceLoad2Mem,IncludeFragmentSpec
call HandleIncludeFragment
IncludeLineNumber=0
IncludeMemBufferNextLine=''
IncludeLoopMemBufferNextLine=''
DebugIncludeNumber=DebugIncludeNumber+1
DebugCurrentFileNumber=DebugIncludeNumber
IncludeFileName=FindFile(RequestedFile)
if IncludeFileName='' then
do
if IncludeLevel<>0 then
call RecursiveIncludeRestore
CryAndDie('File "' || RequestedFile || '" does not exist!')
end
IncludeLevel=IncludeLevel+1
IncludeFileName.IncludeLevel=IncludeFileName
if IncludeLevel>=InfiniteIncludeLoopWhen then
do
if InfiniteIncludeLoopWhen<>0 then
do
say 'Infinite #include loop detected, at level #' ||IncludeLevel
say 'Use "/define:INFINITE_INCLUDE_LOOP_WHEN=0"   to turn off detection'
say 'Use "/define:INFINITE_INCLUDE_LOOP_WHEN=100" to increase detection threshold etc'
IncludeLevel=IncludeLevel-1
call RecursiveIncludeRestore
CryAndDie("We seem to be in an infinite #include loop!")
end
end
MemUpdateIndex=0
do IncIndex=1 to IncludeLevel-1
if RexSystemOpSys="UNIX" then
IncSame=(IncludeFileName=IncludeFileName.IncIndex)
else
IncSame=(translate(IncludeFileName)=translate(IncludeFileName.IncIndex))
if IncSame=1 then
do
if _IncludeMemHandle.IncIndex<> '' then
call DBG 'File already being processed, already reading from memory cache!'
else
do
call DBG 'File already being processed, forcing use from memory cache'
call _FileClose IncludeFileName
MemUpdateIndex=IncIndex
kf!ForceLoad2Mem='Y'
end
leave
end
end
if kf!AddToDepFile<> 'N' then
call AddInputFileToDependancyList(/*RequestedFile*/IncludeFileName)
call ReadingI
ThisDateTime=GetSourceFileDateTimeDieOnError(IncludeFileName)
if ThisDateTime>TsNewestSourcefile then
TsNewestSourcefile=ThisDateTime
parse value IncludeFileOpen(IncludeFileName,kf!ForceLoad2Mem)with IncludeEofLine ';' IncludeMemHandle
if MemUpdateIndex<>0 then
do
_IncludeMemHandle.MemUpdateIndex=IncludeMemHandle
_IncludeEofLine.MemUpdateIndex=IncludeEofLine
end
if IncludeFragmentS<> '' then
do
call DBG 'Looking for the start of the fragment: ' ||IncludeFragmentS
do while IncludeFileLines()<>0
InputLines=InputLines+1
FileLine=IncludeFileLineIn()
if pos(IncludeFragmentS,FileLine)<>0 then
leave
end
if IncludeFileLines()=0 then
do
kf!FR=IncludeFragmentS
kf!FN=IncludeFileName
kf!LP=IncludeLineNumber
IncludeLevel=IncludeLevel-1
if IncludeLevel<>0 then
call RecursiveIncludeRestore
CryAndDie('Did not find the START of the code fragment "' || kf!FR || '" (searched ' || AddCommasToDecimalNumber(kf!LP) || ' lines in "' || kf!FN || '")')
end
call DBG 'Found it'
end
do forever
LastLineAfterMacroRep=''
select
when IncludeLoopMemBufferNextLine\=='' then
do
kf!LC='<<#{'
parse var IncludeLoopMemBufferNextLine FileLine (MarksNewLine) IncludeLoopMemBufferNextLine
LastLine=FileLine
LineSrc='M'
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine,kf!LC
end
when InLoop='Y' & LoopLineSrc = 'M' then
do
kf!LC='<<ML'
FileLine=GetLoopLineIntoFileLine()
LastLine=FileLine
LineSrc='M'
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine,kf!LC
end
when IncludeMemBufferNextLine\=='' then
do
kf!LC='<<<<'
parse var IncludeMemBufferNextLine FileLine (MarksNewLine) IncludeMemBufferNextLine
LastLine=FileLine
LineSrc='M'
if LinesFromOnExit='Y' then
LastFileLine=FileLine
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine,kf!LC
end
when LineQueued\=='' then
do
call FlushQueuedOutput
iterate
end
when InLoop='Y' |IncludeFileLines()<>0 then
do
if EofForced<> '' then
do
if OptionDebugOn='Y' then
call DBG '#EOF (at ' || EofForced || ') told us to stop processing this file any further'
if SetUpOnExitProcessingIfEndOfMainFile()='Y' then
iterate
leave
end
if InLoop='Y' then
do
FileLine=GetLoopLineIntoFileLine()
kf!LC='<<FL'
end
else
do
InputLines=InputLines+1
FileLine=IncludeFileLineIn()
kf!LC=''
end
LastFileLine=FileLine
LastLine=FileLine
LineSrc='F'
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine,kf!LC
if IncludeFragmentE<> '' then
do
if pos(IncludeFragmentE,FileLine)<>0 then
do
call DBG 'Found the end of the fragment'
IncludeFragmentE=''
leave
end
end
if OptionFilterIn<> '' then
do
FileLine=HtmlFilterIn("I",FileLine,IncludeFileName,IncludeLineNumber,InputLines,MarksNewLine)
if pos(MarksNewLine,FileLine)<>0 then
do
IncludeMemBufferNextLine=FileLine
iterate
end
if left(FileLine,1)=NullChar then
do
if FileLine=NullChar then
iterate
else
CryAndDie(substr(FileLine,2))
end
end
end
otherwise
do
if SetUpOnExitProcessingIfEndOfMainFile()='Y' then
iterate
leave
end
end
if LineSrc<> 'F' then
do
LineContinued='N'
Word1=word(FileLine,1)
end
else
do
if InterceptCode<> '' then
do
if FileLine=InterceptOffMarker then
do
if OptionDebugOn='Y' then
call DBG 'Intercepted line looks like end of block, not processed'
end
else
do
BeforeLine=FileLine
call ExecRexxCmd InterceptCode
if OptionDebugOn='Y' then
do
if BeforeLine==FileLine then
call DBG 'Intercepted line was not changed'
else
call DBG 'Intercepted Line changed to ' ||DebugRightArrow||FileLine||DebugLeftArrow
end
if BeforeLine\==FileLine then
do
if pos(MarksNewLine,FileLine)<>0 then
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=FileLine
else
IncludeLoopMemBufferNextLine=FileLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
end
end
iterate
end
end
end
end
if NextIdReplOn='Y' then
do
NidReplaceCount=ReplaceCount
FileLine=ReplaceString(FileLine,NextIdMarker,NextIdNew)
if NidReplaceCount<>ReplaceCount then
NextIdUsed='Y'
end
if AsIsModeOn='Y' then
FileLine=ExpandAsIsTags(FileLine)
if AutoTagOn='Y' then
FileLine=AutoTag(FileLine)
if pos(TabChar,FileLine)<>0 then
do
if OptionDebugOn='Y' then
call DBG 'Tab(s) found'
select
when OptionTabs='W' then
do
call OutputWarningToScreen 'T000', 'There are TABS in the source (converted to spaces)!'
FileLine=translate(FileLine, ' ',TabChar)
end
when OptionTabs='T' then
do
FileLine=translate(FileLine, ' ',TabChar)
end
when OptionTabs='E' then
do
FileLine=ExpandTabs(FileLine,WidthOfTab)
end
otherwise
do
end
end
end
if OptionHideCmdS_L<>0 then
do
PosS=pos(OptionHideCmdS,FileLine)
if PosS<>0 then
do
if OptionDebugOn='Y' then
do
call DBG 'At least one hidden command'
call DBGIND 1
end
RightBit=FileLine
LeftBit=''
do while PosS<>0
PosE=pos(OptionHideCmdE,RightBit,PosS)
if PosE=0 then
CryAndDie('Found start of hidden command ("' || OptionHideCmd || '"), but not the end!')
Hidden=strip(substr(RightBit,PosS+OptionHideCmdS_L,(PosE-PosS)-OptionHideCmdS_L))
if OptionDebugOn='Y' then
call DBG 'Found: ' ||DebugRightArrow||Hidden||DebugLeftArrow
LeftBit=LeftBit||left(RightBit,PosS-1)||Hidden
RightBit=substr(RightBit,PosE+OptionHideCmdE_L)
PosS=pos(OptionHideCmdS,RightBit)
end
FileLine=LeftBit||RightBit
if OptionDebugOn='Y' then
do
call DBG 'NewLine: ' ||DebugRightArrow||FileLine||DebugLeftArrow
call DBGIND-1
end
end
end
FileLine=strip(FileLine, 'T')
CmtPos=lastpos(InLineComment,FileLine)
if CmtPos<>0 then
do
AddToEnd=''
if right(FileLine,1)=LineContChar then
do
Right2=right(FileLine,2)
if Right2=LineContAddNewLine|Right2=LineContAddNewLineObs|Right2=LineContWithoutSpace|Right2=LineContWithSpace|Right2=LineContDefault then
do
AddToEnd=' ' ||Right2
end
end
FileLine=strip(left(FileLine,CmtPos-1), 'T')||AddToEnd
end
if ProcessingMode='REXX' then
do
if OptionDebugOn='N' then
do
if OptionKeepRexxCmts='N' &right(FileLine,2)=RexxCmtEnd then
do
StartCmtPos=lastpos(RexxCmtStart,FileLine)
if StartCmtPos<>0 then
do
if StartCmtPos=0 then
FileLine=''
else
FileLine=strip(left(FileLine,StartCmtPos-1), 'T')
if FileLine='' then
iterate
end
end
end
end
if LineContChar=NullChar then
LineContinued='N'
else
do
if right(FileLine,1)<>LineContChar then
LineContinued='N'
else
do
Right2=right(FileLine,2)
MainBit=strip(left(FileLine,length(FileLine)-2), 'T')
select
when Right2=LineContWithoutSpace then
do
LineContinued='Y'
FileLine=MainBit
end
when Right2=LineContWithSpace|Right2=LineContDefault then
do
FileLine=MainBit
LineContinued='YS'
end
when Right2=LineContAddNewLine then
do
LineContinued='Y'
FileLine=MainBit||CodexNewLine
end
when Right2=LineContAddNewLineObs then
do
call WarnAboutDepreciatedFeature 'Line continuation using downarrow.  Replace with -> "%\"'
LineContinued='Y'
FileLine=MainBit||CodexNewLine
end
otherwise
LineContinued='N'
end
end
end
if FileLine='' then
do
if LeaveBlankLines='N' then
do
if OptionDebugOn='Y' then
call DebugShowLineDropped "Blank Line"
if LineContinued='N' & PartialLine \== '' then
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=PartialLine
else
IncludeLoopMemBufferNextLine=PartialLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
end
end
PartialLine=''
end
iterate
end
end
Word1=word(FileLine,1)
if left(Word1,1)=LineComment then
do
if LineContinued='N' & PartialLine \== '' then
do
if OptionDebugOn='Y' then
call DebugWarning 'Line continuation ends with a comment line'
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=PartialLine
else
IncludeLoopMemBufferNextLine=PartialLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
end
end
PartialLine=''
end
iterate
end
if LineSrc='F' then
do
if KeepIndent='N' then
FileLine=strip(FileLine, 'L')
else
FileLine=LeftIndent||FileLine
end
if PartialLine<> '' then
do
if left(Word1,HashPrefixLng)<>HashPrefix then
do
PartialLine=PartialLine||FileLine
end
else
do
parse var FileLine TheHashCmd TheRest
TheRest=strip(TheRest)
FileLine=TheHashCmd|| ' ' ||TheRest
PartialLine=PartialLine||PpwCmdDivider1||FileLine||PpwCmdDivider1
if LineContinued='YS' then
LineContinued='Y'
end
end
if LineContinued='N' then
do
if PartialLine\=='' then
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=PartialLine
else
IncludeLoopMemBufferNextLine=PartialLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
end
end
PartialLine=''
iterate
end
end
else
do
if PartialLine=='' then
do
PartialLine=FileLine
if translate(left(Word1,length(CmdHashDefine)))=CmdHashDefine then
PpwCmdDivider1=MarksNewLineInHashDefine
else
PpwCmdDivider1=MarksNewLine
end
if LineContinued='YS' then
PartialLine=PartialLine|| ' '
iterate
end
end
if OneLineLevel<>0 then
do
FileLine=AddToOneLine(FileLine)
if FileLine=='' then
iterate
else
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=FileLine
else
IncludeLoopMemBufferNextLine=FileLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
end
end
LastFileLine=FileLine
iterate
end
end
if left(Word1,HashPrefixLng)=HashPrefix then
do
parse var FileLine HashCmd SecondWordEtc
HashCmd=translate(HashCmd)
HashRc='?'
select
when HashCmd=CmdHashIf then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashIfDef then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashIfnDef then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashElseifL|HashCmd=CmdHashElseifS then
HashRc=ProcessHashElse(SecondWordEtc)
when HashCmd=CmdHashEndifL|HashCmd=CmdHashEndifS then
HashRc=ProcessHashEndif(SecondWordEtc)
otherwise
end
if HashRc<> '?' then
do
if HashRc<> 'OK' then
call CryAndDie 'Hash command failed, Rc = ' ||HashRc
else
do
WantLineCache=WantLine()
iterate
end
end
end
if WantLineCache='N' then
do
if OptionDebugOn='Y' then
call DebugShowLineDropped "False"
iterate
end
if left(Word1,HashPrefixLng)=HashPrefix then
do
call ProcessHashCommand FileLine
end
else
do
if DefRexxVar<> '' then
do
call AddDefineRexxLine FileLine
iterate
end
if fb!VarNme<> '' then
do
call AddDataLine FileLine
iterate
end
if ReplacementsAllowed='Y' then
do
NowCount=ReplaceCount
FileLine=ReplaceHashAndStandardDefines(FileLine,, 'Y')
if ExpandXEarly='Y' then
do
if pos(StartsStdSymbolReplacement_x,FileLine)<>0 then
FileLine=ReplaceTheXCodesWeKnowExist(FileLine)
end
if NowCount<>ReplaceCount then
do
if pos(MarksNewLine,FileLine)<>0 then
do
do
if InLoop='Y' & LoopLineSrc = 'M' then
do
if IncludeLoopMemBufferNextLine=='' then
IncludeLoopMemBufferNextLine=FileLine
else
IncludeLoopMemBufferNextLine=FileLine||MarksNewLine||IncludeLoopMemBufferNextLine
end
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
end
end
iterate
end
end
if ExpandXLate='Y' then
do
if pos(StartsStdSymbolReplacement_x,FileLine)<>0 then
FileLine=ReplaceTheXCodesWeKnowExist(FileLine)
end
end
if TransformCodeLvl<>0 then
do
kf!Drop='N'
do kf!TNumb=TransformCodeLvl to 1 by-1 until DoPrevious<> 'Y'
call DBG 'Executing #transform #' ||kf!TNumb
kf!TF=TransformCode.kf!TNumb
if kf!TF='' then
leave
call DBGIND 1
FileRest=FileLine
FileAfter=''
AppendWith=''
Remove=''
DoPrevious='N'
do until FileRest==''
parse var FileRest FileLine (MarksNewLine) FileRest
Remove=''
BeforeLine=FileLine
call ExecRexxCmd kf!TF
if Remove<> '' then
call DBG 'Transform line dropped ==> ' ||Remove
else
do
FileAfter=FileAfter||AppendWith||FileLine
AppendWith=MarksNewLine
if OptionDebugOn='Y' then
do
if BeforeLine==FileLine then
call DBG 'Line was not transformed'
else
call DBG 'Line transformed to ' ||DebugRightArrow||FileLine||DebugLeftArrow
end
end
end
call DBGIND-1
if FileAfter='' & Remove <> '' then
do
kf!Drop='Y'
leave
end
FileLine=FileAfter
end
if kf!Drop='Y' then
iterate
end
if LineSrc='M' then
do
LineQueued=LineQueued||FileLine
iterate
end
do until FileLine == ''
parse var FileLine This1 (MarksNewLine) FileLine
if  ProcessingMode  = 'REXX' then
call OutputRexxLine This1
else
do
if  ProcessingMode <> 'HTML' then
call GenerateOneLine This1
else
do
if  ProcessingMode  = 'HTML' & HtmlGeneratorTags <> '' then
do
This1U  = translate(This1)
InsertTags = 'N'
InsBef     = ''
InsAft     = ''
LookFor = "<HEAD"
TagPos  = pos(LookFor, This1U)
if  TagPos <> 0 then
do
InsertTags = "Y"
InsBef     = MarksNewLine
InsAft     = InsBef
InsertAt   = TagPos + length(LookFor)
InsertAt   = pos('>', This1U, InsertAt)
if  InsertAt <> 0 then
InsertAt = InsertAt + 1
else
do
InsertTags        = "N"
HtmlGeneratorTags = ''
end
end
else
do
LookFor = "<BODY"
TagPos  = pos(LookFor, This1U)
if  TagPos <> 0 then
do
InsertTags = "Y"
InsBef     = '<head>' || MarksNewLine || '  '
InsAft     = MarksNewLine || '</head>' || MarksNewLine
InsertAt   = TagPos
end
end
if  InsertTags = 'Y' then
do
call DBG 'Found "' || LookFor || '" so inserted HTML generator tags'
if!Ins = ReplaceHashAndStandardDefines(HtmlGeneratorTags)
if!Ins = RepXCodes(if!Ins)
if!Ins = InsBef || if!Ins || InsAft
FileLine = insert(if!Ins, This1, InsertAt-1) || MarksNewLine || FileLine
HtmlGeneratorTags = ''
iterate
end
end
call GenerateOneLine This1
end
end
end
end
end
EofForced=''
call IncludeFileClose
if IncludeFragmentE<> '' then
CryAndDie('Did not find the END of the code fragment "' || IncludeFragmentE || '" (in "' || IncludeFileName || '")!')
IncludeLevel=IncludeLevel-1
if OptionDebugOn='Y' then
call DBG 'Finished processing the input file'
return(0)

FlushQueuedOutput:
if LineQueued=='' then
return
LineSrc='Q'
FileLine=LineQueued
LineQueued=''
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine, '>>>>'
do until FileLine == ''
parse var FileLine This1 (MarksNewLine) FileLine
if  ProcessingMode  = 'REXX' then
call OutputRexxLine This1
else
do
if  ProcessingMode <> 'HTML' then
call GenerateOneLine This1
else
do
if  ProcessingMode  = 'HTML' & HtmlGeneratorTags <> '' then
do
This1U  = translate(This1)
InsertTags = 'N'
InsBef     = ''
InsAft     = ''
LookFor = "<HEAD"
TagPos  = pos(LookFor, This1U)
if  TagPos <> 0 then
do
InsertTags = "Y"
InsBef     = MarksNewLine
InsAft     = InsBef
InsertAt   = TagPos + length(LookFor)
InsertAt   = pos('>', This1U, InsertAt)
if  InsertAt <> 0 then
InsertAt = InsertAt + 1
else
do
InsertTags        = "N"
HtmlGeneratorTags = ''
end
end
else
do
LookFor = "<BODY"
TagPos  = pos(LookFor, This1U)
if  TagPos <> 0 then
do
InsertTags = "Y"
InsBef     = '<head>' || MarksNewLine || '  '
InsAft     = MarksNewLine || '</head>' || MarksNewLine
InsertAt   = TagPos
end
end
if  InsertTags = 'Y' then
do
call DBG 'Found "' || LookFor || '" so inserted HTML generator tags'
if!Ins = ReplaceHashAndStandardDefines(HtmlGeneratorTags)
if!Ins = RepXCodes(if!Ins)
if!Ins = InsBef || if!Ins || InsAft
FileLine = insert(if!Ins, This1, InsertAt-1) || MarksNewLine || FileLine
HtmlGeneratorTags = ''
iterate
end
end
call GenerateOneLine This1
end
end
end
return

OutputInformationToScreen:
if OptionWantInfoMsgs='Y' then
do
InfoText=arg(1)
if IncludeLevel=0 then
LineText=''
else
LineText='(@' || AddCommasToDecimalNumber(IncludeLineNumber) || ')'
call ColorSet 'INFO'
call Line1 ReadingIndent()|| '  ' || LineText || 'INFO: ' ||InfoText
call ColorSet
end
return

ProcessHashCommand:
HashCmdMc=word(arg(1),1)
HashCmd=translate(HashCmdMc)
HashCmdParms=subword(arg(1),2)
select
when HashCmd=CmdHashDefine then
return(ProcessDefine(HashCmdParms))
when HashCmd=CmdHashDefinePlus then
return(ProcessDefine(HashCmdParms, 'Y'))
when HashCmd=CmdHashRexxVar then
return(ProcessRexxVar(HashCmdParms))
when HashCmd=CmdHashEvaluateL|HashCmd=CmdHashEvaluateS then
return(ProcessEvaluate(HashCmdParms))
when HashCmd=CmdHashEvaluatePlusL|HashCmd=CmdHashEvaluatePlusS then
return(ProcessEvaluate(HashCmdParms, 'Y'))
when HashCmd=CmdHashAutoTag then
do
ProcessRc=ProcessAutoTag(HashCmdParms)
return(ProcessRc)
end
when HashCmd=CmdHashUndefL|HashCmd=CmdHashUndefS then
return(HandleUndefCommand(HashCmdParms))
when HashCmd=CmdHashOption then
return(ProcessOption(HashCmdParms))
when HashCmd=CmdHashLoopS then
return(ProcessLoopStart(HashCmdParms))
when HashCmd=CmdHashLoopBreak then
return(ProcessLoopBreak(HashCmdParms))
when HashCmd=CmdHashLoopContinue then
return(ProcessLoopContinue(HashCmdParms))
when HashCmd=CmdHashInclude then
do
IncludeParms=strip(PerformReplacementsInCmdsParameters(HashCmdParms))
if IncludeParms="" then
return(CryAndDie("No filename specified on #include line!"))
QuoteChar=left(IncludeParms,1)
if QuoteChar<> '"' & QuoteChar <> "'" & QuoteChar <> "<" then
do
parse var IncludeParms IncludeName Fragment
end
else
do
if QuoteChar="<" then
QuoteChar='>'
IncludeParms=substr(IncludeParms,2)
QuotePos=pos(QuoteChar,IncludeParms)
if QuotePos=0 then
CryAndDie('Could not find the ending quote for the included filename')
IncludeName=left(IncludeParms,QuotePos-1)
Fragment=substr(IncludeParms,QuotePos+1)
if IncludeName='' then
CryAndDie('Invalid #include command, no filename passed!')
end
if Fragment<> '' then
Fragment=GetQuotedText(Fragment)
call RecursiveIncludeSave
call ProcessInputFile IncludeName,,,Fragment
call RecursiveIncludeRestore
call ReadingI
return(0)
end
when HashCmd=CmdHashImport then
return(ProcessImport(HashCmdParms))
when HashCmd=CmdHashOutput then
return(ProcessHashOutput(HashCmdParms))
when HashCmd=CmdHashOutputHold then
return(ProcessHashOutputHold(HashCmdParms))
when HashCmd=CmdHashDefineRexx then
return(ProcessDefineRexx(HashCmdParms))
when HashCmd=CmdHashDefineRexxPlus then
return(ProcessDefineRexx(HashCmdParms, 'Y'))
when HashCmd=CmdHashDefineIfReq then
return(ProcessDefine(HashCmdParms, '?'))
when HashCmd=CmdHash1Line then
return(ProcessOneLine(HashCmdParms,CmdHash1LineEnd))
when HashCmd=CmdHashData then
return(ProcessData(HashCmdParms))
when HashCmd=CmdHashOneLine then
return(ProcessOneLine(HashCmdParms))
when HashCmd=CmdHashMacroSpace then
do
call NotAvailableUnderNtYet HashCmd
Rest=PerformReplacementsInCmdsParameters(HashCmdParms)
MsCommand=translate(GetQuotedText(Rest, "Rest"))
MsFile=GetQuotedText(Rest, "Rest")
if Rest='' then
MsFunction=''
else
MsFunction=GetQuotedText(Rest)
if MsCommand<> 'ADD' & MsCommand <> 'DROP' then
CryAndDie('The macro space command "' || MsCommand || '" is unknown!')
if FileQueryExists(MsFile)='' then
CryAndDie('The rexx file "' || MsFile || '" does not exist!')
call DoMacroSpaceOperation MsCommand,MsFile,MsFunction
return(0)
end
when HashCmd=CmdHashAsIs then
return(ProcessAsIs(HashCmdParms))
when HashCmd=CmdHashWarningL|HashCmd=CmdHashWarningS then
return(ProcessHashWarning(HashCmdParms))
when HashCmd=CmdHashInfo then
do
InfoMsg=PerformReplacementsInCmdsParameters(HashCmdParms)
InfoMsg=GetQuotedRest(InfoMsg)
call OutputInformationToScreen InfoMsg
return(0)
end
when HashCmd=CmdHashPush then
return(ProcessPush(HashCmdParms))
when HashCmd=CmdHashPop then
return(ProcessPop(HashCmdParms))
when HashCmd=CmdHashAutoTagState then
return(ProcessAutoTagState(HashCmdParms))
when HashCmd=CmdHashAutoTagClear then
return(ProcessAutoTagClear(HashCmdParms))
when HashCmd=CmdHashDependsOn then
return(ProcessDependsOn(HashCmdParms))
when HashCmd=CmdHashOnExit then
return(ProcessOnExit(HashCmdParms))
when HashCmd=CmdHashEof then
do
if HashCmdParms<> '' then
do
EndifCounter=GetQuotedText(HashCmdParms)
EndifCounter=PerformReplacementsInCmdsParameters(EndifCounter)
if datatype(EndifCounter, 'W')=0 then
CryAndDie('Invalid #endif simulate count of "' || EndifCounter || '" supplied!')
do EndifIndex=1 to EndifCounter
call ProcessHashEndif
end
end
EofForced=CurrentSourceLocation()
return(0)
end
when HashCmd=CmdHashTransform then
return(ProcessTransform(HashCmdParms))
when HashCmd=CmdHashIntercept then
return(ProcessIntercept(HashCmdParms,HashCmdMc))
when HashCmd=CmdHashSystem then
return(ProcessSystem(HashCmdParms))
when HashCmd=CmdHashDebug then
return(ProcessHashDebug(HashCmdParms))
when HashCmd=CmdHashRequire then
return(ProcessRequire(HashCmdParms))
when HashCmd=CmdHashNextId then
return(ProcessNextId(HashCmdParms))
when HashCmd=CmdHashErrorL|HashCmd=CmdHashErrorS then
call ProcessHashError HashCmdParms
otherwise
do
if UserHashCmds='' then
call LookForUnknownCmdHandler
if UserHashCmds<> '' then
return(ProcessUnknownHashCommand(HashCmd,HashCmdParms))
if HashCmd=CmdHashLoopE then
CryAndDie('Missing "' || CmdHashLoopS || '" command')
else
CryAndDie("Invalid '#' command line of: " ||HashCmd)
end
end
return(0)

ProcessHashError:
ErrorMsg=GetQuotedRest(PerformReplacementsInCmdsParameters(arg(1)))
ErrorMsg=ReplaceString(ErrorMsg, '{NL}',MarksNewLine)
CryAndDie(ErrorMsg)

IsStringOnOrOffCmd:
OoCmd=translate(arg(1))
if OoCmd='+' | OoCmd = 'YES' |  OoCmd = 'ON' then
return('Y')
else
do
if OoCmd='-' | OoCmd = 'NO' |  OoCmd = 'OFF' then
return('N')
end
return('')

SetOnorOffVariable:
parse arg OnOffSrc,VarName
OnOrOffText=translate(GetQuotedText(OnOffSrc))
OnOrOff=IsStringOnOrOffCmd(OnOrOffText)
if OnOrOff='' then
CryAndDie(HashCmd|| ' command does not specify a correct value value (ON/OFF)!')
call _valueS VarName,OnOrOff
return(0)

DisplayCopyright:
if CopyrightDisplayed='N' then
do
if symbol("WizName") <> "VAR" then
WizName='PPWIZARD.REX'
call ColorSet 'HIGHLIGHT'
call Line1 '[]---------------------------------------------------------[]'
call Line1 '| ' || WizName || ': Version ' || PgmVersion || ' (' || PgmAuthorEmail || ')          |'
call Line1 '|               ' || PgmAuthorHomePage || '           |'
call Line1 '| (C)opyright ' || PgmAuthor || ' 1997-2014. ALL RIGHTS RESERVED. |'
call Line1 '[]---------------------------------------------------------[]'
call ColorSet
call Line1 ''
CopyrightDisplayed='Y'
end
return

CheckRexxInterpreter:
if RexWhich='REGINA' then
do
if pos(RexVerRegina,GetEnv("PPWIZARD_TEST_REGINA_VER") || ' ' ||SupportedReginaVersions)<>0 then
return(0)
criText='The Regina "' || RexVerRegina || '" interpreter is unsupported, use ' || SupportedReginaVersions || ' instead! I recommend "' || RecommendedReginaVersions || '"'
if arg(1)='Y' then
call DBG criText
else
call OutputWarningToScreen 'URI0',criText
return(1)
end
return(0)

NiceDateTime:
return(date('Weekday') || ', ' || date() || ' ' ||GetAmPmTime())

ReplaceEnv:call TRACE "OFF"
kf!Str=arg(1)
kf!New=''
do forever
kf!Pos=pos('%',kf!Str)
if kf!Pos=0 then
do
kf!New=kf!New||kf!Str
kf!Str=''
leave
end
else
do
kf!New=kf!New||left(kf!Str,kf!Pos-1)
kf!Str=substr(kf!Str,kf!Pos+1)
kf!Pos=pos('%',kf!Str)
if kf!Pos=0 then
kf!New=kf!New|| '%'
else
do
VarName=left(kf!Str,kf!Pos-1)
VarVal=GetEnv(VarName)
if VarVal=='' then
do
kf!New=kf!New|| '%' ||left(kf!Str,kf!Pos-1)
kf!Str=substr(kf!Str,kf!Pos)
end
else
do
kf!New=kf!New||VarVal
kf!Str=substr(kf!Str,kf!Pos+1)
end
end
end
end
return(kf!New)

GetInputFileNameAndLine:call TRACE "OFF"

CurrentSourceLocation:
if IncludeLevel<>0 then
return('line ' || AddCommasToDecimalNumber(IncludeLineNumber) || ' of "' || IncludeFileName || '"')
else
do
if arg(1, 'E')then
return(arg(1))
else
return("unknown")
end

GetLineBeingProcessed:call TRACE "OFF"
return(strip(LastLine))

GetFileLineBeingProcessed:call TRACE "OFF"
return(strip(LastFileLine))

DumpVarsIfCompoundVariable:
if pos('.',arg(1))<>0 then
ExpressionKilledUs=arg(1)
return

CheckForNotBeingAbleToExecAnything:
CheckAddressCmdCnt=CheckAddressCmdCnt+1
if RexWhich='REGINA' then
do
DoWhat='Simple test of execution of shell commands'
call DBG DoWhat
TmpFile=RexGetTmpFileName('ce??????.PPW')
Tried='echo ' ||DoWhat||RedirectStdOutAndErr2(TmpFile)
call AddressCmd Tried,TmpFile
if FileQueryExists(TmpFile)='' then
do
NL=MarksNewLine
EM="Can't execute shell functions! could not create the" ||NL
EM=EM|| 'file "' || TmpFile || '".' ||NL
EM=EM||NL
EM=EM|| "This command failed:" ||NL||NL
EM=EM|| "    " ||Tried||NL||NL
EM=EM||NL
EM=EM|| 'Please report the problem to "' || PgmAuthorEmail || '" (please attach' ||NL
EM=EM|| 'zipped output with "' || OptChar  || 'debug" switch used)!' ||NL
EM=EM||NL
EM=EM|| 'Its possible one of the following environment variables is corrupt or' ||NL
EM=EM|| 'contains and invalid value (do you have permissions for temp directories etc):' ||NL
EM=EM||NL
EM=EM|| '   * TMP     = "' || GetEnv('TMP')     || '"' ||NL
EM=EM|| '   * TEMP    = "' || GetEnv('TEMP')    || '"' ||NL
EM=EM|| '   * COMSPEC = "' || GetEnv('COMSPEC') || '"'
if symbol("DebugLevel") = "VAR" then
CryAndDie(EM)
else
do
say copies('$#',38)
say EM
say copies('$#',38)
exit 678
end
end
call _SysFileDelete TmpFile
call DBG 'Looks OK to me!'
end
return

LookLikeASingleFile:
FileName=arg(1)
call DBG 'No files matched "' || FileName || '", does it look like a single file?'
if verify(FileName, '*?', 'M')<>0 then
NormalFile='N'
else
do
if FileQueryExists(FileName)='' then
NormalFile='N'
else
NormalFile='Y'
end
call DBGIND 1
call DBG 'Normal File: ' ||NormalFile
call DBGIND-1
return(NormalFile)

DieIfNotRexxSymbol:
parse arg lf!V
if symbol(lf!V)='BAD' | datatype(left(lf!V, 1) , 'W')then
CryAndDie('"' || lf!V || '" is not a valid rexx variable name!')
return

CryAndDie:
SynErrLine=SIGL
SynErrLineC=AddCommasToDecimalNumber(SynErrLine)
call DBGINDInit
call DBG 'Fatal Error Detected (at line ' || SynErrLineC || ' of ppwizard)'
call DBGIND 1
PpwSize=FileQuerySize(PpWizardPgmName)
if PpwSize<> '' then
PpwSize=AddCommasToDecimalNumber(PpwSize)
PpwDateTime=GetFileTimeStamp(PpWizardPgmName)
call AllFollowingOutputGoesToErrorFile
call ColorSet 'ERROR'
call Line1 ''
call Line1 copies('!!',38)
call Line1 copies('!!', 15) || '[ Fatal  Error ]' || copies('!!',15)
call Line1 copies('!!',38)
call CgiStartFatalError
call OutputErrorLocationDetails "Y"
call Line1 'Reason'
call Line1 '~~~~~~'
LastArg=1
do LineIndex=1 to arg()
if arg(LineIndex)<> '' then
LastArg=LineIndex
end
do LineIndex=1 to LastArg
call Line1 arg(LineIndex)
end
if ExpressionKilledUs<> '' then
call DumpVarsInExpression ExpressionKilledUs,, "KNOWN VARIABLES"
call CgiEndFatalError
call Line1 copies('!!',38)
call Line1 ''
call Line1 ''
call AddColorDelayWorkaroundForTee
call ColorSet
call Beeps
if RexxHookError<> '' then
do
do LineIndex=1 to LastArg
call SetEnv "PPWH_ERROR" ||LineIndex,arg(LineIndex)
end
call CallHook "ERROR",,LastArg
do LineIndex=1 to LastArg
call SetEnv "PPWH_ERROR" || LineIndex, ''
end
end
AbnormalExit(SynErrLine)

RexSystemFailure:
FailedAt=SIGL
if TrapHandler='FULL' then
call DBG 'RexSystemFailure(REXSYSTM.XH routine failed)'
call DisplayCopyright
call RexDumpSystemInfo
say ''
if TrapHandler='FULL' then
CryAndDie(arg(1))
say 'ERROR'
say '~~~~~'
say arg(1)
call CallErrorHookForSimpleOneLiner arg(1)
ExitNowCallingAnyHandlers(FailedAt)

CallErrorHookForSimpleOneLiner:
if RexxHookError<> '' then
do
call SetEnv "PPWH_ERROR1",arg(1)
call CallHook "ERROR",,1
call SetEnv "PPWH_ERROR1", ''
end
return

AbnormalExit:
call DBG 'AbnormalExit(' || arg(1) || ') called.'
if arg(2)<> '' then
call CallErrorHookForSimpleOneLiner arg(2)
ThatsAllFolks(arg(1))

ThatsAllFolks:
mf!Rc=arg(1)
call DBG 'ThatsAllFolks() called to exit program.'
if CurrentOutFile<> '' then
call _FileClose CurrentOutFile
if IncludeLevel<>0 then
do
do FileIndex=1 to IncludeLevel
call _FileClose IncludeFileName.FileIndex
end
end
call CloseCgiFileIfOpen
if OptionFilterIn<> '' then
call DoMacroSpaceOperation "DROP", OptionFilterIn,  "HtmlFilterIn",  "QUIET"
if OptionFilterOut<> '' then
call DoMacroSpaceOperation "DROP", OptionFilterOut, "HtmlFilterOut", "QUIET"
call DBG 'Exiting with a return code of ' ||mf!Rc
if OptionCgiModeOn='N' then
do
if mf!Rc<=1 then
OnExitSleepFor=OnExitSleepForOk
else
OnExitSleepFor=OnExitSleepForError
if OnExitSleepFor<>0 then
do
call DBG 'Sleeping for ' || OnExitSleepFor || ' second(s)'
call _SysSleep OnExitSleepFor
end
end
ExitNowCallingAnyHandlers(mf!Rc)

_ReplaceConsoleHandlers:
parse arg mf!Val,mf!Bef,mf!Aft
mf!Before='{' || mf!Bef || '}'
if pos(mf!Before,mf!Val)<>0 then
do
if mf!Aft='' then
do
call Line1 'No value known for "' || mf!Before || '"' ||d2c(7)
call Sleep 3
return('')
end
mf!Val=ReplaceString(mf!Val,mf!Before,mf!Aft)
end
return(mf!Val)

RunScheduledCleanupCode1:
OnExitRexCode=arg(1)
signal ON SYNTAX NAME _SyntaxErrorDuringScheduledRexxCleanupCode
signal ON NOVALUE NAME _UnknownVariableDuringScheduledRexxCleanupCode
signal off HALT
call DBG "ONEXIT REXX"
call DBG "~~~~~~~~~~~"
call DBG OnExitRexCode
interpret OnExitRexCode
return

_SyntaxErrorDuringScheduledRexxCleanupCode:
ErrNo=Rc
call ColorSet 'ERROR'
call Line1 'EXIT CLEANUP: SYNTAX ERROR: ' ||errortext(ErrNo)
call ColorSet 'DEFAULT'
call Line1 ''
call Beeps
return

_UnknownVariableDuringScheduledRexxCleanupCode:
call ColorSet 'ERROR'
call Line1 'EXIT CLEANUP: The rexx variable "' || condition('D') || '" is unknown!'
call ColorSet 'DEFAULT'
call Line1 ''
call Beeps
return

RunScheduledCleanupCode:
if ExitCuc.0=0 then
return
do mf!Cuci=1 to ExitCuc.0
call RunScheduledCleanupCode1 ExitCuc.mf!Cuci
end
return

_CallExitHandler:
nf!Handler=arg(1)
nf!Type=arg(2)
if nf!Handler<> '' then
do
call DBG 'A ' || nf!Type || ' exit handler exists...'
call DBGIND 1
nf!Handler=_ReplaceConsoleHandlers(nf!Handler, 'ConsoleFile',ConsoleFile)
nf!Handler=_ReplaceConsoleHandlers(nf!Handler, 'ErrorFile',ConsoleErrorFile)
if nf!Handler<> '' then
call AddressCmd nf!Handler
call DBGIND-1
end
call RunScheduledCleanupCode
return

ExitNowCallingAnyHandlers:
of!Rc=arg(1)
if of!Rc=0|of!Rc=1 then
call _CallExitHandler PpwOnOK, "success"
else
do
call DeletingOnError
call _CallExitHandler PpwOnERROR, "failure"
end
call FileDeleteQueued
call ColorSet 'RESET'
exit(of!Rc)

AddColorDelayWorkaroundForTee:
if OptionTeeDelay<>0 then
call sleep 1
return

ValidateNesting:
if arg(1)="PPWIZARD" then
of!FNV='Y'
else
of!FNV='N'
call StackValidation
if OptionDebugOn='Y' then
call DBG 'Generation successful so far, look for nesting and other errors'
select
when IfNesting<>0 then
do
do Index=1 to IfNesting
NestingLevel=(IfNesting-Index)+1
call DBG 'Missing #endif at EOF - Nesting Level #' ||NestingLevel||MatchesIfDebugText(NestingLevel)
end
CryAndDie('Missing #endif at EOF' ||MatchesIfDebugText(IfNesting))
end
when StackCnt<>0 then
do
do Index=1 to StackCnt
NestingLevel=(StackCnt-Index)+1
call DBG 'Missing #RexxVar pop at EOF - Nesting Level #' ||NestingLevel||MatchesStackPushDebugText(NestingLevel)
end
CryAndDie('Incorrect #RexxVar push/pop nesting at EOF' ||MatchesStackPushDebugText(StackCnt))
end
when OptionStackCnt<>0 then
do
do Index=1 to OptionStackCnt
NestingLevel=(OptionStackCnt-Index)+1
call DBG 'Missing pop() at EOF - Nesting Level #' ||NestingLevel||MatchesOptionStackPushDebugText(NestingLevel)
end
CryAndDie('Missing #Option pop at EOF' ||MatchesOptionStackPushDebugText(OptionStackCnt))
end
when AutoTagStateCnt<>0 then
do
do Index=1 to AutoTagStateCnt
NestingLevel=(AutoTagStateCnt-Index)+1
call DBG 'Missing #AutoTagState- at EOF - Nesting Level #' ||NestingLevel||MatchesAutoTagStateIncDebugText(NestingLevel)
end
CryAndDie('Missing #AutoTagState- at EOF' ||MatchesAutoTagStateIncDebugText(AutoTagStateCnt))
end
when DefRexxVar<> '' then
CryAndDie('Missing #DefineRexx[+] at EOF', 'Block started at ' ||DefRexxStartLoc)
when(OutputLevel>1)&(of!FNV='Y')then
CryAndDie('Missing ' || OutputLevel - 1 || ' #output command(s) at EOF')
when OutputHoldLvl<>0&(of!FNV='Y')then
CryAndDie('Missing #Output (end) at EOF', 'LAST Block started at ' ||OutHold_.OutputHoldLvl.!OutpHoldStartLoc)
otherwise
call DieIfHoldingOutput
end
return
signal INDENT_48

EXTRAINDENT_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'EXTRAINDENT', 'Extra left indent is now "' || LeftIndent || '"'
return

EXTRAINDENT_GET:
call EXTRAINDENT_DEBUG
return(LeftIndentSet2)

EXTRAINDENT_SET:
LeftIndentSet2=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'EXTRAINDENT', 'Setting default value of extra left indent to "' || LeftIndentSet2 || '"'
Default4_LeftIndent=LeftIndentSet2
return(0)
end
if LeftIndentSet2=='' then
LeftIndentCmd=Default4_LeftIndent
else
LeftIndentCmd=LeftIndentSet2
if translate(LeftIndentCmd)='NULL' then
LeftIndent=''
else
call ExecRexxCmd "LeftIndent = " ||LeftIndentCmd
call EXTRAINDENT_DEBUG
return

INDENT_48:

_DieAsNoTextConditionSupplied:
CryAndDie('No test condition supplied on "#if" command')

_PerformSimpleHashIfTest:
SimpleTest=arg(1)
if left(SimpleTest,1)<> '[' | right(SimpleTest, 1) <> ']' then
CryAndDie('Incorrectly bracketed simple #if command.')
SimpleTest=substr(SimpleTest,2,length(SimpleTest)-2)
if SimpleTest='' then
call _DieAsNoTextConditionSupplied
Parm1=GetSimpleRexxValue(SimpleTest, "SimpleTest")
parse var SimpleTest FastOperator SimpleTest
if SimpleTest='' then
CryAndDie('#if [] has too few parameters (you must put spaces around operator!)')
Parm3=GetSimpleRexxValue(SimpleTest, "SimpleTest")
if SimpleTest<> '' then
CryAndDie('#if [] has too many parameters, expected 3!')
select
when FastOperator='==' then
return(Parm1==Parm3)
when FastOperator='<>' then
return(Parm1<>Parm3)
when FastOperator='=' then
return(Parm1=Parm3)
when FastOperator='<' then
return(Parm1<Parm3)
when FastOperator='>' then
return(Parm1>Parm3)
when FastOperator='<=' then
return(Parm1<=Parm3)
when FastOperator='>=' then
return(Parm1>=Parm3)
otherwise
CryAndDie("Unsupported operator of '" || FastOperator || "' used on simple " || HashCmd, '', 'ONLY "==, <>, =, <, >, <=, >=" are supported!')
end
CryAndDie('BUG: Did not expect to get here!')

MatchesIfDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches #if at ' || IfState.IfAtLine.MatchIndex || ')')

WantLine:
if IfState.WantLines.IfNesting='N' then
return('N')
else
do
if IfState.IfTrue.IfNesting=IfState.InTrue.IfNesting then
return('Y')
else
return('N')
end

ProcessHashIfTest:
if OptionDebugOn='Y' then
do
call DBG_CONDITIONAL '#If? at nesting level ' ||IfNesting+1
call DBGIND 1
end
WantTheLines=WantLine()
if WantTheLines='N' then
IfResult='N'
else
do
if OptionDebugOn='Y' then
call DBGIND 1
parse value PerformReplacementsInCmdsParameters(arg(1))with HashCmd TestCondition
TestCondition=strip(TestCondition)
if translate(HashCmd)=CmdHashIf then
do
if left(TestCondition,1)<> '[' then
do
if TestCondition='' then
call _DieAsNoTextConditionSupplied
call ExecRexxCmd 'IfResult = (' || TestCondition || ')'
end
else
do
IfResult=_PerformSimpleHashIfTest(TestCondition)
end
if IfResult then
IfResult='Y'
else
IfResult='N'
end
else
do
if TestCondition='' then
CryAndDie(HashCmd|| ' command does not specify the macro name!')
if pos('CommentBlock  /* ',TestCondition)<>0 then
IfResult='N'
else
IfResult=MacroExists(TestCondition)
if translate(HashCmd)=CmdHashIfndef then
IfResult=translate(IfResult, 'YN', 'NY')
end
if OptionDebugOn='Y' then
do
call DBGIND-1
if IfResult='N' then
Tf='FALSE'
else
Tf='TRUE'
if OptionDebugOn='Y' then
call DBG_CONDITIONAL 'Answer is ' ||Tf
end
end
IfNesting=IfNesting+1
IfState.WantLines.IfNesting=WantTheLines
IfState.InTrue.IfNesting='Y'
IfState.IfTrue.IfNesting=IfResult
IfState.IfAtLine.IfNesting=CurrentSourceLocation()
if OptionDebugOn='Y' then
call DBGIND-1
return('OK')

ProcessHashElse:
if OptionDebugOn='Y' then
call DBG_CONDITIONAL '#elseif at level #' ||IfNesting||MatchesIfDebugText(IfNesting)
if IfNesting=0 then
CryAndDie("Found #elseif without matching #if")
if IfState.InTrue.IfNesting='N' then
CryAndDie("Found unexpected #elseif - duplicated #elseif?" ||MatchesIfDebugText(IfNesting))
if arg(1)<> '' then
CryAndDie('The #elseif command does not take parameters')
IfState.InTrue.IfNesting='N'
return('OK')

ProcessHashEndif:
if OptionDebugOn='Y' then
call DBG_CONDITIONAL 'Endif at level #' ||IfNesting||MatchesIfDebugText(IfNesting)
if IfNesting=0 then
CryAndDie("Found #endif without matching #if")
IfNesting=IfNesting-1
return('OK')

HaveNewOutputFile:
parse arg pf!OutFile,pf!GenMask,pf!Append,pf!Mode,pf!StartHeld
if OutputLevel<>0 then
call _FileClose CurrentOutFile
if OptionCgiModeOn='Y' then
do
CurrentOutFile=RexStdoutStream
call DBG 'In CGI mode, will output to "' || CurrentOutFile || '" (standard output)'
end
else
do
if pf!GenMask<> '' then
CurrentOutFile=GenerateFileName(pf!OutFile,pf!GenMask)
else
do
CurrentOutFile=pf!OutFile
call MakeDirectoryTree _filespec('drive', CurrentOutFile) || _filespec('path',CurrentOutFile)
end
end
pf!OutLine=CurrentOutLine
CurrentOutLine=0
do ChkIndex=1 to OutputLevel
if RexSystemOpSys="UNIX" then
OutSame=(Output.ChkIndex.File=CurrentOutFile)
else
OutSame=(translate(Output.ChkIndex.File)=translate(CurrentOutFile))
if OutSame then
do
if pf!Append='Y' then
call OutputWarningToScreen 'OFO0', 'Appending to currently opened file ("' || CurrentOutFile || '")!'
else
do
WhereOpened=Output.ChkIndex.!Locn
if WhereOpened='' then
Extra='Check "/Output" mask for correctness'
else
Extra='File opened at ' ||WhereOpened
CryAndDie('Already have "' || CurrentOutFile || '" open for output!',Extra)
end
end
end
OutputLevel=OutputLevel+1
Output.OutputLevel.File=CurrentOutFile
Output.OutputLevel.Line=pf!OutLine
Output.OutputLevel.!Locn=CurrentSourceLocation('')
Output.OutputLevel.!PMODE=ProcessingMode
Output.OutputLevel.!HTAGS=HtmlGeneratorTags
if ProcessingMode<>pf!Mode then
do
call DBG 'Processing mode for "' || CurrentOutFile || '" is "' || pf!Mode || '" (changed from "' || ProcessingMode || '")'
ProcessingMode=pf!Mode
end
pf!Hdr='Y'
if OptionCgiModeOn='N' then
do
if FileQueryExists(CurrentOutFile)<> "" then
do
if pf!Append='Y' then
do
call DBG 'Appending to "' || CurrentOutFile || '"'
pf!Hdr='N'
end
else
do
call DBG 'Deleting "' || CurrentOutFile || '"'
call MustDeleteFile CurrentOutFile
end
end
end
call AddOutputFileToDependancyList CurrentOutFile
HtmlGeneratorTags=OptionHtmlGeneratorTags
if pf!StartHeld='Y' then
call ProcessHashOutputHold ''
call charout CurrentOutFile, ""
call _FileClose CurrentOutFile
call Making,'C'
call _ExecUserHook 'START'
if pf!Hdr='Y' then
do
if Ok2OutputHeader='Y' then
call OutputHeaderIfWantedOrRequired
end
Output.OutputLevel.!SYNRC=OutSyntaxRc
Output.OutputLevel.!SYNCMD=OutSyntaxCmd
Output.OutputLevel.!SYNMSG=OutSyntaxMsg
Output.OutputLevel.!SYNCODE=OutSyntaxCode
Output.OutputLevel.!SYNELM=OutSyntaxErrLineMask
call OutputSyntaxCheckingHeaderIfWantedOrRequired
call _ExecUserHook 'AFTER_HEADERS'
return

_BackToPreviousOutput:
call _ExecUserHook 'END'
call _FileClose CurrentOutFile
call DBG 'Closed the Output file = "' || CurrentOutFile || '" (wrote ' || CurrentOutLine || ' line(s))'
call DoSyntaxCheckingOnFileIfEnabled CurrentOutFile
if OutputLevel<=1 then
CryAndDie('No output files on stack!')
else
do
HtmlGeneratorTags=Output.OutputLevel.!HTAGS
OutSyntaxRc=Output.OutputLevel.!SYNRC
OutSyntaxCmd=Output.OutputLevel.!SYNCMD
OutSyntaxMsg=Output.OutputLevel.!SYNMSG
OutSyntaxCode=Output.OutputLevel.!SYNCODE
OutSyntaxErrLineMask=Output.OutputLevel.!SYNELM
CurrentOutLine=Output.OutputLevel.Line
OutputLevel=OutputLevel-1
CurrentOutFile=Output.OutputLevel.File
if ProcessingMode<>Output.OutputLevel.!PMODE then
do
ProcessingMode=Output.OutputLevel.!PMODE
call DBG 'Restoring mode for "' || CurrentOutFile || '" to "' || ProcessingMode || '"'
end
call DieIfHoldingOutput
call OutputHoldPop
end
call Making,'R'
return

ExtnInfoSet:
qf!S=arg(1)
call DBG '/ExtnInfoSet: ' ||qf!S
call DBGIND 1
if qf!S='' then
do
call DBG 'Clearning all configured EXTNINFO'
drop PPWEXTNINFO.
end
else
do
parse var qf!S qf!E ':' qf!Parms
if qf!Parms='' then
CryAndDie("Invalid EXTNINFO value of:",qf!S)
if RexSystemOpSys<> "UNIX" then
qf!E=translate(qf!E)
do while qf!E<> ''
parse var qf!E qf!1 ',' qf!E
call DBG 'Extn Info for .' ||qf!1
call DBGIND 1
qf!R=qf!Parms
do while qf!R<> ''
parse var qf!R qf!Var '=' qf!R
qf!Var=strip(qf!Var)
qf!Val=GetQuotedText(qf!R, "qf!R", ',')
if qf!Var="PM" then
do
if translate(left(qf!Val,3))='LU:' then
qf!T=substr(qf!Val,4)
else
qf!T=qf!Val
call ValidatePMode qf!T
end
call DBG qf!Var|| ' = ' ||qf!Val
qf!Key='PPWEXTNINFO.PPWEI_' || c2x(qf!Var) || '_' ||c2x(qf!1)
call value qf!Key,qf!Val
qf!R=strip(qf!R)
if left(qf!R,1)=',' then
qf!R=substr(qf!R,2)
end
call DBGIND-1
end
end
call DBGIND-1
return

ExtnInfoGet:
parse arg rf!E,rf!W,rf!Def
if RexSystemOpSys<> "UNIX" then
rf!E=translate(rf!E)
rf!Pre='PPWEXTNINFO.PPWEI_' || c2x(rf!W) || '_'
rf!Key=rf!Pre||c2x(rf!E)
if symbol(rf!Key)='VAR' then
rf!R=value(rf!Key)
else
do
rf!Key=rf!Pre||c2x('*')
if symbol(rf!Key)='VAR' then
rf!R=value(rf!Key)
else
rf!R=rf!Def
end
call DBG 'ExtnInfoGet(EXTN=' || rf!E || ', WANT=' || rf!W || ') => ' ||rf!R
return(rf!R)

GetEiOrLu:
parse arg sf!F,sf!W,sf!LU
call DBG 'GetEiOrLu(' || sf!F || ')'
call DBGIND 1
sf!E=_filespec('E',sf!F)
OptionSrcExtn="PPWSRC"
if RexSystemOpSys<> "UNIX" then
sf!E=translate(sf!E)
if sf!E=OptionSrcExtn then
do
sf!E=_filespec('E', _filespec('W',sf!F))
call DBG 'The file has the single SRC extension, so process as extension "' || sf!E || '"!'
end
sf!R=ExtnInfoGet(sf!E,sf!W)
if translate(left(sf!R,3))='LU:' then
do
if sf!LU<> '' then
sf!R=sf!LU
else
sf!R=substr(sf!R,4)
end
call DBG 'Returning: ' ||sf!R
call DBGIND-1
return(sf!R)

StoreOutHeader:
tf!Spec=arg(1)
tf!Del=left(tf!Spec,1)
call DBG '/OutHeader SPEC: ' ||tf!Spec
parse var tf!Spec (tf!Del) tf!Extn (tf!Del) tf!S (tf!Del) tf!M (tf!Del) tf!E (tf!Del) .
if RexSystemOpSys<> "UNIX" then
tf!Extn=translate(tf!Extn)
tf!Key='OUTHDR_' ||c2x(tf!Extn)
call value tf!Key,tf!S|| '00'x || tf!M || '00'x||tf!E
return

StoreSyntaxCheckCode4Header:
uf!Spec=arg(1)
uf!Del=left(uf!Spec,1)
call DBG '/Syntax SPEC: ' ||uf!Spec
parse var uf!Spec (uf!Del) uf!Extn (uf!Del) uf!Cmd (uf!Del) uf!Rc (uf!Del) uf!Mask (uf!Del) uf!Lines (uf!Del)
if RexSystemOpSys<> "UNIX" then
uf!Extn=translate(uf!Extn)
uf!Key='OUTHDRSYN_' ||c2x(uf!Extn)
if uf!Cmd='' then
drop(uf!Key)
else
do
ReplaceCount=0
uf!Lines=ReplaceString(uf!Lines,uf!Del, 'FF'x)
call value uf!Key,uf!Cmd|| '00'x || uf!Rc || '00'x || uf!Mask || '00'x||uf!Lines
end
return

OutputHeaderIfWantedOrRequired:
vf!CmtS=''
vf!CmtM=''
vf!CmtE=''
vf!Extn=_filespec('EXTN',CurrentOutFile)
if RexSystemOpSys<> "UNIX" then
vf!Extn=translate(vf!Extn)
vf!KeyE='OUTHDR_' ||c2x(vf!Extn)
vf!KeyM='OUTHDR_' || c2x('*' ||ProcessingMode)
vf!KeyA='OUTHDR_' || c2x('*')
if symbol(vf!KeyE)='VAR' then
vf!UseKey=vf!KeyE
else
do
if symbol(vf!KeyM)='VAR' then
vf!UseKey=vf!KeyM
else
do
if symbol(vf!KeyA)='VAR' then
vf!UseKey=vf!KeyA
else
vf!UseKey=''
end
end
if vf!UseKey='' then
call DBG 'No output header definition found'
else
do
call DBG 'Output Header definition was found'
parse value value(vf!UseKey)with vf!CmtS '00'x vf!CmtM '00'x vf!CmtE
end
if vf!CmtS||vf!CmtM||vf!CmtE\=='' then
do
if left(vf!CmtS,1)='@' & vf!CmtM||vf!CmtE = '' then
do
vf!Inc=substr(vf!CmtS,2)
call DBG 'Include output header - "' ||vf!Inc
if IncludeLevel=0 then
GenerateRc=GenerateRc+ProcessInputFile(vf!Inc)
else
do
call RecursiveIncludeSave
GenerateRc=GenerateRc+ProcessInputFile(vf!Inc)
call RecursiveIncludeRestore
end
end
else
do
call GenerateOneLine vf!CmtS
call GenerateOneLine vf!CmtM|| 'Generator   : PPWIZARD version ' ||PgmVersion
call GenerateOneLine vf!CmtM|| '            : FREE tool for Windows, OS/2, DOS and UNIX by ' || PgmAuthor  || ' (' || PgmAuthorEmail || ')'
call GenerateOneLine vf!CmtM|| '            : ' ||PgmHomePage
call GenerateOneLine vf!CmtM|| "Time        : " ||space(PpwCompTime)
call GenerateOneLine vf!CmtM|| "Input File  : " ||InputFile
call GenerateOneLine vf!CmtM|| "Output File : " ||FileQueryExists(Output.OutputLevel.File)
call GenerateOneLine vf!CmtE
call GenerateOneLine ''
end
end
return

OutputSyntaxCheckingHeaderIfWantedOrRequired:
OutSyntaxCmd=''
OutSyntaxRc=''
OutSyntaxMsg=''
OutSyntaxCode=''
OutSyntaxErrLineMask=''
vf!Lines=''
vf!KeyE='OUTHDRSYN_' ||c2x(vf!Extn)
vf!KeyM='OUTHDRSYN_' || c2x('*' ||ProcessingMode)
vf!KeyA='OUTHDRSYN_' || c2x('*')
if symbol(vf!KeyE)='VAR' then
vf!UseKey=vf!KeyE
else
do
if symbol(vf!KeyM)='VAR' then
vf!UseKey=vf!KeyM
else
do
if symbol(vf!KeyA)='VAR' then
vf!UseKey=vf!KeyA
else
vf!UseKey=''
end
end
if vf!UseKey='' then
call DBG 'No output syntax definition found'
else
do
call DBG 'Output syntax checking header code definition was found'
parse value value(vf!UseKey)with OutSyntaxCmd '00'x OutSyntaxRc '00'x OutSyntaxErrLineMask '00'x vf!Lines
end
if OutSyntaxCmd<> '' then
do
if OutSyntaxCmd="*" then
do
if ProcessingMode='REXX' then
do
vf!Lines='if arg(1)="' || SyntaxOkText || '" then exit(' || SyntaxOkRc || ')'
OutSyntaxRc='*REXX'
end
else
do
CryAndDie("Don't have an internal syntax handler for current file type")
end
end
if left(OutSyntaxCmd,1)='@' & (OutSyntaxRc || vf!Lines) = '' then
do
vf!Inc=substr(OutSyntaxCmd,2)
call DBG 'Include output header - "' ||vf!Inc
OutSyntaxRc=''
OutSyntaxCmd=''
OutSyntaxMsg=''
if IncludeLevel=0 then
GenerateRc=GenerateRc+ProcessInputFile(vf!Inc)
else
do
call RecursiveIncludeSave
GenerateRc=GenerateRc+ProcessInputFile(vf!Inc)
call RecursiveIncludeRestore
if OutSyntaxCmd='' | OutSyntaxRc = '' then
CryAndDie('You must set the rexx variables:', ' * OutSyntaxCmd', ' * OutSyntaxRc')
end
end
else
do
if left(vf!Lines,2)='?:' then
do
OutSyntaxCode=d2c(10)||ReplaceString(substr(vf!Lines,3), 'FF'x,CodexNewLine)
end
else
do
do while vf!Lines<> ''
parse var vf!Lines vf!This 'FF'x vf!Lines
call GenerateOneLine vf!This
end
call GenerateOneLine ''
end
end
end
return

DoSyntaxCheckingOnFileIfEnabled:
call DBG 'Need to do a syntax check on this file?'
if OutSyntaxRc='' then
return
wf!File=FileQueryExists(arg(1))
wf!Cmd=ReplaceString(OutSyntaxCmd, '{?}',wf!File)
if OutSyntaxCode<> '' then
do
call OutputWarningToScreen 'SYNS', 'Syntax checking stub "<' || '?SyntaxCheck>" missing in "' || wf!File || '"'
return
end
if OutSyntaxCmd="*" then
do
call DBG 'Calling internal validation code'
if OutSyntaxRc="*REXX" then
call CheckRexxModuleForSyntaxErrors
return
end
call DBGIND 1
call DBG 'Calling stub in generated code ("' || wf!File || '")'
CheckRc='*?*'
wf!Tmp=RexGetTmpFileName('sc??????.PPW')
CheckRc=AddressCmd(wf!Cmd||RedirectStdOutAndErr2(wf!Tmp),wf!Tmp)
if CheckRc<>OutSyntaxRc then
do
wf!O=MarksNewLine
wf!O=wf!O|| "SYNTAX CHECK'S OUTPUT" ||MarksNewLine
wf!O=wf!O|| '~~~~~~~~~~~~~~~~~~~~~' ||MarksNewLine
wf!LN=-1
wf!CN=-1
do while lines(wf!Tmp)<>0
wf!L=linein(wf!Tmp)
if wf!L<> '' then
do
wf!O=wf!O||wf!L||MarksNewLine
if wf!LN=-1&OutSyntaxErrLineMask<>0 then
do
do while wf!L<> '' &wf!LN=-1
wf!SynLine="?"
wf!SynCol="?"
wf!M=ReplaceString(OutSyntaxErrLineMask, "{?}",  "' wf!SynLine '")
wf!M=ReplaceString(wf!M, "{?C}", "' wf!SynCol '")
interpret "parse var wf!L wf!B '" || wf!M || "'"
if wf!SynLine<> "" then
do
if datatype(wf!SynLine, 'W')then
do
if wf!SynLine>0 then
wf!LN=wf!SynLine
end
end
if wf!SynCol<> "" then
do
if datatype(wf!SynCol, 'W')then
do
if wf!SynCol>0 then
wf!CN=wf!SynCol
end
end
wf!L=substr(wf!L,length(wf!B)+2)
end
end
end
end
CloseRc=stream(wf!Tmp, 'c', 'close')
if wf!LN<>-1 then
do
wf!T='SYNTAX ERROR ON LINE #' ||wf!LN
if wf!CN<>-1 then
wf!T=wf!T|| " (column " || wf!CN || ")"
wf!T=wf!T||MarksNewLine||copies('~',length(wf!T))||MarksNewLine
wf!FL=0
wf!Min=wf!LN-8
wf!Max=wf!Ln+2
if wf!Min<1 then
wf!Min=1
do wf!Fl=wf!Min to wf!Max
wf!L=FileLineIn(wf!File,wf!Fl)
if wf!L<> '' |wf!Fl=wf!LN then
do
if wf!FL<>wf!Ln then
wf!M=':'
else
do
wf!T=wf!T||MarksNewLine
wf!M='>'
if wf!CN<>-1 then
wf!L=left(wf!L,wf!CN-1)|| " {ErrorHere:column " || wf!CN || "}=> " ||substr(wf!L,wf!CN)
end
wf!T=wf!T||wf!FL||wf!M|| ' ' ||wf!L||MarksNewLine
if wf!FL=wf!Ln then wf!T=wf!T||MarksNewLine
end
end
CloseRc=stream(wf!File, 'c', 'close')
wf!O=wf!O||MarksNewLine||wf!T
end
if left(OutSyntaxMsg,1)<> '-' then
CryAndDie('Probable Syntax Error detected while checking generated file', 'Got unexpected RC of "' || CheckRc || '" (expected RC of ' || OutSyntaxRc || ')', 'Error checking "' || wf!File || '"',OutSyntaxMsg,wf!O)
else
do
CryAndDie(substr(OutSyntaxMsg,2),wf!O)
end
end
call _SysFileDelete wf!Tmp
call say ''
call DBGIND-1
return

ProcessHashOutput:
call DieIfCgiModeOn
if LineQueued\=='' then
do
if OptionDebugOn='Y' then
do
call DBG 'Need to flush queued data'
call DBGIND 3
end
call FlushQueuedOutput
if OptionDebugOn='Y' then
call DBGIND-3
end
xf!Parms=PerformReplacementsInCmdsParameters(arg(1))
if xf!Parms='' then
call _BackToPreviousOutput
else
do
xf!NewFile=GetQuotedText(xf!Parms, "xf!Parms")
xf!Parms=translate(xf!Parms)
xf!AsIs='N'
xf!HoldOutput='N'
xf!Append='N'
Ok2OutputHeader='Y'
xf!Mode=ProcessingMode
do while xf!Parms<> ''
ThisParm=GetQuotedText(xf!Parms, "xf!Parms")
select
when ThisParm="ASIS" then
xf!AsIs='Y'
when ThisParm="HOLD" then
xf!HoldOutput='Y'
when ThisParm="NOHEADER" then
Ok2OutputHeader='N'
when ThisParm="APPEND" then
xf!Append='Y'
when ThisParm="HTML" | ThisParm = "REXX" | ThisParm = "POWERSHELL" | ThisParm = "OTHER" then
xf!Mode=ThisParm
otherwise
CryAndDie('The parameter "' || ThisParm || '" is unknown!')
end
end
call OutputHoldPushAndClear
if xf!AsIs='N' then
call HaveNewOutputFile xf!NewFile,OptionOutput,xf!Append,xf!Mode,xf!HoldOutput
else
call HaveNewOutputFile xf!NewFile,,xf!Append,xf!Mode,xf!HoldOutput
end
return(0)

_ExecUserHook:
yf!R=CfgMacro('HOOK_OUTPUT', '')
if yf!R<> '' then
do
call DBG 'Calling #OUTPUT HOOK : ' ||arg(1)
call DBGIND 1
yf!R=PerformReplacementsInCmdsParameters(yf!R)
OutputState=arg(1)
call ExecRexxCmd yf!R
call DBGIND-1
end
return

GetQuotedText:
parse arg zf!Str,zf!Rest,zf!Del,zf!Doing
zf!Str=strip(zf!Str, 'L')
zf!Del=' ' ||zf!Del
if OptionDebugOn='Y' then
do
call DBG_QUOTING 'GetQuotedText(): ' ||DebugRightArrow||zf!Str||DebugLeftArrow
call DBGIND 1
end
if zf!Str='' then
call _ErrorNoQuotedParm
QuoteChar=left(zf!Str,1)
if datatype(QuoteChar, 'Alphanumeric')then
do
if OptionDebugOn='Y' then
call DBG_QUOTING 'Text is unquoted'
DelPos=verify(zf!Str,zf!Del, 'M')
if DelPos=0 then
do
QuotedString=zf!Str
TheRest=''
end
else
do
QuotedString=substr(zf!Str,1,DelPos-1)
TheRest=substr(zf!Str,DelPos)
end
end
else
do
if OptionDebugOn='Y' then
call DBG_QUOTING 'Text is quoted with ' ||DebugRightArrow||QuoteChar||DebugLeftArrow
SecondQuotePosn=pos(QuoteChar,zf!Str,2)
if SecondQuotePosn=0 then
call _ErrorNoEndQuote
QuotedString=substr(zf!Str,2,SecondQuotePosn-2)
TheRest=substr(zf!Str,SecondQuotePosn+1)
end
if TheRest<> '' then
do
if zf!Del<> 'Y' then
do
if pos(left(TheRest,1),zf!Del)=0 then
do
zf!1='There is no whitespace after the 2nd quote char of "' || QuoteChar || '" (did not expect to find "' || left(TheRest, 1) || '")'
zf!2='The rest of the line:'
zf!3=copies(' ',8)||DebugRightArrow||TheRest||DebugLeftArrow
if zf!Doing<> '' then
zf!4=''
else
zf!4='Doing: ' ||zf!Doing
CryAndDie(zf!1,zf!2,zf!3,zf!4)
end
end
end
TheRest=strip(TheRest, 'L')
if zf!Rest<> '' then
call _valueS zf!Rest,TheRest
else
do
if TheRest<> '' then
call DieIfExtraUnexpectedParms TheRest
end
if OptionDebugOn='Y' then
do
call DBG_QUOTING 'Text is ' ||DebugRightArrow||QuotedString||DebugLeftArrow
call DBGIND-1
end
return(QuotedString)

GetQuotedRest:
parse arg zf!Str,zf!Doing
zf!Str=strip(zf!Str)
if OptionDebugOn='Y' then
do
call DBG_QUOTING 'GetQuotedRest(): ' ||DebugRightArrow||zf!Str||DebugLeftArrow
call DBGIND 1
end
if zf!Str='' then
call _ErrorNoQuotedParm
QuoteChar=left(zf!Str,1)
if datatype(QuoteChar, 'Alphanumeric')then
do
QuotedString=zf!Str
if OptionDebugOn='Y' then
call DBG_QUOTING 'Text is unquoted'
end
else
do
if OptionDebugOn='Y' then
call DBG_QUOTING 'Text is quoted with '||DebugRightArrow||QuoteChar||DebugLeftArrow
SecondQuotePosn=length(zf!Str)
if SecondQuotePosn<2|substr(zf!Str,SecondQuotePosn,1)<>QuoteChar then
call _ErrorNoEndQuote
QuotedString=substr(zf!Str,2,SecondQuotePosn-2)
end
if OptionDebugOn='Y' then
do
call DBG_QUOTING 'Text is  ' ||DebugRightArrow||QuotedString||DebugLeftArrow
call DBGIND-1
end
return(QuotedString)

DieIfExtraUnexpectedParms:
if arg(1)='' then
return
CryAndDie('Unexpected parameter(s) of "' || strip(arg(1)) || '" found!')

_ErrorNoQuotedParm:
if zf!Doing<> '' then
zf!Doing='Doing: ' ||zf!Doing
CryAndDie('Expect a quoted string, not enough parameters available!',zf!Doing)

_ErrorNoEndQuote:
zf!1='Could not find a matching end quote character of "' || QuoteChar || '"!'
zf!2='Processing:'
zf!3=copies(' ',8)||DebugRightArrow||zf!Str||DebugLeftArrow
if zf!Doing<> '' then
zf!4='Doing: ' ||zf!Doing
else
zf!4=''
CryAndDie(zf!1,zf!2,zf!3,zf!4)

GetRexxVarValueOrDie:
grvVar=arg(1)
if symbol(grvVar)='VAR' then
return(_valueG(grvVar))
else
do
if symbol(grvVar)='BAD' then
Reason="contains invalid character(s)"
else
Reason="is unknown"
call DumpVarsIfCompoundVariable grvVar
CryAndDie('The rexx variable "' || grvVar || '" ' || Reason || '!')
end

ProcessRexxVar:
ResultVar=GetQuotedText(PerformReplacementsInCmdsParameters(arg(1)), "Rest")
XVarName=''
ResultVarU=translate(ResultVar)
if ResultVarU="PUSH" then
do
do while Rest<> ''
ResultVar=GetQuotedText(Rest, "Rest")
call _StackPush GetRexxVarValueOrDie(ResultVar)
end
return(0)
end
if ResultVarU="POP" then
do
TmpVarCnt=0
do while Rest<> ''
ResultVar=GetQuotedText(Rest, "Rest")
TmpVarCnt=TmpVarCnt+1
TmpVar.TmpVarCnt=ResultVar
end
do while TmpVarCnt<>0
call _valueS TmpVar.TmpVarCnt,_StackPop()
TmpVarCnt=TmpVarCnt-1
end
return(0)
end
parse var Rest FastOperator Rest
if FastOperator<> '=' then
do
FastOperator=translate(FastOperator)
if left(FastOperator,1)='=' then
do
if FastOperator='=X=' then
do
XVarName=ResultVar
ResultVar='XVAR?.X?' ||c2x(translate(XVarName))
end
else
do
Rest=strip(Rest)
if symbol(Rest)='VAR' then
ResultValue=GetRexxVarValueOrDie(Rest)
else
ResultValue=GetQuotedRest(Rest)
select
when FastOperator='=VALUE=' then
do
RestVar=value(ResultValue)
end
when FastOperator='=ASIS=' then
do
RestVar=AsIs(ResultValue)
end
otherwise
CryAndDie('Unsupported "=?=" operator of "' || FastOperator || '" used on ' ||HashCmd)
end
Rest='RestVar'
end
FastOperator='='
end
end
select
when FastOperator='=' then
do
Rest=strip(Rest)
if symbol(Rest)='VAR' then
ResultValue=GetRexxVarValueOrDie(Rest)
else
ResultValue=GetQuotedRest(Rest)
end
when FastOperator='PUSH' then
do
call DieIfExtraUnexpectedParms Rest
call _StackPush GetRexxVarValueOrDie(ResultVar)
return(0)
end
when FastOperator='POP' then
do
call DieIfExtraUnexpectedParms Rest
ResultValue=_StackPop()
end
otherwise
do
AfterOperator=GetSimpleRexxValue(Rest, "Rest")
if Rest<> '' then
SourceValue=GetSimpleRexxValue(Rest)
else
SourceValue=GetRexxVarValueOrDie(ResultVar)
if OptionDebugOn='Y' then
call DBG_REXXVAR 'Evaluating: ' || SourceValue || ' ' || FastOperator || ' ' ||AfterOperator
select
when FastOperator='+' then
ResultValue=SourceValue+AfterOperator
when FastOperator='-' then
ResultValue=SourceValue-AfterOperator
when FastOperator='||' then
ResultValue=SourceValue||AfterOperator
when FastOperator='*' then
ResultValue=SourceValue*AfterOperator
when FastOperator='/' then
ResultValue=SourceValue/AfterOperator
when FastOperator='//' then
ResultValue=SourceValue//AfterOperator
when FastOperator='%' then
ResultValue=SourceValue%AfterOperator
otherwise
CryAndDie("Unsupported operator of '" || FastOperator || "' used on " ||HashCmd)
end
end
end
call _valueS ResultVar,ResultValue
if OptionDebugOn='Y' then
do
call DBGIND 1
if XVarName='' then
DbgPrefix=ResultVar
else
DbgPrefix='"X" Variable ' ||XVarName
call DBG_REXXVAR DbgPrefix|| ' = ' ||DebugRightArrow||ResultValue||DebugLeftArrow
call DBGIND-1
end
return(0)

GetSimpleRexxValue:
sParm=strip(arg(1), 'L')
sRestVar=arg(2)
sQuote=left(sParm,1)
if sQuote="'" | sQuote = '"' then
do
sEndPos=pos(sQuote,sParm,2)
if sEndPos=0 then
CryAndDie('Incorrectly quoted rexx literal (could not find ending quote)')
sValue=substr(sParm,2,sEndPos-2)
sRest=substr(sParm,sEndPos+1)
end
else
do
parse var sParm sValue sRest
if datatype(sValue, 'Number')=0 then
sValue=GetRexxVarValueOrDie(sValue)
end
if sRestVar<> '' then
call _valueS sRestVar,sRest
else
do
if sRestVar<> '' then
CryAndDie('Extra unexpected parameters of "' || sRestVar || '" found')
end
return(sValue)

_StackPush:
StackCnt=StackCnt+1
Stack.StackCnt.StackData=arg(1)
Stack.StackCnt.StackPosn=CurrentSourceLocation()
if OptionDebugOn='Y' then
call DBG_REXXVAR 'Stack Push(#' || StackCnt || ') = ' ||DebugRightArrow||arg(1)||DebugLeftArrow
return

_StackPop:
if StackCnt<=0 then
CryAndDie('There is nothing on the stack!')
spData=Stack.StackCnt.StackData
if OptionDebugOn='Y' then
do
call DBG_REXXVAR 'Stack pop(#' || StackCnt || ') = ' ||DebugRightArrow||spData||DebugLeftArrow
call DBG_REXXVAR 'matched push() at ' ||Stack.StackCnt.StackPosn
end
StackCnt=StackCnt-1
return(spData)

MatchesStackPushDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#RexxVar PUSH" at ' || Stack.MatchIndex.StackPosn || ')')

XVarDefined:call TRACE "OFF"
parse arg ag!Xv,ag!Wn
ag!Sa='XVAR?.X?' ||c2x(translate(ag!Xv))
if ag!Wn<> 'N' then
do
if symbol(ag!Sa)<> 'VAR' then
do
if ag!Wn='D' then
CryAndDie('The XVAR "' || ag!Xv || '" does not exist!')
ag!Sa=''
end
end
if OptionDebugOn='Y' then
call DBG_EVALUATE 'XVarDefined(' || ag!Xv || ') : ' ||ag!sa
return(ag!Sa)

_EnsureVersionY2KSafe:
TheVer=ReplaceString(translate(arg(1)), '2K', '00')
if datatype(TheVer, 'Number')=0|(length(TheVer)<>6&length(TheVer)<>8)then
CryAndDie('The version number "' || TheVer || '" is not valid')
if TheVer<100 then
do
if TheVer>98 then
TheVer='19' ||TheVer
else
TheVer='20' ||TheVer
end
return(TheVer)

ProcessRequireCommon:
bg!MinVer=_EnsureVersionY2KSafe(GetQuotedText(arg(1), 'bg!Rest'))
if bg!Rest='' then
bg!MaxVer='9999.99'
else
do
bg!MaxVer=_EnsureVersionY2KSafe(GetQuotedText(bg!Rest))
bg!Rest='"' || bg!MaxVer || '"'
end
bg!ThisVer=_EnsureVersionY2KSafe(PgmVersion)
if OptionDebugOn='Y' then
do
call DBG 'You require "' || bg!MinVer || '" - ' ||bg!Rest
call DBG 'You have    "' || bg!ThisVer || '"'
end
bg!U='You are using version "' || bg!ThisVer || '"'
if bg!ThisVer<bg!MinVer then
CryAndDie('You required at least PPWIZARD version "' || bg!MinVer || '"',bg!U)
if bg!ThisVer>bg!MaxVer then
CryAndDie('You need a PPWIZARD version EARLIER than "' || bg!MaxVer || '"',bg!U)
return(0)

ProcessRequire:
return(ProcessRequireCommon(PerformReplacementsInCmdsParameters(arg(1))))

RexxCtrlC:
CryAndDie('You pressed "Ctrl+C" or the break key to abort execution!')

QuickSourceLine:
LineNum=arg(1)
slKey='PPWSL!.' ||LineNum
if symbol(slKey)='VAR' then
return(_valueG(slKey))
SrcLine=sourceline(LineNum)
call _valueS slKey,SrcLine
return(SrcLine)

_FindLastLabel:
FailedOnLine=arg(1)
TryLine=FailedOnLine
do while TryLine>1
TryLine=TryLine-1
TheLine=QuickSourceLine(TryLine)
ColonPos=pos(':',TheLine)
if ColonPos<>0 then
do
MaybeLabel=strip(left(TheLine,ColonPos-1))
if symbol(MaybeLabel)<> 'BAD' then
do
FoundLabelOnLine=TryLine
return(MaybeLabel|| ':  (line #' || AddCommasToDecimalNumber(TryLine) || ')')
end
end
end
FoundLabelOnLine=0
return('')

GetIncludeStack:
cg!R=''
if IncludeLevel>1 then
do
do cg!F=IncludeLevel to 1 by-1
if cg!R<> '' then
cg!R=cg!R|| ' <- '
cg!R=cg!R||_filespec('n', IncludeFileName.cg!F) || '(' || GetLineNumber4Level(cg!f) || ')'
end
end
return(cg!R)

SeeAlsoFile:
dg!W=arg(1)
dg!T=left('More Info?', dg!W) || ': '
if ConsoleFile<> '' then
do
call Line1 dg!T||ConsoleFile|| ' (console file)'
dg!T=left('', dg!W) || ': '
end
if ConsoleErrorFile<> '' then
call Line1 dg!T||ConsoleErrorFile|| ' (error file)'
return

OutputErrorLocationDetails:
eg!OutputSel=arg(1)
if IncludeLevel<>0 then
do
LastFileLine=strip(LastFileLine)
LastLine=strip(LastLine)
call Line1 'Location  : ' ||CurrentSourceLocation()
eg!S=GetIncludeStack()
if eg!S<> '' then
call Line1 'File Stack: ' ||eg!S
call Line1 'File Line : ' ||LastFileLine
if LastLine<>LastFileLine then
call Line1 'Fail Line : ' ||LastLine
if LastLineAfterMacroRep<> '' &LastLine<>LastLineAfterMacroRep&LastFileLine<>LastLineAfterMacroRep then
call Line1 'After Repl: ' ||LastLineAfterMacroRep
if MacroBeingExpanded<> '' then
call Line1 'Expanding : ' || StartsMacroReplacement || MacroBeingExpanded || ' ...' ||EndsMacroReplacement
end
else
do
if PpwDoing<> '' then
call Line1 'Doing What: ' ||PpwDoing
end
call SeeAlsoFile 10
if eg!OutputSel="Y" then
do
call Line1 'Detected @: Line ' || SynErrLineC || ' of ' || _filespec('name', PpWizardPgmName) || ' (v' || PgmVersion || ')'
call Line1 'PPWIZARD  : Length ' || PpwSize || ' bytes.  TimeStamped ' ||PpwDateTime
end
call Line1 'Running In: ' || DebugGetOpSysText() || ', ' ||RexVersionInfo
return

CommonTrapHandler:
signal on NOVALUE name SimpleRexxTrapUninitializedVariable
signal on SYNTAX name SimpleRexxTrapSyntaxError
FailingLine=arg(1)
TrapType=arg(2)
TextDescription=arg(3)
Text=arg(4)
CmdBeingEvaluated=arg(5)
UserBreakPoint=arg(6)
if TrapType='N' then
TrapHeading='UNKNOWN VARIABLE'
else
TrapHeading='SYNTAX ERROR'
HaveCapturedTrapDetails='Y'
call Line1 ''
call AllFollowingOutputGoesToErrorFile
call ColorSet 'ERROR'
call CgiStartFatalError
call Line1 copies('=+',39)
call Line1 TrapHeading
call Line1 copies('~',length(TrapHeading))
if TrapType='N' then
call Line1 'Variable  : ' ||Text
else
call Line1 'Reason    : ' ||Text
BetterErrorText=Condition('D')
if BetterErrorText<> '' &BetterErrorText<>Text then
call Line1 '          : ' ||BetterErrorText
call OutputErrorLocationDetails
if CmdBeingEvaluated<> '' then
do
CmdBeingEvaluatedTmp=ReplaceString(CmdBeingEvaluated,DefRexxSpecialSepTag, ";")
call Line1 ''
eg!T="Failed Evaluating"
call Line1 eg!T
call Line1 copies('~',length(eg!T))
eg!RexCde=ReplaceString(CmdBeingEvaluated,DefRexxSpecialSepTag,MarksNewLine)
eg!RexCde=ReplaceString(eg!RexCde, '0D'x, '')
eg!RexShort=''
eg!RexLong=''
eg!L=0
do while eg!RexCde<> ''
eg!L=eg!L+1
parse var eg!RexCde eg!1 (MarksNewLine) eg!RexCde
eg!1=strip(eg!1)
eg!Ln=right(eg!L,4, '0')
eg!RexLong=eg!RexLong||MarksNewLine||eg!Ln|| ': ' ||eg!1
if eg!L<=10 then
do
if length(eg!1)>70 then
eg!1=left(eg!1,70)|| '...'
eg!RexShort=eg!RexShort||MarksNewLine||eg!Ln|| ': ' ||eg!1
end
end
if eg!L>10 then
eg!RexShort=eg!RexShort||MarksNewLine|| "... (" || eg!L-10 || ' more lines)'
call Line1 eg!RexShort,eg!RexLong
call Line1 ''
if TrapType='S' then
do
eg!FailedAt=''
eg!C=PPWIZARD_REGINA_SYNTAX_CMD('Y')
if eg!C<> "" & pos('SYNTAX',translate(TrapHeading))<>0 then
do
eg!Msk=ReplaceString(PPWIZARD_REGINA_SYNTAX_LINE_MASK(), "{?}", "' eg!Line '")
Contents=ReplaceString(CmdBeingEvaluated,DefRexxSpecialSepTag,RexEOL)
eg!TmpRx=RexGetTmpFileName('EV?????.CMD')
call MustDeleteFile eg!TmpRx
call lineout eg!TmpRx, "/* Keep OS/2 Happy */"
call lineout eg!TmpRx, "exit(0);"
eg!Extra=2
call charout eg!TmpRx,Contents
call FileClose eg!TmpRx, 'N'
eg!Cmd=ReplaceString(eg!C, '{?}',eg!TmpRx)
eg!TmpO=RexGetTmpFileName('th??????.PPW')
eg!CheckRc=AddressCmd(eg!Cmd||RedirectStdOutAndErr2(eg!TmpO),eg!TmpO)
if eg!CheckRc<>0 then
do
eg!ErrText=charin(eg!TmpO,,99999)
call FileClose eg!TmpO, 'N'
interpret "parse var eg!ErrText '" || eg!Msk || "'"
if eg!Line<> '' & DataType(eg!Line, 'W')=1 then
do
eg!FailedAt='#' || eg!Line - eg!Extra || ' : ' ||FileLineIn(eg!TmpRx,eg!Line)
call FileClose eg!TmpRx, 'N'
end
end
if eg!FailedAt='' then
do
eg!ErrText=Text|| '0A'x||BetterErrorText
parse var eg!ErrText '[Syntax error at line ' eg!Line ']'
if eg!Line<> '' & DataType(eg!Line, 'W')=1 then
do
eg!FailedAt='#' || eg!Line || ' : ' ||FileLineIn(eg!TmpRx,eg!Line+eg!Extra)
call FileClose eg!TmpRx, 'N'
end
end
call _SysFileDelete eg!TmpRx
call _SysFileDelete eg!TmpO
end
if eg!FailedAt='' then
eg!FailedAt='Could not be determined...'
call Line1 'Rexx Invalid at : ' ||eg!FailedAt
end
end
if RexWhich='REGINA' then
ReginaUname=' (' || uname() || ')'
else
ReginaUname=''
FailingLineText=AddCommasToDecimalNumber(FailingLine)
if CmdBeingEvaluated='' then
DumpPpwSrc='Y'
else
do
DumpPpwSrc='N'
call DumpVarsInExpression CmdBeingEvaluatedTmp,, 'KNOWN VARIABLES', 'Line1'
end
if DumpPpwSrc='Y' then
do
call Line1 'Failing Module  : ' || PpWizardPgmName || ' (' || PgmVersion || ')'
call Line1 'Failing Line #  : ' ||FailingLineText
InRoutine=_FindLastLabel(FailingLine)
StartAt=FailingLine-7
if FoundLabelOnLine<>0 then
do
if FoundLabelOnLine>StartAt then
StartAt=FoundLabelOnLine
else
do
if FoundLabelOnLine<>0 then
do
if(FailingLine-FoundLabelOnLine)<10 then
StartAt=FoundLabelOnLine
else
call Line1 'After label     : ' ||InRoutine
end
end
end
call Line1 'SOURCE'
call Line1 '~~~~~~'
vlist.0=0
do ShowLine=StartAt to FailingLine
FailingSrcLineTxt=strip(QuickSourceLine(ShowLine))
call Line1 left(AddCommasToDecimalNumber(ShowLine),length(FailingLineText))|| ' : ' ||FailingSrcLineTxt
call DumpVarsInExpression FailingSrcLineTxt, 'vlist'
end
call DumpVarsInExpressionNow 'vlist', 'KNOWN VARIABLES', 'Line1'
end
HookText=TrapHeading|| ' at line ' || FailingLineText || '. ' || TextDescription || ': ' ||Text
call CgiEndFatalError
call Line1 copies('=+',39)
call AddColorDelayWorkaroundForTee
call ColorSet
call Line1 ''
if UserBreakPoint<> '' then
do
call RexxTrace HookText,,,'Y'
end
AbnormalExit(FailingLine,HookText)

RexxTrapUninitializedVariable:
TrappingLine=SIGL
call CommonTrapHandler TrappingLine, 'N', 'Unknown Variable', condition('D')

RexxTrapSyntaxError:
TrappingLine=SIGL
call CommonTrapHandler TrappingLine, 'S', 'Reason',errortext(Rc)

SimpleCommonTrapHandler:
if HaveCapturedTrapDetails='N' then
do
FailingLine=arg(1)
TrapType=arg(2)
TextDescription=arg(3)
Text=arg(4)
if TrapType='N' then
TrapHeading='NoValue Abort!'
else
TrapHeading='Syntax Error!'
end
FailingLineText=AddCommasToDecimalNumber(FailingLine)
say ''
say copies('*-',39)
say TrapHeading
say copies('~',length(TrapHeading))
if HaveCapturedTrapDetails='Y' then
say 'Trap within Trap: Original trap details saved and displayed below!'
say substr(TextDescription,1,16)|| ': ' ||Text
BetterErrorText=Condition('D')
if BetterErrorText<> '' &BetterErrorText<>Text then
call Line1 copies(' ',18)||BetterErrorText
parse source . . PpWizardPgmName
parse version VersionOfRexx
FailingSrcLineTxt=strip(QuickSourceLine(FailingLine))
say 'Failed at       : ' || PpWizardPgmName || ' (line ' || FailingLineText || ', version ' || PgmVersion || ')'
say 'Source Code     : ' ||FailingSrcLineTxt
say 'Rexx Version    : ' ||VersionOfRexx
call DumpVarsInExpression FailingSrcLineTxt, '', 'KNOWN VARIABLES'
HookText=TrapHeading|| ' at line ' || FailingLineText || '. ' || TextDescription || ': ' ||Text
if HaveCapturedTrapDetails='Y' then
do
FailingLine=arg(1)
TrapHeading=arg(2)
TextDescription=arg(3)
Text=arg(4)
say ''
say 'Reason for secondary trap'
say '~~~~~~~~~~~~~~~~~~~~~~~~~'
say substr(TextDescription,1,16)|| ': ' ||Text
say 'Failed at       : ' || PpWizardPgmName || ' (line ' || FailingLineText || ', version ' || PgmVersion || ')'
say 'Source Code     : ' ||strip(QuickSourceLine(FailingLine))
end
say copies('*-',39)
call CallErrorHookForSimpleOneLiner HookText
ExitNowCallingAnyHandlers(FailingLine)

SimpleRexxTrapUninitializedVariable:
TrappingLine=SIGL
call SimpleCommonTrapHandler TrappingLine, 'N', 'Unknown Variable', condition('D')

SimpleRexxTrapSyntaxError:
TrappingLine=SIGL
call SimpleCommonTrapHandler TrappingLine, 'S', 'Reason',errortext(Rc)
