#include <stdio.h>

int Usage( const char * pszPgmname )
{
   fprintf( stdout, "Usage: %s OUTFILE\n", pszPgmname );
   fprintf( stdout,
      "\n"
      "Copy stdin to OUTFILE replacing crlf by lf.\n");
   return 1;
}

int main(int argc, const char * argv[])
{
   FILE *         pOutFile;
   int i;

   if (argc != 2)
      {
      return Usage(argv[0]);
      }
   pOutFile = fopen( argv[1], "wb");
   if (0 == pOutFile)
      {
      printf("Can't open %s for writing\n", argv[1]);
      return Usage(argv[0]);
      }

   while (EOF != (i= getc(stdin)))
      putc(i, pOutFile);
   return 0;

   fflush( pOutFile );
}

