# General OS/2 & Windows NT configuration for dmake

__.SILENT := $(.SILENT)
.SILENT   := yes

.IMPORT: COMSPEC
.IMPORT .IGNORE: MAKE_SH

DIRSEPSTR   := /

# File suffix macros.

E	:= .exe
#O	:= .obj
L	:= .lib
D	:= .dll

# Directory macros
#
# I like to keep my source directories clean.  All intermediate files
# go into a subdirectory, typically obj, and all final files go into
# the parent directory.

OBJ	:= obj
B	:= ..

# ------------- CPU type and target system architecture --------------
#
# This probably needs to be separated out somewhere because different
# versions of the compiler support different target CPU optimisations.
# For now, I am generating Pentium-II code.
#
# --------------------------------------------------------------------

arch = i686
cpu  = pentium3

# ------------- Optimisations for specific compilers ---------------
#
# ------------------------------------------------------------------

optflags = -funroll-loops -malign-strings=2 -fomit-frame-pointer

# ------------- Stuff pertinent to shell operations --------------
#
# Do not define MAKE_SH if you want to use the standard command processor
#
# This should work on OS/2 (CMD.EXE, 4OS2.EXE) which looks for .CMD file
# and on WinNT (COMMAND.COM) which expects .BAT files.  A corollary is that
# you should be able to use this file without change on both environments,
# simply by choosing the appropriate name, e.g.
#
#	os2.mk
#	win32.mk
#
# for separate files, or even something like
#
#	os2win.mk
#
# on both.  Of course this is only guaranteed if MAKE_SH is not set.  If
# you use a different shell then all bets are off and you'll have to make
# some adjustments if you want to maintain a single file.  It probably
# isn't worth the trouble.
#
# ---------------------------------------------------------------

.IF $(MAKE_SH) == $(NULL)

SHELL       := $(COMSPEC)
SHELLFLAGS  := /c
GROUPFLAGS  := $(SHELLFLAGS)
SHELLMETAS  := *"?<>|&
DIVFILE      = $(TMPFILE:s,/,\)

# This is nonsense
#.IF $(COMSPEC:s,.,/,:f) == COM
#GROUPSUFFIX := .bat
#WINDOWS     := 1
#.ELIF $(COMSPEC:s,.,/,:f) == com
#GROUPSUFFIX := .bat
#WINDOWS     := 1
#.ELSE
#GROUPSUFFIX := .cmd
#OS2         := 1
#.END
# This is better
.IF $(OSID) == WINDOWS
WINDOWS := 1
.ELIF OSID == OS2
OS2 := 1
.ENDIF

# Define MAKE_SH (path name) to use a Unix-like shell

.ELSE

SHELL       := $(MAKE_SH)
SHELLFLAGS  := -c
GROUPFLAGS  :=
SHELLMETAS  := *"?<>|()&][$$\#`'
GROUPSUFFIX := .sh
DIVFILE      = $(TMPFILE:s,/,${DIVSEP_shell_${USESHELL}})
DIVSEP_shell_yes := \\\
DIVSEP_shell_no  := \\

.END

GROUPSHELL  := $(SHELL)

.USESHELL :

.SILENT := $(__.SILENT)
