/* msgtool: an utility that 'decompiles' OS/2 message files */

msgtool.version = '0.1'
msgtool.author  = 'Salvador Parra Camacho'
msgtool.email   = 'x3265340 (arroba) fedro (dot) ugr dot es'
msgtool.url     = 'http://www.os2world.com/spc'

parse source msgtool.OpSys . msgtool.Script
parse version msgtool.RexxVer

parse arg file
if left(file, 1) = '"' then parse var file '"' file '"'

if file = '' then
	exit

if stream(file,'C','QUERY EXISTS') <> '' then
	do
        data = charin(file, 1, chars(file))
        call charout file
        end

header = 'FF'x||'MKMSG'

if substr(data, 1, 6) <> header then
	do
	say 'This is not a message file.'
	exit
	end

component = substr(data, 9, 3)

call lineout 'stderr', 'Message file: '||file

number = c2d(reverse(substr(data, 12 ,2)))

call lineout 'stderr', 'Number of messages: '||number

first = c2d(reverse(substr(data, 14, 2)))

call lineout 'stderr', 'First number of message: '||first

unknown = c2x(substr(data, 32 + number * 2 + 1, 8))
call lineout 'stderr', 'Unknown purpose string (hexadecimal): '||unknown

codepages = substr(data, 32 + number * 2 + 9, 32)
codepage = ''
do while codepages <> ''
	parse var codepages cp +2 codepages
	if c2d(reverse(cp)) = 0 then
		leave
	if codepage = '' then
		codepage = c2d(reverse(cp))
	else
		codepage = codepage||', '||c2d(reverse(cp))
end

call lineout 'stderr', 'Codepages: '||codepage

internalfile = substr(data, 32 + number * 2 + 41)
parse var internalfile internalfile '00'x .
call lineout 'stderr', 'Internal filename: '||internalfile

say ';'
say '; Output generated by msgtool '||msgtool.version||' ('||msgtool.url||')'
say '; by '||msgtool.author
say '; Operating system: '||msgtool.OpSys
say '; REXX interpreter: '||msgtool.RexxVer
say '; File: '||file
say '; Internal filename: '||internalfile
say '; Codepages: '||codepage
say '; Date and time: '||date()||', '||time()
say ';'
say component

do i = 1 to number
	begin = c2d(reverse(substr(data, 30 + 2 * i, 2))) + 1
	end = c2d(reverse(substr(data, 32 + 2 * i, 2))) + 1
	if end < begin then
		end = length(data)
	parse value substr(data, begin, end - begin) with letter +1 message
	message = strip(message, 'T', '0A'x)
	message = strip(message, 'T', '0D'x)
	say component||right(first + i, 4, '0')||letter':' message
end

exit