/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %callchain    */

/* if passed ss:bp cs:ip, this script tries to follow the call chain */
/* and will attempt to decode all symbol names */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

parse upper arg ss':'bp cs':'ip

if ss = '' | bp = '' | cs = '' | ip = '' then do
   parse source . . rexxscript
   rexxscript = filespec('name',rexxscript)
   parse var rexxscript rexxscript '.' .
   say 'invoke: 'rexxscript' ss:bp cs:ip'
   return 1
end

numeric digits 20

address df 'cmd syminfo ln 'cs':'ip
if syminfo.2 = 'No Symbols Found' then do
   say 'Load Symbol File for symbol at address 'cs':'ip', aborting ...'
   return 1
end

say '*********** Call Chain *****************'
do n=1 to 10
/*
   parse var syminfo.2 . symname '+' .
   symname = strip(symname)
*/
   parse var syminfo.2 . symname
   say '('ss':'bp') 'symname

   address df 'cmd stacktrace dw 'ss':'bp' l2'
   parse var stacktrace.2 tmp bp ip

   if tmp = 'Invalid' then do
      leave
   end

   /*say 'ss is:'ss' , bp is:'bp' , cs is:'cs' , ip is:'ip*/

   address df 'cmd syminfo ln 'cs':'ip
end
return 0


IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */

