/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dostable    */

/* this script will display the routines listed in the DosTable */
/* the DosTable address is typically returned on a DevHelp_GetDosVAR with index 9 */

numeric digits 20

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

address df 'cmd tab ln DosTable'
say '********* results for *********'
say tab.2
say '*******************************'
say '*** DosTable1 *****************'
say '*******************************'

/* first byte of dos table is the number of entries */
/* dostable starts at second byte */
address df 'cmd tab dd DOSTable+1 lBY(DosTable)'
do n=2 to tab.0-1
   val.1=''
   val.2=''
   val.3=''
   val.4=''
   parse var tab.n 16 val.1 val.2 val.3 val.4 .
   do k=1 to 4
      idx = (n-2)*4+(k-1)
      if val.k = '' then do
         iterate
      end
      if x2d(val.k) = 0 then do
         iterate
      end
      /* normal routine with selector and offset */
      if x2d(val.k) >= 65536 then do
         parse var val.k cs 5 ip
         address df 'cmd ret ln'cs':'ip
         say 'index 'idx' *-* 'ret.2
      end
      /* only selector value, points to a call gate */
      else do
         parse var val.k . 5 callgate
         address df 'cmd ret dg 'val.k
         parse var ret.2 . '=' cs ':' eip .
         address df 'cmd ret ln'cs':'eip
         say 'index 'idx' *-* 'ret.2' (call gate, sel='callgate')'
      end
   end
end

say '*******************************'
say '*** DosTable2 *****************'
say '*******************************'

/* DosTable2 directly follows DosTable1 */
/* again, first byte of dos table is the number of entries */
/* dostable starts at second byte */
address df 'cmd tab dd DOSTable+4*BY(DosTable)+2 lBY(DosTable+4*BY(DosTable)+1)'
do n=2 to tab.0-1
   val.1=''
   val.2=''
   val.3=''
   val.4=''
   parse var tab.n 16 val.1 val.2 val.3 val.4 .
   do k=1 to 4
      idx = (n-2)*4+(k-1)
      if val.k = '' then do
         iterate
      end

      if x2d(val.k) < 65536 then do
         rest = val.k
      end
      else do
         address df 'cmd ret ln %'val.k
         rest = ret.2
         if ret.2 = 'No Symbols Found' then do
            parse var val.k cs 5 ip
            address df 'cmd ret ln 'cs':'ip
            rest = ret.2
         end
         if ret.2 = 'No Symbols Found' then do
            address df 'cmd ret lg OS2KRNL'
            parse var ret.5 segbase
            segbase = strip(segbase,'L',' ')
            address df 'cmd ret ? 'segbase
            parse var ret.2 . '%' linbase .
            parse var segbase sel ':' .
            if val.k >= linbase then do
               off = d2x(x2d(val.k)-x2d(linbase))
               address df 'cmd ret ln 'sel':'off
               rest = ret.2
            end
            else do
               ret.2 = 'No Symbols Found'
            end
         end
         if ret.2 = 'No Symbols Found' then do
            address df 'cmd ret lg OS2KRNL'
            parse var ret.6 segbase
            segbase = strip(segbase,'L',' ')
            address df 'cmd ret ? 'segbase
            parse var ret.2 . '%' linbase .
            parse var segbase sel ':' .
            if val.k >= linbase then do
               off = d2x(x2d(val.k)-x2d(linbase))
               address df 'cmd ret ln 'sel':'off
               rest = ret.2
            end
            else do
               ret.2 = 'No Symbols Found'
            end
         end
         if ret.2 = 'No Symbols Found' then do
            rest = val.k
         end
      end
      say 'index 'idx' *-* 'rest
   end
end

return 0


IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
