/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %gdt    */

/* script is being passed a GDT type and will then display */
/* all GDT descriptors of that type */
/* 'type' will be Code, Data, CallG32, CallG, TSS32 */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

parse upper arg type
numeric digits 20

output.2 = ''
selector = 0
do until pos('Invalid selector',output.2)>0
   address df 'cmd output dg 'd2x(selector)
   parse upper var output.2 7 gdttype .
   if strip(gdttype) = type then do
      say output.2
   end /* do */
   selector = selector + 8
end
return 0

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */

