/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %drvintr    */

/* script to decode the drivers that have an interrupt hooked */
/* for this, the "airqi" table is queried. It contains the info */
/* which driver or drivers hook what interrupts */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

TAB = d2c(9)

address df "cmd xxx .lmo 'acpi'"
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
if yyy.0 > 2 then do
   /*
    for newer ACPI.PSD, airqi Table is located within ACPI.PSD
    for ACPI.PSD v 3.23.10, it can be found at 4:102f8
    for ACPI.PSD v 3.23.12, it can be found at 4:107d4
    for ACPI.PSD v 3.23.13, it can be found at 4:10884
    for ACPI.PSD v 3.23.14, it can be found at 4:107f8
    for ACPI.PSD v 3.23.15, it can be found at 4:106a0
    for ACPI.PSD v 3.23.16, it can be found at 4:1057c

    ACPI Version string at 3:15f
   */
   MEMOBJ = 3
   OFFSET = x2d(15f)
   n = 2+MEMOBJ
   parse var yyy.n . . baseaddr .

   address df 'cmd xxx da %(' baseaddr ' + ' d2x(OFFSET) ')'
   rc = CompressDfReturn()
   parse var xxx.1 . version
   say version
   version = word(xxx.1,8)
   if version == '3.23.12' then do
      OBJOFFSET = x2d(107d4)
   end
   else if version == '3.23.13' then do
      OBJOFFSET = x2d(10884)
   end
   else if version == '3.23.14' then do
      OBJOFFSET = x2d(107f8)
   end
   else if version == '3.23.15' then do
      OBJOFFSET = x2d(106a0)
   end
   else if version == '3.23.16' then do
      OBJOFFSET = x2d(1057c)
   end
   else if version == '3.23.10' then do
      OBJOFFSET = x2d(102f8)
   end
   else do
      say 'unknown ACPI version !'
      signal bailout
   end

   OBJNUM = 4
   last = yyy.0-1
   do i=3 to last
      parse var yyy.i obj . vbase .
      if x2d(obj) == OBJNUM then do
         leave
      end
   end
   airqi = d2x(OBJOFFSET+x2d(vbase))
   len = 'l100'
end /* do */
else do
   address df 'cmd xxx ln airqi'
   rc = CompressDfReturn()
   parse var xxx.1 2 airqi .
   len = 'lc0'
end /* do */

address df 'cmd xxx dw _R0DS l1'
rc = CompressDfReturn()
last = xxx.0-1
parse var xxx.last 12 r0ds .

address df 'cmd xxx .lmpo'
rc = CompressDfReturn()
rc = SysStemCopy(xxx,drivers)

address df 'cmd xxx dd 'airqi' 'len
rc = CompressDfReturn()
rc = SysStemCopy(xxx,yyy)
last = yyy.0-1
do n=1 to last
   parse var yyy.n 12 dirq . +15 irq .
   do while dirq <> 0
      say 'irq:'||x2d(irq)||' --------------------------------------'
      address df 'cmd xxx dd 'dirq' l3'
      rc = CompressDfReturn()
      parse var xxx.1 12 dirq 21 cs 25 ip . 34 ds .
      if x2d(ds) <> x2d(r0ds) then do
         address df 'cmd xxx .d dev 'ds':0000'
         rc = CompressDfReturn()
         last2 = xxx.0-1
         do o=1 to last2
            say xxx.o
         end /* do */
         say TAB||TAB||DriverNameFromDS(ds)
      end /* do */
      else do
         address df 'cmd xxx ln 'cs':'ip
         rc = CompressDfReturn()
         if xxx.1 <> 'No Symbols Found' then do
            parse var xxx.1 . . routine
         end
         else do
            routine = xxx.1
         end
         say '         DevStrat: 'routine' ('cs':'ip')'
      end /* do */
      say
   end
end
bailout:
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */


DriverNameFromDS: procedure expose drivers.
parse arg ds
last = drivers.0-1
do n=2 to last
   parse var drivers.n . . . drivername
   n = n+1
   parse var drivers.n keyword .
   n = n+1
   do while n <= last & drivers.n <> ''
      if keyword == 'obj' then
         parse var drivers.n . . . . . . . found .
      else
         parse var drivers.n . . . . . found .
      if x2d(ds) == x2d(found) then do
         signal quit
      end /* do */
      n = n+1
   end /* do */
end /* do */
quit:
if n>last then do
   drivername = 'unknown driver'
end
return drivername


