/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %mte          */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

address df 'cmd xxx lg os2krnl'
rc = CompressDfReturn()
/*
say '-------------- DOSCALLS MTE ----------------'
rc = FormatMTE(_DosModMte)

say '---------------- MVDM MTE ------------------'
rc = FormatMTE(_VDDModMte)
*/

say '------------- process MTEs -----------------'
address df 'cmd xxx dd _mte_h l1'
rc = CompressDfReturn()
parse var xxx.1 . linaddr
rc = FormatMTE(linaddr)
do while (mte.mte_link <> '00000000')
   rc = FormatMTE(mte.mte_link)
end

/*
say '------------- library MTEs -----------------'
address df 'cmd output dd _global_h l1'
rc = CompressDfReturn()
parse var xxx.1 . linaddr
rc = FormatMTE(linaddr)
do while (mte.mte_link <> '00000000')
   rc = FormatMTE(mte.mte_link)
end
*/

return 0


FormatMTE: procedure expose mte.
parse arg linaddr .
say 'mte at linear address %'linaddr
address df 'cmd yyy dw %'linaddr' l2'
rc = CompressDfReturn2()
parse var yyy.1 . mte.mte_flags2 mte.mte_handle
address df 'cmd yyy dd %'linaddr'+4 l4'
rc = CompressDfReturn2()
parse var yyy.1 . mte.mte_swapmte mte.mte_link mte.mte_flags1 mte.mte_impmodcnt
address df 'cmd yyy dw %'linaddr'+14 l2'
rc = CompressDfReturn2()
parse var yyy.1 . mte.mte_sfn mte.mte_usecnt
address df 'cmd yyy da %'linaddr'+18 l9'
rc = CompressDfReturn2()
parse var yyy.1 . mte.mte_modname
say 'mte_flags2:'mte.mte_flags2
say 'mte_handle:'mte.mte_handle
say 'mte_swapmte:'mte.mte_swapmte
say 'mte_link:'mte.mte_link
say 'mte_flags1:'mte.mte_flags1
say 'mte_impmodcnt:'mte.mte_impmodcnt
say 'mte_sfn:'mte.mte_sfn
say 'mte_usecnt:'mte.mte_usecnt
say 'mte_modname:'mte.mte_modname
say
return 0

CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

CompressDfReturn2: procedure expose yyy.
if yyy.1 == '' then do
   rc = SysStemDelete(yyy,1)
end
return rc 


IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
