/*

  REXX Script to install PrjBld and create a desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Installing..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "PrjBld", "<WP_DESKTOP>", "OBJECTID=<PRJBLDFOLDER>;ICONVIEW=ASPLACED,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || dir || "plaster.bmp,T;ICONFILE=" || dir || "idk.ICO", "replace"
call SysCreateObject "WPFolder", "Information", "<PRJBLDFOLDER>", "OBJECTID=<PBINFOFOLDER>;ICONVIEW=ASPLACED,NORMAL;ALWAYSSORT=YES;ICONFONT=8.Helv;BACKGROUND=" || dir || "plaster.bmp,T", "replace"
say "Creating program objects"

call SysCreateObject "WPProgram", "Why"  || d2c(10) || "Register?", "<PBINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "REGISTER.TXT", "replace"
call SysCreateObject "WPProgram", "Short"  || d2c(10) || "Product"  || d2c(10) || "Description", "<PBINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "FILE_ID.DIZ", "replace"
call SysCreateObject "WPProgram", "Readme" || d2c(10) || "Whats New?", "<PBINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "README.TXT", "replace"
call SysCreateObject "WPProgram", "Order" || d2c(10) || "Form", "<PBINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "ORDER.FRM", "replace"

call SysCreateObject "WPProgram", "IDK, Inc" || d2c(10) || "Web Site", "<PRJBLDFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.idk-inc.com", "replace"

call SysCreateObject "WPProgram", "PrjBld", "<PRJBLDFOLDER>", "EXENAME=" || dir || "PRJBLD.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
call SysCreateObject "WPProgram", "Purchase", "<PRJBLDFOLDER>", "EXENAME=" || dir || "PURCHASE.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Installation completed - PrjBld"
