#include "mrl.h"
#include <malloc.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

unsigned int mmin = 65535;	/* Low-end  of .MSG */
unsigned int mmax = 0;		/* High-end of .MSG */
unsigned int mlast = 0;		/* Lastread Pointer */
unsigned int mmsgs = 0;
char *logname="mrl.log";
int loglevel=3; /* Log level */

void helptext(void)
{
 printf("Ussage: MRL -[option1..N]  <Directory>\n");
 printf("\nMRL is utility for helping FIDONET Sysops to manage their messagebases.\nI use it for some actions in my T-MAIL's NETMAIL area.");
 printf("\nWARNING: This programs works ONLY with FTS-0001 *.MSG messabases.");
 printf("\nOptions:\nL - Link messages by MSGID\nR - Renumber messages\nP <nn> - Purge messages to max nn.\n");
 printf("F - turn off lastread pointer fix\nV <n> - Set logfile level to n <1-5> def. 3\nN <name> - set logfile name, def. mrl.log\n");
 printf("\n\nExample:\nmrl -n d:\\t-mail\\log\\mrl.log -l -r \\msg\\elkin\n");

/* WriteLog(logname,"BAd ArGuMenTS",'!'); */
 return;
}

#define FALSE 0
#define TRUE  1

int
main (int narg,char *arg[])
{
  char purge=FALSE,renumber=FALSE,link=FALSE,fix=TRUE;
  char nextnum=FALSE;
  unsigned int nechat=0;
  char *dir=malloc(260);
  char *tmp=malloc(260);
  int i;
  time_t zacatek;
  zacatek=time(NULL);
  if ((!dir)||(!tmp)) return 255;
  strcpy(dir,"");
  printf(APP_VERSION". Copyright by Radim Kolar (2:423/66.111,hsn@cybermail.net)\n");
  printf("This program is public domain and may be freely modified.\n");
  printf("Compiled date "__DATE__", using GCC "__VERSION__" with emx09c package.\n\n");
  if(narg<2) {
    helptext();
    return 2;
              };
  for(i=1;i<narg;i++)
  {
   if (nextnum==TRUE) { nextnum=FALSE; nechat=atoi(arg[i]);
			if (nechat<1) { purge=FALSE;
   				printf("%s in NOT number, setting purge=No.\n",arg[i]);
			      	}else
                         continue;
                         }	 
   if (nextnum==TRUE+1) { nextnum=FALSE; loglevel=atoi(arg[i]);
			if (loglevel<1) { loglevel=3;
   				printf("%s in NOT number, setting loglevel=3.\n",arg[i]);
			      	}else
                         continue;
                         }	 
   if (nextnum==TRUE+2) { nextnum=FALSE; 
                          /* free(logname); */
                          logname=malloc(strlen(arg[i])+1);
                          if (logname) strcpy(logname,arg[i]);
                         continue;
                         }	 

   if((*(arg[i])=='-')&&(strlen(arg[i])==2))
 	/* naber parametry */
    {switch(toupper(*(arg[i]+1)))
     {
      case 'P':nextnum=TRUE;purge=TRUE;break;
      case 'L':link=TRUE;break;
      case 'R':renumber=TRUE;break;
      case 'F':fix=FALSE;break;
      case 'V':nextnum=TRUE+1;break;
      case 'N':nextnum=TRUE+2;break;
      default: printf("Bad parameter : %c\n",*(arg[i]+1));
      }      
     continue; 
     } 
   if((*(arg[i])=='-')&&(strlen(arg[i])!=2))
     {
      printf("Parameter %s is too long or too short-ignored\n",arg[i]);
      continue;
     }
   strcpy(dir,arg[i]); 
  }
  if(nextnum==TRUE) {
      printf("No number after -P, setting purge=No.\n");
      purge=FALSE;
      };
  if(strlen(dir)==0) {printf("Working directory is NOT set, aborting.\n");
	              return 2;
		     };
  WriteLog(logname,NULL,'!');                   
  WriteLog(logname,"Begin, "APP_VERSION,'+'); 
  printf("MRL started with this option(s):\n");
  printf("\tWorking directory: %s\n",dir);
  sprintf(tmp,"Working directory: %s",dir);
  WriteLog(logname,tmp,'-');
  printf("\tFix lastread pointer: %s\n",(fix==TRUE)?"YES":"NO");
  sprintf(tmp,"Fix lastread pointer: %s",(fix==TRUE)?"YES":"NO");
  WriteLog(logname,tmp,'-');
  printf("\tPurge messages: %s\n",(purge==TRUE)?"YES":"NO");
  sprintf(tmp,"Purge messages: %s",(purge==TRUE)?"YES":"NO");
  WriteLog(logname,tmp,'-');
  if(purge) { printf("\t\tLeave max. %d messages\n",nechat);
              sprintf(tmp,"...Leave max. %d messages\n",nechat);
              WriteLog(logname,tmp,'-');
            }
  printf("\tRenumber messages: %s\n",(renumber==TRUE)?"YES":"NO");
  sprintf(tmp,"Renumber messages: %s",(renumber==TRUE)?"YES":"NO");
  WriteLog(logname,tmp,'-');
  printf("\tLink messages: %s\n",(link==TRUE)?"YES":"NO");
  sprintf(tmp,"Link messages: %s",(link==TRUE)?"YES":"NO");
  WriteLog(logname,tmp,'-');
  printf("\tLog level: %d\n",loglevel);
  sprintf(tmp,"Log level: %d",loglevel);
  WriteLog(logname,tmp,'-');
  printf("\tLog file name: %s\n",logname);
  sprintf(tmp,"Log file name: %s",logname);
  WriteLog(logname,tmp,'-');
  /* konec Uvodnich Hlasek */
  printf("\nMRL: Scaning directory %s - ",dir);
  sprintf(tmp,"Scaning directory %s",dir);
  WriteLog(logname,tmp,'#');
  i=Scan(dir);
  printf("%s",(i==0)?"OK\n":"Error while scanning\n");
  if(i) return 1;
  printf("\tThere are %d messages\n",mmsgs);
  sprintf(tmp,"There are %d messages",mmsgs);
  WriteLog(logname,tmp,':');
  if(mmsgs)
    {
     printf("\tMessages are in range from %d to %d\n",mmin,mmax);
     sprintf(tmp,"Messages are in range from %d to %d",mmin,mmax);
     WriteLog(logname,tmp,':');
     printf("\tLastread points to %d\n",mlast);
     sprintf(tmp,"Lastread points to %d",mlast);
     WriteLog(logname,tmp,':');
     if ((mlast>mmax)&&(fix))
                     { printf("MRL: Fixing last read pointer.\n");
                       WriteLog(logname,"Fixing last read pointer.",'#');
                       FixLRP(dir);
                     }

    }
  if( ((!purge)&&(!renumber)&&(!link)&&(!fix))||(!mmsgs))
   {
    printf("MRL: Nothing to do.");
    WriteLog(logname,"End (nothing to do), "APP_VERSION,'+');      
    return 0;
   }

  if(purge)
  {
    
    printf("MRL: Purging messages in %s - ",dir);
    sprintf(tmp,"Purging messages (leave %d)",nechat);
    WriteLog(logname,tmp,'#');
    i=Kill(dir,nechat);  
    printf("%s",(i==0)?"OK\n":"Error while purging\n");
    if(i) return 1;
    printf("MRL: ReScaning directory %s - ",dir);
    i=Scan(dir);
    printf("%s",(i==0)?"OK\n":"Error while rescanning\n");
    if(i) return 1;
   } 
  if(renumber)
  {
    WriteLog(logname,"Renumbering messages",'#');
    printf("MRL: Renumbering messages in %s - ",dir);
    i=Renum(dir);
    printf("%s",(i==0)?"OK\n":"Error while renumbering\n");
    if(i) return 1;
    printf("MRL: ReScaning directory %s - ",dir);
    i=Scan(dir);
    printf("%s",(i==0)?"OK\n":"Error while rescanning\n");
    if(i) return 1;
   } 
  if(link)
  {
    WriteLog(logname,"Linking messages",'#');
    printf("MRL: Linking messages in %s - ",dir);
    i=Link(dir);
    printf("%s",(i==0)?"OK\n":"Error while linking\n");
    if(i) return 1;
   } 
  WriteLog(logname,"End, "APP_VERSION,'+');  
  printf("MRL: Successfuly ended. Time elapsed: %ld sec.",time(NULL)-zacatek);

 free(dir); 
 free(tmp);
 return 0;
}
