#include <dnpap.h>
#include <memory.h>
#include <maxmem.h>
#include <snmp.h>
#include <stdlib.h>

#include "log.h"


static CHAR MODULE[] = "LogM";


WORD LogEventIndex(SNMP_OBJECT *obj, WORD idlen, RmonLog *log)
{
	switch (obj->Request)
	{
    case SNMP_PDU_NEXT:
	case SNMP_PDU_GET:
        obj->Syntax.LngInt = obj->Id[idlen];
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
		return SNMP_READONLY;
	}
}


WORD LogIndex(SNMP_OBJECT *obj, WORD idlen, RmonLog *log)
{
	switch (obj->Request)
	{
    case SNMP_PDU_NEXT:
	case SNMP_PDU_GET:
        obj->Syntax.LngInt = obj->Id[idlen+1];
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
		return SNMP_READONLY;
	}
}


WORD LogTime(SNMP_OBJECT *obj, WORD idlen, RmonLog *log)
{
	switch (obj->Request)
	{
    case SNMP_PDU_NEXT:
	case SNMP_PDU_GET:
		obj->Syntax.LngUns = log->TimeTicks;
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
		return SNMP_READONLY;
	}
}


WORD LogDescription(SNMP_OBJECT *obj, WORD idlen, RmonLog *log)
{
	switch (obj->Request)
	{
    case SNMP_PDU_NEXT:
	case SNMP_PDU_GET:
		memcpy(obj->Syntax.BufChr, log->Description, obj->SyntaxLen = log->DescrLen);
		return SNMP_NOERROR;
	case SNMP_PDU_SET:
		return SNMP_READONLY;
	}
}


RmonLog *NewRmonLog(WORD nrlogs)
{
	return DnpapMalloc(nrlogs*sizeof(RmonLog));
}


RmonLog *ReNewRmonLog(RmonLog* ptr, WORD nrlogs, WORD oldnrlogs, WORD maxnrlogs)
{           
WORD n, nold;

	if (nrlogs > maxnrlogs || nrlogs*sizeof(RmonLog) > MemoryGetMaxChunk())
		return NULL;
    n = ((nrlogs-1)/MINALLOCLOGS)*MINALLOCLOGS+MINALLOCLOGS;
    nold = ((oldnrlogs-1)/MINALLOCLOGS)*MINALLOCLOGS+MINALLOCLOGS;
    if (ptr == NULL || abs(n-nold) >= MINALLOCLOGS)  
    {
        return DnpapRealloc(ptr, min(n, maxnrlogs)*sizeof(RmonLog));
    }        
    else
        return ptr;
}


VOID DelRmonLog(RmonLog* ptr)
{
    DnpapFree(ptr);
}

