#include <dnpap.h>
#include <stdarg.h>
#include <message.h>
#include <string.h>

#include "neuro_d.h"
#include "neuro_e.h"



static CHAR MODULE[] =	"NeuroError";



int tracing_ =		1;
int debugging_ =	1;



static CHAR* NeuronErrorMsgs[NEURO_LASTERR-NEURO_ERROFFSET];


static CHAR* SetNeuronErrorMsg(LONG code, CHAR* msg);



CHAR* NeuronErrorMsg(LONG code)
{
	return NeuronErrorMsgs[code-NEURO_ERROFFSET];
}


CHAR* SetNeuronErrorMsg(LONG code, CHAR* msg)
{
	NeuronErrorMsgs[code-NEURO_ERROFFSET] = MALLOC(strlen(msg)+1);
	if (NeuronErrorMsgs[code-NEURO_ERROFFSET] != NULL)
		strcpy(NeuronErrorMsgs[code-NEURO_ERROFFSET], msg);
        return NeuronErrorMsgs[code-NEURO_ERROFFSET];
}


BOOLEAN NeuroErrorInit(VOID)
{
        SetNeuronErrorMsg(NEURO_NETNULL, "");
        SetNeuronErrorMsg(NEURO_ERROFFSET, "");
	SetNeuronErrorMsg(NEURO_LINDEX, "");
        SetNeuronErrorMsg(NEURO_NINDEX, "");
        SetNeuronErrorMsg(NEURO_WINDEX, "");
    	SetNeuronErrorMsg(NEURO_SMALL, "");
        SetNeuronErrorMsg(NEUROC_ALLOCATE, "");
        SetNeuronErrorMsg(NEUROC_TIMERREG, "");
	SetNeuronErrorMsg(NEURO_NOSTATUS, "");
        SetNeuronErrorMsg(NEURO_CALCERR, "");
        SetNeuronErrorMsg(NEURO_NOINPUT, "");
        SetNeuronErrorMsg(NEURO_NORESULT, "");
	SetNeuronErrorMsg(NEURO_NOTARGET, "");
        SetNeuronErrorMsg(NEURO_WRONGTYPE, "");
        SetNeuronErrorMsg(NEURO_DATASRC, "");
        SetNeuronErrorMsg(NEURO_ALLOCATE, "");
        SetNeuronErrorMsg(NEURO_TIMERREG, "");
        SetNeuronErrorMsg(NEURO_ERRINIT, "");
        SetNeuronErrorMsg(NEURO_CONFIGINIT, "");

        return TRUE;
}
