#ifndef _STATC_H
#define _STATC_H


#include <dnpap.h>
#include <mac.h>
#include <timer.h>
#include <snmp.h>


typedef struct _ETHER_STATS
{
    LONG            Source[SNMP_SIZE_BUFINT];
    WORD            SourceLen;
    LWORD           DropEvents;                     
    LWORD           Octets;
    LWORD           Pkts; 
    LWORD           BroadcastPkts; 
    LWORD           MulticastPkts;
    LWORD           CRCAlignErrors;
    LWORD           UndersizePkts;
    LWORD           OversizePkts;
    LWORD           Fragments;
    LWORD           Jabbers;
    LWORD           Collisions;
    LWORD           Pkts64Octets; 
    LWORD           Pkts65to127Octets; 
    LWORD           Pkts128to255Octets; 
    LWORD           Pkts256to511Octets;
    LWORD           Pkts512to1023Octets;
    LWORD           Pkts1024to1518Octets;
    LWORD           OldNetStat[9];
    BYTE            Owner[SNMP_SIZE_BUFCHR];
    WORD            OwnerLen;
    LONG            Status;
    MAC_COLL        Coll;
    TIMER_DESCR     *Timer;
    MAC_IFACE       *Iface;

} ETHER_STATS;


BOOLEAN StatCInit (ETHER_STATS *etherStats);
BOOLEAN StatCStart (ETHER_STATS *etherStats);
BOOLEAN StatCStop (ETHER_STATS *etherStats);


#endif
