#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <snmp.h>
#include <mibsup.h>
#include <message.h>
#include <mac.h>

#include "dstate.h"
#include "dstatc.h"
#include "dstat.h"


#define INDEXSIZE      		1
#define BUCKETINDEXSIZE     2


static MIB_LOCAL    *etherStats = NULL;


static BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize);



BOOLEAN DnpapEtherStatsMInit(VOID)
{
    MessageConfig(DNPAP_STATISTICS_ERROR, "DnpapEtherStat");
    return TRUE;
}


BOOLEAN RmonNext (SNMP_OBJECT *obj, MIB_LOCAL **local, WORD idlen, WORD indexsize)
{
DNPAP_ETHER_STATS *data;

    if (*local == NULL || indexsize < 1)
        return FALSE;

    if (obj->IdLen < idlen + indexsize)
    {
        switch (indexsize)
        {
        case BUCKETINDEXSIZE:
            while (*local != NULL && ((DNPAP_ETHER_STATS*)(*local)->Data)->Status != SNMP_VALID)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + BUCKETINDEXSIZE;
            break;
        case INDEXSIZE:
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + INDEXSIZE;
            break;
        }
        return TRUE;
    }
    else
    {
        switch (indexsize)
        {            
        case BUCKETINDEXSIZE:
        	data = (DNPAP_ETHER_STATS*)(*local)->Data;
            if (data->Status == SNMP_VALID && obj->Id[idlen+1] < data->IATNrBuckets)
            {
                obj->Id[idlen] = (*local)->Index;
                obj->Id[idlen+1]++;
                obj->IdLen = idlen + BUCKETINDEXSIZE;
                break;
            }
            *local = (*local)->Next;
            while (*local != NULL && ((DNPAP_ETHER_STATS*)(*local)->Data)->Status != SNMP_VALID)
                *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->Id[idlen+1] = 1;
            obj->IdLen = idlen + BUCKETINDEXSIZE;
            break;
        case INDEXSIZE:
            *local = (*local)->Next;
            if (*local == NULL)
                return FALSE;
            obj->Id[idlen] = (*local)->Index;
            obj->IdLen = idlen + INDEXSIZE;
            break;
        }
        return TRUE;
    }
    return FALSE;
}

WORD DnpapEtherStatsIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon (Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsDataSource (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_IFACE    *iface;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {           
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        memcpy (Obj->Syntax.BufInt, data->Source, data->SourceLen * sizeof (LONG));
        Obj->SyntaxLen = data->SourceLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        if (data->SourceLen != Obj->SyntaxLen ||
            memcmp(data->Source, Obj->Syntax.BufInt, (data->SourceLen-1) * sizeof (LONG)))
            return SNMP_BADVALUE;
        if ((iface = MacIfaceGet((WORD) Obj->Syntax.BufInt[Obj->SyntaxLen-1])) == NULL)
            return SNMP_BADVALUE;
        memcpy (data->Source, Obj->Syntax.BufInt, Obj->SyntaxLen * sizeof (LONG));
        data->SourceLen = Obj->SyntaxLen;
        data->Iface = iface;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsDropEvents (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.LostPkts + stat.DiscardedPkts - (data->BaseStat.LostPkts + data->BaseStat.DiscardedPkts);
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsOctets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Octets;
        return SNMP_NOERROR;
    }
}
WORD DnpapEtherStatsPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts;
        return SNMP_NOERROR;
    }
}
                                                
WORD DnpapEtherStatsBroadcastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.BroadcastPkts - data->BaseStat.BroadcastPkts;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsMulticastPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.MulticastPkts - data->BaseStat.MulticastPkts;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsCRCAlignErrors (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.CRCAlignErrors - data->BaseStat.CRCAlignErrors;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsUndersizePkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.UndersizePkts - data->BaseStat.UndersizePkts;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsOversizePkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.OversizePkts - data->BaseStat.OversizePkts;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsFragments (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.Fragments - data->BaseStat.Fragments;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsJabbers (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.Jabbers - data->BaseStat.Jabbers;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsCollisions (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
MAC_STAT     stat;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_VALID)
        {
            Obj->Syntax.LngUns = 0UL;
            return SNMP_NOERROR;
        }
        MacStatistics(data->Iface, &stat);
        Obj->Syntax.LngUns = stat.Collisions - data->BaseStat.Collisions;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts64 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts64Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts65to127 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts65to127Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts128to255 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts128to255Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts256to511 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts256to511Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts512to1023 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts512to1023Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsPkts1024to1518 (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngUns = data->Pkts1024to1518Octets;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsIATNrBuckets (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;
ULONG *buckets;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
        case SNMP_PDU_NEXT:
            if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
                return SNMP_NOSUCHNAME;
        case SNMP_PDU_GET:
            data = (DNPAP_ETHER_STATS*) local->Data;
            Obj->Syntax.LngInt = data->IATNrBuckets;
            return SNMP_NOERROR;
        case SNMP_PDU_SET:
            data = (DNPAP_ETHER_STATS*) local->Data;
            if (data->Status != SNMP_UNDERCREATION)
                return SNMP_READONLY;              
            if (Obj->Syntax.LngInt < 1)
            	return SNMP_BADVALUE;
            if ((buckets = ReNewBuckets(data->IATBuckets, Obj->Syntax.LngInt)) == NULL)
                return SNMP_GENERROR;
            data->IATNrBuckets = Obj->Syntax.LngInt;
            data->IATBuckets = buckets;
            return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsIATInterval (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
        case SNMP_PDU_NEXT:
            if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
                return SNMP_NOSUCHNAME;
        case SNMP_PDU_GET:
            data = (DNPAP_ETHER_STATS*) local->Data;
            Obj->Syntax.LngInt = data->IATInterval;
            return SNMP_NOERROR;
        case SNMP_PDU_SET:
            data = (DNPAP_ETHER_STATS*) local->Data;
            if (data->Status != SNMP_UNDERCREATION)
                return SNMP_READONLY;              
            if (Obj->Syntax.LngInt < 1)
            	return SNMP_BADVALUE;
            data->IATInterval = Obj->Syntax.LngInt;
            return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsOwner (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        memcpy (Obj->Syntax.BufChr, data->Owner, data->OwnerLen);
        Obj->SyntaxLen = data->OwnerLen;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        data = (DNPAP_ETHER_STATS*) local->Data;
        if (data->Status != SNMP_UNDERCREATION)
            return SNMP_READONLY;
        memcpy (data->Owner, Obj->Syntax.BufChr, Obj->SyntaxLen);
        data->OwnerLen = Obj->SyntaxLen;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsStatus (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    local = MibRmon(Obj, etherStats, IdLen, INDEXSIZE);

    switch (Obj->Request)
    {
    case SNMP_PDU_GET:
        if (local == NULL)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
        {
            Obj->Syntax.LngInt = SNMP_INVALID;
            return SNMP_NOSUCHNAME;
        }
        data = (DNPAP_ETHER_STATS*) local->Data;
        Obj->Syntax.LngInt = data->Status;
        return SNMP_NOERROR;
    case SNMP_PDU_SET:
        if (local == NULL)
        {
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_CREATEREQUEST:
                if ((local = MibInsert(Obj, &etherStats, IdLen, INDEXSIZE)) == NULL)
                    return SNMP_GENERROR;
                if ((local->Data = DnpapMalloc(sizeof(DNPAP_ETHER_STATS))) == NULL)
                    return SNMP_GENERROR;
                data = (DNPAP_ETHER_STATS*) local->Data;
                memset(data, 0, sizeof(DNPAP_ETHER_STATS));
                if (DnpapStatCInit(data) == TRUE)
                {
                    data->Status = SNMP_UNDERCREATION;
                    DnpapMessage(DMC_MESSAGE, DSTAT_CREATE, "detherStat: collector %ld created", local->Index);
                    return SNMP_NOERROR;
                }
                DnpapFree(local->Data);
                MibRemove (Obj, &etherStats, IdLen, INDEXSIZE);
                return SNMP_GENERROR;
            default:
                return SNMP_NOSUCHNAME;
            }
        }
        data = (DNPAP_ETHER_STATS*) local->Data;
        switch (data->Status)
        {
        case SNMP_UNDERCREATION:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_VALID:
                if (DnpapStatCStart(data) == TRUE)
                {
                    data->Status = SNMP_VALID;
                    DnpapMessage(DMC_MESSAGE, DSTAT_ACTIVE, "detherStat: collector %ld active", local->Index);
                    return SNMP_NOERROR;
                }
                else
                    return SNMP_GENERROR;
            case SNMP_INVALID:
                if (DnpapStatCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, DSTAT_DESTROY, "detherStat: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &etherStats, IdLen, INDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            default:
                return SNMP_BADVALUE;
            }
        case SNMP_VALID:
            switch (Obj->Syntax.LngInt)
            {
            case SNMP_INVALID:
                if (DnpapStatCStop(data) == TRUE)
                {
                    DnpapFree(local->Data);
                    DnpapMessage(DMC_MESSAGE, DSTAT_DESTROY, "detherStat: collector %ld destroyed", local->Index);
                    if (MibRemove (Obj, &etherStats, IdLen, INDEXSIZE) == TRUE)
                        return SNMP_NOERROR;
                }
                return SNMP_GENERROR;
            case SNMP_VALID:
                return SNMP_NOERROR;
            default:
                return SNMP_BADVALUE;
            }
        }
    }
}

WORD DnpapEtherStatsIATIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon (Obj, etherStats, IdLen, BUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = local->Index;
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsIATBucketIndex (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;

    if ((local = MibRmon (Obj, etherStats, IdLen, BUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;
    switch (Obj->Request)
    {
    case SNMP_PDU_NEXT:
        if (RmonNext (Obj, &local, IdLen, INDEXSIZE) == FALSE)
            return SNMP_NOSUCHNAME;
    case SNMP_PDU_GET:
        Obj->Syntax.LngInt = Obj->Id[IdLen+1];
        return SNMP_NOERROR;
    }
}

WORD DnpapEtherStatsIATIntervalPkts (SNMP_OBJECT *Obj, WORD IdLen)
{
MIB_LOCAL    *local = NULL;
DNPAP_ETHER_STATS  *data;

    if ((local = MibRmon(Obj, etherStats, IdLen, BUCKETINDEXSIZE)) == NULL)
        return SNMP_NOSUCHNAME;

    switch (Obj->Request)
    {
        case SNMP_PDU_NEXT:
            if (RmonNext (Obj, &local, IdLen, BUCKETINDEXSIZE) == FALSE)
                return SNMP_NOSUCHNAME;
        case SNMP_PDU_GET:
            data = (DNPAP_ETHER_STATS*) local->Data;
            Obj->Syntax.LngInt = data->IATBuckets[Obj->Id[IdLen+1]-1];
            return SNMP_NOERROR;
        case SNMP_PDU_SET:
            return SNMP_READONLY;
    }
}
