#include <stdlib.h>
#include <stdio.h>
#include <dnpap.h>
#include <timer.h>
#include <mac.h>
#include <chain.h>
#include <config.h>


#define GEN_BUFFER_SIZE 1514


typedef struct _GEN_DESCR GEN_DESCR;
typedef struct _GEN_VALUE GEN_VALUE;


struct _GEN_DESCR
{
    WORD        count;
    GEN_VALUE   *valueList;
};

struct _GEN_VALUE
{
    WORD        value;
    GEN_VALUE   *next;
};

void GenTimerCallBack(TIMER_DESCR *timer, ULONG now, void *parm);
WORD GenRand(GEN_DESCR *descr);
BOOLEAN GenDescrRead(BYTE *root, GEN_DESCR *descr);


GEN_DESCR genDescrSrc[6];
GEN_DESCR genDescrDst[6];
GEN_DESCR genDescrType;
GEN_DESCR genDescrLength;
GEN_DESCR genDescrIat;


MAC_HDR     genHdr;
CHAIN       genChain;
MAC_IFACE   *genIface;
ULONG       genIat = 1000;
TIMER_DESCR *genTimer;



BOOLEAN GenInit(void)
{
    BYTE    name[255];
    BYTE    *descr;
    USHORT  i;
    
    genHdr.src = DnpapMalloc(6);
    if (genHdr.src==0)
        return FALSE;
    genHdr.dst = DnpapMalloc(6);
    if (genHdr.dst==0)
        return FALSE;
    genChain.buffer = DnpapMalloc(GEN_BUFFER_SIZE);
    if (genChain.buffer==0)
        return FALSE;
    genChain.size = GEN_BUFFER_SIZE;
    
    
    if (!ConfigGetString("gen.iface",&descr))
        return TRUE;

    genIface=MacIfaceFind(descr);
    if (genIface==0)
        return FALSE;
    
    for (i=0;i<6;i++)
    {
        sprintf(name,"gen.src.%d",(i+1));
        genDescrSrc[i].count=0;
        genDescrSrc[i].valueList=0;
        if (!GenDescrRead(name, genDescrSrc+i))
            return FALSE;
    }
 
    for (i=0;i<6;i++)
    {
        sprintf(name,"gen.dst.%d",(i+1));
        genDescrDst[i].count=0;
        genDescrDst[i].valueList=0;
        if (!GenDescrRead(name, genDescrDst+i))
            return FALSE;
    }

    if (!GenDescrRead("gen.type", &genDescrType))
        return FALSE;
    if (!GenDescrRead("gen.length", &genDescrLength))
        return FALSE;
    if (!GenDescrRead("gen.iat", &genDescrIat))
        return FALSE;

    genTimer=TimerRegister(GenTimerCallBack, 0, genIat,
        TIMER_FOREVER, TIMER_TYPE_RECOVER);
    if (genTimer==0)
        return FALSE;

    srand(123);

    return TRUE;
}




void GenTimerCallBack(TIMER_DESCR *timer, ULONG now, void *parm)
{
    genHdr.src[0]=(BYTE)(GenRand(genDescrSrc+0) % 256);
    genHdr.src[1]=(BYTE)(GenRand(genDescrSrc+1) % 256);
    genHdr.src[2]=(BYTE)(GenRand(genDescrSrc+2) % 256);
    genHdr.src[3]=(BYTE)(GenRand(genDescrSrc+3) % 256);
    genHdr.src[4]=(BYTE)(GenRand(genDescrSrc+4) % 256);
    genHdr.src[5]=(BYTE)(GenRand(genDescrSrc+5) % 256);
    
    genHdr.dst[0]=(BYTE)(GenRand(genDescrDst+0) % 256);
    genHdr.dst[1]=(BYTE)(GenRand(genDescrDst+1) % 256);
    genHdr.dst[2]=(BYTE)(GenRand(genDescrDst+2) % 256);
    genHdr.dst[3]=(BYTE)(GenRand(genDescrDst+3) % 256);
    genHdr.dst[4]=(BYTE)(GenRand(genDescrDst+4) % 256);
    genHdr.dst[5]=(BYTE)(GenRand(genDescrDst+5) % 256);

    genHdr.type=GenRand(&genDescrType);
    
    genChain.length=GenRand(&genDescrLength);
    genChain.offset=genChain.size-genChain.length;

    genIat=GenRand(&genDescrIat);
    TimerChange(genTimer, genIat);
    
    MacSend(genIface, &genChain, &genHdr);
}


WORD GenRand(GEN_DESCR *descr)
{
    USHORT      r, i;
    GEN_VALUE   *v;
    
    if (descr->count == 0)
        return 0;
    
    if (descr->count == 1)
        return descr->valueList->value;
    
    r = rand();
    i = (ULONG)((ULONG)descr->count * (ULONG)r / (ULONG)(RAND_MAX + 1L));
    v = descr->valueList;
    while (i-->0 && v!=0)
        v=v->next;
    if (v!=0)
        return v->value;
    else
        return 0;
}




BOOLEAN GenDescrRead(BYTE *root, GEN_DESCR *descr)
{
    BYTE        name[255];
    GEN_VALUE   *v;
    USHORT      s;

    sprintf(name,"%s.%d",root,(descr->count+1));
    while (ConfigGetShort(name, &s))
    {
        v=DnpapMalloc(sizeof(GEN_VALUE));
        if (v==0)
            return FALSE;
        v->value=s;
        v->next=descr->valueList;
        descr->valueList=v;
        descr->count++;
        sprintf(name,"%s.%d",root,(descr->count+1));
    }
    return TRUE;
}
