#define  INCL_BASE
#include <os2.h>
#include <memory.h>
#include <string.h>
#include <stdio.h>
#include <maxmem.h>
#include <dnpap.h>
#include <message.h>
#include <timer.h>
#include <block.h>
#include <mac.h>
#include <snor.h>
#include <agent.h>
#include <ether.h>
#include <ip.h>
#include <icmp.h>
#include <udp.h>
#include <pipe.h>
#include <echo.h>
#include <snmp.h>
#include <mibsup.h>
#include <sys.h>
#include <maxmib.h>
#include <agent.h>
#include <info.h>
#include <stat.h>
#include <hist.h>
#include <protocol.h>
#include <capture.h>
#include <filter.h>
#include <channel.h>
#include <matrix.h>
#include <host.h>
#include <topn.h>
#include <alarm.h>
#include <event.h>
#include <config.h>
#include <soft.h>
#include <loop.h>
#include <gen.h>
#include <perf.h>
#include <perfm.h>
#include <register.h>

#ifdef DNPAP_RMON_EXTENSIONS
#include <dstats.h>
#include <dfilter.h>
#include <dhost.h>
#include <dtopn.h>
#include <dmatrix.h>
#endif

#include "beholder.h"



CHAR *trapcomm;


MIB_COMMUNITY beholderPrf[] =
{                                
    { "public", 6, MIB_READ},
    { "dnpap", 5, MIB_READ | MIB_WRITE },
    { "collector", 9, MIB_READ | MIB_WRITE },
    { "viewer", 6, MIB_READ | MIB_WRITE }
};


MIB_ELEMENT beholderObj[] =
{
    { {1,3,6,1,2,1,1,1}, 8,  sysDescr, SNMP_DISPLAYSTR, MIB_READ},
    { {1,3,6,1,2,1,1,2}, 8,  sysObjectID, SNMP_OBJECTID, MIB_READ},
    { {1,3,6,1,2,1,1,3}, 8,  sysUpTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,1,4}, 8,  sysContact, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,1,5}, 8,  sysName, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,1,6}, 8,  sysLocation, SNMP_DISPLAYSTR, MIB_READ},
    { {1,3,6,1,2,1,1,7}, 8,  sysServices, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,1},  11,  etherStatsIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,2},  11,  etherStatsDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,1,1,1,3},  11,  etherStatsDropEvents, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,4},  11,  etherStatsOctets, SNMP_COUNTER, MIB_READ}, 
    { {1,3,6,1,2,1,16,1,1,1,5},  11,  etherStatsPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,6},  11,  etherStatsBroadcastPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,7},  11,  etherStatsMulticastPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,8},  11,  etherStatsCRCAlignErrors, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,9},  11,  etherStatsUndersizePkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,10}, 11,  etherStatsOversizePkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,11}, 11,  etherStatsFragments, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,12}, 11,  etherStatsJabbers, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,13}, 11,  etherStatsCollisions, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,14}, 11,  etherStatsPkts64Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,15}, 11,  etherStatsPkts65to127Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,16}, 11,  etherStatsPkts128to255Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,17}, 11,  etherStatsPkts256to511Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,18}, 11,  etherStatsPkts512to1023Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,19}, 11,  etherStatsPkts1024to1518Octets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,1,1,1,20}, 11,  etherStatsOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,1,1,1,21}, 11,  etherStatsStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,1,1,1},  11,  HistoryControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,2,1,1,2},  11,  HistoryControlDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,1,1,3},  11,  HistoryControlBucketsRequested, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,1,1,4},  11,  HistoryControlBucketsGranted, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,2,1,1,5},  11,  HistoryControlInterval, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,1,1,6},  11,  HistoryControlOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,1,1,7},  11,  HistoryControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,2,2,1,1},  11,  EtherHistoryIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,2},  11,  EtherHistorySampleIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,3},  11,  EtherHistoryIntervalStart, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,4},  11,  EtherHistoryDropEvents, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,5},  11,  EtherHistoryOctets, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,6},  11,  EtherHistoryPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,7},  11,  EtherHistoryBroadcastPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,8},  11,  EtherHistoryMulticastPkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,9},  11,  EtherHistoryCRCAlignErrors, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,10}, 11,  EtherHistoryUndersizePkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,11}, 11,  EtherHistoryOversizePkts, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,12}, 11,  EtherHistoryFragments, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,13}, 11,  EtherHistoryJabbers, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,14}, 11,  EtherHistoryCollisions, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,2,2,1,15}, 11,  EtherHistoryUtilization, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,3,1,1,1},  11,  AlarmIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,3,1,1,2},  11,  AlarmInterval, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,3},  11,  AlarmVariable, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,4},  11,  AlarmSampleType, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,5},  11,  AlarmValue, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,3,1,1,6},  11,  AlarmStartupAlarm, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,7},  11,  AlarmRisingThreshold, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,8},  11,  AlarmFallingThreshold, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,9},  11,  AlarmRisingEventIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,10}, 11,  AlarmFallingEventIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,11}, 11,  AlarmOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,3,1,1,12}, 11,  AlarmStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,4,1,1,1},  11,  hostControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,1,1,2},  11,  hostControlDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,4,1,1,3},  11,  hostControlTableSize, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,1,1,4},  11,  hostControlLastDeleteTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,4,1,1,5},  11,  hostControlOwner, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,4,1,1,6},  11,  hostControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,4,2,1,1},  11,  hostAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,2},  11,  hostCreationOrder, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,3},  11,  hostIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,4},  11,  hostInPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,5},  11,  hostOutPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,6},  11,  hostInOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,7},  11,  hostOutOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,8},  11,  hostOutErrors, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,9},  11,  hostOutBroadcastPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,2,1,10}, 11,  hostOutMulticastPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,1},  11,  hostTimeAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,2},  11,  hostTimeCreationOrder, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,3},  11,  hostTimeIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,4},  11,  hostTimeInPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,5},  11,  hostTimeOutPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,6},  11,  hostTimeInOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,7},  11,  hostTimeOutOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,8},  11,  hostTimeOutErrors, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,9},  11,  hostTimeOutBroadcastPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,4,3,1,10}, 11,  hostTimeOutMulticastPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,1,1,1},  11,  HostTopNControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,1,1,2},  11,  HostTopNHostIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,1,1,3},  11,  HostTopNRateBase, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,1,1,4},  11,  HostTopNTimeRemaining, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,1,1,5},  11,  HostTopNDuration, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,1,1,6},  11,  HostTopNRequestedSize, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,1,1,7},  11,  HostTopNGrantedSize, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,1,1,8},  11,  HostTopNStartTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,5,1,1,9},  11,  HostTopNOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,1,1,10}, 11,  HostTopNStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,5,2,1,1},  11,  HostTopNReport, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,2,1,2},  11,  HostTopNIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,5,2,1,3},  11,  HostTopNAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,5,2,1,4},  11,  HostTopNRate, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,1,1,1},  11,  MatrixControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,1,1,2},  11,  MatrixControlDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,6,1,1,3},  11,  MatrixControlTableSize, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,1,1,4},  11,  MatrixControlLastDeleteTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,6,1,1,5},  11,  MatrixControlOwner, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,6,1,1,6},  11,  MatrixControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,6,2,1,1},  11,  MatrixSDSourceAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,6,2,1,2},  11,  MatrixSDDestAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,6,2,1,3},  11,  MatrixSDIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,2,1,4},  11,  MatrixSDPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,2,1,5},  11,  MatrixSDOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,2,1,6},  11,  MatrixSDErrors, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,1},  11,  MatrixDSSourceAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,2},  11,  MatrixDSDestAddress, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,3},  11,  MatrixDSIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,4},  11,  MatrixDSPkts, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,5},  11,  MatrixDSOctets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,6,3,1,6},  11,  MatrixDSErrors, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,7,1,1,1},  11,  filterIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,7,1,1,2},  11,  filterChannelIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,3},  11,  filterPktDataOffset, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,4},  11,  filterPktData, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,5},  11,  filterPktDataMask, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,6},  11,  filterPktDataNotMask, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,7},  11,  filterPktStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,8},  11,  filterPktStatusMask, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,9},  11,  filterPktStatusNotMask, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,10}, 11,  filterOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,1,1,11}, 11,  filterStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,1},  11,  bufferControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,1,1,2},  11,  bufferControlChannelIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,3},  11,  bufferControlFullStatus, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,1,1,4},  11,  bufferControlFullAction, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,5},  11,  bufferControlCaptureSliceSize, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,6},  11,  bufferControlDownloadSliceSize, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,7},  11,  bufferControlDownloadOffset, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,8},  11,  bufferControlMaxOctetsRequested, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,9},  11,  bufferControlMaxOctetsGranted, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,1,1,10}, 11,  bufferControlCapturedPackets, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,1,1,11}, 11,  bufferControlTurnOnTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,8,1,1,12}, 11,  bufferControlOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,1,1,13}, 11,  bufferControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,1},  11,  channelIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,7,2,1,2},  11,  channelIfIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,3},  11,  channelAcceptType, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,4},  11,  channelDataControl, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,5},  11,  channelTurnOnEventIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,6},  11,  channelTurnOffEventIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,7},  11,  channelEventIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,8},  11,  channelEventStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,9},  11,  channelMatches, SNMP_COUNTER, MIB_READ},
    { {1,3,6,1,2,1,16,7,2,1,10}, 11,  channelDescription, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,11}, 11,  channelOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,7,2,1,12}, 11,  channelStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,8,2,1,1},  11,  captureBufferControlIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,2},  11,  captureBufferIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,3},  11,  captureBufferPacketID, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,4},  11,  captureBufferPacketData, SNMP_OCTETSTR, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,5},  11,  captureBufferPacketLength, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,6},  11,  captureBufferPacketTime, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,8,2,1,7},  11,  captureBufferPacketStatus, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,9,1,1,1},  11,  EventIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,9,1,1,2},  11,  EventDescription, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,9,1,1,3},  11,  EventType, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,9,1,1,4},  11,  EventCommunity, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,9,1,1,5},  11,  EventLastTimeSent, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,9,1,1,6},  11,  EventOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,9,1,1,7},  11,  EventStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {1,3,6,1,2,1,16,9,2,1,1},  11,  EventLogEventIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,9,2,1,2},  11,  EventLogIndex, SNMP_INTEGER, MIB_READ},
    { {1,3,6,1,2,1,16,9,2,1,3},  11,  EventLogTime, SNMP_TIMETICKS, MIB_READ},
    { {1,3,6,1,2,1,16,9,2,1,4},  11,  EventLogDescription, SNMP_DISPLAYSTR, MIB_READ},
    { {BTNG_MIB,1,1,1,1}, BTNG_MIBLEN + 4,  infoIndex, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,1,1,1,2}, BTNG_MIBLEN + 4,  infoDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {BTNG_MIB,1,1,1,3}, BTNG_MIBLEN + 4,  infoLostPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,4}, BTNG_MIBLEN + 4,  infoPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,5}, BTNG_MIBLEN + 4,  infoDiscardedPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,6}, BTNG_MIBLEN + 4,  infoTruncatedPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,7}, BTNG_MIBLEN + 4,  infoBufferedPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,8}, BTNG_MIBLEN + 4,  infoStackedPkts, SNMP_COUNTER, MIB_READ},
    { {BTNG_MIB,1,1,1,9}, BTNG_MIBLEN + 4,  infoOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {BTNG_MIB,1,1,1,10}, BTNG_MIBLEN + 4, infoStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},

#ifdef PERFORMANCE_TEST
    { {BTNG_MIB,2,1}, BTNG_MIBLEN + 2,  PerfDataControl, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {BTNG_MIB,2,2}, BTNG_MIBLEN + 2,  PerfPkts, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,2,3}, BTNG_MIBLEN + 2,  PerfOctets, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,2,4}, BTNG_MIBLEN + 2,  PerfTimeTotal, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,2,5}, BTNG_MIBLEN + 2,  PerfTimeMax, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,2,6}, BTNG_MIBLEN + 2,  PerfTimeMin, SNMP_INTEGER, MIB_READ},
#endif

    { {BTNG_MIB,3,1}, BTNG_MIBLEN + 2,  memoryMax, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,3,2}, BTNG_MIBLEN + 2,  memoryChunk, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,3,3}, BTNG_MIBLEN + 2,  memoryUsed, SNMP_INTEGER, MIB_READ},
    { {BTNG_MIB,4,1}, BTNG_MIBLEN + 2,  RegisterBeholderMessage, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {BTNG_MIB,4,2}, BTNG_MIBLEN + 2,  RegisterBeholder, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},

#ifdef DNPAP_RMON_EXTENSIONS
    { {DNPAP_RMON_MIB,1,1,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,1,1,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsDropEvents, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsOctets, SNMP_COUNTER, MIB_READ}, 
    { {DNPAP_RMON_MIB,1,1,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsBroadcastPkts, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,7},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsMulticastPkts, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsCRCAlignErrors, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,9},  DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsUndersizePkts, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,10}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsOversizePkts, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,11}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsFragments, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,12}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsJabbers, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,13}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsCollisions, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,14}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts64Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,15}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts65to127Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,16}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts128to255Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,17}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts256to511Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,18}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts512to1023Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,19}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsPkts1024to1518Octets, SNMP_COUNTER, MIB_READ},
    { {DNPAP_RMON_MIB,1,1,1,20}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,1,1,1,21}, DNPAP_RMON_MIBLEN + 4,  DnpapEtherStatsStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},

    { {DNPAP_RMON_MIB,4,1,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,1,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,4,1,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlTableSize, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,1,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlLastDeleteTime, SNMP_TIMETICKS, MIB_READ},
    { {DNPAP_RMON_MIB,4,1,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlAcceptType, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,4,1,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlMatches, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,1,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapHostControlNrBuckets, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,4,1,1,10}, DNPAP_RMON_MIBLEN + 4,  DnpapHostControlInterval, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,4,1,1,11}, DNPAP_RMON_MIBLEN + 4,  DnpapHostControlOwner, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,4,1,1,12}, DNPAP_RMON_MIBLEN + 4,  DnpapHostControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},

    { {DNPAP_RMON_MIB,4,2,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapHostAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapHostCreationOrder, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapHostIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapHostInPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapHostOutPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapHostInOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,7},  DNPAP_RMON_MIBLEN + 4,  DnpapHostOutOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapHostOutErrors, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,9},  DNPAP_RMON_MIBLEN + 4,  DnpapHostOutBroadcastPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,2,1,10}, DNPAP_RMON_MIBLEN + 4,  DnpapHostOutMulticastPkts, SNMP_INTEGER, MIB_READ},

    { {DNPAP_RMON_MIB,4,3,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeCreationOrder, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeInPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeOutPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeInOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,7},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeOutOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeOutErrors, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,9},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeOutBroadcastPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,4,3,1,10}, DNPAP_RMON_MIBLEN + 4,  DnpapHostTimeOutMulticastPkts, SNMP_INTEGER, MIB_READ},

    { {DNPAP_RMON_MIB,5,1,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNControlIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,5,1,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNHostIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,1,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNRateBase, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,1,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNTimeRemaining, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,1,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNDuration, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,5,1,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNRequestedSize, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,1,1,7},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNGrantedSize, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,5,1,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNStartTime, SNMP_TIMETICKS, MIB_READ},
    { {DNPAP_RMON_MIB,5,1,1,9},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,1,1,10}, DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,5,2,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNReport, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,5,2,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,5,2,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,5,2,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapHostTopNRate, SNMP_INTEGER, MIB_READ},

    { {DNPAP_RMON_MIB,6,1,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,1,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlDataSource, SNMP_OBJECTID, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,6,1,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlTableSize, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,1,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlLastDeleteTime, SNMP_TIMETICKS, MIB_READ},
    { {DNPAP_RMON_MIB,6,1,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlOwner, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,6,1,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixControlStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,6,2,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDSourceAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,6,2,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDDestAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,6,2,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,2,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,2,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,2,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixSDErrors, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSSourceAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSDestAddress, SNMP_OCTETSTR, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSPkts, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSOctets, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,6,3,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapMatrixDSErrors, SNMP_INTEGER, MIB_READ},

    { {DNPAP_RMON_MIB,7,1,1,1},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterIndex, SNMP_INTEGER, MIB_READ},
    { {DNPAP_RMON_MIB,7,1,1,2},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterChannelIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,3},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterHostIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,4},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterMatrixIndex, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,5},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktDataOffset, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,6},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktData, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,7},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktDataMask, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,8},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktDataNotMask, SNMP_OCTETSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,9},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,10},  DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktStatusMask, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,11}, DNPAP_RMON_MIBLEN + 4,  DnpapFilterPktStatusNotMask, SNMP_INTEGER, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,12}, DNPAP_RMON_MIBLEN + 4,  DnpapFilterOwner, SNMP_DISPLAYSTR, MIB_READ | MIB_WRITE},
    { {DNPAP_RMON_MIB,7,1,1,13}, DNPAP_RMON_MIBLEN + 4,  DnpapFilterStatus, SNMP_INTEGER, MIB_READ | MIB_WRITE},
#endif
};


static VOID BeholderSignalHandler(INT signum);



INT main(INT argc, char **argv)
{
    if (ConfigInit(argc, argv) == FALSE || ConfigLoad() == FALSE)
    {
        DnpapMessage(DMC_FATAL, BEHOLDER_CONFIGFAIL, "ConfigInit failed");
        DnpapExit(1);
    }

    MemoryInit(8000000L, 32000L);

    if (DnpapSignal(SIGINT, BeholderSignalHandler) == SIG_ERR)
        DnpapMessage(DMC_FATAL, BEHOLDER_SIGNALFAIL, "Signal handler initialization failed");
    
    MessageInit("stdio:out", MSGFILE, MSGSTDIO, NULL);
    MessageConfig(BEHOLDER_ERROR, "Beholder");
    
    MibInit(beholderPrf, beholderObj,
        sizeof(beholderPrf)/sizeof(beholderPrf[0]),
        sizeof(beholderObj)/sizeof(beholderObj[0]));

    if (!ProtInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_PROTFAIL,"ProtInit failed");
    
    if (!TimerInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_TIMERFAIL,"TimerInit failed");
    
    if (!SysInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_SYSFAIL,"SysInit failed");

    if (!AlarmMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_ALARMFAIL,"AlarmMInit failed");
    
    if (!MatrixMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_MATRIXFAIL,"MatrixMInit failed");
    
    if (!HostMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_HOSTFAIL,"HostMInit failed");
    
    if (!TopNMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_TOPNFAIL,"TopNMInit failed");
    
    if (!ChannelMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_CHANNELFAIL,"ChannelMInit failed");
    
    if (!CaptureMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_CAPTUREFAIL,"CaptureMInit failed");
    
    if (!FilterMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_FILTERFAIL,"FilterMInit failed");

    if (!EtherStatsMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_STATSFAIL,"EtherStatsMInit failed");
    
    if (!HistoryMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_HISTORYFAIL,"HistoryMInit failed");
    
    if (!InfoMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_INFOFAIL,"InfoMInit failed");

    if (!BlockInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_BLOCKFAIL,"BlockInit failed");

    if (!PipeInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_PIPEFAIL,"PipeInit failed");

    if (!SnorInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_SNORFAIL,"SnorInit failed");

    if (!LoopInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_LOOPFAIL,"LoopInit failed");
    
    if (!MacInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_MACFAIL,"MacInit failed");
    
    if (!ArpInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_ARPFAIL,"ArpInit failed");
    
    if (!IpInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_IPFAIL,"IpInit failed");
    
    if (!IcmpInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_ICMPFAIL,"IcmpInit failed");
    
    if (!UdpInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_UDPFAIL,"UdpInit failed");

    if (!EchoInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_ECHOFAIL,"EchoInit failed");

    if (!AgentInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_AGENTFAIL,"AgentInit failed");

    if (!EtherInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_ETHERFAIL,"EtherInit failed");
    
    if (!SoftInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_SOFTFAIL,"SoftInit failed");
    
    if (!GenInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_GENFAIL,"GenInit failed");
    
    if (!PerfInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_PERFFAIL,"PerfInit failed");
    
    if (!PerfMInit())   /*  MIB support initialization for perf  */
        DnpapMessage(DMC_WARNING,BEHOLDER_PERFMFAIL,"PerfMInit failed");
    
#ifdef DNPAP_RMON_EXTENSIONS
    if (!DnpapEtherStatsMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_DNPAPSTATSFAIL,"DnpapEtherStatsMInit failed");
    
    if (!DnpapFilterMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_DNPAPFILTERFAIL,"DnpapFilterMInit failed");

    if (!DnpapHostMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_DNPAPHOSTFAIL,"DnpapHostMInit failed");

    if (!DnpapTopNMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_DNPAPTOPNFAIL,"DnpapTopNMInit failed");
    
    if (!DnpapMatrixMInit())
        DnpapMessage(DMC_WARNING,BEHOLDER_DNPAPMATRIXFAIL,"DnpapMatrixMInit failed");
#endif

    if (ConfigGetString("beholder.trap.community", &trapcomm) == FALSE)
        trapcomm = "SNMP-trap";
    if (!AgentSendTrap(trapcomm, strlen(trapcomm), SNMP_TRAP_COLDSTART, 0, 0, 0))
        DnpapMessage(DMC_WARNING,BEHOLDER_TRAPFAIL,"Could not send COLDSTART trap");

    DnpapMessage(DMC_MESSAGE,BEHOLDER_ACTIVE,"Beholder TNG active !\n");

    if (!Block())
        DnpapMessage(DMC_WARNING,BEHOLDER_BLOCKERR,"Block");

    DnpapExit(0);

    return 0;
}


VOID BeholderSignalHandler(INT signum)
{
    DnpapExit(0);
}
