#define         INCL_BASE
#include        <os2.h>
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <time.h>
#include        <dnpap.h>
#include        <block.h>
#include        <config.h>
#include        "pipe.h"


#define     PIPE_BUFLEN                 1514
#define     PIPE_MAX_CLIENTS            5               /** max pipe instances  */
#define     PIPE_IN_SIZE                1024            /* input buffer         */
#define     PIPE_OUT_SIZE               1024            /* output buffer        */
#define     PIPE_WSIZE                  0x1fff          /* work buffer size     */
#define     PIPE_SSIZE                  8192            /* stack size           */
#define     PIPE_STATE_UNUSED           0
#define     PIPE_STATE_CONNECTED        1
#define     PIPE_STATE_DISCONNECTED     2
#define     PIPE_SEM                    "\\SEM\\PIPE0"



typedef struct _PIPE_TABLE PIPE_TABLE;

struct  _PIPE_TABLE
{
    int         state;              /* state of pipe instance       */
    unsigned    hdl;                /* pipe handle                  */
    char        *base;              /* base of write-data buffer    */
    char        *wbuf;              /* pending write date           */
    unsigned    num;                /* size of write                */
};



static void FAR Thread(void);
static BOOLEAN  Check(BLOCK *block);
static BOOLEAN  Receive(USHORT pipe, BYTE *data, USHORT length);



/* global data */
static BLOCK            pipeBlock;
static HSYSSEM          pipeSem;
static ULONG            pipeMySem = 0;
static PIPE_TABLE       pipeTable[PIPE_MAX_CLIENTS] = {0};
static char	            pipeName[64] = "\\pipe\\beholder\\161";
static TID              pipeTid;
static BYTE             *pipeStack = {0}; /* Thread Stack  */
static PIPE_DESCR       *pipeDescrList = 0;


/* eng */
static char             *pipeWBuf;
static char             *pipeInBuf;

#ifdef _DEBUG
#define DEBUGDUMP(x)    VioWrtTTY(x,strlen(x),(HVIO) NULL);
#endif





BOOLEAN PipeInit(void)
{
    SEL     Sel;
    USHORT  ret = 0;
    BYTE    *p;
    BOOLEAN success = FALSE;
    
    
    if (ConfigGetString("pipe.hostname", &p))
        sprintf(pipeName,"\\pipe\\%s\\161", p);
    
    /* allocate */
    pipeWBuf    = DnpapMalloc(PIPE_WSIZE);
    pipeInBuf   = DnpapMalloc(PIPE_BUFLEN);

    ret = DosAllocSeg(PIPE_SSIZE,&Sel,SEG_NONSHARED);
    if (ret==0)
    {
        pipeStack = MAKEP(Sel,0);
        memset(pipeStack,0,PIPE_SSIZE);

        /* create resources */
        ret = DosCreateSem(CSEM_PUBLIC,&pipeSem,PIPE_SEM);
        if (ret==0)
        {
            ret = DosSemSet(pipeSem);
            if (ret==0)
            {
                ret = DosCreateThread(Thread,&pipeTid,pipeStack+PIPE_SSIZE);
                if (ret==0)
                {
                    pipeBlock.hsem      = pipeSem;
                    pipeBlock.specific  = 0;
                    pipeBlock.Check     = Check;
                    if (BlockRegister(&pipeBlock))
                    {
                        success = TRUE;
                    }
                }
            }
        }
    }
    return success;
}

BOOLEAN PipeRegister(PIPE_DESCR *descr)
{
    descr->next = pipeDescrList;
    pipeDescrList = descr;
    return TRUE;
}




BOOLEAN PipeSend(USHORT pipe, BYTE *data, USHORT length)
{
    USHORT ret, n;
    
    ret = DosWrite(pipe, data, length, &n);
    return ((ret==0) && (n == length));
}




static BOOLEAN Check(BLOCK *block)
{
    struct  npss    *np;            /* work structure */
    PIPE_TABLE      *pt;            /* instance table */
    USHORT          hdl;                /* pipe handle */
    USHORT          num;
    USHORT          nrEvents;
    USHORT          ret;

    /* initialise semphore */

#ifdef  _DEBUG
    DEBUGDUMP("-->\n\r");
#endif

    
    ret = DosSemSet(pipeSem);
    if (ret!=0)
    {
        return FALSE;
    }
    
    nrEvents = 1;

    while ((nrEvents > 0))
    {
        /* check what reason is for interruption of peace */
        ret = DosQNmPipeSemState(
            pipeSem,
            (PPIPESEMSTATE) pipeWBuf,
            PIPE_WSIZE);
        if (ret !=0)
            return FALSE;

        np = (struct npss far *) pipeWBuf;
        nrEvents = 0;

        /* do for each reason-record */
        while (np->npss_status != NPSS_EOI)
        {
            pt = &pipeTable[np->npss_key];
            hdl = pt->hdl;
#ifdef _DEBUG
            putchar('0'+np->npss_status);
#endif
            switch (np->npss_status)
                {
                case NPSS_CLOSE:
#ifdef _DEBUG
                    DEBUGDUMP("NPSS_CLOSE\n\r");
#endif
                    /* disconnect and mark the state */
                    DosDisConnectNmPipe(hdl);
                    pipeTable[np->npss_key].state = PIPE_STATE_DISCONNECTED;
                    /* Notify the Connect Loop */
                    DosSemClear(&pipeMySem);
                    nrEvents++;
                    break;

                case NPSS_RDATA:
#ifdef _DEBUG
                    DEBUGDUMP("NPSS_RDATA\n\r");
#endif
                    /* read available data */
                    ret = DosRead(hdl,pipeInBuf,PIPE_BUFLEN,&num);
                    if (ret!=0)
                    {
                         return FALSE;
                    }
#ifndef _DEBUG
                    Receive(hdl, pipeInBuf, num);
#else
                    DEBUGDUMP("\n\r<");
                    VioWrtTTY(pipeInBuf,num,(HVIO) NULL);
                    DEBUGDUMP(">\n\r");
#endif
                    nrEvents++;
                    break;

                case NPSS_WSPACE:
#ifdef _DEBUG
                    DEBUGDUMP("NPSS_WSPACE\n\r");
#endif
                    /* empty WSPACE in message mode */
                    break;

                default:   
#ifdef _DEBUG
                    DEBUGDUMP("unknown NPSS_CLOSE\n\r");
#endif
                    break;
                }
            ++np;
            }
#ifdef  _DEBUG
    DEBUGDUMP("<--\n\r");
#endif
    }
    return TRUE;
}
 




static void FAR Thread(void)
{
    unsigned            hdl;
    int                 i;
    USHORT      ret;
    ret = 0;
    /* loop forever */
    while (ret == 0)
        {
        /* try to get a disconnected pipe instance */
        for (i=0; i<PIPE_MAX_CLIENTS;++i)
            {
            if (pipeTable[i].state == PIPE_STATE_DISCONNECTED)
                break;
            }
        if(i==PIPE_MAX_CLIENTS)
            {
            /* no disconnected pipe, create new one */
            for (i=0; i<PIPE_MAX_CLIENTS;i++)
                {
                if(pipeTable[i].hdl == 0)
                    {
                    ret |= DosMakeNmPipe(
                        pipeName,   /* name of pipe */
                        &hdl,             /* pointer to pipe handle */
                        NP_ACCESS_DUPLEX |  /* access mode */
                        NP_NOINHERIT |
                        NP_NOWRITEBEHIND,
                        NP_TYPE_MESSAGE |
                        PIPE_MAX_CLIENTS,        /* maximum number of pipes */
                        PIPE_IN_SIZE,            /* length input buffer */
                        PIPE_OUT_SIZE,           /* length output buffer */
                        0L);                /* timeout (ms) of DosWaitNmPipe */
#ifdef _DEBUG
                    if(ret!=0)
                        DEBUGDUMP("error in DosMakeNmPipe\n\r");
#endif
                    pipeTable[i].hdl = hdl;
                    break;
                    }
                }
            }
        /* if no instances available, wait for them */
        if (i == PIPE_MAX_CLIENTS)
            {
            DosSemSetWait(&pipeMySem,-1L);  /* Set and wait until it is cleared! */
            continue;                       /* start of loop please */
            }
	    
	    /* connect the pipeSem semaphore to the created named pipe
	       so that the main routine can check that semaphore
	       for any arriving data
	    */
        /* Eigenlijk alleen doen als deze echt net 'geconnect' is */
        ret |= DosSetNmPipeSem(pipeTable[i].hdl,pipeSem,i); 
#ifdef _DEBUG
                    if(ret!=0)
                        DEBUGDUMP("error in DosSetNmPipeSem\n\r");
#endif
	  
	/* wait for a client to connect to the current free pipe */
        ret |= DosConnectNmPipe(pipeTable[i].hdl);
#ifdef _DEBUG
                    if(ret!=0)
                        DEBUGDUMP("error in DosConnectNmPipe\n\r");
#endif
        pipeTable[i].state = PIPE_STATE_CONNECTED;
        }
}




static BOOLEAN Receive(USHORT pipe, BYTE *data, USHORT length)
{
    BOOLEAN     success = TRUE;
    PIPE_DESCR  *descr;
    
    for (descr=pipeDescrList; descr!=0; descr=descr->next)
        success = success && descr->Rcve(descr, pipe, data, length);
    
    return success;
}







/**************************************************************
** NAME:        main
** SYNOPSIS:    int main(int argc, char **argv);
** DESCRIPTION: driver routine server <namepipe> application
**              should be called as argv[1] = <name pipe name>
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
#ifdef _DEBUG
int main(int argc, char **argv)
{
    int iRet;
	PipeInit("\\pipe\\nptest");
    while(1)
    {
#ifdef  _DEBUG
    DEBUGDUMP("**>\n\r");
#endif
        iRet = DosSemWait(pipeSem,SEM_INDEFINITE_WAIT);
#ifdef  _DEBUG
    DEBUGDUMP("<**\n\r");
#endif
        if(iRet != 0)
        {
            DEBUGDUMP("error in DosSemWait\n\r");
            return(0);
        }
	    while(PipeCheck() > 0)
	    {
	    };
        /* DosSemSet(pipeSem); */
    }
	return 0;
}
#endif
