#include <memory.h>
#include "chain.h"



WORD ChainAvailSpace(CHAIN *chain)
{
    return chain->offset;
}


WORD ChainAvailData(CHAIN *chain)
{
    return chain->length;
}

WORD ChainLength(CHAIN *chain)
{
    WORD        n=0;
    CHAIN       *p;

    for (p=chain; p!=0; p=p->next)
        n += p->length;

    return n;
}

WORD ChainSize(CHAIN *chain)
{
    WORD        n=0;
    CHAIN       *p;

    for (p=chain; p!=0; p=p->next)
        n += p->size;

    return n;
}





BYTE *ChainPush(CHAIN **chain, WORD size)
{
    CHAIN   *p;

    p = *chain;
    if (p==0 || p->offset < size)
    {
        p= DnpapMalloc(sizeof(CHAIN));
        if (p == 0)
            return 0;
        p->buffer = DnpapMalloc(size);
        if (p->buffer == 0)
            return 0;
        p->size   = size;
        p->length = size;
        p->offset = 0;
        p->flags  = CHAIN_FLAG_DNPAP_BUFFER | CHAIN_FLAG_DNPAP_CHAIN;
        p->next   = *chain;
        *chain    = p;
    }
    else
    {
        p->length += size;
        p->offset -= size;
    }

    return (p->buffer + p->offset);
}





BYTE *ChainPop(CHAIN **chain, WORD size)
{
    CHAIN   *p;
    
    p = *chain;
    if (p==0)
        return 0;
    
    if (p->length < size)
    {
        return 0;
    }
    else
    {
        p->length -= size;
        p->offset += size;
    }
    return (p->buffer + p->offset - size);
}




CHAIN *ChainAlloc(CHAIN *chain, BYTE *buffer, WORD size, WORD length, WORD offset, CHAIN *next)
{
    if (chain == 0)
    {
        chain = DnpapMalloc(sizeof(CHAIN));
        if (chain == 0)
            return 0;
        chain->flags = CHAIN_FLAG_DNPAP_CHAIN;
    }
    if (buffer == 0)
    {
        buffer = DnpapMalloc(size);
        if (buffer == 0)
            return 0;
        chain->flags |= CHAIN_FLAG_DNPAP_BUFFER;
    }
    
    chain->buffer   = buffer;
    chain->size     = size;
    chain->length   = length;
    chain->offset   = offset;
    chain->next     = next;
    
    return chain;
}

void ChainFree(CHAIN *chain)
{
   if (chain->flags & CHAIN_FLAG_DNPAP_BUFFER)
       DnpapFree(chain->buffer);
   if (chain->flags & CHAIN_FLAG_DNPAP_CHAIN)
       DnpapFree(chain);
}

BOOLEAN ChainCopy(CHAIN *chain, BYTE *buffer, WORD size)
{
    if (ChainLength(chain) > size)
        return FALSE;
    
    while (chain!=0)
    {
        memcpy(buffer, chain->buffer + chain->offset, chain->length);
        buffer += chain->length;
        chain = chain->next;
    }
    return TRUE;
}


BOOLEAN ChainSplit(CHAIN *head, CHAIN *tail, WORD length)
{
    CHAIN *p;

    if (head==0 || tail==0)
        return FALSE;
    
    p = head;
    while (p != 0 && length > p->length)
    {
        length -= p->length;
        p       = p->next;
    }

    if (p==0)
    {
        tail->buffer = 0;
        tail->size   = 0;
        tail->offset = 0;
        tail->length = 0;
        return FALSE;
    }
    else
    {
        tail->next   = p->next;
        tail->buffer = p->buffer;
        tail->size   = p->size;
        tail->offset = p->offset + length;
        tail->length = p->length - length;
        head->length = length;
        return TRUE;
    }
}


               




