#include "snordef.h"
#include "snorhdl.h"
#include "snorrqs.h"
#include "snorevt.h"
#include "snorsem.h"




static int Compare(SNOR_DESCR *snor, PEVENT event, USHORT type, USHORT extra);



PEVENT SnorEvtGet(SNOR_DESCR *snor)
{
    if (snor->tx->usRecsAvail==0)
        return 0;
    return snor->event;
}

void SnorEvtFree(SNOR_DESCR *snor)
{
    TXSEG *tx;
    
    switch ( snor->event->usEventType )
	{
		case EVENT_GENREQ:
			SnorRqsFreeGeneral(snor, snor->event->usHandle);
			break;
		case EVENT_SEND:
			SnorRqsFreeSend(snor, snor->event->usHandle);
			break;
		case EVENT_GET_CONFIG:
		case EVENT_MAX_LEN:
		case EVENT_TYPE_LEN:
		case EVENT_STATUS:
		case EVENT_FRAME:
		case EVENT_LOST_FRAMES:
			break;
	}
    tx=snor->tx;

      
    /******************* WARNING ************************* 
    * The following lines may generate a race condition! *
    * The decrement and compare of usRecsAvail should be *
    * an atomic operation!                               *
    *****************************************************/
    
    snor->event = snor->event->pxNextEvent;
    if (--tx->usRecsAvail==0)
        snor->event = tx->pxFirst;
}


void SnorEvtWait(SNOR_DESCR *snor, USHORT type, USHORT extra)
{
	PEVENT event;

    while (1)
    {
        event=SnorEvtGet(snor);
        if (event==0)
            continue;
        if (Compare(snor, event, type, extra))
 			break;
 		SnorEvtFree(snor);
    }
}


void SnorEvtFlush(SNOR_DESCR *snor)
{
    SnorSemSet(snor);
    snor->tx->usRecsAvail=0;
    snor->event = snor->tx->pxFirst;
}



static int	Compare(SNOR_DESCR *snor, PEVENT event, USHORT type, USHORT extra)
{      
	int	ret = 0;

	if ( event->usEventType == type )
	{
		switch ( type )
		{
			case EVENT_GENREQ:
				if ( extra != 0 )
				{
					SNOR_MH	*msg;

					msg = SnorHdl2Ptr(snor, event->usHandle);
					if ( msg->usMem1 == extra )
						ret = 1;
			   	}
				else
					ret = 1;
				break;
			case EVENT_STATUS:
				if ( event->usRet1 == extra )
					ret = 1;
				break;
			case EVENT_SEND:
			default:
				ret = 1;
				break;
			}
		}
	return(ret);
}



