#include "snordef.h"
#include "snorevt.h"
#include "snorrqs.h"
#include "snordev.h"
#include "snorerr.h"
#include "snorkel.h"



BOOLEAN SnorKelOpen(SNOR_DESCR *snor, BYTE *name, BOOLEAN close)
{
	if ( (snor->device=SnorDevOpen(name)) == 0xffff )
	{
        SnorErrPrint("Can not open device %s",name);
        return FALSE;
	}

	if ( SnorRqsGive(snor) != 0 )
	{
        SnorErrPrint("Device error");
        return FALSE;
	}

    SnorEvtFlush(snor);
    
    if (SnorRqsConfig(snor) != 0)
    {
        SnorErrPrint("Config error");
        return FALSE;
    }

	
	if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<3)) == 0 )
	{
        SnorErrPrint("No promiscuous mode available");
        return FALSE;
	}

	
    if (close)
	{
		/* Stop packet reception; Wait until completed */
		/* before issuing the ResetMAC, otherwise it   */
		/* will be cancelled.                          */
		SnorRqsSetPacketFilter(snor,0);

		SnorEvtWait(snor, EVENT_GENREQ, SetPacketFilter);

		SnorRqsConfig(snor);

		if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<11)) != 0
			&& (snor->tabs.msss->msss_status & (1<<4)) != 0)
		{
			/* Open/Close Adapter supported AND adapter is open */
			SnorRqsCloseAdapter(snor);
			SnorEvtWait(snor, EVENT_GENREQ, CloseAdapter);
		}
    }

	/* Now prepare MAC with ResetMAC, OpenAdapter */
	if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<10)) != 0 )
	{
		/* ResetMAC supported */
		SnorRqsResetMAC(snor);
		if ( snor->tabs.cct->cct_maj_ndis >= '\x2')
			SnorEvtWait(snor, EVENT_STATUS, EndReset);
		else
			SnorEvtWait(snor, EVENT_STATUS, StartReset);

		SnorRqsMotor(snor);
	}

	SnorRqsConfig(snor);

	if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<11)) != 0
		&& (snor->tabs.msss->msss_status & (1<<4)) == 0)
	{
		/* Open/Close Adapter supported AND adapter is not open */
		SnorRqsOpenAdapter(snor,0);
		SnorEvtWait(snor, EVENT_GENREQ, OpenAdapter);
		SnorRqsMotor(snor);
	}

	SnorRqsMotor(snor);
	
    SnorRqsSetPacketFilter(snor,7);

	return TRUE;
}

BOOLEAN	SnorKelClose(SNOR_DESCR *snor)
{
	/* Stop receiving frames.... */

    SnorEvtFlush(snor);
	
    SnorRqsSetPacketFilter(snor,0);
	
    SnorEvtWait(snor, EVENT_GENREQ, SetPacketFilter);

	SnorRqsConfig(snor);

	if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<11)) != 0
		&& (snor->tabs.msss->msss_status & (1<<4)) != 0)
	{
		/* Open/Close Adapter supported AND adapter is open */
		SnorRqsCloseAdapter(snor);
		SnorEvtWait(snor, EVENT_GENREQ, CloseAdapter);
	}

	if ( (snor->tabs.mssc->mssc_Serv_flags & (1<<10)) != 0 )
	{
		/* ResetMAC supported */
		SnorRqsResetMAC(snor);

		if ( snor->tabs.cct->cct_maj_ndis >= '\x2')
			SnorEvtWait(snor, EVENT_STATUS, EndReset);
		else
			SnorEvtWait(snor, EVENT_STATUS, StartReset);
	}

	SnorRqsMotor(snor);

	SnorDevClose(snor->device);
	
    return TRUE;
}















































































