#include <memory.h>
#include "snordef.h"
#include "snorerr.h"
#include "snorseg.h"


BOOLEAN SnorSegMalloc(SNOR_DESCR *snor, USHORT count)
{
	USHORT	i;
	USHORT	ret = 0;

	for (i=0; i<count; i++)
	{
		if ((ret=DosAllocSeg(0, snor->sel+i, SEG_NONSHARED)) != 0 )
		{
			SnorErrPrint("DosAllocSeg fail for segment %d, rc: %u",i,ret);
            snor->selCount = i;
			if ( snor->selCount >= 1 )
				SnorSegFree(snor);
            return FALSE;
		}
	}
    snor->selCount=count;
	for (i=0 ;i<snor->selCount; i++)                
		memset(MAKEP(snor->sel[i],0), i, 0xfffe);       
	return TRUE;
}







void SnorSegFree(SNOR_DESCR *snor)
{
	USHORT  i;
	USHORT	ret;

	for (i=0; i<snor->selCount; i++)
	{
		if (snor->sel[i] != 0 )
		{
			if ( (ret=DosFreeSeg(snor->sel[i])) != 0 )
				SnorErrPrint("DosFreeSeg fail for segment %d, rc: %u",i,ret);
			snor->sel[i] = 0;
		}
	}
    snor->selCount = 0;
}
