#include "snordef.h"
#include "snorerr.h"
#include "snorsub.h"


USHORT	SnorSubInit(SNOR_DESCR *snor)
{
	USHORT	ret;

	if ( (ret=DosSubSet(snor->sel[0], 0x1, 0)) != 0 )
	{
		SnorErrPrint("DosSnorSubSet failed %d", ret);
	}
	return(ret);
}

PVOID	SnorSubMalloc(SNOR_DESCR *snor, USHORT size)
{
	USHORT	ret;
	USHORT	offset;
	SEL	sel;

	size += 4;
	sel = snor->sel[0];
    if ( (ret=DosSubAlloc(sel, &offset, size)) != 0 )
	{
		SnorErrPrint("DosSubAlloc failed %d", ret);
		offset = sel = 0;
	}
	else
	{
		*(PUSHORT)(MAKEP(sel, offset)) = size;
		offset += 4;
	}
	return(MAKEP(sel, offset));
}


VOID SnorSubFree(SNOR_DESCR *snor, PVOID p)
{
	USHORT	ret;
	USHORT	offset;
	USHORT	size;

	if ( SELECTOROF(p) != snor->sel[0] )
		SnorErrPrint("Invalid selector in SnorSubFree");
	else
	{
		size = ((PUSHORT)p)[-2];
		offset = OFFSETOF(p)-4;

		if ( (ret=DosSubFree(snor->sel[0], offset, size)) != 0 )
			SnorErrPrint("DosSnorSubFree failed %d", ret);
	}
}

