#ifndef _CONFIG_H_
#define _CONFIG_H_


#include <dnpap.h>


/***********************
* High Level Interface *
***********************/

BOOLEAN ConfigInit(int argc, char **argv);

BOOLEAN ConfigLoad(VOID);
BOOLEAN ConfigSave(VOID);

BOOLEAN ConfigSetBoolean(BYTE *name, BOOLEAN b);
BOOLEAN ConfigGetBoolean(BYTE *name, BOOLEAN *b);

BOOLEAN ConfigSetShort(BYTE *name, SHORT s);
BOOLEAN ConfigGetShort(BYTE *name, SHORT *s);

BOOLEAN ConfigSetLong(BYTE *name, LONG l);
BOOLEAN ConfigGetLong(BYTE *name, LONG *l);

BOOLEAN ConfigSetIPAddr(BYTE *name, IPADDR a);
BOOLEAN ConfigGetIPAddr(BYTE *name, IPADDR *a);

BOOLEAN ConfigSetDouble(BYTE *name, DOUBLE d);
BOOLEAN ConfigGetDouble(BYTE *name, DOUBLE *d);

BOOLEAN ConfigSetString(BYTE *name, CHAR *s);
BOOLEAN ConfigGetString(BYTE *name, CHAR **s);

BOOLEAN ConfigSetBytes(BYTE *name, BYTE *b, USHORT n);
BOOLEAN ConfigGetBytes(BYTE *name, BYTE **b, USHORT *n);

BOOLEAN ConfigSetLongBuf(BYTE *name, LONG *b, USHORT n);
BOOLEAN ConfigGetLongBuf(BYTE *name, LONG **b, USHORT *n);


/**********************
* Low Level Interface *
**********************/

#define CONFIG_TYPE_NULL      0
#define CONFIG_TYPE_SHORT     1
#define CONFIG_TYPE_LONG      2
#define CONFIG_TYPE_DOUBLE    3
#define CONFIG_TYPE_STRING    4
#define CONFIG_TYPE_BYTES     5
#define CONFIG_TYPE_LONGBUF   6
#define CONFIG_TYPE_BOOLEAN   7
#define CONFIG_TYPE_IPADDR    8


typedef struct _CONFIG_ENTRY CONFIG_ENTRY;
typedef struct _CONFIG_BYTES CONFIG_BYTES;
typedef struct _CONFIG_LONGBUF CONFIG_LONGBUF;
typedef union  _CONFIG_VALUE CONFIG_VALUE;


BOOLEAN         ConfigFlush(VOID);

BOOLEAN         ConfigRead (CHAR *file, USHORT level);
BOOLEAN         ConfigWrite(CHAR *file, USHORT level);

CONFIG_ENTRY    *ConfigCreate(BYTE *name);
CONFIG_ENTRY    *ConfigFind(BYTE *name);

CONFIG_ENTRY    *ConfigFirst(VOID);
CONFIG_ENTRY    *ConfigNext(CONFIG_ENTRY *e);


BOOLEAN ConfigGetName(CONFIG_ENTRY *e, BYTE **name);
BOOLEAN ConfigGetType(CONFIG_ENTRY *e, USHORT *type);
BOOLEAN ConfigGetLevel(CONFIG_ENTRY *e, USHORT *level);
BOOLEAN ConfigSetLevel(CONFIG_ENTRY *e, USHORT level);

BOOLEAN ConfigClear(CONFIG_ENTRY *e);


/******************************
* Support for different types *
******************************/

struct _CONFIG_BYTES
{
    USHORT  size;
    BYTE    *buffer;
};

struct _CONFIG_LONGBUF
{
    USHORT  size;
    LONG    *buffer;
};

union  _CONFIG_VALUE 
{
    BOOLEAN         Boolean;
    SHORT           Short;
    LONG            Long;
    IPADDR          IPAddr;
    DOUBLE          Double;
    CHAR            *String;
    CONFIG_BYTES    Bytes;    
    CONFIG_LONGBUF  LongBuf;
};

struct _CONFIG_ENTRY
{
    BYTE            *name;
    USHORT          level;
    USHORT          type;
    CONFIG_VALUE    value;
    CONFIG_ENTRY    *next;
    CONFIG_ENTRY    *nextHash;
};
    
BOOLEAN ConfigSetValueBoolean(CONFIG_ENTRY *e, BOOLEAN b);
BOOLEAN ConfigGetValueBoolean(CONFIG_ENTRY *e, BOOLEAN *b);
BOOLEAN ConfigDelValueBoolean(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueShort(CONFIG_ENTRY *e, SHORT s);
BOOLEAN ConfigGetValueShort(CONFIG_ENTRY *e, SHORT *s);
BOOLEAN ConfigDelValueShort(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueLong(CONFIG_ENTRY *e, LONG l);
BOOLEAN ConfigGetValueLong(CONFIG_ENTRY *e, LONG *l);
BOOLEAN ConfigDelValueLong(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueIPAddr(CONFIG_ENTRY *e, IPADDR a);
BOOLEAN ConfigGetValueIPAddr(CONFIG_ENTRY *e, IPADDR *a);
BOOLEAN ConfigDelValueIPAddr(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueDouble(CONFIG_ENTRY *e, DOUBLE d);
BOOLEAN ConfigGetValueDouble(CONFIG_ENTRY *e, DOUBLE *d);
BOOLEAN ConfigDelValueDouble(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueString(CONFIG_ENTRY *e, CHAR *s);
BOOLEAN ConfigGetValueString(CONFIG_ENTRY *e, CHAR **s);
BOOLEAN ConfigDelValueString(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueBytes(CONFIG_ENTRY *e, BYTE *b, USHORT n);
BOOLEAN ConfigGetValueBytes(CONFIG_ENTRY *e, BYTE **b, USHORT *n);
BOOLEAN ConfigDelValueBytes(CONFIG_ENTRY *e);

BOOLEAN ConfigSetValueLongBuf(CONFIG_ENTRY *e, LONG *b, USHORT n);
BOOLEAN ConfigGetValueLongBuf(CONFIG_ENTRY *e, LONG **b, USHORT *n);
BOOLEAN ConfigDelValueLongBuf(CONFIG_ENTRY *e);


#endif
