#ifndef _ENTRY_H_
#define _ENTRY_H_


#define TYPE_NULL   0
#define TYPE_SHORT  1
#define TYPE_LONG   2
#define TYPE_DOUBLE 3
#define TYPE_STRING 4
#define TYPE_BYTES  5
#define TYPE_BITS   6


typedef struct _ENTRY           ENTRY;
typedef struct _ENTRY_BYTES     ENTRY_BYTES;
typedef struct _ENTRY_BITS      ENTRY_BITS;

struct _ENTRY
{
    BYTE        *name;
    SHORT       type;
    SHORT       level;
    ENTRY_VALUE value;
    ENTRY       *next;
    ENTRY       *nextHash;
};

struct _ENTRY_BYTES
{
    short       count;          /* in bytes */
    char        buffer[1];
};

struct _ENTRY_BITS
{
    short       count;          /* int bits */
    char        buffer[1];
};


union _ENTRY_VALUE
{
    short           Short;
    LONG            Long;
    double          Double;
    char            *String;
    ENTRY_BYTES     *Bytes;
    ENTRY_BITS      *Bits;
}



void     EntryInit(void);
void     EntryFlush(void);
ENTRY    *EntrySet(USHORT level, BYTE *name, USHORT type, ENTRY_VALUE *value);
void     EntryRemove(BYTE *name);
ENTRY    *EntryFind(BYTE *name);
ENTRY    *EntryFirst(void);
ENTRY    *EntryNext(ENTRY *e);
USHORT   EntryValue(

#endif
