/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       MIB.H
**     SYSTEM   NAME:       Sage
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       
**
** DESCRIPTION: global include file for the MIB handling system of
**              the Sage environment.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision$
** WORKFILE:    $Workfile$
** LOGINFO:     $Log$
*************************************************************************/
#include  "mibdf.h"
#include  <stdio.h>
#include  <dnpap.h>

/* defines */
#define MIBHASHSIZE   67

typedef struct _mibNode MIBNODE;
typedef struct _mibHash MIBHASH;

/* MIB Types */

struct _mibHash
{
    MIBHASH * next;
    MIBNODE * contents;
};

struct _mibNode
{
    const char *name;
    MIBNODE * father;
    MIBNODE * brother;
    MIBNODE * child1;
    LONG index;
    WORD type;
    WORD mode;
    WORD status;
};

/* internal MIB api */

void  MibInitialise(void);
int  MibNameHash(const char  *name);
void  MibAddHash(const char  *name,MIBNODE *ptr);
MIBNODE *MibResolveHash(const char  *name);
MIBNODE *MibFindChild(MIBNODE *fPtr,const LONG  index);
MIBNODE *MibFindNode(const char  *name);
int  MibAddNode(MIBNODE *node,MIBNODE *fnode);
int  MibFillID(MIBNODE *node,LONG  *id);
MIBNODE *MibFindID(const LONG  *id,const int  nr);
MIBNODE *MibFindID2(const LONG  *id,const int  nr,int  *nrmatched);
void  MibDumpTree(const MIBNODE *first);
void  MibDumpHash(void);
int  main(int  argc,char  * *argv);
void  DumpTree(const char  *name);
MIBNODE *MibCreateNode(const char  *name,char  *position);
MIBNODE *MibScanLine(char  *line);
int  MibFindChunks(char  *line,char  * *chunks,int  *clens);
int  MibDecodeType(char  *type);
int  MibDecodeMode(char  *mode);
int  MibDecodeStatus(char  *status);
char  *MibEncodeStatus(int  status);
char  *MibEncodeMode(int  mode);
char  *MibEncodeType(int  type);


