/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       neus.h
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Paul Lemmers
**     VERSION  NUMBER:     
**     CREATION DATE:       1991/11/10
**
** DESCRIPTION: Definitions of structures and macros for NEUS driver.
**              This file contains all the common definitions for the
**              driver and the ring 3 application
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.2  $
** WORKFILE:    $Workfile:   neus.h  $
** LOGINFO:     $Log:   D:/CPROG/NDIS/NEUS/VCS/NEUS.H_V  $
**              
**                 Rev 1.2   20 Sep 1992 21:28:18   PAUL
**              DevHelp_SemHandle addition
**              
**                 Rev 1.1   05 Mar 1992 13:36:12   PAUL
**              MULTI_SEND structure and #defines
**              
**                 Rev 1.0   17 Feb 1992 18:08:00   PAUL
**              Initial revision.
*************************************************************************/

#define	NEUS_CATEGORY       0x83        /* .....invented..... */

typedef struct _iocparm {
	unsigned short	usSub;
	unsigned short	usHandle;
	unsigned short	usDatLen;
	unsigned short	usParam1;
	unsigned long	ulParam2;
	unsigned char	abData[16];
	} IOCPARM;

/* NEUS IOCtl function codes */
#define FUNCTION_MASK       0x40
#define	NEUS_MOTOR          (FUNCTION_MASK)
#define	NEUS_GIVE           (1 | FUNCTION_MASK)
#define	NEUS_GET_CONFIG     (2 | FUNCTION_MASK)
#define	NEUS_MAX_LEN        (3 | FUNCTION_MASK)
#define	NEUS_TYPE_LEN       (4 | FUNCTION_MASK)
#define	NEUS_GENREQ         (5 | FUNCTION_MASK)
#define	NEUS_SEND           (6 | FUNCTION_MASK)
#define	NEUS_MULTI_SEND     (7 | FUNCTION_MASK)
#define	NEUS_HIGHRES_TIME   (10 | FUNCTION_MASK)

/* NEUS IOCtl error codes (returned DosIOCtl as 0xFFxx) */
#define	NER_NO_GIVE         0x81
#define	NER_TOO_MANY        0x82
#define	NER_INVALID_PARM    0x83
#define NER_INVALID_TXSEG   0x84
#define NER_INVALID_RXSEG   0x85
#define NER_TOO_MANY_RXSEG  0x86
#define	NER_DUP_GIVE        0x87
#define NER_INVALID_SEG     0x88
#define NER_OUT_OF_MEM      0x89
#define NER_NOT_BOUND       0x8A
#define NER_NO_TIMER        0x8B
#define NER_INVALID_SEM     0x8C

typedef struct _EVENT far *PEVENT;
typedef struct _EVENT {
	PEVENT          pxNextEvent;
	unsigned short	usEventType;
	unsigned short	usHandle;
	unsigned short	usRet1;
	unsigned short	usRet2;
	unsigned long	ulTime;
	unsigned char	abData[16];
	};

/* NEUS Event Types */
#define EVENT_GET_CONFIG    2
#define EVENT_MAX_LEN       3
#define EVENT_TYPE_LEN      4
#define EVENT_GENREQ        5
#define EVENT_SEND          6
#define	EVENT_MULTI_SEND    7
#define EVENT_STATUS        10
#define EVENT_FRAME         11
#define EVENT_LOST_FRAMES   12
#define EVENT_DUMMY         13


typedef struct _txseg {
	PEVENT		pxFirst;	/* pointer to first event; only valid
					   when sem released!! */
	unsigned long	semRecsAvail;	/* RAM sem, if RAM sem requested */
	void _far      *hsemRing0;      /* Semaphore handle; Prepared by 3 */
					/* but after NEUS_GIVE it may not be */
					/* touched by ring 3! NULL for RAM */
					/* semaphore, HSYSSEM otherwise. */
	void _far      *hsemRing3;      /* Semaphore handle; Prepared by 3 */
					/* Never used by ring 0! Must be */
					/* &semRecsAvail for RAM sem. Or */
					/* HSYSSEM if system semaphore, */
					/* THEN hsemRing0 must be initialized */
					/* to hsemRing3 */
	unsigned short	usRecsAvail;	/* # of event records available */
	unsigned short	usTxSize;	/* Size of this Tx segment (0=64K) */
	unsigned short  usRcvSegCnt;	/* # of Rcv segments */
	unsigned short  awRcvSels[4];	/* array with Rcv selectors (>= 4) */
	} TXSEG;

typedef TXSEG _far *PTXSEG;

typedef struct _msend {
	unsigned short	usLen;       /* Frame length */
	unsigned short	usOffs;      /* Offset in frame for sequence # */
	unsigned short	usWindow;    /* Simultaneous send window size */
	unsigned short	usCnt;       /* Total number of frames to send */
	unsigned short	usDescOffs;  /* Offset between frame and desc. */
	unsigned short	usRes;       /* reserved */
	unsigned long	ulTime1;     /* Just before first send */
	unsigned long	ulTime2;     /* Return to kernel */
	unsigned long	ulTime3;     /* Last completion */
	/* Although not in structure definition, an array of   */
	/* usWindow ring 3 far pointers to frames follows here */
	} MSEND;
