package collector;
#**********************************************************************
#* NAME:	collector.pl
#* Description:	This module contains the subroutines
#*		to start and end collectors in an RMON node.
#*		It requires the spook.pl.
#**********************************************************************

@collector_list = ();
 
sub collector'collector_list_tbl
{
	local($i,$j,@repl) = @_;
	push(@collector_list,($repl[1]));	# remember index
}
#**********************************************************************
#* Name:	list_collectors
#* Synopsis:	list list_collectors(int connNr, char *collName);
#
#* Description:	This fuction return a list of the active
#*		collectors of the type <collName> on <connNr>.
#* Returns:	list of integers
#**********************************************************************
sub main'list_collectors
{
	local($nr,$varName) = @_;
	local($res,$varStat );
					     
	$varStat = $varName . "Status\[\]";
       	@collector_list = ();
	&main'snmp_tbl($nr,collector'collector_list_tbl,$varStat);
	return @collector_list;
}
sub collector'get_new_collector_number
{
	local($i,$varName) = @_;
	local($lst);
	@lst = &main'list_collectors($i,$varName);
	if( @lst < 1)
	{
	 	return 1;
	}
	else
	{
	  	return $collector_list[@lst - 1]+1;
	}
}
#**********************************************************************
#* Name:	create_new_collector
#* Synopsis:	int create_new_collector(
#*			int connNr, 
#*			char *collName
#*			char *ownerString
#*			fun  *iniFun);
#
#* Description:	This fuction creates a new collector of type <collName>
#*		on <connNr>. It also sets <ownerString>.
#*		The function <iniFun> will be called during
#*		creation time so that the caller can set
#*		some collector startup values. <iniFun> will
#*		be called as:
#*
#*			&$iniFun(in connNr,char*collName,int collNr);
#*
#* Returns:	number of new collector, 0 iff error
#**********************************************************************
sub main'create_new_collector
{
	local($i,$collName,$ownerString,$iniFun) = @_;
	local($nr,$res,$varStat , $varOwn);
	
					     
	$nr = &collector'get_new_collector_number($i,$collName);
	$varStat = $collName . "Status\[$nr\]";
	$varOwn = $collName . "Owner\[$nr\]";
	$res = &main'snmp_set($i,"$varStat=2");
	if($res != 2)
	{
		return 0;
	}
	$res = &main'snmp_get($i,$varStat);
	if($res != 3)
	{
		return 0;
	}
	$res = &main'snmp_set($i,"$varOwn=\"$ownerString\"");
	if( &$iniFun( $i, $collName, $nr ) == 0 )
	{
		return 0;
	}
	$res = &main'snmp_set($i,"$varStat=1");
	if($res != 1)
	{
		return 0;
	}
	return $nr;
}
#**********************************************************************
#* Name:	remove_collector
#* Synopsis:	int remove_collector(
#*			int connNr, 
#*			char *collName,
#*			int collNr;
#*			char *ownerString);
#
#* Description:	This fuction removes a collector of type <collName>,
#*		number <collNr>
#*		on <connNr>. It checks for <ownerString>.
#* Returns:	1 iff success, 0 iff error
#**********************************************************************
sub main'remove_collector
{
	local($nr,$collName,$collNr,$ownerString) = @_;
	local($res,$own,$varStat , $varOwn);
					     
	$res = $collName . "Status";
	$varStat = $collName . "Status\[$collNr\]";
	$varOwn = $collName . "Owner\[$collNr\]";
	
	$res = &main'snmp_get($nr,$varOwn);
	$own = "\"" . $ownerString . "\"";
	if( $res ne $own)
	{
		print "Ownerstring doesnt match ($res,$own)\n";
		return 0;
	}
	$res = &main'snmp_set($i,"$varStat=4");
	if($res != 4)
	{
		return 0;
	}
	return 1;
}
1;
