include ../../include/gcc_unx.std

SYS     = tricklet
SYSLIB  = tricklet

all: snmp-get snmp-nxt snmp-set snmp-tbl snmp-info stdspook

snmp-get: get.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-get get.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap
			  
snmp-nxt: next.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-nxt next.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap
			  
snmp-set: set.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-set set.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap
			  
snmp-tbl: table.o parse.o exec.o
	$(LN) $(CFLAGS) -o snmp-tbl table.o exec.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap

snmp-info: info.o parse.o
	$(LN) $(CFLAGS) -o snmp-info info.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap

stdspook: stdspook.o spook.o parse.o
	$(LN) $(CFLAGS) -o stdspook stdspook.o spook.o parse.o $(LDFLAGS)  -lmibdf -lmgmt -lsnmp -ldnpap

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) snmp-get
	- $(RM) snmp-nxt
	- $(RM) snmp-set
	- $(RM) snmp-tbl
	- $(RM) snmp-info
	- $(RM) stdspook
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak

install: $(BINDIR)/snmp-get $(BINDIR)/snmp-nxt $(BINDIR)/snmp-set $(BINDIR)/snmp-tbl $(BINDIR)/snmp-info $(BINDIR)/stdspook

$(BINDIR)/snmp-get: snmp-get
	$(CP) snmp-get $(BINDIR)/snmp-get

$(BINDIR)/snmp-nxt: snmp-nxt
	$(CP) snmp-nxt $(BINDIR)/snmp-nxt

$(BINDIR)/snmp-set: snmp-set
	$(CP) snmp-set $(BINDIR)/snmp-set

$(BINDIR)/snmp-tbl: snmp-tbl
	$(CP) snmp-tbl $(BINDIR)/snmp-tbl
        
$(BINDIR)/snmp-info: snmp-info
	$(CP) snmp-info $(BINDIR)/snmp-info
        
$(BINDIR)/stdspook: stdspook
	$(CP) stdspook $(BINDIR)/stdspook
        

get.o: get.c  exec.h parse.h

next.o: next.c  exec.h parse.h

set.o: set.c  exec.h parse.h

info.o: info.c

table.o: table.c  exec.h parse.h

stdspook.o: stdspook.c  parse.h

spook.o: spook.c  parse.h

parse.o: parse.c parse.h

exec.o: exec.c exec.h 
