/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE	NAME:	    sppok.c
**     SYSTEM	NAME:	    tricklet
**     ORIGINAL AUTHOR(S):  Jan van Oorschot
**     VERSION	NUMBER:
**     CREATION DATE:
**
** DESCRIPTION: This module contains the main function of snmp_spk.
**		It implements a finit state machines which is fed
**		by input-lines from stdin. Replies are send through
**		stdout. On line of input result in on line of output.
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:	     $Log$
*************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <dnpap.h>
#include <snmp.h>
#include <mibdf.h>
#include <stdarg.h>
#include <dnpap.h>
#include <mgmt.h>
#include <config.h>
#include <ctype.h>
#include "exec.h"
#include "parse.h"
#include "spook.h"

int             SpookMessage(SPOOK_OBJ * spook, char *request, char *answer)
{
	int             ret = 0;
	/* first character determince command */
	switch (*request)
	{
	case '=':		/* define env. varaible */
		ret = SpookMacro(spook, request + 1, answer);
		break;
	case '?':		/* get an answer to the queued request */
		ret = SpookRequest(spook, answer);
		break;
	case '<':		/* initialise a get request */
		ret = SpookGet(spook, request+1, answer);
		break;
	case '>':		/* initialse a set request */
		ret = SpookSet(spook, request+1, answer);
		break;
	case '*':		/* initialise a tbl request */
		ret = SpookTbl(spook, request+1, answer);
		break;			       
	case '.':		/* close it up bartender */
		strcpy(answer, ".+");
		spook->quit = 1;
		break;
	case '$':		/* give info about stored ID */
		ret = SpookInfo(request+1,answer);
		break;
    case '[':       /* open connection */
		if((spook->handle = MgmtOpen(spook->host,spook->medium))==NULL)
        {
		    DnpapMessage(DMC_ERROR, TRICKLET_ERROR+1,
                "failed to MgmtOpen <%s[%d],%d>\n",
                spook->host,strlen(spook->host),spook->medium);
            strcpy(answer,"[-");
        }
        else
        {
            strcpy(answer,"[+");
        }
        break;
    case ']':       /* close connection */
        if(spook->handle!=NULL)
            MgmtClose(spook->handle);
        spook->handle=NULL;
        strcpy(answer,"]+");
        break;
	default:		/* unknown request */
		sprintf(answer, "%c- Unknown command", *request);
		break;
	}
	return ret;
}
static char    *SpookMacros[] =
{
	"host",
	"medium",
	"community",
	NULL
};

int             SpookMacro(SPOOK_OBJ * spook, char *request, char *answer)
{
	char           *ptr = request;
	char            macro[STRLEN];
	char            value[STRLEN];
	int             i, j;

	while (isspace(*ptr) && *ptr != '\0')
		ptr++;
	/* copy macro */
	i = 0;
	while (!isspace(*ptr) && *ptr != '\0')
	{
		macro[i++] = (char) tolower((int) (*ptr));
        ptr++;
	}
	while (isspace(*ptr) && *ptr != '\0')
		ptr++;

	if (*ptr == '\0')
	{
		/* not legal, should be two parts */
		sprintf(answer, "=- not a legal SPOOK macro definition");
		return 0;
	}
	macro[i] = '\0';
	i = 0;
	while (*ptr != '\n' && *ptr != '\0')
	{
		value[i++] = *ptr++;
	}
	value[i] = '\0';

	i = 0;
	while (SpookMacros[i] != NULL)
	{
		if (strcmp(SpookMacros[i], macro) == 0)
			break;
		i++;
	}
	if (SpookMacros[i] == NULL)
	{
		sprintf(answer, "=- not a known SPOOK macro %s", macro);
		return 0;
	}
	switch (i)
	{
	case 0:		/* host */
		j = 0;
		while (!isspace(value[j]) && value[j] != '\0')
		{
			spook->host[j] = value[j];
			j++;
		}
		spook->host[j]='\0';
		if(spook->handle!=NULL)
			MgmtClose(spook->handle);
		sprintf(answer,"=+ host = %s",spook->host);
		break;

	case 1:		/* medium */
		if (value[0] == 'u' || value[0] == 'U')
		{
			spook->medium = MGMT_TYPE_UDP;
		} else if (value[0] == 'p' || value[0] == 'P')
		{
			spook->medium = MGMT_TYPE_PIPE;
		} else
			spook->medium = MGMT_TYPE_DEFAULT;
		if(spook->handle!=NULL)
			MgmtClose(spook->handle);
		
		sprintf(answer,"=+ medium = %d",spook->medium);
		break;

	case 2:		/* community */
		j = 0;
		while (value[j]!='\r' && value[j] != '\n' && value[j] != '\0')
		{
			spook->comm[j] = value[j];
			j++;
		}
		spook->comm[j]='\0';			  
		spook->commLen = j;
		sprintf(answer, "=+ community = %s(%d)", spook->comm,spook->commLen);
		break;
	default:
		sprintf(answer, "=- weird programming bug <%s>", value);
	}

	return 0;
}

int             SpookGet(SPOOK_OBJ * spook, char *request, char *answer)
{
	/* prepare a get command */
        if(GetList(request, spook->list, LIST_SIZE, &(spook->listLen))<0)
	{
		sprintf(answer,"<- Couldn't parse <%s>",request);
		spook->have_list = 0;
		return 0;
	}
	spook->have_list = 1;
	spook->tag = SNMP_PDU_GET;
	spook->repeat = 0;
	sprintf(answer,"<+");
	return 0;
}

int             SpookSet(SPOOK_OBJ * spook, char *request, char *answer)
{
	/* prepare a set command */
        if(GetList(request, spook->list, LIST_SIZE, &(spook->listLen))<0)
	{
		sprintf(answer,">- Couldn't parse <%s>",request);
		spook->have_list = 0;
		return 0;
	}
	spook->have_list = 1;
	spook->tag = SNMP_PDU_SET;
	spook->repeat = 0;
	sprintf(answer,">+");
	return 0;
}

int             SpookTbl(SPOOK_OBJ * spook, char *request, char *answer)
{
	/* prepare a table command */
        if(GetList(request, spook->list, LIST_SIZE, &(spook->listLen))<0)
	{
		sprintf(answer,"*- Couldn't parse <%s>",request);
		spook->have_list = 0;
		return 0;
	}
	spook->tableLen=spook->list[0].IdLen;
	memcpy(spook->table,spook->list[0].Id,spook->tableLen*sizeof(spook->list[0].Id[0]));
	spook->have_list = 1;
	spook->tag = SNMP_PDU_NEXT;
	spook->repeat = 1;
	sprintf(answer,"*+");
	return 0;
}

int             SpookRequest(SPOOK_OBJ * spook, char *answer)
{				      

	WORD status,index;
	int r;
			    
	if(spook->handle == NULL)
	{
		sprintf(answer,"?- no connection");
		return 0;
	}
	
	if(!spook->have_list)
	{
		sprintf(answer,"?- no request pending");
		return 0;
	}
	
	if(!MgmtRequest(
		spook->handle,
		spook->comm,spook->commLen,
		spook->tag,
		spook->list,spook->listLen,
		&status,&index,
		spook->timeout,spook->retries))
	{
		sprintf(answer,"?- SNMP request failed");
		return 0;
	}
	
	if(spook->repeat)
	{
		if(memcmp(
			spook->table,
			spook->list[0].Id,
			spook->tableLen*sizeof(spook->list[0].Id[0]))!=0 ||
			status == SNMP_NOSUCHNAME)
		{
			spook->have_list = 0;
			sprintf(answer,"?.");
			return 0;
		}
	}
	
	if(status!=SNMP_NOERROR)
	{
		spook->have_list = 0;
		sprintf(answer,"?- SNMP error <%d> in variable <%d>",status,index);
		return 0;
	}		
	
	r = PutList(spook->list,spook->listLen,answer+2,STRLEN);
	if(r<0)
	{
		spook->have_list = 0;
		sprintf(answer,"?- Couldn't handle SNMP answer <%d>",r);
		return 0;
	}
	answer[r+1]='\0';
	answer[0]='?';
	answer[1]='+';
	return 0;
}

int             SpookInfo(char *request, char *answer)
{	    
	SNMP_OBJECT list[1];
	unsigned listLen;
	int ret;
	
	/* prepare a get command */
        if(GetList(request, list, 1, &listLen)<0)
	{
		sprintf(answer,"$- Couldn't parse <%s>",request);
		return 0;
	}
	strcpy(answer,"$+");
	ret = MibIDInfo(list[0].Id,list[0].IdLen-1,answer+2);
	if (ret != 0)
	{
		strcpy(answer,"$- couldn't get info");
	}
	return 0;
}

