#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dnpap.h>
#include <snmp.h>
#include "protocol.h"
#include "prot.h"

BYTE *protEthernetString[] =
{
    "DESTINATION_ADDRESS",
    "SOURCE_ADDRESS",
    "FRAME_TYPE"
};

BOOLEAN ProtEthernetHeader (PROT_PKT *Pkt)
{
    LWORD  Child;

    if (Pkt->DataLen < 14)
        return (FALSE);
    if ((Pkt->Frame = DnpapMalloc (sizeof(PROT_ETHERNET))) == NULL)
        return (FALSE);

    Pkt->Frame->Ethernet.DstAdr = Pkt->Ptr;
    Pkt->Frame->Ethernet.SrcAdr = Pkt->Ptr + 6;
    Pkt->Frame->Ethernet.Type = Pkt->Ptr + 12;
    Pkt->Frame->Ethernet.Data = Pkt->Ptr + 14;

    PROT_NETWORD (Child,Pkt->Frame->Ethernet.Type)

    switch (Child)
    {
        case 0x800:
            Pkt->ChildProt = PROT_PKTIP;
            break;
        case 0x806:
            Pkt->ChildProt = PROT_PKTARP;
            break;
        case 0x8035:
            Pkt->ChildProt = PROT_PKTRARP;
            break;
        case 0x6003:
            Pkt->ChildProt = PROT_PKTDEC;
            break;
        default:
            Pkt->ChildProt = PROT_PKTUNKNOWN;
    }
    return (TRUE);
}

BOOLEAN ProtEthernetField (PROT_PKT *Pkt, PROT_OBJ *Obj)
{
    if (Obj->Level == 0 && Obj->Id[1] == PROT_TYPE)
    {
        Obj->Type = SNMP_GAUGE;
        Obj->Syntax.LngUns = (LWORD) Pkt->ChildProt;
        return (TRUE);
    }

    if (Obj->Id[0] == PROT_PKTETHERNET)
    {
        switch (Obj->Id[1])
        {
            case 1:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = 6;
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Ethernet.DstAdr, 6);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 2:
                Obj->Type = SNMP_OCTETSTR;
                Obj->SyntaxLen  = 6;
                memcpy (Obj->Syntax.BufChr, Pkt->Frame->Ethernet.SrcAdr, 6);
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 3:
                Obj->Type = SNMP_GAUGE;
                PROT_NETWORD (Obj->Syntax.LngUns,Pkt->Frame->Ethernet.Type)
                if (Obj->Syntax.LngUns < 0x600)
                    Obj->Syntax.LngUns = 0;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
            case 4:
                Obj->Type = SNMP_NULL;
                if (Pkt->DataLen <= 14)
                    Obj->SyntaxLen = 0;
                else
                    Obj->SyntaxLen = Pkt->DataLen - 14;
                Obj->Syntax.Ptr = Pkt->Frame->Ethernet.Data;
                memset(&Obj->Id[2], 0, SNMP_SIZE_OBJECTID - 4);
                return (TRUE);
             default:
                return (FALSE);
         }
    }
    if (Obj->Level > 0 && Pkt->ChildProt != PROT_PKTUNKNOWN)
    {
        if (Pkt->Child == NULL)
        {
            if ((Pkt->Child = DnpapMalloc (sizeof(PROT_PKT))) == NULL)
                return (FALSE);
            Pkt->Child->Ptr = Pkt->Frame->Ethernet.Data;
            Pkt->Child->Child = NULL;
            Pkt->Child->DataLen = Pkt->DataLen - 14;
            if ((ProtPtr[Pkt->ChildProt].Header(Pkt->Child)) == FALSE)
            {
                DnpapFree(Pkt->Child);
                return (FALSE);
            }
        }
        Obj->Level--;
        return (ProtPtr[Pkt->ChildProt].Field (Pkt->Child, Obj));
    }
    return (FALSE);
}

BOOLEAN ProtEthernetPrint (PROT_OBJ *Obj, BYTE **StrPtr)
{
    switch (Obj->Id[1])
    {
        case 1:                                 /* Dst Adr */
        case 2:                                 /* Src Adr */
            sprintf(protocolString, "%02x:%02x:%02x:%02x:%02x:%02x",
                Obj->Syntax.BufChr[0], Obj->Syntax.BufChr[1],
                Obj->Syntax.BufChr[2], Obj->Syntax.BufChr[3],
                Obj->Syntax.BufChr[4], Obj->Syntax.BufChr[5]);
            *StrPtr = protocolString;
            return (TRUE);
        case 3:                                 /* Type */
            sprintf(protocolString, "%04lx", Obj->Syntax.LngUns);
            *StrPtr = protocolString;
            return (TRUE);
         default:
            return (FALSE);
     }
}

