/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       vip.h
**     SYSTEM   NAME:       VIP
**     ORIGINAL AUTHOR(S):  Alfred Kayser
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       92/05/15
**
** DESCRIPTION: Include file for the vip library.
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION: $Revision$
** AUTHOR:   $Author$
** DATE:     $Date$
** LOG:      $Log$
*************************************************************************/
#ifndef _VIP_INCLUDED
#define _VIP_INCLUDED

#ifndef _VIP_LIBRARY
typedef struct _vipinfo  VIPINFO;
typedef struct _vipfont  VIPFONT;
typedef struct _vipkeys  VIPKEYS;
typedef struct _viptimer VIPTIMER;
typedef struct _vipimage VIPIMAGE;
#endif

#define VIP_WHITE       0
#define VIP_BLACK       1
#define VIP_GREY        2
#define VIP_DARKGREY    3
#define VIP_RED         4
#define VIP_BLUE        5
#define VIP_GREEN       6 
#define VIP_PINK        7
#define VIP_CYAN        8
#define VIP_YELLOW      9
#define VIP_DARKRED     10
#define VIP_DARKBLUE    11
#define VIP_DARKGREEN   12 
#define VIP_DARKPINK    13
#define VIP_DARKCYAN    14
#define VIP_BROWN       15

#define VIP_NONE  0
#define VIP_BOX   1
#define VIP_DEPTH 2
#define VIP_RISE  3
#define VIP_LOW   4

/* TEXT and MENU flags can be combined so they must be unique */
#define VIP_TEXTF       0x0003
#define VIP_LEFT        0x0000
#define VIP_CENTER      0x0001
#define VIP_RIGHT       0x0002
#define VIP_WORDWRAP    0x0003

#define VIP_MENUF       0x0030
#define VIP_MENUITEM    0x0000
#define VIP_MENUSUB     0x0010
#define VIP_MENUBAR     0x0020
#define VIP_MENUTITLE   0x0030

#define VIP_VMENU       0x0000    /* By default */
#define VIP_HMENU       0x0001
#define VIP_FIXMENU     0x0002
#define VIP_POPMENU     0x0004

/* Framing flags */
#define VIP_HSPLIT      0x0001
#define VIP_VSPLIT      0x0002
#define VIP_FIXTOP      0x0004
#define VIP_FIXLEFT     0x0008

/* Font Attributes */
#define VIP_ITALIC      0x0001
#define VIP_BOLD        0x0002

/* Tabular Text Attributes */
#define VIP_TABFORMAT   0xc000
#define VIP_TCENTER     0x8000
#define VIP_TRIGHT      0x4000
#define VIP_TLEFT       0x0000
                      
/* Table Flags */     
#define VIP_TABLINES    0x0001
/* All VIP Errors should be defined here! */
#define VIPERR_FRAME        VIP_ERROR+1
#define VIPERR_MEMORY       VIP_ERROR+2
#define VIPERR_TYPE         VIP_ERROR+3
#define VIPERR_MENU         VIP_ERROR+4
#define VIPERR_PARENT       VIP_ERROR+5
#define VIPERR_BORDER       VIP_ERROR+6
#define VIPERR_OPEN         VIP_ERROR+7
#define VIPERR_PRTSET       VIP_ERROR+8
#define VIPERR_PRTDEV       VIP_ERROR+9
#define VIPERR_PRTSTART     VIP_ERROR+10
#define VIPERR_PRTHPS       VIP_ERROR+11
#define VIPERR_PRTCONFIG    VIP_ERROR+12
#define VIPERR_NULL         VIP_ERROR+13
#define VIPERR_VIP          VIP_ERROR+14
#define VIPERR_INIT1        VIP_ERROR+15
#define VIPERR_INIT2        VIP_ERROR+16
#define VIPERR_INIT3        VIP_ERROR+17
#define VIPERR_HANDLER      VIP_ERROR+18
#define VIPERR_WIN          VIP_ERROR+19
#define VIPERR_FONTS        VIP_ERROR+20
#define VIPERR_TIMER        VIP_ERROR+21
#define VIPERR_IMAGE        VIP_ERROR+22
#define VIPERR_TABS         VIP_ERROR+23


#define VIP_KEYFLAGS     0xFF00
#define VIP_KEYPRESS     0x0000
#define VIP_KEYRELEASE   0x8000
#define VIP_KEYALT       0x4000
#define VIP_KEYSHIFT     0x2000
#define VIP_KEYCTRL      0x1000
#define VIP_KEYSPECIAL   0x0080
#define VIPKEY_CODE(k)   (k&~VIP_KEYFLAGS)
#define VIPKEY_FLAGS(k)  (k&VIP_KEYFLAGS)

#define VIPKEY_BUTTON1		(0x01|VIP_KEYSPECIAL)
#define VIPKEY_BUTTON2		(0x02|VIP_KEYSPECIAL)
#define VIPKEY_BUTTON3		(0x03|VIP_KEYSPECIAL)
#define VIPKEY_BREAK		(0x04|VIP_KEYSPECIAL)
#define VIPKEY_BACKSPACE	(0x05|VIP_KEYSPECIAL)
#define VIPKEY_TAB			(0x06|VIP_KEYSPECIAL)
#define VIPKEY_BACKTAB		(0x07|VIP_KEYSPECIAL)
#define VIPKEY_NEWLINE		(0x08|VIP_KEYSPECIAL)
#define VIPKEY_SHIFT		(0x09|VIP_KEYSPECIAL)
#define VIPKEY_CTRL 		(0x0A|VIP_KEYSPECIAL)
#define VIPKEY_ALT			(0x0B|VIP_KEYSPECIAL)
#define VIPKEY_ALTGRAF		(0x0C|VIP_KEYSPECIAL)
#define VIPKEY_PAUSE		(0x0D|VIP_KEYSPECIAL)
#define VIPKEY_CAPSLOCK		(0x0E|VIP_KEYSPECIAL)
#define VIPKEY_ESC			(0x0F|VIP_KEYSPECIAL)
#define VIPKEY_SPACE		(0x10|VIP_KEYSPECIAL)
#define VIPKEY_PAGEUP		(0x11|VIP_KEYSPECIAL)
#define VIPKEY_PAGEDOWN		(0x12|VIP_KEYSPECIAL)
#define VIPKEY_END			(0x13|VIP_KEYSPECIAL)
#define VIPKEY_HOME 		(0x14|VIP_KEYSPECIAL)
#define VIPKEY_LEFT 		(0x15|VIP_KEYSPECIAL)
#define VIPKEY_UP			(0x16|VIP_KEYSPECIAL)
#define VIPKEY_RIGHT		(0x17|VIP_KEYSPECIAL)
#define VIPKEY_DOWN 		(0x18|VIP_KEYSPECIAL)
#define VIPKEY_PRINTSCRN	(0x19|VIP_KEYSPECIAL)
#define VIPKEY_INSERT		(0x1A|VIP_KEYSPECIAL)
#define VIPKEY_DELETE		(0x1B|VIP_KEYSPECIAL)
#define VIPKEY_SCRLLOCK		(0x1C|VIP_KEYSPECIAL)
#define VIPKEY_NUMLOCK		(0x1D|VIP_KEYSPECIAL)
#define VIPKEY_ENTER		(0x1E|VIP_KEYSPECIAL)
#define VIPKEY_SYSRQ		(0x1F|VIP_KEYSPECIAL)
#define VIPKEY_F1			(0x20|VIP_KEYSPECIAL)
#define VIPKEY_F2			(0x21|VIP_KEYSPECIAL)
#define VIPKEY_F3			(0x22|VIP_KEYSPECIAL)
#define VIPKEY_F4			(0x23|VIP_KEYSPECIAL)
#define VIPKEY_F5			(0x24|VIP_KEYSPECIAL)
#define VIPKEY_F6			(0x25|VIP_KEYSPECIAL)
#define VIPKEY_F7			(0x26|VIP_KEYSPECIAL)
#define VIPKEY_F8			(0x27|VIP_KEYSPECIAL)
#define VIPKEY_F9			(0x28|VIP_KEYSPECIAL)
#define VIPKEY_F10			(0x29|VIP_KEYSPECIAL)
#define VIPKEY_F11			(0x2A|VIP_KEYSPECIAL)
#define VIPKEY_F12			(0x2B|VIP_KEYSPECIAL)
#define VIPKEY_F13			(0x2C|VIP_KEYSPECIAL)
#define VIPKEY_F14			(0x2D|VIP_KEYSPECIAL)
#define VIPKEY_F15			(0x2E|VIP_KEYSPECIAL)
#define VIPKEY_F16			(0x2F|VIP_KEYSPECIAL)
#define VIPKEY_F17			(0x30|VIP_KEYSPECIAL)
#define VIPKEY_F18			(0x31|VIP_KEYSPECIAL)
#define VIPKEY_F19			(0x32|VIP_KEYSPECIAL)
#define VIPKEY_F20			(0x33|VIP_KEYSPECIAL)
#define VIPKEY_F21			(0x34|VIP_KEYSPECIAL)
#define VIPKEY_F22			(0x35|VIP_KEYSPECIAL)
#define VIPKEY_F23			(0x36|VIP_KEYSPECIAL)
#define VIPKEY_F24			(0x37|VIP_KEYSPECIAL)


#ifndef _VIP_LIBRARY
typedef BOOLEAN (*VIP_CALLKEYS)   (VIPINFO  *wip, VOID *p, int value);
typedef void (*VIP_CALLBACK)   (VIPINFO  *wip, VOID *p, int value);
typedef void (*VIP_BUTTCALL)   (VIPINFO  *wip, VOID *p, BOOLEAN pressed);
typedef void (*VIP_TIMEOUT)    (VIPTIMER *wip, VOID *p);
#endif

/*---------------------------------------------------------------------*/

BOOLEAN     VipInit              (int argc,char **argv);
void        VipInitExceptions    (void);
BOOLEAN     VipCheck             (BOOLEAN block);
void        VipMessageBox        (CONST char *title, CONST char *msg);
void        VipClose             (VIPINFO *win);
void        VipBell              (void);
void        VipShow              (VIPINFO *win);
void        VipHide              (VIPINFO *win);
void        VipDestroy           (VIPINFO *win);
void        VipUpdate            (VIPINFO *win, BOOLEAN all);
void        VipIconize           (VIPINFO *win, BOOLEAN flag);
void        VipMessage           (VIPINFO *win, CONST char *title, CONST char *msg);

int         VipQueryFontFaces    (char **faces, int bufsize);
int         VipQueryFontSizes    (CONST char *face, int *buf, int bufsize);
BOOLEAN     VipSelectFont        (VIPINFO *win, CONST char *font, int size, int attr);
VIPFONT *   VipCreateFont        (CONST char *face, int size, int attr);
void        VipSetFont           (VIPINFO *win, VIPFONT *fp);
int         VipQueryFontHeight   (VIPFONT *wip);
void        VipDestroyFont       (VIPFONT *wip);

VIPINFO *   VipOpenSimple        (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenFrame         (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenDial          (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenMeter         (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenButton        (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenText          (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenList          (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenLabel         (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenGraph         (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenMenu          (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenVScroll       (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenHScroll       (VIPINFO *parent,int x,int y,int w,int h);
VIPINFO *   VipOpenInput         (VIPINFO *parent,int x,int y,int w,int h);

void        VipSetBusy           (BOOLEAN on);
void        VipSetTitle          (VIPINFO *win, CONST char *title);
void        VipSetSystemMenu     (VIPINFO *win, BOOLEAN flag);
void        VipSetBackground     (VIPINFO *win, int color);
void        VipSetForeground     (VIPINFO *win, int color);
void        VipSetBorder         (VIPINFO *win, int width, int type);

void        VipSetDialRange      (VIPINFO *win, LONG min, LONG max, int stripes);
void        VipSetDialCurrent    (VIPINFO *win, LONG current);

void        VipSetMeterRange     (VIPINFO *win, LONG min, LONG max, int stripes);
void        VipSetMeterCurrent   (VIPINFO *win, LONG current);

void        VipSetButtonFlag     (VIPINFO *wip, BOOLEAN *flagptr);
void        VipSetButtonCallBack (VIPINFO *wip, VIP_BUTTCALL cb, void *ptr);
void        VipSetButtonKey      (VIPINFO *wip, int key);

BOOLEAN     VipSetTextLine       (VIPINFO *win, CONST char *text, int len, int flags);
#define VipSetTextScroll VipScrollText
void        VipScrollText        (VIPINFO *win, int dir);
void        VipSetTextScrollbars (VIPINFO *win, VIPINFO *vert, VIPINFO *horz);
void        VipSetTextTabs       (VIPINFO *wip, int tabCount, int *tabPos, int flags);
void        VipClearText         (VIPINFO *wip);

void        VipSetListCallBack   (VIPINFO *wip, VIP_CALLBACK mb, VOID *ptr);

void        VipSetGraphValue     (VIPINFO *wip, int set, int pos, LONG value);
BOOLEAN     VipSetGraphDataSet   (VIPINFO *wip, int set, int xsize, LONG ymin,
                                                LONG ymax, CONST char *title, int color);
void        VipSetGraphLast      (VIPINFO *wip, int set, LONG value);
void        VipSetGraphOffset    (VIPINFO *wip, int set, int pos);
void        VipSetGraphStripes   (VIPINFO *wip, int x, int y);

void        VipSetMenuEntry      (VIPINFO *wip, CONST char *text, int num, int type, VOID *p);
void        VipSetMenuCallBack   (VIPINFO *wip, VIP_CALLBACK mb);
void        VipSetMenuType       (VIPINFO *wip, int flags);

void        VipSetFrameSplit     (VIPINFO *parent, VIPINFO *fix, int flags);

void        VipSetScrollRange    (VIPINFO *wip, LONG min, LONG max);
void        VipSetScrollCurrent  (VIPINFO *wip, LONG current);
void        VipSetScrollSize     (VIPINFO *wip, LONG size);
void        VipSetScrollCallBack (VIPINFO *wip, VIP_CALLBACK cb, VOID *ptr);

void        VipSetAbout          (VIPINFO *, VIP_CALLBACK);

BOOLEAN     VipPrinterQuery      (VIPINFO *wip);
BOOLEAN     VipPrinterSetup      (void);
BOOLEAN     VipPrintWindow       (VIPINFO *wip, BOOLEAN all);

void        VipSetGlobalKeys     (VIPINFO *win, VIPKEYS *keySet);
void        VipSetLooseKeys      (VIPINFO *win, VIPKEYS *keySet);
void        VipSetKeyHandler     (VIPINFO *win, VIP_CALLKEYS keyCall, VOID *p);

void        VipSetInputBuffer    (VIPINFO *win, char *buf, int len);
VIPKEYS  *  VipKeysCreate        (void);
void        VipKeysReset         (VIPKEYS *ks);
VIPKEYS  *  VipKeysCopy          (VIPKEYS *k2);
void        VipKeysUnion         (VIPKEYS *k1, VIPKEYS *k2);
void        VipKeysAdd           (VIPKEYS *ks, int keyCode);
BOOLEAN     VipKeysInset         (VIPKEYS *ks, int keyCode);
void        VipKeysRemove        (VIPKEYS *ks, int keyCode);
void        VipKeysDestroy       (VIPKEYS *ks);

ULONG       VipGetMiSecs         (void);
VIPTIMER *  VipCreateTimer       (ULONG msecs, VIP_TIMEOUT fun, VOID *p);
BOOLEAN     VipDestroyTimer      (VIPTIMER *tp);

VIPIMAGE *  VipCreateImage       (int depth, int xSize, int ySize, BYTE *data);
BOOLEAN     VipDestroyImage      (VIPIMAGE *tp);

#define FONTFACE_SYSTEM    "System"
#define FONTFACE_COUR      "Courier"
#define FONTFACE_HELV      "Helv"
#define FONTFACE_TIMES     "Tms Rmn"
#define FONTFACE_SYMBOL    "Symbol"
                               
#ifdef MESSAGE_H
#define MSGVIP &messageVipDev
IMPORT TRANSDEVICE messageVipDev;
#endif

VIPKEYS *vipAsciiSet;
VIPKEYS *vipAllSet;

#endif /*_VIP_INCLUDED*/

